; sufiled/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/10/83 - kjw
;
	PAGE
;
;	$COMFILE - compare files entry point
;
COMFILE	RST	@08		;display header
;
	DEFB	LF
	DEFM	'Source:'
	DEFB	LF
	DEFB	ETX
;
	CALL	ASKFILE		;fetch file
	LD	A,(DRIV)	;get drive #
	LD	(SDRIVE),A	;save as source
	PUSH	IX		;pass dir pointer to HL
	POP	HL		;HL => dir record
	LD	DE,FILBUFF	;start of files
	OR	A		;clear carry
	SBC	HL,DE		;HL = offset into dir
	LD	DE,FBUFF+100H	;source storage
	ADD	HL,DE		;add offset to start
	LD	(IXSAVX),HL	;save source dir pointer
;
;	move directory to storage area
;
	LD	HL,FILBUFF	;start of directory
	LD	DE,FBUFF+100H	;where it goes
	LD	BC,1000H	;16 sectors max
	LDIR			;move it up
	CALL	INTCNT		;clear counter
	CALL	INTACNT		;clear alt counter
;
COMFILX	RST	@08		;display header
;
	DEFB	LF
	DEFM	'Compare:'
	DEFB	LF
	DEFB	ETX
;
	CALL	ASKFILE		;get file
	LD	A,(DRIV)	;get drive #
	LD	(DDRIVE),A	;save as dest drive
;
	LD	HL,0		;init relative record
	LD	(TEMP9),HL	;save for positioning
	LD	(IXSAVY),IX	;save dir pointer
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	IX,(IXSAVX)	;get source pointer
	LD	HL,(CURSOR)	;get cursor
	CALL	SHOWIT		;display filename
	RST	@08		;display separator
;
	DEFM	'  <<==>>  '
	DEFB	ETX
;
	LD	IX,(IXSAVY)	;get dest pointer
	LD	HL,(CURSOR)	;get cursor
	CALL	SHOWIT		;display dest filename
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
COMFLP	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;fetch DCT
	CALL	DRVSAME		;source & dest same?
	CALL	Z,MNTSRC	;yes, mount source drive
	LD	HL,(TEMP9)	;get relative sector
	LD	(TEMP1),HL	;save for dest test
	LD	HL,0		;init current counter
	LD	(TEMP4),HL	;# sectors total
	LD	BC,DATBUFF	;actual data buffer
;
COMIFLP	LD	IX,(IXSAVX)	;get source pointer
	PUSH	BC		;save buffer
	LD	DE,FBUFF+100H	;start of stored dir
	CALL	POSIT		;position the file
	POP	BC		;re-fetch buffer
	JR	C,COMOFLP	;go if out of range
	RST	@28		;read the sector
	LD	HL,(TEMP4)	;get sector count
	INC	HL		;+1
	LD	(TEMP4),HL	;re-save sub-total
	LD	HL,(TEMP9)	;get current rel sector
	INC	HL		;+1
	LD	(TEMP9),HL	;re-save it
	CALL	BUFFEND		;at buffer end?
	JR	NZ,COMIFLP	;nope, continue
;
COMOFLP	LD	HL,(TEMP4)	;get # sectors
	LD	A,H		;anything?
	OR	L		;HL = 0?
	JP	Z,CMOXWE	;go if yes!
;
	LD	A,(DDRIVE)	;get dest drive
	CALL	SETDRV		;setup for I/O
	CALL	DRVSAME		;source & dest same?
	CALL	Z,MNTDES	;yes, mount dest disk
	LD	HL,(TEMP1)	;get start record #
	LD	(TEMP9),HL	;save for positioning
	LD	BC,DATBUFF	;data buffer
;
COMFLP1	LD	IX,0		;get dest file pointer
IXSAVY	EQU	$-2
	PUSH	BC		;save buffer
	LD	DE,FILBUFF	;start of dir
	CALL	POSIT		;position the file
	POP	BC		;BC = buffer
	JP	C,CMFNEXT	;out of range
	PUSH	BC		;save relative buffer
	LD	BC,GATBUFF	;use GAT buff to verify
	RST	@28		;read the sector
	POP	BC		;restore rel buff ptr
	LD	D,B		;pass to DE for test
	LD	E,C		;DE => rel buffer
	LD	HL,GATBUFF	;new sector is here
;
	PUSH	BC		;save buffer
	LD	B,0		;length of sector
	CALL	COMPARE		;same?
	POP	BC		;restore rel buffer
;
	JR	Z,COMFOK	;yes, compare OK
;
	PUSH	BC		;save buffer
	LD	A,L		;get offset of mismatch
	RST	@20		;convert to hex ascii
	LD	(MGGIJJ),BC	;save into text
	LD	HL,(TEMP9)	;get relative sector
;
	PUSH	IY		;save DCT
	LD	IY,MGGIH	;point to text string
	CALL	BINASC		;convert to decimal ascii
	POP	IY		;restore DCT
	POP	BC		;restore rel buffer
;
	RST	@08		;display text
;
	DEFB	EOL
	DEFM	'Mismatch, Relative Sector '
MGGIH	DEFM	'xxxxx, Byte '
MGGIJJ	DEFM	'xxH'
	DEFB	LF
	DEFB	ETX
;
	CALL	ADDACNT		;bump mismatch counter
;
COMFOK	CALL	PAUSE		;check for pause key
	INC	B		;bump rel buffer pointer
	LD	HL,(TEMP9)	;get rel sector
	INC	HL		;+1
	LD	(TEMP9),HL	;re-save sub-total
	LD	HL,(TEMP4)	;get # sectors to read
	DEC	HL		;-1
	LD	(TEMP4),HL	;re-save sub-total
	LD	A,H		;any more to read?
	OR	L		;any bits on?
	JR	Z,CKCOMFD	;nope, go next buffer
;
	CALL	BUFFEND		;end of memory?
	JP	NZ,COMFLP1	;nope, continue
;
CKCOMFD	LD	IX,(IXSAVX)	;get source pointer
	LD	DE,FBUFF+100H	;start of dir
	CALL	POSIT		;position the file
	JP	NC,COMFLP	;go if more to do
;
;	files compared, display result
;
CMOXWE	CALL	SHOCNT		;display error counter
	RST	@08		;display message
;
	DEFM	'Disk Errors'
	DEFB	ETX
;
	CALL	SHOACNT		;dislay alt counter
	RST	@08		;display message
;
	DEFM	'Sector Mismatches'
	DEFB	ETX
;
	JP	GOBACK		;return to sub-menu
;
;	dest file is smaller than source file!
;
CMFNEXT	RST	@08		;display message
;
	DEFB	LF
	DEFM	'EOF Dest file reached'
	DEFB	ETX
;
	JP	CMOXWE		;continue
;
	PAGE
;
;	$CHUNK - allocate disk space to file
;
;	ENT	HL = # grans needed
;
;	EXT	C = # grans fetched
;		Carry = insufficient
;		D  = starting track of chunk
;		E  = bit mask for starting gran
;
CHUNK	LD	IX,GATBUFF	;point to GAT table
	LD	C,0		;current track
	BIT	5,(IY+6)	;track 0 available?
	JR	Z,CHUNKA	;yes, go!
	INC	IX		;bump GAT pointer
	INC	C		;bump track
;
CHUNKA	LD	D,(IX)		;get track byte
	LD	A,(IY+11)	;grans / track
	LD	E,0		;start gran offset
	BIT	0,(IY+5)	;2 sides?
	JR	Z,CHUNKAA	;go if not
	ADD	A,A		;double # grans/track
CHUNKAA	LD	B,A		;pass # grans / track
	LD	(CHUNKX),A	;save it
;
CHUNKB	RR	D		;check a bit
	JR	NC,CHUNKC	;have free spot
	INC	E		;bump offset
	DJNZ	CHUNKB		;go if more bits
;
	INC	C		;bump it
	LD	A,C		;get new track
	INC	IX		;bump table
	CP	(IY+1)		;at highest track?
	JR	C,CHUNKA	;go if not
	SCF			;set error
	RET			;return with carry error
;
CHUNKC	LD	A,E		;get gran offset
	PUSH	AF		;save offset
	RRCA			;align to high bits
	RRCA
	RRCA			;3 bits moved
	AND	0E0H		;A = gran offset
	LD	E,A		;E = gran offset
	LD	D,C		;starting track
	LD	B,'$'		;fetch # grans/track
CHUNKX	EQU	$-1
	LD	C,0		;init # grans fetched
	POP	AF		;restore first gran
;
;	locate first free bit
;
	OR	A		;first gran?
	JR	Z,CHUNK0	;yes, go!
	DEC	A		;gran 1
	JR	Z,CHUNK1
	DEC	A		;bit 2
	JR	Z,CHUNK2
	DEC	A		;bit 3
	JR	Z,CHUNK3
	DEC	A		;bit 4
	JR	Z,CHUNK4
	JR	CHUNK5		;else go!
;
CHUNK0	OR	A		;clear carry flag
	BIT	0,(IX)		;first gran free?
	RET	NZ		;nope, return NC
	SET	0,(IX)		;allocate gran
	CALL	CNUFF		;enough?
;
CHUNK1	BIT	1,(IX)		;gran 1 free?
	RET	NZ		;nope, return NC
	SET	1,(IX)		;allocate it
	CALL	CNUFF		;enough?
	LD	A,B		;get # grans/trk
	CP	2		;only 2?
	JR	Z,CHUNK6	;yes, go!
	OR	A		;clear carry
;
CHUNK2	BIT	2,(IX)		;gran #2 free?
	RET	NZ		;nope, return
	SET	2,(IX)		;allocate it
	CALL	CNUFF		;enough?
	LD	A,B		;# grans/trk
	CP	3		;only 3?
	JR	Z,CHUNK6	;yes, go!
	OR	A		;clear carry
;
CHUNK3	BIT	3,(IX)		;bit 3 free
	RET	NZ		;nope, return
	SET	3,(IX)		;allocate it
	CALL	CNUFF		;enough?
;
	LD	A,B		;# grans/track
	CP	4		;only 4?
	JR	Z,CHUNK6	;yes, go!
	OR	A		;clear carry
;
CHUNK4	BIT	4,(IX)		;4 free?
	RET	NZ		;return if not
	SET	4,(IX)		;allocate it
	CALL	CNUFF		;enough space?
;
CHUNK5	BIT	5,(IX)		;5 free?
	RET	NZ		;nope, go!
	SET	5,(IX)		;allocate it
	CALL	CNUFF		;enough space?
;
CHUNK6	PUSH	HL		;save count
	INC	IX		;bump IX
	PUSH	IX		;pass IX to HL
	POP	HL		;L = track number
	LD	A,L		;fetch it
	POP	HL		;restore
	CP	(IY+1)		;end of disk?
	JR	C,CHUNK0	;nope, get more grans
	SCF			;else carry = bad
	RET			;return
;
;	check if enough grans allocated
;
CNUFF	INC	C		;bump gran counter
	PUSH	HL		;save needed
	LD	A,B		;get # grans/track
	OR	A		;clear carry
	LD	B,0		;set MSB to zero
	SBC	HL,BC		;compare
	POP	HL		;restore needed
	LD	B,A		;reset
	JR	Z,CHAVE		;yes, have enough
	LD	A,C		;get LSB counter
	CP	1FH		;max / extent?
	JR	Z,CHAVE		;yes, have enough
	OR	A		;clear carry flag
	RET			;get more grans
;
CHAVE	POP	AF		;unstack call address
	OR	A		;clear carry flag
	RET			;done!
;
;	file is being overwritten, display it
;
OVERWRT	RST	@08		;display message
;
	DEFM	'  *****'
	DEFB	ETX
;
	LD	HL,FILBUFF	;start of records
	LD	(KILLW),HL	;save for $KILL
	CALL	KILLIT		;kill the file
;
	JP	MAKEGAT		;release the space
;
;	locate a free directory entry
;
FNDSPOT	LD	DE,0		;get # dir entries
DIRY	EQU	$-2
	LD	HL,FILBUFF	;start of records
;
FINDS0	BIT	4,(HL)		;available slot?
	RET	Z		;yes, HL=> free record
	CALL	HLDIR		;move HL => next entry
	DEC	E		;less this file
	JR	NZ,FINDS0	;go if more to check
	JP	OUTSPAF		;out of file space!
;
	PAGE
;
;	$EXECOPY - perform actual copy of file
;
EXECOPY	LD	BC,0		;init relative sector
	LD	(TEMP9),BC	;save for positioning
	LD	(IXSAVX),IX	;save pointer
;
EXECPY0	LD	BC,(TEMP9)	;get current sector
	LD	(TEMP3),BC	;save for write
	CALL	SSETUP		;setup for source I/O
	LD	IX,(IXSAVX)	;get pointer
	LD	BC,DATBUFF	;data buffer
;
EXECPY1	LD	DE,FBUFF+100H	;start of records
	PUSH	BC		;save buffer
	CALL	POSIT		;position to record
	POP	BC		;restore buffer
	JR	C,EXECPY2	;go if end of file
	RST	@28		;read the sector
	LD	HL,(TEMP9)	;get current rel sector
	INC	HL		;+1
	LD	(TEMP9),HL	;re-save sub-total
	CALL	BUFFEND		;end of memory?
	JR	NZ,EXECPY1	;go if more room
;
EXECPY2	LD	HL,(TEMP9)	;get current rel sector
	LD	(TEMP4),HL	;save for next pass
	LD	HL,(TEMP3)	;get start this pass
	LD	(TEMP9),HL	;save for positioning
	LD	IX,(TEMP7)	;get dest pointer
	LD	BC,DATBUFF	;start of data buffer
	CALL	DSETUP		;setup for DEST I/O
;
EXECPY3	PUSH	BC		;save buffer
	LD	DE,FILBUFF	;start of records
	CALL	POSIT		;position file
	POP	BC		;unstack buffer
;
	RET	C		;go if out of range
	CALL	COMPDAT		;compute data DAM
	LD	(WRTYPE),A	;save for sector write
	RST	@30		;write the sector
;
	LD	HL,(TEMP9)	;get current rel sector
	INC	HL		;+1
	LD	(TEMP9),HL	;update sub-total
	CALL	BUFFEND		;end of memory?
	JR	NZ,EXECPY3	;nope, continue
;
	LD	HL,(TEMP4)	;get start rel sector
	LD	(TEMP9),HL	;save for source
	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;setup
	LD	DE,FBUFF+100H	;fil buffer
	LD	IX,(IXSAVX)	;get source pointer
	CALL	POSIT		;position file
	RET	C		;done!
	JP	EXECPY0		;else copy more
;
