; sudvrs/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/09/83 - kjw/dwh
; revised 03/14/83 - kjw
;
	PAGE
;
;	$DISPLAY - RST @08 - display string to video
;
;	ENT	(SP) => data area (immed after CALL)
;		data terminates with a 00H
;
;	EXT	return to byte immed after 00H term.
;		if DUAL is on, bytes spooled to printer
;
;	ALL registers and FLAGS are preserved
;
DISPLY	EX	(SP),HL		;get data address
	PUSH	DE		;save this
	PUSH	AF		;save accum too.
	EX	DE,HL		;de => data
	LD	HL,(CURSOR)	;get cursor addr.
	CALL	OFFVID		;make sure it's in video
;
DISLP	LD	A,(DE)		;get a byte
	INC	DE		;bump the pointer
	CP	ETX		;end of text?
	JR	Z,DISDN		;go if yes!
;
	CALL	CKDUL		;see if dual is on
	CP	SPACE		;control code?
	JR	C,DISCTL	;do it if <20H
;
;	automatic lower case recognition
;
	LD	(HL),A		;display the byte
	CP	(HL)		;still there?
	JR	Z,DISOK		;yes, lowercase in
	SUB	20H		;make it uppercase
	LD	(HL),A		;put it back
;
DISOK	INC	HL		;bump the cursor
	CALL	OFFVID		;see if still on video
	JR	DISLP		;continue
;
;	completed, resume at next byte after terminator
;
DISDN	LD	(CURSOR),HL	;put cursor back
	EX	DE,HL		;hl => return address
	POP	AF		;restore af
	POP	DE		;restore de
	EX	(SP),HL		;get hl back, leave ret.
	RET			;go to it
;
;	setup call to control byte
;
DISCTL	CALL	CONTRL		;make it a call
	JR	DISLP		;continue
;
;	interpret control byte
;
CONTRL	CP	BACKSP		;backspace
	JR	Z,BKSPA
;
	CP	TAB		;center screen?
	JP	Z,CENTR
;
	CP	LF		;linefeed?
	JR	Z,LINFEED
;
	CP	CR		;carriage return?
	JR	Z,LINFEED	;same thing
;
	CP	UFEED		;up linefeed?
	JP	Z,UPFEED
;
	CP	BOL		;BOL?
	JR	Z,BOLX
;
	CP	EOL		;EOL?
	JR	Z,EOLX
;
	CP	CLSF		;clear with framing?
	JP	Z,CLS0
;
	CP	CLSA		;clear entire screen?
	JP	Z,CLS1
;
	CP	CLSB		;clear framed only?
	JP	Z,CLS2
;
	RET			;invalid, ignore it
;
;	backspace cursor
;
BKSPA	DEC	HL		;go back one space
	LD	(HL),SPACE	;load space
	JR	OFFVID		;make sure it's on video
;
;	move cursor down one row and C/R
;
LINFEED	PUSH	DE		;save it
	LD	DE,COLS		;chars / line
	CALL	BOLX		;get begin of line
	ADD	HL,DE		;go to next line
	POP	DE		;restore it
	JR	OFFVID		;frame it
;
;	move cursor to beginning of line
;
BOLX	LD	A,L		;get lsb byte
	AND	0C0H		;put to beginning of line
	ADD	A,2		;move in two spots
	LD	L,A		;put that back
	RET			;no frame needed
;
;	move cursor to beginning of line and clear it
;
EOLX	CALL	BOLX		;go beginning of line
	PUSH	BC		;save these
	LD	BC,COLS-4	;line length -4
;
;	fill video data area
;
FIXCON	PUSH	HL		;save the rest
	PUSH	DE
	LD	D,H		;give to DE
	LD	E,L
	INC	DE		;start +1
	LD	(HL),SPACE	;clear byte
;
;	turn off 'alive' to assure a blank screen
;
	LD	A,(FLAGA)	;fetch system flag
	PUSH	AF		;save on stack
	SET	1,A		;turn it OFF
	LD	(FLAGA),A	;put it back
	LDIR			;put spaces all over
	POP	AF		;restore flag
	LD	(FLAGA),A	;put back original
;
	POP	DE		;unstack
	POP	HL
	POP	BC		;get 'em all back
;
;	check for cursor in valid video memory area
;
OFFVID	LD	A,H		;check for boundrys
	CP	VIDEO<-8+1	;less than video?
	JR	NC,OFFAOK	;test one ok
	LD	HL,VIDEO+102H	;top of vid
	RET			;resume
;
OFFAOK	CP	VIDEND<-8	;more than top?
	JR	NC,AKSCRL	;scroll
	CP	VIDEND<-8-1	;last quad?
	RET	C		;less, in range
	LD	A,L		;get LSB
	CP	0C0H		;last row?
	RET	C		;skip if not
;
AKSCRL	PUSH	DE		;save
	PUSH	BC		;this too
	LD	DE,VIDEO+102H	;start
	LD	HL,VIDEO+142H	;start 2nd row
	LD	B,10		;scroll 10 rows video
;
SCROL	PUSH	HL		;save start
	PUSH	DE
	PUSH	BC
	LD	B,60		;60 bytes / row
;
SCRIL	LD	A,(HL)		;fetch a byte
	LD	(DE),A		;scroll it up a row
	INC	HL		;bump pointers
	INC	DE
	DJNZ	SCRIL		;finish this row
	POP	BC		;unstack
	POP	DE
	LD	HL,COLS		;next row
	ADD	HL,DE		;HL = new DE
	EX	(SP),HL		;DE => stack, HL back
	LD	DE,COLS		;next row
	ADD	HL,DE		;HL = new HL
	POP	DE		;DE = new DE
	DJNZ	SCROL		;finish all rows
	POP	BC		;unstack
	POP	DE
	LD	HL,VIDEO+382H	;new cursor bottom row
	JR	EOLX		;clear this line
;
CLS1	LD	HL,VIDEO	;video start
	PUSH	DE		;save
	PUSH	BC
	LD	DE,VIDEO+1	;video start +1
	LD	BC,VIDEND-VIDEO-1 ;video length -1
	CALL	CLSMOVE		;'de' alive, and LDIR
	POP	BC		;unstack
	POP	DE
	LD	HL,VIDEO	;new cursor position
	RET			;done
;
CLS2	LD	HL,VIDEO+102H	;start bottom area
	PUSH	DE		;save
	PUSH	BC
	LD	B,11		;11 rows to clear
CLSOL	PUSH	HL		;save row start
	LD	D,H		;pass to DE
	LD	E,L		;HL = DE
	INC	DE		;start +1
	PUSH	BC		;save
	LD	BC,59		;60 -1 done
	CALL	CLSMOVE		;fill row
	POP	BC		;restore
	POP	HL		;start pointer
	LD	DE,COLS		;offset to next row
	ADD	HL,DE		;HL => next row
	DJNZ	CLSOL		;finish 11 rows
	POP	BC		;unstack
	POP	DE
	LD	HL,VIDEO+102H	;new cursor location
	RET			;done
;
CLS0	CALL	CLS1		;clear entire screen
	PUSH	DE		;save
	PUSH	BC		;too
	LD	HL,VIDEO+42H	;video location
	LD	DE,CLSTIT	;title message
	CALL	CLSON		;display message
	LD	HL,VIDEO+82H	;second row
	CALL	CLSON		;display remainder messg.
	LD	HL,VIDEO	;video start
	CALL	PER64		;put periods
	LD	HL,VIDEO+0C0H	;start 3rd row
	CALL	PER64		;periods
	LD	HL,VIDEO+3C0H	;bottom row video
	CALL	PER64		;periods on row
	LD	HL,VIDEO	;video start
	LD	DE,63		;offset to next row
	LD	BC,102EH	;B = # rows, C = char.
;
CLS02	LD	(HL),C		;turn on char
	ADD	HL,DE		;offset to row end
	LD	(HL),C		;char here too
	INC	HL		;start next row
	DJNZ	CLS02		;finish all rows
	POP	BC		;unstack
	POP	DE
	LD	HL,VIDEO+102H	;reset cursor
	LD	A,(FLAGA)	;get system flag
	RES	1,A		;turn 'alive' on
	LD	(FLAGA),A	;put it back
	RET			;done
;
;	position cursor to center of current line
;
CENTR	LD	A,L		;get lsb cursor
	AND	0C0H		;beginning of line
	OR	20H		;put in the middle
	LD	L,A		;that goes back
	RET			;must be in video
;
;	move cursor up one line without C/R
;
UPFEED	PUSH	DE		;save from add
	LD	DE,-40H		;1 line up
	ADD	HL,DE		;move hl up
	POP	DE		;restore DE
	JP	OFFVID		;check if it's on video
;
	PAGE
;
;	$GETSTR - RST 10 - fetch string from keyboard
;
;	ENT	B = number of characters to fetch
;
;	EXT	Z = no characters input (ENTER alone)
;		NZ = characters present
;		HL => start of input string
;		C  = requested number of characters
;		B  = actual number of characters input
;		A  = first character from buffer
;
;	DE preserved
;
GETSTR	LD	C,B		;fetch requested length
	PUSH	DE		;save from use
	LD	HL,(CURSOR)	;get cursor posit
	PUSH	HL		;save a second
	INC	B		;length + 1
;
;	display prompt line for key input
;
PUTPER	LD	(HL),PROMPT	;put a character
	INC	HL		;bump pointer
	DJNZ	PUTPER		;prompt displayed
	POP	HL		;restored
	LD	DE,STRING	;input buffer
;
;	loopers for keyboard input
;
CURCUR	LD	A,CURCHRO	;OFF char
	JR	CUROFF		;display it
;
CURON	LD	A,CURCHR	;cursor ON char
CUROFF	LD	(HL),A		;display it
;
;	setup count for cursor flash
;
	LD	A,16		;1/2 second flash
	LD	(FLCOUNT),A	;save the count
;
;	loop here waiting for a key
;
SCAN	LD	A,16		;get counter
FLCOUNT	EQU	$-1
	DEC	A		;less one
	LD	(FLCOUNT),A	;resave it
	JR	NZ,SCAN2	;continue if not time
;
;	time to change the cursor char
;
	LD	A,(HL)		;get cursor char.
	CP	CURCHRO		;off?
	JR	NZ,CURCUR	;on, turn it off
	JR	CURON		;off, turn it on
;
;	check the keyboard
;
SCAN2	CALL	INKEY		;scan keyboard
	JR	Z,SCAN		;loop till have key
;
	CP	ENTER		;enter key?
	JR	Z,SCDON
;
	CP	SENTER		;sh enter?
	JR	Z,SCDON
;
	CP	LARR		;backspace?
	JR	Z,BAKSPCE
;
	CP	SLARR		;shift back?
	JR	Z,NEWST
;
	CP	CLEAR		;clear?
	JR	Z,NEWST
;
	CP	SPACE		;valid code?
	JR	NC,SCANXY	;in range, go!
SCANBD	LD	A,BLOCK		;invalid char
	JR	CUROFF		;display block
;
;	have a key
;
SCANXY	LD	(ASVE),A	;save the key
	LD	A,B		;get length
	CP	C		;test for max
	JR	NC,SCANBD	;don't take it, buff full
	LD	A,0
ASVE	EQU	$-1		;get key back
;
;	check for printer output
;
	CALL	CKDUL		;see if dual on
	LD	(HL),A		;display the byte
	LD	(DE),A		;put in buffer
	CP	(HL)		;lower case ?
	JR	Z,CHAROK	;yes if Z
	SUB	20H		;make it uppercase
	LD	(HL),A		;put it back
;
CHAROK	INC	DE		;bump buffer
	INC	B		;bump length
	INC	HL		;bump video pointer
	LD	A,C		;get max length
	CP	1		;one char only?
	JR	NZ,SCANF	;show forward motion
	LD	A,(ALVFLAG)	;get alive flag
	BIT	1,A		;is 'INKEY' on?
	JR	Z,SCDON		;go if yes
;
SCANF	LD	A,'>'		;show forward motion
	JR	CUROFF		;continue
;
SCANB	LD	A,'<'		;show backward motion
	JR	CUROFF		;continue
;
;	completed, terminate with 13
;
SCDON	LD	A,CR		;C/R terminator
	CALL	CKDUL		;check for DUAL
	CALL	DLON		;re-activate if DISABLED
	LD	(DE),A		;put into buffer
;
;	clear any remaining prompt chars
;
	LD	A,C		;get original length
	SUB	B		;less actual input
	INC	A		;+ 1 for term byte
	PUSH	BC		;save it
	LD	B,A		;give to B for looper
	LD	A,SPACE		;char to turn off prompt
	LD	(HL),'.'	;show enter key
	INC	HL		;bump video pointer
	CALL	FILL		;clear it out
	POP	BC		;unstack
;
;	routine completed, reset stack & set flags
;
	POP	DE		;restore old DE
;
	LD	A,B		;set flags for length
	OR	A		;Z flag = B register
	LD	HL,STRING	;hl => input string
	LD	A,(HL)		;a has first char
	RET			;done
;
;	backspace a character
;
BAKSPCE	LD	A,B		;any length?
	OR	A		;yes?
	JR	Z,SCANBD	;don't do it then
;
	LD	(HL),PROMPT	;put to the video
	DEC	HL		;move it back
	DEC	DE		;move buffer back
	DEC	B		;char. count back
	JR	SCANB		;resume
;
;	clear entire input line and start over
;
NEWST	LD	A,B		;any length?
	OR	A		;yes?
	JR	Z,SCANBD	;don't bother
;
NEWSTL	LD	(HL),PROMPT	;to the display
	DEC	HL		;pointer back
	DEC	DE		;move buffer back
	DJNZ	NEWSTL		;go till length 0
	JR	SCANB		;cursor on, continue
;
	PAGE
;
;	$KEY	- scan keyboard for input character
;
;	ENT	none
;
;	EXT	Z = no key available
;		NZ = A = character
;
;	ALL other registers preserved
;
KEY	CALL	SAVEREG		;save all registers
;
;	check for any keys pressed right now
;
	LD	A,(KBDR7-1)	;any keys on?
	OR	A		;set flags
	JR	NZ,ADDRPT	;yes, go!
;
;	reset first key repeat counter
;
GONWKEY	LD	A,(FLAGA)	;fetch system flag
	BIT	6,A		;high speed on?
	LD	A,30		;normal speed value
	JR	Z,I80		;no, go!
	LD	A,60		;double speed value
I80	LD	(DLY1),A	;insert delay
;
;	reset between key delay counter
;
CONTRPT	LD	A,(FLAGA)	;fetch system flag
	BIT	6,A		;high speed on?
	LD	A,3		;normal repeat speed
	JR	Z,I85		;go if not on
	LD	A,4		;double time speed
I85	LD	(DLY2),A	;stash it
	JR	KIGO		;go single key
;
;	check for current key same as last key
;
ADDRPT	CP	0		;same as last key?
LSTKEY	EQU	$-1
	LD	(LSTKEY),A	;put into mask byte
	JR	NZ,GONWKEY	;go to new key if not
;
;	same as last, check for first repeat time
;
	LD	A,0		;get first key count
DLY1	EQU	$-1
	OR	A		;down to 0 yet?
	JR	Z,CKDLY2	;if yes, check delay2
	DEC	A		;reduce it on this pass
	LD	(DLY1),A	;put it back
	JR	KIGO		;continue, skip for now
;
;	key is repeating, check for between key delay
;
CKDLY2	LD	A,0		;get between key count
DLY2	EQU	$-1
	DEC	A		;less one
	LD	(DLY2),A	;back
	JR	NZ,KIGO		;go if not time
;
;	time to repeat the key, clear out the key mask
;
	LD	HL,KEYBRD	;keyboard mask area
	LD	DE,KEYBRD+1	;7 byte last key mask
	LD	BC,6		;length -1
	LD	(HL),0		;put in a zero
	LDIR			;put all zeroes
	JR	CONTRPT		;reset counter
;
;	mask area all set for repeat, scan key matrix
;
KIGO	LD	HL,KEYBRD	;work area
	LD	BC,KBDR0	;keyboard memory
	LD	D,0		;row counter
;
NEXROW	LD	A,(BC)		;get key byte
	LD	E,A		;save it here
;
;	compare to mask area to see if it's a new key
;
	XOR	(HL)		;compare to last scan
	LD	(HL),E		;save new key in mask
	AND	E		;same as last key?
	JR	NZ,HAVEIT	;have a new one
;
;	not a new key, continue to next matrix row
;
	INC	D		;bump row count
	INC	L		;bump mask byte
	RLC	C		;move key memory
	JP	P,NEXROW	;go for 7 rows
	RET			;done, Z flag set
;
;	have a new key, decode into ASCII
;
HAVEIT	LD	E,A		;save masked byte
	LD	A,D		;get row counter
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	D,A		;row * 8
	LD	C,1		;column mask bit
;
MKT1	LD	A,C		;fetch mask
	AND	E		;this the right key?
	JR	NZ,MKT2		;yup, go!
;
	INC	D		;bump row*8
	RLC	C		;shift mask bit left
	JR	MKT1		;continue
;
MKT2	LD	A,(FLAGA)	;get system flag
	LD	C,A		;save it here
	LD	A,(KBDR7)	;get shift key
	LD	B,-1		;set mask for shift
	OR	A		;any bits?
	JR	NZ,KI3		;continue if yes
	INC	B		;else clear B
;
KI3	LD	A,D		;get value back
	ADD	A,40H		;make it ascii
	CP	60H		;a-z?
	JR	NC,LXH3		;go if not
;
;	check for upper case lock switch
;
	RRC	C		;reverse lower case?
	JR	C,REVKEY	;works reverse if -1
	RRC	B		;shift key pressed?
	JR	NC,GOTKEY	;have the key
	ADD	A,20H		;make it lower
;
;	check to see if control code issued
;
CKCTL	LD	D,A		;save char
;
	IF	MODI.OR.MODIII
	LD	A,(KBDR6)	;get last row
	AND	10H		;down arrow?
	ENDIF
	IF	MAX80
	LD	A,(KBDR7)	;get last row
	AND	80H		;control key?
	ENDIF
	LD	A,D		;get char back
	JR	Z,GOTKEY	;continue if not
;
;	have a control code, adjust it
;
	CALL	UCASE		;make it upper case
	SUB	40H		;make it a control key
	JR	GOTKEY		;continue
;
;	check for case reverse with case lock switch
;
REVKEY	RRC	B		;shift key on?
	JR	C,CKCTL		;have the key
	ADD	A,20H		;make it lower
	JR	GOTKEY		;continue
;
;	check for keys that need special attention
;
LXH3	SUB	70H		;check for last row
	JR	NC,LXH5		;get byte from table
;
	ADD	A,40H		;adjust ascii back
	CP	3CH		;test for =*/
	JR	C,LXH4		;don't adjust
;
	XOR	10H		;works backwards
LXH4	RRC	B		;shift key?
	JR	NC,GOTKEY	;continue if not
	XOR	10H		;reverse back
	JR	GOTKEY		;continue
;
;	special last row key, fetch from table
;
LXH5	ADD	A,A		;double for table
	RRC	B		;check for shift
	JR	NC,LXH6		;go
	INC	A		;add one for shift entry
LXH6	LD	HL,KEYTABL	;look up key table
	LD	C,A
	LD	B,0		;bc=displacement
	ADD	HL,BC
	LD	A,(HL)		;get the byte
;
;	have a key, check for special commands
;
GOTKEY	CP	SCLEAR		;sh clear?
	JR	Z,SCRNPRT	;screen printer
;
;	check for shift 0 (case lock switch reverse)
;
	CP	20H		;check for sh 0
	RET	NZ		;not that
;
;	shift 0 same ascii as space, check which one
;
	LD	DE,(KBDR7)	;check shift key
	INC	E		;check for nil
	DEC	E		;no shift?
	RET	Z		;nope, return
;
;	toggle upper case lock switch
;
	LD	A,(FLAGA)	;get system flag
	XOR	1		;reverse bit 0
	LD	(FLAGA),A	;put it back
	XOR	A		;return no keys
	RET			;done
;
;	special output routine for DUAL
;
CKDUL	LD	(CKDSAV),A	;save the character
	LD	A,(FLAGA)	;get system flag
	AND	80H		;check bit 7
	LD	A,0		;get char back
CKDSAV	EQU	$-1
	RET	Z		;dual NOT ON
	JR	POUT		;else send to printer
;
;	$DLON	- enables DUAL if ON
;	$DLOFF	- disables DUAL
;
;	this routine is usually used by
;	repetitive messages to turn on/off DUAL
;	when reading sectors, the 'reading ...'
;	message is not displayed, etc.
;
DLON	PUSH	AF		;save the flags
	LD	A,(FLAGA)	;get system flag
	BIT	5,A		;dual on?
	RES	7,A		;turn off if no
	JR	Z,DLCMM		;nope, continue
	SET	7,A		;else turn it on
;
DLCMM	LD	(FLAGA),A	;update the flag
	POP	AF		;unstack
	RET			;done, go back
;
DLOFF	PUSH	AF		;save it
	LD	A,(FLAGA)	;get system flag
	RES	7,A		;disable it
	JR	DLCMM		;put it back
;
	PAGE
;
;	$SCRNPRT - send video to lineprinter
;
;	ENT	none
;
;	EXT	returns back to caller with A = ZERO
;
;	HL, DE, BC destroyed
;
SCRNPRT	LD	B,16		;16 lines on video
	LD	HL,VIDEO	;start of video
;
;	check for significant length of line to print
;
VIDE1	LD	C,64		;64 char/line
	PUSH	HL		;save begin of line
	LD	A,L		;get lsb
	ADD	A,3FH		;put at end of line
	LD	E,A		;give to de
	LD	D,H		;de = end of line
;
VIDE3	LD	A,(DE)		;get a byte from screen
	CP	SPACE		;space?
	JR	NZ,VIDIT	;end of that line, go!
;
	DEC	DE		;go back
	DEC	C		;reduce count
	JR	NZ,VIDE3	;look for more chars
;
;	no characters on the line, send a linefeed
;
	LD	A,LF		;send a linefeed
	CALL	POUT		;print it
	JR	VIDNEX		;continue
;
;	HL => start of the line, DE => end of the line
;
VIDIT	INC	DE		;bump for end byte
;
VIDIT1	LD	A,(HL)		;get a byte from video
	PUSH	AF		;save original on stack
;
;	put a graphic block at current video location
;
	LD	(HL),BLOCK	;put graphic on screen
;
;	check to see if char is control to printer
;
	CP	SPACE		;needs adjust?
	JR	NC,VID4		;nope, continue
	LD	A,'.'		;convert to this
;
VID4	CALL	POUT		;send the character
	POP	AF		;restore original
	LD	(HL),A		;put back on the video
;
	INC	HL		;bump position
	PUSH	HL		;test for end of line
	OR	A		;clear carry flag
	SBC	HL,DE		;at end yet?
	POP	HL		;restore it
	JR	NZ,VIDIT1	;nope, finish the line
;
;	one line completed, follow with a carriage return
;
	LD	A,CR		;send a carriage return
	CALL	POUT
;
;	line completed, go to next line
;
VIDNEX	POP	HL		;restore start last line
	LD	DE,64		;length of a video line
	ADD	HL,DE		;point to next row
	DJNZ	VIDE1		;continue for 16 lines
;
;	entire video completed, send another linefeed
;
	LD	A,LF		;linefeed
	CALL	POUT		;send it
;
;	completed, return with zero (no keys pressed)
;
VIDBK	XOR	A		;return with zero
	RET			;done
;
	PAGE
;
;	$POUT	- send character to printer device
;
;	ENT	A = character to print
;
;	EXT	character is added to print spool buffer
;
POUT	PUSH	HL		;save regs
	PUSH	DE
	PUSH	BC
	PUSH	AF		;save original char
;
	LD	B,A		;save character here
	LD	A,(KBDR0)	;check for @ key
	AND	1		;pressed?
	JR	Z,POUT0		;go if not
	LD	A,(KBDR7)	;check for SHIFT key
	OR	A		;any bits?
	CALL	NZ,SPOOLE	;clear buffer if yes
;
POUT0	LD	A,(FLAGB)	;get printer flag
	LD	C,A		;pass here for bit tests
	LD	A,B		;get original char
;
;	check for graphic code
;
	BIT	7,A		;graphic code
	JR	Z,POUT11	;go if not
	BIT	7,C		;graphic flag on?
	JR	NZ,POUT11	;yes, go!
	LD	A,'#'		;change to non-graphic
;
;	check for lower case
;
POUT11	BIT	6,C		;enabled?
	JR	NZ,POUT12	;yes, go
	CALL	UCASE		;else make it upper case
;
;	check for MX80 graphic adjust
;
POUT12	BIT	5,C		;MX80 enabled?
	JR	Z,POUT13	;no, continue
	BIT	7,A		;graphic char?
	JR	Z,POUT13	;no, skip adjust
;
	RES	6,A		;adjust for MX80
	ADD	A,20H		;done
;
;	done, add char to buffer
;
POUT13	PUSH	BC		;save sys flag
	CALL	ADDBUFF		;add to printer buffer
	POP	BC		;restore flag
;
;	check for linefeeds on CR
;
	CP	CR		;was it a linefeed?
	JR	NZ,POUT14	;no, unstack and return
;
	BIT	3,C		;linefeed switch?
	JR	Z,POUT14	;nope, go
;
;	add a linefeed after the carriage return
;
	LD	A,LF		;send linefeed
	CALL	ADDBUFF		;add to the buffer
;
;	completed, unstack and return
;
POUT14	POP	AF		;get char
	POP	BC		;restore counters
	POP	DE
	POP	HL
	RET			;done
;
;	add character to printer buffer
;
ADDBUFF	PUSH	AF		;save char
	LD	A,(FLAGA)	;get system flag
	PUSH	AF		;save it
	SET	4,A		;set task spooler OFF
	LD	(FLAGA),A	;reset it
	CALL	SPOOL0		;attempt to de-spool
	POP	AF		;get flag back
	RES	4,A		;make sure it's off
	LD	(FLAGA),A	;allow task spooler
	POP	AF		;get char back
;
	CALL	BUFFADD		;can add to buffer?
	JR	NC,ADDBUFF	;wait here if not
	LD	(PRADDO),DE	;save new offset
	RET			;done!
;
;	interrupt service SPOOL handler
;
SPOOL	LD	A,(FLAGA)	;get system flag
	BIT	4,A		;spooler OFF?
	RET	NZ		;yes, skip for now
;
;	attempt to send chars to printer device
;
SPOOL0	LD	C,20		;20 chars / interrupt
;
SPOOLA	CALL	BUFTAKE		;get a character
	RET	NC		;nil!
	LD	B,16		;time out delay
;
;	fetch printer status - time out if not ready
;
SPOOLB	EQU	$
;i/m*
	IF	MODI.OR.MAX80
	LD	A,(RDPRT)	;read printer
	ENDIF
;i/m*
;iii*
	IF	MODIII
	IN	A,(RDPRT)	;read printer
	ENDIF
;iii*
	AND	0F0H		;mask out low bits
	CP	30H		;ready for a char?
	JR	Z,SPOOLC	;go if ready
	DJNZ	SPOOLB		;time out delay
	RET
;
;	printer is ready, fetch a char
;
SPOOLC	LD	A,(HL)		;get char from buffer
;
;	send character to the printer
;i*
	IF	MODI.OR.MAX80
	LD	(WRPRT),A	;lineprinter I
	ENDIF
;i*
;iii*
	IF	MODIII
	OUT	(WRPRT),A	;lineprinter III
	ENDIF
;iii*
	LD	(PRTAKO),DE	;update offset
	DEC	C		;less this char
	JR	NZ,SPOOLA	;another immediately?
	RET
;
;	end spooling, reset pointers
;
SPOOLE	LD	HL,0		;set 0000h
	LD	(PRADDO),HL	;add offset to 0000
	LD	(PRTAKO),HL	;take offset to 0000
	RET			;done
;
;	attempt to add char to buffer
;
BUFFADD	LD	HL,(PRTAKO)	;get take offset
	LD	DE,(PRADDO)	;get add offset
	CALL	RINGBUF		;bump ring
	OR	A		;clear carry
	SBC	HL,DE		;compare
	RET	Z		;NC = no room!
;
	LD	HL,(PRBUFF)	;get printer buffer
	ADD	HL,DE		;HL => character
	LD	(HL),A		;load char to buffer
	SCF			;C = loaded
	RET			;done!
;
;	take character from spool buffer
;
BUFTAKE	LD	HL,(PRADDO)	;get adder offset
	LD	DE,(PRTAKO)	;get taker offset
	OR	A		;clear carry for SUB
	SBC	HL,DE		;compare pointers
	RET	Z		;NC = nil
;
	LD	HL,(PRBUFF)	;get buffer start
	CALL	RINGBUF		;bump ring pointer
	ADD	HL,DE		;HL => char
	SCF			;C = avail
	RET			;done
;
;	increment ring buffer pointer
;
RINGBUF	PUSH	HL		;save
	INC	DE		;bump for char
	LD	HL,(PRSIZE)	;get buffer size
	SCF			;set for adjust
	SBC	HL,DE		;check for ring end
	POP	HL		;restore
	RET	NC		;not at ring end
	LD	DE,0		;reset to beginning
	RET			;done
;
CLSTIT	DEFM	'**  Super-Utility +  **'
	DEFM	'  Version 3.1a  **  By: '
KIM	DEFM	'Kim Watt  **'
	DEFB	ETX
;
	DEFM	'      (c)(p) 1983 Breeze/QSD, Inc.'
	DEFM	'  --  Dallas, Texas'
	DEFB	ETX
;
CLSON	LD	A,(DE)		;get data byte
	INC	DE		;point to next
	CP	ETX		;check for terminator
	RET	Z		;yes, done
	LD	(HL),A		;else put on video
	CP	(HL)		;still there?
	JR	Z,CLSONOK	;yes, go!
	SUB	20H		;make it upper case
	LD	(HL),A		;put it on video
CLSONOK	INC	HL		;bump video
	JR	CLSON		;continue
;
CLSMOVE	LD	A,(FLAGA)	;get system flag
	PUSH	AF		;save it
	SET	1,A		;turn off alive
	LD	(FLAGA),A	;re-save it
	LD	(HL),SPACE	;load space
	LDIR			;load lots of spaces
	POP	AF		;restore flag
	LD	(FLAGA),A	;re-instate it
	RET			;done
;
;	display period horozontal borders
;	display every other byte for sync with
;	vertical spacing
;
PER64	LD	B,21		;length / 3
;
PER64A	LD	(HL),2EH	;load display
	INC	HL		;bump pointer
	LD	(HL),SPACE	;load space
	INC	HL		;bump pointer
	LD	(HL),SPACE	;load gap
	INC	HL		;bump pointer
	DJNZ	PER64A		;go for row length
	RET			;done
;
