; subuff/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/09/83 - kjw/dwh
; revised 03/16/83 - kjw
;
	PAGE
;
;	ID address mark buffer
;
INPUT	DEFS	6		;6 byte I/O buffer
BUFFPRT	DEFS	100		;100 byte printer spooler
PATCHES	EQU	$		;start patch area
DBUFF	EQU	$&0FF00H	;last even page
;
;	when SU+ reads in a sector, it returns with
;	the sector write byte needed to reproduce the
;	same data address mark (DAM) in the A' register
;	On multiple sector routines, this stream of
;	bytes is stored in the following buffer so that
;	the sectors may be written back with the
;	same mark as the original
;
PATCHEN	EQU	DBUFF+1FFH	;end patch area
DAMBUFF	EQU	DBUFF+200H	;start I/O buffer
PGMEND	EQU	DAMBUFF
;
;	when a directory is read into memory, SU+
;	will always read it in at the following buffer
;	the first sector of a directory is the GAT
;	table hence the label name
;	this is also used as the beginning of the
;	true available buffer area
;
BUFFER	EQU	DAMBUFF+100H
GATBUFF	EQU	BUFFER+100H	;1 page of gat
;
	ORG	GATBUFF		;init code here
;
*GET	SUINIT			;get init code
*GET	SULOGO			;get logo code
;
;	the following sector will contain the HIT table
;	of a directory residing in memory
;
HITBUFF	EQU	GATBUFF+100H	;1 page of hit
;
;	the following sectors contain the actual records
;	of the file allocations and assignments
;	normally, this will be either 8 or 16 additional
;	sectors in addition to the GAT and HIT
;
FILBUFF	EQU	HITBUFF+100H	;16 pages of file data
;
;	when executing the 'format without erase'
;	option, we need to hold an entire track of
;	sectors in memory, and then still have enough
;	free memory available to build a formatted
;	track image
;	If a track is read in starting at $BUFFER
;	there will be sufficient memory starting right
;	here for either a single or double density track
;
;	this area is also used to hold the second
;	diskettes directory when the 'copy files'
;	utility is executed
;	this will be an additional 18 sectors long
;	to account for double density tracks
;	Following this second directory will be the
;	real free memory used to transfer the files
;	There is one problem when a directory that is
;	longer than 18 sectors (extended ND80 directory)
;	As you can see, there is not enough memory
;	available using the techniques to copy files
;	that PT uses
;	Therefore, this is the reason for the limitation
;	of copying files from/to a disk with a long dir.
;
FBUFF	EQU	BUFFER+1200H	;18 pages for w/o erase
;
DATBUFF	EQU	FBUFF+1100H	;actual free memory
;
ENDMEM	EQU	0FFFFH		;end physical memory
;
;	when using the 'exchange disk sectors' option
;	we will need to keep two complete sets of source
;	information before any writing takes place
;	Starting at $BUFFER, which is the first avail
;	buffer, compute the address of (0-$BUFFER)/2
;	which is one half of the buffer area
;	The $DAMBUFF buffer which hold the address marks
;	during this operation will itself be divided
;	in half and each corresponding set of DAM bytes
;	will be used to each of the destination sectors
;	write bytes
;	This is possible because there will never be
;	enough free memory to ever hold more that 128
;	sectors in memory at one time
;	128 sectors = 32K
;
BUFFLEN	EQU	0-BUFFER	;length of free memory
HALFLEN	EQU	BUFFLEN<-1	;divide in half
MIDPNT	EQU	BUFFER+HALFLEN	;midpoint of program
;
