; subtm - kjw/bqsd - 02/83
;
; revised 03/09/83 - kjw/dwh
; revised 04/20/83 - kjw
;
	TITLE	'<Super Utility Boot MAX>'
;
;	This program will locate at Track 0/Sector 0
;	in double density.  It will read in a rather
;	'unusual' manner the 'true' loader which
;	will reside on track 1, at sectors 
;	20H SD, 25H SD, 30H SD, 35H DD, 40H DD, 45H DD
;	The sectors will be have Track/Head/Sector
;	numbers all the same
;
;	equivalences
;
FDC	EQU	07ECH		;FDC command/status reg.
TRACK	EQU	07EDH		;FDC track register
SECTOR	EQU	07EEH		;FDC sector register
XFER	EQU	07EFH		;FDC transfer register
SELFDC	EQU	07D8H		;FDC select register
BEEP	EQU	07F8H		;beep speaker
;
DRIVE	EQU	001H		;drive select code
SEEK	EQU	01BH		;seek command
SREAD	EQU	080H		;read command
RESTORE	EQU	00BH		;restore command
AREAD	EQU	0C4H		;read ID marks
CLEAR	EQU	0D0H		;reset FDC
;
	ORG	400H		;Max loader
;
ENTRY	DI
	LD	A,03H		;for dir kill
;
	LD	SP,STACK	;reset stack
	POP	HL		;get buffer
	CALL	FIG4080		;figure 40/80 track drive
;
;	move head to loader track
;
	CALL	$SEEK		;move head there
;
;	all register loaded via pop's
;
	LD	B,6		;6 512 byte sectors
;
LDLP	POP	HL		;get buffer
	POP	DE		;get track/sector
	PUSH	BC		;save counter
	CALL	$READ		;read sector
	POP	BC		;restore counter
	DEC	B		;less this count
	RET	Z		;go load if done!
	LD	A,B		;get count
	CP	3		;3 to go?
	JR	NZ,LDLP		;go if not
	LD	A,DRIVE.OR.40H	;set double density
	LD	(DRIVX),A	;set for select
	JR	LDLP		;continue
;
;	actual read routine
;	return/entry point on stack
;
;	ENT	HL => I/O buffer to use
;		DE = track/sector (from ID field)
;
;	EXT	return made via stack
;		first pass a CALL is on stack
;		second pass, stack overflow fetchs
;		the entry point from init table
;
$READ	LD	A,SREAD.XOR.-1	;standard sector read
	JR	READ		;go common
;
$READA	LD	A,AREAD.XOR.-1	;subroutine
;
READ	LD	(RDTYPE),A	;pass vector
	LD	A,10		;init retry counter
;
READLP	PUSH	HL		;save buffer address
	EX	AF,AF'		;save retry count
	CALL	READ1		;try once
	POP	HL		;restore buffer
	RET	Z		;no error, return
	EX	AF,AF'		;save status, get count
	DEC	A		;any more?
	JR	NZ,READLP	;go for retry count
	JR	ERROR		;go disk error
;
READ1	CALL	SELECT		;select drive 0
	LD	A,E		;get sector
	CPL
	LD	(SECTOR),A	;to FDC sector reg
	LD	A,D		;get track
	CPL
	LD	(TRACK),A	;to FDC track reg
;
	LD	A,0		;read command
RDTYPE	EQU	$-1
	CALL	SLOW		;issue and delay
;
RDL1	LD	A,(FDC)		;read FDC status
	BIT	1,A		;byte ready?
	JR	Z,RDL2		;go if ready
	RRCA			;still pending?
	JR	NC,RDL1		;wait if yes
	JR	RDL3		;else command completed
;
RDL2	LD	A,(XFER)	;read FDC byte
	CPL
	LD	(HL),A		;to buffer
	INC	HL		;bump buffer
	JR	RDL1		;go next byte
;
RDL3	LD	A,(FDC)		;read status
	CPL			;reverse status
	OR	A		;any error?
	PUSH	AF		;save
	LD	A,CLEAR.XOR.-1	;clear FDC
	LD	(FDC),A		;do it
	POP	AF		;restore
	RET			;done!
;
;	error vector
;
ERROR	LD	BC,0000H	;count
ERRLP	LD	(BEEP),A	;beep
	DEC	C		;less LSB
	JR	NZ,ERRLP	;go for LSB count
	DJNZ	ERRLP		;go for MSB count
	RST	0		;re-boot
;
;	issue FDC command and delay for valid status
;
SLOW	LD	(FDC),A		;to FDC
	LD	A,32		;delay time
SLOW1	DEC	A		;less counter
	JR	NZ,SLOW1	;wait for valid status
	RET			;done!
;
;	read ID marks
;
FIG4080	LD	A,4		;track to seek
	CALL	$SEEK		;seek track
	CALL	$READA		;read ID marks
	LD	B,3		;4 bytes
	LD	A,(HL)		;fetch a byte
FIGIT	INC	HL		;bump pointer
	OR	(HL)		;merge
	DJNZ	FIGIT		;go for 4 bytes
	LD	(400H),A	;save byte
	RET			;done!
;
;	seek track
;
$SEEK	PUSH	AF		;save track
	CALL	SELECT		;select drive
	LD	A,RESTORE.XOR.-1 ;restore to track 0
	CALL	SLOW		;issue command
SEEK1	CALL	SELECT		;read status
	RRCA			;command busy?
	JR	NC,SEEK1	;wait till done
	POP	AF		;get track
	CPL			;reverse bits
	LD	(XFER),A	;track to seek
	LD	A,SEEK.XOR.-1	;FDC command
	CALL	SLOW		;issue command
SEEK2	CALL	SELECT		;select/get status
	RRCA			;pending?
	JR	NC,SEEK2	;wait till done
	RET			;else done!
;
;	select drive
;
SELECT	LD	A,DRIVE		;drive select code
DRIVX	EQU	$-1
	LD	(SELFDC),A	;select reg FDC
	LD	A,(FDC)		;read status
	RET			;done!
;
;	following is the real stack area
;
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
;
;	stack area follows, registers popped here
;
STACK	DEFW	1000H		;buffer
	DEFW	1000H		;buffer
	DEFW	2020H		;track/sector
	DEFW	1200H
	DEFW	2525H
	DEFW	1400H
	DEFW	3030H
	DEFW	1600H
	DEFW	4040H
	DEFW	1800H
	DEFW	4545H
	DEFW	1A00H
	DEFW	5050H
	DEFW	1800H
;
ZZZZZ	EQU	$
;
	END	ENTRY
