; sutape/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/16/83 - kjw
;
	PAGE
;
;	copy tape entry point
;
CTAPE	RST	@08		;display
;
	DEFB	CLSF
	DEFM	'Tape Backup'
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
	CALL	ASKDECK		;prompt and wait
;
	LD	HL,CTAPED	;vector for completed
	LD	(VECTOR1),HL	;save for interrupt
	CALL	MOTORO		;motor on/interrupts off
	LD	HL,(CURSOR)	;fetch cursor
	LD	(HL),99H	;fill with block
;
;	wait for a pulse, check keyboard
;	if pulse detected, immediately send one out
;
CTAPEL	CALL	BITIN		;clear key pressed?
;
	LD	B,30H		;settling delay
	DJNZ	$		;count here
;
	CALL	BITOUT		;send a bit
;
;	change block
;
	LD	A,(HL)		;fetch from video
	XOR	3FH		;reverse bits
	LD	(HL),A		;new block to video
	JR	CTAPEL		;go looper
;
CTAPED	CALL	MOTORF		;turn off cassette motor
	JP	GOBACK		;done!
;
;	ask deck 1 or 2 on Mod I only
;
ASKDECK	EQU	$
;i*
	IF	MODI
	RST	@08		;display prompt
;
	DEFB	EOL
	DEFM	'Deck 1 or 2? '
	DEFB	ETX
;
	CALL	ONEKEY		;fetch single key
	JR	NZ,DECK1	;go if input
	LD	A,'1'		;default deck 1
DECK1	SUB	'1'		;remove ascii
	JR	Z,DECK2		;go if dec 1
	CP	1		;dec 2?
	JR	NZ,ASKDECK	;go if neither
;
DECK2	LD	(CASSEL),A	;select cassette drive
	ENDIF
;i*
;
	RST	@08		;display mount prompt
;
	DEFB	EOL
	DEFM	'<KEY> to begin:'
	DEFB	ETX
;
	CALL	ONEKEY		;single key input
	RST	@08		;display clear message
;
	DEFB	EOL
	DEFM	'<CLEAR> to terminate:'
	DEFB	LF
	DEFB	ETX
;
	RET			;done
;
;	init registers for count/mem address
;
TAPESET	LD	DE,0		;init byte counter
	LD	H,D		;pass to HL
	LD	L,E		;HL = checksum
	EXX			;save 'em
	LD	HL,(TADDS)	;input buffer
	LD	IY,VIDEO+342H	;video byte display
	RET			;done
;
;	locate sync byte to begin block
;
LOCSYNC	RST	@08		;display message
;
	DEFB	EOL
	DEFM	'Looking for sync'
	DEFB	ETX
;
	CALL	MOTORO		;turn on motor
	LD	D,0		;load zero byte
;
TAPELDR	CALL	BITIN		;read 1 bit
	RL	D		;move into mask byte
	LD	A,D		;get new byte
	CP	0A5H		;have the byte yet?
	JR	NZ,TAPELDR	;go loop
;
	RST	@08		;clear display line
	DEFB	EOL
	DEFB	ETX
;
	RET			;found it!
;
;	display current incoming/outgoing byte
;
TAPESHO	PUSH	AF		;save char
	EXX			;swap to alt set
	LD	C,A		;pass to BC
	LD	B,0		;BC = new char
	ADD	HL,BC		;add to checksum
	INC	DE		;bump byte counter
	EXX			;swap back
;
	LD	(IY-64),A	;poke ascii direct
	RST	@20		;make it ascii hex
	LD	(IY),C		;MSB
	LD	(IY+64),B	;LSB ascii
	INC	IY		;bump video pointer
	PUSH	IY		;pass to BC
	POP	BC		;BC = video
	LD	A,C		;get LSB
	CP	7EH		;at end?
	JR	NZ,TAPSHO1	;go if not
	LD	IY,VIDEO+342H	;reset to beginning
;
TAPSHO1	LD	(IY-64),BLOCK	;graphics
	LD	(IY+00),BLOCK
	LD	(IY+64),BLOCK
;
	POP	AF		;restore original
	RET			;done, tallied
;
	PAGE
;
;	$RTAPE - read tape entry
;
RTAPE	RST	@08		;display header
;
	DEFB	CLSF
	DEFM	'Tape Read'
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
	LD	BC,PGMEND	;default buffer
	LD	(DEFADDR),BC	;save as default
	CALL	GETADDR		;fetch address
	LD	(TADDS),BC	;save buffer start
	CALL	ASKDECK		;fetch deck/wait
	LD	HL,RTAPED	;completion vector
	LD	(VECTOR1),HL	;save it
	CALL	TAPESET		;init counter/checksum
	CALL	LOCSYNC		;look for sync byte
;
RTAPEL	CALL	BYTEIN		;read one byte
	LD	(HL),D		;put in buffer
	LD	A,D		;fetch char
	CALL	TAPESHO		;display it
	INC	HL		;bump buffer
	LD	A,H		;check for mem overflow
	OR	L
	JP	Z,TAPEND	;force tape end
	JR	RTAPEL		;continue next byte
;
RTAPED	PUSH	HL		;save buff address
	CALL	MOTORF		;turn off motor
	POP	HL		;restore address
	CALL	TRANGES		;display tape range
	CALL	PRESS		;enter to continue
;
	LD	HL,(TCOUNT)	;get tape count
	LD	A,H		;anything?
	OR	L
	JP	Z,RETURN	;go if nil input
;
	LD	BC,(TADDS)	;start of data
	JP	DOADDR		;display address
;
	PAGE
;
;	$VTAPE - verify tape entry
;
VTAPENO	RST	@08		;display
;
	DEFM	'NO DATA in memory'
	DEFB	ETX
;
	CALL	GETSE		;get start/end buffer
	LD	BC,(TEMP0)	;fetch start address
	LD	(TADDS),BC	;save start
	LD	HL,(TEMP1)	;get end address
	LD	(TADDR),HL	;save end
	OR	A		;clear carry
	SBC	HL,BC		;compute length
	INC	HL		;+ 1 for inclusive addrs
	LD	(TCOUNT),HL	;save counter
	LD	HL,0		;load zero
	LD	(TSUM),HL	;save checksum
	RET			;done
;
VTAPE	RST	@08		;display
;
	DEFB	CLSF
	DEFM	'Tape Verify'
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
	CALL	INTCNT		;clear counter
	LD	HL,(TCOUNT)	;get byte count
	LD	A,H		;anything?
	OR	L
	CALL	Z,VTAPENO	;nothing in memory
;
	CALL	ASKDECK		;ask for deck
	LD	HL,VTAPED	;exit vector
	LD	(VECTOR1),HL	;save it
	CALL	TAPESET		;setup registers
	CALL	TRANGE		;display data range
	CALL	LOCSYNC		;find the sync byte
	LD	BC,(TCOUNT)	;fetch counter
;
VTAPEL	PUSH	BC		;save count
	CALL	BYTEIN		;read one byte
	LD	A,D		;fetch byte
	CP	(HL)		;match?
	LD	A,SPACE		;load blank
	JR	Z,VTAPE1	;go if match
;
;	mismatch on verify
;
	CALL	ADDCNT		;bump error counter
	LD	A,'*'		;error marker
;
VTAPE1	LD	(IY-128),A	;to video
	LD	A,D		;fetch byte back
	CALL	TAPESHO		;display it
	POP	BC		;restore counter
	INC	HL		;bump buffer
	LD	A,H		;check for mem overflow
	OR	L
	JP	Z,TAPEND	;force tape end
	DEC	BC		;less byte count
	LD	A,B		;any more?
	OR	C
	JR	NZ,VTAPEL	;go if more to do
;
VTAPED	PUSH	HL		;save buffer
	CALL	MOTORF		;turn off motor
	POP	HL		;restore buffer
	CALL	TRANGES
	CALL	SHOCNT		;display counter
	RST	@08		;display
;
	DEFM	'errors on verify'
	DEFB	ETX
;
	JP	GOBACK		;key to continue
;
	PAGE
;
;	$WTAPE - write tape entry
;
WTAPE	RST	@08		;display header
;
	DEFB	CLSF
	DEFM	'Tape Write'
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
	LD	HL,(TCOUNT)	;get tape count
	LD	A,H		;anything?
	OR	L
	CALL	Z,VTAPENO	;go if nil!
;
	CALL	ASKDECK		;fetch deck
	CALL	TAPESET		;setup to go
	CALL	TRANGE		;display data range
	CALL	PUTSYNC		;write leader and sync
	LD	BC,(TCOUNT)	;get byte count
;
WTAPEL	LD	D,(HL)		;fetch byte
	PUSH	BC		;save count
	CALL	BYTEOUT		;send byte to cassette
	LD	A,(HL)		;fetch again
	CALL	TAPESHO		;to display
	POP	BC		;restore counter
	INC	HL		;bump buffer
	CALL	IFCLEAR		;clear key pressed?
	JR	C,WTAPED	;go if yes
	DEC	BC		;less byte count
	LD	A,B		;any more to do?
	OR	C
	JR	NZ,WTAPEL	;go if more
;
WTAPED	PUSH	HL		;save buffer
	CALL	MOTORF		;turn off motor
	POP	HL		;restore buffer
	CALL	TRANGES		;display range
	JP	GOBACK		;key to continue
;
;	write leader and sync byte to tape
;
PUTSYNC	RST	@08		;display message
;
	DEFB	EOL
	DEFM	'Writing Leader'
	DEFB	ETX
;
	CALL	MOTORO		;turn on cassette motor
	LD	BC,8000H	;1/2 second for tape
	CALL	DELAY		;to come up to speed
;
	LD	E,0		;init byte counter
;
PUTSNY	LD	D,0		;byte to send
	CALL	BYTEOUT		;write a byte
	DEC	E		;less counter
	JR	NZ,PUTSNY	;go if more
	LD	D,0A5H		;load header
	CALL	BYTEOUT		;write the byte
	RST	@08		;clear line
;
	DEFB	EOL
	DEFB	ETX
;
	RET			;done!
;
	PAGE
;
;	$BYTEOUT - send one byte to cassette port
;
;	ENT	D = byte to send
;
;	EXT	ABC destroyed
;
BYTEOUT	LD	C,8		;go for 8 bits
;
BYTEOL	SCF			;for bit ON
	CALL	BITOUT		;send timing bit
	RLC	D		;move bit into carry
	CALL	BITOUT		;send data bit
	DEC	C		;less bit counter
	JR	NZ,BYTEOL	;go till done
	RET			;byte sent
;
BITOUT	JR	NC,BITOUT0	;send 0 bit
;i*
	IF	MODI
	LD	A,05		;low output mod I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	A,01		;low output mod III
	ENDIF
;iii*
	OUT	(CASDAT),A	;issue pulse
;i*
	IF	MODI
	LD	B,0AH		;pulse length I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,0DH		;pulse length III
	ENDIF
;iii*
	DJNZ	$
	INC	A		;adjust to high output
	OUT	(CASDAT),A	;issue pulse
;i*
	IF	MODI
	LD	B,0AH		;pulse length I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,0DH		;pulse length III
	ENDIF
;iii*
	DJNZ	$
	CALL	BITNIL		;clear latch
;i*
	IF	MODI
	LD	B,6CH		;pulse gap I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,78H		;pulse gap III
	ENDIF
;iii*
	DJNZ	$
	RET			;bit sent
;
BITOUT0	EQU	$
;i*
	IF	MODI
	LD	B,87H		;gap mod I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,98H		;gap mod III
	ENDIF
;iii*
	DJNZ	$
	RET			;bit sent
;
BITNIL	EQU	$
;i*
	IF	MODI
	LD	A,4
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	A,0
	ENDIF
;iii*
;
	OUT	(CASDAT),A	;send to cassette port
	RET			;done!
;
;	$BYTEIN - read byte from cassette port
;
;	EXT	D = data byte
;		ABC destroyed
;
BYTEIN	LD	C,8		;go for 8 bits
;
BYTEIL	CALL	BITIN		;read one bit
	RL	D		;shift into D reg
	DEC	C		;less bit
	JR	NZ,BYTEIL	;go if more bits
	RET			;done, byte in D
;
;	$BITIN - read one bit from tape
;
;	EXT	carry flag is data bit
;		if <CLEAR> key is pressed, exit is
;		made via (VECTOR1)
;		AB destroyed
;
BITIN	PUSH	HL		;save HL
	LD	HL,KBDR6	;point to keyboard
;
BITINL	IN	A,(CASDAT)	;read cassette port
	RLA			;have sync bit?
	JR	C,BITINH	;have it, go!
	BIT	1,(HL)		;CLEAR pressed?
	JR	Z,BITINL	;go if not
	JR	BITCAN		;else abort!
;
BITINH	EQU	$
;i*
	IF	MODI
	LD	B,41H		;delay for reset
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,6EH		;delay for reset
	ENDIF
;iii*
	DJNZ	$
	CALL	BITNIL		;reset latch
;i*
	IF	MODI
	LD	B,72H		;delay for data
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,98H		;delay for data
	ENDIF
;iii*
	DJNZ	$
;
	IN	A,(CASDAT)	;read data bit
	RLA			;move into carry flag
	POP	HL		;restore HL
;
	JP	BITNIL		;clear latch and return
;
;	cancel operation
;
BITCAN	POP	HL		;restore buff address
	LD	SP,STACK	;reset stack
	LD	BC,(VECTOR1)	;get return vector
	PUSH	BC		;to stack
	RET			;go exit vector
;
;	$MOTORO - turn cassette motor on
;
MOTORO	EQU	$
;i*
	IF	MODI
	LD	A,4		;motor on, latch clear
	OUT	(CASMOT),A	;turn cassette on
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	A,2AH		;motor on
	OUT	(CASMOT),A	;turn cassette on
	ENDIF
;iii*
	CALL	DLOFF		;dual off
	CALL	SPDOFF		;high speed off
	DI			;disable for transfer
	RET			;done
;
;	$MOTORF - turn cassette motor off
;
MOTORF	EQU	$
;i*
	IF	MODI
	LD	A,0		;clear all bits
	OUT	(CASMOT),A	;turn motor off
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	A,28H		;motor off
	OUT	(CASMOT),A	;do it
	ENDIF
;iii*
	CALL	TURNSPD		;set hispeed config
	CALL	DLON		;re-enable dual if on
	EI			;can enable now
	RET			;done
;
;	completed, fetch byte count and checksum
;
TRANGES	LD	(TADDR),HL	;save ending address
	EXX			;get alt set
	LD	(TCOUNT),DE	;save byte count
	LD	(TSUM),HL	;save checksum
	EXX			;swap back
;
;	display buffer/checksum/length
;
TRANGE	PUSH	BC		;save needed
	PUSH	HL
;
	LD	BC,(TADDS)	;start of buffer
	LD	HL,TRNG1	;text
	CALL	PUTHEX		;display start address
	LD	BC,(TADDR)	;get end address
	LD	HL,TRNG2	;text
	CALL	PUTHEX		;display end address
	LD	BC,(TSUM)	;get checksum
	LD	HL,TRNG3	;text
	CALL	PUTHEX		;display checksum
	LD	HL,(TCOUNT)	;get byte count
	PUSH	IY		;save it
	LD	IY,TRNG4	;text
	CALL	BINASC		;to decimal ascii
	POP	IY		;restore
	RST	@08		;display it
;
	DEFB	BOL
	DEFM	'Data from '
TRNG1	DEFM	'xxxxH to '
TRNG2	DEFM	'xxxxH / count = '
TRNG4	DEFM	'xxxxx / checksum = '
TRNG3	DEFM	'xxxxH'
	DEFB	LF
	DEFB	ETX
;
	POP	HL		;unstack
	POP	BC
	RET			;done
;
;	buffer overflow on tape read/verify
;
TAPEND	DEC	HL		;adjust buffer
	PUSH	HL		;setup stack
	RST	@08		;display message
;
	DEFB	BOL
	DEFM	'Buffer Full'
	DEFB	LF
	DEFB	ETX
;
	JP	BITCAN		;go abort vector
;
