; sumastm/asm - kjw/bqsd - 02/83
;
; revised 02/20/83 - kjw
;
	TITLE	'<Assem File to Master>'
;
	SUBTTL	'<by Kim Watt - (c)(p) Copyright 1983 Breeze/QSD, Inc. - Dallas, TX>'
;
;	this program will take normal disk files
;	that are assembled and move them to the
;	master duplicating diskette in the
;	correct position
;
;	the master disk is a standard LDOS formatted
;	diskette for 40 tracks in double density
;	the directory must be moved to TRACK 1 !!
;
;	equivalences
;
@OPEN	EQU	4424H		;open file
@VDLINE	EQU	4467H		;string to video
@KBLINE	EQU	0040H		;string from keyboard
@GET	EQU	0013H		;fetch byte from file
@ERROR	EQU	4409H		;display error
@ABORT	EQU	4030H		;dos exit
@FSPEC	EQU	441CH		;fetch filespec
@WRSEC	EQU	4763H		;write sector
@RDSSEC	EQU	4B45H		;read system sector
@TOPMEM	EQU	4411H		;topmem Mod III
@FEXT	EQU	444BH		;add default extension
;
CR	EQU	0DH
LF	EQU	0AH
ETX	EQU	03H
HOME	EQU	1CH
CLS	EQU	1FH
EOF	EQU	1CH
;
	ORG	5200H		;use with LDOS!
;
ENTRY	LD	(STACK),SP	;save stack pointer
	LD	HL,HELLO	;sign on message
	CALL	@VDLINE		;display message
;
LOOP	LD	SP,$		;reset stack
STACK	EQU	$-2
	CALL	CLEAR		;clear buffer for use
	LD	HL,MENU		;menu options
	LD	DE,STRING	;input buffer
	LD	B,1		;one key input
	CALL	@VIDKEY		;display/fetch key
	JP	C,EXIT		;exit program
	LD	A,(HL)		;fetch first char
	AND	5FH		;make upper case
	SUB	'A'		;remove ascii
	JR	C,LOOP		;go if any error
	CP	17		;0-16?
	JR	NC,LOOP		;go if out of range
	LD	(TYPE),A	;save type of placement
	CP	16		;quit?
	JP	Z,EXIT		;yes, go!
	CP	15		;init?
	JP	Z,GETDES	;yes, go!
;
;	display default filespec that I use
;
	ADD	A,A		;add offset
	LD	HL,NAMES	;table of names
	ADD	A,L		;add offset
	LD	L,A		;update
	JR	NC,NAMGOT	;have it, go!
	INC	H		;crossed page boundary
NAMGOT	LD	A,(HL)		;get LSB pointer
	INC	HL		;bump table
	LD	H,(HL)		;get MSB pointer
	LD	L,A		;HL => name
	LD	(DEFNAME),HL	;save default name
	CALL	@VDLINE		;display it
	JR	GETFILE		;get file from user
;
;	fetch filespec from user
;
ERROR	OR	0C0H		;normal error
	CALL	@ERROR		;display message
;
GETFILE	LD	A,(TYPE)	;get type
	CP	15		;init?
	JP	Z,LOOP		;yes, go!
	LD	HL,PROMPT	;prompt text
	LD	DE,STRING	;input buffer
	LD	B,32		;max input length
	CALL	@VIDKEY		;video/keyboard
	JP	C,LOOP		;go if break
;
;	check if nil input to use default
;
	LD	A,B		;any input?
	OR	A		;B=0?
	JR	NZ,INPFILE	;filename was input!
	LD	HL,$		;get default
DEFNAME	EQU	$-2
;
INPFILE	LD	DE,DCB		;file DCB
	CALL	@FSPEC		;fetch filespec
	JR	NZ,ERROR	;go if any error
;
;	add default extension
;
	LD	HL,CMD		;/CMD extension
	CALL	@FEXT		;add it
;
	LD	B,0		;LRL
	LD	HL,IOBUFF	;I/O buffer
	CALL	@OPEN		;open the file
	JR	NZ,ERROR	;go if any error
	JR	GETDES		;get dest drive
;
;	fetch target drive from user
;
GETDERR	OR	0C0H		;set error type
	CALL	@ERROR		;display error
;
GETDES	LD	HL,TARGET	;target drive
	LD	DE,STRING	;input buffer
	LD	B,1		;one key input
	CALL	@VIDKEY		;display/keyboard
	JP	C,GETFILE	;go if break
;
	LD	A,(HL)		;get input key
	SUB	'0'		;remove ascii
	JR	C,GETDES	;go if invalid
	CP	8		;0-7?
	JR	NC,GETDES	;go if too big
	LD	(DRIVE),A	;save binary drive #
	LD	C,A		;pass drive
	LD	DE,0100H	;dir track/sector 0
	LD	HL,BUFFER	;I/O buffer
	CALL	@RDSSEC		;log in the disk!
	JR	NZ,GETDERR	;go if error!
;
;	go vector to write information
;
	LD	A,0		;get type
TYPE	EQU	$-1
	ADD	A,A		;*2 for two byte table
	LD	HL,VECTORS	;jump table for subs
	ADD	A,L		;add to LSB
	LD	L,A		;update
	JR	NC,NOTCRS	;go if no page cross
	INC	H		;bump page
NOTCRS	LD	A,(HL)		;get LSB vector
	INC	HL		;bump table
	LD	H,(HL)		;get MSB vector
	LD	L,A		;HL => vector
	PUSH	HL		;save on stack
	LD	HL,FINISH	;completed vector
	EX	(SP),HL		;leave on stack/get vect
	XOR	A		;load zero
	JP	(HL)		;go vector!
;
VECTORS	DEFW	BOOT1		;boot sector 1
	DEFW	BOOT3		;boot sector 3
	DEFW	BOOTM		;boot sector max
	DEFW	LOADER1		;loader sectors 1
	DEFW	LOADER3		;loader sectors 3
	DEFW	LOADERM		;loader sectors max
	DEFW	LOADR81		;load 80 track 1
	DEFW	LOADR83		;load 80 track 3
	DEFW	LOADR8M		;load 80 track max
	DEFW	PATCH1		;patch sectors 1
	DEFW	PATCH3		;patch sectors 3
	DEFW	PATCHM		;patch sectors max
	DEFW	SU1		;program sectors 1
	DEFW	SU3		;program sectors 3
	DEFW	SUM		;program sectors max
	DEFW	INIT		;init
	DEFW	EXIT		;exit program
;
NAMES	DEFW	NAME0		;subt1
	DEFW	NAME1		;subt3
	DEFW	NAME2		;subtm
	DEFW	NAME3		;suld41
	DEFW	NAME4		;suld43
	DEFW	NAME5		;suld4m
	DEFW	NAME6		;suld81
	DEFW	NAME7		;suld83
	DEFW	NAME8		;suld8m
	DEFW	NAME9		;supatch1
	DEFW	NAME10		;supatch3
	DEFW	NAME11		;supatchm
	DEFW	NAME12		;su1
	DEFW	NAME13		;su3
	DEFW	NAME14		;sum
;
;	boot sector Mod I
;
BOOTM	EQU	$
BOOT1	CALL	PLOAD		;load in the file
	RET	NZ		;return if any error
;
;	check size
;
	LD	HL,100H		;max length
	OR	A		;clear carry flag
	SBC	HL,DE		;compare
	JR	C,FMTERR	;file too large!
;
	LD	HL,BUFFER	;start of buffer
	LD	DE,0200H	;track/sector
	JP	WRITE		;write and return
;
FMTERR	LD	A,34
	OR	A
	RET
;
;	boot sector Mod III
;
BOOT3	CALL	PLOAD		;load the file
	RET	NZ		;error!
;
;	check size
;
	LD	HL,100H		;max size
	OR	A		;clear carry flag
	SBC	HL,DE		;compare
	JR	C,FMTERR	;too large!
;
	LD	HL,BUFFER	;data is here
	LD	DE,0201H	;track/sector
	JP	WRITE		;write sector and return
;
;	loader mod I - 40/80 track versions
;
LOADERM	EQU	$
LOADER1	LD	HL,0300H	;track 3, sector 0
	JR	LDR481		;go 40/80 driver
;
LOADR8M	EQU	$
LOADR81	LD	HL,0400H	;track 4, sector 0
;
LDR481	LD	(LDR48A),HL	;save track/sector
	CALL	PLOAD		;load program
	RET	NZ		;return in error!
;
	LD	HL,0C00H	;max size
	OR	A		;clear carry
	SBC	HL,DE		;compare length
	JR	C,FMTERR	;format error!
;
;	CALL	ADJLOAD		;adjust loader buffer
	LD	HL,BUFFER	;adjusted buffer
	LD	DE,$		;get track/sector
LDR48A	EQU	$-2
	LD	B,12		;12 sectors to write
XXYY	PUSH	BC		;save count
	CALL	WRITE		;write sector
	POP	BC		;restore count
	RET	NZ		;go on error
	INC	H		;bump I/O buffer
	INC	E		;bump sector
	DJNZ	XXYY		;go for track count
	XOR	A		;set no error
	RET			;done!
;
;	loader mod III - 40/80 track versions
;
LOADER3	LD	HL,0306H	;track/sector start
	JR	LDR483		;go common
;
LOADR83	LD	HL,0406H	;track 4, sector 6
;
LDR483	LD	(LDR48B),HL	;save track/sector
	CALL	PLOAD		;program load
	RET	NZ		;error!
;
	LD	HL,300H		;max length
	OR	A		;clear carry
	SBC	HL,DE		;compare length
	JR	C,FMTERR	;file format error
;
	CALL	ADJLOAD		;adjust load buffer
	LD	HL,BUFFER+600H	;start of adjust
	LD	DE,$		;reload track/sector
LDR48B	EQU	$-2
	CALL	WRITE
	RET	NZ
	INC	H
	INC	E
	CALL	WRITE
	RET	NZ
	INC	H
	INC	E
	CALL	WRITE
	RET	NZ
	INC	H
	INC	E
	CALL	WRITE
	RET	NZ
	INC	H
	INC	E
	CALL	WRITE
	RET	NZ
	INC	H
	INC	E
	JP	WRITE
;
;	patch sectors mod I
;
PATCHM	EQU	$
PATCH1	LD	DE,0204H	;start patch mod I
	JR	PATCOM		;go common
;
;	patch sectors mod III
;
PATCH3	LD	DE,0207H	;start patch mod III
;
PATCOM	PUSH	DE		;save track/sector
	LD	HL,BUFFER+100H	;load patches here
	PUSH	HL		;save buffer
	CALL	LOADPAT		;load patches
	POP	HL		;restore buffer
	POP	DE		;restore track sector
	RET	NZ		;error on load!
;
	LD	B,3		;3 sector to do
;
PATPUT	CALL	WRITE		;write the sector
	RET	NZ		;return if error
	INC	E		;bump sector #
	INC	H		;bump buffer
	DJNZ	PATPUT		;finish for 3 sectors
	XOR	A		;return zero
	RET			;done!
;
;	load patch info into $BUFFER
;
LOADPAT	CALL	GET		;fetch a byte
	RET	NZ		;return if error
	DEC	A		;less one
	JR	Z,PAT1		;go if load block
	DEC	A		;less one
	JR	Z,PAT2		;go if entry block
	CP	1EH		;valid code?
	JP	NC,FMTERR	;file format error!
;
;	skip over remarks
;
	CALL	GET		;get length byte
	RET	NZ		;return if error
	LD	B,A		;pass it
PAT3	CALL	GET		;get remark
	RET	NZ
	DJNZ	PAT3		;finish it off
	JR	LOADPAT		;go next block
;
;	load block
;
PAT4	DEC	B		;adjust to correct length
	DEC	B
	JR	PAT3		;remove block
;
PAT1	CALL	PATADDR		;get address
	RET	NZ		;go if error
	PUSH	HL		;save address
	LD	HL,3BFFH	;less than ram?
	OR	A		;clear carry
	SBC	HL,DE		;compare
	POP	HL		;restore address
	JR	NC,PAT4		;go remark if <3C00H
;
	LD	A,01H		;block header
	CALL	PATHEAD		;add it
	DEC	B		;less two byte address
	DEC	B
PAT1L	CALL	GET		;fetch a byte
	RET	NZ		;go if error
	LD	(HL),A		;to buffer
	INC	HL		;bump pointer
	DJNZ	PAT1L		;finish
	JR	LOADPAT		;go next block
;
;	entry point marker
;
PAT2	CALL	PATADDR		;get address block
	RET	NZ		;error
	LD	A,E		;any entry point?
	OR	D		;yes?
	RET	Z		;nope, done!
	LD	A,02H		;entry header
;
;	add block header to buffer
;
PATHEAD	LD	(HL),A		;header to buffer
	INC	HL		;bump buffer
	LD	(HL),B		;pass length
	INC	HL		;bump
	LD	(HL),E		;lsb address
	INC	HL		;bump
	LD	(HL),D		;msb address
	INC	HL		;bump
	XOR	A		;load zero
	RET			;return a level
;
PATADDR	CALL	GET		;fetch a byte
	RET	NZ		;return if error
	LD	B,A		;pass length to B
	CALL	GET		;fetch a byte
	RET	NZ
	LD	E,A		;pass LSB address to E
	CALL	GET		;fetch next byte
	LD	D,A		;pass MSB to D
	RET			;return with status
;
;	load program file and alter load format
;
;	FFFF or 0000
;		FFFF = load block follows
;			XXXX = block load address
;			XXXX = block length
;			XX   = XOR byte for decoding
;			data = block length exact
;			XXXX = block checksum word
;		0000 = entry block follows
;			XXXX = entry point address
;			XXXX = entire program checksum
;
;	NOTE:  all addresses are MSB, LSB !
;
SUM	EQU	$
SU1	LD	DE,0600H	;high/low sectors
	JR	PTOOL13		;go common
;
SU3	LD	DE,0C06H	;high+1/low sectors
;
PTOOL13	LD	A,D		;get high
	LD	(PTHI),A	;save for test
	LD	A,E		;get low
	LD	(PTLO),A	;save for test
;
;	init counters/pointers
;
	LD	IY,0		;program checksum
	LD	D,5		;init start track
	LD	HL,BUFFER	;set buffer as empty
;
;	loop to load program file
;
PTLDLP	CALL	GET		;get source byte
	RET	NZ		;return if error
	DEC	A		;load block?
	JR	Z,PTLD1		;go if yes!
	DEC	A		;entry block?
	JP	Z,PTLD2		;go if yes!
	CP	1EH		;valid remark block?
	JP	NC,FMTERR	;file format error!
;
;	ignore remark blocks
;
	CALL	GET		;get length byte
	RET	NZ		;error
	LD	B,A		;pass it
PTLD3	CALL	GET		;get remark
	RET	NZ		;error
	DJNZ	PTLD3		;finish it off
	JR	PTLDLP		;go next block
;
;	program load block, alter load format and cksum
;
PTLD1	LD	A,-1		;block header
	CALL	PUT		;to file
	RET	NZ		;return if error
	LD	A,-1		;2 bytes long
	CALL	PUT		;to file
	RET	NZ		;return if error
;
	CALL	GET		;fetch a byte
	RET	NZ		;return if error
	SUB	2		;adjust it
	LD	B,0		;set MSB
	JR	NZ,PTLD1A	;go if <256
	INC	B		;set 100H
PTLD1A	LD	C,A		;BC = block length
	CALL	GET		;get address
	RET	NZ		;return if error
	LD	(PTLD1B),A	;save lsb
	CALL	GET		;get address
	RET	NZ		;return if error
;
	CALL	PUT		;write msb address
	RET	NZ
	LD	A,'$'		;get lsb address
PTLD1B	EQU	$-1
	CALL	PUT
	RET	NZ
;
	LD	A,B		;msb block length
	CALL	PUT
	RET	NZ
	LD	A,C		;lsb length
	CALL	PUT
	RET	NZ
;
	CALL	RANDOM		;fetch random byte
	LD	(CODE),A	;save for encoding
	CALL	PUT		;give to file
	RET	NZ		;return if error
	LD	IX,0		;init checksum block
;
;	write actual data block to file
;
PTLD1C	PUSH	IX		;save checksum
	CALL	GET		;get a byte
	POP	IX		;restore
	RET	NZ		;return if error
;
	PUSH	BC		;save
	LD	C,A		;pass byte
	LD	B,0		;BC = new byte
	ADD	IX,BC		;add to block checksum
	ADD	IY,BC		;add to program checksum
	POP	BC		;restore count
;
	XOR	'$'		;encode the byte
CODE	EQU	$-1
	PUSH	IX		;save checksum
	CALL	PUT		;write to dest
	POP	IX		;restore checksum
	RET	NZ		;return if error
;
	DEC	BC		;less this byte
	LD	A,B		;any more?
	OR	C
	JR	NZ,PTLD1C	;go till done
;
;	insert block checksum
;
	PUSH	IX		;pass checksum
	POP	BC		;to BC
	LD	A,B		;get MSB
	CALL	PUT		;to file
	RET	NZ		;return if error
	LD	A,C		;get LSB
	CALL	PUT		;write to dest
	RET	NZ		;return if any error
	JP	PTLDLP		;go next block!
;
;	program entry block
;
PTLD2	CALL	GET		;get length byte
	RET	NZ		;error!
	CP	2		;02 length?
	JP	NZ,FMTERR	;go if format error
;
;	save entry header (0000H) to dest file
;
	XOR	A		;load word of zeroes
	CALL	PUT		;give to buffer
	RET	NZ		;error
	XOR	A		;load zero
	CALL	PUT		;to buffer
	RET	NZ		;return if error
;
;	get entry point from file
;
	CALL	GET		;get lsb address
	RET	NZ		;return if error
	LD	C,A		;save lsb
	CALL	GET		;get msb address
	RET	NZ		;return if err
	CALL	PUT		;write to file msb
	RET	NZ		;return if error
	LD	A,C		;get lsb
	CALL	PUT
	RET	NZ		;return if error
;
;	add checksum to file
;
	PUSH	IY		;pass checksum to HL
	POP	BC		;BC = program checksum
	LD	A,B		;get MSB
	CALL	PUT		;add to buffer
	RET	NZ		;write error!
	LD	A,C		;get lsb
	CALL	PUT		;write checksum
	RET	NZ		;return if error
;
;	write partial buffer to disk
;
	LD	L,0		;reset buffer
	CALL	REVERSE		;reverse data!
	CALL	WRITE		;write the sector
	RET	NZ		;return if error
;
;	fill remainder of disk with cleared sectors
;
CLRDSK	INC	E		;bump sector
	LD	A,(PTHI)	;get high sector
	CP	E		;at end?
	JR	NZ,CLRDSK1	;nope, continue
	LD	A,(PTLO)	;get low sector
	LD	E,A		;reset it
	INC	D		;bump track
	LD	A,D		;get result
	SUB	35		;at disk end?
	RET	Z		;yes, return Z
;
CLRDSK1	LD	HL,BUFFER	;start of buffer
	CALL	GPUT		;clear to zeroes
	CALL	WRITE		;write the sector
	RET	NZ		;return if error
	JR	CLRDSK		;go next sector
;
;	init disk - fill all with 00's
;
INIT	XOR	A		;load zero
	LD	(PTLO),A	;save low sector
	LD	A,18		;highest sector +1
	LD	(PTHI),A	;save high sector
	LD	DE,02FFH	;track/sector
	JR	CLRDSK		;zero disk!
;
;**	subroutines
;
;	compute random number
;
RANDOM	LD	A,R		;get refresh register
	XOR	37H
RAND1	EQU	$-1
	LD	(RAND3),A
	RRCA
	RRCA
	XOR	2FH
RAND2	EQU	$-1
	LD	(RAND1),A
	RLA
	XOR	77H
RAND3	EQU	$-1
	LD	(RAND2),A
;
	RET	NZ
	DEC	A
	RET
;
;	write data to destination sectors buffered
;
PUT	LD	(HL),A		;char to buffer
;
;	check if buffer is full
;
	INC	L		;bump buffer
	JR	NZ,PUTOK	;not at end, return OK
	CALL	REVERSE		;reverse sector!
	CALL	WRITE		;else write sector!
	RET	NZ		;return in error!
	CALL	GPUT		;clear out buffer
	INC	E		;bump to next sector
	LD	A,E		;get sector
	CP	'$'		;at end?
PTHI	EQU	$-1
	JR	C,PUTOK		;nope, all OK
	LD	E,'$'		;else fetch low sector
PTLO	EQU	$-1
	INC	D		;bump track
	LD	A,D		;get track
	CP	35		;in range?
	JR	C,PUTOK		;yes, continue
	LD	A,27		;full disk!
	OR	A		;set NZ
	RET			;return with error
;
PUTOK	XOR	A		;load zero
	RET			;return no error
;
;	reverse 256 byte buffer at HL
;
REVERSE	PUSH	BC		;save
	PUSH	DE		;save
	PUSH	HL		;save
;
	PUSH	HL		;save start
	LD	DE,0FFH		;length -1
	ADD	HL,DE		;HL => end
	POP	DE		;DE => start
	LD	B,80H		;length / 2
;
SWAP	LD	A,(HL)		;get a byte
	EX	AF,AF'		;save it
	LD	A,(DE)		;get second
	LD	(HL),A		;swap with first
	EX	AF,AF'		;get first
	LD	(DE),A		;swap with second
	INC	DE		;bump low
	DEC	HL		;dec high
	DJNZ	SWAP		;finish 256 bytes
;
	POP	HL		;unstack
	POP	DE
	POP	BC
	RET			;done
;
;	clear 256 byte buffer for buffered output
;
GPUT	PUSH	HL		;save everything
	PUSH	DE
	PUSH	BC
;
	LD	D,H		;pass to DE
	LD	E,L		;DE = buffer start
	INC	DE		;DE = start +1
	LD	BC,0FFH		;buff length -1
	LD	(HL),0		;load zero
	LDIR			;fill all zeroes
;
	POP	BC		;unstack
	POP	DE
	POP	HL
	RET
;
;	clear entire buffer before data load
;
CLEAR	LD	HL,(@TOPMEM)	;get topmem
	LD	DE,BUFFER	;start of buffer
	OR	A		;clear carry
	SBC	HL,DE		;HL = free memory
	DEC	HL		;length -1
	LD	B,H		;pass to BC
	LD	C,L		;BC = length -1
	LD	H,D		;get buffer
	LD	L,E		;HL & DE => buffer
	INC	DE		;start +1
	LD	(HL),0		;load zero
	LDIR			;clear it out
	RET			;done
;
;	adjust buffer for loader code
;
ADJLOAD	LD	HL,BUFFER+600H	;start of encoded buffer
	LD	DE,BUFFER	;data is here
	LD	B,3		;768 bytes to do
;
ADJ1	LD	A,(DE)		;get a byte
	CALL	ADJ2		;to buffer
	LD	A,(DE)		;get another
	RRCA			;align high bits
	RRCA
	RRCA
	RRCA
	CALL	ADJ2		;to buffer
	DEC	E		;less source
	JR	NZ,ADJ1		;go till page
	INC	D		;bump page
	DJNZ	ADJ1		;go till 2 pages
	RET			;return adjusted
;
ADJ2	AND	0FH		;low 4 bits
	LD	(HL),A		;to buffer
	INC	HL		;bump buffer
	RET			;done
;
;	write sector to disk direct
;
WRITE	PUSH	BC		;save
	LD	C,'$'		;get drive #
DRIVE	EQU	$-1
	PUSH	IY		;save
	CALL	@WRSEC		;write the sector
	POP	IY		;restore
	POP	BC		;restore
	RET			;done, return status
;
;	load file direct / no marker interpretation
;
LOAD	LD	HL,BUFFER	;start of buffer
	LD	DE,0		;byte counter
;
LOADLP	CALL	GET		;get a byte
	JR	Z,LOADIT	;go if no error
	CP	EOF		;end of file?
	RET			;return with flags
;
LOADIT	LD	(HL),A		;to buffer
	CP	(HL)		;still there?
	LD	A,35		;memory error
	RET	NZ		;return if error
	INC	HL		;bump buffer
	INC	DE		;bump byte counter
	JR	LOADLP		;go next byte
;
;	load program file into buffer
;
PLOAD	LD	HL,BUFFER	;load it here
	LD	DE,0		;init byte counter
;
PLOADLP	CALL	GET		;fetch a byte
	RET	NZ		;return if error
	DEC	A		;load marker?
	JR	Z,PLOAD1	;yes, go!
	DEC	A		;02 entry marker?
	JR	Z,PLOAD2	;yes, go!
	CP	1EH		;valid remark block?
	JP	NC,FMTERR	;file format error
;
	CALL	GET		;get a byte
	RET	NZ		;error
	LD	B,A		;pass length
PLOAD3	CALL	GET		;get a byte
	RET	NZ		;return if error
	DJNZ	PLOAD3		;go till end
	JR	PLOADLP		;go next block
;
PLOAD1	CALL	GETADR		;get address block
	RET	NZ		;return if error
;
PLOAD1L	CALL	GET		;get a byte
	RET	NZ		;error!
	LD	(HL),A		;to buffer
	CP	(HL)		;still there?
	LD	A,35		;memory error
	RET	NZ		;return if not there!
	INC	HL		;bump buffer
	INC	DE		;bump byte counter
	DJNZ	PLOAD1L		;go till block done
	JR	PLOADLP		;go next block
;
PLOAD2	CALL	GETADR		;get address block
	RET	NZ		;return if error
;
	INC	L		;L = 0?
	DEC	L		;yes?
	RET	Z		;yes, return!
;
;	pad end of buffer
;
	PUSH	HL		;save current buffer
PLOAD5	LD	(HL),0		;load zero
	INC	L		;bump buffer
	JR	NZ,PLOAD5	;go till end of page
	POP	HL		;restore buffer
	RET			;done!
;
;	fetch address block from file
;
GETADR	CALL	GET		;get a byte
	RET	NZ		;return if error
	SUB	2		;less address length
	LD	B,A		;B = length
	CALL	GET		;get lsb address
	RET	NZ		;return if error
	CALL	GET		;get msb address
	RET			;return/discard address
;
GET	PUSH	IY		;save
	PUSH	DE		;save
	LD	DE,DCB		;file DCB
	CALL	@GET		;get a byte from file
	POP	DE		;restore DE
	POP	IY		;and IY
	RET			;return with status
;
;	completed, check for errors
;
FINISH	JR	Z,FINOK		;no error, go!
	OR	0C0H		;set error bits
	CALL	@ERROR		;display error
	LD	HL,INCMSG	;incompleted message
	CALL	@VDLINE		;display error
	JP	GETFILE		;ask filespec again
;
FINOK	LD	HL,FINMSG	;completed OK
	CALL	@VDLINE		;string to video
	JP	LOOP		;go next loop
;
@VIDKEY	PUSH	DE		;save input buffer
	CALL	@VDLINE		;display prompt
	POP	HL		;HL => input buffer
	JP	@KBLINE		;fetch from keyboard
;
EXIT	LD	HL,EXITMSG	;exit message
	CALL	@VDLINE		;display it
	JP	@ABORT		;abort to DOS
;
;##	text area
;
CMD	DEFM	'CMD'		;default extension
;
HELLO	DEFB	HOME		;home cursor
	DEFB	CLS		;clear screen
	DEFM	'SUMAST - Super Utility Master Maker - '
	DEFM	'by Kim Watt - Ver MAX'
	DEFB	LF
	DEFM	'(c)(p) 1983 by Breeze/QSD, Inc. - '
	DEFM	'Dallas, Texas'
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
MENU	DEFM	'A. Boot I            '
	DEFM	'B. Boot III          '
	DEFM	'C. Boot MAX'
	DEFB	LF
	DEFM	'D. 40-Loader I       '
	DEFM	'E. 40-Loader III     '
	DEFM	'F. 40-Loader MAX'
	DEFB	LF
	DEFM	'G. 80-Loader I       '
	DEFM	'H. 80-Loader III     '
	DEFM	'I. 80-Loader MAX'
	DEFB	LF
	DEFM	'J. Patches I         '
	DEFM	'K. Patches III       '
	DEFM	'L. Patches MAX'
	DEFB	LF
	DEFM	'M. Program I         '
	DEFM	'N. Program III       '
	DEFM	'O. Program MAX'
	DEFB	LF
	DEFM	'P. Prepare Diskette  '
	DEFM	'Q. Quit Program'
	DEFB	LF
	DEFB	LF
	DEFM	'Option: '
	DEFB	ETX
;
NAME0	DEFM	'SUBT1'
	DEFB	CR
;
NAME1	DEFM	'SUBT3'
	DEFB	CR
;
NAME2	DEFM	'SUBTM'
	DEFB	CR
;
NAME3	DEFM	'SULD41'
	DEFB	CR
;
NAME4	DEFM	'SULD43'
	DEFB	CR
;
NAME5	DEFM	'SULD4M'
	DEFB	CR
;
NAME6	DEFM	'SULD81'
	DEFB	CR
;
NAME7	DEFM	'SULD83'
	DEFB	CR
;
NAME8	DEFM	'SULD8M'
	DEFB	CR
;
NAME9	DEFM	'SUPATCH1'
	DEFB	CR
;
NAME10	DEFM	'SUPATCH3'
	DEFB	CR
;
NAME11	DEFM	'SUPATCHM'
	DEFB	CR
;
NAME12	DEFM	'SU1'
	DEFB	CR
;
NAME13	DEFM	'SU3'
	DEFB	CR
;
NAME14	DEFM	'SUM'
	DEFB	CR
;
PROMPT	DEFM	'Source Filespec: '
	DEFB	ETX
;
TARGET	DEFM	'Target Drive: '
	DEFB	ETX
;
EXITMSG	DEFM	'Program Terminated'
	DEFB	LF
	DEFB	ETX
;
FINMSG	DEFM	'Function Completed'
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
INCMSG	DEFM	'Function Aborted'
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
;	data area
;
STRING	DC	32,ETX		;keyboard input
DCB	DC	32,ETX		;dcb for file
IOBUFF	DC	256,ETX		;I/O buffer for file
;
PGMEND	EQU	$
DBUFF	EQU	PGMEND&0FF00H
BUFFER	EQU	DBUFF+100H	;first even free page
;
	END	ENTRY
