; suld4m/asm - kjw/bqsd - 02/83
;
; revised 03/09/83 - kjw/dwh
; revised 03/15/83 - kjw
;
	TITLE	'<Super Utility Loader 40 Track MAX>'
;
;	equates
;
BUFFER	EQU	3000H-600H	;end of buff-length
FDC	EQU	07ECH		;FDC command/status
TRACK	EQU	07EDH		;FDC track register
SECTOR	EQU	07EEH		;FDC sector register
XFER	EQU	07EFH		;FDC transfer register
SELFDC	EQU	07D8H		;FDC select register
VLATCH	EQU	07DCH		;$VLATCH
PIOCA	EQU	07FDH		;$PIOCA
CRTREG	EQU	07E0H		;CRT select register
;
ETX	EQU	000H		;end of text marker
DRIVE	EQU	001H		;drive select code
;
	ORG	1800H		;start loader
;
;	head is over track one, read ID marks
;
ENTRY	CALL	SETVID		;program video CRTC
	CALL	MEMTEST		;test memory
	CALL	IDMARKS		;read id marks
	CP	20H		;< 20H?
	JP	C,IERROR	;out of range!
	CP	51H		;> 50H?
	JP	NC,IERROR	;protection error!
;
	CALL	STEPIN		;move head to track 2
;
;	sectors are protected here, check 'em out
;
	CALL	PROTECT		;check protection
;
	CALL	STEPIN		;move head to track 3
	CALL	STEPIN		;move to track 4
	CALL	IDMARKS		;read ID marks 1 time
	SUB	40H		;lowest possible value
	JP	C,IERROR	;go if error
	CP	29H		;max value now
	JP	NC,IERROR	;go if error!
;
;	begin program load here
;
	LD	HL,0		;init buffer
	LD	IY,0		;init checksum
	EXX			;save here
;
LOAD	CALL	BYTEBC		;fetch 2 bytes
	PUSH	BC		;save on stack
	CALL	BYTEBC		;fetch 2 more
	LD	H,B		;pass 'em
	LD	L,C
	POP	BC		;restore counter
;
	LD	A,B		;get bytes
	AND	C		;check for 0000 entry
	JR	NZ,LOAD1	;go if nz
	OR	B		;check for 0000
	OR	C		;any bits at all?
	JP	NZ,LERROR	;go data error
;
;	hl = entry point, verify checksum
;
	PUSH	HL		;save entry
	CALL	BYTEBC		;fetch checksum
	PUSH	IY		;IY = checksum
	POP	HL		;HL = checksum
	OR	A		;clear carry flag
	SBC	HL,BC		;test checksum
	JP	NZ,LERROR	;go checksum error
;
	RET			;go program!
;
LOAD1	INC	A		;A=0?
	JP	NZ,LERROR	;data error!
;
	CALL	BYTEBC		;fetch block length
;
	CALL	BYTE		;fetch checksum byte
	LD	(CODE),A	;save code
	LD	IX,0		;init sector checksum
;
LOADIT	CALL	BYTE		;fetch a byte
	XOR	'$'		;de-code it
CODE	EQU	$-1
	LD	E,A		;pass for checksum
	LD	(HL),A		;to buffer
	CP	(HL)		;still there?
	JP	NZ,MERROR	;nope, memory error
	INC	HL		;bump buffer
	LD	D,0		;DE = checksum
	ADD	IX,DE		;add to sector checksum
	ADD	IY,DE		;add to program checksum
	DEC	BC		;less byte count
	LD	A,B		;any more?
	OR	C		;any bits on?
	JR	NZ,LOADIT	;go if more to do
;
;	check block checksum
;
	CALL	BYTEBC		;fetch a byte
	PUSH	IX		;pass checksum to HL
	POP	HL		;HL = computed checksum
	OR	A		;clear carry
	SBC	HL,BC		;compare
	JP	NZ,LERROR	;checksum error!
	JR	LOAD		;else go next block
;
BYTEBC	CALL	BYTE		;fetch byte
	LD	B,A		;pass MSB
	CALL	BYTE		;fetch another
	LD	C,A		;pass LSB
	RET			;done
;
;	fetch byte from disk
;
BYTE	EXX			;swap back
	LD	A,H		;check for read
	OR	L		;anything?
	JR	NZ,BYTEIN	;yes, in memory
;
;	read in all 6 sectors
;
	LD	E,40H		;init start sector
	LD	HL,BUFFER	;start of buffer
RDLP	CALL	SREAD		;read it
	INC	H		;bump buffer
	LD	A,E		;get sector
	ADD	A,8		;offset to next
	LD	E,A		;put it back
	CP	70H		;40H - 68H?
	JR	C,RDLP		;go till done!
	CALL	STEPIN		;step in a track
	CALL	ADJUST		;adjust buffer order
	LD	HL,BUFFER	;reset buffer
;
BYTEIN	LD	B,(HL)		;get the byte
	INC	HL		;bump buffer
	LD	A,H		;get msb
	CP	30H		;end of buffer?
	JR	C,BYTEOK	;nope, continue
	LD	HL,0		;force read next time
;
BYTEOK	LD	A,B		;get byte
	EXX			;swap back
	RET			;A = byte
;
;	select disk drive
;
SELECT	LD	A,DRIVE		;single density select
	LD	(SELFDC),A	;select drive
	RET			;else done!
;
;	move head in one track
;
STEPIN	CALL	SELECT		;select drive
	LD	A,5BH.XOR.-1	;step in command
	CALL	SLOW		;issue and wait
;
STEPWT	LD	A,(FDC)		;read status
	RRCA			;command pending?
	JR	NC,STEPWT	;wait for it
	RET			;else done!
;
;	read sector on current track
;
SREAD	LD	A,080H.XOR.-1	;FDC read command
	JR	SARD		;go common
;
AREAD	LD	A,0C4H.XOR.-1	;FDC read id command
;
SARD	LD	(RDTYPE),A	;save type of read
;
	LD	A,10		;10 I/O tries
;
READ	EX	AF,AF'		;save # retries
	PUSH	HL		;save buffer
	CALL	READ1		;read the sector
	POP	HL		;restore buffer
	RET	Z		;return if no error
;
	EX	AF,AF'		;get error counter
	DEC	A		;less this pass
	JR	NZ,READ		;go if more
	JP	DERROR		;go disk error
;
READ1	CALL	SELECT		;select drive
	LD	A,E		;get track/sector
	CPL
	LD	(TRACK),A	;to FDC track reg
	LD	(SECTOR),A	;to FDC sector reg
;
	LD	A,'$'		;fetch read command
RDTYPE	EQU	$-1
	CALL	SLOW		;issue and wait
;
READ2	LD	A,(FDC)		;read FDC status
	BIT	1,A		;byte ready?
	JR	Z,READ3		;yes, get it!
	RRCA			;command done?
	JR	NC,READ2	;nope, continue
;
	LD	A,(FDC)		;read status
	PUSH	AF		;save it
	LD	A,0D0H.XOR.-1	;interrupt FDC
	LD	(FDC),A		;clear it
	POP	AF		;restore status
	CPL
	OR	A		;set flags
	RET			;return with status
;
READ3	LD	A,(XFER)	;read FDC byte
	CPL
	LD	(HL),A		;to buffer
	INC	HL		;bump buffer
	JR	READ2		;continue
;
;	issue disk command and wait
;
SLOW	LD	(FDC),A		;issue command
	LD	A,32		;delay time
SLOW1	DEC	A		;less counter
	JR	NZ,SLOW1	;wait for valid status
	RET			;done
;
;	read ID marks from disk
;
IDMARKS	LD	HL,BUFFER	;init address
	CALL	AREAD		;read ID marks
;
	LD	A,(HL)		;get track #
	INC	HL		;bump pointer
	OR	(HL)		;get head #
	INC	HL		;bump buffer
	OR	(HL)		;get sector #
	RET			;return with it
;
;	check protection on diskette
;
PROTECT	LD	HL,BUFFER	;I/O buffer
	LD	A,80H.XOR.-1	;set read command
	LD	(RDTYPE),A	;save it
	LD	E,22H		;sector #
	CALL	READ1		;read it
	CP	18H		;must be NF/CRC error
	JR	NZ,IERROR	;ident error!
;
	LD	E,11H		;sector #
	PUSH	HL		;save buffer
	CALL	READ1		;read it
	POP	HL		;restore buffer
	CP	08H		;must be CRC error
	JR	NZ,IERROR	;go id error
	LD	DE,NAME
	LD	B,NAMEL		;name length
CHECK	LD	A,(DE)		;get a byte
	CP	(HL)		;match?
	JR	NZ,IERROR	;go if not
	INC	HL		;bump pointer
	INC	DE		;bump test string
	DJNZ	CHECK		;check 'em all
;
;	fetch serial # from sector
;
	LD	B,16		;length
	LD	DE,0F000H-16	;save it in topmem
CHECKS	LD	A,(HL)		;get a byte
	XOR	'$'		;correct it
	LD	(DE),A		;pass it
	INC	DE		;bump pointer
	INC	HL		;bump passer
	DJNZ	CHECKS		;go for length
	CALL	GETCOR		;get serial # checksum
	LD	C,A		;save partial
	CALL	GETCOR		;get second half
	RLCA			;align to high bits
	RLCA
	RLCA
	RLCA
	AND	0F0H		;keep 4 only
	OR	C		;combine!
	CP	40H		;<40H?
	JR	NC,$+4		;go if not
	ADD	A,40H		;adjust it
	LD	I,A		;load I register
	RET			;return if OK
;
GETCOR	LD	A,(HL)		;get buffer byte
	INC	HL		;bump pointer
	XOR	'#'		;correct it
	RET			;A = value
;
;	adjust load buffer to correct format
;
ADJUST	LD	HL,BUFFER	;start of buffer
	LD	C,6		;6 pages long
;
ADJLP	PUSH	HL		;save buffer
	CALL	ADJIT		;adjust this page
	POP	HL		;restore buffer
	INC	H		;bump page
	DEC	C		;less this page
	JR	NZ,ADJLP	;go for # pages
	RET			;done!
;
ADJIT	LD	D,H		;pass to DE
	LD	E,L		;DE => start
	DEC	E		;DE => end
	LD	B,80H		;1/2 length
;
SWAP	LD	A,(HL)		;get a byte
	EX	AF,AF'		;save it
	LD	A,(DE)		;get second byte
	LD	(HL),A		;swap with first
	EX	AF,AF'		;get first back
	LD	(DE),A		;swap with second
	DEC	DE		;end -1
	INC	HL		;start +1
	DJNZ	SWAP		;go till end
	RET			;done
;
;	error vectors
;
IERROR	CALL	SELECT		;select drive
	LD	A,0BH.XOR.-1	;restore drive
	CALL	SLOW		;issue command
IERR	LD	A,(FDC)		;read port
	RRCA			;done?
	JR	NC,IERR		;wait for restore
	CALL	STEPIN		;step single track
	JP	ENTRY		;try it again!
;
LERROR	LD	DE,LMSG		;load file format!
	JR	ERROR		;go dummy
;
DERROR	LD	DE,DMSG		;disk error
	JR	ERROR		;go common
;
MERROR	LD	DE,MMSG		;memory error
;
ERROR	LD	HL,0C00H	;start of video
	CALL	PRINT		;display it
	LD	DE,MSG		;error
	CALL	PRINT		;display it
;
HOLD	LD	A,(0840H)	;read keyboard
	RRCA			;enter pressed?
	JR	NC,HOLD		;wait till yes
	XOR	A		;load zero
	LD	(VLATCH),A	;enable ROM
	RST	0		;jp 0000H
;
PRINT	LD	A,(DE)		;get string byte
	OR	A		;end of message
	RET	Z		;yes, done!
	INC	DE		;bump message
	LD	(HL),A		;to video
	INC	HL		;bump video
	JR	PRINT		;go next char
;
;	test all memory
;
MEMTEST	LD	HL,BUFFER	;start free memory
MEMLP	LD	A,-1		;set all bits
	LD	(HL),A		;to memory
	CP	(HL)		;still there?
	JR	NZ,MERROR	;go mem error if not
	INC	A		;clear all bits
	LD	(HL),A		;to memory
	CP	(HL)		;still there?
	JR	NZ,MERROR	;go if not
	INC	HL		;bump pointer
	OR	H		;at 0000H?
	OR	L
	JR	NZ,MEMLP	;go for 48K
	RET			;done, memory OK!
;
;	setup for video CRTC initialization
;
SETVID	LD	B,16		;port count
	LD	HL,CRTTBL+15	;table end
;
SETVLP	LD	A,B		;get register value
	DEC	A		;adjust to rel 0
	LD	(CRTREG),A	;select register
	LD	A,(HL)		;get table entry
	LD	(CRTREG+1),A	;pass parameter
	DEC	HL		;move table pointer
	DJNZ	SETVLP		;for 15 count
;
	LD	A,4		;set bit 2
	LD	(VLATCH),A	;select short chars
	LD	HL,1000H
	LD	D,L		;load DE = 0000H
	LD	E,L
	LD	B,4		;load BC = 400H
	LD	C,L
	LDIR
	LD	A,6		;set 2/1
	LD	(VLATCH),A	;select tall chars
	LD	D,L		;DE = 0000H
	LD	B,4		;BC = 400H
	LDIR
	LD	A,1		;set bit 2
	LD	(VLATCH),A	;select RAM @ 0000H
	RET
;
;	shape definition table for video CRTC
;
CRTTBL	DEFB	77H,40H,59H,06H,15H,00H,10H,13H
	DEFB	00H,0BH,00H,00H,00H,00H,00H,00H
;
DMSG	DEFM	'Disk',ETX
MMSG	DEFM	'Memory',ETX
LMSG	DEFM	'Data',ETX
MSG	DEFM	' Error ',5FH,ETX
;
;	special string to override SU+ special backup
;
NAME	DEFM	'S'.XOR.'*'
	DEFM	'u'.XOR.'*'
	DEFM	'p'.XOR.'*'
	DEFM	'e'.XOR.'*'
	DEFM	'r'.XOR.'*'
	DEFM	' '.XOR.'*'
	DEFM	'U'.XOR.'*'
	DEFM	't'.XOR.'*'
	DEFM	'i'.XOR.'*'
	DEFM	'l'.XOR.'*'
	DEFM	'i'.XOR.'*'
	DEFM	't'.XOR.'*'
	DEFM	'y'.XOR.'*'
	DEFM	' '.XOR.'*'
	DEFM	'+'.XOR.'*'
	DEFM	' '.XOR.'*'
NAMEL	EQU	$-NAME
;
	DEFM	'by Kim Watt & Doug Hogarth'
;
ZZZZZ	EQU	$
	END	ENTRY
