; suforma/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/16/83 - kjw
;
	PAGE
;
;	$SFMTW - standard format without erase
;
SFMTW	XOR	A		;NOP opcode
	LD	(PUT10),A	;enable track write
	LD	(GET10),A	;enable track read
	LD	(STRTRK),A	;starting track #
	INC	A		;load with one
	LD	(FMTYPE),A	;set 'without erase'
	LD	(HASFLAG),A	;disable prompt on data
;
	JR	SFMT2		;go common
;
;	$SFMT - standard disk format
;
SFMT	XOR	A		;init flag
	LD	(FMTYPE),A	;set 'standard fmt'
	LD	(STRTRK),A	;save start track
	LD	(HASFLAG),A	;prompt if disk has data
	CALL	INITGAT		;create a GAT table
;
SFMT2	CALL	GETDRVS		;get multiple drives
	LD	A,(FMTYPE)	;get type flag
	DEC	A		;1 = without erase
	CALL	NZ,GETNMDT	;get name/date/password
;
;	preserve user input information
;
	LD	HL,GATBUFF+0CEH	;start of password
	LD	DE,STRING+20	;save it here
	LD	BC,50		;length to move
	LDIR			;save pass/name/date/auto
;
SFMT5	LD	DE,FMTLOOP	;common looper
	LD	BC,SFMT3	;'repeat' vector
	JP	DRVCOMM		;do all requested drives
;
	PAGE
;
;	$GETDRVS - prompt for multiple drives
;
;	ENT	none
;
;	EXT	bit 3,(DCT+4) set on requested drives
;
GETDRVS	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
GETDVB	CALL	INITDRV		;turn off all drives
	RST	@08		;display prompt
;
	DEFB	EOL		;clear input line
	DEFM	'Drive(s)? '
	DEFB	ETX
;
	LD	B,40		;40 char input
	RST	@10		;fetch from keyboard
DEFU0	LD	IY,DCT0		;drive 0 DCT
	SET	5,(IY+5)	;activate drive
	RET	Z		;nil input, default
	RES	5,(IY+5)	;turn it back off
	LD	DE,0		;D=#drives/E=mask
	JR	GETDLP		;fetch drives
;
SETNSIO	SET	3,E		;non-standard I/O?
	JR	SETDET+2	;continue
;
SETDET	SET	4,E		;set auto detect
	INC	HL		;bump past !
;
GETDLP	CALL	POSHL		;position to input
	JR	Z,GETDVDN	;done, check if anything
;
	CP	'!'		;force a dir determine?
	JR	Z,SETDET	;set if yes
	CP	'#'		;non-standard I/O
	JR	Z,SETNSIO	;continue
;
	CALL	FIGDRV		;evaluate drive input
	JR	C,GETDVB	;invalid, re-prompt
;
	SET	5,(IY+5)	;activate drive
	INC	D		;bump drive counter
	LD	A,(IY+5)	;fetch result
	AND	0E7H		;bits 4/3 off
	OR	E		;combine with special
	LD	(IY+5),A	;update DCT
	LD	E,0		;reset
	JR	GETDLP		;see if more
;
GETDVDN	LD	A,D		;any drives input?
	OR	A		;yes?
	JR	Z,DEFU0		;default, use 0
RET	RET			;else have 'em
;
	PAGE
;
;	$GETNMDT - load name/date/password into GAT
;
GETNMDT	RST	@08		;extra linefeed
;
	DEFB	LF
	DEFB	ETX
;
ANAME	RST	@08		;prompt for name
;
	DEFB	EOL
	DEFM	'Name? '
	DEFB	ETX
;
	LD	B,8		;8 char input
	RST	@10		;get from keyboard
	JR	Z,ANAME1	;nil, get date
;
	PUSH	HL		;save input pointer
	PUSH	BC		;save length
	LD	HL,GATBUFF+0D0H	;where name lies
	PUSH	HL		;save for load
	LD	B,8		;8 chars long
	LD	A,SPACE		;space
	CALL	FILL		;fill it with spaces
	POP	DE		;DE => name @ GAT
	POP	BC		;B = input length
	POP	HL		;HL => user input
;
	LD	C,B		;pass to C
	LD	B,0		;BC = input length
	LDIR			;move into the GAT
;
ANAME1	RST	@08		;another linefeed
;
	DEFB	LF
	DEFB	ETX
;
ADATE	RST	@08		;prompt for date
;
	DEFB	EOL		;clear line
	DEFM	'Date? '
	DEFB	ETX
;
	LD	B,8		;8 chars to input
	RST	@10		;get from keyboard
	JR	Z,ADATE1	;nil, get password
;
	PUSH	HL		;save pointer
	PUSH	BC		;save length
	LD	HL,GATBUFF+0D8H	;where it goes in GAT
	PUSH	HL		;save for load
	LD	B,8		;8 chars
	LD	A,SPACE		;space
	CALL	FILL		;fill field with spaces
	POP	DE		;DE => date in GAT
	POP	BC		;B = length of input
	POP	HL		;HL => user input
;
	LD	C,B		;pass to C
	LD	B,0		;BC = input length
	LDIR			;move date into GAT
;
ADATE1	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
APASS	RST	@08		;display prompt
;
	DEFB	EOL		;clear input line
	DEFM	'Master Password? '
	DEFB	ETX
;
	LD	B,8		;8 char input
	RST	@10		;get from keyboard
	JR	Z,APASS1	;nil, continue
;
	CALL	CODE		;code the password
	LD	(GATBUFF+0CEH),HL	;place into GAT
;
APASS1	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
;	set starting track to be formatted at 0
;
	XOR	A		;track 0
	LD	(STRTRK),A	;save it
;
;	check to see that the directory track in the DCT
;	is within the disk boundary
;
	LD	A,(IY+2)	;directory track
	CP	(IY+1)		;within disk bounds?
	JR	NC,FORCONF	;nope! ask user where
;
ACONF	RST	@08
;
	DEFB	EOL		;clear input line
	DEFM	'Use Configuration? '
	DEFB	ETX
;
	XOR	A		;zero byte
	LD	(STRTRK),A	;start track to 0
;
	LD	B,3		;3 char input
	RST	@10		;get from keyboard
;
ACONFF	CALL	POSHL		;position to first char
	RET	Z		;nil input
	CALL	UCASE		;make it upper
	CP	'N'		;no?
	JR	Z,FORCONF	;prompt for config
;
	CP	'Y'		;yes + prompt on data?
	RET	Z		;yes, done!
;
	CP	'!'		;yes + no prompt on data?
	JR	NZ,ACONF	;invalid, try again!
;
;	no prompting if target diskette has data
;
	LD	A,-1		;flag condition
	LD	(HASFLAG),A	;save the flag
	RET			;done!
;
;	setup loop to prompt user for pertinent
;	data about each requested drive
;
FORCONF	LD	DE,CONFC	;config prompt vector
	LD	BC,RET		;to caller when done
	JP	DRVCOMM		;do all indicated drives
;
CONFC	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DRVASC		;get ascii drive #
	LD	(CONFCD),A	;put into prompt string
;
CONFC1	RST	@08		;display prompt
;
	DEFB	EOL		;clear input line
	DEFM	':'
CONFCD	DEFM	'x Type, Tks, Dir, St Tk? '
	DEFB	ETX
;
;	setup defaults
;
	XOR	A		;starting track to 0
	LD	(STRTRK),A	;save it
	LD	A,(IY+1)	;get track count
	SRL	A		;divide it in half
	LD	(IY+2),A	;directory in middle
;
;	get user input
;
	LD	B,19		;19 char input
	RST	@10		;get from keyboard
;
;	check for dos/disk descriptors
;
	CALL	POSHL		;position to first char
	RET	Z		;nil input
	CALL	CKCONF		;drive configuration?
	JR	C,CONFC1	;error, try again
;
;	check for track count
;
CONFC2	CALL	POSHL		;any more input?
	RET	Z		;nope, return
	CALL	VALUE		;get value
	JR	C,CONFC1	;go if bad
	LD	A,C		;get track count
	CP	2		;less than 2?
	JR	C,CONFC1	;go if yes
	CP	97		;>96?
	JR	NC,CONFC1	;go if yes
	LD	(IY+1),A	;save track count
	CALL	RELTKS		;compute rel tracks
;
;	check for directory track
;
	CALL	POSHL		;any more input?
	JR	Z,CKDIRTK	;check if in bounds
;
	CALL	VALUE		;get numeric entry
	JR	C,CONFC1	;error, ask again
	LD	(IY+2),C	;put into DCT
;
;	check that directory is within disk boundary
;
CKDIRTK	LD	A,(IY+2)	;get directory track
	CP	(IY+1)		;within boundary?
	JR	NC,CONFC1	;to big, ask again
;
;	check for starting track
;
	CALL	POSHL		;any more input?
	RET	Z		;nope, done!
	CALL	VALUE		;fetch numeric entry
	JR	C,CONFC1	;error, ask again
	LD	A,C		;get LSB value
	LD	(STRTRK),A	;save start track
	RET			;done!
;
	PAGE
;
;	$INITGAT - create a nil GAT table in memory
;
INITGAT	LD	HL,GATBUFF	;start of table
;
;	fill the sector with nil bytes
;	00 for TRSDOS double density only
;	FF for all others
;
	LD	B,-1		;fill byte
	LD	A,(IY+7)	;get dos type
	CP	2		;single trs?
	JR	C,IGH		;go if yes
	CP	4		;double trs?
	JR	NC,IGH		;go if no
	INC	B		;set 00
;
IGH	LD	A,B		;get fill byte
	LD	B,0		;set length 256
	CALL	FILL		;fill the table
;
;	move in default name/date/password/etc
;
	LD	HL,DEFGAT	;default information
	LD	DE,GATBUFF+0CBH	;where it goes
	LD	BC,22		;length
	LDIR			;move it in
	CALL	DPASSV		;password 'PASSWORD'
	LD	(GATBUFF+0CEH),HL	;to the GAT
;
;	open up all available tracks
;
	LD	IX,GATBUFF	;start of GAT
	CALL	MNYGRNS		;fetch nil mask byte
	LD	B,(IY+1)	;get relative tracks
	LD	A,(IY+7)	;get dos type
	CP	02		;I DD?
	JR	Z,INTLGT	;go if yes
	CP	03		;trsdos 3?
	JR	NZ,INTGTL	;go if not
INTLGT	LD	A,E		;get mask
	SUB	0C0H		;TRSDOS double den?
	JR	NZ,INTGTL	;go if not
	LD	E,A		;set to nil
;
INTGTL	LD	(IX+00H),E	;load allocation byte
	BIT	3,(IY+6)	;relative engaged?
	JR	NZ,INTGTM	;no lockout table!
	LD	(IX+60H),E	;load lockout byte
INTGTM	INC	IX		;bump table pointer
	DJNZ	INTGTL		;go for track count
;
	JP	SETGAT		;init particulars
;
;	default information for nil GAT table
;	data loaded starting at GAT+0CBH
;
DEFGAT	DEFB	31H		;SUP version #
	DEFW	0000H		;dos-used flags
	DEFW	42E0H		;password 'PASSWORD'
;
FMTNAME	DEFM	'* Data *'	;default format name
FMTDATE	DEFM	'* Disk *'	;default format date
;
	DEFB	CR		;CR to disable AUTO cmd
;
	PAGE
;
;	$FMTLOOP - common looper for standard disk
;		   format and without erase
;
FMTLOOP	CALL	INITGAT		;clear GAT to specifics
	LD	HL,STRING+20	;start of stored data
	LD	DE,GATBUFF+0CEH	;where it goes
	LD	BC,50		;stored length
	LDIR			;re-install it
;
FORMIT	CALL	DSTAT		;check disk status
	RET	NZ		;not ready, skip it!
;
	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
;	try to read boot sector to locate directory
;	to report that the disk has data
;
	LD	A,(IY+6)	;get dos type
	LD	(TEMP1),A	;save it for restore
	LD	DE,0001H	;track 0
	LD	BC,BUFFER	;read data here
	CALL	READ		;read it
	CALL	NZ,TREAD	;reverse density
	CALL	Z,HASDATA	;if read, ask to cont
;
	CALL	RESTORE		;move head to track 0
	RET	NZ		;error, not in system!
	CALL	INTCNT		;clear error counter
	CALL	INTACNT		;clear alt counter
;
	LD	HL,FBUFF	;format buffer
	LD	(FMTBUFF),HL	;for track create/write
	CALL	CLRBUFF		;zero out format buffer
	LD	A,(TEMP1)	;get original config
;
;	the relative sectoring bit MUST be RESET
;	when formatting without erase or the subs
;	that read/write each track would be reading
;	RELATIVE sectors and the data would be in error!
;
	AND	0E7H		;reset relative sectoring
	LD	(IY+6),A	;put it back
;
;	move head to desired start track if non-zero
;
	LD	A,0		;get start track
STRTRK	EQU	$-1
	OR	A		;is it zero?
	JR	Z,FMTST		;yes, go!
;
	LD	D,A		;pass to D
	CALL	SEEK		;seek head to the track
	RET	NZ		;error, abort!
;
;	we must keep track of the position of the
;	head independently of the DCT byte here
;	in case double step is ON
;
FMTST	LD	A,(STRTRK)	;get starting track
	LD	(TEMP0),A	;stash it here
;
;	loop here for each track being formatted
;
FMTLP	RES	1,(IY+5)	;set side 0
	LD	A,(FMTYPE)	;get format type
	DEC	A		;without erase?
	CALL	Z,GET10		;yes, read track
	CALL	BUILD		;create format image
	CALL	SHOFMT		;write track
	RET	NZ		;return if error
	LD	A,(FMTYPE)	;get type again
	DEC	A		;w/o erase?
	CALL	Z,PUT10		;yes, write track
;
	BIT	0,(IY+5)	;2 sides?
	JR	Z,FMTLPZ	;go if not
	SET	1,(IY+5)	;set side 1
	LD	A,0		;get type of format
FMTYPE	EQU	$-1
	DEC	A		;1 = without erase
	CALL	Z,GET10		;if yes, read track
;
	CALL	BUILD		;build a track
	CALL	SHOFMT		;write to disk
	RET	NZ		;error, abort!
;
	LD	A,(FMTYPE)	;get type again
	DEC	A		;without erase?
	CALL	Z,PUT10		;yes, write track
;
;	check for CLEAR key if without erase
;
FMTLPZ	LD	A,(FMTYPE)	;get flag back
	DEC	A		;without erase?
	JR	NZ,NOTWO	;nope, continue
;
	CALL	IFCLEAR		;clear key?
	JR	C,FMTDONV	;go if yes and verify
;
;	check for disk end
;
NOTWO	LD	A,(TEMP0)	;get current relative
	INC	A		;else next track
	LD	(TEMP0),A	;save it again
	CP	(IY+0)		;compare to physical trks
	JR	Z,FMTDONV	;done, verify!
	PUSH	AF		;save it
	CALL	STEPIN		;move head in with 2step
	POP	AF		;get real relative trk
;
	JR	FMTLP		;continue with next track
;
	PAGE
;
;	$FMTDONV - verify diskette after formatting
;		   lockout granules as necessary
;
FMTDONV	LD	A,(TEMP1)	;get stored config
	LD	(IY+6),A	;update DCT
	LD	A,(FMTYPE)	;get format type
	CP	2		;disk backup?
	RET	Z		;yes, don't verify yet
;
	LD	A,(STRTRK)	;get starting track
	LD	D,A
	CALL	FIRSTS		;first sector that track
;
FMTDONL	LD	BC,BUFFER	;I/O buffer
	CALL	SHOVERX		;read it twice
	CALL	NZ,LOKIT	;lockout the gran
	CALL	NEXSEC		;do next sector
	JR	NC,FMTDONL	;do whole disk
;
;	diskette verified, if format without erase
;	prompt for lockout table update
;
	LD	A,(FMTYPE)	;type of format
	CP	1		;without erase?
	JP	Z,FMTWDON	;yes, go!
;
;	if starting track on diskette was non-zero
;	prompt if the directory and boot are to be
;	written back to the disk
;	This option is to allow a diskette track
;	count to easily be extended without endangering
;	the existing boot and directory on the disk
;
	LD	A,(STRTRK)	;get starting track
	OR	A		;zero?
	JR	Z,CONFSK	;yes, just write it out!
	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
AKSHR	RST	@08		;prompt to write it
;
	DEFB	EOL		;clear input line
	DEFM	'Write Directory and Boot? '
	DEFB	ETX
;
	LD	B,3		;3 char input
	RST	@10		;get from keyboard
	JR	Z,CONFSK	;nil, write it out!
	CALL	UCASE		;make input upper case
	CP	'N'		;don't write it?
	RET	Z		;done if not
;
	CP	'Y'		;yes write it?
	JR	NZ,AKSHR	;neither, ask again
;
CONFSK	LD	BC,BUFFER	;use this buffer
	CALL	ZBUFF		;zero it out
	PUSH	BC		;save for a minute
	LD	D,B		;give to DE
	LD	E,C
	LD	HL,NSBOOT	;non-system boot
	LD	BC,NSBOOTL	;length of boot
	LDIR			;move into buffer
	POP	BC		;get buffer back
;
;	insert directory track into boot sector
;
	LD	C,1		;BOOT+1 = Trsdos DD
	LD	A,(IY+7)	;get dos type
	CP	2		;double mod 1?
	JR	Z,CUBP		;yes, go!
	CP	3		;mod 3 DD?
	JR	Z,CUBP		;yes, go!
	INC	C		;adjust to normal locate
CUBP	LD	A,(IY+2)	;get directory track
;
	LD	(BC),A		;put into BOOT
	DEC	BC		;back one
	LD	A,0FEH		;CP opcode
	LD	(BC),A		;to buffer
	CALL	COMPDAT		;get DATA dam
	LD	(WRTYPE),A	;save for sector write
;
	LD	D,0		;D = track zero
	CALL	FIRSTS		;load E with first sector
	PUSH	DE		;save track sector
	LD	BC,BUFFER	;where data is
	PUSH	BC		;save buffer
	RST	@30		;write LOGICAL boot
	LD	E,1		;sector 1
	LD	BC,BUFFER	;I/O buffer
	RST	@30		;write alternate boot
	POP	BC		;restore buffer
	POP	DE		;restore track sector
	LD	A,(IY+6)	;get DCT byte
	PUSH	AF		;save on stack
	RES	3,(IY+6)	;turn off rel sectoring
	RST	@30		;write physical boot
	POP	AF		;restore flags
	LD	(IY+6),A	;update DCT
;
;	allocate the BOOT and DIRECTORY in the GAT
;
	LD	HL,GATBUFF	;GAT buffer
	SET	0,(HL)		;allocate boot sector
;
	PUSH	HL		;save for BC
	LD	L,(IY+2)	;HL => directory GAT byte
	LD	A,(HL)		;get existing byte
	OR	3FH		;all dos's at once
	LD	(HL),A		;directory allocated
	POP	BC		;BC => I/O buffer
;
	CALL	COMPDIR		;compute correct DAM
	LD	(WRTYPE),A	;save for write
	CALL	GETDIR		;load DE with dir start
	RST	@30		;write the GAT sector
;
;	setup the HIT table
;
	LD	BC,BUFFER	;use same buffer
	CALL	ZBUFF		;zero it out
	LD	A,(IY+7)	;get dos type
	CP	02		;dd 1?
	JR	Z,HTNNRM	;yes, go!
	CP	03		;dd 3?
	JR	Z,HTNNRM	;yes, go!
;
HTNRM	LD	A,0A2H		;boot HIT code
	LD	(BC),A
	LD	A,0C4H		;directory HIT code
	INC	C		;bump pointer
	LD	(BC),A		;put in table
	XOR	A		;flag NORMAL directory
	LD	C,A		;BC => buffer start
	JR	WRTHT		;write HIT table out
;
HTNNRM	EXX			;save pointers
	LD	HL,BUFFER+0D0H	;start 'special' gat I
	LD	C,2FH		;length -1
	CP	3		;mod III?
	JR	NZ,HTLHV	;nope, I DD
	LD	L,0E0H		;start 'special' gat III
	LD	C,1FH		;length -1
;
HTLHV	LD	B,0		;BC = length
	LD	D,H		;pass start to DE
	LD	E,L
	INC	DE		;DE = start +1
	LD	(HL),-1		;set to NIL
	LDIR			;fill the extra table
	EXX			;get pointers back
	OR	-1		;set NOT NORMAL directory
;
WRTHT	PUSH	AF		;save flag byte
	CALL	NEXSEC		;move DE => HIT sector
	RST	@30		;write out to disk
	POP	AF		;get type flags back
;
	JR	NZ,WRREST	;zeroes to all remain sec
;
;	write out sector with BOOT/SYS
;
	LD	BC,BUFFER	;clear buffer again
	CALL	ZBUFF		;clear buffer again
;
	PUSH	DE		;save track/sector
	PUSH	BC		;save buffer
	LD	D,B		;pass to DE
	LD	E,C
;
	LD	HL,BOOTENT	;boot dir entry
	LD	BC,20H		;length
	LDIR			;move it in
	POP	BC		;restore buff ptr
	POP	DE		;track/sector back
;
	CALL	NEXSEC		;move to next sector
	RST	@30		;write to disk
;
;	write sector with DIR/SYS
;
	PUSH	DE		;save track/sector
	LD	BC,BUFFER	;reset pointer
	PUSH	BC		;save on stack
	LD	A,D		;get track
	LD	(DIRTKK),A	;put into directory entry
	CALL	MNYGRNS		;load D with # grans/trk
	LD	A,D		;fetch it
	DEC	A		;A = # grans/dir -1
	LD	(DIRTKK+1),A	;put into directory entry
	CALL	GETDIR		;get dir length
	LD	(DIRTKK-2),A	;to directory entry
	LD	D,B		;pass buff start to DE
	LD	E,C
	LD	HL,DIRENT	;DIR/SYS entry
	LD	BC,20H		;length
	LDIR			;move into sector
	POP	BC		;restore buffer
	POP	DE		;restore track/sector
;
	CALL	NEXSEC		;move DE => next sector
	RST	@30		;write it out
;
;	write remaining sector of directory with zeroes
;
WRREST	LD	BC,BUFFER	;reset buffer
	CALL	ZBUFF		;clear the buffer
	INC	E		;advance sector
	RST	@30		;write the sector
	LD	A,(IY+9)	;get highest sector disk
	DEC	A		;adjust for compare
	CP	E		;end of track?
	JR	NC,WRREST	;go more if not!
	BIT	0,(IY+5)	;single side?
	JR	Z,SKPDD		;nope, continue
	PUSH	DE		;save track/sector
	CALL	GETDIR		;A = # dir sectors
	POP	DE		;restore
	CP	E		;at end?
	JR	NZ,WRREST	;go more if not!
;
SKPDD	CALL	SHOCNT		;display error counter
	RST	@08		;message
;
	DEFM	'Granules LOCKED OUT'
	DEFB	ETX
;
	RET			;done, next drive
;
FMTWDON	CALL	SHOCNT		;display counter
	RST	@08		;message
;
	DEFM	'sectors LOST'
	DEFB	ETX
;
	CALL	SHOACNT		;alternate counter
	RST	@08		;message
;
	DEFM	'sectors could NOT be verified'
	DEFB	ETX
;
	JP	UPDIRX		;update directory
;
