; subt3 - kjw/bqsd - 02/83
;
; revised 03/15/83 - kjw
;
	TITLE	'<Super-Utility 3.0 Boot III>'
;
	SUBTTL	'<by Kim Watt - (c)(p) Copyright 1983 Breeze/QSD, Inc. - Dallas, TX>'
;
;	This program will locate at Track 0/Sector 1
;	in double density.  It will read in a rather
;	'unusual' manner the 'true' loader which
;	will reside on track 1, at sectors 50H & 70H
;	The sectors will be have Track/Head/Sector
;	numbers all the same
;
;	equivalences
;
VIDEO	EQU	3C00H		;start of video
VIDLEN	EQU	0400H		;video length
;
NMI	EQU	0E4H		;NMI select latch
FDC	EQU	0F0H		;FDC command/status reg.
TRACK	EQU	0F1H		;FDC track register
SECTOR	EQU	0F2H		;FDC sector register
XFER	EQU	0F3H		;FDC transfer register
SELFDC	EQU	0F4H		;FDC select register
;
DRIVE	EQU	081H		;drive select code
SEEK	EQU	01BH		;seek command
SREAD	EQU	080H		;read command
;
	ORG	4300H		;Mod III loader
;
ENTRY	DI
	LD	A,03H		;for dir kill
;
	IM	1		;interrupt mode 1
	LD	SP,STACK	;reset stack
	CALL	CLS		;clear video
	XOR	A		;load zero
	LD	BC,NMIRET	;disable NMI
	CALL	SETNMI		;setup NMI
;
;	move head to track 1
;
	CALL	SELECT		;select drive
	LD	A,01		;track to seek
	OUT	(XFER),A	;set track 1
	LD	A,SEEK		;get seek command
	CALL	SLOW		;issue command
SEEKWT	CALL	SELECT		;select drive
	RRCA			;command done?
	JR	C,SEEKWT	;wait if not
;
;	all register data loaded via POP's
;
	LD	B,3		;3 sectors to read
;
READER	POP	HL		;I/O buffer
	POP	DE		;track/sector
	PUSH	BC		;save counter
	CALL	READ		;read sector
	POP	BC		;restore count
	DJNZ	READER		;go for count
	RET			;go loader!
;
;	actual read routine
;	return/entry point on stack
;
;	ENT	HL => I/O buffer to use
;		DE = track/sector
;
;	EXT	return made via stack
;		first pass a CALL is on stack
;		last pass, stack overflow fetchs
;		the entry point from init table
;
READ	LD	A,10		;init retry counter
;
READL	PUSH	HL		;save buffer address
	EX	AF,AF'		;save retry count
	CALL	READ1		;try once
	POP	HL		;restore buffer
	RET	Z		;no error, return
	EX	AF,AF'		;get retry counter
	DEC	A		;less this attempt
	JR	NZ,READL	;go if more left
	JR	ERROR		;go disk error!
;
READ1	CALL	SELECT		;select drive 0
	LD	A,E		;get sector
	OUT	(SECTOR),A	;to FDC sector reg
	LD	A,D		;get track
	OUT	(TRACK),A	;to FDC track reg
;
	LD	(SPSAVE),SP	;save stack
	LD	BC,RETNMI	;NMI vector
	LD	A,0C0H		;allow NMI
	CALL	SETNMI		;setup NMI
	LD	C,XFER		;xfer port
	LD	A,SREAD		;read command
	CALL	SLOW		;issue and delay
;
RDL1	IN	A,(FDC)		;read FDC status
	AND	2		;byte ready?
	JR	NZ,RDL3		;go if ready
	JR	RDL1		;else wait
;
RDL2	LD	A,DRIVE.OR.40H	;set wait states
	OUT	(SELFDC),A	;select drive
RDL3	IN	A,(C)		;read the byte
	RRD			;move into buffer
;
	LD	A,DRIVE.OR.40H	;set wait
	OUT	(SELFDC),A	;select drive
	IN	A,(C)		;read the byte
	RRD			;to buffer
	DEC	L		;buffer back
	JR	NZ,RDL2		;go till full
	INC	H		;HL => next buffer addr
	JR	RDL2		;continue
;
RETNMI	XOR	A		;load zero
	LD	BC,NMIRET	;non-disk NMI's
	CALL	SETNMI		;reset NMI's
	LD	SP,$		;reset stack
SPSAVE	EQU	$-2
	IN	A,(FDC)		;read status
	PUSH	AF		;save error code
	LD	A,0D0H		;FDC reset command
	OUT	(FDC),A		;issue reset
	POP	AF		;restore error
	OR	A		;check for error
	RET			;return with Z/NZ status
;
SETNMI	LD	(404AH),BC	;pass interrupt vector
	LD	B,C		;pass lsb
	LD	C,0C3H		;JP opcode
	LD	(4049H),BC	;pass JP opcode
	OUT	(NMI),A		;setup NMI vector
	IN	A,(FDC)		;clear FDC
	RET			;done!
;
;	error vector
;
ERROR	RST	0		;retry again
;
NMIRET	RETN
;
;	issue FDC command and delay for valid status
;
SLOW	OUT	(FDC),A		;issue command
	LD	A,13		;delay count
SLOW1	DEC	A		;less counter
	JR	NZ,SLOW1	;finish
	RET			;else OK to continue
;
;	select drive and return with FDC status
;
SELECT	IN	A,(FDC)		;read FDC
	BIT	7,A		;motor on?
	PUSH	AF		;save FDC status
	LD	A,DRIVE		;drive select code
	OUT	(SELFDC),A	;select reg FDC
	POP	AF		;restore FDC status
	RET	Z		;return if already on
;
	PUSH	BC		;save
	LD	BC,0000H	;motor on delay
DELAY	DEC	BC		;less count
	LD	A,A		;adjust for quicker mod 3
	LD	A,B		;done?
	OR	C		;BC = 0000H?
	JR	NZ,DELAY	;continue if not
	POP	BC		;restore
	JR	SELECT		;re-select drive
;
;	clear video screen
;
CLS	LD	HL,VIDEO	;start video
	LD	DE,VIDEO+1	;start +1
	LD	BC,VIDLEN-1	;length -1
	LD	(HL),' '	;load a space
	LDIR			;load all spaces
	RET			;video clean!
;
;	following is the real stack area
;
	DEFB	'B'<1,'y'<1,' '<1,'K'<1,'i'<1,'m'<1
	DEFB	' '<1,'W'<1,'a'<1,'t'<1,'t'<1
;
;	stack area follows, registers popped here
;
STACK	DEFW	4400H		;buffer address
	DEFW	4040H		;track/sector
	DEFW	4500H		;buffer address
	DEFW	4545H		;track sector
	DEFW	4600H		;buffer
	DEFW	5050H		;track/sect
	DEFW	4400H		;loader entry point!
;
	END	ENTRY
