; subt1 - kjw/bqsd - 02/83
;
; revised 03/16/83 - kjw
;
	TITLE	'<Super-Utility 3.0 Boot I>'
;
	SUBTTL	'<by Kim Watt - (c)(p) Copyright 1983 Breeze/QSD, Inc. - Dallas, TX>'
;
;	This program will locate at Track 0/Sector 0
;	in single density.  It will read in a rather
;	'unusual' manner the 'true' loader which
;	will reside on track 1, at sectors 20H & 40H
;	The sectors will be have Track/Head/Sector
;	numbers all the same
;
;	equivalences
;
VIDEO	EQU	3C00H		;start of video
VIDLEN	EQU	0400H		;length of video
;
FDC	EQU	37ECH		;FDC command/status reg.
TRACK	EQU	37EDH		;FDC track register
SECTOR	EQU	37EEH		;FDC sector register
XFER	EQU	37EFH		;FDC transfer register
SELFDC	EQU	37E1H		;FDC select register
;
DRIVE	EQU	001H		;drive select code
SEEK	EQU	01BH		;seek command
SREAD	EQU	088H		;read command
CLEAR	EQU	0D0H		;clear FDC
;
	ORG	4200H		;Mod I loader
;
ENTRY	DI
	LD	A,03H		;for dir kill
;
	IM	1		;interrupt mode 1
	LD	SP,STACK	;reset stack
	CALL	CLS		;clear video screen
;
;	move head to track 1
;
	CALL	SELECT		;select drive
	LD	A,01		;track to seek
	LD	(XFER),A	;set track 1
	LD	A,SEEK		;get seek command
	CALL	SLOW		;issue command
SEEKWT	CALL	SELECT		;select drive
	RRCA			;command done?
	JR	C,SEEKWT	;wait if not
;
;	all register data loaded via POP's
;
	LD	B,3		;3 sectors to read
;
READER	POP	HL		;get I/O buffer
	POP	DE		;get track/sector
	PUSH	BC		;save loop counter
	CALL	READ		;read the sector
	POP	BC		;get loop
	DJNZ	READER		;go for sector count
	RET			;go loader!
;
;	actual read routine
;	return/entry point on stack
;
;	ENT	HL => I/O buffer to use
;		DE = track/sector (from ID field)
;
;	EXT	return made via stack
;		first pass a CALL is on stack
;		last pass, stack overflow fetchs
;		the entry point from init table
;
READ	LD	A,10		;init retry counter
;
READL	PUSH	HL		;save buffer address
	EX	AF,AF'		;save retry count
	CALL	READ1		;try once
	POP	HL		;restore buffer
	RET	Z		;no error, return
	EX	AF,AF'		;get retry counter
	DEC	A		;less this count
	JR	NZ,READL	;go if more tries left!
	JR	ERROR		;go disk error!
;
READ1	CALL	SELECT		;select drive 0
	LD	A,E		;get sector
	LD	(SECTOR),A	;to FDC sector reg
	LD	A,D		;get track
	LD	(TRACK),A	;to FDC track reg
;
	LD	A,SREAD		;read command
	CALL	SLOW		;issue and delay
;
RDL1	LD	A,(FDC)		;read FDC status
	BIT	1,A		;byte ready?
	JR	NZ,RDL2		;get it if yes
	RRCA			;still in progress?
	JR	C,RDL1		;continue if yes
;
;	command done, fetch status
;
	LD	A,(FDC)		;fetch status
	JR	RDL5		;go exit
;
RDL2	LD	A,(XFER)	;read FDC byte
	RRD			;put into buffer
;
RDL3	LD	A,(FDC)		;read a byte
	BIT	1,A		;byte ready?
	JR	NZ,RDL4		;go if yes
	RRCA			;command pending?
	JR	C,RDL3		;wait if yes
	OR	-1		;else set error!
	JR	RDL5		;go exit
;
RDL4	LD	A,(XFER)	;read FDC byte
	RRD			;move into buffer
	DEC	L		;less buffer
	JR	NZ,RDL1		;go next byte
	INC	H		;else bump MSB
	JR	RDL1		;continue
;
RDL5	PUSH	AF		;save error
	LD	A,0D0H		;FDC reset
	LD	(FDC),A		;issue reset
	POP	AF		;restore error code
	OR	A		;set flags
	RET			;return status
;
;	error vector
;
ERROR	HALT			;re-boot
;
;	issue FDC command and delay for valid status
;
SLOW	LD	(FDC),A		;issue command
	LD	A,10		;delay count
SLOW1	DEC	A		;less count
	JR	NZ,SLOW1	;finish
	RET			;else OK to continue
;
;	select drive and return with FDC status
;
SELECT	LD	A,(FDC)		;read FDC
	BIT	7,A		;motor on?
	PUSH	AF		;save status
	LD	A,DRIVE		;drive select code
	LD	(SELFDC),A	;select reg FDC
	POP	AF		;restore
	RET	Z		;return if already on
;
	PUSH	BC		;save
	LD	BC,0000H	;motor on delay
DELAY	DEC	BC		;less counter
	LD	A,B		;any left?
	OR	C		;BC = 0000H?
	JR	NZ,DELAY	;wait for done
	POP	BC		;restore
	JR	SELECT		;re-select drive
;
;	clear video
;
CLS	LD	HL,VIDEO	;start video
	LD	DE,VIDEO+1	;start +1
	LD	BC,VIDLEN-1	;length -1
	LD	(HL),' '	;load blank
	LDIR			;load all blanks
	RET			;video clean!
;
;	following is the real stack area
;
	DEFB	'B'<1,'y'<1,' '<1,'K'<1,'i'<1,'m'<1
	DEFB	' '<1,'W'<1,'a'<1,'t'<1,'t'<1
;
;	stack area follows, registers popped here
;
STACK	DEFW	4400H		;buffer address
	DEFW	2020H		;track/sector
	DEFW	4500H		;buffer address
	DEFW	2525H		;track sector
	DEFW	4600H		;buffer
	DEFW	3030H		;track/sector
	DEFW	4400H		;loader entry point!
;
	END	ENTRY
