DISK   ; DISK/ASM
 SELECT0	LD	A,D
 	CP	16H
 	LD	A,0
 	JR	C,SELECT1
 	LD	A,20H
 SELECT1	LD	(SELECT2),A
 	LD	A,(DRIV)
 	AND	0FH
 	OR	0
 SELECT2	EQU	$-1
 	OR	0
 DENSITY	EQU	$-1
 	LD	(DRIV),A
 SELECT	IN	A,(0F0H)	;read status
 	AND	80H
 	LD	A,1		;get drive bit
 DRIV	EQU	$-1
 	OUT	(0F4H),A
 	RET	Z
 	PUSH	BC
 	LD	BC,0
 	CALL	60H
 	POP	BC
 	JR	SELECT
 SEEK	CALL	SELECT0	;select drive, set den & precomp
 	CALL	GETTRK	;get track from table
 	OUT	(0F1H),A	;give to FDC
 	JR	NZ,SEEK1	;continue if not track 0
 	CALL	RESTORE		;restore to track 0
 	RET	NZ		;bad, return
 SEEK1	LD	A,0
 STEPFLAG	EQU	$-1
 	OR	A
 	LD	A,D
 	JR	Z,SEEK01
 	SLA	A
 SEEK01	OUT	(0F3H),A	;track to seek
 	LD	A,18H		;seek command
 	CALL	MOVE		;move the head
 	RET	NZ		;bad seek
 	IN	A,(0F1H)
 PUTTRK	PUSH	HL		;save this
 	LD	HL,CTRACK	;current track table
 	PUSH	AF
 	LD	A,0		;get binary drive
 DRIVE	EQU	$-1
 	ADD	A,L		;point to drive
 	LD	L,A
 	POP	AF		;get track back
 	LD	(HL),A		;put in table
 	POP	HL		;restore HL
 	LD	A,E		;set sector register
 	OUT	(0F2H),A
 	LD	A,D
 	OUT	(0F1H),A
 	XOR	A
 	RET		;Z flag set
 RESTORE	LD	A,8	;restore command
 	CALL	MOVE
 	RET	NZ
 	IN	A,(0F0H)
 	CPL
 	BIT	2,A
 	RET
 MOVE	OR	0	;set step speed
 SPEED	EQU	$-1
 	OUT	(0F0H),A	;issue command to FDC
 	CALL	DSKSLO
 MOVEWT	CALL	SELECT		;keep drive on
 	IN	A,(0F0H)	;read status
 	BIT	0,A		;still busy?
 	JR	NZ,MOVEWT	;wait till done
 	AND	18H
 	RET			;Z flag set if OK
 STEPIN	CALL	SELECT
 	LD	A,58H
 	JP	MOVE
 FORMIT	LD	A,(TRACK)
 	OR	A
 	CALL	Z,ZBUFF
 	CP	3
 	CALL	Z,ZBUFF
 	CALL	BUILDTRK
 	XOR	A
 	LD	(DENSITY),A
 	LD	A,(TRACK)
 	LD	D,A
 	CALL	SELECT0
 	IN	A,(0F0H)
 	BIT	6,A
 	RET	NZ
 TRYWRTG	LD	A,5
 	LD	(FCOUNT),A
 TRYGOW	CALL	W0
 	AND	0FCH
 	RET	Z
 	EX	AF,AF'
 	LD	A,0D0H
 	OUT	(0F0H),A
 	LD	A,0
 FCOUNT	EQU	$-1
 	DEC	A
 	LD	(FCOUNT),A
 	JR	NZ,TRYGOW
 	EX	AF,AF'
 	RET
 DSKSLO	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 R1	CALL	SETNMI		;setup return vectors
 	LD	A,80H
 	OUT	(0F0H),A
 	CALL	DSKSLO
 	LD	E,2
 R100	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	E
 	JR	Z,R100
 	INI
 	LD	A,D
 R101	OUT	(0F4H),A
 	INI
 	JR	NZ,R101
 	JR	$
 W1	CALL	SETNMI
 	LD	A,0A0H
 TYPE	EQU	$-1
 W000	OUT	(0F0H),A
 	CALL	DSKSLO
 	LD	E,2
 WR100	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	E
 	JR	Z,WR100
 	OUTI
 	LD	B,60H
 	DJNZ	$
 	DEC	B
 	LD	A,D
 WR101	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WR101
 	JR	$
 BUILDTRK	LD	A,0F7H
 	LD	(CRC1),A
 	LD	(CRC2),A
 	LD	A,(TRACK)
 	OR	A
 	JP	Z,BUILDTK0
 	CP	3
 	JP	Z,BUILDTK0
 	CP	6
 	JP	NC,BUILDTK0
 	PUSH	AF
 	XOR	A
 	LD	(CRC1),A
 	POP	AF
 	CP	4
 	JP	Z,BUILDTK0
 	PUSH	AF
 	LD	A,0F7H
 	LD	(CRC1),A
 	XOR	A
 	LD	(CRC2),A
 	POP	AF
 	CP	5
 	JP	Z,BUILDTK0
 	LD	A,0F7H
 	LD	(CRC1),A
 	LD	(CRC2),A
 	LD	HL,ORDER
 	LD	DE,BUFFER
 FIGBUILD	LD	C,(HL)
 	INC	HL
 	PUSH	DE
 	LD	E,(HL)
 	INC	HL
 	LD	D,(HL)
 	INC	HL
 	EX	DE,HL
 	EX	(SP),HL
 	CALL	MOVEIN
 	LD	(DESVE),DE
 SECLP	CALL	MOVEIN
 	CALL	MOVEIN
 	LD	(HL),0FEH
 	INC	HL
 	LD	A,(TRACK)
 	LD	(HL),A
 	INC	HL
 	LD	(HL),0
 	INC	HL
 	EX	(SP),HL
 	LD	A,(HL)
 	INC	HL
 	EX	(SP),HL
 	LD	(HL),A
 	INC	HL
 	LD	(HL),1
 	INC	HL
 	LD	(HL),0F7H
 CRC1	EQU	$-1
 	INC	HL
 	CALL	MOVEIN
 	CALL	MOVEIN
 	CALL	MOVEIN
 	LD	(HL),0FBH
 	INC	HL
 	LD	A,0
 	CALL	FILL
 	LD	(HL),0F7H
 CRC2	EQU	$-1
 	INC	HL
 	CALL	MOVEIN
 	LD	DE,0
 DESVE	EQU	$-2
 	DEC	C
 	JR	NZ,SECLP
 	INC	SP
 	INC	SP
 	DEC	DE
 	LD	A,(DE)
 	LD	B,62
 	JP	FILL
 ORDER	DB	10
 	DW	ORDERD
 	DB	1FH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 ORDERD	DB	0,5,1,6,2,7,3,8,4,9
 ORDER1	DB	6
 	DW	ORDERD1
 	DB	31,0FFH
 	DB	3,0
 	DB	3,0
 	DB	11,0FFH
 	DB	3,0
 	DB	3,0
 	DB	11,0FFH
 ORDERD1	DB	0,6,2,8,4,10
 ORDER2	DB	6
 	DW	ORDERD2
 	DB	62,4EH
 	DB	12,0
 	DB	3,0F5H
 	DB	22,4EH
 	DB	12,0
 	DB	3,0F5H
 	DB	22,4EH
 ORDERD2	DB	1,5,9,3,7,11
 MOVEIN	LD	A,(DE)
 	INC	DE
 	LD	B,A
 	LD	A,(DE)
 	INC	DE
 FILL	LD	(HL),A
 	INC	HL
 	DJNZ	FILL
 	RET
 READ	LD	A,10
 	LD	(RCOUNT),A
 READGO	PUSH	BC
 	CALL	R1
 	POP	HL
 	AND	9CH
 	RET	Z
 	EX	AF,AF'
 	LD	A,0D0H
 	OUT	(0F0H),A
 	LD	B,H
 	LD	C,L
 	LD	A,0
 RCOUNT	EQU	$-1
 	DEC	A
 	LD	(RCOUNT),A
 	JR	NZ,READGO
 	EX	AF,AF'
 	RET
 WRITE	LD	A,10
 	LD	(WRCOUNT),A
 WRGO	PUSH	BC
 	CALL	W1
 	POP	HL
 	AND	0FCH
 	RET	Z
 	EX	AF,AF'
 	LD	A,0D0H
 	OUT	(0F0H),A
 	LD	B,H
 	LD	C,L
 	LD	A,0
 WRCOUNT	EQU	$-1
 	DEC	A
 	LD	(WRCOUNT),A
 	JR	NZ,WRGO
 	EX	AF,AF'
 	RET
 W0	CALL	SETNMI2
 	LD	E,2
 	LD	B,3
 	LD	A,0F0H
 	LD	HL,BUFFER
 	OUT	(0F0H),A
 	CALL	DSKSLO
 	LD	A,(TRACK)
 	CP	1
 	JR	Z,WW101
 	CP	2
 	JP	NZ,W0SPCL
 WW101	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	B
 	JP	PO,WW101
 	OUTI
 WW102	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	E
 	JR	Z,WW102
 	OUTI
 	LD	A,D
 WW103	OUT	(0F4H),A
 	OUTI
 	JP	WW103
 NMIRET	RETN
 GETTRK	PUSH	HL
 	LD	HL,CTRACK
 	LD	A,(DRIVE)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	POP	HL
 	OR	A
 	RET
 SETNMI	LD	(BUFFSAVE),BC	;save buffer
 	LD	(SECSAVE),DE	;save track/sector
 	LD	H,B		;pass buffer to HL
 	LD	L,C
 	CALL	SEEK		;seek the track
 	RET	NZ		;not found
 SETNMI2	LD	A,(DRIV)	;get drive bit
 	OR	40H		;set wait state
 	LD	D,A		;save here
 	PUSH	HL
 	LD	HL,RETNMI
 	LD	(404AH),HL
 	POP	HL
 	IN	A,(0F0H)	;clear FDC latch
 	LD	BC,0F3H		;set C = data register
 	DI
 	LD	A,0C0H
 	OUT	(0E4H),A
 	XOR	A
 	RET
 RETNMI	POP	HL		;fix the stack
 	XOR	A		;reset NMI
 	OUT	(0E4H),A	;turn it off
 	LD	DE,0		;restore track/sector
 SECSAVE	EQU	$-2
 	LD	BC,0		;restore buffer
 BUFFSAVE	EQU	$-2
 	INC	B		;bump page pointer
 	LD	HL,NMIRET	;return vector now
 	LD	(404AH),HL
 	CALL	DSKSLO
 	IN	A,(0F0H)	;read status
 	LD	(RESULT),A	;save answer
 	EI
 	RET
 ZBUFF	LD	HL,BUFFER
 	LD	DE,BUFFER+1
 	LD	BC,4000H
 	LD	(HL),0
 	DI
 	LDIR
 	EI
 	RET
 BUILDTK0	LD	DE,BUFFER
 	LD	HL,ORDER1
 	CALL	FIGBUILD
 	EX	DE,HL
 	LD	HL,ORDER2
 	JP	FIGBUILD
 W0SPCL	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	B
 	JP	PO,W0SPCL
 	OUTI
 	LD	B,-1
 WS2	LD	A,D
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	E
 	JR	Z,WS2
 	OUTI
 	LD	A,D
 WS3	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS3
 WS4	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS4
 WS40	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS40
 WS41	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS41
 WS42	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS42
 WS43	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS43
 WSS44	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WSS44
 	LD	B,58
 WS5	OUT	(0F4H),A
 	OUTI
 	JR	NZ,WS5
 	SET	7,A
 WS6	OUT	(0F4H),A
 	OUTI
 	JR	WS6
 SETDEN	XOR	A
 	LD	(DENSITY),A
 	LD	A,D
 	CP	1
 	RET	Z
 	CP	2
 	RET	Z
 	LD	A,E
 	RRCA
 	RET	NC
 	LD	A,80H
 	LD	(DENSITY),A
 	RET
 NEXSEC	INC	E
 	XOR	A
 	LD	(SSEC),A
 	LD	A,12
 	LD	(TOPSEC),A
 	LD	A,(MODEL)
 	CP	'C'
 	JR	Z,SECKOK
 	INC	E
 	CP	'A'
 	LD	A,12
 	JR	Z,MOKKOK
 	LD	A,1
 	LD	(SSEC),A
 	LD	A,13
 MOKKOK	LD	(TOPSEC),A
 SECKOK	LD	A,D
 	CP	3
 	JR	NC,HTOPSEC
 ;	CP	1
 ;	JR	C,HTOPSEC
 	LD	A,10
 	LD	(TOPSEC),A
 ;	LD	A,D
 ;	CP	2
 ;	JR	NZ,CNTSX
 ;	LD	A,6
 ;	LD	(TOPSEC),A
 CNTSX	LD	A,0
 	LD	(SSEC),A
 	LD	A,(MODEL)
 	CP	'C'
 	JR	Z,PZLWE
 	DEC	E
 PZLWE	LD	A,D
 	CP	2
 	JR	NZ,HTOPSEC
 	LD	A,(MODEL)
 	CP	'B'
 	JR	NZ,HTOPSEC
 	LD	A,1
 	LD	(SSEC),A
 HTOPSEC	LD	A,E
 	SUB	12
 TOPSEC	EQU	$-1
 	RET	NZ
 	LD	E,0
 SSEC	EQU	$-1
 	INC	D
 	LD	A,D
 	CP	4
 	RET	C
 	CP	6
 	RET	NC
 	LD	D,6
 	RET
