SD456/ ;	*********************************
 ;	*				*
 ;	*   Screen Dump to Disk File	*
 ;	*	     under		*
 ;	*	   NEWDOS/80		*
 ;	*				*
 ;	*	by Ron A. Zajac		*
 ;	*				*
 ;	*********************************
 
 INKEY	EQU	035BH		;Loads ACC w/ current keystroke
 SCREEN	EQU	3C00H		;CRT Memory
 HIMEM1	EQU	4049H		;Mod I     HIMEM
 HIMEM3	EQU	4411H		;Mod III/4 HIMEM
 ENQUE1	EQU	4410H		;Mod I     Enqueue Interrupt
 ENQUE3	EQU	447BH		;Mod III/4 Enqueue Interrupt
 
 	ORG	5200H
 
 LDSTRT	EQU	$
 	LD	A,(54H)			;Check if Mod I or III/4
 	DEC	A
 	JR	Z,HM1			;Go if Model I
 	LD	HL,HIMEM3		;Model III MEM SIZE
 	LD	(HM1+1),HL		;Patch into program
 	LD	(HM2+1),HL
 	LD	HL,ENQUE3		;Mod III Enqueue Routine
 	LD	(ENQ+1),HL		;Patch into program
 
 HM1	LD	HL,(HIMEM1)		;Get MEM SIZE
 	LD	BC,ENDING-DMPSCN	;Get program length
 	OR	A			;Clear carry flag
 	PUSH	HL
 	SBC	HL,BC			;HL <-- new MEM SIZE
 HM2	LD	(HIMEM1),HL		;Posit new MEM SIZE
 	LD	DE,ENDING-1		;DE <-- Rev. Source
 	POP	HL			;HL <-- Destin.
 	EX	DE,HL			;HL=Source / DE=Destin.
 	LDDR
 	INC	DE			;DE <-- Start Program
 
 	LD	HL,PT1-DMPSCN+1
 	CALL	REPLCE
 	LD	HL,PT2-DMPSCN+1
 	CALL	REPLCE
 	LD	HL,PT3-DMPSCN+1
 	CALL	REPLCE
 	LD	HL,PT4-DMPSCN+1
 	CALL	REPLCE
 	LD	HL,ERROR-DMPSCN+1
 	CALL	REPLCE
 	LD	HL,PT6-DMPSCN+1
 	CALL	REPLCE
 	LD	HL,NOFILE-DMPSCN+1
 	CALL	REPLCE
 
 ENQ	CALL	ENQUE1		;Enqueue "456" scan/dump
 	LD	HL,ENTMSS
 	JP	4467H		;Send opening mess. to display,
 ;				 Exit to DOS
 
 REPLCE	ADD	HL,DE		;Get address of label
 	LD	C,(HL)
 	INC	HL
 	LD	B,(HL)		;BC <-- displacement
 	PUSH	DE		;Save start address
 	EX	DE,HL
 	ADD	HL,BC		;Add Start to Displacement
 	EX	DE,HL		;Get address into HL
 	LD	(HL),D
 	DEC	HL
 	LD	(HL),E		;(HL) <-- new LD/JP vector
 	POP	DE		;Restore Start address
 
 	RET
 
 ENTMSS	EQU	$
 
 ;	This is the "SD456" banner message graphics --
 
 	DEFB	10
 	DEFB	32,32,32,32,32,32,32,32,32,32,32,32,144,164
 	DEFB	137,144,32,32,32,152,151,131,137,32,154,151
 	DEFB	131,169,144,32,32,160,174,32,32,160,175,131
 	DEFB	131,129,32,32,160,158,129,32,32,32,152,161
 	DEFB	132,144
 	DEFB	10
 	DEFB	32,32,32,32,32,32,32,32,32,32,132,153,162
 	DEFB	132,153,162,132,32,32,137,178,137,144,32,149
 	DEFB	149,32,149,149,32,152,171,170,32,32,130,141
 	DEFB	172,144,32,32,184,183,176,32,32,32,166,136
 	DEFB	145,166,136,145,132
 	DEFB	10
 	DEFB	32,32,32,32,32,32,32,32,32,32,32,32,129,134
 	DEFB	152,129,32,32,136,176,176,157,129,32,189,177
 	DEFB	176,135,32,130,131,171,150,131,32,164,176,186
 	DEFB	134,32,138,181,176,186,133,32,32,32,137,146
 	DEFB	132,129
 	DEFB	10,10
 	DEFM	'                Screen Dump Utility is INSTALLED!'
 	DEFB	10
 	DEFM	'               Press the "456" keys simultaneously'
 	DEFB	10
 	DEFM	'                     and follow the prompts.'
 	DEFB	10
 	DEFM	'                 (created 1984 by Ron A. Zajac)'
 	DEFB	10,13
 
 
 OFST	EQU	$
 DMPSCN	EQU	$
 
 	DEFW	0	;Used by Enqueue ("forward pointer")
 	DEFB	1	;25ms between invocations
 	DEFB	1	;Count-down byte
 
 	PUSH	AF
 	LD	A,(3810H)	;"01234567" Keyboard Matrix
 	XOR	70H		;Test "456"
 	JR	Z,DUMPIT	;If Not Zero, Forget it
 	POP	AF
 	RET
 
 DUMPIT	PUSH	BC
 	PUSH	DE
 	PUSH	HL		;Save Program Status
 
 	LD	HL,3FC0H	;Last Line of CRT
 PT1	LD	DE,LSTBUF-OFST	;Last Line Buffer
 	LD	BC,40H		;Length of CRT Line
 	PUSH	HL
 	PUSH	BC
 	LDIR			;Hold on to it
 	POP	BC
 	POP	HL
 	EX	DE,HL		;Set up for prompt line
 	LDIR
 
 	LD	BC,100
 	CALL	0060H		;Delay for Keybounce
 
 	LD	HL,TYPEIN-TPPRMT+3FC0H	;CRT char. insert loc.
 	LD	B,30H		;Cursor Blink Count
 	LD	C,ERRMES-TYPEIN-1	;C <-- MAX char. entry
 	LD	E,0		;E <-- character entry count
 
 	PUSH	HL		;Hold CRT position
 
 KEYLOP	CALL	INKEY		;Get key
 	OR	A
 	JR	Z,CONT
 	CP	8		;Left arrow
 	JR	Z,BACKSP
 	CP	13		;ENTER key
 	JR	Z,DEXIT
 	PUSH	AF
 	LD	A,E
 	CP	C
 	JR	Z,CONT-1	;Pop AF before continuing
 	POP	AF
 	CP	'.'
 	JR	C,CONT
 	CP	'z'+1
 	JR	NC,CONT
 	CP	'a'
 	JR	C,PROC
 	AND	5FH		;Mask bit 5 to UPPER CASE
 
 PROC	LD	(HL),A
 	INC	HL
 	INC	E
 	JR	CONT
 
 BACKSP	LD	A,E
 	OR	A
 	JR	Z,CONT
 	DEC	E
 
 	LD	(HL),' '
 	DEC	HL
 	JR	CONT
 
 	POP	AF
 
 CONT	DJNZ	KEYLOP
 
 	LD	A,(HL)
 	CP	086H
 	JR	Z,NUNDER
 	LD	A,086H		;Cursor character
 	JR	INSTAL
 NUNDER	LD	A,089H		;Flip pixels
 INSTAL	LD	(HL),A
 	LD	B,30H
 	JR	KEYLOP
 
 DEXIT	EQU	$
 	POP	HL		;Get back CRT position
 	LD	A,E
 	OR	A		;Test for no characters
 	JR	Z,NOFILE	;No filespec -- EXIT w/o Disk
 	LD	C,A
 	LD	B,0		;BC <-- Characters to move
 PT2	LD	DE,DCB-OFST
 	PUSH	BC
 	PUSH	DE		;Hold onto DCB
 	LDIR
 	EX	DE,HL
 	LD	(HL),3		;Posit Terminator
 PT3	LD	HL,LSTBUF-OFST
 	LD	DE,3FC0H
 	LD	BC,40H		;Set up to restore bottom line
 	LDIR			;Restore it
 	POP	DE		;Restore DCB
 	POP	BC		;Restore B=0
 PT4	LD	HL,BUFFER-OFST
 	CALL	4420H		;Open New or Existing File
 	JR	Z,NOERR
 
 ERROR	LD	HL,ERRMES-OFST
 	LD	DE,3FC0H
 	LD	BC,40H		;Set up Error Message
 	LDIR			;Move it in
 
 ERRLOP	CALL	INKEY
 	CP	13
 	JR	NZ,ERRLOP	;If no <ENTER> keep looking
 	JR	NOFILE
 
 NOERR	LD	HL,SCREEN	;Set up for dump
 PT6	LD	DE,DCB-OFST
 	LD	C,10H		;CRT Lines to write
 
 LINLP1	LD	B,40H		;Line Characters to write
 
 LINLP2	LD	A,(HL)
 	INC	HL
 	CALL	001BH		;Write Byte to Disk File
 
 	DJNZ	LINLP2
 
 	LD	A,13
 	CALL	001BH		;Write Carriage Return to File
 
 	DEC	C
 	JR	NZ,LINLP1	;Set up for next line
 
 	XOR	A		;Zero ACC
 	CALL	001BH		;Write Zero to File
 
 	CALL	4428H		;Close Dump File
 	JR	NZ,ERROR
 
 NOFILE	LD	HL,LSTBUF-OFST
 	LD	DE,3FC0H
 	LD	BC,40H		;Set up to restore bottom line
 	LDIR			;Restore it
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF		;Get back status
 
 	RET			;Return to task
 
 DCB	DEFS	20H
 BUFFER	DEFS	100H
 LSTBUF	DEFM	'                                '
 	DEFM	'                                '
 TPPRMT	DEFM	'   Dump Filespec ( <ENTER> to abort ) ==>'
 TYPEIN	DEFM	'                       '
 ERRMES	DEFM	'   DISK ERROR:  Press <ENTER> to'
 	DEFM	' continue . . .                 '
 
 ENDING	EQU	$
 	END	LDSTRT
