QUIK   ;		Process DUAL keyboard	02/16/85
 
 	ORG	5200H		;Code is relocatable
 
 ROW1	EQU	01H		;LSB of Keyboard Row ONE
 ROW2	EQU	02H		;LSB of Keyboard Row TWO
 ROW3	EQU	04H		;LSB of Keyboard Row THREE
 ROW4	EQU	08H		;LSB of Keyboard Row FOUR
 ROW5	EQU	10H		;LSB of Keyboard Row FIVE
 ROW6	EQU	20H		;LSB of Keyboard Row SIX
 ROW7	EQU	40H		;LSB of Keyboard Row SEVEN
 
 P1$UP1	EQU	00100000N	;E - @3801H
 P1$DN1	EQU	00000001N	;X - @3808H
 P1$DN2	EQU	00001000N	;C - @3801H
 P1$DN3	EQU	00010000N	;D - @3801H
 P1$LF1	EQU	00001000N	;S - @3804H
 P1$RT1	EQU	01000000N	;F - @3801H
 P1$WP1	EQU	00001000N	;3 - @3810H
 P1$WP2	EQU	00010000N	;4 - @3810H
 P1$PAU	EQU	10000000N	;  - @3840H
 
 P2$UP1	EQU	00000010N	;I - @3802H
 P2$DN1	EQU	00100000N	;M - @3802H
 P2$DN2	EQU	00010000N	;, - @3820H
 P2$DN3	EQU	00001000N	;K - @3802H
 P2$LF1	EQU	00000100N	;J - @3802H
 P2$RT1	EQU	00010000N	;L - @3802H
 P2$WP1	EQU	00000001N	;8 - @3820H
 P2$WP2	EQU	00000010N	;9 - @3820H
 P2$PAU	EQU	10000000N	;  - @3840H
 
 HLLOAD	EQU	0A7FH
 HLSAVE	EQU	0A9AH
 WHERE	EQU	0BH		;PC ==> HL
 
 ENTRY	EQU	$
 
 	CALL	HLLOAD
 	PUSH	HL		;Save address of array
 
 	CALL	WHERE
 	JR	EXEC
 
 ;	Note the clock orientation of the movement codes:
 
 ;				4
 ;				|
 ;			 3  --	+  --  1
 ;				|
 ;				2	Also, 5 is WARP
 
 TABLE	DEFB	ROW1,P1$UP1,4
 	DEFB	ROW4,P1$DN1,2
 	DEFB	ROW1,P1$DN2,2
 	DEFB	ROW1,P1$DN3,2
 	DEFB	ROW3,P1$LF1,3
 	DEFB	ROW1,P1$RT1,1
 	DEFB	ROW5,P1$WP1,5
 	DEFB	ROW5,P1$WP2,5
 
 	DEFB	ROW2,P2$UP1,4
 	DEFB	ROW2,P2$DN1,2
 	DEFB	ROW6,P2$DN2,2
 	DEFB	ROW2,P2$DN3,2
 	DEFB	ROW2,P2$LF1,3
 	DEFB	ROW2,P2$RT1,1
 	DEFB	ROW6,P2$WP1,5
 	DEFB	ROW6,P2$WP2,5
 
 EXEC	PUSH	HL
 	POP	IX		;IX points to TABLE-2
 	LD	B,2		;2 tables to process
 
 LOOP1	LD	C,8		;8 key entries/table
 	LD	E,0
 
 LOOP2	LD	L,(IX+2)	;LSB of key matrix
 	LD	H,38H		;MSB of key matrix
 	LD	A,(HL)		;Get key char
 	AND	(IX+3)		;Use bit mask
 	LD	A,(IX+4)	;Get movement code
 	INC	IX
 	INC	IX
 	INC	IX		;Point to next key entry
 	JR	Z,CHEKC		;If no key pressed, dont xfer
 	LD	E,A		;xfer
 
 CHEKC	DEC	C
 	JR	NZ,LOOP2	;Check each key entry
 
 	POP	HL		;Get back array VARPTR
 	LD	A,E		;Posit key response
 	OR	A		;*
 	JR	Z,CHEKB		;*
 	LD	(HL),A
 	INC	HL
 	XOR	A
 	LD	(HL),A
 	DEC	HL
 ;			Omit * lines for INKEY$-like function
 CHEKB	INC	HL
 	INC	HL		;Next integer array element
 	PUSH	HL
 	DJNZ	LOOP1		;Process both tables
 
 	POP	HL		;Clean stack
 	LD	A,(3840H)	;Key SPACE BAR address
 	CP	10000000N	;Check for space bar
 	JP	NZ,HLSAVE	;If not, don't pause
 
 	LD	(HL),-1		;Pause flag
 	JP	HLSAVE
 	END
