;**************************************************************
;	Program to make the time clock work @ 4mhz under LDOS 5.1.4
;	Gary Godfrey			30 January 1985
;	modifications for EDAS and Series 1 EDTASM by --jjkd--
;**************************************************************
;	Model III Addresses
SFLAG$	EQU	442BH	;system bit flag
HIGH$	EQU	4411H	;pointer to top of free memory
CLKVEC	EQU	4013H	;interrupt vector storage
CLKCNT	EQU	4216H	;RTC count down storage
@DSPLY	EQU	4467H		; display message string
@EXIT	EQU	402DH	;normal return to DOS
;
	ORG	5200H
;
START	EQU	$
	LD	HL,SIGNON
	CALL	@DSPLY
	LD	HL,(CLKVEC)	;get clock vector
	LD	(RETURN+1),HL	;where to jump out
	LD	HL,(HIGH$)	;p/u HIGH$
	LD	(OLDHIGH),HL	;put old HIGH$ in header
	LD	DE,ENDC-DRIVER
	OR	A		; clear carry flag
	SBC	HL,DE		;move down HIGH$
	LD	(HIGH$),HL	;set new HIGH$
	INC	HL
	EX	DE,HL
	PUSH	DE		;save start of patch
	LD	HL,DRIVER	;start
	LD	BC,ENDC-DRIVER	;length
	LDIR			;move!
	POP	HL		;restore start of patch
	LD	(CLKVEC),HL	;new vector
	JP	@EXIT		;return to DOS
;
;	The actual clock driver
;
DRIVER	JR	NCLK		;jump around header
OLDHIGH	DEFW	0		;old HIGH$
	DEFB	6		; length of name
	DEFM	'CLKFIX'
NCLK	PUSH	AF
	LD	A,(CLKCNT)	;get counter
	CP	80H+1DH		;time to reset double flag?
	JR	NZ,NOUP		;jump no
	AND	7FH		;set it up for normal RTC rtn
	LD	(CLKCNT),A
NOUP	CP	1EH		;was it just loaded?
	JR	NZ,NOCLK	;no, don't reload
	LD	A,1EH*2+80H	;load with double value
	LD	(CLKCNT),A	;and store
NOCLK	POP	AF
RETURN	JP	0		;keep going
ENDC	EQU	$
;
SIGNON	DEFM	'Gary Godfrey'
	DEFB	27H
	DEFM	's RTC filter program installed'
	DEFB	0AH
	DEFB	0DH
	END	START
