RTCZAP ;*****************************************************
 ;*      NEWDOS/80 ZAP FOR REALTIME CLOCK             *
 ;*   INSTALL INTO LAST SECTOR ON SYS0/SYS            *
 ;*           BY DAVID KENNEDY                        *
 ;*****************************************************
 CONTRL EQU     20H     ;CONTROL REG
 SECLOC EQU     4041H   ;SECONDS STORAGE LOC.
 ;****************************************************
 ;*      DATE,TIME INPUT TO RAM BUFFER 4041-4046     *
 ;****************************************************
        ORG     50E6H           ;START OF PATCH.
 START  AND     L               ;CLEAR
        LD      A,20            ;TAPE
        OUT     (0FFH),A        ;LATCH.
        DI                      ;DISABLE INTERRUPTS.
        IN      A,(22H)         ;CHECK
        CP      255             ;CLOCK IS
        JR      Z,GO            ;CONNECTED.
        LD      BC,0F22H        ;LOAD COUNT AND PORT 22.
        LD      HL,SECLOC       ;LOAD SECONDS TABLE.
        CALL    GETTIM          ;GET VALUE.
        LD      (HL),A          ;LOAD SECONDS.
        INC     HL              ;NEXT LOCATION.
        CALL    GETTIM          ;GET VALUE.
        LD      (HL),A          ;LOAD MINUTES.
        INC     HL              ;NEXT LOCATION.
        CALL    GETTIM          ;GET VALUE.
        LD      (HL),A          ;LOAD HOURS.
        INC     HL              ;NEXT VALUE.
        INC     HL              ;NEXT VALUE.
        CALL    GETTIM          ;GET VALUE.
        LD      (HL),A          ;LOAD DAY.
        INC     HL              ;NEXT VALUE.
        CALL    GETTIM          ;GET VALUE.
        LD      (HL),A          ;LOAD MONTH.
        DEC     HL
        DEC     HL
        CALL    GETTIM          ;GET VALUE.
        LD      (HL),A          ;LOAD YEAR.
 GO     EI                      ;ENABLE INERRUPTS.
        JP      4D00H           ;GO DOS.
 ;*****************************************************
 ;*              READ CLOCK REGISTERS.                *
 ;*****************************************************
 GETTIM IN      A,(CONTRL)      ;CHECK FOR
        BIT     3,A             ;CLOCK IS
        JR      NZ,GETTIM       ;READY.
        IN      A,(C)           ;READ VALUE IN.
        IN      A,(C)           ;MAKE SURE.
        AND     B               ;ZERO HIGH BITS.
        LD      D,A             ;SAVE VALUE.
        INC     C               ;NEXT PORT.
        IN      A,(C)           ;READ IN VALUE.
        IN      A,(C)           ;MAKE SURE.
        AND     B               ;ZERO HIGH BITS.
        RLCA                    ;VALUE TIMES 2.
        INC     C               ;NEXT PORT.
        LD      E,A             ;SAVE VALUE.
        RLCA                    ;VALUE TIMES 2.
        RLCA                    ;VALUE TIMES 4.
        ADD     A,E             ;ADD VALUES.
        ADD     A,D             ;ADD AGAIN.
        RET
        END     START
