RTCSTR ;***************************************************
 ;*               REAL TIME CLOCK                   *
 ;*         SETTING AND READING ROUTINE             *
 ;*               BY DAVID KENNEDY                  *
 ;***************************************************
 ;
 CRSTOP EQU     3D22H   ;CURSOR POSITION +2
 CURPOS EQU     4020H   ;CURSOR POSITION
 CLEAR  EQU     01C9H   ;CLEAR SCREEN
 SCREEN EQU     3C00H
 DODCB  EQU     401DH   ;VIDEO D.C.B
 CONTRL EQU     20H     ;CLOCK CONTROL REDG.
        ORG     6000H
 ;***************************************************
 ;*           WRITE SCREEN MESSAGES                 *
 ;***************************************************
 START  DI                      ;DISABLE INTERRUPTS.
        LD      SP,START        ;LOAD STACK POINTER.
        CALL    CLEAR           ;CLEAR SCREEN.
        LD      HL,SCREEN+80    ;SCREEN LOCATION
        LD      (CURPOS),HL     ;LOAD CURSOR POS.
        LD      HL,MESG1        ;GET MESSAGE
        CALL    VIDEO           ;PUT ONTO SCREEN
        LD      HL,SCREEN+151   ;N
        LD      (CURPOS),HL     ;E
        LD      HL,MESG2        ;X
        CALL    VIDEO           ;T
        LD      HL,SCREEN+208
        PUSH    HL              ;SAVE LOCATION
        LD      (CURPOS),HL     ;LOAD CURSOR.
        LD      HL,MESG3        ;LOAD MESSAGE.
        CALL    VIDEO           ;PUT ON SCREEN.
 LOOP   CALL    2BH             ;CALL KEYBOARD
        CP      'R'             ;CHECK FOR "R"
        JP      Z,READ          ;GO READ
        CP      'W'             ;CHECK FOR "W"
        JR      NZ,LOOP         ;LOOP IF NOT WRITE
        LD      HL,SCREEN+203   ;SCREEN LOCATION.
        PUSH    HL              ;SAVE LOCATION.
        LD      (CURPOS),HL     ;LOAD CURSOR.
        LD      HL,MESG4        ;LOAD MESSAGE.
        CALL    VIDEO           ;LOAD SCREEN.
        LD      HL,CRSTOP       ;SCREEN POSITION.
        LD      (CURPOS),HL     ;LOAD CURSOR.
        LD      A,176           ;CURSOR CHARACTER.
        LD      (DODCB+5),A     ;LOAD D.C.B.
        IM      1               ;MODE I INTERRUPTS.
        EI                      ;INABLE INTERRUPTS.
        LD      A,'>'           ;LOAD ">".
 LOOP1  CALL    33H             ;DISPLAY IT.
 LOOP2  CALL    2BH             ;CALL KEYBOARD.
        CP      08H             ;BACKSPACE.
        JR      Z,BSPACE        ;GO BACKSPACE.
        CP      18H             ;ERASE
        JR      Z,ERASE         ;GO ERASE.
        CP      0DH             ;ENTER.
        JP      Z,ENTER         ;GO ENTER.
 SAVE   EQU     $-2             ;ENTER1 JUMP.
        CP      '/'             ;COMPARE FOR "/".
        JR      C,LOOP2         ;LOOP "/"OR LESS.
        CP      ';'             ;COMPARE FOR ";".
        JR      NC,LOOP2        ;LOOP ";"OR GREATER.
        JR      LOOP1           ;GO WITH NUMBER.
 ;***************************************************
 ;*              BACKSPACE CHARACTER.               *
 ;***************************************************
 BSPACE LD      HL,(CURPOS)     ;CURSOR LOCATION.
        DEC     HL
        LD      A,'>'           ;LOAD ">".
        CP      (HL)            ;COMPARE SAME.
        JR      Z,LOOP2         ;IF SO LOOP.
        LD      A,08H           ;LOAD BACKSPACE.
        JR      LOOP1           ;LOOP BACK.
 ;***************************************************
 ;*            ERASE LINE ROUTINE.                  *
 ;***************************************************
 ERASE  LD      HL,CRSTOP+1     ;LOAD HL 3D23H.
        LD      (CURPOS),HL     ;LOAD CURSOR LOC.
        LD      A,1FH           ;ERASE FROM CURSOR ON.
        JR      LOOP1           ;GO DO IT.
 ;***************************************************
 ;*           ENTER DAY MONTH YEAR.                 *
 ;***************************************************
 ENTER  LD      HL,CRSTOP+3     ;LOAD HL 3D25H
        LD      A,'/'           ;LOAD "/".
        CP      (HL)            ;COMPARE SAME.
        JR      NZ,ERASE        ;ERASE IF NOT.
        LD      HL,CRSTOP+6     ;LOAD HL 3D28H.
        CP      (HL)            ;COMPARE "/".
        JR      NZ,ERASE        ;ERASE IF NOT.
        LD      HL,TABLE        ;LOAD STORAGE.
        LD      BC,15           ;COUNT.
 LOOP3  LD      (HL),0          ;ZERO STORAGE.
        INC     HL              ;NEXT LOCATION.
        DEC     BC              ;DEC. COUNT.
        LD      A,C             ;SAVE COUNT.
        OR      C               ;COMPARE FOR "0".
        JR      NZ,LOOP3        ;RETURN IF NOT.
        LD      (HL),2          ;LOAD CONTROL RED.
        LD      A,0FH           ;TURN OFF CURSOR.
        CALL    33H             ;PRINT IT.
        LD      HL,CRSTOP+7     ;LOAD HL 3D29H.
        LD      BC,TABLE+2      ;LOAD TENS YEARS.
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        INC     HL
        INC     BC
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        LD      HL,CRSTOP+4     ;LOAD HL 3D26H.
        INC     BC
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        INC     HL
        INC     BC
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        INC     BC
        LD      HL,CRSTOP+1     ;LOAD HL 3D23H
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        INC     HL
        INC     BC
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        POP     HL              ;SCREEN LOCATION.
        PUSH    BC              ;SAVE TABLE LOC.
        LD      (CURPOS),HL     ;LOAD CURSOR.
        LD      HL,MESG7        ;GET MESSAGE.
        CALL    VIDEO           ;PRINT IT.
        LD      HL,ENTER1       ;LOAD TIME.
        LD      (SAVE),HL       ;SAVE NEW JUMP.
        LD      HL,CRSTOP+1     ;LOAD HL 3D23H.
        LD      (CURPOS),HL     ;LOAD CURSOR.
        LD      A,0EH           ;TURN ON
        CALL    33H             ;CURSOR.
        JP      ERASE
 ;***************************************************
 ;*               TIME ROUTINE.                     *
 ;***************************************************
 ENTER1 LD      HL,CRSTOP+3     ;LOAD HL 3D25H.
        LD      A,':'           ;LOAD ":".
        CP      (HL)            ;COMPARE FOR ":".
        JP      NZ,ERASE        ;GO IF NOT
        LD      HL,CRSTOP+1     ;LOAD HL 3D23H.
        POP     BC              ;POP TABLE COUNT.
        INC     BC
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        INC     HL
        INC     BC
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        INC     HL
        INC     HL
        INC     BC
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        INC     HL
        INC     BC
        LD      A,(HL)          ;GET CHARACTER.
        LD      (BC),A          ;LOAD TABLE.
        LD      A,0FH           ;TURN OF
        CALL    33H             ;CURSOR.
        POP     HL              ;SCREEN LOCATION.
        LD      (CURPOS),HL     ;LOAD CURSOR.
        LD      A,1DH           ;POSITION CURSOR
        CALL    33H             ;END OF LINE.
        LD      A,1FH           ;ERASE FROM CURSOR
        CALL    33H             ;TO END OF FRAME.
        LD      HL,SCREEN+214   ;SCREEN LOCATION.
        LD      (CURPOS),HL     ;LOAD CURSOR POS.
        LD      HL,MESG8        ;GET MESSAGE.
        CALL    VIDEO           ;PRINT MESSAGE.
        LD      A,0EH           ;TURN ON CURSOR.
        CALL    33H             ;DO IT.
        LD      HL,TABLE        ;LOAD TABLE.
        PUSH    HL              ;SAVE LOCATION.
 LOOP4  CALL    2BH             ;CALL KEYBOARD.
        CP      'A'
        JR      Z,LOOP5         ;IF "A" GO.
        CP      'P'
        JR      NZ,LOOP4        ;IF NOT "P" GO.
        SET     1,(HL)          ;SET AM PM BIT.
 LOOP5  CALL    33H             ;LOAD SCREEN AM PM.
        LD      A,0FH           ;TURN OF CURSOR.
        CALL    33H             ;DO IT.
        LD      HL,SCREEN+260   ;SCREEN LOCATION.
        LD      (CURPOS),HL     ;LOAD CURSOR
        LD      HL,MESG9        ;GET MESSAGE.
        CALL    VIDEO           ;PRINT IT.
        LD      A,0EH           ;TURN ON CURSOR.
        CALL    33H             ;DO IT
        POP     HL              ;TABLE LOCATION.
 LOOP6  CALL    2BH             ;CALL KEYBOARD.
        CP      '0'             ;COMPARE FOR "0".
        JR      C,LOOP6         ;LOOP IF BELOW "0".
        CP      '4'             ;COMPARE FOR "4".
        JR      NC,LOOP6        ;LOOP IF ABOVE "3".
        CALL    33H             ;PRINT CHARACTER.
        RLA                     ;MULTIPLE BY 2.
        RLA                     ;MULTIPLE BY 4.
        ADD     A,(HL)          ;ADD AM PM VALUE.
        LD      (HL),A          ;RESTORE VALUE.
        LD      A,0FH           ;TURN OF CURSOR.
        CALL    33H             ;DO IT.
 ;***************************************************
 ;*             INPUT DAY ROUTINE.                  *
 ;***************************************************
        LD      HL,SCREEN+328   ;SCREEN LOCATION.
        LD      (CURPOS),HL     ;LOAD CURSOR.
        LD      HL,MESG10       ;GET MESSAGE.
        CALL    VIDEO           ;LOAD SCREEN.
        LD      A,0EH           ;TURN ON CURSOR.
        CALL    33H             ;DO IT.
 LOOP7  CALL    2BH             ;CALL KEYBOARD.
        CP      '1'             ;COMPARE FOR "1".
        JR      C,LOOP7         ;LOOP IF BELOW "1".
        CP      '8'             ;COMPARE FOR "8".
        JR      NC,LOOP7        ;LOOP IF ABOVE "7".
        LD      (TABLE+1),A     ;LOAD TABLE WITH DAY.
        CALL    33H             ;LOAD SCREEN.
        LD      A,0FH           ;TURN OFF CURSOR.
        CALL    33H             ;DO IT
 ;***************************************************
 ;*       ENTER TO START CLOCK ROUTINE.             *
 ;***************************************************
        LD      HL,SCREEN+388   ;SCREEN LOCATINE.
        LD      (CURPOS),HL     ;LOAD CURSOR.
        LD      HL,MESG11       ;LOAD MESSAGE.
        CALL    VIDEO           ;PUT ON SCREEN.
        XOR     A               ;CLEAR A.
        OUT     (20H),A         ;CLEAR CONTROL REG.
        OUT     (2FH),A         ;CLEAR SETTING REG.
        LD      A,5             ;BITS 4 AND 0.
        OUT     (20H),A         ;LOAD CONTROL REG.
        LD      HL,TABLE+14     ;LOAD HL DAYS.
        LD      BC,0F21H        ;COUNT PORT C.
 LOOP8  LD      A,(HL)          ;GET VALUE.
        OUT     (C),A           ;LOAD CLOCK.
        DEC     HL              ;DEC TABLE.
        INC     C               ;INC. CLOCK PORT.
        DJNZ    LOOP8           ;AGAIN 16 TIMES.
 LOOP9  CALL    2BH             ;CALL KEYBOARD.
        CP      0DH             ;COMPARE FOR ENTER.
        JR      NZ,LOOP9        ;LOOP IF NOT.
        XOR     A               ;ZERO A.
        OUT     (20H),A         ;START CLOCK.
        JR      READ            ;GO READ ROUTINE.
 ;***************************************************
 ;*           VIDEO WRITE ROUTINE.                  *
 ;***************************************************
 VIDEO  LD      A,(HL)          ;GET LETTER FROM MESS.
        OR      A               ;TEST FOR END OF MESS.
        RET     Z               ;GO IF END OF MESSAGE.
        CALL    33H             ;PRINT CHARACTER.
        INC     HL              ;NEXT CHARACTER.
        JR      VIDEO           ;LOOP TILL ALL DONE.
 ;***************************************************
 ;*            CLOCK READ ROUTINE                   *
 ;*            IN 32 CHR$ MODE                      *
 ;***************************************************
 READ   CALL    CLEAR           ;CLEAR SCREEN.
        LD      A,17H           ;SELECT 32 CHR$
        CALL    33H             ;MODE AND PRINT.
        LD      HL,SCREEN+328   ;LOAD CURSOR
        LD      (CURPOS),HL     ;POSTION.
        LD      HL,MESG5        ;PRINT
        CALL    VIDEO           ;MESSAGE.
 ;***************************************************
 ;*           FIND DAY ROUTINE                      *
 ;***************************************************
        LD      HL,SCREEN+84    ;LOAD CURSOR
        LD      (CURPOS),HL     ;POSTION.
        LD      B,0
        LD      HL,MESG6        ;LOAD DAYS.
        IN      A,(2EH)         ;GET DAY VALUE.
        AND     0FH             ;CLEAR TOP BITS.
        DEC     A               ;MAKE ZERO.
        RLA                     ;ROTATE 
        RLA                     ;TWICE.
        LD      C,A             ;LOAD C WITH VALUE.
        RLA                     ;ROTATE TWICE
        RLA                     ;MORE.
        SUB     C               ;SUBTRACT 0CH.
        LD      C,A             ;LOAD VALUE.
        ADD     HL,BC           ;FIND DAY.
        CALL    VIDEO           ;PRINT IT.
 ;***************************************************
 ;*            AM PM ROUNTINE                       *
 ;***************************************************
        LD      HL,SCREEN+234   ;SCREEN LOCATION.
        LD      (CURPOS),HL     ;LOAD CURSOR.
        LD      HL,MESG12       ;GET MESSAGE.
        LD      B,0
        IN      A,(2FH)         ;CLOCK SET REGISTERS.
        AND     2H              ;AM OR PM SET.
        RLA                     ;MOVE RIGHT.
        LD      C,A             ;SAVE IN C.
        ADD     HL,BC           ;FIND AM OR PM.
        CALL    VIDEO           ;PRINT VALUE.
 ;************************************************
 ;*       LOAD DATE AND TIME ONTO SCREEN         *
 ;************************************************
 LOOP10 LD      HL,SCREEN+224   ;SCREEN POSITION.
        LD      C,21H           ;LOAD PORT 21H.
        CALL    GETTIM          ;DISPLAY IT.
        LD      (HL),':'        ;PRINT COLEN.
        DEC     HL
        DEC     HL
        CALL    GETTIM          ;DISPLAY NEXT.
        CALL    GETTIM          ;DISPLAY NEXT.
        LD      (HL),':'
        DEC     HL
        DEC     HL
        CALL    GETTIM          ;DISPLAY NEXT.
        CALL    GETTIM          ;DISPLAY NEXT.
        LD      (HL),':'
        DEC     HL
        DEC     HL
        CALL    GETTIM          ;DISPLAY NEXT.
        CALL    GETTIM          ;DISPLAY NEXT.
        LD      L,090H          ;SCREEN LOCATION.
        CALL    GETTIM          ;DISPLAY NEXT.
        CALL    GETTIM          ;DISPLAY NEXT.
        LD      L,092H          ;SCREEN LOCATION.
        LD      (HL),'/'        ;LOAD SLASH.
        LD      L,096H          ;SCREEN LOCATION.
        CALL    GETTIM          ;DISPLAY NEXT.
        CALL    GETTIM          ;DISPLAY NEXT.
        LD      L,098H          ;SCREEN LOCATION.
        LD      (HL),'/'        ;LOAD SLASH.
        LD      L,09CH          ;SCREEN LOCATION.
        CALL    GETTIM          ;DISPLAY NEXT.
        CALL    GETTIM          ;DISPLAY NEXT.
        CALL    2BH             ;CALL KEYBOARD.
        CP      'R'             ;COMPARE RETRY.
        JR      Z,RETRY         ;GO RETRY.
        CP      'E'             ;COMPARE EXIT.
        JR      NZ,LOOP10       ;GO IF NOT
        CALL    CLEAR           ;CLEAR SCREEN.
        JP      402DH           ;GO DOS.
 RETRY  LD      HL,ENTER        ;RESAVE ENTER.
        LD      (SAVE),HL       ;SAVE IT.
        JP      START           ;GO TO BEGINING.
 ;***************************************************
 ;*            READ CLOCK ROUTINE.                  *
 ;***************************************************
 GETTIM IN      A,(CONTRL)      ;CONTROL REGISTER.
        BIT     3,A             ;IS CLOCK READY.
        JR      NZ,GETTIM       ;RETURN IF SO.
        IN      A,(C)           ;CLOCK REGISTER.
        AND     3FH             ;CONVERT TO NUMBERS.
        INC     C               ;NEXT PORT.
        LD      (HL),A          ;LOAD SCREEN.
        DEC     HL              ;NEXT SCREEN LOCATION.
        DEC     HL              ;AGAIN.
        RET
 ;***************************************************
 ;*                MESSAGES.                        *
 ;***************************************************
 MESG1  DEFM    'Real Time Clock setting program'
        DEFB    0
 MESG2  DEFM    'by David Kennedy'
        DEFB    0
 MESG3  DEFM    'Enter;(R)ead or (W)rite'
        DEFB    0
 MESG4  DEFM    'Input Day/Month/Year,eg 00/00/00'
        DEFB    0
 MESG5  DEFM    '(R)ETRY OR (E)XIT'
        DEFB    0
 MESG6  DEFM    'SUNDAY     '
        DEFB    0
        DEFM    'MONDAY     '
        DEFB    0
        DEFM    'TUESDAY    '
        DEFB    0
        DEFM    'WEDNESDAY  '
        DEFB    0
        DEFM    'THURSDAY   '
        DEFB    0
        DEFM    'FRIDAY     '
        DEFB    0
        DEFM    'SATURDAY   '
        DEFB    0
 MESG7  DEFM    ' Input Hours:Minutes,eg 00:00        '
        DEFB    0
 MESG8  DEFM    'Press (A)M or (P)M >'
        DEFB    0
 MESG9  DEFM    'Number of Years since last Leap Year >'
        DEFB    0
 MESG10 DEFM    'Input: Sunday to Saturday 1 to 7 >'
        DEFB    0
 MESG11 DEFM    'Enter with seconds at 00 to start clock'
        DEFB    0
 MESG12 DEFM    'AM '
        DEFB    0
        DEFM    'PM'
        DEFB    0
 TABLE  EQU     $
        END     START
