RAMDIS START	EQU	0B170H
 READSC	EQU	4675H
 WRITSC	EQU	45F7H
 BANCTL	EQU	84H
 BANRES	EQU	00H
 BANK0	EQU	03H
 BANK2	EQU	63H
 BANK3	EQU	73H
 RAMDRV	EQU	02H
 PRINT	EQU	021BH
 DBUFF1	EQU	4300H
 ERROR	EQU	4409H
 HIMEM	EQU	4411H
 HIDISK	EQU	4413H
 ENDMEM	EQU	4415H
 INIT	EQU	4420H
 OPEN	EQU	4424H
 CLOSE	EQU	4428H
 READ	EQU	4436H
 WRITE	EQU	4439H
 TRKLEN	EQU	4608
 ARBBYT	EQU	6000H
 ;
 	ORG	START
 ;
 ;*** Save Command Line Parameters ***
 ;
 	LD	DE,PARAM
 	LD	BC,64
 	LDIR
 ;
 ;*** test for Existance of Extra Memory ***
 ;
 	DI			;Test for Existance of
 	LD 	HL,ARBBYT	;   banks 2 and 3
 	LD	A,BANK2		;   by writing to Bank 2
 	OUT	(BANCTL),A	;   and checking that
 	LD	(HL),0FFH	;   Bank 3 was not
 	LD	A,BANK3		;   modified in the
 	OUT	(BANCTL),A	;   process.
 	LD	(HL),00H
 	LD	A,BANK2
 	OUT	(BANCTL),A
 	LD	B,(HL)
 	LD	A,BANRES
 	OUT	(BANCTL),A
 	EI
 	LD	A,B		;Bank 2 modified by
 	OR	A		;   write to Bank 3?
 	JP	NZ,INSTAL	;Install if not.
 ;
 	LD	HL,ERRMES	;Else Error!
 	JP	PRINT
 ;
 ;*** Install Patches and Drivers ***
 ;
 INSTAL	LD	A,RAMDRV	;Last Drive=Ramdrive
 	LD	(HIDISK),A
 ;
 	LD	HL,NEWRD	;Install new Read Sector
 	LD	(READSC+4),HL	;   Handler.
 ;
 	LD	HL,NEWWR	;Install new Write Sector
 	LD	A,0C3H		;   HANDLER.
 	LD	(WRITSC),A
 	LD	(WRITSC+1),HL
 ;
 	LD	HL,DRVCHK	;Bypass Drive Check
 	LD	(4C75H),A	;   on Ramdisk.
 	LD	(4C76H),HL
 ;
 	LD	HL,NEWRD	;Protect Ramdisk Driver.
 	DEC	H
 	LD	L,0FFH
 	LD	(HIMEM),HL
 	LD	(ENDMEM),HL
 ;
 ;*** Process Command Line Parameters ***
 ;
 	LD	A,(PARAM)
 	CP	'*'		;Warm start?
 	RET	Z
 	CP	'S'		;Save Ramdisk to file
 	JP	Z,SAVE
 	CP	's'
 	JP	Z,SAVE
 	CP	'L'		;Load Ramdisk File
 	JP	Z,LOAD
 	CP	'l'
 	JP	Z,LOAD
 ;
 ;*** Format Ramdrive (cold start) ***
 ;
 	LD	HL,GAT		;Clear 12 Sectors
 	LD	DE,GAT+1	;   of Track Buffer.
 	LD	BC,3071
 	LD	(HL),0
 	LDIR
 ;
 	LD	A,1		;Protect Bootstrap Gran.
 	LD	(GAT),A
 ;
 	LD	HL,GAT+17	;Protect Tracks 17-39.
 	LD	DE,GAT+18
 	LD	BC,39-17
 	LD	(HL),'?'
 	LDIR
 ;
 	LD	HL,8FD3H	;Master Password=PASSWORD
 	LD	(GAT+0CEH),HL
 ;
 	LD	HL,IDENT	;Store Disk Name, Date
 	LD	DE,GAT+0D0H
 	LD	BC,17
 	LDIR
 ;
 	LD	HL,GAT+256+50	;Fill Phantom Directory.
 	LD	DE,GAT+256+51
 	LD	BC,80-50-1
 	LD	(HL),0FFH
 	LDIR
 ;
 	LD	HL,DBUFF1	;Copy Boot Sector
 	LD	BC,0		;   to Ramdrive
 	LD	DE,1
 	CALL	READSC
 	LD	HL,DBUFF1
 	LD	BC,RAMDRV
 	LD	DE,1
 	CALL	WRITSC
 ;
 	LD	B,12		;Write Directory
 	LD	C,RAMDRV
 	LD	D,17
 	LD	E,1
 	LD	HL,GAT
 DIROUT	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	CALL	WRITSC
 	POP	HL
 	POP	DE
 	POP	BC
 	INC	E		;Next Record
 	INC	H
 	DJNZ	DIROUT
 	RET
 ;
 ;*** Load Stored Ramdisk Image from file ***
 ;
 LOAD	CALL	IOINIT
 	CALL	OPEN
 	JP	NZ,BADPAR
 LLOAD	LD	DE,(DCB)	;Read Floppy till EOF
 	CALL	READ
 	JR	Z,L2LOAD
 	CP	1CH		;EOF?
 	JR	Z,EXITLS
 	JP	ERROR
 L2LOAD	CALL	NXTSEC		;Copy Record to Ramdisk
 	LD	HL,BUFFER
 	CALL	WRITSC
 	JR	LLOAD
 ;
 ;*** Save Ramdisk Image to File ***
 ;
 SAVE	CALL	IOINIT
 	CALL	INIT
 	JP	NZ,BADPAR
 LSAVE	CALL	NXTSEC		;Write entire Ramdisk
 	LD	HL,BUFFER	;   to Floppy File.
 	CALL	READSC
 	LD	DE,(DCB)
 	CALL	WRITE
 	JP	NZ,ERROR
 	LD	A,(LAST)
 	OR	A
 	JR	NZ,SAVE
 ;
 EXITLS	LD	DE,(DCB)
 	CALL	CLOSE
 	JP	NZ,ERROR
 	RET
 ;
 ;*** Calculate Next Sector ***
 ;
 NXTSEC	PUSH	HL
 	LD	C,RAMDRV
 	LD	HL,(CURSEC)
 	LD	DE,-18
 	LD	E,D
 	XOR	A
 	SBC	HL,DE
 	EX	DE,HL
 	INC	DE
 	LD	DE,(CURSEC)
 	INC	L
 	JR	NZ,ENXT
 	LD	L,-18
 	INC	H
 	JR	NZ,ENXT
 	LD	(LAST),A
 	POP	HL
 	RET
 ENXT	DEC	A
 	LD	(LAST),A
 	LD	(CURSEC),HL
 	POP	HL
 	RET
 ;
 ;*** Build DCB and Reset Sector Counter ***
 ;
 IOINIT	PUSH	HL
 	LD	H,-18
 	LD	L,H
 	LD	(CURSEC),HL
 	POP	HL
 	LD	DE,PARAM+1
 LDCB	LD	A,(DE)
 	INC	DE
 	CP	13
 	JP	Z,BADPAR
 	CP	' '
 	JP	Z,LDCB
 	CP	'='
 	JP	Z,LDCB
 	DEC	DE
 	LD	(DCB),DE
 	LD	HL,BUFFER
 	LD	B,0		;Logical Rec. Length=256
 	RET
 ;
 BADPAR	LD	A,11+40H	;Illegal Command Param.
 	JP	ERROR
 ;
 ;*** Message Area ***
 ;
 IDENT	DEFM	'Ramdisk 10/08/87'
 	DEFB	13
 ;
 ERRMES	DEFM	'*** Memory Banks 2 and 3 NOT FOUND!!!'
 	DEFB	13
 ;
 ;*** Install Time Buffer Area ***
 ;
 LAST	DEFS	1
 CURSEC	DEFS	2
 DCB	DEFS	2
 PARAM	EQU	$
 BUFFER	EQU	$+100H
 GAT	DEFS	3072
 ;
 ;***********************
 ;* high memory drivers *
 ;***********************
 ;
 ;*** New Read Sector Driver ***
 ;
 NEWRD	LD	A,RAMDRV	;Drive = Ramdrive?
 	CP	C
 	JR	NZ,FLOPRD	;No, then Floppy Driver
 ;
 	PUSH	HL		;Trk 17, Sec 12 or lower
 	LD	HL,110CH
 	XOR	A
 	SBC	HL,DE
 	POP	HL
 	JR	NC,LEGSEC
 ;
 	PUSH	HL		;If not, Zero Buffer
 	PUSH	DE
 	PUSH	BC
 	PUSH	HL
 	POP	DE
 	INC	DE
 	LD	BC,255
 	LD	(HL),0
 	LDIR
 	JR	ENEWRD
 ;
 LEGSEC	PUSH	HL		;Else attempt to Read
 	PUSH	DE
 	PUSH	BC
 	CALL	CALC		;Calculate Sector Address
 	LD	B,0
 	EX	DE,HL
 	LD	HL,(SECADD)
 	DI
 SECIN	LD	A,(BANK)	;Copy Sector to Buffer
 	OUT	(BANCTL),A
 	LD	C,(HL)
 	LD	A,BANRES
 	OUT	(BANCTL),A
 	LD	A,C
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	SECIN
 	EI
 ENEWRD	POP	BC
 	POP	DE
 	POP	HL
 	POP	AF		;Return to Readsc caller
 	XOR	A
 	RET
 ;
 FLOPRD	JP	4C6BH		;Return to Floppy Driver
 ;
 ;*** New Write Sector Driver ***
 ;
 NEWWR	LD	A,RAMDRV	;Drive = Ramdrive?
 	CP	C
 	JR	NZ,FLOPWR	;No, then Floppy Driver
 ;
 	PUSH	HL		;Legal Sector?
 	LD	HL,110CH
 	XOR	A
 	SBC	HL,DE
 	POP	HL
 	RET	C		;If not, Return.
 ;
 	PUSH	HL		;Else, attempt to Write.
 	PUSH	DE
 	PUSH	BC
 	CALL	CALC		;Calculate Sector Address
 	LD	DE,(SECADD)
 	LD	B,0
 	DI
 SECOUT	LD	C,(HL)		;Dump Buffer to Sector
 	LD	A,(BANK)
 	OUT	(BANCTL),A
 	LD	A,C
 	LD	(DE),A
 	LD	A,BANRES
 	OUT	(BANCTL),A
 	INC	HL
 	INC	DE
 	DJNZ	SECOUT
 	EI
 	POP	BC
 	POP	DE
 	POP	HL
 	XOR	A
 	RET
 ;
 FLOPWR	LD	A,0FFH		;Return to Floppy Driver.
 	CP	C
 	JP	45FAH
 ;
 ;*** Bypass Test of Ramdrive ***
 ;
 DRVCHK	LD	A,C
 	CP	RAMDRV
 	JR	Z,NOERR
 	IN	A,(0F0H)
 	AND	80H
 	JP	4C79H
 NOERR	XOR	A
 	RET
 ;
 ;*** Calculate Bank # and Offset of Sector
 ;
 CALC	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	C,0		;Clear Bank Overflow Flag
 	LD	(TRKSEC),DE
 	LD	HL,0		;Track Start Address
 	LD	A,D
 	OR	A
 	JR	Z,ADDOFF	;Track 0?
 ;
 	LD	B,D
 	LD	DE,TRKLEN
 MULTRK	ADD	HL,DE
 	RL	C
 	DJNZ	MULTRK
 ;
 ADDOFF	LD	DE,(TRKSEC)	;Offset = Sector * 256
 	DEC	DE
 	LD	D,E
 	LD	E,0
 	ADD	HL,DE		;Add Sector Offset
 	RL	C
 	LD	A,C		;Bank 2 or 3 Overflow
 	OR	A
 	JR	NZ,B0		;   then use Bank 0
 	BIT	7,H		;Bank 2 Overflow
 	JR	NZ,B3		;   then use Bank 3
 	JP	B2		;Else use Bank 2
 ;
 B0	LD	A,BANK0		;Use Bank 0
 	LD	DE,4000H	;inserted for 4P
 	AND	A		;inserted for 4P
 	SBC	HL,DE		;as above, use Bank 1
 	JR	ECALC
 ;
 B2	LD	A,BANK2		;use Bank 2
 	JR	ECALC
 ;
 B3	RES	7,H		;Secadd = hl - 8000h
 	LD	A,BANK3		;use Bank 3
 ;
 ECALC	LD	(BANK),A	;Save Bank Number
 	LD	(SECADD),HL	;   and Sector Address
 	POP	BC
 	POP	DE
 	POP	HL
 	RET
 ;
 ;*** Run-Time Variables ***
 ;
 SECADD	DEFS	2
 TRKSEC	DEFS	2
 BANK	DEFS	1
 ;
 	END	START
NK),A	;Save Bank Number
 	LD	(SECADD),HL	;   and Sector Address
 	POP	BC
 	POP	DE
 	POP	HL
 	RET
 ;
 ;*** Run-Time Variables ***
 ;
 SECADD	DEFS	2
 TRKSEC	DEFS	2
