; supzapc/asm - kjw/bqsd - 08/79 - 08/82
;
	TITLE	'<Disk Zap - Section C>'
;
	PAGE
;
;	$MODxx - cursor positioning in $MODIFY mode
;
;	ENT	HL = pointer to current data address
;			(usually stored in DE!)
;		IX => current position of cursor in
;			the HEX portion of the display
;		IY => current posit of cursor in the
;			ASCII portion of the display
;		(TEMP2) = relative offset of the pointers
;			from the beginning of the data
;			(TEMP2)=HL-(ADDRES)
;		(ADDRES) = beginning address of the
;			current display buffer
;
;	EXT	exit made via a RET, $MODWT on stack!
;
;
;
;	$MODR - move cursor right one place
;	right arrow key
;
MODR	EX	DE,HL		;restore data source
;
;	advance cursor to the right
;	do not move off of the row
;
	CALL	MODRX		;move right, no row adv
	RET	NC		;not beyond row edge
;
;	move down one row
;	if at bottom row, last char, wrap to the
;	first character on the same row
;
	CALL	MODDX		;move down one row
	JR	NC,MODLE+1	;go left side if at bot
;
MODRCNT	LD	A,(TYPE)	;fetch modify type
	CP	2		;from memory?
	SCF			;Carry = video limit
	RET	NZ		;not mem, return
;
;	attempt made to move the cursor beyond the
;	video limit, but since the data is from memory
;	(and not restricted to 256 bytes like a disk sec)
;	bring in another 16 bytes of data to fill request
;
	LD	HL,(ADDRES)	;fetch current address
	LD	BC,16		;get 16 more
	ADD	HL,BC		;new rel 00 address
	LD	(ADDRES),HL	;re-save it
;
	EX	DE,HL		;fetch curr cursor offset
	ADD	HL,BC		;add new length
	EX	DE,HL		;put it back
;
;	re-display the data and move the cursor
;	to the far left on the bottom row
;
	CALL	AASHOW		;re-display data!
	JP	MODLE+1		;cursor far left same row
;
;
;	$MODTOP - home cursor to rel offset 00
;	clear key
;
MODTOP	EX	DE,HL		;get addr back to DE
	LD	A,(TEMP2)	;fetch current offset
	LD	B,A		;save it here for looper
	OR	A		;already at home?
	RET	Z		;yes, don't bother
;
;	B = relative offset of DE, IX and IY pointers
;	from the beginning of the data.  Simulate
;	left arrow keys for offset length to easily
;	keep all the pointers current
;
MODTOPL	PUSH	BC		;save counter
	CALL	MODL+1		;move left one space
	POP	BC		;restore counter
	DJNZ	MODTOPL		;continue till home
	RET			;done!
;
;
;	$MODRX - move cursor right one space
;		 do not leave the current row
;	(internal call)
;
MODRX	PUSH	IX		;IX = hex side of video
	POP	HL		;pass to HL for test
	LD	A,L		;fetch LSB video posit
	AND	3FH		;get rel posit in row
	CP	2DH		;check for hex side limit
	SCF			;C = at end!
	RET	Z		;yes, return!
;
;	ok to advance on current row
;
	INC	IX		;bump hex pointer
	INC	IX		;2 chars each byte
	INC	IY		;bump ascii pointer
	INC	DE		;bump data address
	LD	A,(IX)		;check for quad 'gap'
	CP	' '		;space on video?
	SCF			;clear carry by set
	CCF			;and reset
	RET	NZ		;return, NCarry=status
	INC	IX		;bump past the gap
	RET			;Z flag doesn't matter
;
;
;	$MODRE - move cursor to far right side
;		 remain on the same row
;	shift right arrow
;
MODRE	EX	DE,HL		;fetch data addr to DE
	LD	A,16		;16 chars/line max
;
;	since a call to MODRX will not advance
;	beyond the end of a row, go ahead and call
;	it 16 times and ignore the status.
;	it will surely end up at the right side when done
;
MODREX	EX	AF,AF'		;save counter
	CALL	MODRX		;move right, same row
	EX	AF,AF'		;get counter
	DEC	A		;more?
	JR	NZ,MODREX	;go if yes
	RET			;else done!
;
;
;	$MODL - move cursor left one space
;	left arrow
;
MODL	EX	DE,HL		;fetch data start to DE
	CALL	MODLX		;move left, same row
	RET	NC		;did not reach the end
;
	CALL	MODUX		;move up a row
	JR	NC,MODRE+1	;if at end, go right end
;
;	attempt to move beyond top of video
;
MDLCONT	LD	A,(TYPE)	;fetch source of data
	CP	2		;from memory?
	SCF			;C = limit reached
	RET	NZ		;non memory, return error
;
;	go ahead and bring in more data from memory
;
	LD	HL,(ADDRES)	;fetch data address
	LD	BC,-16		;subtract 16 from it
	ADD	HL,BC		;add minus (saves a byte)
	LD	(ADDRES),HL	;save NEW address
;
	EX	DE,HL		;get data offset
	ADD	HL,BC		;subtract here too
	EX	DE,HL		;put it back
;
	CALL	AASHOW		;re-display data
	JP	MODRE+1		;cursor to far right side
;
;
;	$MODLE - move cursor to far left side of display
;	shift left arrow
;
MODLE	EX	DE,HL		;load DE with data addr
	LD	A,16		;go 16 times
;
MODLEX	EX	AF,AF'		;save counter
	CALL	MODLX		;move left, same row!
	EX	AF,AF'		;get counter
	DEC	A		;more?
	JR	NZ,MODLEX	;yes, go again
	RET			;else now at left end!
;
;
;	$MODLX - move cursor left one space
;		 remain on the same row
;	(internal call)
;
MODLX	PUSH	IX		;get HEX side video ptr
	POP	HL		;pass it to HL for test
	LD	A,L		;fetch LSB
	AND	3FH		;compute row offset
	CP	8		;at far left side now?
	SCF			;C = video limit!
	RET	Z		;yes, can't go no more!
;
;	OK to move cursor back
;
	DEC	IX		;HEX pointer back
	DEC	IX		;2 chars per byte
	DEC	IY		;ASCII pointer back
	DEC	DE		;DATA pointer back
;
;	check to see if we're on a 'gap'
;
	LD	A,(IX+1)	;get accused byte
	CP	' '		;a space?
	SCF			;must clear carry flag
	CCF			;without upsetting Z
	RET	NZ		;nope, OK
	DEC	IX		;get over the 'gap'
	RET			;now, done
;
;
;	$MODU - move cursor up one space
;	up arrow
;
MODU	EX	DE,HL		;fetch data ptr to DE
	CALL	MODUX		;up a row, same column
	RET	NC		;not at top yet
;
;	again, tried to go off the video
;	check if more data can be supplied
;	to meet the request
;
	JP	MDLCONT		;check source of data
;
;
;	$MODUE - move cursor to top row
;		 do not move off the current column
;	shift up arrow
;
MODUE	EX	DE,HL		;load DE with data addr
	LD	A,16		;16 columns on video
;
;	NOTE	the following sequence of calls will
;		result in a full page of new data being
;		brought in if the cursor is already
;		on the top row of the display
;
MODUEX	EX	AF,AF'		;save counter
	CALL	MODUX		;up a row, same column
	EX	AF,AF'		;get counter back
	DEC	A		;any more?
	JR	NZ,MODUEX	;yes, go!
	RET			;at top now!
;
;
;	$MODUX - move cursor up one row
;		 do not change column
;	(internal call)
;
MODUX	PUSH	IX		;pass HEX video pointer
	POP	HL		;to HL for test
	LD	BC,-64		;one column up
	ADD	HL,BC		;point to it
	LD	A,H		;check for still on video
	CP	3CH		;below video memory?
	RET	C		;yes, DE, IX IY still OK
;
	ADD	IX,BC		;subtract from HEX ptr
	ADD	IY,BC		;subtract from ASCII ptr
;
	EX	DE,HL		;get to HL for ADD
	ADD	HL,BC		;subtract from DATA off.
	EX	DE,HL		;put it back
	OR	A		;clear carry for OK
	RET			;back to caller
;
;
;	$MODD - move cursor down one row
;	down arrow
;
MODD	EX	DE,HL		;get pointer to DE
	CALL	MODDX		;move down, same column
	RET	NC		;did not go beyond video
;
;	attempt to move past video bottom
;	check to see if more data can be brought in
;
	JP	MODRCNT		;check for more data
;
;
;	$MODDE - move cursor to far bottom of same column
;	shift down arrow
;
MODDE	EX	DE,HL		;load DE with address
	LD	A,16		;16 columns on display
;
MODDEX	EX	AF,AF'		;save counter
	CALL	MODDX		;move down a row
	EX	AF,AF'		;get counter back
	DEC	A		;more?
	JR	NZ,MODDEX	;yes, go!
	RET			;else now at bottom row
;
;
;	$MODDX - move cursor down a row
;		 do not leave the current column
;	(internal call)
;
MODDX	PUSH	IX		;HEX video pointer
	POP	HL		;pass to HL for test
	LD	BC,64		;offset to next row
	ADD	HL,BC		;add it
	LD	A,H		;get MSB
	CP	40H		;still in video memory?
	CCF			;reverse carry
	RET	C		;if >40H, then NOPE!
;
;	registers intact in case of error
;	now adjust to the new offset
;
	ADD	IX,BC		;add HEX offset
	ADD	IY,BC		;add ASCII offset
;
	EX	DE,HL		;get to HL for add
	ADD	HL,BC		;add to DATA offset
	EX	DE,HL		;put it back
;
	OR	A		;clear carry for OK
	RET			;back to caller
;
	PAGE
;
;	$UPDATE - update modified data
;
;	ENT	(ZAPFLAG) indicates any errors on read
;		HL = track/sector data
;		IX & IY point to video data
;		(TYPE) = modify data source
;
;	EXT	proper user action taken and an exit
;		is made either back to the initiating
;		paging mode, or back to modify mode
;
UPDATE	PUSH	HL		;save track/sector
	LD	A,(ZAPFLAG)	;fetch error trapper
	DEC	A		;one?
	JR	NZ,SKPZU	;nope, cancel!
;
;	check for non-standard read attempt
;
	LD	A,(FLAGB)	;get system flag B
	AND	2		;attempted?
	JR	Z,SKPZU		;nope, don't prompt
	RST	8		;clear work, show why
;
	DEFB	7		;clear screen
	DEFM	'ERROR on Load'
	DEFB	0
;
	CALL	ASKIBM		;ask if IBM or not
	XOR	A		;clear the flag
	LD	(ZAPFLAG),A	;by setting NOT 1
;
SKPZU	POP	DE		;load trk/sec to DE
;
;	check if data source is from memory
;	if it is, it is already updated, bypass prompt
;
	LD	A,(TYPE)	;fetch modify data source
	CP	2		;from memory?
	JP	Z,DISRETM	;return from mod - memory
;
UPDATE1	RST	8		;display prompt
;
	DEFB	7		;clear screen
	DEFM	'U>pdate, C>ancel, R>eturn to Modify ? '
	DEFB	0
;
	LD	B,1		;fetch one key
	RST	10H		;get from keyboard
	RST	8		;clear input line
;
	DEFB	1EH		;clear line
	DEFB	0
;
;	RST 8 (display) doesn't use AF!
;
	JR	Z,PUTDATA	;nil input, default U
	CALL	UCASE		;make input upper case
;
	CP	'U'		;update?
	JR	Z,PUTDATA
;
	CP	'R'		;return to modify?
	JR	Z,BAKMOD
;
	CP	'C'		;cancel?
	JR	NZ,UPDATE1	;non of the above, go!
;
;	re-read the data (cancel)
;
;	NOTE	after data has been written back to
;		disk with the UPDATE command, it will
;		be re-read at this vector to make sure
;		that everything that went to the disk
;		is coming back the same
;
;
REREAD	LD	A,(TYPE)	;fetch data source
	CP	1		;$DISDSK ?
	POP	HL		;remove return vector
	LD	DE,(SECTOR)	;fetch original sector
	JP	Z,DISKLP	;yes, read again!
	CP	3		;$DISFILE ?
	JP	Z,FILECT	;yes, read again!
	PUSH	HL		;put vector back
;
;	flag is corrupt!  exit back to $DISDSK
;
;	return from modify to paging mode
;
RETMOD	LD	A,(TYPE)	;fetch data source
	POP	HL		;remove $MODIFY return
	CP	1		;display disk sectors?
	JP	Z,DISCON	;yes, continue here
	CP	2		;display memory
	JP	Z,DISMCON	;yes, continue here
	CP	3		;display file sectors?
	JP	Z,DISFCON	;yes, continue here
	JP	DISKLP		;corrupt! default DISK
;
;	resume modify mode at last place, vect on stack
;
BAKMOD	RST	8		;clear screen
;
	DEFB	7		;cls
	DEFB	0		;term
;
	JP	AASHOW		;re-display data & return
;
;	write data back to the current sector
;
PUTDATA	LD	BC,(ADDRES)	;fetch buffer address
	LD	DE,(SECTOR)	;fetch real trk/sec
	CALL	INITBAD		;enable nonstop
	CALL	INITBD1		;enable error monitor
;
RT1	CALL	DSTAT		;check drive ready
	JP	NZ,4018H	;SKIP selected, ABORT!
;
;	check if 'funny disk' flag is on
;
	LD	A,(FLAGB)	;get system flag
	AND	2		;funny bit
	JR	NZ,WRFUN	;write it funny too!
;
	CALL	WRITE		;write normal
	JR	WRFUN+3		;continue
;
WRFUN	CALL	WRITENS		;write no seeking
;
	CALL	NZ,BADWRT	;error monitor if bad
	JR	NZ,RT1		;retry selected, go again
;
	RST	8		;clear screen
;
	DEFB	7		;cls
	DEFB	0
;
	JP	REREAD		;resume paging mode
;
	PAGE
;
;	$NUMBER - enter numerical input from $MODIFY
;
;	ENT	HL = data address
;		IX & IY are video pointers
;
;	EXT	current byte is modified and updated
;		both to the buffer and video
;		the current number base in effect will
;		be used to interpret the input
;
NUMBER	EX	DE,HL		;load DE with data addr
;
	EX	AF,AF'		;save first key
	LD	A,(MODE)	;fetch type of modify
	CP	4		;ASCII?
	JR	Z,ASCNUM	;yes, use char on stack
;
	LD	A,12		;flash speed
	LD	BC,20B0H	;off/on bytes
	CALL	FLSNUM		;fetch numerical input
	RET	C		;error, don't change it
	EX	AF,AF'		;save char
;
ASCNUM	EX	AF,AF'		;get char
	LD	(DE),A		;put into data buffer
	CALL	MODFIX		;set HEX&ASCII bytes
	JP	MODR+1		;move cursor one place
;
	PAGE
;
;	$ADJBYTE - adjust byte to decrypt mode
;
;	ENT	A = normal character
;
;	EXT	A = adjusted to current decrypt mode
;
ADJBYTE	EX	AF,AF'		;save char in A'
	PUSH	BC		;save BC
	LD	A,(DISP3)	;fetch counter byte
	LD	B,A		;save count in B
	LD	A,(DISP2)	;fetch dir flag for RS
	LD	C,A		;save rotate/shift flag
	LD	A,(DISP1)	;fetch operation
;
	CP	'+'		;add?
	JR	Z,SHODIS
;
	CP	'-'		;subtract?
	JR	Z,SHODISM
;
	CP	'A'		;AND?
	JR	Z,EFAND
;
	CP	'O'		;OR?
	JR	Z,EFOR
;
	CP	'X'		;XOR?
	JR	Z,EFXOR
;
	CP	'R'		;ROTATE?
	JR	Z,EFROT
;
	CP	'S'		;SHIFT?
	JR	Z,EFSHIFF
;
	EX	AF,AF'		;corrupt!, return!
;
ADJF	POP	BC		;unstack
	RET			;return to caller
;
;	shift operation
;
EFSHIFF	LD	A,C		;fetch direction
	LD	C,27H		;SLA A opcode
	CP	'L'		;shift left?
	JR	Z,SIT		;yes, go!
	LD	C,2FH		;SRA A opcode
	JR	SIT		;go!
;
;	rotate operation
;
EFROT	LD	A,C		;fetch direction
	LD	C,7		;RLC A opcode
	CP	'L'		;rotate left?
	JR	Z,SIT		;yes, go!
	LD	C,0FH		;RRC A opcode
;
SIT	LD	A,C		;fetch opcode modifier
	LD	(COMB2),A	;save into code
	EX	AF,AF'		;get original back
;
COMB1	DB	0CBH		;SLA,SRA,RLCA,RRCA
COMB2	DB	0		;modifier byte
	DJNZ	COMB1		;go for number specified
	JR	ADJF		;done, A = new char
;
;	add operation
;
SHODIS	EX	AF,AF'		;fetch original
	ADD	A,B		;add specifier
	JR	ADJF		;return!
;
;	subtract operation
;
SHODISM	EX	AF,AF'		;original
	SUB	B		;subtract 'em
	JR	ADJF		;resume
;
;	AND operation
;
EFAND	EX	AF,AF'		;fetch original
	AND	B		;and it
	JR	ADJF		;resume
;
;	OR operation
;
EFOR	EX	AF,AF'		;original
	OR	B		;or it
	JR	ADJF		;resume
;
;	XOR operation
;
EFXOR	EX	AF,AF'		;original
	XOR	B		;XOR it
	JR	ADJF		;resume
;
	PAGE
;
;	$FINBYTE - locate user specified byte
;
FINBYTE	EX	DE,HL		;DE => data vector
	LD	A,12		;flash counter
	LD	BC,0BF00H	;cursor type
	CALL	FLICKSP		;fetch first key
;
	CP	'L'		;last byte?
	JR	Z,LSTBYTE	;use last byte
	CP	'l'		;check lower too
	JP	Z,LSTBYTE	;use last
	EX	AF,AF'		;save the key
	LD	A,12		;flash counter
	CALL	FLSNUM		;fetch numeric entry
	RET	C		;error, return
;
FBGO	PUSH	AF		;save character
	CALL	MODFIX		;cursors off
	POP	AF		;restore char
	LD	(LBLST),A	;save as last byte
	LD	C,A		;save byte in C
	LD	A,(TEMP2)	;get rel offset in data
	LD	B,A		;give to b
	CP	-1		;at end now?
	RET	Z		;at end already
;
	XOR	A		;end of video offset
	SUB	B		;less current offset
	DEC	A		;less current cursor
	LD	B,A		;B = # entries to check
;
FIGO1	PUSH	BC		;save counter
	CALL	MODR+1		;check next char
	POP	BC		;restore counter
	LD	A,(DE)		;get buffer byte
	CP	C		;same as one wanted?
	RET	Z		;yep, leave cursor here
	DJNZ	FIGO1		;else continue
	RET			;done, cursor at last pos
;
LSTBYTE	LD	A,-1		;get last byte
LBLST	EQU	$-1		;saved
	JR	FBGO		;find it
;
;	$AASHOW - display all portions of current display
;
AASHOW	CALL	SHOW		;show hex/ascii
	JP	SHOWLF		;show data source
;
	PAGE
;
;	$INSBYTE - enter INSERT mode in $MODIFY
;
INSBYTE	PUSH	HL		;HL=> buffer posit
	EX	DE,HL		;to DE
	LD	HL,(ADDRES)	;start of buffer
	DEC	L		;end of buffer
	PUSH	HL		;save on stack
	SCF			;need length -1
	SBC	HL,DE		;HL=length
	LD	B,H		;give to BC
	LD	C,L
	POP	HL		;HL => data end
	LD	D,H		;pass to DE
	LD	E,L
	DEC	HL		;end -1
	LDDR			;move 'em up one
	POP	HL		;restore current posit
	LD	(HL),0		;insert a zero there
	EX	DE,HL		;DE => data
	JR	AASHOW		;re-display and return
;
;	$DELBYTE - enter delete mode at current cursor
;
DELBYTE	PUSH	HL		;save current data offset
	EX	DE,HL		;pass to DE
	LD	HL,(ADDRES)	;data start
	DEC	L		;+255, HL => data end
	SCF			;need length -1
	SBC	HL,DE		;compute length remaining
	LD	B,H		;pass to BC for move
	LD	C,L
	POP	HL		;restore data start
;
	PUSH	HL		;leave back on stack
	LD	D,H		;pass to DE
	LD	E,L
	INC	HL		;start +1
	LDIR			;move data backward
	POP	DE		;restore curr data ptr
	LD	HL,(ADDRES)	;fetch address start
	DEC	L		;(ADDRES)+255
	LD	(HL),0		;put zero there
	JR	AASHOW		;redisplay & return
;
	PAGE
;
;	$FILBYTS - fill block of data from $MODIFY mode
;
FILBYTS	EX	DE,HL		;DE => data offset
	LD	BC,0B300H	;cursor off/on
	LD	A,12		;flash rate
	CALL	FLICKSP		;fetch first input key
	EX	AF,AF'		;save key here
	LD	A,12		;flash rate again
	CALL	FLSNUM		;fetch numerical input
	RET	C		;invalid numeric
;
FLGBO	PUSH	AF		;save the key
	CALL	MODFIX		;turn cursors off
	POP	AF		;restore char
;
	LD	C,A		;save it here
	LD	B,0		;BC = value
	PUSH	DE		;save data offset
	EX	DE,HL		;HL => curr data offset
	LD	D,H		;put back into DE
	LD	E,L
	INC	DE		;bump for move
	LDIR			;propogate data
	POP	DE		;restore curr offset
	JP	AASHOW		;redisplay and return
;
	PAGE
;
;	$GOBYTE - position cursor to user specified
;		  relative offset in current page
;
GOBYTE	EX	DE,HL		;DE => data offset
	LD	BC,05B5DH	;cursors to use
	LD	A,12		;flash rate
	CALL	FLICKSP		;special flicker
;
	CP	'L'		;go last?
	JR	Z,GOBLST	;yes, go!
	CP	'l'		;check this too
	JR	Z,GOBLST	;yes, go!
;
	EX	AF,AF'		;pass char here
	LD	A,12		;flash rate again
	CALL	FLSNUM		;fetch numeric input
	RET	C		;error, go!
;
GOBGO	PUSH	AF		;save the key
	CALL	MODFIX		;turn off cursors
	POP	AF		;restore the value
;
	LD	IX,3C00H+8	;reset all pointers
	LD	IY,3C00H+48	;to their initial value
	LD	DE,(ADDRES)	;start of data
	LD	B,A		;counter
	LD	(GBLST),A	;save for next LAST
	OR	A		;check if at 0
	RET	Z		;done
;
GOBGO1	PUSH	BC		;save counter
	CALL	MODR+1		;move right 1 space
	POP	BC		;restore counter
	DJNZ	GOBGO1		;go till request spot
	RET			;done, cursor at new pos
;
GOBLST	LD	A,0		;get last command
GBLST	EQU	$-1
	JR	GOBGO		;move cursor!
;
	PAGE
;
;	$FLSNUM - evaluate user value input
;
;	ENT	BC = off/on chars for cursor
;		A  = delay factor
;		A' = first input character
;
;	EXT	Carry = error
;		NC = OK, value in A
;
;
;	compute base of number and length of input
;
FLSNUM	LD	HL,MODELN	;base/length lookup table
	LD	(FLSSPD),A	;save speed byte
	LD	(FLSCUR),BC	;save cursors
;
	LD	A,(MODE)	;get current number base
	AND	3		;force in range
	ADD	A,A		;double for table
	LD	C,A		;give to C
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => table entries
	LD	B,(HL)		;get length of input
	INC	HL		;bump pointer
	LD	C,(HL)		;get base of number
	EX	AF,AF'		;restore first character
;
	LD	HL,STRING	;use string area to save
	JR	CKENUM		;insert first char
;
;	lookup table for length of input
;	and base specifier for $VALUE call
;
MODELN	DB	2,'H'		;hex
	DB	3,'D'		;decimal
	DB	8,'B'		;binary
	DB	3,'O'		;octal
	DB	1,'A'		;ascii
;
;	wait for input char, flash the cursors
;
NUMON	PUSH	BC		;need to use this
	LD	BC,20B0H	;off, on chars
FLSCUR	EQU	$-2
	LD	A,12		;flash speed
FLSSPD	EQU	$-1
	CALL	FLICKSP		;special input with flash
	POP	BC		;restore counter
;
	CALL	UCASE		;make it upper case
	CP	13		;forced terminate?
	JR	Z,DECNUM	;yes, interpret number
;
;	check for valid character
;
CKENUM	CP	'0'		;valid?
	RET	C		;nope, cancel input
	CP	'9'+1		;in range?
	JR	C,NUMHAV	;yes, go!
	CP	'A'		;less than alpha?
	RET	C		;yes, cancel operation
	CP	'G'		;A-F?
	CCF			;reverse carry
	RET	C		;nope, cancel it
;
NUMHAV	LD	(HL),A		;put char into buffer
	INC	HL		;bump pointer
	DJNZ	NUMON		;go for length
;
;	completed, insert base specifier for $VALUE
;
DECNUM	LD	(HL),C		;put into string
	INC	HL		;bump pointer
	LD	(HL),13		;insert terminator
	LD	HL,STRING	;start of data input
	CALL	VALUE		;fetch the value
	LD	A,C		;fetch LSB value
	RET			;Carry = error
;
