; supzapb/asm - kjw/bqsd - 08/79 - 08/82
;
	TITLE	'<Disk Zap - Section B>'
;
	PAGE
;
;	$SHOW	- display hex/ascii data to video
;
;	ENT	(ADDRESS) = address of data to display
;
;	EXT	data displayed
;		all registers preserved EXCEPT A
;
SHOW	CALL	SAVEREG		;save registers
;
	LD	A,(FLAGA)	;get system flag
	SET	1,A		;turn off 'alive'
	LD	(FLAGA),A	;put it back
;
;	display decryption information lower left corner
;
	LD	A,(DISP1)	;displacement #1
	LD	(3C00H+960),A	;to the video
;
;	check for rotate/shift
;
	CP	'R'		;rotate?
	JR	Z,SHRTT		;yes, go!
	CP	'S'		;shift?
	JR	Z,SHRTT		;yes, go!
;
	LD	A,(DISP3)	;else fetch value
	RST	20H		;to hex ascii
	LD	(3C00H+961),BC	;to the video
	JR	SJRTT		;continue
;
SHRTT	LD	A,(DISP2)	;fetch shf/rot direction
	LD	(3C00H+961),A	;to the video
;
	LD	A,(DISP3)	;fetch bit value
	CP	8		;must be 0-7
	JR	C,SHUGH		;ok, continue
	LD	A,1		;else reset to 1
	LD	(DISP3),A	;update it
;
SHUGH	ADD	A,'0'		;make it ascii
	LD	(3C00H+962),A	;to the video
;
;	display hex and ascii side of display
;
SJRTT	LD	IX,(ADDRES)	;fetch data address
	LD	IY,3C00H+8	;where on video to start
	LD	B,16		;16 lines to do
;
SHOWLP	PUSH	BC		;save counter
	PUSH	IY		;save video row start
	PUSH	IX		;save data address
;
	LD	L,8		;8 two byte pairs (16)
;
SHOWPL1	LD	H,2		;loop for two byte pair
;
;	check if decrypt set for hex side of display
;
SHOWPL	LD	A,(SHFLG)	;get hex decrypt flag
	CP	':'		;on?
	LD	A,(IX)		;fetch data byte
	CALL	Z,ADJBYTE	;adjust if ON
;
	RST	20H		;convert to hex ascii
	LD	(IY),C		;LSB to video
	INC	IY		;bump video
	LD	(IY),B		;MSB to video
	INC	IY		;bump video
	INC	IX		;bump data address
;
	DEC	H		;less pair counter
	JR	NZ,SHOWPL	;first one, continue
;
	INC	IY		;space between pairs
	DEC	L		;less group counter
	JR	NZ,SHOWPL1	;if more, go!
;
;	hex side of row completed, display ascii side
;
	POP	IX		;restore data start
	LD	B,16		;16 bytes to display
;
SHOWPP	LD	A,(IX)		;fetch data byte
	CALL	M00		;display to video
;
	INC	IY		;bump video
	INC	IX		;bump data address
	DJNZ	SHOWPP		;go for 16 bytes
;
	POP	IY		;done, fetch video start
	LD	BC,64		;64 char/line video
	ADD	IY,BC		;start of next row
;
	POP	BC		;restore counter
	DJNZ	SHOWLP		;go for 16 rows
	RET			;else done, return
;
	PAGE
;
;	$SHOMODE - display current modify mode base
;
SHOMODE	LD	A,(MODE)	;fetch modify mode
;
	LD	B,A		;save it here
	ADD	A,A		;*2
	ADD	A,B		;*3
	LD	C,A		;pass to C
	LD	B,0		;BC=3 byte table offset
	LD	HL,MODTYP	;start of text table
	ADD	HL,BC		;HL => text
	LD	DE,3C40H	;where on video it goes
	LD	BC,3		;length of name
	LDIR			;move to video
	RET			;unstack & return
;
;	$SHOWLF - display source of modify data
;
SHOWLF	CALL	SAVEREG		;save registers
	CALL	SHOMODE		;display mode base
;
;	check for memory or disk drive
;
	LD	BC,3		;3 byte entries
	LD	HL,MODDRV	;drive
	LD	A,(TYPE)	;get type of modify
	CP	2		;from memory?
	PUSH	AF		;save result
	JR	NZ,TYUT		;go if not memory
	LD	HL,MODMEM	;memory text
TYUT	LD	DE,3C00H+128	;where on video
	PUSH	BC		;save length
	LDIR			;move it in
	POP	BC		;restore 3
	POP	AF		;restore flags
;
	JP	Z,SHONUMB	;display memory address
;
;	data from disk, show drive track sector
;
	LD	HL,MODTRK	;TRK
	LD	DE,3C00H+256	;video address
	PUSH	BC		;save 3
	LDIR			;move it in
	POP	BC		;restore count
;
	LD	HL,MODTRU	;TRU
	LD	DE,3C00H+384	;where on video
	PUSH	BC		;save length
	LDIR			;move it in
	POP	BC		;restore length
;
	LD	HL,MODSEC	;SEC
	LD	DE,3C00H+512	;video location
	LDIR			;move to video
;
	LD	A,(WRTYPE)	;get type of write
	AND	3		;type of DAM using
	LD	B,A		;give to B
	ADD	A,A		;*2
	ADD	A,B		;*3
	LD	C,A		;give to C
	LD	B,0		;BC = table offset
	LD	HL,MODDAT	;start of text table
	ADD	HL,BC		;HL => text
	LD	BC,3		;3 bytes long
	LD	DE,3C00H+640	;where on video
	LDIR			;move it in
;
	LD	A,(RDTYPE)	;get type of read
	AND	8		;check IBM bit
;
;	NOTE	I & III IBM bits are reversed!
;
;i*
	IF	MODI
	LD	A,'N'		;non ibm
	JR	Z,HAIBM		;go if yes
	LD	A,'I'		;else ibm
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,'I'		;ibm
	JR	Z,HAIBM		;yes, go!
	LD	A,'N'		;else non ibm
	ENDIF
;iii*
HAIBM	LD	(MXDDE),A	;save part into string
;
	LD	A,(IY+3)	;get relative track
	OR	A		;on zero?
	JR	Z,HACK0		;yes, check it
;
	BIT	6,(IY+5)	;density non-track 0
	JR	HACK00		;continue
;
HACK0	BIT	7,(IY+5)	;density track 0
HACK00	LD	A,'S'
	JR	Z,HASD		;yes, go!
	LD	A,'D'		;else double
HASD	LD	(MXDDE+1),A	;put into string
	LD	HL,MXDDE	;stat of string
	LD	DE,3C00H+704	;where on video
	LD	BC,3		;length
	LDIR			;move it in
;
	CALL	DRVASC		;get ascii drive #
	LD	(3C00H+193),A	;to the video
;
	LD	A,(SECTOR+1)	;get track
	RST	18H		;to decimal ascii
	LD	(3C00H+320),A	;to the video
	LD	(3C00H+321),BC
;
	LD	A,(SECTOR)	;get sector
	RST	18H		;decimal ascii
	LD	(3C00H+576),A	;to the video
	LD	(3C00H+577),BC
;
	LD	A,(IY+3)	;get RELATIVE track
	RST	18H		;to decimal ascii
	LD	(3C00H+448),A	;to the video
	LD	(3C00H+449),BC
;
;	insert relative byte offset field
;
	LD	A,(ADDRES)	;get LSB address
	LD	IY,3C00H+5	;start of video
;
NBLP	PUSH	AF		;save address offset
	RST	20H		;to hex ascii
	LD	(IY),C		;MSB to the video
	LD	(IY+1),B	;LSB to video
	LD	BC,64		;length of video line
	ADD	IY,BC		;point to next
	POP	AF		;restore original
;
	ADD	A,16		;next offset
	JR	NZ,NBLP		;go till 16 done
	RET			;done, return
;
;	display hex address for memory modify
;
SHONUMB	LD	HL,(ADDRES)	;fetch address
	LD	DE,64		;length / line
	LD	IY,3C00H+3	;start of video
	LD	A,16		;number of lines to do
;
SHONUML	PUSH	AF		;save counter
	LD	A,H		;fetch MSB address
	RST	20H		;to hex ascii
	LD	(IY),C		;MSB to video
	LD	(IY+1),B	;LSB to video
	LD	A,L		;fetch LSB address
	RST	20H		;to hex ascii
	LD	(IY+2),C	;MSB to video
	LD	(IY+3),B	;LSB to video
	ADD	IY,DE		;offset to next row
	POP	AF		;restore counter
;
	LD	BC,16		;offset to next address
	ADD	HL,BC		;HL = next row address
	DEC	A		;less row counter
	JR	NZ,SHONUML	;finish it off
	RET			;done!
;
;	text area for $SHOWLF
;
MODTYP	DEFM	'HEXDECBINOCTASC'
MODDRV	DEFM	'DRV'
MODMEM	DEFM	'MEM'
MODTRK	DEFM	'TRK'
MODTRU	DEFM	'TRU'
MODSEC	DEFM	'SEC'
MODDAT	DEFM	'STDRPTDDTUDF'
MXDDE	DEFM	'ISD'
;
	PAGE
;
;	$MODIFY - enter modify mode
;
;	ENT	source data in memory
;
;	EXT	vector made back to source routine
;
;	NOTE	all of the various types of modify
;		are made with this common subroutine.
;		the data will be modified at the
;		associated buffer location and will
;		be written back to disk if necessary
;
MODIFY	PUSH	IY		;save all registers
	PUSH	IX
	PUSH	HL
	PUSH	DE
	PUSH	BC
;
;	NOTE	cannot use $SAVEREG here because
;		this is not entered as a call but
;		is vectored back to the source
;
	LD	IX,3C00H+8	;hex side of video
	LD	IY,3C00H+48	;ascii side of video
	LD	DE,(ADDRES)	;address of data
;
;	compute relative offset of current cursor
;
MODWT	PUSH	DE		;DE = current address
	LD	HL,(ADDRES)	;start address
	EX	DE,HL		;HL = current
	OR	A		;clear carry
	SBC	HL,DE		;compare current to start
	LD	A,L		;get LSB
	LD	(TEMP2),A	;save offset into data
	RST	20H		;to hex ascii
	LD	(3C00H),BC	;to the video
	LD	A,5DH		;ascii pointer
	LD	(3C00H+2),A	;to the video
	POP	DE		;restore address
;
	LD	A,12		;flash counter
	LD	BC,8F00H	;B=off, C=call modfix
	CALL	FLICKSP		;special 'flasher'
;
	EX	DE,HL		;HL = data address
	LD	DE,MODWT	;leave vector on stack
	PUSH	DE		;put it there
;
	PUSH	AF		;save input key
	LD	A,(MODE)	;get modify mode
	CP	4		;ascii modify?
	JR	Z,MODCONT	;yes, skip special bytes
	POP	AF		;restore char
;
;	following 'special' commands are not
;	available under ascii modify
;
	CP	'P'		;propogate?
	JP	Z,FILBYTS
	CP	'p'
	JP	Z,FILBYTS
;
	CP	'G'		;go to relative posit?
	JP	Z,GOBYTE
	CP	'g'
	JP	Z,GOBYTE
;
	CP	'L'		;locate byte
	JP	Z,FINBYTE
	CP	'l'
	JP	Z,FINBYTE
;
	PUSH	AF		;set stack
;
MODCONT	POP	AF		;restore character
;
	LD	DE,MODTBL	;jump table for modify
	CALL	GOTABL		;go!
	JP	NUMBER		;not there, check numeric
;
MODTBL	DEFB	'>'		;insert mode?
	DEFW	INSBYTE
	DEFB	'<'		;delete mode
	DEFW	DELBYTE
	DEFB	5DH		;cursor left
	DEFW	MODL
	DEFB	5EH		;cursor right
	DEFW	MODR
	DEFB	5BH		;cursor up
	DEFW	MODU
	DEFB	5CH		;cursor down
	DEFW	MODD
	DEFB	19H		;cursor right end
	DEFW	MODRE
	DEFB	18H		;cursor left end
	DEFW	MODLE
	DEFB	1AH		;cursor bottom
	DEFW	MODDE
	DEFB	1BH		;cursor top
	DEFW	MODUE
	DEFB	3		;cursor home
	DEFW	MODTOP
	DEFB	13		;update data
	DEFW	UPDATE
	DEFB	14		;change modify base
	DEFW	CHWT
	DEFB	0		;terminator
;
	PAGE
;
;	$MODFIX - restore characters to video
;
;	ENT	DE = address of current data byte
;		IX => hex side of display
;		IY => ascii side of display
;
;	EXT	data is take from (DE) and converted
;		to hex and ascii and displayed to
;		the video
;
;	NOTE	this routine is used to correct the
;		display after a flashing cursor
;		has 'destroyed' the data
;
MODFIX	LD	A,(SHFLG)	;get hex adjust flag
	CP	':'		;on?
	LD	A,(DE)		;get data byte
	CALL	Z,ADJBYTE	;adjust on hex side
	RST	20H		;to hex ascii
	LD	(IX),C		;to the display
	LD	(IX+1),B	;LSB to display
;
	LD	A,(DE)		;fetch again
;
M00	CALL	ADJBYTE		;adjust for decrypt
	CP	' '		;displayable?
	JR	NC,N000		;yes, go!
	LD	A,'.'		;else make a period
N000	LD	(IY),A		;on ascii side video
	CP	(IY)		;still there?
	RET	Z		;yes, done
	SUB	20H		;no lower case, convert
	LD	(IY),A		;put upper case char back
	RET			;done
;
	PAGE
;
;	$CHWT	- change modify mode base
;
;	ENT	none
;
;	EXT	new modify mode base is set
;
;	NOTE	graphic blocks are flashed over
;		the base display to prompt for
;		the new mode
;
BLKS	DEFB	8FH		;used as 'prompt' chars
	DEFB	8FH
	DEFB	8FH
;
CHWT	EX	DE,HL		;HL = data address
;
CHWT1	LD	HL,BLKS		;graphic blocks
;
CHWT2	PUSH	DE		;save data address
	LD	DE,3C40H	;video display
	LD	BC,3		;length of prompt
	LDIR			;move to the video
	POP	DE		;restore data
	LD	A,12		;flash counter
	LD	(CHWT4),A	;save initial count
;
CHWT3	CALL	INKEY		;any keys?
	JR	NZ,CHWT5	;yes, interpret it
;
	LD	A,0		;fetch flash counter
CHWT4	EQU	$-1
	DEC	A		;decrement it
	LD	(CHWT4),A	;put it back
	JR	NZ,CHWT3	;not time to change
;
	LD	A,(3C40H)	;get video byte
	CP	8FH		;is it on now?
	JR	NZ,CHWT1	;nope, turn it on
	LD	HL,SPACES	;else put spaces
	JR	CHWT2		;continue
;
CHWT5	CALL	UCASE		;make it upper case
;
	CP	'H'		;hex?
	LD	B,0		;hex flag
	JR	Z,CHAVE		;yes, go!
;
	INC	B		;decimal flag
	CP	'D'
	JR	Z,CHAVE
;
	INC	B		;binary flag
	CP	'B'
	JR	Z,CHAVE
;
	INC	B		;octal flag
	CP	'O'
	JR	Z,CHAVE
	CP	'Q'
	JR	Z,CHAVE
;
	INC	B		;ascii flag
	CP	'A'
	JR	NZ,CHAVE1	;nope, invalid
;
CHAVE	LD	A,B		;get the flag
	LD	(MODE),A	;save it
;
CHAVE1	JP	SHOMODE		;display current base
;
	PAGE
;
;	$DECODE - enter DECRYPT mode
;
DECBAD	LD	HL,DECBTXT	;error text
	LD	A,'+'		;reset pointer
	LD	(DISP1),A	;set ADD
	LD	A,' '		;set modifier
	LD	(DISP2),A
	XOR	A		;set add value
	LD	(DISP3),A
	JR	DECCON		;display prompt, continue
;
DECODE	PUSH	HL		;save data vector
	LD	HL,DECTXT	;decrypt prompt
;
DECCON	LD	DE,3C00H+768	;where on video
	LD	BC,4		;length to display
	LDIR			;move to video
;
DECOKG	LD	HL,3C00H+832	;move cursor to next line
	LD	(CURSOR),HL	;set cursor position
	LD	B,16		;16 chars to input
	RST	10H		;fetch keyboard input
;
;	clear prompt and input lines
;
	PUSH	HL		;save input pointer
	EX	AF,AF'		;save character
	LD	HL,SPACES	;clear input line
	LD	BC,16		;16 chars
;
	PUSH	HL		;save spaces
	PUSH	BC		;save length
	LD	DE,3C00H+832	;prompt video location
	LDIR			;clear it
	POP	BC		;get count
	POP	HL		;get spaces
	LD	DE,3C00H+896	;input video location
	LDIR			;clear it
	POP	HL		;get input pointer
	EX	AF,AF'		;get first input char
;
	JR	Z,MNOTH		;Z = nil input, reset
	CALL	UCASE		;make it upper case
;
	CP	'!'
	JP	Z,PERMDEC	;make it permanent?
;
	CP	':'		;set hex adjust?
	CALL	Z,SETDEC
	CP	'*'		;clear hex adjust?
	CALL	Z,SETDEC
;
	CP	5BH		;up arrow?
	JP	Z,DECCUP
	CP	5CH		;down arrow?
	JP	Z,DECCDN
;
	CP	'A'		;set AND?
	JR	Z,DOAND
	CP	'O'		;set OR?
	JR	Z,DOAND
	CP	'X'		;set XOR?
	JR	Z,DOAND
	CP	'R'		;set ROTATE?
	JR	Z,DOROT
	CP	'S'		;set SHIFT?
	JR	Z,DOROT
;
	CP	'+'		;ADD?
	JR	Z,MEXEX
	CP	'-'		;SUBTRACT?
	JR	NZ,MEXXE
;
MEXEX	LD	(DISP1),A	;save specifier type
	INC	HL		;bump input pointer
;
MEXXE	CALL	VALUE		;get offset value
	JR	C,DECBAD	;error, go!
	LD	(DISP3),A	;save offset value
;
MDONEY	LD	A,' '		;clear modifier byte
	LD	(DISP2),A	;by setting to space
;
MDONE	LD	HL,SPACES	;clear prompter
	LD	DE,3C00H+768	;where on video
	LD	BC,16		;length
	LDIR			;clear it!
;
	POP	DE		;restore data source
	JP	RETMOD		;return to modify
;
;	nothing entered, reset decrypt to nil
;
MNOTH	LD	A,'+'		;set ADD
	LD	(DISP1),A	;save it
	XOR	A		;add 00
	LD	(DISP3),A	;save value
	LD	A,'*'		;turn off hex adjust
	LD	(SHFLG),A	;save it
	JR	MDONEY		;resume
;
;	AND, OR, XOR selected
;
DOAND	LD	(DISP1),A	;save decode type
	INC	HL		;bump pointer
	CALL	VALUE		;get numeric field
	JP	C,DECBAD	;invalid numeric
	LD	(DISP3),A	;else save value
	JR	MDONEY		;resume
;
;	ROTATE or SHIFT selected
;
DOROT	LD	(DISP1),A	;save type
	INC	HL		;bump string
	LD	A,(HL)		;fetch next char
	CALL	UCASE		;make it upper case
;
	CP	'R'		;RIGHT?
	JR	Z,DOROT1
	CP	'L'		;LEFT?
	JP	NZ,DECBAD
DOROT1	LD	(DISP2),A	;save modifier type
	INC	HL		;bump pointer
;
	CALL	VALUE		;get numeric field
	JP	C,DECBAD	;error, go!
;
	CP	8		;must be 0-7
	JP	NC,DECBAD	;error if >8
	LD	(DISP3),A	;else save offset
	JR	MDONE		;continue
;
;	setup max value on rotate/shift to 8
;
FGST	CALL	SHOWLF		;re-display left side
	LD	A,(DISP1)	;get decode type
	LD	B,8		;max value shift rotate
	CP	'R'		;rotate?
	RET	Z		;yes return
	CP	'S'		;shift?
	RET	Z		;yes, return
	LD	B,0		;else no max
	RET			;return
;
;	add displacement offset, check for max
;
GFST	LD	A,(DISP3)	;get decode value
	ADD	A,C		;add offset (+/-)
	CP	B		;test for max
	LD	(DISP3),A	;update value
	RET			;return with flags
;
;	* or : specified, setup hex side adjust
;
SETDEC	LD	(SHFLG),A	;save the flag
	INC	HL		;bump pointer
	CALL	POSHL		;any more input?
	RET	NZ		;yes, return
	POP	HL		;else pop caller address
	JP	MDONE		;and resume
;
;	decode 'scan' mode with increment
;
DECCUP	CALL	GCOUNT		;get delay factor
	JP	C,DECBAD	;error, try again
	POP	DE		;fetch data address
	PUSH	DE		;put it back
	CALL	FGST		;setup and fetch max
	LD	C,1		;increment by one
;
DECCUP1	CALL	SHOW		;display adjusted data
	CALL	DOSPEED		;wait specified delay
	CALL	GFST		;inc offset
	JR	NZ,DECCUP1	;not at max, go more
	JP	MDONE		;else completed
;
;	decode 'scan' mode with decrement
;
DECCDN	CALL	GCOUNT		;get delay factor
	JP	C,DECBAD	;invalid, try again
	POP	DE		;fetch data address
	PUSH	DE		;re-save it
	CALL	FGST		;set count and get max
	LD	C,-1		;for subtract
;
DECCDN1	CALL	SHOW		;display adjusted data
	CALL	DOSPEED		;wait user delay
	CALL	GFST		;decrement and check max
	JR	NZ,DECCDN1	;not done, go more
	JP	MDONE		;else complete, return
;
;	fetch user defined delay factor
;
GCOUNT	INC	HL		;bump string pointer
	LD	BC,8000H	;default time (1/2 sec)
	CALL	POSHL		;any input?
	JR	Z,GCOUNT1	;nope, use default
	CALL	VALUE		;else fetch value
	RET	C		;error, return
;
	LD	B,C		;move LSB > MSB
	LD	C,0		;BC = value * 256
;
GCOUNT1	LD	(DLYCNT),BC	;save delay value
	OR	A		;clear carry flag
	RET			;back to caller OK
;
;	wait for user defined delay factor
;
DOSPEED	PUSH	BC		;save inc/dec
	LD	BC,0		;fetch time delay
DLYCNT	EQU	$-2
	CALL	DELAY		;countdown!
	POP	BC		;restore inc/dec
	CALL	PAUSE		;check for pause key
;
;	check for @ key to cancel operation
;
	LD	A,(3801H)	;read keyboard
	BIT	0,A		;@ pressed?
	RET	Z		;nope, return
	POP	HL		;remove caller address
	JP	MDONE		;resume modify mode
;
DECBTXT	DEFM	'ERR '		;error prompt
DECTXT	DEFM	'DCR '		;decrypt prompt
;
;	make current decrypt mode permanent
;
PERMDEC	LD	HL,(ADDRES)	;fetch data address
	LD	B,0		;set loop for 256 bytes
;
PERMLXP	LD	A,(HL)		;fetch a byte
	CALL	ADJBYTE		;adjust to curr decrypt
	LD	(HL),A		;put it back
	INC	HL		;bump data pointer
	DJNZ	PERMLXP		;do full page (256 bytes)
	JP	MNOTH		;reset to nil
;
