; supzapa/asm - kjw/bqsd - 08/79 - 08/82
;
	TITLE	'<Disk Zap - Section A>'
;
	PAGE
;
;	$DISDSK - Zap - Display Disk Sectors
;
DISDSK	CALL	GETDAT		;get drive, track, sector
	RST	8		;clear screen
;
	DEFB	7
	DEFB	0
;
	CALL	INITBD1		;enable $BADRD
;
;	due to the fact that this routine will allow
;	non-standard tracks/sectors to be read in,
;	when it is finished the track number in the
;	FDC register may not hold the correct contents
;	By simply setting (TASKDRV)=0, when the
;	routine has completed or BREAK has been pressed,
;	the DCT will be set to force SU+ to issue a
;	$RESTORE command on the next access.
;	This allows SU+ to correct the FDC track register
;	This is only performed if the ! specifier
;	is issued to indicate non-standard sectors
;
	LD	A,(IY+3)	;fetch relative track
	LD	(TRUE),A	;save TRUE track
;
DISKLP	CALL	DSTAT		;drive ready?
	JP	NZ,4018H	;nope, abort the routine
;
;	reset error condition flag for IBM prompt
;
	XOR	A		;no error
	LD	(ZAPFLAG),A	;error type flag
;
;	check for normal read
;
	LD	(SECTOR),DE	;save track/sector
	LD	A,(FLAGB)	;system flag B
	AND	2		;bit 1 set?
	JR	Z,DKSRT		;nope, read it normal!
;
;	non-standard issued, force $RESTORE next
;	drive access
;
	XOR	A		;NOP opcode
	LD	(TASKDRV),A	;save it into the code
	LD	A,(TRUE)	;fetch TRUE track
	LD	(IY+3),A	;save into DCT
	CALL	DDOSFIX		;adjust DE to RELATIVE
	LD	(RSECT),DE	;save relative sector
;
	CALL	SEEK		;seek the RELATIVE track
	POP	DE		;unstack from $DDOSFIX
	JP	NZ,XBADRD	;error, go!
;
	LD	A,(IY+3)	;get REAL track
	LD	(TRUE),A	;new TRUE track
;
;	scan ID field on disk to establish track
;
	CALL	ADDR		;read ID marks
	JR	Z,GODSKLL	;OK, go!
;
	LD	DE,(RSECT)	;fetch rel sector
	BIT	4,A		;'not found' on ID read?
	CALL	NZ,FLIPDEN	;if yes, alter density
	CALL	ADDR		;try the other density
	JR	NZ,XBADRDX	;error, display it
;
;	ID read OK, fetch track from data read in
;
GODSKLL	LD	A,(HL)		;fetch track
;i*
	IF	MODI
	LD	(37EDH),A	;give to FDC track reg
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F1H),A	;FDC track reg III
	ENDIF
;iii*
	LD	DE,(RSECT)	;fetch relative sect
	LD	D,A		;pass ID field track
	LD	(RSECT),DE	;update actual from ID
	CALL	INITBAD		;enable error monitor
;
DKSRT	LD	BC,BUFFER	;memory buffer to use
	LD	(ADDRES),BC	;save for $MODIFY
	CALL	ZBUFF		;clear it to zeroes
;
;	check for normal read
;
	LD	A,(FLAGB)	;get system flag B
	AND	2		;bit 1 set?
	JR	Z,READNRM	;no, read it normal
;
	CALL	READNS		;read with NO seek
	JR	Z,ZAPO		;ok, go!
;
	BIT	4,A		;check NOT FOUND bit
	CALL	NZ,FLIPDEN	;reverse density if set
;
	CALL	READNS		;one more time
	JR	Z,ZAPO		;ok, go!
;
	BIT	4,A		;check not found again
	CALL	NZ,FLIPDEN	;reverse if set
;
	CALL	XREAD		;try NON-IBM read
	CALL	NZ,XREAD	;if error, flip again
	JR	Z,ZAPO		;if ok, go!
	JR	XBADRD		;else go error monitor
;
;	cannot read ID marks, track flawed!
;
XBADRDX	LD	A,(TRUE)	;fetch RELATIVE track
	LD	DE,(SECTOR)	;fetch REAL tk/sec
	RST	18H		;convert A to ascii
	LD	(XBDX1),A	;put into string
	LD	(XBDX1+1),BC	;rest of it
	RST	8		;display text
;
	DEFB	7		;clear screen
	DEFB	10
	DEFM	'Track '
XBDX1	DEFM	'xxx FLAWED or NOT FORMATTED'
	DEFB	0
;
	LD	A,1		;notify error monitor
	LD	(ZAPFLAG),A	;set the flag
;
;	wait here for a key, flash a cursor
;
	LD	BC,20B0H	;on/off chars
	LD	A,12		;counter
	LD	HL,3C00H	;where to flash
	CALL	FLICKS		;flicker and get key
	RST	8		;clear screen
;
	DEFB	7
	DEFB	0
;
	JR	DISHV		;interpret key!
;
;	attempt a normal read, two tries
;
READNRM	CALL	READ		;read with seek
	JR	Z,ZAPO		;go if ok!
;
;	sector read got an error
;
XBADRD	CALL	BDRDCLS		;clear screen, go monitor
	JP	NZ,DKSRT	;retry, try again
	JR	ZAPN		;error, but SKIP, display
;
;	read OK, clear error monitor flag
;
ZAPO	XOR	A		;zero it
	LD	(ZAPFLAG),A	;save the flag
	JR	DKOK		;continue
;
;	read NOT OK, set error monitor flag
;
ZAPN	LD	A,1		;set NON zero
	LD	(ZAPFLAG),A	;save the flag
;
;	error on I/O, reset read type byte
;
;i*
	IF	MODI
	LD	A,88H		;IBM read
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,80H		;IBM read III
	ENDIF
;iii*
	LD	(RDTYPE),A	;save read type byte
;
	PAGE
;
DKOK	LD	DE,(SECTOR)	;fetch REAL trk/sect
;
DISCON	CALL	SHOW		;display HEX/ASCII data
;
DISCON1	CALL	SHOWLF		;display data source
;
;	wait here for an instruction key
;
DISWT	LD	A,12		;flash counter
	LD	BC,20B0H	;on/off bytes
	LD	HL,3C00H	;where to flash
	CALL	FLICKS		;flicker and get key
;
;	put response on video, check for displayable
;
DISHV	PUSH	AF		;save the key
	CALL	UCASE		;make it upper case
	CP	' '		;displayable?
	JR	NC,DISHVXX	;yes, go!
	LD	A,8FH		;else make it graphic
DISHVXX	LD	(3C00H),A	;to the video
	POP	AF		;restore original
;
;	check for digit 0-9 for direct paging
;
	CP	'0'		;compare
	JR	C,GOTTT		;nope, check table
	CP	'9'+1		;in range?
	JR	NC,GOTTT	;nope, go look in table
;
	SUB	'0'		;remove the ascii
	LD	E,A		;give it to E
	JP	DISKLP		;resume!
;
;	not digit, check in table
;
GOTTT	EX	DE,HL		;HL = track sector
	LD	DE,DISTBL	;jump table
	CALL	GOTABL		;is it there?
;
;	nope, restore track/sector to DE and resume
;
BADISRT	EX	DE,HL		;DE = trk/sec again
	JR	DISWT		;get another key
;
DISTBL	DEFB	'R'
	DEFW	GOREST		;lowest sector on disk
	DEFB	'M'
	DEFW	MODIFY		;modify mode
	DEFB	'@'
	DEFW	DECODE		;decrypt mode
	DEFB	'H'
	DEFW	HEXIT		;hex modify
	DEFB	'A'
	DEFW	ASCIT		;ascii modify
	DEFB	'B'
	DEFW	BINIT		;binary modify
	DEFB	'D'
	DEFW	DECIT		;decimal modify
	DEFB	'O'
	DEFW	OCTIT		;octal modify
	DEFB	5BH
	DEFW	TRKUP		;one track up
	DEFB	5CH
	DEFW	TRKDN		;one track down
	DEFB	5DH
	DEFW	SECDN		;dec sector
	DEFB	5EH
	DEFW	SECUP		;inc sector
	DEFB	18H
	DEFW	SECBOT		;lowest sector
	DEFB	19H
	DEFW	SECTOP		;highest sector
	DEFB	1AH
	DEFW	TRKBOT		;lowest track
	DEFB	1BH
	DEFW	TRKTOP		;highest track
	DEFB	','
	DEFW	BAKSEC		;back next readable sec
	DEFB	'.'
	DEFW	FORSEC		;forward next readable
	DEFB	'<'
	DEFW	BAKSEC		;back next readable
	DEFB	'>'
	DEFW	FORSEC		;forward next readable
	DEFB	'('
	DEFW	LOSEC		;lowest readable sector
	DEFB	')'
	DEFW	HISEC		;highest readable sector
	DEFB	3
	DEFW	NEWDTS		;new drive, track, sector
	DEFB	'T'
	DEFW	NEWTS		;new track, sector
	DEFB	'S'
	DEFW	NEWS		;new sector
	DEFB	0		;terminator
;
;	$NEWDTS - prompt for new drive, track, sector
;
NEWDTS	RST	8		;clear screen
;
	DEFB	7
	DEFB	0
;
	JP	DISDSK		;back to entry point!
;
;	$NEWS - prompt for new sector
;
NEWS	EX	DE,HL		;DE = track/sector
	RST	8		;display prompt
;
	DEFB	7		;clear screen
	DEFM	'Sector ? '
	DEFB	0
;
	LD	B,30		;30 keys allowed input
	RST	10H		;fetch key input
	JR	Z,LSDIR		;re-fetch original
;
	CALL	POSHL		;any input?
	JR	Z,LSDIR		;nope, back to orig
;
	CALL	VALUE		;fetch the value
	JR	C,NEWS+1	;error, ask again
	LD	E,C		;pass value
	JP	DISDSK+3	;read and display it
;
;	$NEWTS - prompt for new track and sector
;
NEWTS	EX	DE,HL		;DE = track/sector
	RST	8		;display prompt
;
	DEFB	7		;clear screen
	DEFM	'Track, Sector ? '
	DEFB	0
;
	LD	B,30		;30 char key input
	RST	10H		;get key input!
	JR	Z,LSDIR		;nil, get original back
;
	CALL	POSHL		;any input?
	JR	Z,LSDIR		;nope, go original!
;
	CALL	UCASE		;make it upper case
	CP	'D'		;directory?
	JR	Z,USDIR		;yes, use directory
;
	CP	5CH		;lowest track?
	JR	Z,BSDIR		;yes, go!
;
	CP	5BH		;highest track?
	JR	Z,TSDIR		;yes, go!
;
;	nothing special, prepare defaults
;
	LD	D,0		;track 0
	CALL	FIRSTS		;lowest sector to E
;
HERIO	CALL	VALUE		;get the value of input
	JR	C,NEWTS+1	;error, ask again
	LD	D,C		;pass value
;
NXDIR	CALL	POSHL		;any more?
	JP	Z,DISDSK+3	;nope, go!
;
	CALL	VALUE		;get the value
	JR	C,NEWTS+1	;error, ask again
	LD	E,C		;load sector
	JP	DISDSK+3	;restart, go!
;
LSDIR	LD	DE,(SECTOR)	;fetch original trk/sec
	JP	DISDSK+3	;go!
;
TSDIR	LD	D,(IY+0)	;get physical tracks
	DEC	D		;less one for top track
;
CSDIRZ	CALL	FIRSTS		;lowest sector on track
	INC	HL		;bump string for more inp
	JR	NXDIR		;get more data
;
BSDIR	LD	D,0		;set lowest track
	JR	CSDIRZ		;fetch lowest sector
;
USDIR	LD	D,(IY+2)	;get directory track
	JR	CSDIRZ		;load first sector
;
	PAGE
;
;	set modify mode number base
;
HEXIT	XOR	A		;HEX flag
	JR	ITCONT		;go!
;
DECIT	LD	A,1		;DECIMAL flag
	JR	ITCONT		;go!
;
BINIT	LD	A,2		;BINARY flag
	JR	ITCONT		;go!
;
OCTIT	LD	A,3		;OCTAL flag
	JR	ITCONT		;go!
;
ASCIT	LD	A,4		;ASCII flag
;
ITCONT	LD	(MODE),A	;save mode type
	EX	DE,HL		;DE = trk/sect
;
;	determine where to return to
;
	LD	A,(TYPE)	;get source
;
	DEC	A		;from ZAP?
	JP	Z,DISCON1	;go!
;
	DEC	A		;from memory?
	JP	Z,DSMCON1	;go!
;
	DEC	A		;from files?
	JP	Z,DSFCON1	;yes, go!
;
	JP	DSMCON1		;from format, go memory
;
;	fetch highest sector on a track
;
HISEC	LD	A,0DCH		;CALL C opcode
	JR	LOSEC+2		;go common
;
;	fetch lowest sector on a track
;
LOSEC	LD	A,0D4H		;CALL NC opcode
;
	LD	(HLPWAY),A	;put into code
	EX	DE,HL		;DE = track/sector
	LD	B,20		;make 20 attempts
;
LOSECL	CALL	ADDR		;read ID marks
	JP	NZ,DISKLP	;error, skip it
	INC	HL		;head
	INC	HL		;sector
	LD	A,E		;fetch current sector
	CP	(HL)		;compare to from disk
HLPWAY	CALL	C,GETE		;load new DE depending
	DJNZ	LOSECL		;any more tries left?
	JP	DISKLP		;continue!
;
GETE	LD	E,(HL)		;load E with sector
	RET			;done
;
;	restore drive to track 0/ first sector
;
GOREST	LD	H,0		;track zero
	LD	A,(IY+5)	;get flag byte
	AND	1		;get lowest sector
	LD	L,A		;HL = first sector
;
DISRET	EX	DE,HL		;load DE back correct
	JP	DISKLP		;continue!
;
TRKUP	INC	H		;bump track
	JR	DISRET		;done!
;
TRKDN	LD	A,H		;on track 0?
	OR	A		;yes?
	JP	Z,BADISRT	;go if yes
	DEC	H		;else OK to decrement
	JR	DISRET		;resume!
;
TRKTOP	LD	H,(IY+0)	;number of tracks
	DEC	H		;highest track
	JR	DISRET		;resume!
;
TRKBOT	LD	H,0		;lowest track
	JR	DISRET		;resume!
;
SECTOP	INC	L		;force bump sector
	JR	DISRET		;resume
;
SECBOT	DEC	L		;force decrement sector
	JR	DISRET		;resume!
;
SECUP	EX	DE,HL		;DE = track/sector
	CALL	NEXSEC		;advance logically
	EX	DE,HL		;put it back in HL
	JR	NC,DISRET	;not beyond disk
;
;	beyond disk, put it back like it was
;
SECDN	EX	DE,HL		;DE = sector
	CALL	RETSEC		;retard logically
	EX	DE,HL		;back into HL
	JR	DISRET		;resume!
;
;	going back a sector on a readable basis
;	use ID field as a 'readable' criterion
;
BAKLPG	LD	E,(HL)		;fetch resulting sector
	JP	DISKLP		;resume!
;
;	back to next lower 'readable' sector
;
BAKSEC	LD	A,3DH		;DEC A opcode
	JR	BADFOR		;go common
;
;	forward to next 'readable' sector
;
FORSEC	LD	A,3CH		;INC A opcode
;
BADFOR	LD	(BAKLP3),A	;insert opcode
;
	EX	DE,HL		;DE = track/sector
	CALL	ADDR20		;read 20 ID fields
	JP	NZ,DISKLP	;error, abort it!
;
	LD	A,E		;fetch current sector
	JR	BAKLP3		;inc/decrement it
;
BAKLP1	LD	HL,DAMBUFF	;ID fields read in here
	LD	B,20		;20 of 'em
;
BAKLP2	CP	(HL)		;compare with the sector
	JR	Z,BAKLPG	;have next one available
	INC	HL		;bump table
	DJNZ	BAKLP2		;try all 20
;
;	this sector not found in ID batch
;	increment/decrement and search again
;
BAKLP3	DEC	A		;sector +1/-1
	CP	-1		;just past 0?
	JR	NZ,BAKLP1	;nope, continue!
	JP	DISKLP		;else abort, none lower
