; supsub1/asm - kjw/bqsd - 08/79 - 08/82
;
	TITLE	'<Subroutine Section #1>'
;
	PAGE
;
;	$MENU00 - force main menu for all returns
;
MENU00	XOR	A		;set sub-menu vector
	CALL	SETUPS		;set it up
	JP	RETURN		;reset all params go menu
;
	PAGE
;
;	$GETSEL	- prompt for user input, go jump table
;
;	ENT	DE => lookup table of valid responsed
;
;	EXT	exit vectored to correct table response
;
GETSEL	RST	8		;display following
;
	DEFB	10		;2 linefeeds
	DEFB	10
	DEFB	0
;
BADSEL	RST	8		;display
;
	DEFB	1EH		;clear current line
	DEFM	'Selection ? '
	DEFB	0
;
	LD	B,1		;one key to input
	RST	10H		;get from keyboard
	JR	NZ,CKTBLX	;go if input
;
;	nil input, default to first table entry
;
	LD	A,(DE)		;fetch first entry
;
CKTBLX	CALL	GOTABL		;is it valid?
	JR	BADSEL		;nope, try again
;
	PAGE
;
;	$GOTABL	- lookup vector in table
;
;	ENT	DE => lookup table (3 byte entries)
;		A  = character to locate
;
;	EXT	will return if no matches found
;		will pop caller address and vector to
;		table match if one is found
;
;	NOTE	subroutine only returns if not in table
;	NOTE	character in A is converted to upper case
;		to scan the table, but the character is
;		passed unchanged to the vector if matched
;
GOTABL	PUSH	DE		;save table start
	PUSH	HL		;need this
	EX	DE,HL		;HL => table
;
	LD	E,A		;save original here
	CALL	UCASE		;convert to upper case
;
TABLP	INC	(HL)		;test for table end
	DEC	(HL)		;0?
	JR	Z,NOTINT	;not in table
;
	CP	(HL)		;same as request?
	INC	HL		;point to vector
	JR	Z,HAVTAB	;yes, have table
	INC	HL		;bump past vector
	INC	HL
	JR	TABLP		;try next entry
;
NOTINT	POP	HL		;unstack
	LD	A,E		;fetch original char
	POP	DE		;restore table start
	RET			;not in table
;
;	table entry found!, fetch it
;
HAVTAB	LD	A,(HL)		;fetch LSB vector
	INC	HL		;bump pointer
	LD	H,(HL)		;fetch MSB pointer
	LD	L,A		;HL = vector
;
	LD	A,E		;get unadultered char
	EX	AF,AF'		;save it here
	POP	AF		;dummy pop old HL
	POP	DE		;unstack DE
;
	EX	(SP),HL		;overwrite with vector
	PUSH	AF		;put HL back on stack
	POP	HL		;get in the right place
	EX	AF,AF'		;get original A back
	RET			;all restored, go vector!
;
	PAGE
;
;	$SETUPS	- set stack and sub-menu return vector
;
;	ENT	A = sub-menu return code
;
;	EXT	SMRC saved, stack set to top
;
SETUPS	POP	HL		;get caller address
	LD	SP,STACK	;reset stack to top
	LD	(WHERE),A	;save sub-menu flag
	JP	(HL)		;return!
;
;	$INKEY	- fetch a single key
;
;	ENT	none
;
;	EXT	Z = no key available
;		NZ = A = character
;
;	NOTE	a call to KEY will return immediately
;		INKEY adds appropriate debounce
;
INKEY	CALL	KEY		;strobe with no delay
;
;	add key debounce delay
;
	PUSH	BC		;save it
	LD	BC,500H		;big delay
	CALL	DELAY		;dec BC till 0
	POP	BC		;restore it
;
	OR	A		;set flags on INKEY char
	RET			;return, A = char
;
	PAGE
;
;	$GOBACK	- exit vector to last sub-menu
;		  user is prompted to key to continue
;	$RETURN	- immediate exit to submenu
;
;	ENT	none
;
;	EXT	program vectors to last sub-menu
;
GOBACK	LD	SP,STACK	;reset stack
	CALL	PRESS		;'key enter to continue'
;
RETURN	LD	SP,STACK	;reset stack
	CALL	DLON		;reactivate DUAL if ON
;
	LD	HL,4018H	;sub-menu exit vector
	PUSH	HL		;leave on stack for ret's
;
;	reset all I/O code changes
;
;i*
	IF	MODI
	LD	A,88H		;restore IBM type reads
	LD	(RDTYPE),A
	LD	A,0A8H		;and writes
	LD	(WRTYPE),A
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	A,80H		;IBM type III
	LD	(RDTYPE),A
	LD	A,0A0H		;IBM data write III
	LD	(WRTYPE),A
;
;	read track can alter $WXFER, reset it
;
	LD	A,20H		;JR NZ opcode
	LD	(RD3FIX),A	;put into code
	LD	(WR3FIX),A	;put into write code
	ENDIF
;iii*
;
;	reset NOP into code at $STAT
;
	XOR	A		;NOP opcode
	LD	(HOLDIN),A	;put into code
;
	LD	(ZAPFLAG),A	;reset error on disk I/O
;
;	disallow *nn filespec evaluation for TRSDOS III
;	only valid with 'display file sectors'
;
	DEC	A		;set non-zero
	LD	(MOD3FIL),A	;disallow *nn type fspec
;
	LD	A,(FLAGA)	;get system flag
	RES	1,A		;enable 'alive'
	LD	(FLAGA),A	;put it back
;
	LD	A,(FLAGB)	;system flag B
	RES	1,A		;set standard I/O
	LD	(FLAGB),A	;put it back
;
;	check to see if an active disk operation
;	was interrupted
;
;i*
	IF	MODI
	LD	A,(37ECH)	;read FDC status I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;read FDC status III
	ENDIF
;iii*
	BIT	0,A		;active FDC command?
	JR	Z,NOTAXT	;nope, continue
;
	XOR	A		;set NOP opcode
	LD	(TASKDRV),A	;for drive reset
;
NOTAXT	CALL	TASKDRV		;reset drive on error
	CALL	IFSAVCF		;save config on?
	CALL	TURNSPD		;reset high speed clock
	CALL	DLON		;activate DUAL if ON
;
	LD	A,(WHERE)	;fetch sub-menu #
	INC	A		;adjust for actual
;
	LD	DE,RETADD	;jump table for sub-menus
	CALL	GOTABL		;go!
	JP	4015H		;corrupt! exit main menu
;
RETADD	DB	1
	DW	MENU		;main menu
	DB	2
	DW	ZAP		;disk zap
	DB	3
	DW	PURGE		;disk purge
	DB	4
	DW	FORMAT		;disk format
	DB	5
	DW	COPY		;disk backup
	DB	6
	DW	REPAIR		;disk repair
	DB	7
	DW	TAPE		;tape utilities
	DB	8
	DW	MEMORY		;memory utilities
	DB	9
	DW	FILES		;file utilities
	DB	10
	DW	CONFIG		;configuration
	DB	11
	DW	EXIT		;exit program
	DB	0		;term
;
	PAGE
;
;	$PRESS	- prompt user to key enter to continue
;
;	ENT	none
;
;	EXT	A = character input
;
;	all other registers preserved
;
PRESS	RST	8		;display prompt
;
	DEFB	10
	DEFM	'Key <ENTER>'
	DEFB	0
;
	JP	ONEKEY		;fetch single key
;
	PAGE
;
;	$NEXSEC	- advance to next sector
;
;	ENT	DE = current track/sector
;
;	EXT	C = disk boundary exceeded
;		NC = OK, DE still in bounds
;		DE = next track sector in sequence
;
NEXSEC	CALL	TRKEND		;fetch last sec on track
	INC	E		;bump sector
	CP	E		;at end?
	JR	NC,NEXTUI	;nope, continue
;
	INC	D		;bump the track
	CALL	FIRSTS		;load E with low sector
;
NEXTUI	LD	A,(IY+1)	;get tracks relative
	INC	A		;bump for compare
	CP	D		;beyond disk boundary?
	RET			;Carry = yes!
;
;	$RETSEC	- retard to next sector back
;
;	ENT	DE = current track/sector
;
;	EXT	DE = previous track/sector
;
;	NOTE	DE unchanged if already at the
;		first sector on a disk
;
RETSEC	PUSH	DE		;save sector
	CALL	FIRSTS		;get lowest
	LD	A,E		;fetch it
	POP	DE		;restore original
	CP	E		;at lowest sector?
	JR	Z,DOWNSEC	;yes, go back last track
;
	DEC	E		;else back a sector
	RET			;done, return
;
DOWNSEC	LD	A,D		;get track
	OR	A		;on track 0?
	RET	Z		;if yes, don't change it
;
	DEC	D		;else move back a track
	CALL	TRKEND		;get last sector on track
	LD	E,A		;give it to DE
	RET			;done, return
;
;	$TRKEND	- compute last sector on a track
;
;	ENT	D  = current track
;
;	EXT	A = highest sector on the track
;
TRKEND	LD	A,D		;fetch track
	OR	A		;on track 0?
	JR	NZ,TKEND	;nope, check remainder
;
	BIT	7,(IY+5)	;track 0 density
	JR	TKECNT		;continue
;
TKEND	BIT	6,(IY+5)	;remainder density
;
TKECNT	LD	A,9		;highest sector Single
	RET	Z		;single den, return
;
	BIT	4,(IY+5)	;relative sectoring?
	RET	NZ		;yes, use 'lumps'
;
	LD	A,(IY+5)	;get the flag
	AND	1		;A = lowest sector
	ADD	A,17		;A = highest sector
	RET			;done, return
;
;	$FIRSTS - locate first sector on track
;
;	ENT	D = current track
;
;	EXT	E = first sector on that track
;
FIRSTS	LD	A,D		;get track number
	OR	A		;check for zero
	LD	A,(IY+5)	;get system flag
	JR	NZ,FRSTG	;not zero, go!
	RRCA			;align track zero bit
FRSTG	AND	1		;A = lowest sector
	LD	E,A		;give it to E
	RET			;both have it
;
	PAGE
;
;	$ADDR20	- read 20 ID sectors into buffer
;
;	ENT	none
;
;	EXT	NZ = disk error, A = I/O status byte
;		Z = OK
;		HL => buffer containing 20 sector #'s
;
;	NOTE	this is used to locate the highest and
;		lowest sector #'s on a track
;
ADDR20	LD	B,20		;20 iterations
	LD	IX,DAMBUFF	;load into this buffer
;
ADDR20A	CALL	ADDR		;read ID field
	RET	NZ		;error, return NZ
;
	INC	HL		;head
	INC	HL		;sector
	LD	A,(HL)		;fetch sector number
	LD	(IX),A		;put into buffer
	INC	IX		;bump buffer pointer
	DJNZ	ADDR20A		;go for B # times
	XOR	A		;return ZERO
	RET			;back to caller
;
	PAGE
;
;	$GETDAT	- prompt for 'drive, track, sector'
;
;	ENT	none
;
;	EXT	(DRIVE)&(DRIV) set for drive
;		IY => drives DCT
;		DE = track sector
;
;	NOTE	defaults of the lowest possible values
;		are used if not given
;	NOTE	if first character of the input line
;		is an !, then bit one at (FLAGB) will
;		be set to tell 'display disk sectors'
;		that it is to attempt to read a non-
;		standard diskette.  Otherwise a normal
;		sector will be assumed.
;		This is a new feature and is only
;		recognized by $DISDSK
;
GETDAT	RST	8		;display following
;
	DEFB	10		;single linefeed
	DEFB	0		;terminator
;
	LD	A,(FLAGB)	;get system flag
	RES	1,A		;set 'normal' mode
	LD	(FLAGB),A	;update the flag
;
BADDAT	RST	8		;display prompt
;
	DEFB	1EH		;clear the line
	DEFM	'Drive, Track, Sector ? '
	DEFB	0
;
;	setup default values
;
	XOR	A		;default to drive 0
	LD	D,A		;default track
	CALL	SETDRV		;set up drive 0
	LD	A,(IY+5)	;get drive flag
	AND	1		;lowest sector
	LD	E,A		;DE = lowest sector
;
;	get keyboard input
;
	LD	B,35		;max chars to input
	RST	10H		;get from keyboard
	RET	Z		;nothing, use defaults
;
	CALL	POSHL		;any more input
	RET	Z		;an accident?
;
;	interpret drive and dos specifiers
;
	CP	'!'		;special char?
	JR	NZ,GTDV		;nope, check drive type
;
	LD	A,(FLAGB)	;get system flag
	SET	1,A		;set 'non-standard' read
	LD	(FLAGB),A	;put it back
	INC	HL		;bump string pointer
;
;	if mod iii, allow non-IBM length sectors
;	to be read/written
;
;iii*
	IF	MODIII
	LD	A,18H		;JR opcode
	LD	(RD3FIX),A	;put into $RXFER code
	LD	(WR3FIX),A	;put into $WXFER code
	ENDIF
;iii*
;
GTDV	CALL	FIGDRV		;compute the drive type
	JR	C,BADDAT	;error, invalid data
;
	CALL	POSHL		;any more?
	RET	Z		;nope, return
;
;	interpret track number
;
	INC	HL		;bump pointer
	CALL	UCASE		;make it upper case
;
	CP	5CH		;down arrow?
	JR	Z,LKSEC		;already there, get sect
;
	CP	'D'		;directory track?
	JR	Z,DEFDIR	;yes, get it
;
	CP	5BH		;up arrow?
	JR	Z,DEFUPT	;yes, get highest track
;
;	no defaults, get the value
;
	DEC	HL		;put it back
	CALL	VALUE		;get value
	JR	C,BADDAT	;error, return
	LD	D,C		;give track to D
;
;	interpret the sector
;
LKSEC	CALL	POSHL		;any more input?
	RET	Z		;nope, return
;
	CALL	VALUE		;get the value
	JR	C,BADDAT	;error, try again
	LD	E,C		;give sector to E
	RET			;done, all set
;
DEFDIR	LD	D,(IY+2)	;get directory track
	JR	LKSEC		;look at sector
;
DEFUPT	LD	D,(IY+1)	;relative track count
	DEC	D		;top track on disk
	JR	LKSEC		;look at sector #
;
	PAGE
;
;	$ASCII	- convert binary byte to decimal ascii
;
;	ENT	A = binary byte to convert
;
;	EXT	ACB = decimal ascii equivalent
;
ASCII	LD	B,'0'		;start ascii
;
ASC1	SUB	100		;remove a hundred
	JR	C,ASC2		;have it, go!
	INC	B		;bump ascii
	JR	ASC1		;try again
;
ASC2	PUSH	BC		;save MSB on stack
	ADD	A,100		;put it back
	LD	C,'0'		;starting 10's place
;
ASC3	SUB	10		;remove ten
	JR	C,ASC4		;done, go!
	INC	C		;bump ascii
	JR	ASC3		;try again
;
ASC4	ADD	A,'0'+10	;last sub + ascii
	LD	B,A		;give LSB to B
	POP	AF		;get msb
	RET			;ACB = ascii
;
	PAGE
;
;	$POSHL	- position HL to first significant char
;
;	ENT	HL => input string
;
;	EXT	Z = terminator found
;		NZ = HL => first significant char
;
	INC	HL		;bump pointer
POSHL	LD	A,(HL)		;fetch a character
;
	CALL	CKSEP		;check for separator
	RET	C		;carry = yes, Z set
	JR	Z,POSHL-1	;yes, skip it
;
	RET			;NC,NZ - valid char
;
	PAGE
;
;	$MOVE	- move block of memory
;
;	ENT	HL => current block address
;		DE => destination block address
;		BC =  length of block
;
;	EXT	block moved (blocks may overlay)
;
MOVE	PUSH	HL		;save from compare
	OR	A		;clear carry flag
	SBC	HL,DE		;compare source & dest
	POP	HL		;restore original
	JR	C,MOVBAK	;move backwards
;
	LDIR			;move it forwards
	RET			;block moved!
;
MOVBAK	ADD	HL,BC		;source + length
	DEC	HL		;point to last byte
;
	EX	DE,HL		;exchange
	ADD	HL,BC		;add length to dest
	DEC	HL		;point to last byte
	EX	DE,HL		;put 'em back
;
	LDDR			;move data
	RET			;data moved!
;
	PAGE
;
;	$VALUE	- extract value from input string
;
;	ENT	HL => input string to parse
;
;	EXT	C = invalid or nil input
;		NC = OK, BC = value
;
VALUE	CALL	POSHL		;position to first char
	SCF			;carry for nil
	RET	Z		;nil, return
;
	PUSH	HL		;save pointer
	CALL	POSEND		;get last character
;
;	interpret base of number specified
;
	LD	HL,ADDHEX	;hex adder
	LD	B,16		;max digit
	CP	'H'		;hex?
	JR	Z,GOVAL		;have it, go!
;
	LD	HL,ADDOCT	;octal adder
	LD	B,8		;max digit
	CP	'O'		;octal?
	JR	Z,GOVAL		;have it!
	CP	'Q'		;octal?
	JR	Z,GOVAL		;have it!
;
	LD	HL,ADDBIN	;binary adder
	LD	B,2		;max digit
	CP	'B'		;binary?
	JR	Z,GOVAL		;have it, go!
;
	LD	HL,ADDDEC	;decimal adder
	LD	B,10		;max digit
	CP	'D'		;decimal?
	JR	Z,GOVAL		;yes, go!
;
	XOR	A		;no base specified
;
GOVAL	LD	(ADDVEC),HL	;save adder vector
	LD	(VALTRM),A	;special terminator
	LD	A,B		;get max digit
	LD	(VALMAX),A	;save into code
;
	POP	HL		;restore pointer
	LD	BC,0		;starting digit
;
VALLP	LD	A,(HL)		;get a character
	CALL	UCASE		;make it upper
;
	CALL	CKSEP		;separator/terminator?
	RET	Z		;yes, return
;
	INC	HL		;bump string pointer
	CP	0		;special terminator?
VALTRM	EQU	$-1		;base of number
	RET	Z		;yes, return
;
;	check for valid digit
;
	SUB	'0'		;remove the ascii
	RET	C		;error, return
	CP	'9'+1		;0-9?
	JR	C,DIGOK		;ok so far, go!
	SUB	7		;adjust for A-F
	RET	C		;error, return
DIGOK	CP	0		;test for max
VALMAX	EQU	$-1
	CCF			;reverse the carry
	RET	C		;out of range!
;
;	multiply subtotal by base
;
	PUSH	HL		;save pointer
;
	LD	H,B		;get sub-total
	LD	L,C
	CALL	0		;multiply it!
ADDVEC	EQU	$-2
;
;	add new digit
;
	LD	C,A		;give it to C
	LD	B,0		;BC = new number
	ADD	HL,BC		;add it in
;
	LD	B,H		;give subtotal back
	LD	C,L
	POP	HL		;restore pointer
	JR	VALLP		;go more!
;
POSEND	LD	A,(HL)		;get a char
;
	CALL	CKSEP		;separator/terminator?
	JR	Z,POSND		;done if yes
;
	INC	HL		;bump pointer
	JR	POSEND		;try next character
;
POSND	DEC	HL		;put it back
	LD	A,(HL)		;get last character
	JP	UCASE		;convert and return
;
;	decimal/binary adders
;
ADDDEC	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,BC		;*5
ADDBIN	ADD	HL,HL		;*10 (*2)
	RET			;done
;
;	hex/octal adders
;
ADDHEX	ADD	HL,HL		;*2
ADDOCT	ADD	HL,HL		;*4 (*2)
	ADD	HL,HL		;*8 (*4)
	ADD	HL,HL		;*16 (*8)
	RET			;done
;
	PAGE
;
;	$EXIT	- exit program
;
;	ENT	none
;
;	EXT	exit made to bootstrap in ROM
;
;	NOTE	user is prompted to mount a system
;		system disk and press enter
;
EXIT	XOR	A		;setup BREAK to menu
	CALL	SETUPS		;set it up
;
	CALL	SETDRV		;setup for drive 0
	CALL	MNTSYS		;mount system disk
;
;	on a mod I, do not jump to 0000 while the
;	disk drive is turning or a the ROM will not
;	detect the correct drive status
;
;i*
	IF	MODI
FDCWAIT	LD	A,(37ECH)	;get FDC status byte
	RLCA			;check bit 7
	JR	NC,FDCWAIT	;wait for motor to go off
	ENDIF
;i*
	CALL	SPDOFF		;high speed clock OFF
;
;	disable serial number checksum byte
;	if program is re-entered, the interrupt
;	routine will clear out the program
;
	XOR	A		;set zero
	LD	(SERCHK),A	;clear checksum
;i*
	IF	MODI
	HALT			;boot Mod I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	RST	0		;boot Mod III
	ENDIF
;iii*
;
	PAGE
;
;	$MNTSRC	- prompt for source disk mount
;	$MNTDES	- prompt for dest disk mount
;	$MNTSYS	- prompt for system disk mount
;
;	ENT	none
;
;	EXT	A = char pressed during mount prompt
;
MNTSRC	RST	8		;display message
;
	DEFB	10
	DEFM	'Mount SOURCE'
	DEFB	0
;
	JR	MOCOMM		;go common
;
MNTDES	RST	8		;display prompt
;
	DEFB	10
	DEFM	'Mount DESTINATION'
	DEFB	0
;
	JR	MOCOMM		;go common
;
MNTSYS	RST	8		;display prompt
;
	DEFB	10
	DEFM	'Mount SYSTEM'
	DEFB	0
;
MOCOMM	CALL	DRVASC		;fetch ascii drive #
	LD	(WDVV),A	;put into the string
	RST	8		;display following
;
	DEFM	' Disk on Drive '
WDVV	DEFM	'x'
	DEFB	0
;
	PAGE
;
;	$ONEKEY	- fetch a key from keyboard
;
;	ENT	NONE
;
;	EXT	A = char pressed
;		current display line is erased
;
ONEKEY	PUSH	HL		;save 'em
	PUSH	BC
;
	LD	B,1		;one key to input
	RST	10H		;fetch from keyboard
;
	POP	BC		;unstack 'em
	POP	HL
;
	RST	8		;display following
;
	DEFB	1EH		;clear the line
	DEFB	0		;term
;
	RET			;done, return
;
	PAGE
;
;	$DRVCOMM - execute subroutine multiple drives
;
;	ENT	DE = subroutine address for active drives
;		BC = return vector when completed
;
;	EXT	to (BC) when all drives completed
;
;	NOTE	a drive is indicated as being active
;		in this command if bit 3 of DCT+5
;		is set
;	NOTE	HL is preserved to all subroutines
;		IY points to the current drive DCT
;
DRVCOMM	XOR	A		;set current drive to 0
	LD	(RETN1),DE	;subroutine address
	LD	(RETN2),BC	;return vector
;
DRVLP	LD	(POSA),A	;save current drive
	CALL	SETDRV		;setup for disk activity
;
	BIT	3,(IY+5)	;drive enabled?
	CALL	NZ,0		;call subroutine if yes
RETN1	EQU	$-2
;
	LD	A,(POSA)	;fetch current drive
	INC	A		;bump it
	CP	8		;test for max
	JR	C,DRVLP		;more to do, go!
;
	JP	0		;else return to caller
RETN2	EQU	$-2
;
	PAGE
;
;	$INITDRV - activate all drives
;	$INITDVO - deactivate all drives
;
;	ENT	none
;
;	EXT	all drives set as active/inactive by
;		setting/resetting bit 3 of DCT+5
;
;	NOTE	this is the normal setup for a call
;		being made to $DRVCOMM
;
INITDVO	PUSH	AF		;save AF
	LD	A,8		;mask for bit ON
	JR	INITDV		;go common
;
INITDRV	PUSH	AF		;save it
	XOR	A		;mask for bit OFF
;
INITDV	PUSH	BC		;save from use
	PUSH	IY		;save too
	LD	C,A		;give mask to C
	XOR	A		;drive 0
	LD	B,A		;save it here
;
INITLP	CALL	SETDRV		;locate the DCT
	LD	A,(IY+5)	;get mask
	AND	0F7H		;all but bit 3
	OR	C		;merge with mask
	LD	(IY+5),A	;put back into DCT
;
	INC	B		;bump drive
	LD	A,B		;fetch it
	CP	8		;0-7?
	JR	C,INITLP	;do more
;
	POP	IY		;unstack
	POP	BC
	POP	AF
	RET			;done, return
;
	PAGE
;
;	$ZBUFF	- clear out memory buffer
;
;	ENT	BC => 256 byte buffer
;
;	EXT	buffer filled with zeroes
;		all registers preserved
;
ZBUFF	PUSH	HL		;save 'em
	PUSH	DE
	PUSH	BC
;
	LD	H,B		;give buffer to HL
	LD	L,C
;
	LD	D,H		;and to DE
	LD	E,L
	INC	DE		;start +1
;
	LD	BC,255		;length -1
	LD	(HL),0		;put a zero
	LDIR			;put all zeroes
;
	POP	BC		;unstack & return
	POP	DE
	POP	HL
	RET
;
	PAGE
;
;	$UCASE - convert character to upper case
;
;	ENT	A = character
;
;	EXT	A = character in upper case
;
UCASE	CP	'a'		;already upper?
	RET	C		;yes, don't change it
;
	CP	'z'+1		;non alpha?
	RET	NC		;yes, skip it
;
	AND	5FH		;make it upper case
	RET			;done, return
;
	PAGE
;
;	$FIGDRV	- evaluate user drive specifiers
;
;	ENT	HL => drive specifications
;
;	EXT	C = invalid characters found
;		NC = OK, drive set for I/O activity
;		IY => drives DCT
;		HL => next char after drive specifiers
;
FIGDRV	LD	A,(HL)		;get a character
;
	SUB	'0'		;remove ascii
	RET	C		;error, return
	CP	8		;0-7 valid only!
	CCF			;reverse carry flag
	RET	C		;error, return
;
	CALL	SETDRV		;setup drive for activity
	INC	HL		;bump pointer
;
	LD	A,(HL)		;get next char
	CALL	CKSEP		;done?
	SCF			;clear carry
	CCF
	RET	Z		;done if yes
;
	CALL	UCASE		;else make it upper case
	CALL	CKCONF		;check for valid type
	RET	C		;nope, error
	INC	HL		;bump pointer
;
	LD	A,(HL)		;get next char
	CALL	CKSEP		;separator?
	SCF
	CCF			;turn off carry
	RET	Z		;yes, done!
;
	CP	'='		;track specifier
	JR	Z,CKTKS		;yes, get tracks
;
	CALL	CKDSKT		;check disk type
	RET	C		;error
	INC	HL		;bump pointer
;
	LD	A,(HL)		;get the char
	CALL	CKSEP		;sep/term?
	SCF			;clear carry
	CCF
	RET	Z		;yes, return
;
	CP	'='		;track specifier?
	SCF			;error if not
	RET	NZ		;error!
;
CKTKS	PUSH	BC		;save it
	CALL	VALUE		;get track value
	LD	A,C		;get it
	POP	BC		;restore
	RET	C		;error, return
;
	LD	(IY+0),A	;real track count
	PUSH	DE		;save it
	DEC	A		;highest track on disk
	LD	D,A		;give to D
	CALL	TRKEND		;last sector
	LD	E,A		;DE = last sector on disk
	CALL	DDOSFIX		;adjust to relative track
	LD	A,D		;get highest track
	INC	A		;for track count
	LD	(IY+1),A	;relative track count
	POP	DE		;from $DDOSFIX
	POP	DE		;get original back
;
	XOR	A		;set OK
	RET			;back to caller
;
	PAGE
;
;	$TASKDRV - force $RESTORE next drive access
;
;	ENT	none
;
;	EXT	last drive accessed will be forced
;		to issue a $RESTORE next access
;
;	NOTE	this service is in case the BREAK key
;		if pressed during a $SEEK or $STEPIN
;		operation whereby the current track
;		table will not reflect the actual track
;		where the head landed, thus future
;		seek operations would be incorrect.
;		this routine will force a zero into the
;		current track table thus forcing the
;		$SEEK operation to $RESTORE the drive
;		before it is accessed next time
;
TASKDRV	NOP			;can be intercepted
	LD	A,0C9H		;RET opcode
	LD	(TASKDRV),A	;only allow one pass
;
	LD	A,(DRIV)	;get current drive
	CALL	SETDRV		;locate the DCT
	LD	(IY+3),0	;current track to zero
	RET			;done
;
	PAGE
;
;	$IFSAVCF - check for 'save configuration'
;
;	ENT	none
;
;	EXT	if ON, drive DCT's are restored
;		to their saved conditions
;
IFSAVCF	LD	A,(FLAGA)	;get system flag
	BIT	4,A		;save ON?
	RET	Z		;nope, return
;
	LD	BC,0800H	;B=looper, C=drive #
;
SVDLP	LD	A,C		;get drive
	CALL	SETDRV		;locate the DCT
	LD	A,(IY+7)	;get saved byte
	LD	(IY+5),A	;put it back
	LD	A,(IY+8)	;get saved #2
	LD	(IY+6),A	;put it back
;
	INC	C		;bump drive #
	DJNZ	SVDLP		;do all 8
	RET			;done
;
	PAGE
;
;	$TURNSPD - activate/deactivate high speed clock
;
;	ENT	none
;
;	EXT	clock turned on or off
;
TURNSPD	LD	A,(FLAGA)	;get system flag
	BIT	6,A		;high speed on?
	JR	NZ,SPDON	;yes, turn it on
;
SPDOFF	LD	A,0		;user instructions!
	OUT	(0FEH),A
	NOP
	NOP
	RET
;
SPDON	LD	A,1		;user configurable!
	OUT	(0FEH),A
	NOP
	NOP
	RET
;
;	$CKSEP	- check for separator/terminator
;
;	ENT	A = char to check
;
;	EXT	C = terminator (13)
;		Z = separator (space,comma)
;		NZ = none
;
CKSEP	CP	13		;terminator?
	SCF			;carry = yes
	RET	Z		;yes, return
;
	CP	' '		;separator?
	RET	Z		;Z = yes
	CP	','		;sep?
	RET			;Z = yes
;
	PAGE
;
;	$CKCONF - check for valid dos specifier
;
;	ENT	A = specifer to check
;
;	EXT	C = invalid
;		NC = OK, DCT adjusted accordingly
;
;	valid dos specifiers
;
;	T = TRSDOS
;	L = LDOS
;	D = DOSPLUS
;	M = MULTIDOS
;	N = NEWDOS
;	B = DOUBLEDOS
;	* = UNDEFINED SYSTEM
;
CKCONF	PUSH	BC		;save it
	PUSH	DE		;save for table
	LD	B,80H		;starting bit
	LD	DE,DOSTBL	;dos jump table
	CALL	GOTABL		;go jump table
	SCF			;not found!
	JR	CONFRET		;return
;
UDOS	SRL	B		;undefined dos
EDOS	SRL	B		;extra dos slot
BDOS	SRL	B		;double dos
NDOS	SRL	B		;newdos
MDOS	SRL	B		;multidos
DDOS	SRL	B		;dos+
LDOS	SRL	B		;ldos
TDOS	OR	A		;trsdos
;
	LD	(IY+6),B	;put in dos byte
;
CONFRET	POP	DE		;unstack
	POP	BC
	RET			;C = bad
;
;	dos lookup table
;
DOSTBL	DEFB	'T'
	DEFW	TDOS
	DEFB	'L'
	DEFW	LDOS
	DEFB	'D'
	DEFW	DDOS
	DEFB	'M'
	DEFW	MDOS
	DEFB	'N'
	DEFW	NDOS
	DEFB	'B'
	DEFW	BDOS
	DEFB	'*'
	DEFW	UDOS
;
;	leave a slot in case a 'new' dos appears
;	just poke in the relative ASCII descriptor
;	and use bit 1 at (iy+6) to detect it!
;
EDOSLOT	DEFB	0		;extra dos slot
	DEFW	EDOS
	DEFB	0		;table terminator
;
;	$CKDSKT - check for valid disk type
;
;	ENT	A = char to check
;
;	EXT	C = invalid disk type code
;		NC = OK, DCT setup accordingly
;
;	valid disk types:
;
;	1 = single den, SD track 0, sectors 0-9
;	2 = double den, DD track 0, sectors 0-17 +R
;	3 = double den, DD track 0, sectors 1-18
;	4 = double den, SD track 0, sectors 0-17 +R
;	5 = double den, SD track 0, sectors 1-18 (0,0-9)
;
CKDSKT	SUB	'0'		;remove the ascii
	RET	C		;error, return
;
;	possibly in range, compute system mask byte
;
	PUSH	BC		;save it
	LD	B,00000000B	;mask byte
	DEC	A		;type 1?
	JR	Z,HAVDTYP	;have it, go!
;
	LD	B,11000000B	;mask byte
	DEC	A		;type 2?
	JR	Z,HAVDTYP	;have type, go!
;
	LD	B,11000111B	;mask byte
	DEC	A		;type 3?
	JR	Z,HAVDTYP	;yes, go!
;
	LD	B,01000000B	;mask byte
	DEC	A		;type 4?
	JR	Z,HAVDTYP	;yes, go!
;
	LD	B,01000001B	;mask byte
	DEC	A		;type 5?
	JR	Z,HAVDTYP	;yes, go!
;
;	leave some space for more types to 'appear'
;
	DEFW	0		;ld b,mask
	DEFB	0		;dec a
	DEFW	0		;jr z,havdtyp
;
	DEFW	0		;ld b,mask
	DEFB	0		;dec a
	DEFW	0		;jr z,havdtyp
;
	POP	BC		;unstack
	SCF			;error!
	RET			;return carry
;
HAVDTYP	LD	(IY+5),B	;insert mask
;
	POP	BC		;unstack
	INC	HL		;bump pointer
	LD	A,(HL)		;get next char
	DEC	HL		;put it back
	CALL	UCASE		;make it upper
	CP	'R'		;relative sectoring?
	SCF			;clear carry
	CCF
	RET	NZ		;nope, return
;
	SET	4,(IY+5)	;set relative sectoring
	INC	HL		;bump pointer
	RET			;carry is clear
;
