; supmenu/asm - kjw/bqsd - 08/79 - 08/82
;
	TITLE	'<Menu Selections>'
;
	PAGE
;
MENU	XOR	A		;main menu flag
	CALL	SETUPS		;set everything up
	RST	8		;display following
;
	DEFB	7		;clear screen
	DEFM	'**  SUPER-UTILITY +  **  '
	DEFM	'Version 3.0 M'
;
;	display model number of the program
;
;i*
	IF	MODI
	DEFM	'I'
	ENDIF
;i*
;
;iii*
	IF	MODIII
	DEFM	'III'
	ENDIF
;iii*
	DEFM	'  -  by '
KIM	DEFM	'Kim Watt  -'
;
	DEFB	10
	DEFM	'(c)(p) Copyright 1982  -  '
	DEFM	'Breeze/QSD, Inc. - '
	DEFM	'Dallas, Texas'
;
	DEFB	10
	DEFB	10
	DEFM	'1.  Disk Zap'
	DEFB	9
	DEFM	'6.  Tape Utilities'
;
	DEFB	10
	DEFM	'2.  Disk Purge'
	DEFB	9
	DEFM	'7.  Memory Utilities'
;
	DEFB	10
	DEFM	'3.  Disk Format'
	DEFB	9
	DEFM	'8.  File Utilities'
;
	DEFB	10
	DEFM	'4.  Disk Backup'
	DEFB	9
	DEFM	'9.  Configure System'
;
	DEFB	10
	DEFM	'5.  Disk Repair'
	DEFB	9
	DEFM	'0.  Exit Program'
	DEFB	0
;
	LD	DE,MENUWHR	;selection jump table
	JP	GETSEL		;get user selection!
;
;	jump table for menu selections
;
MENUWHR	DEFB	'1'
	DEFW	ZAP		;disk zap
	DEFB	'2'
	DEFW	PURGE		;disk purge
	DEFB	'3'
	DEFW	FORMAT		;disk format
	DEFB	'4'
	DEFW	COPY		;disk backup
	DEFB	'5'
	DEFW	REPAIR		;disk repair
	DEFB	'6'
	DEFW	TAPE		;tape utilities
	DEFB	'7'
	DEFW	MEMORY		;memory utilities
	DEFB	'8'
	DEFW	FILES		;file utilities
	DEFB	'9'
	DEFW	CONFIG		;configuration
	DEFB	'0'
	DEFW	EXIT		;exit program
	DEFB	0		;terminator
;
	PAGE
;
;	DISK ZAP Utility
;
ZAP	LD	A,1		;sub-menu flag
	LD	(TYPE),A	;save for $MODIFY
	CALL	SETUPS		;setup for menu action
	RST	8		;display following
;
	DEFB	7		;clear screen
;i*
	IF	MODI
	DEFB	140		;graphic blocks
	DEFB	183
	ENDIF
;i*
;
;iii*
	IF	MODIII
	DEFB	244
	DEFB	245		;'hand'
	DEFB	246
	ENDIF
;iii*
	DEFM	'  DISK ZAP Utilities  '
;i*
	IF	MODI
	DEFB	187
	DEFB	140
	ENDIF
;i*
	DEFB	10
	DEFB	10
	DEFM	'1.  Display Sectors'
	DEFB	9
	DEFM	'7.  Reverse Sector Data'
;
	DEFB	10
	DEFM	'2.  Verify Sectors'
	DEFB	9
	DEFM	'Exchange Sectors'
;
	DEFB	10
	DEFM	'3.  Compare Sectors'
	DEFB	9
	DEFM	'9.  String Search'
;
	DEFB	10
	DEFM	'4.  Copy Sectors'
	DEFB	9
	DEFM	'0.  Sector Search'
;
	DEFB	10
	DEFM	'5.  Copy Sector Data'
	DEFB	9
	DEFM	'A.  Read ID Address Marks'
;
	DEFB	10
	DEFM	'6.  Zero Sectors'
	DEFB	9
	DEFM	'B.  Alter DATA Address Marks'
	DEFB	0
;
	LD	DE,ZAPWHR	;jump vector table
	JP	GETSEL		;go selection!
;
ZAPWHR	DEFB	'1'
	DEFW	DISDSK		;display sectors
	DEFB	'2'
	DEFW	VERSEC		;verify sectors
	DEFB	'3'
	DEFW	COMSEC		;compare sectors
	DEFB	'4'
	DEFW	COPSEC		;copy sectors
	DEFB	'5'
	DEFW	SECDATA		;copy sector data
	DEFB	'6'
	DEFW	ZERSEC		;zero sectors
	DEFB	'7'
	DEFW	REVSEC		;reverse sectors
	DEFB	'8'
	DEFW	EXCSEC		;exchange sectors
	DEFB	'9'
	DEFW	STRSER		;string search
	DEFB	'0'
	DEFW	SECSER		;sector search
	DEFB	'A'
	DEFW	IDMARKS		;read ID marks
	DEFB	'B'
	DEFW	DAMARKS		;alter DATA marks
	DEFB	0		;table terminator
;
	PAGE
;
;	DISK PURGE Utility
;
PURGE	LD	A,2		;sub-menu return flag
	CALL	SETUPS		;set it up
	RST	8		;display following
;
	DEFB	7		;clear screen
;i*
	IF	MODI
	DEFB	140		;blocks
	DEFB	183
	ENDIF
;i*
;
;iii*
	IF	MODIII
	DEFB	244		;hand
	DEFB	245
	DEFB	246
	ENDIF
;iii*
	DEFM	'  DISK PURGE Utilities  '
;i*
	IF	MODI
	DEFB	187		;blocks
	DEFB	140
	ENDIF
;i*
	DEFB	10
	DEFB	10
	DEFM	'1.  Kill Selected Files'
	DEFB	9
	DEFM	'6.  Zero Unused Entries'
;
	DEFB	10
	DEFM	'2.  Kill by Category'
	DEFB	9
	DEFM	'7.  Zero Unused Granules'
;
	DEFB	10
	DEFM	'3.  Remove System Files'
	DEFB	9
	DEFM	'8.  Change Disk Name'
;
	DEFB	10
	DEFM	'4.  Remove All Passwords'
	DEFB	9
	DEFM	'9.  Change File Parameters'
;
	DEFB	10
	DEFM	'5.  Disk Directory'
	DEFB	9
	DEFM	'0.  Check Directory'
	DEFB	0
;
	LD	DE,PURWHR	;jump table
	JP	GETSEL		;get choice
;
PURWHR	DEFB	'1'
	DEFW	DSKDIR		;kill selected files
	DEFB	'2'
	DEFW	KILLCAT		;kill by category
	DEFB	'3'
	DEFW	RSYST		;remove system files
	DEFB	'4'
	DEFW	RPASSW		;remove passwords
	DEFB	'5'
	DEFW	DIRLIST		;disk directory
	DEFB	'6'
	DEFW	ZUNUSE		;zero unused entries
	DEFB	'7'
	DEFW	ZUGRNS		;zero unused granules
	DEFB	'8'
	DEFW	CHDNAME		;change disk name
	DEFB	'9'
	DEFW	CHFILE		;change file params
	DEFB	'0'
	DEFW	CHKDIR		;check directory
	DEFB	0
;
	PAGE
;
;	DISK FORMAT Utilities
;
FORMAT	LD	A,3		;for sub-menu return
	CALL	SETUPS		;set it up
	LD	A,2		;for $MODIFY vector
	LD	(TYPE),A	;so it can $UPDATE
	RST	8		;display menu
;
	DEFB	7		;cls
;i*
	IF	MODI
	DEFB	140		;graphics
	DEFB	183
	ENDIF
;i*
;
;iii*
	IF	MODIII
	DEFB	244		;hand
	DEFB	245
	DEFB	246
	ENDIF
;iii*
	DEFM	'  DISK FORMAT Utilities  '
;i*
	IF	MODI
	DEFB	187		;graphics
	DEFB	140
	ENDIF
;i*
	DEFB	10
	DEFB	10
	DEFM	'1.  Standard Format'
	DEFB	9
	DEFM	'4.  Build Format Track'
;
	DEFB	10
	DEFM	'2.  Special Format'
	DEFB	9
	DEFM	'5.  Write Format Track'
;
	DEFB	10
	DEFM	'3.  Format Without Erase'
	DEFB	9
	DEFM	'6.  Software Bulk Erase'
	DEFB	0
;
	LD	DE,FMTWHR	;jump table
	JP	GETSEL		;get user selection
;
FMTWHR	DEFB	'1'
	DEFW	SFMT		;standard format
	DEFB	'2'
	DEFW	UFMT		;user defined format
	DEFB	'3'
	DEFW	SFMTW		;standard w/o erase
	DEFB	'4'
	DEFW	DOBUILD		;build format track
	DEFB	'5'
	DEFW	WRBUILD		;write format track
	DEFB	'6'
	DEFW	BLKERAS		;bulk erase diskette
	DEFB	0		;term
;
	PAGE
;
;	DISK BACKUP Utilities
;
COPY	LD	A,4		;sub-menu vector
	CALL	SETUPS		;set it up
	RST	8		;display menu
;
	DEFB	7		;clear screen
;i*
	IF	MODI
	DEFB	140
	DEFB	183		;graphics
	ENDIF
;i*
;
;iii*
	IF	MODIII
	DEFB	244		;hand
	DEFB	245
	DEFB	246
	ENDIF
;iii*
	DEFM	'  DISK BACKUP Utilities  '
;i*
	IF	MODI
	DEFB	187
	DEFB	140
	ENDIF
;i*
	DEFB	10
	DEFB	10
	DEFM	'1.  Standard Disk Backup'
	DEFB	9
	DEFM	'2.  Special Disk Backup'
	DEFB	0
;
	LD	DE,CPYWHR	;jump table
	JP	GETSEL		;get user choice
;
CPYWHR	DEFB	'1'
	DEFW	SCOPY		;standard copy
	DEFB	'2'
	DEFW	UCOPY		;special copy
	DEFB	0
;
	PAGE
;
;	DISK REPAIR Utilities
;
REPAIR	LD	A,5		;sub-menu vector return
	CALL	SETUPS		;set it up
	RST	8		;display menu
;
	DEFB	7		;clear screen
;i*
	IF	MODI
	DEFB	140		;graphics
	DEFB	183
	ENDIF
;i*
;
;iii*
	IF	MODIII
	DEFB	244		;hand
	DEFB	245
	DEFB	246
	ENDIF
;iii*
	DEFM	'  DISK REPAIR Utilities  '
;i*
	IF	MODI
	DEFB	187
	DEFB	140
	ENDIF
;i*
	DEFB	10
	DEFB	10
	DEFM	'1.  Repair GAT Sector'
	DEFB	9
	DEFM	'6.  Recover Killed Files'
;
	DEFB	10
	DEFM	'2.  Repair HIT Sector'
	DEFB	9
	DEFM	'7.  Move Directory'
;
	DEFB	10
	DEFM	'3.  Repair BOOT Sector'
	DEFB	9
	DEFM	'8.  Display Directory'
;
	DEFB	10
	DEFM	'4.  Read Protect Directory'
	DEFB	9
	DEFM	'9.  Check Directory'
;
	DEFB	10
	DEFM	'5.  Un-Read Protect Directory'
	DEFB	9
	DEFM	'0.  Clear Unused Entries'
	DEFB	0
;
	LD	DE,REPWHR	;jump table
	JP	GETSEL		;get user choice
;
REPWHR	DEFB	'1'
	DEFW	REPGAT		;repair GAT
	DEFB	'2'
	DEFW	REPHIT		;repair HIT
	DEFB	'3'
	DEFW	REPBOOT		;repair BOOT
	DEFB	'4'
	DEFW	RPDIR		;read protect dir
	DEFB	'5'
	DEFW	URPDIR		;un-read protect dir
	DEFB	'6'
	DEFW	DSKDIR		;recover killed files
	DEFB	'7'
	DEFW	MOVEDIR		;move directory
	DEFB	'8'
	DEFW	DIRLIST		;display directory
	DEFB	'9'
	DEFW	CHKDIR		;check directory
	DEFB	'0'
	DEFW	ZUNUSE		;zero unused entries
	DEFB	0		;term
;
	PAGE
;
;	MEMORY Utilities
;
MEMORY	LD	A,7		;sub-menu vector
	CALL	SETUPS		;set it up
	LD	A,2		;for $MODIFY
	LD	(TYPE),A	;and $UPDATE
	RST	8		;display menu
;
	DEFB	7		;clear screen
;i*
	IF	MODI
	DEFB	140		;graphics
	DEFB	183
	ENDIF
;i*
;
;iii*
	IF	MODIII
	DEFB	244		;hand
	DEFB	245
	DEFB	246
	ENDIF
;iii*
	DEFM	'  MEMORY Utilities  '
;i*
	IF	MODI
	DEFB	187		;graphics
	DEFB	140
	ENDIF
;i*
	DEFB	10
	DEFB	10
	DEFM	'1.  Display Memory'
	DEFB	9
	DEFM	'9.  String Search'
;
	DEFB	10
	DEFM	'2.  Move Memory'
	DEFB	9
	DEFM	'0.  Input Byte From Port'
;
	DEFB	10
	DEFM	'3.  Exchange Memory'
	DEFB	9
	DEFM	'A.  Output Byte to Port'
;
	DEFB	10
	DEFM	'4.  Compare Memory'
	DEFB	9
	DEFM	'B.  Memory to Sectors'
;
	DEFB	10
	DEFM	'5.  Fill Memory'
	DEFB	9
	DEFM	'C.  Sectors to Memory'
;
	DEFB	10
	DEFM	'6.  Reverse Memory'
	DEFB	9
	DEFM	'D.  Memory to Track'
;
	DEFB	10
	DEFM	'7.  Test Memory'
	DEFB	9
	DEFM	'E.  Track to Memory'
;
	DEFB	10
	DEFM	'8.  Jump to Memory'
	DEFB	0
;
	LD	DE,MEMWHR	;jump table
	JP	GETSEL		;get user choice
;
MEMWHR	DEFB	'1'
	DEFW	DISMEM		;display memory
	DEFB	'2'
	DEFW	MOVMEM		;move memory
	DEFB	'3'
	DEFW	EXCMEM		;exchange memory
	DEFB	'4'
	DEFW	COMMEM		;compare memory
	DEFB	'5'
	DEFW	FILLMEM		;fill memory
	DEFB	'6'
	DEFW	REVMEM		;reverse memory
	DEFB	'7'
	DEFW	TESTMEM		;test memory
	DEFB	'8'
	DEFW	JUMPMEM		;jump to memory
	DEFB	'9'
	DEFW	MSTRSER		;string search memory
	DEFB	'0'
	DEFW	INPORT		;input from port
	DEFB	'A'
	DEFW	OUTPORT		;output to port
	DEFB	'B'
	DEFW	MEM2SEC		;memory to sectors
	DEFB	'C'
	DEFW	SEC2MEM		;sectors to memory
	DEFB	'D'
	DEFW	MEM2TRK		;memory to track
	DEFB	'E'
	DEFW	TRK2MEM		;track to memory
	DEFB	0
;
	PAGE
;
;	TAPE Utilities
;
TAPE	LD	A,6		;sub-menu vector
	CALL	SETUPS		;set it up
	LD	A,2		;for $MODIFY
	LD	(TYPE),A	;save source of data
	RST	8		;display menu
;
	DEFB	7		;clear screen
;i*
	IF	MODI
	DEFB	140
	DEFB	183		;graphics
	ENDIF
;i*
;
;iii*
	IF	MODIII
	DEFB	244		;hand
	DEFB	245
	DEFB	246
	ENDIF
;iii*
	DEFM	'  TAPE Utilities  '
;i*
	IF	MODI
	DEFB	187		;graphics
	DEFB	140
	ENDIF
;i*
	DEFB	10
	DEFB	10
	DEFM	'1.  Read Tape'
	DEFB	9
	DEFM	'3.  Verify Tape'
;
	DEFB	10
	DEFM	'2.  Write Tape'
	DEFB	9
	DEFM	'4.  Copy Tape'
	DEFB	0
;
	LD	DE,TAPWHR	;jump table
	JP	GETSEL		;get user choice
;
TAPWHR	DEFB	'1'
	DEFW	TAPERD		;read tape
	DEFB	'2'
	DEFW	TAPEWRT		;write tape
	DEFB	'3'
	DEFW	TAPEVER		;verify tape
	DEFB	'4'
	DEFW	TAPECOPY	;copy tape
	DEFB	0
;
	PAGE
;
;	FILE Utilities
;
FILES	LD	A,8		;for sub-menu vector
	CALL	SETUPS		;set it up
	LD	A,3		;for $MODIFY
	LD	(TYPE),A	;in display files
	RST	8		;display menu
;
	DEFB	7		;clear screen
;i*
	IF	MODI
	DEFB	140
	DEFB	183		;graphics
	ENDIF
;i*
;
;iii*
	IF	MODIII
	DEFB	244		;hand
	DEFB	245
	DEFB	246
	ENDIF
;iii*
	DEFM	'  FILE Utilities  '
;i*
	IF	MODI
	DEFB	187		;graphics
	DEFB	140
	ENDIF
;i*
	DEFB	10
	DEFB	10
	DEFM	'1.  Display File Sectors'
	DEFB	9
	DEFM	'8.  Drive Status'
;
	DEFB	10
	DEFM	'2.  Compare Files'
	DEFB	9
	DEFM	'9.  Sector Allocation'
;
	DEFB	10
	DEFM	'3.  Copy Files'
	DEFB	9
	DEFM	'0.  Build File'
;
	DEFB	10
	DEFM	'4.  Disk Directory'
	DEFB	9
	DEFM	'A.  Clear File'
;
	DEFB	10
	DEFM	'5.  Free Space'
	DEFB	9
	DEFM	'B.  Disk Allocation'
;
	DEFB	10
	DEFM	'6.  Offset File'
	DEFB	9
	DEFM	'C.  Compute Hash Code'
;
	DEFB	10
	DEFM	'7.  File Locations'
	DEFB	9
	DEFM	'D.  Compute Password'
	DEFB	0
;
	LD	DE,FILWHR	;jump table
	JP	GETSEL		;get user choice
;
FILWHR	DEFB	'1'
	DEFW	DISFILE		;display file sectors
	DEFB	'2'
	DEFW	COMFILE		;compare files
	DEFB	'3'
	DEFW	COPFILE		;copy files
	DEFB	'4'
	DEFW	DIRLIST		;disk directory
	DEFB	'5'
	DEFW	DSKFREE		;free space
	DEFB	'6'
	DEFW	OFSFILE		;offset file
	DEFB	'7'
	DEFW	FILEMAP		;file locations
	DEFB	'8'
	DEFW	DRVSTAT		;drive status
	DEFB	'9'
	DEFW	SECALLO		;sector allocations
	DEFB	'0'
	DEFW	CREATF		;create file
	DEFB	'A'
	DEFW	CLRFILE		;clear file
	DEFB	'B'
	DEFW	DALLOC		;disk allocation
	DEFB	'C'
	DEFW	CHASH		;compute hash code
	DEFB	'D'
	DEFW	CPASSW		;compute password
	DEFB	0		;terminator
;
