; supdvrs/asm - kjw/bqsd - 08/79 - 07/82
;
	TITLE	'<Resident Character I/O Package>'
;
	PAGE
;
;	$DISPLAY - RST 08 - display string to video
;
;	ENT	(SP) => data area (immed after CALL)
;		data terminates with a 00H
;
;	EXT	return to byte immed after 00H term.
;		if DUAL is on, bytes spooled to printer
;
;	ALL registers and FLAGS are preserved
;
DISPLY	EX	(SP),HL		;get data address
	PUSH	DE		;save this
	PUSH	AF		;save accum too.
	EX	DE,HL		;de => data
	LD	HL,(CURSOR)	;get cursor addr.
	CALL	OFFVID		;make sure it's in video
;
DISLP	LD	A,(DE)		;get a byte
	INC	DE		;bump the pointer
	OR	A		;check for term
	JR	Z,DISDN		;go if yes!
;
	CALL	CKDUL		;see if dual is on
	CP	20H		;control code?
	JR	C,DISCTL	;do it if <20H
;
;	automatic lower case recognition
;
	LD	(HL),A		;display the byte
	CP	(HL)		;still there?
	JR	Z,DISOK		;yes, lowercase in
	SUB	20H		;make it uppercase
	LD	(HL),A		;put it back
;
DISOK	INC	HL		;bump the cursor
	CALL	OFFVID		;see if still on video
	JR	DISLP		;continue
;
;	completed, resume at next byte after terminator
;
DISDN	LD	(CURSOR),HL	;put cursor back
	EX	DE,HL		;hl => return address
	POP	AF		;restore af
	POP	DE		;restore de
	EX	(SP),HL		;get hl back, leave ret.
	RET			;go to it
;
;	setup call to control byte
;
DISCTL	CALL	CONTRL		;make it a call
	JR	DISLP		;continue
;
;	interpret control byte
;
CONTRL	CP	8		;backspace
	JR	Z,BKSPA
;
	CP	9		;center screen?
	JR	Z,CENTR
;
	CP	10		;linefeed?
	JR	Z,LINFEED
;
	CP	13		;carriage return?
	JR	Z,LINFEED	;same thing
;
	CP	11		;up linefeed?
	JR	Z,UPFEED
;
	CP	1DH		;BOL?
	JR	Z,BOL
;
	CP	1EH		;EOL?
	JR	Z,EOL
;
	CP	7		;clear screen
	JR	Z,CLS
;
	RET			;invalid, ignore it
;
;	backspace cursor
;
BKSPA	DEC	HL		;go back one space
	JR	OFFVID		;make sure it's on video
;
;	move cursor down one row and C/R
;
LINFEED	PUSH	DE		;save it
	LD	DE,64		;64 char/line
	CALL	BOL		;get begin of line
	ADD	HL,DE		;go to next line
	POP	DE		;restore it
	JR	OFFVID		;frame it
;
;	move cursor to beginning of line
;
BOL	LD	A,L		;get lsb byte
	AND	0C0H		;put to beginning of line
	LD	L,A		;put that back
	RET			;no frame needed
;
;	move cursor to beginning of line and clear it
;
EOL	CALL	BOL		;go beginning of line
	PUSH	BC		;save these
	LD	BC,3FH		;line length -1
;
;	fill video data area
;
FIXCON	PUSH	HL		;save the rest
	PUSH	DE
	LD	D,H		;give to DE
	LD	E,L
	INC	DE		;start +1
	LD	(HL),20H	;clear byte
;
;	turn off 'alive' to assure a blank screen
;
	LD	A,(FLAGA)	;fetch system flag
	PUSH	AF		;save on stack
	SET	1,A		;turn it OFF
	LD	(FLAGA),A	;put it back
	LDIR			;put spaces all over
	POP	AF		;restore flag
	LD	(FLAGA),A	;put back original
;
	POP	DE		;unstack
	POP	HL
	POP	BC		;get 'em all back
;
;	check for cursor in valid video memory area
;
OFFVID	LD	A,H		;check for boundrys
	CP	3CH		;less than video?
	JR	NC,OFFAOK	;test one ok
	LD	HL,3C00H	;top of vid
	RET			;resume
;
OFFAOK	CP	40H		;more than top?
	RET	C		;it's OK
;
;	cursor out of bounds, scroll video & set cursor
;
	PUSH	DE		;save this
	PUSH	BC		;this too
	LD	DE,3C00H	;scroll the screen
	LD	HL,3C40H	;2'nd line
	LD	BC,3C0H		;screen less one line
	LDIR			;move it up
	POP	BC		;get 'em back
	POP	DE
;
	LD	HL,3FC0H	;bottom line new cursor
	JR	EOL		;clear bottom line
;
;	clear video screen
;
CLS	LD	HL,3C00H	;top of screen
	PUSH	BC		;save from use
	LD	BC,1023		;screen size -1
	JR	FIXCON		;fill with spaces
;
;	position cursor to center of current line
;
CENTR	LD	A,L		;get lsb cursor
	AND	0C0H		;beginning of line
	OR	20H		;put in the middle
	LD	L,A		;that goes back
	RET			;must be in video
;
;	move cursor up one line without C/R
;
UPFEED	PUSH	DE		;save from add
	LD	DE,-40H		;1 line up
	ADD	HL,DE		;move hl up
	POP	DE		;restore DE
	JR	OFFVID		;check if it's on video
;
	PAGE
;
;	$GETSTR - RST 10 - fetch string from keyboard
;
;	ENT	B = number of characters to fetch
;
;	EXT	Z = no characters input (ENTER alone)
;		NZ = characters present
;		HL => start of input string
;		C  = requested number of characters
;		B  = actual number of characters input
;		A  = first character from buffer
;
;	DE preserved
;
GETSTR	LD	C,B		;fetch requested length
	PUSH	DE		;save from use
	LD	HL,(CURSOR)	;get cursor posit
	PUSH	HL		;save a second
	INC	B		;length + 1
	LD	A,(CURSOFF)	;get cursor off char
;
;	display prompt line for key input
;
PUTPER	LD	(HL),A		;put a character
	INC	HL		;bump pointer
	DJNZ	PUTPER		;prompt displayed
	POP	HL		;restored
	LD	DE,STRING	;input buffer
;
;	loopers for keyboard input
;
CURCUR	LD	A,(CURSOFF)	;get OFF char
	JR	CUROFF		;display it
;
CURON	LD	A,8FH		;cursor ON char
CUROFF	LD	(HL),A		;display it
;
;	setup count for cursor flash
;
	LD	A,8		;1/4 second flash
	LD	(FLCOUNT),A	;save the count
;
;	loop here waiting for a key
;
SCAN	LD	A,0		;get counter
FLCOUNT	EQU	$-1
	DEC	A		;less one
	LD	(FLCOUNT),A	;resave it
	JR	NZ,SCAN2	;continue if not time
;
;	time to change the cursor char
;
	LD	A,(HL)		;get cursor char.
	CP	5FH		;off?
CURSOFF	EQU	$-1
	JR	NZ,CURCUR	;on, turn it off
	JR	CURON		;off, turn it on
;
;	check the keyboard
;
SCAN2	CALL	INKEY		;scan keyboard
	JR	Z,SCAN		;loop till have key
;
	CP	13		;enter key?
	JR	Z,SCDON
;
	CP	14		;sh enter?
	JR	Z,SCDON
;
	CP	5DH		;backspace?
	JR	Z,BAKSPCE
;
	CP	18H		;shift back?
	JR	Z,NEWST
;
	CP	3		;clear?
	JR	Z,NEWST
;
	CP	20H		;valid code?
	JR	C,SCAN		;skip if not
;
;	have a key
;
	LD	(ASVE),A	;save the key
	LD	A,B		;get length
	CP	C		;test for max
	JR	NC,SCAN		;don't take it, buff full
	LD	A,0
ASVE	EQU	$-1		;get key back
;
;	check for printer output
;
	CALL	CKDUL		;see if dual on
	LD	(HL),A		;display the byte
	LD	(DE),A		;put in buffer
	CP	(HL)		;lower case ?
	JR	Z,CHAROK	;yes if Z
	SUB	20H		;make it uppercase
	LD	(HL),A		;put it back
;
CHAROK	INC	DE		;bump buffer
	INC	B		;bump length
	INC	HL		;bump video pointer
	JR	CURCUR		;resume
;
;	completed, terminate with 13
;
SCDON	LD	A,13		;C/R terminator
	CALL	CKDUL		;check for DUAL
	CALL	DLON		;re-activate if DISABLED
	LD	(DE),A		;put into buffer
;
;	clear any remaining prompt chars
;
	LD	A,C		;get original length
	SUB	B		;less actual input
	INC	A		;+ 1 for term byte
	PUSH	BC		;save it
	LD	B,A		;give to B for looper
	LD	A,20H		;char to turn off prompt
	CALL	FILL		;clear it out
	POP	BC		;unstack
;
;	routine completed, reset stack & set flags
;
	POP	DE		;restore old DE
;
	LD	A,B		;set flags for length
	OR	A		;Z flag = B register
	LD	HL,STRING	;hl => input string
	LD	A,(HL)		;a has first char
	RET			;done
;
;	backspace a character
;
BAKSPCE	LD	A,B		;any length?
	OR	A		;yes?
	JR	Z,SCAN		;don't do it then
;
	LD	A,(CURSOFF)	;get OFF character
	LD	(HL),A		;put to the video
	DEC	HL		;move it back
	DEC	DE		;move buffer back
	DEC	B		;char. count back
	JP	CURCUR		;resume
;
;	clear entire input line and start over
;
NEWST	LD	A,B		;any length?
	OR	A		;yes?
	JP	Z,SCAN		;don't bother
;
	LD	A,(CURSOFF)	;get OFF character
;
NEWSTL	LD	(HL),A		;to the display
	DEC	HL		;pointer back
	DEC	DE		;move buffer back
	DJNZ	NEWSTL		;go till length 0
	JP	CURCUR		;cursor on, continue
;
	PAGE
;
;	$KEY	- scan keyboard for input character
;
;	ENT	none
;
;	EXT	Z = no key available
;		NZ = A = character
;
;	ALL other registers preserved
;
KEY	PUSH	HL		;save all registers
	PUSH	DE
	PUSH	BC
	LD	HL,GET		;return address
	PUSH	HL		;to the stack
;
;	check for any keys pressed right now
;
	LD	A,(387FH)	;any keys on?
	OR	A		;set flags
	JR	NZ,ADDRPT	;yes, go!
;
;	reset first key repeat counter
;
GONWKEY	LD	A,(FLAGA)	;fetch system flag
	BIT	6,A		;high speed on?
	LD	A,30		;normal speed value
	JR	Z,I80		;no, go!
	LD	A,60		;double speed value
I80	LD	(DLY1),A	;insert delay
;
;	reset between key delay counter
;
CONTRPT	LD	A,(FLAGA)	;fetch system flag
	BIT	6,A		;high speed on?
	LD	A,4		;normal repeat speed
	JR	Z,I85		;go if not on
	LD	A,8		;double time speed
I85	LD	(DLY2),A	;stash it
	JR	KIGO		;go single key
;
;	check for current key same as last key
;
ADDRPT	CP	0		;same as last key?
LSTKEY	EQU	$-1
	LD	(LSTKEY),A	;put into mask byte
	JR	NZ,GONWKEY	;go to new key if not
;
;	same as last, check for first repeat time
;
	LD	A,0		;get first key count
DLY1	EQU	$-1
	OR	A		;down to 0 yet?
	JR	Z,CKDLY2	;if yes, check delay2
	DEC	A		;reduce it on this pass
	LD	(DLY1),A	;put it back
	JR	KIGO		;continue, skip for now
;
;	key is repeating, check for between key delay
;
CKDLY2	LD	A,0		;get between key count
DLY2	EQU	$-1
	DEC	A		;less one
	LD	(DLY2),A	;back
	JR	NZ,KIGO		;go if not time
;
;	time to repeat the key, clear out the key mask
;
	LD	HL,KEYBRD	;keyboard mask area
	LD	DE,KEYBRD+1	;7 byte last key mask
	LD	BC,6		;length -1
	LD	(HL),0		;put in a zero
	LDIR			;put all zeroes
	JR	CONTRPT		;reset counter
;
;	mask area all set for repeat, scan key matrix
;
KIGO	LD	HL,KEYBRD	;work area
	LD	BC,3801H	;keyboard memory
	LD	D,0		;row counter
;
NEXROW	LD	A,(BC)		;get key byte
	LD	E,A		;save it here
;
;	compare to mask area to see if it's a new key
;
	XOR	(HL)		;compare to last scan
	LD	(HL),E		;save new key in mask
	AND	E		;same as last key?
	JR	NZ,HAVEIT	;have a new one
;
;	not a new key, continue to next matrix row
;
	INC	D		;bump row count
	INC	L		;bump mask byte
	RLC	C		;move key memory
	JP	P,NEXROW	;go for 7 rows
	RET			;done, Z flag set
;
;	have a new key, decode into ASCII
;
HAVEIT	LD	E,A		;save masked byte
	LD	A,D		;get row counter
	RLCA			;*2
	RLCA			;*4
	RLCA			;*8
	LD	D,A		;row * 8
	LD	C,1		;column mask bit
;
MKT1	LD	A,C		;fetch mask
	AND	E		;this the right key?
	JR	NZ,MKT2		;yup, go!
;
	INC	D		;bump row*8
	RLC	C		;shift mask bit left
	JR	MKT1		;continue
;
MKT2	LD	A,(FLAGA)	;get system flag
	LD	C,A		;save it here
	LD	A,(3880H)	;get shift key
	LD	B,-1		;set mask for shift
	OR	A		;any bits on?
	JR	NZ,KI3		;continue if yes
	INC	B		;else clear B
;
KI3	LD	A,D		;get value back
	ADD	A,40H		;make it ascii
	CP	60H		;a-z?
	JR	NC,LXH3		;go if not
;
;	check for upper case lock switch
;
	RRC	C		;reverse lower case?
	JR	C,REVKEY	;works reverse if -1
	RRC	B		;shift key pressed?
	JR	NC,GOTKEY	;have the key
	ADD	A,20H		;make it lower
;
;	check to see if control code issued
;
CKCTL	LD	D,A		;save char
	LD	A,(3840H)	;get last row
	AND	10H		;down arrow?
	LD	A,D		;get char back
	JR	Z,GOTKEY	;continue if not
;
;	have a control code, adjust it
;
	CALL	UCASE		;make it upper case
	SUB	40H		;make it a control key
	JR	GOTKEY		;continue
;
;	check for case reverse with case lock switch
;
REVKEY	RRC	B		;shift key on?
	JR	C,CKCTL		;have the key
	ADD	A,20H		;make it lower
	JR	GOTKEY		;continue
;
;	check for keys that need special attention
;
LXH3	SUB	70H		;check for last row
	JR	NC,LXH5		;get byte from table
;
	ADD	A,40H		;adjust ascii back
	CP	3CH		;test for =*/
	JR	C,LXH4		;don't adjust
;
	XOR	10H		;works backwards
LXH4	RRC	B		;shift key?
	JR	NC,GOTKEY	;continue if not
	XOR	10H		;reverse back
	JR	GOTKEY		;continue
;
;	special last row key, fetch from table
;
LXH5	RLCA			;double it for table
	RRC	B		;check for shift
	JR	NC,LXH6		;go
	INC	A		;add one for shift entry
LXH6	LD	HL,KEYTABL	;look up key table
	LD	C,A
	LD	B,0		;bc=displacement
	ADD	HL,BC
	LD	A,(HL)		;get the byte
;
;	have a key, check for special commands
;
GOTKEY	CP	4		;sh clear?
	JR	Z,SCRNPRT	;screen printer
;
;	check for shift 0 (case lock switch reverse)
;
	CP	20H		;check for sh 0
	RET	NZ		;not that
;
;	shift 0 same ascii as space, check which one
;
	LD	D,A		;save 
	LD	A,(3880H)	;check shift key
	OR	A		;see if pressed
	LD	A,D		;fetch key back
	RET	Z		;nope, return
;
;	toggle upper case lock switch
;
	LD	A,(FLAGA)	;get system flag
	XOR	1		;reverse bit 0
	LD	(FLAGA),A	;put it back
	XOR	A		;return no keys
	RET			;done
;
;	return vector for keyboard
;
GET	POP	BC		;unstack and return
	POP	DE
	POP	HL
	OR	A		;set actual flags
	RET			;back to caller
;
;	special output routine for DUAL
;
CKDUL	LD	(CKDSAV),A	;save the character
	LD	A,(FLAGA)	;get system flag
	AND	80H		;check bit 7
	LD	A,0		;get char back
CKDSAV	EQU	$-1
	RET	Z		;dual NOT ON
	JR	POUT		;else send to printer
;
;	$DLON	- enables DUAL if ON
;	$DLOFF	- disables DUAL
;
;	this routine is usually used by
;	repetitive messages to turn on/off DUAL
;	when reading sectors, the 'reading ...'
;	message is not displayed, etc.
;
DLON	PUSH	AF		;save the flags
	LD	A,(FLAGA)	;get system flag
	BIT	5,A		;dual on?
	RES	7,A		;turn off if no
	JR	Z,DLCMM		;nope, continue
	SET	7,A		;else turn it on
;
DLCMM	LD	(FLAGA),A	;update the flag
	POP	AF		;unstack
	RET			;done, go back
;
DLOFF	PUSH	AF		;save it
	LD	A,(FLAGA)	;get system flag
	RES	7,A		;disable it
	JR	DLCMM		;put it back
;
	PAGE
;
;	$SCRNPRT - send video to lineprinter
;
;	ENT	none
;
;	EXT	returns back to caller with A = ZERO
;
;	HL, DE, BC destroyed
;
SCRNPRT	LD	B,16		;16 lines on video
	LD	HL,3C00H	;start of video
;
;	check for significant length of line to print
;
VIDE1	LD	C,64		;64 char/line
	PUSH	HL		;save begin of line
	LD	A,L		;get lsb
	ADD	A,3FH		;put at end of line
	LD	E,A		;give to de
	LD	D,H		;de = end of line
;
VIDE3	LD	A,(DE)		;get a byte from screen
	CP	20H		;space?
	JR	NZ,VIDIT	;end of that line, go!
;
	DEC	DE		;go back
	DEC	C		;reduce count
	JR	NZ,VIDE3	;look for more chars
;
;	no characters on the line, send a linefeed
;
	LD	A,10		;send a linefeed
	CALL	POUT		;print it
	JR	VIDNEX		;continue
;
;	HL => start of the line, DE => end of the line
;
VIDIT	INC	DE		;bump for end byte
;
VIDIT1	LD	A,(HL)		;get a byte from video
	PUSH	AF		;save original on stack
;
;	put a graphic block at current video location
;
	LD	(HL),191	;put graphic on screen
;
;	check to see if char has changed to low numbers
;
	CP	20H		;needs adjust?
	JR	NC,VID4		;nope, continue
	ADD	A,40H		;adjust to letter
;
VID4	CALL	POUT		;send the character
	POP	AF		;restore original
	LD	(HL),A		;put back on the video
;
	INC	HL		;bump position
	PUSH	HL		;test for end of line
	OR	A		;clear carry flag
	SBC	HL,DE		;at end yet?
	POP	HL		;restore it
	JR	NZ,VIDIT1	;nope, finish the line
;
;	one line completed, follow with a carriage return
;
	LD	A,13		;send a carriage return
	CALL	POUT
;
;	line completed, go to next line
;
VIDNEX	POP	HL		;restore start last line
	LD	DE,64		;length of a video line
	ADD	HL,DE		;point to next row
	DJNZ	VIDE1		;continue for 16 lines
;
;	entire video completed, send another linefeed
;
	LD	A,10		;linefeed
	CALL	POUT		;send it
;
;	completed, return with zero (no keys pressed)
;
VIDBK	XOR	A		;return with zero
	RET			;done
;
	PAGE
;
;	$POUT	- send character to printer device
;
;	ENT	A = character to print
;
;	EXT	character is added to print spool buffer
;
POUT	PUSH	BC		;save needed registers
	PUSH	AF		;save original char
;
	LD	B,A		;save character here
	LD	A,(FLAGB)	;get printer flag
	LD	C,A		;pass here for bit tests
	LD	A,B		;get original char
;
;	check for graphic code
;
	BIT	7,A		;graphic code
	JR	Z,POUT11	;go if not
	BIT	7,C		;graphic flag on?
	JR	NZ,POUT11	;yes, go!
	LD	A,'.'		;change to a period
;
;	check for lower case
;
POUT11	BIT	6,C		;enabled?
	JR	NZ,POUT12	;yes, go
	CALL	UCASE		;else make it upper case
;
;	check for MX80 graphic adjust
;
POUT12	BIT	5,C		;enabled?
	JR	Z,POUT13	;no, continue
	BIT	7,A		;graphic code?
	JR	Z,POUT13	;no, skip adjust
;
	RES	6,A		;adjust for MX80
	ADD	A,20H		;done
;
;	done, add char to buffer
;
POUT13	CALL	ADDBUFF		;add to buffer
;
	CP	13		;was it a linefeed?
	JR	NZ,POUT14	;no, unstack and return
;
	BIT	3,C		;linefeed switch?
	JR	Z,POUT14	;nope, go
;
;	add a linefeed after the carriage return
;
	LD	A,10		;send linefeed
	CALL	ADDBUFF		;add to the buffer
;
;	completed, unstack and return
;
POUT14	POP	AF		;get char
	POP	BC		;restore counters
	RET			;done
;
;	add character to printer buffer
;
ADDBUFF	PUSH	BC		;save flag
	PUSH	HL		;need too
;
;	wait here for enough room
;
PWAIT	CALL	SPOOL		;attempt to spool a byte
	LD	HL,(PRCOUNT)	;get counter
	LD	BC,(PRSIZE)	;get size
	OR	A		;clear carry
	SBC	HL,BC		;compare 'em
	JR	NC,PWAIT	;wait for room
;
	LD	BC,(PRADDO)	;get add offset
	LD	HL,(PRBUFF)	;get buffer start
	ADD	HL,BC		;point to location
	LD	(HL),A		;put in buffer
	CALL	RINGBUF		;bump ring buffer
	LD	(PRADDO),BC	;save new offset
;
	LD	HL,(PRCOUNT)	;get counter
	INC	HL		;bump it
	LD	(PRCOUNT),HL	;update counter
;
	POP	HL		;unstack and return
	POP	BC
	RET
;
SPOOL	PUSH	BC		;save 'em
	PUSH	HL
;
SPOOLA	LD	BC,(PRCOUNT)	;get counter
	LD	A,B		;anything?
	OR	C
	JR	Z,SPOOLR	;return if not
;
;	check for shift clear to clear buffer
;
	LD	A,(3880H)	;get shift key
	OR	A		;pressed?
	JR	Z,PRTYR		;no, continue
	LD	A,(3840H)	;check for clear
	AND	2		;bit 1 set?
	JR	NZ,SPOOLE	;end spooling if yes
;
;	fetch printer status
;
PRTYR	LD	A,(37E8H)	;get status byte
	AND	0F0H		;mask out low bits
	CP	30H		;ready for a char?
	JR	NZ,SPOOLR	;nope, return
;
;	printer is ready, fetch a char
;
	LD	BC,(PRTAKO)	;get take offset
	LD	HL,(PRBUFF)	;get buffer start
	ADD	HL,BC		;point to the byte
	LD	A,(HL)		;get the byte
;
;	send character to the printer
;i*
	IF	MODI
	LD	(37E8H),A	;lineprinter I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F8H),A	;lineprinter III
	ENDIF
;iii*
	CALL	RINGBUF		;increment pointer
	LD	(PRTAKO),BC	;update offset
;
	LD	HL,(PRCOUNT)	;get counter
	DEC	HL		;less this char
	LD	(PRCOUNT),HL	;update the counter
	JR	SPOOLA		;another immediately?
;
SPOOLR	POP	HL		;unstack and return
	POP	BC
	RET
;
;	end spooling, reset pointers
;
SPOOLE	LD	HL,0		;set 0000h
	LD	(PRCOUNT),HL	;set count to 0000
	LD	(PRADDO),HL	;add offset to 0000
	LD	(PRTAKO),HL	;take offset to 0000
	JR	SPOOLR		;continue
;
;	increment ring buffer
;
RINGBUF	INC	BC		;bump pointer
	LD	HL,(PRSIZE)	;get size of buffer
	OR	A		;clear carry flag
	SBC	HL,BC		;compare to end
	RET	NZ		;nope, return
	LD	B,H		;else reset offset to 0
	LD	C,L		;BC = 0000 offset
	RET			;done
;
