; supdiskb/asm - kjw/bqsd - 08/79 - 08/82
;
	TITLE	'<Disk I/O - Section B>'
;
;
	PAGE
;
;	$SEEKWHT - adjust track for double step
;
;	ENT	D = track number desired
;
;	EXT	A = track number to $SEEK
;
SEEKWHT	BIT	2,(IY+4)	;double step it?
	LD	A,D		;get track
	RET	Z		;nope, don't adjust
;
	ADD	A,A		;double it
	RET			;that's all there is!
;
	PAGE
;
;	$DSTAT	- check if drive is ready to go
;
;	ENT	(DRIVE) valid for $SELECT
;
;	EXT	Z = drive ready
;		NZ = not ready, SKIP DRIVE selected
;
DSTAT	XOR	A		;set NOP opcode
	JR	STAT+2		;continue
;
;	$STAT	- check disk drive status
;
;	ENT	(DRIVE) valid for $SELECT
;
;	EXT	Z = drive ready
;		NZ = drive not ready, HL => error text
;
;
;	NOTE	a call to DSTAT will prompt the user
;		to correct the condition and will only
;		return NZ if the used selected to
;		skip the drive
;		a call to STAT will not prompt the
;		user, but will immediately return
;		with the status of the drive
;
STAT	LD	A,0C9H		;set RETURN opcode
;
	LD	(HFLG),A	;set operation into code
;
	CALL	SELECT		;select the drive
	CALL	INTFDC		;immediate reset
;
	CALL	DRVASC		;get ascii drive
	LD	(E0),A		;save into error strings
	LD	(E5),A
	LD	(E9),A
;
	PUSH	HL		;preserve registers
	PUSH	DE
	PUSH	BC
	LD	HL,GET		;unstacker address
	PUSH	HL		;leave on the stack
;
STAT2	CALL	SELECT		;select the drive
	LD	HL,ERMSG5	;error message text
	JR	NZ,HOLDER	;error, go!
;
;	read index hole to see if a disk is in
;	the drive and turning
;
;	make sure we start with NO index
;
	LD	BC,400H		;be forgiving
	LD	HL,ERMSG0	;error text
;
TT1	DEC	BC		;decrement counter
	LD	A,B		;down to zero?
	OR	C
	JR	Z,HOLDER	;yes, error!
;i*
	IF	MODI
	LD	A,(37ECH)	;read FDC status
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;read FDC III
	ENDIF
;iii*
	AND	2		;check for index hole
	JR	NZ,TT1		;if yes, wait more
;
;	no index hole at the current disk position
;	wait for one to come around
;
	LD	BC,6000H	;forgiving delay
	LD	HL,ERMSG9	;error text
;
TT2	DEC	BC		;dec counter
	LD	A,B		;down to zero?
	OR	C
	JR	Z,HOLDER	;go error if yes
;i*
	IF	MODI
	LD	A,(37ECH)	;read FDC I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;read FDC III
	ENDIF
;iii*
	AND	2		;index hole?
	JR	Z,TT2		;nope, wait more for one
;
;	index hole found, now is should go away!
;
	LD	BC,400H		;liberal count
	LD	HL,ERMSG0	;error message
;
TT3	DEC	BC		;dec counter
	LD	A,B		;down to zero?
	OR	C
	JR	Z,HOLDER	;go error if yes!
;i*
	IF	MODI
	LD	A,(37ECH)	;read FDC I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	IN	A,(0F0H)	;read FDC III
	ENDIF
;iii*
	AND	2		;index hole still there?
	JR	NZ,TT3		;if yes, wait a bit more
;
;	index hole came and went, disk is there all right
;
	XOR	A		;return ZERO status
	RET			;no error!
;
;	error found on drive ready
;	check if error is to be displayed
;
HOLDER	CALL	INTFDC		;immediate interrupt
	OR	-1		;set NZ flag for error
	LD	(TEMP3),HL	;save error text
;
HFLG	NOP			;either NOP or RET
;
	PUSH	HL		;put error text on stack
	RST	8		;display following
;
	DEFB	7		;clear screen
	DEFB	0		;terminator
;
	JP	8		;display error on stack
;
;	error displayed, prompt to correct the problem
;
HOLDIN	NOP			;can be vectored
	RST	8		;display following
;
	DEFB	10
	DEFM	'<ENTER>, <BREAK>, or <S>kip '
	DEFB	0
;
	CALL	ONEKEY		;fetch a single key
	RST	8		;display following
;
	DEFB	1EH		;BOL and clear curr line
	DEFB	11		;move cursor up one row
	DEFB	1EH		;clear it too
	DEFB	11		;up one more row
	DEFB	0		;terminator
;
	CALL	UCASE		;make input upper case
	CP	'S'		;<SKIP>?
	JP	NZ,STAT2	;nope, check again
;
;	skip issued, return to caller NZ
;
	OR	-1		;set NZ
	RET			;done
;
;	text for drive not ready
;
ERMSG5	DEFB	10
	DEFM	'Drive '
E5	DEFM	'x DEACTIVATED'
	DEFB	0
	JP	HOLDIN		;continue processing
;
ERMSG9	DEFB	10
	DEFM	'OPEN DOOR on Drive '
E9	DEFM	'x'
	DEFB	0
	JP	HOLDIN		;continue
;
ERMSG0	DEFB	10
	DEFM	'NO DISKETTE in Drive '
E0	DEFM	'x'
	DEFB	0
	JP	HOLDIN		;continue
;
	PAGE
;
;	$SELDEN	- select FDC chip on Mod I's
;
;	ENT	(DRIVE) setup for $SELECT
;
;	EXT	single/double density chip selected
;
;	NOTE	this service if for the Mod I ONLY!
;	NOTE	since there are actually two FDC chips
;		in the Mod I for double density, the
;		track register contents must be passed
;		from chip to chip so it doesn't get lost
;	NOTE	if bit 4 (FLAGB) is set, then no attemp
;		will be made to read double density
;		if bit 2 (FLAGB) is set, then the
;		Radio Shack Double is installed and
;		will be selected accordingly
;
;i*
	IF	MODI
SELDEN	LD	A,(FLAGB)	;get system flag B
	PUSH	BC		;save it
	BIT	4,A		;density available?
	JR	NZ,SELSNG	;nope, force single
;
	BIT	6,(IY+5)	;double density?
	JR	Z,SELSNG	;nope, select single
;
	BIT	7,(IY+5)	;track 0 double?
	JR	NZ,SELDBL	;yes, select double
;
	LD	B,A		;save flag
	LD	A,D		;fetch track
	OR	A		;on track 0?
	LD	A,B		;restore flag
	JR	NZ,SELDBL	;nope, select double
;
;	select single density
;
SELSNG	LD	BC,0AFEH	;B=R/S, C=other
	JR	SELDNOK		;continue
;
;	select double density
;
SELDBL	LD	BC,80FFH	;B=R/S, C=others
;
;	have both patterns, check for which
;	doubler to select
;
SELDNOK	BIT	2,A		;radio shack doubler?
	JR	NZ,SELRS	;yes, do it!
;
	LD	A,(37EDH)	;fetch the current track
	EX	AF,AF'		;save it
	LD	A,C		;fetch non-R/S code
	LD	(37ECH),A	;select the correct chip
	EX	AF,AF'		;get track back
	LD	(37EDH),A	;put into new chip
	JR	SELERET		;continue
;
SELRS	LD	A,(37EEH)	;get current sect reg
	LD	C,A		;save it
	LD	A,(37EDH)	;get track register
	EX	AF,AF'		;save it
	LD	A,B		;get select code
	LD	(37EEH),A	;select the chip
;
;	check for write precomp
;
	LD	A,D		;get track
	CP	16H		;>21?
	LD	A,0C0H		;disable mask
	JR	C,SELPM		;go if <22
	OR	20H		;enable pre-comp
SELPM	LD	(37EEH),A	;issue to FDC
	EX	AF,AF'		;get track back
	LD	(37EDH),A	;pass to new chip
	LD	A,C		;get sector back
	LD	(37EEH),A	;give to new chip
;
SELERET	CALL	RESFDC		;reset the controller
;
	POP	BC		;unstack
	RET			;done, return
;
	ENDIF
;i*
;
	PAGE
;
;	$RXFER	- disk read I/O transfer
;
;	ENT	command has been issued to the FDC
;
;	EXT	A = status byte of operation
;
RXFER	CALL	DSKSLO		;wait for valid status
;i*
	IF	MODI
RX0	LD	A,(HL)		;fetch FDC status
	AND	87H		;check for READY
	JP	PO,RX0		;wait if not
;
RX1	LD	A,(DE)		;fetch a byte from FDC
	LD	(BC),A		;put into the buffer
	INC	BC		;bump buffer pointer
;
RX2	BIT	1,(HL)		;another byte ready?
	JR	NZ,RX1		;yes, get it
	BIT	1,(HL)		;ready now?
	JR	NZ,RX1		;yes, go!
	BIT	7,(HL)		;drive motor still on?
	JR	NZ,XFERET	;no, go!
	BIT	1,(HL)		;byte ready now?
	JR	NZ,RX1		;yes, get it!
	BIT	0,(HL)		;command completed?
	JR	NZ,RX2		;no, wait again
;
XFERET	LD	A,(HL)		;fetch FDC status byte
	CALL	RESFDC		;reset the FDC
	LD	(RESULT),A	;save non-masked result
	LD	(TEMPFF),BC	;save end of buffer
	EI			;can enable now
	RET			;return to caller
	ENDIF
;i*
;
;iii*
	IF	MODIII
RFF1	IN	A,(0F0H)	;fetch FDC status
	AND	E		;byte ready?
	JR	Z,RFF1		;wait for one if not
	INI			;fetch the byte
	LD	A,D		;go to wait states
;
RFF2	OUT	(0F4H),A	;set 'wait' state
	INI			;fetch a byte
;
;	NOTE	the following code will test for 
;		256 bytes of data being read in
;		and will terminate and wait for an
;		interrupt
;		On track reads, the byte count will
;		exceed 256 bytes, and therefore the
;		vector $RD3FIX may be intercepted
;		to allow the transfer to contine
;
RD3FIX	JR	NZ,RFF2		;go for a sector
	JR	$		;wait for interrupt
	ENDIF
;iii*
;
	PAGE
;
;	$WXFER	- write data to disk
;
;	ENT	disk command has been issued
;
;	EXT	A = status byte of operation
;
WXFER	CALL	DSKSLO		;wait for valid status
;i*
	IF	MODI
	LD	A,(BC)		;fetch byte from buffer
;
WX1	BIT	7,(HL)		;drive motor on?
	JR	NZ,XFERET	;nope, bail out!
;
	BIT	1,(HL)		;ready for a byte?
	JR	Z,WX1		;wait if no
;
	LD	(DE),A		;give to FDC
	INC	BC		;bump buffer
	LD	A,(BC)		;fetch 2nd byte
;
WX2	BIT	1,(HL)		;ready for it?
	JR	Z,WX2		;wait her till yes
;
WX3	LD	(DE),A		;give byte to FDC
	INC	BC		;bump buffer
	LD	A,(BC)		;fetch next byte
;
WX4	BIT	1,(HL)		;ready for a byte?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;ready now?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;ready now?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;now?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;how bout now?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;yet?
	JR	NZ,WX3		;go if yes
;
	BIT	0,(HL)		;command done?
	JR	NZ,WX4		;if not, wait some more
;
WX5	JR	XFERET		;exit from transfer
	ENDIF
;i*
;
;iii*
	IF	MODIII
WFF1	IN	A,(0F0H)	;read FDC status
	AND	E		;read to go!
	JR	Z,WFF1		;nope, wait some more
	OUTI			;write byte to FDC
;
	LD	B,60H		;wait before 2nd byte
	DJNZ	$
	DEC	B		;B = remaining bytes
	LD	A,D		;get wait state flag
;
WFF2	OUT	(0F4H),A	;set wait states
	OUTI			;write a byte to disk
WR3FIX	JR	NZ,WFF2		;go for 256
	JR	$		;wait to be interrupted
	ENDIF
;
	PAGE
;
;	$WRITETR - special 'write track' code
;
;	ENT	head positioned over correct track
;		BC => data buffer to be written
;
;	EXT	Z = OK
;		NZ = A = error status byte
;
WRITETR	LD	A,(IY+4)	;get drive type byte
	AND	40H		;software write protect?
	RET	NZ		;yes, return error
;
	LD	A,5		;make 5 attempts
	LD	(WTRIES),A	;save try counter
;
WTRIE	PUSH	BC		;save buffer start
	SET	3,(IY+4)	;operation is WRITE
	CALL	TRWRITE		;write the track
	POP	BC		;load back
	AND	0FFH		;check for errors
	RET	Z		;done, no error
;
	EX	AF,AF'		;save result
;
	CALL	RESFDC		;reset FDC
	LD	A,5		;fetch # tries left
WTRIES	EQU	$-1
	DEC	A		;less this bad one
	LD	(WTRIES),A	;put it back
	JR	NZ,WTRIE	;more to do, try again
	EX	AF,AF'		;fetch error status back
	RET			;return in error
;
TRWRITE	CALL	SELECT		;try to write it
	RET	NZ		;not ready
;i*
	IF	MODI
	LD	D,(IY+3)	;get current track
	CALL	SELDEN		;setup density chip
	LD	HL,37ECH	;point to FDC
	LD	DE,37EFH	;data address
	DI			;disable
	LD	(HL),0F4H	;write track command
	JP	WXFER		;write the data
	ENDIF
;i*
;
;iii*
	IF	MODIII
	LD	D,(IY+3)	;current track
	CALL	SETNMI		;setup for NMI I/O vector
	LD	B,3		;B = mask, not counter
;
	LD	A,0F0H		;write track command
	OUT	(0F0H),A	;give to FDC III
	CALL	DSKSLO		;wait for valid status
;
;	the first 2 bytes are very critical on the
;	mod III full track writes
;	by checking parity on the two low bits
;	of the status register
;	(1=data register empty, 0=command completed)
;	if both are set, then the FDC is ready to
;	take the first byte.  If both are reset then
;	the command has terminated prematurely and
;	will fall through and be detected on the
;	interrupt lines
;	if the FDC is ready, the data register must
;	be loaded in PROMPTLY, as a request will be
;	made for the second byte almost IMMEDIATELY
;	this 'special' set of code differs on the
;	mod III only
;
WX1	IN	A,(0F0H)	;fetch status now
	AND	B		;check bits 0,1
	JP	PO,WX1		;only one set, wait!
	OUTI			;stuff the FDC
;
;	go into immediate wait states
;
WX2	LD	A,D		;get FDC w'wait' command
	OUT	(0F4H),A	;give it!
	IN	A,(0F0H)	;read the status
	AND	E		;bit 1 ready?
	JR	Z,WX2		;wait here if not
	OUTI			;send the byte
;
;	no more need to monitor the status lines
;	after 2 bytes have been successfully sent
;
	LD	A,D		;fetch command byte
WX3	OUT	(0F4H),A	;wait state!
	OUTI			;in sync, send the byte
	JP	WX3		;go till interrupted
	ENDIF
;iii*
;
	PAGE
;
;	$ADDR	- read ID address marks from disk
;
;	ENT	(DRIVE) set for $SELECT
;		head positioned over correct track
;
;	EXT	Z = OK, HL => 6 byte buffer of ID marks
;		NZ = A = error status byte
;
;	DE and BC preserved
;
ADDR	PUSH	DE		;save 'em
	PUSH	BC
;
	LD	BC,INPUT	;input buffer
	PUSH	BC		;save for HL pop return
;i*
	IF	MODI
	LD	D,(IY+3)	;get current track
	CALL	SELDEN		;to set the density
;
	LD	HL,37ECH	;FDC command register
	CALL	SELECT		;select the drive
	JR	NZ,ADDRD	;error, return
;
	RES	3,(IY+4)	;operation is READ
	LD	DE,37EFH	;data transfer address
	DI			;disable interrupts
	LD	(HL),0C0H	;issue FDC command
	ENDIF
;i*
;
;iii*
	IF	MODIII
	CALL	SELECT		;select the drive
	JR	NZ,ADDRD	;error, abort
;
	LD	D,(IY+3)	;get current track
	CALL	SETNMI		;setup density
	LD	A,0C0H		;read ID command
	OUT	(0F0H),A	;give to FDC
	ENDIF
;iii*
	CALL	RXFER		;transfer the bytes
	AND	9CH		;mask unwanted bits
;
ADDRD	POP	HL		;HL => buffer
	POP	BC		;restore DE and BC
	POP	DE
	RET			;return, Z = OK
;
	PAGE
;
;	$DDOSFIX - adjust for relative sector read
;
;	ENT	DE = track/sector to be read
;
;	EXT	original DE left on stack
;		DE adjusted to the RELATIVE track/sector
;
;	HL destroyed
;
DDOSFIX	POP	HL		;get caller address
	PUSH	DE		;save start DE
	PUSH	HL		;put caller back
;
	BIT	4,(IY+5)	;relative sectoring?
	RET	Z		;nope, don't adjust
;
	PUSH	BC		;save 'em
	PUSH	HL
;
	LD	L,D		;load HL with track
	LD	H,0
	LD	A,10		;multipy by 10
	PUSH	DE		;save
	CALL	MULPY		;multiply it
	POP	DE		;restore
;
	LD	H,L		;adjust registers
	LD	L,A
	LD	D,0
	ADD	HL,DE		;add the sector
	LD	A,18		;for divid by 18
	CALL	DIVD		;divide it
	LD	D,L		;place result into DE
	LD	E,A
	POP	HL		;unstack it
	POP	BC
;
	BIT	7,(IY+5)	;double track zero?
	RET	NZ		;yes, DE = OK
;
	INC	D		;don't use track zero
	RET			;done, DE = OK
;
;	$MULPY	- multiply subroutine
;
;	ENT	HL = multiplicand
;		A  = multiplier
;
;	EXT	HLA = result
;
MULPY	PUSH	BC		;save it
	EX	DE,HL		;DE = multi
	LD	C,A		;C = multp
	LD	HL,0		;start value
	LD	A,L		;start with zero
	LD	B,8		;8 bits to multiply
;
MPY102	ADD	HL,HL		;multiply times two
	RLA			;catch the carry bit
	RLC	C		;see if bit set in multp
	JR	NC,MPY101	;nope, continue
	ADD	HL,DE		;else add odd
	ADC	A,0		;add the carry
;
MPY101	DJNZ	MPY102		;go for 8 bits
;
	LD	C,A		;save the MSB
	LD	A,L		;move LSB to A
	LD	L,H		;move NSB to L
	LD	H,C		;move MSB to H
	POP	BC		;unstack
	RET			;done, HLA = product
;
;	$DIVD	- divide subroutine
;
;	ENT	HL = dividend
;		A  = divisor
;
;	EXT	HL = product
;		A  = remainder
;
DIVD	PUSH	DE		;save it
	LD	D,A		;pass divisor
	LD	E,16		;16 bits to do
	XOR	A		;zero the 'catcher'
;
DIVD3	ADD	HL,HL		;times 2
	RLA			;catch the carry
	JR	C,DIVD1		;go if a carry
;
	CP	D		;compare to divisor
	JR	C,DIVD2		;go if less
;
DIVD1	SUB	D		;else remove divisor
	INC	L		;bump product
;
DIVD2	DEC	E		;less bit counter
	JR	NZ,DIVD3	;go if more
;
	POP	DE		;unstack
	RET			;done, HL+A = result
;
	PAGE
;
;	$INTFDC - immediate interrupt on FDC
;
INTFDC	LD	A,0D8H		;immediate interrupt
;i*
	IF	MODI
	LD	(37ECH),A	;FDC command reg I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F0H),A	;FDC III
	ENDIF
;iii*
;
;	$RESFDC - reset floppy disk controller from error
;
RESFDC	PUSH	AF		;save status byte
	LD	A,0D0H		;interrupt command
;i*
	IF	MODI
	LD	(37ECH),A	;FDC command I
	ENDIF
;i*
;
;iii*
	IF	MODIII
	OUT	(0F0H),A	;FDC command III
	ENDIF
;iii*
	POP	AF		;restore status byte
	RET			;FDC now reset
;
