; supdata/asm - kjw/bqsd - 08/79 - 07/82
;
	TITLE	'<Data Storage Area>'
;
	PAGE
;
;	RST vector table
;
RST08	JP	DISPLY		;string to video
RST10	JP	GETSTR		;keyboard line input
RST18	JP	ASCII		;binary => ascii DECIMAL
RST20	JP	HEXCV		;binary => ascii HEX
RST28	JP	SHOREAD		;sector read / display
RST30	JP	SHOWRITE	;sector write / display
RST38	JP	TASK		;interrupt service
;
;	2 additional vectors for program entry
;
	JP	MENU		;return main menu
	JP	RETURN		;return sub-menu
;
;	flag bytes
;
WHERE	DEFB	0		;sub-menu return flag
;	0 = main menu
;	1 = disk zap
;	2 = disk purge
;	3 = disk format
;	4 = disk backup
;	5 = disk repair
;	6 = tape utility
;	7 = memory utility
;	8 = file utility
;	9 = configuration
;
MODE	DEFB	0		;modify mode base
;	0 = HEX modify
;	1 = DECIMAL modify
;	2 = BINARY modify
;	3 = OCTAL modify
;	4 = ASCII modify
;
TYPE	DEFB	0		;source of modify data
;	1 = data from direct disk sector
;	2 = data from memory
;	3 = data from file sector
;
;	data
;
SECTOR	DEFB	0		;relative sector
TRAK	DEFB	0		;relative track
TRUE	DEFB	0		;real track
;
CURSOR	DEFW	3C00H		;video cursor location
;
EOFB	DEFB	0		;file end of file byte
EOFS	DEFW	0		;end of file sector
EOAS	DEFW	0		;end of allocation sector
;
FREEG	DEFW	0		;free granules
FREEF	DEFB	0		;free files
CGRANS	DEFW	0		;gran counter
;
ADDRESS	DEFW	DAMBUFF		;memory display address
DEFADDR	DEFW	MENU		;default address vector
FMTBUFF	DEFW	FBUFF		;buffer for build track
;
DIRSCNT	DEFB	0		;directory sector count
DIRPAGE	DEFB	0		;curr dir display page
;
TOPMEM	DEFW	0		;top of memory +1
MIDMEM	DEFW	0		;middle free memory
BOTMEM	DEFW	0		;free memory
;
;	printer data storage
;
PRCOUNT	DEFW	0		;char count in spooler
PRSIZE	DEFW	400H		;size of buffer
PRBUFF	DEFW	BUFFPRT		;start of buffer
PRADDO	DEFW	0		;add to buffer offset
PRTAKO	DEFW	0		;take from buffer offset
;
NUMTYPE	DEFB	0		;number type for value
RESULT	DEFW	0		;result of disk I/O
;
;	NMI disk vector for Mod III at 4049H
;
	DEFB	0		;get it there
;
NMIVECT	JP	RETNMI		;non-disk NMI vector
RETNMI	RETN			;return from non-maskable
;
;	temporary storage block for subroutine use
;
TEMP0	DEFW	0		;temporary storage
TEMP1	DEFW	0
TEMP2	DEFW	0
TEMP3	DEFW	0
TEMP4	DEFW	0
TEMP5	DEFW	0
TEMP6	DEFW	0
TEMP7	DEFW	0
TEMP8	DEFW	0
TEMP9	DEFW	0
;
;	system operation flag
;
FLAGA	DEFB	0		;system flag A
;	7 = 1 = DUAL ACTIVE
;	6 = 1 = HISPEED clock ON
;	5 = 1 = DUAL ON
;	4 = 1 = Save Configuration ON
;	3 = 1 = Extended ID Marks Mode (from ZAP)
;	2 = 1 = String Replace Flag
;	1 = 1 = Alive OFF
;	0 = 1 = Keyboard case lock switch ON
;
FLAGB	DEFB	0		;system flag B
;	7 = 1 = printer graphics ON
;	6 = 1 = printer lower case ON
;	5 = 1 = adjust printer graphics for MX80
;	4 = 1 = NO double density available
;	3 = 1 = send linefeeds on carriage returns
;	2 = 1 = Radio Shack Doubler Installed
;	1 = 1 = attempt non-standard disk read @ $DISDSK
;	0 = 1 = trace OFF
;
;	data
;
SDRIVE	DEFB	0		;source drive
DDRIVE	DEFB	0		;destination drive
MFLAG	DEFB	0		;disk mount prompts?
;
DRIV	DEFB	0		;binary drive number
DRIVE	DEFB	1		;bit pattern set for drv
POSA	DEFB	0		;curr drive for mult rout
RSECT	DEFW	0		;relative sector storage
;
RDTYPE	DEFB	88H		;sector read byte
WRTYPE	DEFB	0A8H		;sector write byte
;
BUFPAS	DEFW	0		;buffer save address
SECPAS	DEFW	0		;track/sector saver
TEMPFF	DEFW	0		;address of last byte I/O
;
;	keyboard mask area for new key detect
;
KEYBRD	DEFB	0,0,0,0,0,0,0	;one byte each key row
;
;	keyboard lookup table for special keys
;
KEYTABL	DEFB	13		;enter
	DEFB	14		;sh enter
	DEFB	3		;clear
	DEFB	4		;sh clear
	DEFB	1		;break
	DEFB	2		;sh break
	DEFB	5BH		;u arr
	DEFB	1BH		;sh u arr
	DEFB	5CH		;d arr
	DEFB	1AH		;sh d arr
	DEFB	5DH		;l arr
	DEFB	18H		;sh l arr
	DEFB	5EH		;r arr
	DEFB	19H		;sh r arr
	DEFB	20H		;space
	DEFB	80H		;sh space
;
;	displacement offsets for 'decrypt' mode
;
DISP1	DEFB	'+'		;type flag
DISP2	DEFB	20H		;type modifier
DISP3	DEFB	0		;type value
SHFLG	DEFB	0		;hex side adjust flag
;
COUNT	DEFW	0		;counter word
;
;	keyboard input area (70 bytes)
;
STRING	DEFM	'String String String String String '
	DEFM	'String String String String String '
;
;	system stack area (108 bytes)
;
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
	DEFM	'Stack Stack Stack Stack Stack Stack '
STACK	EQU	$
;
;	filename storage area
;
FILEDCB	DEFM	'FilenameExt'
PASSWRD	DEFM	'Password'
;
;	checker string to make sure
;	my name doesn't get changed in the program
;
KIMCHK	DEFB	'K'<1,'i'<1,'m'<1,' '<1
	DEFB	'W'<1,'a'<1,'t'<1,'t'<1
;
;	disk drive data storage area, 10 bytes each
;	8 contiguous drive code tables (DCT's)
;
;	+0 = physical disk drive track count
;	+1 = relative disk drive track count (DRS)
;	+2 = current directory track
;	+3 = current head location
;	+4 = resident flags
;		7 = 1 = drive NOT IN SYSTEM
;		6 = 1 = software write protected
;		5 = 1 = motor delay 1/2 sec (else 1 sec)
;		4 = 1 = motor delay on reads
;		3 = 1 = current operation is WRITE
;		2 = 1 = double step the drive
;		1&0 = drive step rate (0-3)
;	+5 = disk description flags
;		7 = 1 = double density track 0
;		6 = 1 = double density disk remainder
;		5 = unused
;		4 = 1 = relative sectoring engaged
;		3 = 1 = active in multiple drive cmds
;		2 = 1 = directory ID marks REVERSED
;		1 = starting sector on track 0
;		0 = starting sector on non-track 0
;	+6 = dos description flags
;		7 = 1 = TRSDOS
;		6 = 1 = LDOS
;		5 = 1 = DOSPLUS
;		4 = 1 = MULTIDOS
;		3 = 1 = NEWDOS80
;		2 = 1 = DOUBLEDOS
;		1 = extra
;		0 = 1 = Dos Type Unknown
;	+7 = save config byte for +5
;	+8 = save config byte for +6
;	+9 = temp data byte for disk I/O use
;
;
DRIV0	DEFB	35		;physical tracks
	DEFB	35		;relative tracks
	DEFB	17		;directory track
	DEFB	00		;current track
	DEFB	00010011B	;flags #1
	DEFB	00000000B	;flags #2
	DEFB	10000000B	;flags #3
	DEFB	00000000B	;save for flag #2
	DEFB	10000000B	;save for flag #3
	DEFB	00		;work byte
;
DRIV1	DEFB	35		;p tks
	DEFB	35		;r tks
	DEFB	17		;dir tk
	DEFB	00		;c tk
	DEFB	00010011B	;f1
	DEFB	00000000B	;f2
	DEFB	10000000B	;f3
	DEFB	00000000B	;s f2
	DEFB	10000000B	;s f3
	DEFB	00		;wrk
;
DRIV2	DEFB	35		;p tks
	DEFB	35		;r tks
	DEFB	17		;dir tk
	DEFB	00		;c tk
	DEFB	00010011B	;f1
	DEFB	00000000B	;f2
	DEFB	10000000B	;f3
	DEFB	00000000B	;s f2
	DEFB	10000000B	;s f3
	DEFB	00		;wrk
;
DRIV3	DEFB	35		;p tks
	DEFB	35		;r tks
	DEFB	17		;dir tk
	DEFB	00		;c tk
	DEFB	00010011B	;f1
	DEFB	00000000B	;f2
	DEFB	10000000B	;f3
	DEFB	00000000B	;s f2
	DEFB	10000000B	;s f3
	DEFB	00		;wrk
;
DRIV4	DEFB	35		;p tks
	DEFB	35		;r tks
	DEFB	17		;dir tk
	DEFB	00		;c tk
	DEFB	10010011B	;f1 - inactive
	DEFB	00000000B	;f2
	DEFB	10000000B	;f3
	DEFB	00000000B	;s f2
	DEFB	10000000B	;s f3
	DEFB	00		;wrk
;
DRIV5	DEFB	35		;p tks
	DEFB	35		;r tks
	DEFB	17		;dir tk
	DEFB	00		;c tk
	DEFB	10010011B	;f1 - inactive
	DEFB	00000000B	;f2
	DEFB	10000000B	;f3
	DEFB	00000000B	;s f2
	DEFB	10000000B	;s f3
	DEFB	00		;wrk
;
DRIV6	DEFB	35		;p tks
	DEFB	35		;r tks
	DEFB	17		;dir tk
	DEFB	00		;c tk
	DEFB	10010011B	;f1 - inactive
	DEFB	00000000B	;f2
	DEFB	10000000B	;f3
	DEFB	00000000B	;s f2
	DEFB	10000000B	;s f3
	DEFB	00		;wrk
;
DRIV7	DEFB	35		;p tks
	DEFB	35		;r tks
	DEFB	17		;dir tk
	DEFB	00		;c tk
	DEFB	10010011B	;f1 - inactive
	DEFB	00000000B	;f2
	DEFB	10000000B	;f3
	DEFB	00000000B	;s f2
	DEFB	10000000B	;s f3
	DEFB	00		;wrk
;
;	lookup table to locate a DCT
;
DCTTBL	DEFW	DRIV0
	DEFW	DRIV1
	DEFW	DRIV2
	DEFW	DRIV3
	DEFW	DRIV4
	DEFW	DRIV5
	DEFW	DRIV6
	DEFW	DRIV7
;
