BENCH  ;bench/asm
 	ORG	5200H
 ENTRY	LD	HL,HELLO
 	LD	BC,3C00H
 	CALL	@PRINT
 SYSTEM	LD	HL,SYSMSG
 	LD	BC,3C00H+256
 	CALL	@PRINT
 	CALL	@GETKEY
 	JR	C,QUIT
 	CP	'L'
 	LD	BC,0		;ldos flag
 	JR	Z,SETUP
 	CP	'D'
 	LD	BC,2		;dos+ flag
 	JR	Z,SETUP
 	CP	'E'
 	JR	NZ,SYSTEM
 QUIT	LD	HL,QUITMSG
 	LD	BC,3C00H+256
 	CALL	@PRINT
 	JP	402DH
 SETUP	LD	(FLAG),BC
 ASKTST	LD	HL,TESTMSG
 	LD	BC,3C00H+320
 	CALL	@PRINT
 	CALL	@GETKEY
 	JR	C,QUIT
 	SUB	30H
 	JR	C,ASKTST
 	JR	Z,ASKTST
 	CP	10
 	JR	NC,ASKTST
 	DEC	A		;for table lookup
 	LD	(TEST),A
 START	LD	HL,STARTMSG
 	LD	BC,3C00H+384
 	CALL	@PRINT
 	CALL	@GETKEY
 	LD	A,(TEST)
 	LD	C,A
 	LD	B,0
 	LD	HL,TSTLPS
 	ADD	HL,BC
 	LD	A,(HL)
 	LD	(LOOPS),A
 	CALL	ASCII
 	LD	(MSG0B),BC
 	XOR	A
 	LD	(CURRENT),A
 	CALL	BEGIN
 LOOP	LD	A,0
 CURRENT	EQU	$-1
 	INC	A
 	LD	(CURRENT),A
 	CALL	ASCII
 	LD	(MSG0A),BC
 	LD	HL,MSG0
 	LD	BC,3C00H+448
 	CALL	@PRINT
 	CALL	@TEST		;perform the test
 	CALL	2BH		;check for terminate
 	CALL	UCASE
 	CP	'Q'
 	JR	Z,HALTER
 	LD	A,0
 LOOPS	EQU	$-1
 	DEC	A		;decrement counter
 	LD	(LOOPS),A
 	JR	NZ,LOOP		;do more if any left
 	CALL	DONE		;program finished
 	JP	ASKTST
 HALTER	LD	HL,HALTMSG
 	LD	BC,3C00H+512
 	CALL	@PRINT
 	JP	ASKTST
 HALTMSG	DB	'Test * Aborted *',1FH,3
 BEGIN	LD	HL,NAMETABLE
 	LD	A,0
 TEST	EQU	$-1
 	SLA	A
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	LD	A,(HL)		;get LSB
 	INC	HL
 	LD	H,(HL)		;get MSB
 	LD	L,A		;pass LSB
 	LD	BC,3C00H+384
 	CALL	@PRINT		;display name of test
 	DI
 	CALL	@CMDI		;via a dos call
 	LD	HL,MSG1A	;start time
 	CALL	@GETTIME
 	EI			;can enable now
 	LD	HL,STIME	;start time
 	LD	BC,3C00H+448+18
 	CALL	@PRINT
 	RET			;done
 DONE	DI			;stop for clock fetch
 	LD	HL,MSG1B	;end time
 	CALL	@GETTIME
 	EI
 	LD	HL,ETIME
 	LD	BC,3C00H+448+40
 	CALL	@PRINT
 	RET
 ASCII	LD	C,'0'		;start digit
 ASC1	SUB	10		;remove 10
 	JR	C,ASC2
 	INC	C		;bump MSB
 	JR	ASC1		;do more
 ASC2	ADD	A,3AH		;add 30H + 10
 	LD	B,A		;pass here
 	RET
 @GETTIME	LD	BC,0
 FLAG	EQU	$-2
 	EX	DE,HL		;save string pointer
 	LD	HL,DOSTIME	;table of vectors
 	ADD	HL,BC		;point to command
 	LD	A,(HL)		;get lsb
 	INC	HL
 	LD	H,(HL)
 	LD	L,A
 	PUSH	HL		;save address
 	EX	DE,HL
 	RET			;go get it
 DOSTIME
 	DW	3036H		;ldos time
 	DW	446DH		;dos+ time
 @CMDI	LD	BC,(FLAG)	;get dos type
 	EX	DE,HL		;HL => command
 	LD	HL,DOSCMD	;vector table
 	ADD	HL,BC		;point to it
 	LD	A,(HL)
 	INC	HL
 	LD	H,(HL)
 	LD	L,A
 	PUSH	HL
 	EX	DE,HL
 	RET
 DOSCMD
 	DW	LZTIM
 	DW	LZTIM
 LZTIM	XOR	A
 	LD	(4217H),A
 	LD	(4218H),A
 	LD	(4219H),A
 	RET
 @PRINT	LD	(4020H),BC	;save cursor
 	JP	4467H		;display and return
 @GETKEY	LD	HL,KEYBUFF
 	LD	B,1
 	CALL	40H		;get a key
 	RET	C
 	LD	A,(HL)
 UCASE	CP	80H
 	RET	NC
 	CP	60H
 	CCF
 	RET	NC
 	AND	5FH
 	RET
 @TEST	LD	A,(TEST)	;get test #
 	SLA	A		;* 2 for table
 	LD	C,A		;put in BC
 	LD	B,0		;for table
 	LD	HL,TESTABLE	;lookup table
 	ADD	HL,BC
 	LD	A,(HL)
 	INC	HL
 	LD	H,(HL)
 	LD	L,A		;HL = address
 	JP	(HL)		;do the test
 TEST1	DB	'File Test: Create,Write,Close,Open,Read,Close,Open,Kill',1EH,3
 TST1	LD	HL,DCB
 	LD	DE,FCB
 	LD	BC,32
 	LDIR
 	LD	DE,FCB		;file block
 	LD	HL,BUFFER	;i/o buffer
 	LD	B,0		;lrl = 0
 	CALL	4420H		;create the file
 	JP	NZ,@ERROR	;i/o error
 	CALL	4439H		;write a sector
 	JP	NZ,@ERROR
 	CALL	4428H		;close it
 	JP	NZ,@ERROR
 	CALL	4424H		;open it up
 	JP	NZ,@ERROR
 	CALL	4436H		;read a sector
 	JP	NZ,@ERROR
 	CALL	4428H		;close it
 	JP	NZ,@ERROR
 	CALL	4424H		;open it back up
 	JP	NZ,@ERROR
 	CALL	442CH		;kill it now
 	RET	Z		;done if good
 @ERROR	LD	BC,3C00H+576
 	LD	(4020H),BC
 	OR	0C0H
 	CALL	4409H
 	LD	HL,ENDMSG
 	LD	BC,3C00H+640
 	CALL	@PRINT
 	POP	HL		;restore stack
 	JP	ASKTST
 TEST2	DB	'Video Driver Speed Test',1EH,3
 TST2	LD	A,'A'		;start character
 	LD	(TST2X),A	;save it
 TST2C	LD	BC,511		;# chars to do
 	LD	HL,3C00H+512	;start video
 	LD	(4020H),HL	;set cursor
 TST2A	LD	A,0
 TST2X	EQU	$-1
 	CALL	33H		;display the character
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,TST2A
 	LD	BC,511		;erase whole thing
 TST2B	LD	A,8
 	CALL	33H
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,TST2B
 	LD	A,(TST2X)
 	INC	A
 	LD	(TST2X),A
 	CP	'Z'+1
 	JR	NZ,TST2C
 	RET
 TEST3	DB	'Load Program from Disk',1EH,3
 TST3	LD	HL,LFCB
 	LD	DE,FCB
 	LD	BC,32
 	LDIR
 	LD	DE,FCB
 	CALL	@LOAD
 	JP	NZ,@ERROR
 	RET
 @LOAD	JP	4430H		;load it
 ENDMSG	DB	'Test Terminated due to Error.',3
 TEST4	DB	'Keyboard Scan Speed Test',1EH,3
 TST4	LD	B,0
 TST4A	CALL	2BH
 	DJNZ	TST4A
 TST4B	CALL	2BH
 	DJNZ	TST4B
 	RET
 ;###
 TSTLPS	DB	15,6,12,99
 HELLO	DB	1CH,1FH
 	DB	'################################################################'
 	DB	'##  BENCH - Benchmark Test Program for Dos Comparisons        ##'
 	DB	'##  by Kim Watt - Breeze/QSD, Inc. - Dallas, Texas            ##'
 	DB	'################################################################',3
 SYSMSG	DB	'L)dos, D)osplus, E)xit ? ',1EH,3
 STARTMSG	DB	'Key <ENTER> to begin test. ',3
 MSG0	DB	'Loop # '
 MSG0A	DB	'xx of '
 MSG0B	DB	'xx.',3
 STIME	DB	'Test Start '
 MSG1A	DB	'xx:xx:xx',3
 ETIME	DB	'Test End '
 MSG1B	DB	'xx:xx:xx',3
 NAMETABLE
 	DW	TEST1
 	DW	TEST2
 	DW	TEST3
 	DW	TEST4
 	DW	TEST5
 	DW	TEST6
 	DW	TEST7
 	DW	TEST8
 	DW	TEST9
 QUITMSG	DB	'Benchmark Test * Terminated *',1FH,13
 TESTMSG	DB	'Enter Test Number (1-9): ',1EH,3
 ZCKMSG	DB	'TIME 00:00:00',13
 KEYBUFF	DS	5
 TESTABLE
 	DW	TST1
 	DW	TST2
 	DW	TST3
 	DW	TST4
 	DW	TST5
 	DW	TST6
 	DW	TST7
 	DW	TST8
 	DW	TST9
 DCB	DB	'TESTTEST/TST',13,0,0,0
 	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 FCB	DS	32
 LFCB	DB	'TESTTEST/CIM',13,0,0,0
 	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DBUFF	EQU	$&0FF00H
 BUFFER	EQU	DBUFF+100H
 	END	ENTRY
