; pttask/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
; revised 04/25/83 - kjw/bqsd
;
	PAGE
;
;	$TASK	- interrupt processor
;
;	interrupts each 'real time clock' beat
;
;	fetch interrupted Program Counter for trace
;	save all registers to be used
;
TASK	EX	(SP),HL		;get current PC
	LD	(TRACADD),HL	;save for TRACE
	EX	(SP),HL		;put it back
	PUSH	AF		;save registers
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
;	check for valid RTC interrupt
;
;i*
	IF	MODI
	LD	A,(RDINT)	;read int latch I
	BIT	6,A		;FDC making roster?
	JP	NZ,FDCROST	;clear it if yes
	BIT	7,A		;valid interrupt?
	JP	Z,TSKNOT	;nothing if not set
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,(RDINT)	;read interrupt latch
	BIT	7,A		;RTC interrupt?
	JP	Z,TSKNOT	;go if not
	ENDIF
;m*
;iii*
	IF	MODIII
	IN	A,(RDINT)	;read int latch III
	BIT	2,A		;valid interrupt?
	JP	NZ,TSKNOT	;nothing if set
	ENDIF
;iii*
;
;	check for BREAK key
;
	LD	A,(KBDR6)	;check for break key
	AND	4		;bit 2 set?
	JR	Z,TASKDN	;if no, continue
;
;	display BREAK on video and wait for key release
;
	RST	@08		;display
;
	DEFB	CLSF		;clear video
	DEFM	'Break'		;message
	DEFB	ETX
;
	LD	A,(KBDR7)	;check for shift key
	OR	A		;set flags
	JR	Z,BRKCK2	;go if not shift
	RST	@08		;new message
;
	DEFB	BOL		;beginning of line
	DEFM	'Shift Break'
	DEFB	ETX		;terminator
;
BRKCK1	CALL	IFBREAK		;wait for key release
	JP	MASTER		;go main menu
;
BRKCK2	CALL	IFBREAK		;wait for release
	JP	SUBMENU		;go sub-menu
;
IFBREAK	LD	A,(KBDR6)	;read keyboard
	AND	4		;still pressed?
	JR	NZ,IFBREAK	;wait if yes
	RET			;else return
;
;	check for control keys
;
TASKDN	LD	A,(KBDR6)	;read keyboard
	AND	2		;clear key?
	JP	Z,TASKCHL	;go if no!
	LD	A,0		;get flag
TASKCHM	EQU	$-1
	OR	A		;available?
	JP	NZ,TASKCHK	;go if not!
	LD	A,(KBDR0)	;get row zero
	AND	2		;control A?
	JP	NZ,TOGALV	;toggle alive on/off!
	LD	A,(KBDR1)	;get row 1
	AND	2		;'I'?
	JP	NZ,TOGINK	;toggle inkey!
	LD	A,(KBDR2)	;get row two
	BIT	7,A		;control W?
	JP	NZ,TOGWHO	;toggle WHO
	BIT	6,A		;control V?
	JP	NZ,TOGVER	;toggle VERSION
	BIT	4,A		;control T?
	JP	NZ,TOGTRA	;toggle trace
	BIT	3,A		;control S?
	JP	NZ,TOGSER	;serial number
	JP	TASKCHK		;none, go!
;
;	'special' key combination pressed!
;
TOGWHO	LD	HL,SERSTRT	;encoded message text
SER87X	LD	A,(HL)		;fetch a char
	XOR	25H		;decode it
	LD	(HL),A		;put it back
	INC	HL		;bump pointer
	JR	NZ,SER87X	;finish it
	RST	@08		;display hidden message
;
	DEFB	CLSF		;clear screen
SERSTRT	DEFB	0FH,0FH,0FH,0FH,0FH,0FH,0FH,0FH
	DEFB	0FH,0FH,0FH,0FH,0FH,0FH,0FH,28H
	DEFB	0FH,05H,75H,57H,4AH,42H,57H,44H
	DEFB	48H,05H,47H,5CH,05H,05H,0FH,28H
	DEFB	0FH,05H,05H,6EH,4CH,48H,05H,72H
	DEFB	44H,51H,51H,05H,05H,05H,0FH,28H
	DEFB	0FH,05H,62H,57H,44H,55H,4DH,4CH
	DEFB	46H,56H,05H,47H,5CH,05H,0FH,28H
	DEFB	0FH,61H,40H,4BH,4BH,4CH,56H,05H
	DEFB	67H,57H,40H,4BH,51H,05H,0FH,28H
	DEFB	0FH,66H,4AH,55H,5CH,57H,4CH,42H
	DEFB	4DH,51H,14H,1CH,1DH,16H,0FH,28H
	DEFB	0FH,67H,57H,40H,40H,5FH,40H,0AH
	DEFB	74H,76H,61H,6CH,4BH,46H,0FH,28H
	DEFB	0FH,61H,44H,49H,49H,44H,56H,09H
	DEFB	05H,71H,40H,5DH,44H,56H,0FH,28H
	DEFB	0FH,0FH,0FH,0FH,0FH,0FH,0FH,0FH
	DEFB	0FH,0FH,0FH,0FH,0FH,0FH,0FH,28H
	DEFB	25H,ETX
;
;	wait for 'special' key release
;	and restore message
;
WTK3	LD	A,(KBDR2)	;read keyboard
	BIT	7,A		;pressed?
	JR	NZ,WTK3		;wait if yes
;
;	re-encode string for next access
;
	LD	HL,SERSTRT	;start of message
SER085	LD	A,(HL)		;get a char
	OR	A		;check for term
	PUSH	AF		;save flag
	XOR	25H		;restore it
	LD	(HL),A		;put it back
	INC	HL		;bump pointer
	POP	AF		;get flags
	JR	NZ,SER085	;go if more
	JP	SUBMENU		;go last sub-menu
;
TASKCHN	LD	A,-1		;set flag
TASKCHL	LD	(TASKCHM),A	;allow next scan
;
TASKCHK	LD	A,(FLAGB)	;get sys flag
	BIT	0,A		;trace on?
	CALL	NZ,PERTRC	;yes, display it!
;
	LD	A,(FLAGA)	;check for "alive"
	BIT	1,A		;on?
	JR	NZ,TASKCH	;nope, don't display it
;
	LD	A,0		;get alive flag
ALVFLAG	EQU	$-1
	BIT	0,A		;alive on?
	JR	NZ,TASKCH	;go if not!
;
;	change 'alive' in four video corners
;
;i*
	IF	MODI
	LD	A,4		;counter Mod I
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,8
	ENDIF
;m*
;iii*
	IF	MODIII
	LD	A,3		;counter Mod III
	ENDIF
;iii*
;
TSKCNTY	EQU	$-1
	DEC	A		;decrement it
	LD	(TSKCNTY),A	;put it back
	JR	NZ,TSKCNTX	;not time yet, continue
;
;i*
	IF	MODI
	LD	A,4		;reset Mod I
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,8
	ENDIF
;m*
;iii*
	IF	MODIII
	LD	A,3		;reset Mod III
	ENDIF
;iii*
;
	LD	(TSKCNTY),A	;put it back
;
;	change all # to * in top row of display
;
	LD	HL,VIDEO+42H	;start here
	LD	B,60		;row length less edges
	LD	A,(HL)		;fetch a byte
	CP	'*'		;one way?
	JR	Z,GOFLS		;yes, go!
	CP	'#'		;opposite
	JR	NZ,TSKCNTX	;skip if neither!
;
GOFLS	CP	(HL)		;same?
	JR	NZ,SKPFLSG	;skip if not
	XOR	09H		;change to other
	LD	(HL),A		;to the video
	XOR	09H		;put it back
SKPFLSG	INC	HL		;bump video pointer
	DJNZ	GOFLS		;finish the row
;
TSKCNTX	EQU	$
;
;i*
	IF	MODI
	LD	A,5		;alive counter I
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,8
	ENDIF
;m*
;iii*
	IF	MODIII
	LD	A,4		;alive mod III
	ENDIF
;iii*
;
TSKCNTZ	EQU	$-1
	DEC	A		;less one
	LD	(TSKCNTZ),A	;put it back
	JR	NZ,TASKCH	;go if not time
;
;i*
	IF	MODI
	LD	A,5		;reset I
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,8
	ENDIF
;m*
;iii*
	IF	MODIII
	LD	A,4		;reset III
	ENDIF
;iii*
;
	LD	(TSKCNTZ),A
;
;	display 'alive' to video
;
	LD	A,(VIDEO+3FH)	;get current 'alive'
	BIT	7,A		;graphics?
	JR	Z,TSKZXX	;go if not
	ADD	A,A		;shift left
	AND	3FH		;mask low bits
	JR	NZ,TSKCNU	;go if bits on
TSKZXX	LD	A,1		;reset 'alive'
TSKCNU	OR	80H		;set graphic bit
	LD	(VIDEO),A	;to top left
	LD	(VIDEO+COLS-1),A ;top right corner
	LD	(COLS*3+VIDEO),A ;to middle left
	LD	(COLS*4+VIDEO-1),A ;to middle right
	LD	(VIDEND-COLS),A ;to lower left
	LD	(VIDEND-1),A	;to lower right
;
;	check to see if a valid serial number is present
;
TASKCH	LD	A,0		;get counter
SERCNT	EQU	$-1		;once about each 8 secs
	DEC	A		;less one
	LD	(SERCNT),A	;put it back
	JR	NZ,TSKDONE	;skip this time around
;
;	check to make sure my name has not been changed
;
	LD	HL,KIM		;my name in the program
	LD	DE,KIMCHK	;'checker' string
	LD	B,8		;length to check
;
TSKCK1	LD	A,(DE)		;fetch check byte
	XOR	'!'		;adjust to normal
	CP	(HL)		;same?
	JR	NZ,KILLPGM	;nope, kill the program
;
	INC	DE		;bump checker
	INC	HL		;bump string
	DJNZ	TSKCK1		;go for 8
;
;	check valid serial #
;
	LD	HL,SERSAVE	;serial number area
	LD	BC,16<8+00H	;B=counter, C=cksum
;
TKCKY	LD	A,(HL)		;fetch a byte
	XOR	'$'		;adjust to normal
	NEG			;reverse it
	ADD	A,C		;add to subtotal
	LD	C,A		;put it back
	INC	HL		;bump pointer
	DJNZ	TKCKY		;do whole length
	CP	40H		;<40H?
	JR	NC,$+5		;go if not
	ADD	A,40H		;adjust checksum
	LD	C,A		;alter checksum
	LD	A,I		;get interrupt register
	CP	C		;match?
	JR	Z,TSKDONE	;OK, continue
;
;	either my name or the serial name is corrupt
;	destroy the program
;
KILLPGM	LD	HL,BASE		;start of writable memory
	LD	DE,BASE+1	;start + 1
	LD	BC,0FFFFH-BASE	;length of ALL RAM
	LD	(HL),0C7H	;RST 00H opcodes
	LDIR			;fill ALL memory
	RST	@00
;
;	check if printer ready to accept spooled char
;
TSKDONE	CALL	SPOOL		;printer spooler
;
;	completed, clear interrupt latch and return
;
TSKNOT	EQU	$
;i*
	IF	MODI.OR.MAX80
	LD	A,(WRINT)	;clear interrupt latch
	ENDIF
;i*
;iii*
	IF	MODIII
	IN	A,(WRINT)	;clear latch III
	ENDIF
;iii*
	POP	HL		;unstack
	POP	DE
	POP	BC
	POP	AF		;restore AF
	EI			;re-enable
	RET			;done, return from int
;i*
	IF	MODI
FDCROST	LD	A,(FDCSTA)	;clear FDC
	JR	TSKNOT		;clear latch and return
	ENDIF
;i*
PERTRC	LD	HL,0		;get program counter
TRACADD	EQU	$-2
	LD	A,H		;get MSB
	CALL	HEXCV		;convert to HEX ascii
	LD	(VIDEO+COLS+58),BC ;put on video
	LD	A,L		;get LSB
	CALL	HEXCV		;to HEX ascii
	LD	(VIDEO+COLS+60),BC ;to video
	RET			;done!
;
TOGTRA	LD	A,(FLAGB)	;get sys flag
	XOR	1		;reverse bit 0
	LD	(FLAGB),A	;update
	JP	TASKCHN		;continue
;
TOGALV	LD	A,(ALVFLAG)	;get flag
	XOR	1		;reverse bit 0
	LD	(ALVFLAG),A	;update
	LD	A,BLOCK		;graphic block
	JP	TSKCNU		;turn off corners
;
TOGALVC	LD	(ALVFLAG),A	;update
	JP	TASKCHN		;continue
;
TOGINK	LD	A,(ALVFLAG)	;get flag
	XOR	2		;reverse bit 1
	JR	TOGALVC		;continue
;
TOGSER	CALL	SERIALV		;check for location
	RST	@08		;display
	DEFB	CLSF		;clear with frame
	DEFM	'Master Date: '
SERIAL1	DEFM	'xxxxxxxxxxxxxxxx'
	DEFB	ETX
;
TOGSERW	LD	A,(KBDR2)	;read keyboard
	BIT	3,A		;key pressed?
	JR	NZ,TOGSERW	;wait for release
	JP	SUBMENU		;back to sub-menu
;
TOGVER	RST	@08		;display
;
	DEFB	CLSF		;clear with frame
	DEFM	'Version 1.00 - Assembled '
	DEFM	'April 25, 1983'
	DEFM	' - kjw/bqsd'
	DEFB	ETX
;
TOGVERW	LD	A,(KBDR2)	;read keyboard
	BIT	6,A		;pressed?
	JR	NZ,TOGVERW	;wait for it
	JP	SUBMENU		;continue
;
