; ptzape/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
; revised 04/21/83 - kjw/bqsd
;
	PAGE
;
;	$STRSER - string search through disk
;
STRSER	CALL	GETDAT		;get drive/track/sector
	CALL	GETCNT		;get sector count
	EXX			;save in alternate
	CALL	INTCNT		;zero the counter
	CALL	INTACNT		;clear alt counter
	CALL	INITBAD		;enable error monitor
	CALL	INITBD1		;turn off non-stop
	CALL	ASKSTR		;get requested string
	JP	STRSERC		;continue search
;
;	$MSTRSER - string search through memory
;
MSTRSER	CALL	INTACNT		;initialize counter
	CALL	GETSE		;get start end
	CALL	BYTECNT		;setup registers
	EXX			;save here
	CALL	ASKSTR		;get the string
;
	PUSH	HL		;save data pointer
	LD	A,B		;get string length
	EXX			;get alternate back
	POP	DE		;DE => string
;
MSERL	PUSH	BC		;save counter
	LD	B,A		;pass length
	LD	C,A		;save here for restore
;
	PUSH	DE		;save 'em
	PUSH	HL		;both pointers
	EX	DE,HL		;swap pointers
	CALL	COMPSP		;special compare
	POP	HL		;restore
	POP	DE		;restore both
;
	CALL	Z,MSTRSAM	;yes if Z
;
MSERN	CALL	PAUSE		;check for space bar
	LD	A,C		;get length back
	POP	BC		;get counter
;
	INC	HL		;next address
	DEC	C		;less 1
	JR	NZ,MSERL	;go loop
	DJNZ	MSERL		;till BC = 0
;
MSTDDON	CALL	SHOACNT		;display counter
	RST	@08		;display message
;
	DEFM	'matches'
	DEFB	ETX
;
	JP	GOBACK		;'enter' to continue
;
;	string match found, display data source
;
MSTRSAM	PUSH	BC		;save from ascii
	PUSH	HL		;save also
	LD	B,H		;pass to BC
	LD	C,L		;BC = value
	LD	HL,MST1		;point to string
	CALL	PUTHEX		;load HEX there
	POP	HL		;unstack
	POP	BC		;get counter back
;
	RST	@08		;display text
;
	DEFB	LF
	DEFM	'Match at '
MST1	DEFM	'xxxxH'
	DEFB	ETX
;
	LD	(ADDRESS),HL	;save last match addr
	CALL	ADDACNT		;bump counter
	LD	A,(FLAGA)	;get system flag
	BIT	2,A		;string replace set?
	RET	Z		;nope, return
;
;	replace the string
;
	CALL	SAVEREG		;save registers
	LD	A,(REPLEN)	;get length of repl str
	LD	C,A		;pass it here
	LD	B,0		;BC = repl length
	EX	DE,HL		;DE = match string
	LD	HL,STRING	;replacement string
	LDIR			;replace it
	RET			;done, restore registers
;
	PAGE
;
;	$ASKSTR - prompt user for string
;
;	ENT	none
;
;	EXT	source string at (DAMBUFF)
;		source length at (STRLEN)
;		replacement string at (STRING)
;		replace length at (REPLEN)
;		bit 2 ($FLAGA) = 1 = replace ON
;		HL => source string
;		B  =  source length
;
;	NOTE	the ascii input that is input from the
;		keyboard will be interpreted if the
;		@ (decode) or # (byte/word list) options
;		are issued.  The string returned will
;		be the resulting ascii/binary product
;
ASKSTR	RST	@08		;display prompt
;
	DEFB	LF		;linefeed
	DEFM	'String:'
	DEFB	LF		;start new line
	DEFB	ETX
;
ASKSTRI	RST	@08		;prompt for input
;
	DEFB	BOL		;clear current line
	DEFB	ETX
;
	LD	B,55		;input length
	RST	@10		;fetch from keyboard
;
;	interrogate string
;
	CALL	ADJSTR		;adjust the string
	JR	C,ASKSTRI	;error, ask again
;
	LD	A,B		;get length
	LD	(STRLEN),A	;save string length
	LD	C,B		;give to C
	LD	B,0		;BC = length
	LD	DE,DAMBUFF	;save string here
	LDIR			;move string in
;
;	$ASKREPL - prompt user for replacement string
;
;	ENT	none
;
;	EXT	string stored at ($STRING)
;		length at ($REPLEN)
;		bit 2 @ ($FLAGA) set if replace on
;
ASKREPL	RST	@08		;display prompt
;
	DEFB	LF		;linefeed
	DEFM	'Replacement:'
	DEFB	LF		;start new line
	DEFB	ETX
;
ASKREP1	RST	@08		;clear current line
;
	DEFB	BOL
	DEFB	ETX
;
	LD	A,(FLAGA)	;get system flag
	RES	2,A		;turn off replace
	LD	(FLAGA),A	;re-save it
	LD	B,55		;same length
	RST	@10		;fetch from keyboard
	JR	Z,ASKREP2	;nil, length, return
	CALL	ADJSTR		;adjust string
	JR	C,ASKREP1	;error, ask again
	LD	A,B		;resulting length
	LD	(REPLEN),A	;save replace length
	LD	A,(FLAGA)	;fetch flag
	SET	2,A		;set 'replace' flag
	LD	(FLAGA),A	;put it back
;
	LD	DE,STRING	;move it here
	LD	C,B		;length to LSB
	LD	B,0		;BC = length
	LDIR			;move it there
	OR	-1		;set NZ
;
ASKREP2	LD	HL,DAMBUFF	;source string start
	LD	A,(STRLEN)	;fetch string length
	LD	B,A		;need it here
	RET	Z		;no replace!
;
	LD	A,(REPLEN)	;fetch length
	CP	B		;check lengths
	RET	C		;less than
	RET	Z		;equal to
;
;	replacement string longer!
;	truncate source string
;
	LD	A,B		;fetch source length
	LD	(REPLEN),A	;truncate
	RET			;done, HL,B = source
;
;	$ADJSTR - adjust string for string search
;
;	ENT	HL => input string
;		B  = length
;
;	EXT	HL => string
;		B  = adjusted length (if different)
;		Carry = input error
;
;	NOTE	if first char of string begins with @
;		then the entire string is 'encrypted'
;		according to the current setting
;		If numerical input is issued (byte list)
;		AND the @ symbol, the byte list will
;		be created FIRST and then decrypted
;	NOTE	string may be intermixed with ascii
;		text and numerical data
;		All strings must be surrounded by either
;		" (case dependent)
;		' (case independent)
;
ADJSTR	LD	A,0C9H		;RET opcode
	LD	(ASKSTRD),A	;disable encrypting
;
	LD	A,(HL)		;fetch a character
	CP	40H		;decode?
	JR	NZ,ADJSTR1	;nope, continue
	XOR	A		;NOP opcode
	LD	(ASKSTRD),A	;enable decrypting
	INC	HL		;bump pointer
	LD	A,(HL)		;fetch next
	DEC	B		;less character
ADJSTR1	INC	B		;any length now?
	DEC	B		;B = 0?
	SCF			;carry = bad
	RET	Z		;error if nil
;
	LD	IX,BUFFER	;temporary buffer
	LD	B,0		;actual length
;
ADJSTR2	CALL	POSHL		;position to next field
	JR	Z,ADJSTRD	;no more, go
;
	CP	'"'		;quote?
	JR	Z,GOTSTR	;have a string
	CP	27H		;single quote
	JR	Z,GOTSTR	;have a string
;
;	not a string, fetch the value
;
	PUSH	BC		;save length
	CALL	VALUE		;fetch value
	JR	C,ADJERR	;error, go!
	LD	A,B		;get MSB
	OR	A		;single byte?
	JR	Z,ADJ1		;yes, go!
;
	LD	(IX),C		;LSB value
	INC	IX		;next
	LD	(IX),B		;MSB value
	POP	AF		;get B from stack
	ADD	A,2		;for 2 bytes new
	JR	ADJ2		;continue
;
ADJ1	LD	(IX),C		;LSB value (byte)
	POP	AF		;get B length
	INC	A		;plus one new byte
ADJ2	INC	IX		;next
	LD	B,A		;pass length back to B
	JR	ADJSTR2		;continue
;
ADJERR	POP	BC		;restore length
	RET			;error, return with C
;
GOTSTR	PUSH	HL		;save HL
	LD	HL,RET		;point to RET opcode
	CP	'"'		;literal?
	JR	Z,GOTSTRZ	;yes, go!
	LD	HL,UCASE	;point to UCASE
GOTSTRZ	LD	(GOTSTRC),HL	;save call
	LD	(GOTXCL),HL	;save for compare
	LD	(GOTXCC),A	;save term char
	POP	HL		;unstack
;
	INC	HL		;bump past quote
GOTSTL	LD	A,(HL)		;fetch a char
	INC	HL		;bump pointer
	CP	0		;terminator?
GOTXCC	EQU	$-1
	JR	Z,ADJSTR2	;continue if yes
	CP	CR		;terminator?
	JR	Z,ADJSTRD	;done, go!
;
	CALL	RET		;call subroutine
GOTSTRC	EQU	$-2
	LD	(IX),A		;put into string
	INC	IX		;bump pointer
	INC	B		;bump length
	JR	GOTSTL		;more string
;
ADJSTRD	INC	B		;any length?
	DEC	B		;B=0?
	SCF			;Carry = bad
	RET	Z		;nil, return
	OR	A		;clear carry
	LD	HL,BUFFER	;data start
;
;	if decode option issued (@) change all the
;	bytes in the string to the current setting
;
ASKSTRD	RET			;intercept here with NOP
;
	PUSH	HL		;save string
	PUSH	BC		;save byte count
ASKSTRE	LD	A,(HL)		;get a byte
	CALL	ADJBYTE		;decode it
	LD	(HL),A		;put it back
	INC	HL		;bump pointer
	DJNZ	ASKSTRE		;do whole thing
	POP	BC		;length
	POP	HL		;pointer
	OR	A		;clear carry flag
;
	RET			;back!
;
;
;	$STRSERC - string search through disk
;
;	ENT	HL => source string
;		B  = string length
;		DE' = start track sector
;		HL' = sector count
;		bit 2 @ ($FLAGA) = replace on/off
;		(REPLEN) = replacement length
;		(STRING) holds replacement string
;
STRSERC	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	EXX			;save, get data source
;
STRSERL	LD	BC,BUFFER	;I/O buffer
	PUSH	HL		;save count
	RST	@28		;read sector with display
	POP	HL		;count back
;
	EXX			;alternate set
	LD	DE,BUFFER	;disk data
	LD	A,0C9H		;RET opcode
	LD	(UPDVEC),A	;turn off sector update
;
STRSERP	PUSH	HL		;save 'em
	PUSH	DE
	PUSH	BC
	CALL	COMPSP		;special compare
	POP	BC		;unstack 'em
	POP	DE
	POP	HL
	CALL	Z,STRMAT	;have a match?
;
STRNEX	CALL	PAUSE		;space bar?
	INC	E		;next byte
	JR	NZ,STRSERP	;not end of sector, go!
;
	EXX			;drive set back
	CALL	UPDVEC		;update the sector?
	DEC	HL		;one sector less
	CALL	NEXSEC		;next sector
	JR	C,STRSERD	;end of disk, end it!
	LD	A,H		;any more sectors left?
	OR	L		;any bits?
	JR	NZ,STRSERL	;yes, go again
;
STRSERD	CALL	SHOCNT		;display counter
	RST	@08		;message
;
	DEFM	'sectors NOT read'
	DEFB	ETX
;
	CALL	SHOACNT		;alternate counter
	RST	@08		;message
;
	DEFM	'matches'
	DEFB	ETX
;
	JP	GOBACK		;back to menu
;
;	$STRMAT - display string match and count it
;
STRMAT	PUSH	BC		;save from ascii
	LD	A,E		;get relative sect byte
	RST	@20		;to hex ascii
	LD	(STRMX),BC	;put in string
	POP	BC
;
	RST	@08		;display it
;
	DEFM	' Match @ '
STRMX	DEFM	'xxH'
	DEFB	LF
	DEFB	ETX
;
	EXX			;drive set back
	LD	(SECTOR),DE	;save this sector
	EXX			;put 'em back
;
	CALL	ADDACNT		;bump match counter
;
;	check for replacement
;
	LD	A,(FLAGA)	;system flag
	BIT	2,A		;replace on?
	RET	Z		;nope, return
;
	PUSH	DE		;save buff posit
	PUSH	HL		;string posit
	PUSH	BC		;length
	LD	HL,STRING	;replace string
	LD	BC,(REPLEN)	;C = replacement length
	LD	B,0		;BC = length
	LDIR			;move the new data
	POP	BC		;unstack
	POP	HL
	POP	DE		;restore pointer
;
;	allow sector to be re-written back to disk
;
	XOR	A		;NOP opcode
	LD	(UPDVEC),A	;put into code
	RET			;back to caller
;
;	when a sector has been completed, and needs
;	to be written back to disk, this subroutine
;	will do it.  First byte can be intercepted
;	with a RET instruction
;
UPDVEC	RET			;update to disk
	PUSH	HL		;save counter
	LD	BC,BUFFER	;data is here
	RST	@30		;write to disk
	POP	HL		;counter back
	RET			;done with replace
;
	PAGE
;
;	$REVSEC - reverse disk sectors
;
REVSEC	CALL	GETDAT		;drive track sector
	CALL	GETCNT		;sector count
	CALL	INITBD1		;clear non-stop
	CALL	INTCNT		;clear error counter
	CALL	DSTAT		;check status
	JP	NZ,SUBMENU	;skip, back to menu
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
REVSECL	LD	BC,BUFFER	;use low buffer
	LD	(REVDE),DE	;save start track sector
;
	PUSH	HL		;save count
	CALL	MREAD		;multiple read
	LD	B,H		;remaining count to BC
	LD	C,L
	POP	HL		;restore original
;
	OR	A		;clear carry
	SBC	HL,BC		;HL = number just read
;
	PUSH	BC		;number sects remaining
;
	PUSH	HL		;number this pass
	LD	B,H		;give to BC
	LD	C,L		;BC = number pages in mem
	LD	HL,BUFFER	;start of area
	PUSH	HL		;pass to BC
;
REVSECT	CALL	SWAP		;reverse this page
	DEC	BC		;any more to do in mem?
	LD	A,B		;get counter
	OR	C		;any bits?
	JR	NZ,REVSECT	;yes, finish memory
	POP	BC		;buffer
	POP	HL		;counter
;
	LD	DE,0		;data start track/sect
REVDE	EQU	$-2
	CALL	MWRITE		;write 'em back
	POP	HL		;remaining count
;
	LD	A,H		;any more to do?
	OR	L
	JR	NZ,REVSECL	;continue through loop
;
;	completed, display status
;
	CALL	SHOCNT		;display error counter
	RST	@08		;message
;
	DEFM	'reversal errors'
	DEFB	ETX
;
	JP	GOBACK		;'enter' to continue
;
;	$SWAP - reverse all byte in a 256 byte block
;
;	ENT	HL => page in memory (256 bytes)
;
;	EXT	HL => next page
;
SWAP	PUSH	HL		;save pointer
	PUSH	DE		;compare pointer
	PUSH	BC		;save counter
;
	LD	D,H		;pass to DE
	LD	E,L		;DE => first byte
;
	LD	BC,0FFH		;offset to end
	ADD	HL,BC		;HL => last byte
	LD	B,80H		;page count / 2
;
SWAPL	LD	C,(HL)		;get a byte
	LD	A,(DE)		;get this byte
	LD	(HL),A		;put it here
	LD	A,C		;get original
	LD	(DE),A		;save this
;
	DEC	HL		;dec top pointer
	INC	DE		;inc bottom pointer
	DJNZ	SWAPL		;go till all done
;
	POP	BC		;restore everything
	POP	DE
	POP	HL
;
	INC	H		;look at next page
	RET			;back for next test
;
	PAGE
;
;	$SECSER - sector search utility
;
SECSER	RST	@08		;prompt
;
	DEFB	LF
	DEFM	'Source'
	DEFB	ETX
;
	CALL	GETDAT		;drive, track, sector
	CALL	DSTAT		;drive ready?
	JP	NZ,SUBMENU	;nope, back to menu
	CALL	INITBD1		;clear non-stop
	LD	BC,BUFFER	;I/O buffer
	RST	@08		;linefeed
;
	DEFB	LF
	DEFB	ETX
;
	RST	@28		;read the sector
	JP	C,SUBMENU	;skip, cancel it
;
	CALL	INTCNT		;clear error counter
	CALL	INTACNT		;clear alt counter too
	RST	@08		;prompt
;
	DEFB	LF
	DEFM	'Search'
	DEFB	ETX
;
	CALL	GETDAT		;drive,track,sector
	CALL	GETCNT		;get sector count
	CALL	INITBD1		;clear nonstop
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DSTAT		;drive ready?
	JP	NZ,SUBMENU	;nope, abort sub-menu
;
SECSERL	LD	BC,HITBUFF	;buffer + 100H
;
	PUSH	HL		;save count
	RST	@28		;read it
	POP	HL		;restore count
;
	JR	C,NTOCTH	;skip, don't compare
;
	EXX			;save everything
	LD	HL,BUFFER	;source data
	LD	DE,HITBUFF	;compare data
	LD	B,0		;256 bytes long
	CALL	COMPARE		;same?
	CALL	Z,SECSERF	;print it out if yes
	EXX			;swap 'em back
;
NTOCTH	CALL	PAUSE		;check space bar
	CALL	NEXSEC		;bump sector
	JR	C,SECSFIN	;end of disk, done!
	DEC	HL		;less count
	LD	A,H		;any more?
	OR	L
	JR	NZ,SECSERL	;yes, continue!
;
SECSFIN	CALL	SHOCNT		;display error counter
	RST	@08		;message
;
	DEFM	'sectors NOT read'
	DEFB	ETX
;
	CALL	SHOACNT		;display aternate counter
	RST	@08		;message
;
	DEFM	'matches'
	DEFB	ETX
;
	JP	GOBACK		;enter to continue
;
;	display that the sector matched
;
SECSERF	RST	@08		;display
;
	DEFM	'   Exact Match'
	DEFB	LF		;linefeed
	DEFB	ETX		;terminator
;
	JP	ADDACNT		;bump match counter
;
	PAGE
;
;	$IDMARKS - read ID marks from diskette
;
IDMARKS	CALL	ONEDRIV		;ask for one drive
	CALL	DSTAT		;drive ready?
	JP	NZ,SUBMENU	;nope, go sub-menu
	XOR	A		;load zero
	LD	(IDMK),A	;clear flag
	RES	1,(IY+5)	;set current access side0
	SET	3,(IY+5)	;non-standard I/O
;
;	could mess up the FDC track register
;	set the $RETURN vector to reset the drive
;	we're using when this routine has completed
;
	XOR	A
	LD	(TASKDRV),A
;
	CALL	RESTORE		;restore the drive
	JP	NZ,SUBMENU	;'drive not in system'
	CALL	SETSIDX		;select correct side
;
	XOR	A		;set true track 0
	LD	(TRUE),A	;save it
	RST	@08		;display video header
;
	DEFB	CLSF		;clear screen
	DEFB	ETX
;
;	display header line
;
	LD	HL,VIDEO+0C2H	;video where it goes
	LD	DE,IDNAMG	;text
	CALL	CLSON		;display @HL
;
;	scroll up display, but don't touch top 2 lines
;
ADDLP	LD	HL,VIDEO+898	;end last display line
	LD	(CURSOR),HL	;set cursor there
	RST	@08		;display linefeed
;
	DEFB	LF		;linefeed
	DEFB	EOL		;clear the line
	DEFB	ETX		;terminator
;
;	display drive information on last line
;	that was just cleared
;
	LD	A,':'		;for drive number
	LD	(VIDEO+896+2),A	;start bottom line
	CALL	DRVASC		;ascii drive number
	LD	(VIDEO+896+3),A	;to the video
;
	LD	A,'='		;for track
	LD	(VIDEO+896+6),A	;to the video
	LD	A,(TRUE)	;get track (real one)
	RST	@18		;decimal ascii
	LD	(VIDEO+896+7),A	;to the video
	LD	(VIDEO+896+8),BC ;rest of it
;
	BIT	6,(IY+6)	;yes?
	JR	Z,ISDEN		;yes, put on video
	BIT	7,(IY+6)	;single den track 0?
	JR	NZ,IDDEN	;no, set double
	LD	A,(TRUE)	;get real track
	OR	A		;on zero?
	JR	Z,ISDEN		;yes, set single
IDDEN	LD	A,'D'		;double den
	JR	IPDEN		;to the video
ISDEN	LD	A,'S'		;single density
IPDEN	LD	(VIDEO+896+4),A	;density to video
	LD	A,27H		;side 0
	BIT	1,(IY+5)	;on side 0?
	JR	Z,$+4		;go if yes
	LD	A,22H		;side 1
	LD	(VIDEO+896+5),A	;to video
;
	CALL	CKADDR		;read address marks
	JP	Z,IDNOT		;not formatted!
	JP	C,DAMNOTR	;disk error!
;
	LD	A,(HL)		;get track
	RST	@18		;decimal ascii
	LD	(VIDEO+896+11),A ;to the video
	LD	(VIDEO+896+12),BC ;rest of it
;
	INC	HL
	LD	A,(HL)		;head number
	RST	@18		;decimal ascii
	LD	(VIDEO+896+17),A ;to the video
	LD	(VIDEO+896+18),BC ;rest
;
	INC	HL
	LD	A,(HL)		;sector number
	RST	@18		;decimal ascii
	LD	(VIDEO+896+22),A ;to the video
	LD	(VIDEO+896+23),BC ;rest
;
	INC	HL
	LD	A,(HL)		;sector length
	RST	@18		;decimal ascii
	LD	(VIDEO+896+29),A ;to the video
	LD	(VIDEO+896+30),BC ;rest
;
	INC	HL
	LD	A,(HL)		;CRC 1
	RST	@20		;hex ascii
	LD	(VIDEO+896+36),BC ;to the video
;
	INC	HL
	LD	A,(HL)		;CRC 2
	RST	@20		;hex ascii
	LD	(VIDEO+896+42),BC ;to the video
;
	LD	A,'H'		;HEX specifier
	LD	(VIDEO+896+38),A ;to the video
	LD	(VIDEO+896+44),A ;here too
;
	CALL	XIDMARK		;extended info?
;
IDRET	CALL	PAUSE		;holding?
	CALL	INKEY		;check a key
	JP	Z,ADDLP		;loop if no key
;
	LD	DE,IDTABLE	;key/jump table
	CALL	GOTABL		;perform the key
	JP	ADDLP		;no matches, continue
;
;	lookup table of valid ID mark commands
;
IDTABLE	DEFB	DARR		;d arrow?
	DEFW	IDDOWN
	DEFB	UARR		;u arrow?
	DEFW	IDUP
	DEFB	SDARR		;s d arrow?
	DEFW	IDBOT
	DEFB	SUARR		;s u arrow?
	DEFW	IDTOP
	DEFB	'X'		;toggle extended mode?
	DEFW	IDXCHG
	DEFB	'S'		;force single den?
	DEFW	IDSNGL
	DEFB	'D'		;force double den?
	DEFW	IDDBL
	DEFB	'F'		;force side 0?
	DEFW	IDSID0
	DEFB	'B'		;force side 1?
	DEFW	IDSID1
	DEFB	27H		;side 0?
	DEFW	IDSID0
	DEFB	'"'		;side 1?
	DEFW	IDSID1
	DEFB	ETBL		;terminator
;
;	move up a track if not at end of disk
;
IDUPX	LD	A,(TRUE)	;get track we're on
	INC	A		;bump for test
	CP	(IY+0)		;physical tracks
	RET	Z		;can't bump it, return Z
;
	LD	(TRUE),A	;update real track
	CALL	STEPIN		;move head in
	OR	-1		;set NZ for not disk end
	RET			;done
;
;	move down one track
;
IDDOWN	LD	A,(TRUE)	;at bottom now?
	OR	A		;zero?
	JP	Z,ADDLP		;yes, ignore it
;
	DEC	A		;less one
	LD	(TRUE),A	;update true track
	CALL	STEPOUT		;step out a track
	JP	ADDLP		;continue
;
IDTOP	CALL	IDUPX		;move up one track
	JR	NZ,IDTOP	;more, go again
	JP	ADDLP		;continue
;
;	move to lowest track (0)
;
IDBOT	CALL	RESTORE		;move to track 0
	XOR	A		;set true track
	LD	(TRUE),A	;save it
	JP	ADDLP		;continue
;
;	move up one track
;
IDUP	CALL	IDUPX		;up a track
	JP	ADDLP		;resume
;
;	force in single/double density & side 0/1
;
IDSNGL	RES	7,(IY+6)	;set single den
	RES	6,(IY+6)	;single disk
	LD	A,-1		;set flag
	LD	(IDMK),A	;set flag
	JP	ADDLP		;continue
;
IDDBL	SET	7,(IY+6)	;set double 0
	SET	6,(IY+6)	;set double disk
	LD	A,-1		;set flag
	LD	(IDMK),A	;set LOCK
	JP	ADDLP		;continue
;
IDSID0	RES	1,(IY+5)	;set side 0
	RES	0,(IY+5)	;set single sided
	JP	ADDLP		;continue
;
IDSID1	SET	1,(IY+5)	;set side 1
	SET	0,(IY+5)	;set double sided
	JP	ADDLP		;continue
;
;	track not formatted in current density
;
IDNOT	LD	HL,VIDEO+896+10	;position the cursor
	LD	(CURSOR),HL	;save it
	RST	@08		;display message
;
	DEFM	'  Flawed'
	DEFB	ETX
;
	JP	IDRET		;resume
;
;	error issued from FDC, possible correct density
;
DAMNOTR	LD	HL,VIDEO+896+10	;video for display
	LD	(CURSOR),HL	;set the cursor there
	RST	@08		;display it
;
	DEFM	'  ID Read Error'
	DEFB	ETX
;
	JP	IDRET		;resume
;
	PAGE
;
;	$CKADDR - check for valid ID marks
;
;	ENT	none
;
;	EXT	Carry = disk error
;		Z = disk not formatted
;		else (INPUT) has valid data
;		HL => input data
;
CKADDR	LD	HL,INPUT	;clear the buffer
	LD	B,6		;6 bytes long
	XOR	A		;load with zero
	CALL	FILL		;clear it out
;
	CALL	ADDR		;read the marks
	SCF			;prepare for error
	JR	NZ,CKADDRS	;abort, flip density
;
	PUSH	HL		;save buffer start
	PUSH	BC		;save counter
	LD	BC,0600H	;B = count, C = sum
;
CKADDRL	LD	A,(HL)		;get a byte
	ADD	A,C		;add to total
	LD	C,A		;save back here
	INC	HL		;bump position
	DJNZ	CKADDRL		;go for 6 bytes
	POP	BC		;A has total
	POP	HL		;HL=>data
;
	OR	A		;set Z, clear C
	RET	NZ		;done, data in buffer
;
CKADDRS	PUSH	AF		;save result
	LD	A,'$'		;get flag
IDMK	EQU	$-1
	OR	A		;lock OFF?
	CALL	Z,FLIPDEN	;reverse density
	POP	AF		;restore result
	RET			;back to caller
;
;	$XIDMARK - display extended field data
;
XIDMARK	LD	A,(FLAGA)	;fetch system flag
	BIT	3,A		;extended on?
	RET	Z		;nope, return
;
	LD	HL,INPUT	;point to buffer
	LD	D,(HL)		;get track
	INC	HL
	INC	HL
	LD	E,(HL)		;get sector
	LD	A,D		;fetch track
;
;	force the track into the FDC
;
;i*
	IF	MODI
	LD	(FDCTRK),A	;track to FDC I
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCTRK),A	;to track register
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCTRK),A	;track to FDC III
	ENDIF
;iii*
;
	LD	BC,BUFFER	;use this buffer
	CALL	READNS		;read it, no seeking
	JR	Z,IDMOK		;no error, continue
;
	BIT	3,A		;CRC error?
	JR	Z,IDMOK		;go if not
	PUSH	BC		;save
	CALL	FIXSET		;load B with IBM bit
	LD	A,(RDTYPE)	;get current read
	XOR	B		;reverse bit if set
	POP	BC		;restore
	LD	(RDTYPE),A	;reset type of read
	CALL	READNS		;try to read again
;
IDMOK	LD	A,(RESULT)	;get non-masked result
;
	BIT	3,A		;data field OK
	LD	BC,'YY'		;both correct?
	JR	Z,IFX2		;both OK
	BIT	4,A		;see if ID error
	LD	B,'N'		;DATA no
	JR	Z,IFX2		;ID ok, DATA not
	LD	C,B		;ID no
	LD	B,'*'		;DATA not detected
IFX2	LD	(VIDEO+896+49),BC ;to the video
;
	CALL	FIXSET		;fetch IBM type
	LD	A,(RDTYPE)	;fetch read type
	AND	8		;check IBM bit
	CP	B		;match?
;
	LD	A,'Y'
	JR	Z,IFX2A
	LD	A,'N'
IFX2A	LD	(VIDEO+896+54),A ;to the video
;
	LD	A,(WRTYPE)	;fetch write for DAM
	AND	3		;low 2 bits only
	LD	B,A		;save it
	ADD	A,A		;*2
	ADD	A,B		;*3
	LD	C,A		;give to C
	LD	B,0		;BC = table offset
	LD	HL,MODDAT	;DAM text
	ADD	HL,BC		;HL => text
	LD	BC,3		;length
	LD	DE,VIDEO+896+58	;video
	LDIR			;move to video
	RET			;done, back to caller
;
;	toggle extended ID mark mode
;
IDXCHG	LD	A,(FLAGA)	;get flag byte
	XOR	8		;reverse bit 3
	LD	(FLAGA),A	;put it back
	JP	ADDLP		;resume
;
IDNAMG	DEFM	'Source  Track Head Sector Length '
	DEFM	'CRC1  CRC2  ckCRC IBM Data'
	DEFB	ETX
;
;	$COMPSP - special comparator
;
COMPSP	LD	A,(DE)		;get data byte
	CALL	RET		;convert?
GOTXCL	EQU	$-2
	CP	(HL)		;match?
	RET	NZ		;nope, done!
	INC	HL		;bump
	INC	DE		;both pointers
	DJNZ	COMPSP		;go till done
	RET			;ret Z
;
