; ptdiskb/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
; revised 04/25/83 - kjw/bqsd
;
	PAGE
;
;	$SEEKWHT - adjust track for double step
;
;	ENT	D = track number desired
;
;	EXT	A = track number to $SEEK
;
SEEKWHT	BIT	6,(IY+5)	;double step it?
	LD	A,D		;get track
	RET	Z		;nope, don't adjust
;
	ADD	A,A		;double it
	RET			;that's all there is!
;
	PAGE
;
;	$DSTAT	- check if drive is ready to go
;
;	ENT	(DRIVE) valid for $SELECT
;
;	EXT	Z = drive ready
;		NZ = not ready, SKIP DRIVE selected
;
DSTAT	XOR	A		;set NOP opcode
	JR	STAT+2		;continue
;
;	$STAT	- check disk drive status
;
;	ENT	(DRIVE) valid for $SELECT
;
;	EXT	Z = drive ready
;		NZ = drive not ready, HL => error text
;
;
;	NOTE	a call to DSTAT will prompt the user
;		to correct the condition and will only
;		return NZ if the used selected to
;		skip the drive
;		a call to STAT will not prompt the
;		user, but will immediately return
;		with the status of the drive
;
STAT	LD	A,0C9H		;set RETURN opcode
;
	LD	(HFLG),A	;set operation into code
;
	CALL	SELECT		;select the drive
	CALL	INTFDC		;immediate reset
;
	CALL	DRVASC		;get ascii drive
	LD	(E0),A		;save into error strings
	LD	(E5),A
	LD	(E9),A
;
	CALL	SAVEREG		;save registers
;
STAT2	CALL	SELECT		;select the drive
	LD	HL,ERMSG5	;error message text
	JR	NZ,HOLDER	;error, go!
;
;	read index hole to see if a disk is in
;	the drive and turning
;
;	make sure we start with NO index
;
	LD	HL,ERMSG0	;error text
	LD	BC,0C000H	;8" select delay
;
TT1	CALL	TT0		;dec and read index
	JR	NZ,TT1		;wait if hole here
;
;	no index hole at the current disk position
;	wait for one to come around
;
	LD	HL,ERMSG9	;error text
;
TT2	CALL	TT0		;dec and read status
	JR	Z,TT2		;wait for it
;
;	index hole found, now is should go away!
;
	LD	HL,ERMSG0	;error message
;
TT3	CALL	TT0		;dec and read FDC
	JR	NZ,TT3		;if yes, wait a bit more
;
;	index hole came and went, disk is there all right
;
	XOR	A		;return ZERO status
	RET			;no error!
;
;	check for countdown, and read index status
;
TT0	DEC	BC		;less this pass
	LD	A,B		;any time left?
	OR	C
	JR	Z,HOLDER-1	;go if done!
;i*
	IF	MODI
	LD	A,(FDCSTA)	;FDC mod I
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,(FDCSTA)	;get status
	CPL			;reverse bits
	ENDIF
;m*
;iii*
	IF	MODIII
	IN	A,(FDCSTA)	;FDC mod III
	ENDIF
;iii*
	AND	2		;check bit 1
	RET			;return with flag
;
;	error found on drive ready
;	check if error is to be displayed
;
	POP	AF		;dummy pop call
HOLDER	CALL	INTFDC		;immediate interrupt
	OR	-1		;set NZ flag for error
	LD	(TEMP3),HL	;save error text
;
HFLG	NOP			;either NOP or RET
;
	PUSH	HL		;put error text on stack
	RST	@08		;display following
;
	DEFB	CLSF		;clear screen
	DEFB	ETX		;terminator
;
	JP	@08		;display error on stack
;
;	error displayed, prompt to correct the problem
;
HOLDIN	NOP			;can be vectored
	RST	@08		;display following
;
	DEFB	LF
	DEFM	'<ENTER>, <BREAK>, or <S>kip:'
	DEFB	ETX
;
	CALL	ONEKEY		;fetch a single key
	RST	@08		;display following
;
	DEFB	EOL		;BOL and clear curr line
	DEFB	UFEED		;move cursor up one row
	DEFB	EOL		;clear it too
	DEFB	UFEED		;up one more row
	DEFB	ETX		;terminator
;
	CALL	UCASE		;make input upper case
	CP	'S'		;<SKIP>?
	JP	NZ,STAT2	;nope, check again
;
;	skip issued, return to caller NZ
;
	OR	-1		;set NZ
	RET			;done
;
;	text for drive not ready
;
ERMSG5	DEFB	LF
	DEFM	'Drive '
E5	DEFM	'x DEACTIVATED'
	DEFB	ETX
	JP	HOLDIN		;continue processing
;
ERMSG9	DEFB	LF
	DEFM	'OPEN DOOR on Drive '
E9	DEFM	'x'
	DEFB	ETX
	JP	HOLDIN		;continue
;
ERMSG0	DEFB	LF
	DEFM	'NO DISKETTE in Drive '
E0	DEFM	'x'
	DEFB	ETX
	JP	HOLDIN		;continue
;
	PAGE
;
;	$SELDEN	- select FDC chip on Mod I's
;
;	ENT	(DRIVE) setup for $SELECT
;
;	EXT	single/double density chip selected
;
;	NOTE	this service if for the Mod I ONLY!
;	NOTE	since there are actually two FDC chips
;		in the Mod I for double density, the
;		track register contents must be passed
;		from chip to chip so it doesn't get lost
;	NOTE	if bit 4 (FLAGB) is set, then no attempt
;		will be made to read double density
;		if bit 2 (FLAGB) is set, then the
;		Radio Shack Doubler is installed and
;		will be selected accordingly
;
;i*
	IF	MODI
SELDEN	CALL	RESFDC		;reset FDC
	LD	A,(FLAGB)	;get system flag B
	PUSH	BC		;save it
	BIT	4,A		;density available?
	JR	NZ,SELSNG	;nope, force single
;
	BIT	6,(IY+6)	;double density?
	JR	Z,SELSNG	;nope, select single
;
	BIT	7,(IY+6)	;track 0 double?
	JR	NZ,SELDBL	;yes, select double
;
	INC	D		;check for track 0
	DEC	D		;D=0?
	JR	NZ,SELDBL	;nope, select double
;
;	select single density
;
SELSNG	LD	BC,0A0FEH	;B=R/S, C=other
	JR	SELDNOK		;continue
;
;	select double density
;
SELDBL	LD	BC,080FFH	;B=R/S, C=others
;
;	have both patterns, check for which
;	doubler to select
;
SELDNOK	BIT	2,A		;radio shack doubler?
	JR	Z,SELRS		;yes, do it!
;
	LD	A,(FDCSEC)	;get sector register
	LD	B,A		;save it
	LD	A,(FDCTRK)	;fetch the current track
	EX	AF,AF'		;save it
	LD	A,C		;fetch non-R/S code
	LD	(FDCCMD),A	;select the correct chip
	EX	AF,AF'		;get track back
	LD	(FDCTRK),A	;put into new chip
	LD	A,B		;get sector
	LD	(FDCSEC),A	;pass it
	JR	SELERET		;continue, done
;
SELRS	LD	A,(FDCSEC)	;get current sect reg
	LD	C,A		;save it
	LD	A,(FDCTRK)	;get track register
	EX	AF,AF'		;save it
	LD	A,D		;get track
	CP	21		;>21?
	LD	A,0C0H		;non pre-comp
	JR	C,SELPM		;nope, go!
	OR	20H		;enable pre-comp
SELPM	LD	(FDCSEC),A	;select the chip
	LD	A,B		;get select code
	LD	(FDCSEC),A	;select it
;
	EX	AF,AF'		;get track back
	LD	(FDCTRK),A	;pass to new chip
	LD	A,C		;get sector back
	LD	(FDCSEC),A	;give to new chip
;
SELERET	CALL	RESFDC		;reset the controller
;
	POP	BC		;unstack
	JP	SELECT		;reselect drive
;
	ENDIF
;i*
;m*
	IF	MAX80
SELDEN	LD	A,(DRIVE)	;fetch drive select
	AND	0FH		;keep low 4 only
	BIT	6,(IY+6)	;double density?
	JR	Z,SELSNG	;go if single
	BIT	7,(IY+6)	;double track 0?
	JR	NZ,SELDBL	;yes, go double
	INC	D		;on track 0?
	DEC	D		;D = 00?
	JR	NZ,SELDBL	;go double if not 00
;
SELSNG	JR	SELSDS		;go common
;
SELDBL	SET	6,A		;set double
;
SELSDS	BIT	1,(IY+5)	;side 1 access?
	JR	Z,SELSD9	;go if not
	SET	4,A		;set side 1
SELSD9	BIT	2,(IY+5)	;8" select?
	JR	Z,SELSD99	;go if not
	SET	5,A		;set 8" access
SELSD99	LD	(DRIVE),A	;update select code
	JP	SELECT		;reselect drive
	ENDIF
;m*
;
	PAGE
;
;	$RXFER	- disk read I/O transfer
;
;	ENT	command has been issued to the FDC
;
;	EXT	A = status byte of operation
;
RXFER	CALL	DSKSLO		;wait for valid status
;i*
	IF	MODI
RX0	LD	A,(HL)		;fetch FDC status
	AND	03H		;check for READY
	JP	PO,RX0		;wait if not
;
RX1	LD	A,(DE)		;fetch a byte from FDC
	LD	(BC),A		;put into the buffer
	INC	BC		;bump buffer
;
RX2	BIT	1,(HL)		;another byte ready?
	JR	NZ,RX1		;yes, get it
	BIT	1,(HL)		;ready now?
	JR	NZ,RX1		;yes, go!
	BIT	1,(HL)		;ready?
	JR	NZ,RX1		;fetch if yes
	BIT	7,(HL)		;drive motor still on?
	JR	NZ,XFERET	;go if no
	BIT	0,(HL)		;command completed?
	JR	NZ,RX2		;no, wait again
;
XFERET	LD	A,(HL)		;fetch FDC status byte
	CALL	RESFDC		;reset the FDC
	LD	(RESULT),A	;save non-masked result
	LD	(TEMPFF),BC	;save end of buffer
	EI			;can enable now
	RET			;return to caller
	ENDIF
;i*
;m*
	IF	MAX80
	LD	HL,XFERET	;return address
	PUSH	HL		;to the stack
	LD	HL,USTAT	;FDC status
	JP	RX2		;continue
;
RX0	RET	PO		;go if done!
RX1	AND	(HL)		;byte ready?
	JP	M,RX0		;go if not
	LD	A,(DE)		;get FDC byte
	CPL			;make normal
	LD	(BC),A		;to buffer
	INC	BC		;bump buffer
RX2	LD	A,0C0H		;setup test mask
	JP	RX1		;continue
;
XFERET	LD	A,(FDCSTA)	;read resulting status
	CPL			;reverse bits
	CALL	RESFDC		;reset FDC
	LD	(RESULT),A	;save unmasked result
	LD	(TEMPFF),BC	;save buff pointer
	EI			;can enable now
	RET			;done
	ENDIF
;m*
;iii*
	IF	MODIII
RFF1	IN	A,(FDCSTA)	;fetch FDC status
	AND	E		;byte ready?
	JR	Z,RFF1		;wait for one if not
	INI			;fetch the byte
	LD	A,D		;go to wait states
;
RFF2	OUT	(FDCSEL),A	;set 'wait' state
	INI			;fetch a byte
;
;	NOTE	the following code will test for 
;		256 bytes of data being read in
;		and will terminate and wait for an
;		interrupt
;		On track reads, the byte count will
;		exceed 256 bytes, and therefore the
;		vector $RD3FIX may be intercepted
;		to allow the transfer to contine
;		by changing the JRNZ to a JR
;
RD3FIX	JR	NZ,RFF2		;go for a sector
	JR	$		;wait for interrupt
	ENDIF
;iii*
;
	PAGE
;
;	$WXFER	- write data to disk
;
;	ENT	disk command has been issued
;
;	EXT	A = status byte of operation
;
WXFER	CALL	DSKSLO		;wait for valid status
;i*
	IF	MODI
	LD	A,(HL)		;fetch status
	AND	81H		;bit 7 and 0
	CP	1		;must be this
	LD	A,8		;force CRC error if not
	JR	NZ,XFERET+1	;nope, bail out!
;
	LD	A,(BC)		;fetch byte from buffer
;
WX1	BIT	7,(HL)		;drive motor on?
	JR	NZ,XFERET	;nope, bail out!
;
	BIT	1,(HL)		;ready for a byte?
	JR	Z,WX1		;wait if no
;
	LD	(DE),A		;give to FDC
	INC	BC		;bump buffer
;
	LD	A,(DRIVE)	;get drive select code
	LD	(FDCSEL),A	;re-select drive
;
	LD	A,(BC)		;fetch 2nd byte
;
WX2	BIT	1,(HL)		;ready for it?
	JR	Z,WX2		;wait her till yes
;
WX3	LD	(DE),A		;give byte to FDC
	INC	BC		;bump buffer
	LD	A,(BC)		;fetch next byte
;
WX4	BIT	1,(HL)		;ready for a byte?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;ready now?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;ready now?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;now?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;how bout now?
	JR	NZ,WX3		;go if yes
	BIT	1,(HL)		;yet?
	JR	NZ,WX3		;go if yes
;
	BIT	0,(HL)		;command done?
	JR	NZ,WX4		;if not, wait some more
;
WX5	JR	XFERET		;exit from transfer
	ENDIF
;i*
;m*
	IF	MAX80
	LD	HL,XFERET	;return vector
	PUSH	HL		;leave on stack
	LD	HL,USTAT	;FDC status
	JP	WX2		;continue
;
WX0	RET	PO		;go if completed
WX1	AND	(HL)		;ready for byte?
	JP	M,WX0		;go if not
	LD	A,(BC)		;get buffer byte
	CPL			;normalize
	LD	(DE),A		;to FDC register
	INC	BC		;bump buffer
WX2	LD	A,0C0H		;setup mask
	JP	WX1		;continue
	ENDIF
;m*
;iii*
	IF	MODIII
WFF1	IN	A,(FDCSTA)	;read FDC status
	AND	E		;read to go!
	JR	Z,WFF1		;nope, wait some more
	OUTI			;write byte to FDC
;
	LD	B,60H		;wait before 2nd byte
	DJNZ	$
	DEC	B		;B = remaining bytes
	LD	A,D		;get wait state flag
;
WFF2	OUT	(FDCSEL),A	;set wait states
	OUTI			;write a byte to disk
WR3FIX	JR	NZ,WFF2		;go for 256
	JR	$		;wait to be interrupted
	ENDIF
;
	PAGE
;
;	$WRITETR - special 'write track' code
;
;	ENT	head positioned over correct track
;		BC => data buffer to be written
;
;	EXT	Z = OK
;		NZ = A = error status byte
;
WRITETR	LD	A,(IY+4)	;get drive type byte
	AND	40H		;software write protect?
	RET	NZ		;yes, return error
;
	LD	A,5		;make 5 attempts
	LD	(WTRIES),A	;save try counter
;
WTRIE	PUSH	BC		;save buffer start
	SET	7,(IY+5)	;operation is WRITE
	CALL	TRWRITE		;write the track
	POP	BC		;load back
	AND	0FFH		;check for errors
	RET	Z		;done, no error
;
	EX	AF,AF'		;save result
;
	CALL	RESFDC		;reset FDC
	EX	AF,AF'		;get error
	BIT	6,A		;write protect?
	RET	NZ		;yes, abort!
	EX	AF,AF'		;swap back
	LD	A,5		;fetch # tries left
WTRIES	EQU	$-1
	DEC	A		;less this bad one
	LD	(WTRIES),A	;put it back
	JR	NZ,WTRIE	;more to do, try again
	EX	AF,AF'		;fetch error status back
	RET			;return in error
;
TRWRITE	CALL	SELECT		;try to write it
	RET	NZ		;not ready
;i*
	IF	MODI
	LD	D,(IY+3)	;get current track
	CALL	SELDEN		;setup density chip
	LD	HL,FDCCMD	;point to FDC
	LD	DE,FDCDAT	;data address
	DI			;disable
	LD	(HL),0F4H	;write track command
	JP	WXFER		;write the data
	ENDIF
;i*
;m*
	IF	MAX80
	LD	D,(IY+3)	;get current track
	CALL	SELDEN		;select density
	LD	HL,FDCCMD	;FDC command
	LD	DE,FDCDAT	;data address
	DI			;disable interrupts
	LD	A,0F4H.XOR.-1	;write track command
	LD	(HL),A		;to FDC
	JP	WXFER		;transfer!
	ENDIF
;m*
;iii*
	IF	MODIII
	LD	D,(IY+3)	;current track
	CALL	SETNMI		;setup for NMI I/O vector
	LD	B,3		;B = mask, not counter
;
	LD	A,0F0H		;write track command
	OUT	(FDCCMD),A	;give to FDC III
	CALL	DSKSLO		;wait for valid status
;
;	the first 2 bytes are very critical on the
;	mod III full track writes
;	by checking parity on the two low bits
;	of the status register
;	(1=data register empty, 0=command completed)
;	if both are set, then the FDC is ready to
;	take the first byte.  If both are reset then
;	the command has terminated prematurely and
;	will fall through and be detected on the
;	interrupt lines
;	if the FDC is ready, the data register must
;	be loaded in PROMPTLY, as a request will be
;	made for the second byte almost IMMEDIATELY
;	this 'special' set of code differs on the
;	mod III only
;
WX1	LD	A,D		;get wait bit
	OUT	(FDCSEL),A	;set wait state
	IN	A,(FDCSTA)	;fetch status now
	AND	B		;check bits 0,1
	JP	PO,WX1		;only one set, wait!
	OUTI			;stuff the FDC
;
;	go into immediate wait states
;
WX2	LD	A,D		;get FDC w'wait' command
	OUT	(FDCSEL),A	;give it!
	IN	A,(FDCSTA)	;read the status
	AND	E		;bit 1 ready?
	JR	Z,WX2		;wait here if not
	OUTI			;send the byte
;
;	no more need to monitor the status lines
;	after 2 bytes have been successfully sent
;
	LD	A,D		;fetch command byte
WX3	OUT	(FDCSEL),A	;wait state!
	OUTI			;in sync, send the byte
	JP	WX3		;go till interrupted
	ENDIF
;iii*
;
;	$READTR - special 'read track' subroutine
;
READTR	LD	A,5		;5 tries to go
	LD	(RTRIES),A	;save it
;
READTRL	PUSH	BC		;save I/O buffer
	RES	7,(IY+5)	;set READ command
	CALL	TRREAD		;read track
	POP	BC		;restore address
	AND	0FFH		;check for errors
	RET	Z		;none, return
	EX	AF,AF'		;save error
	CALL	RESFDC		;reset the FDC
	LD	A,5		;get # attempts left
RTRIES	EQU	$-1
	DEC	A		;less this try
	LD	(RTRIES),A	;re-save it
	JR	NZ,READTRL	;go if more
	EX	AF,AF'		;get error back
	RET			;return in error
;
TRREAD	CALL	SELECT		;select drive
	RET	NZ		;error!
;
;i*
	IF	MODI
	LD	HL,FDCCMD	;FDC command reg
	LD	DE,FDCDAT	;FDC transfer reg
	DI			;disable interrupts
	LD	(HL),0E4H	;issue command
SYNC	EQU	$-1
	JP	RXFER		;go I/O transfer
	ENDIF
;i*
;m*
	IF	MAX80
	LD	HL,FDCCMD	;FDC command reg
	LD	DE,FDCDAT	;FDC data register
	DI			;disable for transfer
	LD	A,0E4H		;get command
SYNC	EQU	$-1
	CPL			;reverse bits
	LD	(HL),A		;issue command
	JP	RXFER		;transfer bytes
	ENDIF
;m*
;iii*
	IF	MODIII
	LD	D,(IY+3)	;get track
	CALL	SETNMI		;set for NMI return
;
	LD	A,0E0H		;get disk command
SYNC	EQU	$-1
	OUT	(FDCCMD),A	;issue to FDC
	CALL	DSKSLO		;wait for valid status
;
RXX1	IN	A,(FDCSTA)	;read FDC
	AND	E		;byte ready?
	JR	Z,RXX1		;wait for it!
	INI			;read it!
;
RXX2	IN	A,(FDCSTA)	;read FDC status
	AND	E		;byte ready?
	JR	Z,RXX2		;go if not
	INI			;read it!
;
	LD	A,D		;get wait state
RXX3	OUT	(FDCSEL),A	;go wait
	INI			;read the byte!
	JP	RXX3		;go more!
	ENDIF
;iii*
;
	PAGE
;
;	$ADDR	- read ID address marks from disk
;
;	ENT	(DRIVE) set for $SELECT
;		head positioned over correct track
;
;	EXT	Z = OK, HL => 6 byte buffer of ID marks
;		NZ = A = error status byte
;
;	DE and BC preserved
;
ADDR	PUSH	DE		;save 'em
	PUSH	BC
;
	LD	BC,INPUT	;input buffer
	PUSH	BC		;save for HL pop return
;i*
	IF	MODI
	LD	D,(IY+3)	;get current track
	CALL	SELDEN		;to set the density
	LD	HL,FDCCMD	;FDC command register
	JR	NZ,ADDRD	;error, return
	RES	7,(IY+5)	;operation is READ
	LD	DE,FDCDAT	;data transfer address
	DI			;disable interrupts
	LD	(HL),0C0H	;issue FDC command
	ENDIF
;i*
;m*
	IF	MAX80
	LD	D,(IY+3)	;get track
	CALL	SELDEN		;select density
	LD	HL,FDCCMD	;command register
	JR	NZ,ADDRD	;go if error
	RES	7,(IY+5)	;operation is READ
	LD	DE,FDCDAT	;fdc data register
	DI			;disable
	LD	A,0C4H.XOR.-1	;command
	LD	(HL),A		;to FDC
	ENDIF
;m*
;iii*
	IF	MODIII
	CALL	SELECT		;select the drive
	JR	NZ,ADDRD	;error, abort
;
	LD	D,(IY+3)	;get current track
	CALL	SETNMI		;setup density
	LD	A,0C0H		;read ID command
	OUT	(FDCCMD),A	;give to FDC
	ENDIF
;iii*
	CALL	RXFER		;transfer the bytes
	AND	0FFH		;mask unwanted bits
;
ADDRD	POP	HL		;HL => buffer
	POP	BC		;restore DE and BC
	POP	DE
	RET			;return, Z = OK
;
	PAGE
;
;	$MULT	- multiply subroutine
;
;	ENT	HL = multiplicand
;		C  = multiplier
;
;	EXT	AHL = result
;		Carry = overflow generated
;		Zero  = result = 0
;
MULT	PUSH	DE		;save from use
	LD	A,C		;get multiplier
	CALL	DMULT		;double precision mult
	LD	E,A		;save LSB
	LD	D,L		;MSB
	LD	A,H		;overflow byte
	EX	DE,HL		;put it back
	POP	DE		;restore DE
	OR	A		;any overflow?
	JR	Z,DIVD1		;get flags on HL
	SCF			;else set overflow
	RET			;return with flags
;
;	double precision multiply
;
DMULT	PUSH	BC		;save it
	EX	DE,HL		;DE = multiplicand
	LD	C,A		;C = multiplier
	LD	HL,0		;init result
	LD	A,L		;init overflow
	LD	B,8		;multiplier precision
;
DMULT1	ADD	HL,HL		;shift left result (*2)
	RLA			;catch overflow bits
	RLC	C		;odd number?
	JR	NC,DMULT2	;nope, continue
	ADD	HL,DE		;result + multiplicand
	ADC	A,0		;catch overflow
;
DMULT2	DJNZ	DMULT1		;go till precision
	LD	C,A		;C = MSB
	LD	A,L		;A = LSB
	LD	L,H		;L = NSB
	LD	H,C		;H = MSB
	POP	BC		;restore stack
	RET			;done!
;
;	$DIVD	- divide subroutine
;
;	ENT	HL = dividend
;		C  = divisor
;
;	EXT	HL = product
;		C  = remainder
;		Carry = divide by 0 (not attempted)
;		Zero  = result = 0
;
DIVD	LD	A,C		;get divisor
	OR	A		;zero?
	SCF			;carry = yes
	RET	Z		;return with result
;
	CALL	DDIVD		;double precision divide
	LD	C,A		;pass remainder
;
DIVD1	LD	A,H		;check for zero
	OR	L		;anything?
	LD	A,0		;return with zero
	RET			;back to caller
;
DDIVD	PUSH	DE		;save from use
	LD	D,A		;D = divisor
	LD	E,16		;precision to divide
	XOR	A		;0 least sig bits
;
DDIVD1	ADD	HL,HL		;shift dividend left
	RLA			;shift 8 lsb bits left
	JR	C,DDIVD2	;go if overflow
	CP	D		;at divisor?
	JR	C,DDIVD3	;go if not
;
DDIVD2	SUB	D		;remainder - divisor
	INC	L		;quotient +1
;
DDIVD3	DEC	E		;next
	JR	NZ,DDIVD1	;go till precision
	POP	DE		;restore stack
	RET			;done!
;
;	$TMULT - triple precision multiply
;
;	ENT	BHL = multiplicand
;		A   = multiplier
;
;	EXT	BHLA = result
;
TMULT	PUSH	IX		;save
	PUSH	BC		;save too
;
	LD	C,B		;BDE = multiplicand
	EX	DE,HL		;DE = multiplicand
	LD	HL,0		;init result MSB's
	LD	IX,0		;init result LSB's
	LD	B,8		;multiplier precision
;
TMULT1	ADD	IX,IX		;shift result left
	ADC	HL,HL		;shift result left
	RLCA			;1 bit?
	JR	NC,TMULT2	;go if not
	PUSH	BC		;save count
	ADD	IX,DE		;result + multiplicand
	LD	B,0		;BC = mult
	ADC	HL,BC		;result + multiplicand
	POP	BC		;restore it
;
TMULT2	DJNZ	TMULT1		;go till done
	PUSH	IX		;pass result
	POP	DE		;to DE (lsb's)
	LD	A,E		;A = result LSB
	POP	BC		;restore
	LD	B,H		;B = MSB
	LD	H,L		;H = NSB
	LD	L,D		;L = LSB
	POP	IX		;unstack
	RET			;done
;
;	$TDIVD - triple precision divide
;
;	ENT	BHL = dividend
;		A   = divisor
;
;	EXT	BHL = quotient
;		A   = remainder
;
TDIVD	PUSH	DE		;save it
	LD	D,A		;D = divisor
	LD	E,24		;precision
	XOR	A		;clear lsb bits
;
TDIVD1	ADD	HL,HL		;shift dividend left
	RL	B		;shift dividend left
	RLA			;shift left 8 low bits
	JR	C,TDIVD2	;go if overflow
	CP	D		;at divisor?
	JR	C,TDIVD3	;go if not
;
TDIVD2	SUB	D		;remainder - divisor
	INC	L		;quotient +1
;
TDIVD3	DEC	E		;next one
	JR	NZ,TDIVD1	;go till done
	POP	DE		;restore
	RET			;done
;
	PAGE
;
;	$INTFDC - immediate interrupt on FDC
;
INTFDC	LD	A,0D8H		;immediate interrupt
;i*
	IF	MODI
	LD	(FDCCMD),A	;FDC command reg I
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCCMD),A	;to fdc
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCCMD),A	;FDC III
	ENDIF
;iii*
;
;	$RESFDC - reset floppy disk controller from error
;
RESFDC	PUSH	AF		;save status byte
	LD	A,0D0H		;interrupt command
;i*
	IF	MODI
	LD	(FDCCMD),A	;FDC command I
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCCMD),A	;to fdc
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCCMD),A	;FDC command III
	ENDIF
;iii*
	POP	AF		;restore status byte
	RET			;FDC now reset
;
