; ptboot1s/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
	PAGE
;
;	this is the actual TANDY Mod I SD loader
;	TRSDOS Version 2.3sd - 01/29/80
;
$DIFS	EQU	4200H-$		;offset to actual load
$SECLS	EQU	00		;lowest sector on track
$SECHS	EQU	09		;highest sector
;
;	boot entry point 4200H
;
BOOT1S	NOP			;single 00H
	CP	11H		;3rd byte dir track
;
;	init stack / clear video
;
	DI			;disable interrupts
	LD	SP,41FCH	;re-init stack
	LD	HL,@1SMG1+$DIFS	;clear screen text
	CALL	@1SDSP+$DIFS	;clear video
;
;	select drive 0 for load
;
	LD	A,01H		;drive 0 select code
	LD	(37E1H),A	;select drive 0
;
;	read dir entry to locate SYS0/SYS
;
	LD	A,(4202H)	;fetch DIR track
	LD	D,A		;pass to D
	LD	E,04H		;sector for SYS0/SYS
	LD	BC,4D00H	;I/O buffer to use
	CALL	@1SREAD+$DIFS	;read the sector
	JR	NZ,@1SERR	;go if disk error
;
;	check if valid /SYS file
;
	LD	A,(4D00H)	;get first byte of sector
	AND	10H		;active entry?
	LD	HL,@1SMG2+$DIFS	;'no system'
	JR	Z,@1SERRD	;go error if 'dead' entry
;
;	fetch location of SYS0/SYS program code
;
	EXX			;swap registers
	LD	HL,(4D16H)	;get first extent pair
	LD	D,L		;pass track # to D
	LD	A,H		;get gran offset/# grans
	RLCA			;align high 3 bits to low
	RLCA
	RLCA
	AND	07H		;A=gran offset from tk st
	LD	H,A		;H = offset
	RLCA			;*2
	RLCA			;*4
	ADD	A,H		;*5
	LD	E,A		;E = gran start sector
	LD	BC,4DFFH	;init buffer pointer
	EXX			;save in alt registers
;
;	setup loop to load program into memory
;
@1SLOOP	CALL	@1SGETB+$DIFS	;fetch single byte
	DEC	A		;01 load block?
	JR	NZ,@1SLOP2	;go if not
;
;	load block
;
	CALL	@1SGETB+$DIFS	;fetch length byte
	LD	B,A		;pass length to B
	CALL	@1SGETB+$DIFS	;fetch LSB load address
	LD	L,A		;pass to L
	DEC	B		;less length byte
	CALL	@1SGETB+$DIFS	;fetch MSB load address
	LD	H,A		;pass to H
;
@1SLP1	DEC	B		;less length byte
	JR	Z,@1SLOOP	;go if nil block
	CALL	@1SGETB+$DIFS	;fetch data byte
	LD	(HL),A		;to buffer
	INC	HL		;bump buffer pointer
	JR	@1SLP1		;go for length of block
;
@1SLOP2	DEC	A		;02 entry point?
	JR	Z,@1SLOP3	;go if yes!
;
;	remark block, ignore it
;
	CALL	@1SGETB+$DIFS	;fetch length byte
	LD	B,A		;pass to B
;
@1SLP2	CALL	@1SGETB+$DIFS	;fetch remark byte
	DJNZ	@1SLP2		;go for remark length
	JR	@1SLOOP		;go next block
;
;	entry point block
;
@1SLOP3	CALL	@1SGETB+$DIFS	;get length byte & ignore
	CALL	@1SGETB+$DIFS	;get LSB entry point
	LD	L,A		;pass to L
	CALL	@1SGETB+$DIFS	;get MSB entry point
	LD	H,A		;pass to H
	JP	(HL)		;go SYS0/SYS !
;
;	fetch single byte from file
;
@1SGETB	EXX			;get alt register set
	INC	C		;bump buffer pointer
	JR	NZ,@1SINBF	;go if buffer has data
;
;	read new sector from disk if C=0
;
	PUSH	BC		;save buff pointer
	LD	A,01H		;drive 0 select code
	LD	(37E1H),A	;select drive 0 to load
	CALL	@1SREAD+$DIFS	;read the sector
	JR	NZ,@1SERR	;go if disk error
	POP	BC		;restore buff pointer
	INC	E		;bump sector #
	LD	A,E		;fetch for compare
	SUB	$SECHS+1	;less sector count
	JR	NZ,@1SINBF	;go if not beyond track
	LD	E,A		;set sector 0
	INC	D		;bump track #
;
@1SINBF	LD	A,(BC)		;fetch byte from I/O buff
	EXX			;swap registers back
	RET			;done, A = buff char
;
;	error vector
;
@1SERR	LD	HL,@1SMG3+$DIFS	;'disk error'
@1SERRD	CALL	@1SDSP+$DIFS	;display message
	CALL	0040H		;wait for <ENTER> key
	HALT			;re-boot!
;
;	display message
;
@1SDSP	PUSH	HL		;save string pointer
	LD	A,(HL)		;fetch display char
	CP	03H		;end of text?
	JR	Z,@1SDSPR	;yes, done!
	CALL	0033H		;display char
	INC	HL		;bump text pointer
	CP	0DH		;end of text?
	JR	NZ,@1SDSP+1	;continue if not
@1SDSPR	POP	HL		;restore pointer start
	RET			;done!
;
;	read disk sector
;
@1SREAD	PUSH	BC		;save buffer pointer
	CALL	@1SRED1+$DIFS	;attempt one try
	POP	HL		;HL = original buffer
	RET	Z		;go if no error
;
;	disk error, reset buffer pointer and try again
;
	LD	B,H		;reset buffer start
	LD	C,L
;
;	single attempt to read disk sector
;
@1SRED1	LD	(37EEH),DE	;select track/sector
	LD	HL,37ECH	;FDC mod I
	LD	(HL),1BH	;FDC 'seek' command
	PUSH	AF		;delay for valid status
	POP	AF
	PUSH	AF
	POP	AF
;
;	wait for FDC to signal seek completed
;
@1SSEEK	LD	A,(HL)		;read FDC status register
	RRCA			;busy bit set?
	JR	C,@1SSEEK	;wait till command done
;
	LD	(HL),88H	;issue FDC 'read' command
	PUSH	DE		;save track/sector
	LD	DE,37EFH	;FDC transfer register
	PUSH	BC		;delay for valid status
	POP	BC
	JR	@1SRD3		;go transfer!
;
@1SRD1	RRCA			;command completed?
	JR	NC,@1SRD4	;yes, go!
;
@1SRD2	LD	A,(HL)		;read FDC status register
	BIT	1,A		;byte ready?
	JR	Z,@1SRD1	;wait if not
;
	LD	A,(DE)		;fetch data from FDC
	LD	(BC),A		;to I/O buffer
	INC	BC		;bump buffer pointer
@1SRD3	JR	@1SRD2		;check if next byte ready
;
@1SRD4	LD	A,(HL)		;read resulting status
	AND	5CH		;check for any errors
	POP	DE		;restore track/sector
	RET	Z		;go if no error
	LD	(HL),0D0H	;issue FDC 'reset' cmd.
	RET			;return NZ error
;
;	message text
;
@1SMG1	DEFB	1CH		;home cursor
	DEFB	1FH		;clear screen
	DEFB	03H		;end of text
;
@1SMG2	DEFB	17H		;double wide video
	DEFB	0E8H		;tab
	DEFM	'NO SYSTEM'
	DEFB	0DH		;terminator C/R
;
@1SMG3	DEFB	17H		;double wide video
	DEFB	0E8H		;tab
	DEFM	'DISK ERROR'
	DEFB	0DH
;
;	extraneous chars!
;
	DEFB	0EBH
	DEFB	05FH
;
BOOT1SL	EQU	$-BOOT1S
;
