; ptboot1d/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
	PAGE
;
;	this is the actual TANDY Mod I DD loader
;	TRSDOS Version 2.8dd - 12/15/82
;
$DIFD	EQU	4200H-$		;offset to actual load
$SECLD	EQU	01		;lowest sector on track
$SECHD	EQU	18		;highest sector
;
;	boot entry point 4200H
;
BOOT1D	CP	11H		;directory track
;
;	select double density for load
;
	LD	A,81H		;double density select
	LD	(37EEH),A	;select DD board
;
;	clear video/display header text
;
	CALL	01C9H		;clear video screen
	LD	HL,3E0CH	;video cursor position
	LD	(4020H),HL	;set cursor row8/col12
	LD	HL,@1DMG2+$DIFD	;'loading TRSDOS'
	CALL	@1DDSP+$DIFD	;display message
;
;	setup for SYS0/SYS load / assume track 1/sector 1
;
	EXX			;swap registers
	LD	DE,1<8+1	;track 1/sector 1
	LD	BC,43FFH	;reset buffer pointer
	EXX			;swap back
;
;	setup loop to load SYS0/SYS program
;
@1DLOOP	CALL	@1DGETB+$DIFD	;fetch a single byte
	DEC	A		;01 load block?
	JR	NZ,@1DLOP2	;go if not
;
;	load block
;
	CALL	@1DGETB+$DIFD	;fetch length byte
	LD	B,A		;pass length byte
	CALL	@1DGETL+$DIFD	;get load address
	DEC	B		;less 2 byte load address
;
@1DLP1	DEC	B		;less byte counter
	JR	Z,@1DLOOP	;go next block if done
	CALL	@1DGETB+$DIFD	;get single byte
	LD	(HL),A		;to load address
	INC	HL		;bump buffer pointer
	JR	@1DLP1		;go next byte
;
@1DLOP2	DEC	A		;02 entry header?
	JR	Z,@1DLOP3	;go if yes
;
;	remark block
;
	CALL	@1DGETB+$DIFD	;get length byte
	LD	B,A		;pass to B for loop
;
@1DLP2	CALL	@1DGETB+$DIFD	;get remark byte
	DJNZ	@1DLP2		;go for remark length
	JR	@1DLOOP		;done, go next block
;
;	entry block
;
@1DLOP3	CALL	@1DGETB+$DIFD	;get length byte & ignore
	CALL	@1DGETL+$DIFD	;get load address
	JP	(HL)		;go SYS0/SYS!
;
;	fetch 2 byte load address from file
;
@1DGETL	CALL	@1DGETB+$DIFD	;get single byte
	LD	L,A		;pass LSB to L
	CALL	@1DGETB+$DIFD	;get single byte
	LD	H,A		;pass MSB to H
	RET			;done!
;
;	fetch single byte from file
;
@1DGETB	EXX			;get alt registers
	INC	C		;bump load address
	JR	NZ,@1DINBF	;byte in buffer, go!
;
;	read disk sector to fetch byte
;
	PUSH	BC		;save buffer address
	LD	A,01H		;select drive 0
	LD	(37E1H),A	;selected for load
	CALL	@1DREAD+$DIFD	;read disk sector!
	JR	NZ,@1DERR	;go if disk error!
	POP	BC		;restore load address
;
;	bump to next sector
;
	INC	E		;bump sector
	LD	A,E		;fetch for test
	SUB	$SECHD+1	;at track end?
	JR	NZ,@1DINBF	;nope, continue
	LD	E,$SECLD	;set lowest sector
	INC	D		;bump track
;
@1DINBF	LD	A,(BC)		;get byte from buffer
	EXX			;swap back
	RET			;done, A = next byte
;
;	disk error vector
;
@1DERR	LD	HL,@1DMG1+$DIFD	;'disk error'
	CALL	@1DDSP+$DIFD	;display message
	JR	$		;hold here till re-boot
;
;	display string to video
;
@1DDSP	PUSH	HL		;save text pointer
	LD	A,(HL)		;fetch string byte
	CP	03H		;end of text?
	JR	Z,@1DDSPR	;yes, done!
	CALL	0033H		;display character
	INC	HL		;bump text pointer
	CP	0DH		;end of text?
	JR	NZ,@1DDSP+1	;go if more
@1DDSPR	POP	HL		;restore text start
	RET			;done!
;
	DEFB	-1		;filler?
;
;	read sector from disk
;
@1DREAD	PUSH	BC		;save buffer address
	CALL	@1DRED1+$DIFD	;try to read once
	POP	HL		;restore buffer start
	RET	Z		;go if no error!
;
;	setup for second attempt
;
	LD	B,H		;re-init buffer
	LD	C,L		;to start address
;
;	single attempt to read disk sector
;
@1DRED1	DI			;disable for transfer
	LD	A,E		;get sector #
	LD	(37EEH),A	;to FDC sector register
	LD	A,D		;get track #
	LD	(37EFH),A	;to FDC track register
	LD	HL,37ECH	;point to FDC cmd/sta reg
	LD	(HL),1FH	;FDC 'seek' with verify
	EX	(SP),HL		;short delay to wait for
	EX	(SP),HL		;valid FDC status
	EX	(SP),HL
	EX	(SP),HL
;
;	wait for completion of seek command
;
@1DSEK	BIT	0,(HL)		;command in progress?
	JP	NZ,@1DSEK+$DIFD	;wait for completion
;
	LD	(HL),80H	;FDC 'read' command
	PUSH	DE		;save track/sector
	LD	DE,37EFH	;FDC transfer register
	EX	(SP),HL		;wait for valid status
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
;
@1DRD1	LD	A,(HL)		;read FDC status
	AND	03H		;busy/byte ready?
	JP	PO,@1DRD1+$DIFD	;wait for byte ready
;
@1DRD2	LD	A,(DE)		;fetch FDC data byte
	LD	(BC),A		;to I/O buffer
	INC	BC		;bump buffer pointer
;
@1DRD3	BIT	1,(HL)		;byte ready?
	JR	NZ,@1DRD2	;get if if yes
	BIT	1,(HL)		;ready now?
	JR	NZ,@1DRD2	;go if yes
	BIT	1,(HL)		;now?
	JR	NZ,@1DRD2	;go if yes
	BIT	7,(HL)		;motor still on?
	JR	NZ,@1DRD4	;nope! time out!
	BIT	0,(HL)		;still busy?
	JR	NZ,@1DRD3	;yes, keep checking ready
;
@1DRD4	LD	A,(HL)		;get resulting status
	AND	5CH		;check for errors
	POP	DE		;restore track/sector
	RET	Z		;go if no error
	LD	(HL),0D0H	;else 'reset' FDC error
	RET			;return NZ in error
;
;	message text
;
@1DMG1	DEFB	1DH		;cursor to line beginning
	DEFB	1EH		;clear to end of line
	DEFM	'Disk Error'
	DEFB	0DH		;terminator
;
@1DMG2	DEFB	17H		;double wide video
	DEFM	'Loading TRSDOS'
	DEFB	03H		;terminator
;
;	trsdos serial # 00000121582000040000
;
@1DSER	MACRO	#@1DA,#@1DB
	DEFB	#@1DA-'0'<4+#@1DB-'0'
	ENDM
;
	@1DSER	'0','0'
	@1DSER	'0','0'
	@1DSER	'0','1'
	@1DSER	'2','1'
	@1DSER	'5','8'
	@1DSER	'2','0'
	@1DSER	'0','0'
	@1DSER	'0','4'
;
	DEFW	0000H		;filler?
	DEFB	27H		;version # 2.7 (bcd)
	DEFB	35		;track count
;
BOOT1DL	EQU	$-BOOT1D	;boot length
;
