; ptzapa/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
; revised 04/21/83 - kjw/bqsd
;
	PAGE
;
;	$DISDSK - Zap - Display Disk Sectors
;
DISDSK	LD	HL,DISDSK1	;modify mode return vect.
	LD	(VECTOR1),HL	;save for UPDATE
	LD	HL,DISDSK0	;modify mode return
	LD	(VECTOR2),HL	;save for CANCEL
	LD	HL,DISCON1	;base change return
	LD	(VECTOR3),HL	;save for return
	LD	HL,BUFFER	;I/O buffer to use
	LD	(ADDRESS),HL	;save it
	CALL	GETDAT		;get drive, track, sector
;
	CALL	DSTAT		;check status
	JP	NZ,SUBMENU	;go if not ready
	BIT	4,(IY+5)	;detect on?
	CALL	NZ,DETECT	;auto DOS recognition
	JP	NZ,CANNOT	;cannot establish type!
	PUSH	DE		;save track/sector
	CALL	FIRSTS		;get first sector on trak
	LD	A,E		;get first sector
	POP	DE		;restore original
	OR	A		;first sector is 0?
	JR	Z,DISDSKY	;go if yes
	LD	A,E		;get requested sector
	OR	A		;on zero?
	JR	NZ,DISDSKY	;go if not
	INC	E		;reset to sector 1
;
DISDSKY	RST	@08		;clear screen
;
	DEFB	CLSA
	DEFB	ETX
;
DISDSKX	LD	(TEMP4),IY	;save DCT pointer
	LD	(SECTOR),DE	;save track/sector
	JR	DISDSK00	;read it!
;
;	write modified sector back & re-read
;
DISDSK1	LD	DE,(SECTOR)	;get track sector
	LD	BC,(ADDRESS)	;get buffer address
	LD	IY,(TEMP4)	;get DCT address
	CALL	INITBAD		;clear non-stop
	CALL	INITBD1		;enable error monitor
;
RT1	CALL	DSTAT		;check drive status
	JP	NZ,SUBMENU	;SKIP, abort!
;
;	check if 'funny disk' flag is on
;
	BIT	3,(IY+5)	;non-standard I/O?
	JR	NZ,WRFUN	;write funny too
;
	CALL	WRITE		;write normal
	JR	WRFUN+3		;continue
;
WRFUN	CALL	WRITENS		;write, no seek
;
	CALL	NZ,BADWRT	;error monitor if bad
	JR	NZ,RT1		;go if retry
;
DISDSK0	RST	@08		;clear screen
;
	DEFB	CLSA
	DEFB	ETX
;
DISDSK00 LD	DE,(SECTOR)	;get track/sector
	LD	IY,(TEMP4)	;get DCT
	LD	BC,(ADDRESS)	;ge5t 
	CALL	INITBD1		;enable $BADRD
;
;	due to the fact that this routine will allow
;	non-standard tracks/sectors to be read in,
;	when it is finished the track number in the
;	FDC register may not hold the correct contents
;	By simply setting (TASKDRV)=0, when the
;	routine has completed or BREAK has been pressed,
;	the DCT will be set to force SU+ to issue a
;	$RESTORE command on the next access.
;	This allows SU+ to correct the FDC track register
;	This is only performed if the # specifier
;	is issued to indicate non-standard sectors
;
	LD	A,(IY+3)	;fetch relative track
	LD	(TRUE),A	;save TRUE track
;
;	reset error condition flag for IBM prompt
;
DISKLP	XOR	A		;no error
	LD	(ZAPFLAG),A	;error type flag
;
;	check for normal read
;
	BIT	3,(IY+5)	;standard I/O?
	JR	Z,DKSRT		;yep, read it normal!
;
;	non-standard issued, force $RESTORE next
;	drive access
;
	LD	(IY+7),0	;set unknown DOS now
	XOR	A		;NOP opcode
	LD	(TASKDRV),A	;save it into the code
	LD	A,(TRUE)	;fetch TRUE track
	LD	(IY+3),A	;save into DCT
	LD	(RSECT),DE	;save relative sector
;
	CALL	SEEK		;seek the RELATIVE track
	JP	NZ,XBADRD	;error, go!
;
	LD	A,(IY+3)	;get REAL track
	LD	(TRUE),A	;new TRUE track
;
;	scan ID field on disk to establish track
;
GODSKLM	CALL	ADDR		;read ID marks
	JR	Z,GODSKLL	;OK, go!
;
	LD	DE,(RSECT)	;fetch rel sector
	BIT	4,A		;'not found' on ID read?
	CALL	NZ,FLIPDEN	;if yes, alter density
	CALL	ADDR		;try the other density
	JR	NZ,XBADRDX	;error, display it
;
;	ID read OK, fetch track from data read in
;
GODSKLL	LD	DE,(RSECT)	;get rel sector
	INC	HL		;bump to sector
	INC	HL		;HL => sector #
	LD	A,(HL)		;read it
	CP	E		;match?
	JR	NZ,GODSKLM	;go if not!
	DEC	HL		;back to track
	DEC	HL		;HL => track #
	LD	A,(HL)		;fetch track
;i*
	IF	MODI
	LD	(FDCTRK),A	;give to FDC track reg
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCTRK),A	;to track register
	CPL			;swap back
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCTRK),A	;FDC track reg III
	ENDIF
;iii*
	LD	D,A		;pass ID field track
	LD	(RSECT),DE	;update actual from ID
	CALL	INITBAD		;enable error monitor
;
DKSRT	LD	BC,(ADDRESS)	;memory buffer to use
	CALL	ZBUFF		;clear it to zeroes
;
;	check for normal read
;
	BIT	3,(IY+5)	;normal I/O?
	JR	Z,READNRM	;no, read it normal
;
	CALL	READNS		;read with NO seek
	JR	Z,ZAPO		;ok, go!
;
	BIT	4,A		;check NOT FOUND bit
	CALL	NZ,FLIPDEN	;reverse density if set
;
	CALL	READNS		;one more time
	JR	Z,ZAPO		;ok, go!
;
	BIT	4,A		;check not found again
	CALL	NZ,FLIPDEN	;reverse if set
;
	CALL	XREAD		;try NON-IBM read
	CALL	NZ,XREAD	;if error, flip again
	JR	Z,ZAPO		;if ok, go!
	JR	XBADRD		;else go error monitor
;
;	cannot read ID marks, track flawed!
;
XBADRDX	LD	A,(TRUE)	;fetch RELATIVE track
	LD	DE,(SECTOR)	;fetch REAL tk/sec
	RST	@18		;convert A to ascii
	LD	(XBDX1),A	;put into string
	LD	(XBDX1+1),BC	;rest of it
	RST	@08		;display text
;
	DEFB	CLSF		;clear screen
	DEFB	LF
	DEFM	'Track '
XBDX1	DEFM	'xxx FLAWED'
	DEFB	ETX
;
	LD	A,1		;notify error monitor
	LD	(ZAPFLAG),A	;set the flag
;
;	wait here for a key, flash a cursor
;
	LD	BC,20B0H	;on/off chars
	LD	A,12		;counter
	LD	HL,VIDEO	;where to flash
	CALL	FLICKS		;flicker and get key
	RST	@08		;clear screen
;
	DEFB	CLSA
	DEFB	ETX
;
	JR	DISHV		;interpret key!
;
;	attempt a normal read, two tries
;
READNRM	CALL	READ		;read with seek
	JR	Z,ZAPO		;go if ok!
;
;	sector read got an error
;
XBADRD	CALL	BDRDCLS		;clear screen, go monitor
	JP	NZ,DKSRT	;retry, try again
	JR	ZAPN		;error, but SKIP, display
;
;	read OK, clear error monitor flag
;
ZAPO	XOR	A		;zero it
	LD	(ZAPFLAG),A	;save the flag
	JR	DKOK		;continue
;
;	read NOT OK, set error monitor flag
;
ZAPN	LD	A,1		;set NON zero
	LD	(ZAPFLAG),A	;save the flag
;
;	error on I/O, reset read type byte
;
;i*
	IF	MODI
	LD	A,88H		;IBM read
	ENDIF
;i*
;iii/m*
	IF	MODIII.OR.MAX80
	LD	A,80H		;IBM read III/max
	ENDIF
;iii/m*
	LD	(RDTYPE),A	;save read type byte
;
	PAGE
;
DKOK	LD	DE,(SECTOR)	;fetch REAL trk/sect
;
DISCON	CALL	SHOW		;display HEX/ASCII data
;
DISCON1	CALL	SHOWLF		;display data source
;
;	wait here for an instruction key
;
DISWT	LD	A,12		;flash counter
	LD	BC,20B0H	;on/off bytes
	LD	HL,VIDEO	;where to flash
	CALL	FLICKS		;flicker and get key
;
;	put response on video, check for displayable
;
DISHV	PUSH	AF		;save the key
	CALL	UCASE		;make it upper case
	CP	SPACE		;displayable?
	JR	NC,DISHVXX	;yes, go!
	LD	A,8FH		;else make it graphic
DISHVXX	LD	(VIDEO),A	;to the video
	POP	AF		;restore original
;
;	check for digit 0-9 for direct paging
;
	CP	'0'		;compare
	JR	C,GOTTT		;nope, check table
	CP	'9'+1		;in range?
	JR	NC,GOTTT	;nope, go look in table
;
	SUB	'0'		;remove the ascii
	LD	E,A		;give it to E
	JP	DISDSKX		;resume!
;
;	not digit, check in table
;
GOTTT	EX	DE,HL		;HL = track sector
;
;	since CLEAR key is the same as the table
;	terminator, it must be checked separately
;
	CP	CLEAR		;clear key?
	JP	Z,NEWDTS	;new drive,track,sector
;
	LD	DE,DISTBL	;jump table
	CALL	GOTABL		;is it there?
;
;	nope, restore track/sector to DE and resume
;
BADISRT	EX	DE,HL		;DE = trk/sec again
	JR	DISWT		;get another key
;
DISTBL	DEFB	'R'
	DEFW	GOREST		;lowest sector on disk
	DEFB	'M'
	DEFW	MODIFY		;modify mode
	DEFB	'@'
	DEFW	DECODE		;decrypt mode
	DEFB	'H'
	DEFW	HEXIT		;hex modify
	DEFB	'A'
	DEFW	ASCIT		;ascii modify
	DEFB	'B'
	DEFW	BINIT		;binary modify
	DEFB	'D'
	DEFW	DECIT		;decimal modify
	DEFB	'O'
	DEFW	OCTIT		;octal modify
	DEFB	'Q'
	DEFW	OCTIT
	DEFB	UARR
	DEFW	TRKUP		;one track up
	DEFB	DARR
	DEFW	TRKDN		;one track down
	DEFB	LARR
	DEFW	SECDN		;dec sector
	DEFB	RARR
	DEFW	SECUP		;inc sector
	DEFB	SLARR
	DEFW	SECBOT		;lowest sector
	DEFB	SRARR
	DEFW	SECTOP		;highest sector
	DEFB	SDARR
	DEFW	TRKBOT		;lowest track
	DEFB	SUARR
	DEFW	TRKTOP		;highest track
	DEFB	','
	DEFW	BAKSEC		;back next readable sec
	DEFB	'.'
	DEFW	FORSEC		;forward next readable
	DEFB	'<'
	DEFW	BAKSEC		;back next readable
	DEFB	'>'
	DEFW	FORSEC		;forward next readable
	DEFB	'('
	DEFW	LOSEC		;lowest readable sector
	DEFB	')'
	DEFW	HISEC		;highest readable sector
	DEFB	'T'
	DEFW	NEWTS		;new track, sector
	DEFB	'S'
	DEFW	NEWS		;new sector
	DEFB	ETBL		;terminator
;
;	$NEWDTS - prompt for new drive, track, sector
;
NEWDTS	RST	@08		;clear screen
;
	DEFB	CLSF
	DEFB	ETX
;
	JP	DISDSK		;back to entry point!
;
;	$NEWS - prompt for new sector
;
NEWS	EX	DE,HL		;DE = track/sector
	RST	@08		;display prompt
;
	DEFB	CLSF		;clear screen
	DEFM	'Sector? '
	DEFB	ETX
;
	LD	B,30		;30 keys allowed input
	RST	@10		;fetch key input
	JR	Z,LSDIR		;re-fetch original
;
	CALL	POSHL		;any input?
	JR	Z,LSDIR		;nope, back to orig
;
	CALL	VALUE		;fetch the value
	JR	C,NEWS+1	;error, ask again
	LD	E,C		;pass value
	JP	DISDSKY		;read and display it
;
;	$NEWTS - prompt for new track and sector
;
NEWTS	EX	DE,HL		;DE = track/sector
	RST	@08		;display prompt
;
	DEFB	CLSF		;clear screen
	DEFM	'Track, Sector? '
	DEFB	ETX
;
	LD	B,30		;30 char key input
	RST	@10		;get key input!
;
	CALL	POSHL		;any input?
	JR	Z,LSDIR		;nope, go original!
;
	CALL	UCASE		;make it upper case
	CP	'D'		;directory?
	JR	Z,USDIR		;yes, use directory
;
	CP	DARR		;lowest track?
	JR	Z,BSDIR		;yes, go!
;
	CP	UARR		;highest track?
	JR	Z,TSDIR		;yes, go!
;
;	nothing special, prepare defaults
;
	LD	D,0		;track 0
	CALL	FIRSTS		;lowest sector to E
;
HERIO	CALL	VALUE		;get the value of input
	JR	C,NEWTS+1	;error, ask again
	LD	D,C		;pass value
;
NXDIR	CALL	POSHL		;any more?
	JP	Z,DISDSKY	;nope, go!
;
	CALL	VALUE		;get the value
	JR	C,NEWTS+1	;error, ask again
	LD	E,C		;load sector
	JP	DISDSKY		;restart, go!
;
LSDIR	LD	DE,(SECTOR)	;fetch original trk/sec
	JP	DISDSKY		;go!
;
TSDIR	LD	D,(IY+1)	;get relative track count
	DEC	D		;D = highest track
;
CSDIRZ	CALL	FIRSTS		;lowest sector on track
	INC	HL		;bump string for more inp
	JR	NXDIR		;get more data
;
BSDIR	LD	D,0		;set lowest track
	JR	CSDIRZ		;fetch lowest sector
;
USDIR	LD	D,(IY+2)	;get directory track
	JR	CSDIRZ		;load first sector
;
	PAGE
;
;	set modify mode number base
;
HEXIT	XOR	A		;HEX flag
	JR	ITCONT		;continue
;
DECIT	LD	A,1		;DECIMAL flag
	JR	ITCONT		;cont
;
BINIT	LD	A,2		;BINARY flag
	JR	ITCONT		;continue
;
OCTIT	LD	A,3		;OCTAL flag
	JR	ITCONT		;cont
;
ASCIT	LD	A,4		;ASCII flag
;
ITCONT	LD	(MODE),A	;save mode type
	EX	DE,HL		;DE = trk/sect
;
;	determine where to return to
;
	LD	HL,(VECTOR3)	;get return vector
	JP	(HL)		;return to it
;
;	fetch highest sector on a track
;
HISEC	LD	A,0DCH		;CALL C opcode
	JR	LOSEC+2		;go common
;
;	fetch lowest sector on a track
;
LOSEC	LD	A,0D4H		;CALL NC opcode
;
	LD	(HLPWAY),A	;put into code
	EX	DE,HL		;DE = track/sector
	LD	B,20		;make 20 attempts
;
LOSECL	CALL	ADDR		;read ID marks
	JP	NZ,DISKLP	;error, skip it
	INC	HL		;head
	INC	HL		;sector
	LD	A,E		;fetch current sector
	CP	(HL)		;compare to from disk
HLPWAY	CALL	C,GETE		;load new DE depending
	DJNZ	LOSECL		;any more tries left?
	JP	DISDSKX		;continue!
;
GETE	LD	E,(HL)		;load E with sector
	RET			;done
;
;	restore drive to track 0/ first sector
;
GOREST	LD	H,0		;track zero
	LD	A,(IY+6)	;get flag byte
	RRCA			;align bit 1 > 0
	AND	1		;get lowest sector
	LD	L,A		;HL = first sector
;
DISRET	EX	DE,HL		;load DE back correct
	JP	DISDSKX		;continue!
;
TRKUP	LD	A,H		;get track
	INC	A		;plus one
	CP	(IY+1)		;test to top track
	JP	Z,BADISRT	;if there, don't bump it
	INC	H		;else bump track
	JR	DISRET		;done!
;
TRKDN	LD	A,H		;on track 0?
	OR	A		;yes?
	JP	Z,BADISRT	;go if yes
	DEC	H		;else OK to decrement
	JR	DISRET		;resume!
;
TRKTOP	LD	H,(IY+1)	;relativ tracks
	DEC	H		;highest track
	JR	DISRET		;resume!
;
TRKBOT	LD	H,0		;lowest track
	JR	DISRET		;resume!
;
SECTOP	INC	L		;force bump sector
	JR	DISRET		;resume
;
SECBOT	DEC	L		;force decrement sector
	JR	DISRET		;resume!
;
SECUP	EX	DE,HL		;DE = track/sector
	CALL	NEXSEC		;advance logically
	EX	DE,HL		;put it back in HL
	JR	NC,DISRET	;not beyond disk
;
;	beyond disk, put it back like it was
;
SECDN	EX	DE,HL		;DE = sector
	CALL	RETSEC		;retard logically
	EX	DE,HL		;back into HL
	JR	DISRET		;resume!
;
;	going back a sector on a readable basis
;	use ID field as a 'readable' criterion
;
BAKLPG	LD	E,(HL)		;fetch resulting sector
	JP	DISDSKX		;resume!
;
;	back to next lower 'readable' sector
;
BAKSEC	LD	A,3DH		;DEC A opcode
	JR	BADFXR		;go common
;
;	forward to next 'readable' sector
;
FORSEC	LD	A,3CH		;INC A opcode
;
BADFXR	LD	(BAKLP3),A	;insert opcode
;
	EX	DE,HL		;DE = track/sector
	CALL	ADDR20		;read 20 ID fields
	JP	NZ,DISKLP	;error, abort it!
;
	LD	A,E		;fetch current sector
	JR	BAKLP3		;inc/decrement it
;
BAKLP1	LD	HL,DAMBUFF	;ID fields read in here
	LD	B,20		;20 of 'em
;
BAKLP2	CP	(HL)		;compare with the sector
	JR	Z,BAKLPG	;have next one available
	INC	HL		;bump table
	DJNZ	BAKLP2		;try all 20
;
;	this sector not found in ID batch
;	increment/decrement and search again
;
BAKLP3	DEC	A		;sector +1/-1
	CP	-1		;just past 0?
	JR	NZ,BAKLP1	;nope, continue!
	JP	DISKLP		;else abort, none lower
;
