; ptver2/asm - kjw/bqsd - 04/83
;
; revised 04/21/83 - kjw/bqsd
;
;	install serial # on diskette
;
INSTAL	LD	HL,REMDRIV	;error exit
	PUSH	HL		;to stack
	LD	(IY+8),0	;set single density
	LD	A,(IY+6)	;get binary drive #
	CALL	SETDRV		;set it up
	LD	A,LF		;send linefeed
	CALL	VOUT		;to video
	LD	DE,0200H	;track/dummy sect
	LD	(IY+0),D	;setup track
	CALL	SEEK		;move head to track
	RET	NZ		;go if error
	CALL	BUILD		;build the track image
	CALL	WRITETR		;format the track
	RET	NZ		;go on error
	POP	AF		;remove error vector
	XOR	A		;return Z
	RET			;to next drive
;
;	format track 1 for 80 track loader
;
FORM80	LD	HL,REMDRIV	;error exit
	PUSH	HL		;leave on stack
	LD	(IY+8),0	;set single density
	LD	A,(IY+6)	;get binary drive #
	CALL	SETDRV		;set it up
	LD	A,LF		;send linefeed
	CALL	VOUT		;to video
	LD	DE,0100H	;track/dummy sect
	LD	(IY+0),D	;save it
	CALL	SEEK		;seek track 1
	RET	NZ		;return if error
	CALL	BUILD		;build the track
	CALL	WRITETR		;format the track
	RET	NZ		;go if error
	POP	AF		;remove error vector
	XOR	A		;load zero
	RET			;return no error
;
;	format entire 35 track disk
;
FORMIT	LD	A,LF		;send linefeed to video
	CALL	VOUT		;display char
;
	LD	HL,REMDRIV	;error exit
	PUSH	HL		;save on stack
	XOR	A		;start track 0
	LD	(IY+0),A	;save it
	LD	(IY+8),A	;setup as single den
	LD	A,(IY+6)	;get binary drive
	CALL	SETDRV		;setup for single den
	CALL	RESTORE		;restore to track 0
	RET	NZ		;error!
;
FORMLP	LD	D,(IY+0)	;pass track to D
	LD	E,0		;dummy for sect register
	CALL	SEEK		;seek the track
	RET	NZ		;format error!
	CALL	BUILD		;create track
	CALL	WRITETR		;write the track
	RET	NZ		;go if error
	LD	A,(IY+0)	;get track
	INC	A		;+1
	LD	(IY+0),A	;update pointer
	CP	35		;at end?
	JR	C,FORMLP	;go till done
;
	POP	AF		;remove error vector
	XOR	A		;return Z
	RET			;done!
;
;	build format image in memory
;
BUILD	LD	C,(IY+0)	;get track
	SLA	C		;*2
	LD	B,0		;BC = offset in table
	LD	HL,TABLES	;start of table
	ADD	HL,BC		;HL = indirect address
	LD	E,(HL)		;get LSB
	INC	HL		;table +1
	LD	D,(HL)		;get MSB - DE => table
	EX	DE,HL		;HL => table
;
	PUSH	HL		;pass to IX
	POP	IX		;IX => length bytes
	INC	HL		;bump past length
	INC	HL		;HL => sector data
	LD	DE,BUFFER	;DE => I/O buffer
;
;	create each sector image in memory
;
SECLP	LD	A,(HL)		;get a bytre
	INC	A		;FF terminator?
	RET	Z		;yes, done!
	INC	A		;FE special ID?
	JR	Z,SECSPEC	;yes, go!
	CALL	MOVE		;fill
	JR	SECLP		;go till done
;
SECSPEC	PUSH	HL		;save table entry
	LD	HL,NAME		;name ID
	LD	BC,NAMEL	;name length
	LDIR			;move in the name
	EX	DE,HL		;HL => buffer
	CALL	TOSERL		;get serial #
	EX	DE,HL		;DE => buffer
	LD	BC,16<8+00	;B=counter, C=checksum
CORSER	LD	A,(HL)		;get serial # byte
	PUSH	AF		;save original
	NEG			;reverse it
	ADD	A,C		;add to checksum
	LD	C,A		;update checksum
	POP	AF		;get original
	XOR	'$'		;decrypt it
	LD	(DE),A		;to buffer
	INC	HL		;bump source
	INC	DE		;bump dest
	DJNZ	CORSER		;finish serial # correct
	LD	A,C		;get checksum
	CALL	PUTCOR		;put correct checksum
	LD	A,C		;get again
	RRCA			;align high bits to low
	RRCA
	RRCA
	RRCA
	CALL	PUTCOR		;put checksum
	POP	HL		;restore HL
	INC	HL		;bump past entry
	INC	HL		;2 bytes
	LD	A,0DDH		;fill byte
	LD	B,256-NAMEL-18	;length remaining
	CALL	FILL		;fill remainder
	JR	SECLP		;continue
;
;	insert correct on serial # checksum
;
PUTCOR	AND	0FH		;keep low 4 bits only
	XOR	'#'		;decrypt it
	LD	(DE),A		;to buffer
	INC	DE		;bump buffer
	RET			;done!
;
;	move bytes to buffer
;
MOVE	LD	B,(HL)		;get byte count
	INC	HL		;bump table
	LD	A,(HL)		;get fill byte
	INC	HL		;bump table
;
FILL	LD	(DE),A		;char to buffer
	INC	DE		;bump buffer pointer
	DJNZ	FILL		;go till done
	RET			;buffer filled
;
;	read sector for verify
;
READV	EXX			;save
	LD	HL,SREAD	;read with seek
	JR	READNCM		;go common
;
;	read sector with no seek
;
READNS	EXX			;save
	LD	HL,NREAD	;no seek read
READNCM	LD	BC,SHOWVE	;display routine
	JR	READCM		;go common
;
;	read sector
;
READ	EXX			;save
	LD	HL,SREAD	;sector read
	LD	BC,SHOWRD	;display routine
READCM	LD	DE,0A2EDH	;INI opcode reversed
	RES	7,(IY+9)	;set read
	JR	RWCOMM		;go common
;
;	write sector with no seek
;
WRITENS	EXX			;save
	LD	HL,NWRITE	;write no seek
	JR	WRTCM		;go write common
;
;	write sector
;
WRITE	EXX			;save
	LD	HL,SWRITE	;sector write
WRTCM	LD	BC,SHOWWR	;display driver
	JR	WRTRCM		;go common
;
;	write track
;
WRITETR	LD	HL,BUFFER	;I/O buffer
	LD	D,(IY+0)	;get track
	EXX			;save
	LD	HL,TRWRITE	;I/O section
	LD	BC,SHOWRTR	;display routine
WRTRCM	LD	DE,0A3EDH	;OUTI opcode
	SET	7,(IY+9)	;set WRITE
;
RWCOMM	LD	A,(IY+2)	;get # retries
	LD	(IY+3),A	;init this loop
	LD	(RWCALL),HL	;pass call vector
	LD	(RWDIR),DE	;INI/OUTI opcodes
	LD	(RWDIR2),DE	;here also
	LD	(SHOWVEC),BC	;save display vector
	LD	BC,0000H	;NOP NOP
	BIT	7,(IY+9)	;READ?
	JR	Z,RWNOP		;yes, continue
	LD	BC,0FE10H	;DJNZ $  opcodes
RWNOP	LD	(RWTNOP),BC	;save into code
	EXX			;restore
	LD	(IY+0),D	;save track
	CALL	$		;display
SHOWVEC	EQU	$-2
;
WRITLP	PUSH	HL		;save buffer
	PUSH	DE		;save sector
	CALL	$		;read/write/format
RWCALL	EQU	$-2
	POP	DE		;restore table
	POP	HL		;unstack buffer
;
	RET	Z		;done, return
	EX	AF,AF'		;save error
	DEC	(IY+3)		;any more?
	JR	NZ,WRITLP	;go if yes
	EX	AF,AF'		;get NZ back
	RET			;return in error
;
TRWRITE	LD	(SPSAVE),SP	;save current stack
	CALL	SETNMI		;setup for NMI exit
	INC	E		;set mask = 3
	LD	A,0F0H		;write track command
	CALL	DSKSLO		;short delay
;
TRW1	IN	A,(0F0H)	;read FDC status
	AND	E		;check if ready
	JP	PO,TRW1		;go if not
	OUTI			;send byte
	DEC	E		;set mask = 2
;
TRW2	IN	A,(0F0H)	;read FDC status
	AND	E		;check if ready
	JR	Z,TRW2		;go if not
	OUTI			;to FDC
;
	LD	B,D		;pass select code
	LD	E,(IX+0)	;get lsb length
	LD	D,(IX+1)	;get msb length
;
TRW4	LD	A,B		;get select command
	OUT	(0F4H),A	;set wait states
	OUTI			;go for it
	LD	B,A		;pass back from OUTI
	DEC	DE		;less this byte
	LD	A,D		;any more?
	OR	E		;any bits on?
	JR	NZ,TRW4		;go if not
;
	LD	A,B		;get command
	OR	80H		;set double density
TRW5	OUT	(0F4H),A	;to FDC
	OUTI			;write byte
	JR	TRW5		;go till interrupt
;
;	sector read I/O
;
SREAD	LD	A,80H		;FDC read command
	JR	SRDWTCM		;go common
;
;	sector read with no seek
;
NREAD	CALL	SELECT		;select drive
	RET	NZ		;dropped ready!
	CALL	SEEK		;seek track D
	RET	NZ		;return if error
	LD	A,E		;get sector
	OUT	(0F1H),A	;to track register
	LD	A,80H		;read command
	EX	AF,AF'		;pass it here
	JR	WRITRES		;resume with command
;
;	sector write with no seek
;
NWRITE	CALL	SELECT		;select drive
	RET	NZ		;error!
	CALL	SEEK		;seek track D
	RET	NZ		;return if error
	LD	A,E		;get sector
	OUT	(0F1H),A	;give to track register
	LD	A,0A0H		;sector write command
	EX	AF,AF'		;pass it here
	JR	WRITRES		;resume with command
;
;	sector write I/O
;
SWRITE	LD	A,0A0H		;sector write
;
SRDWTCM	EX	AF,AF'		;save command
	CALL	SELECT		;select drive
	RET	NZ		;not ready
	CALL	SEEK		;seek track
	RET	NZ		;error
WRITRES	LD	(SPSAVE),SP	;save stack pointer
	CALL	SETNMI		;setup for NMI return
	EX	AF,AF'		;get command back
	CALL	DSKSLO		;short delay for status
;
SRW1	IN	A,(0F0H)	;read status
	AND	E		;byte ready?
	JR	Z,SRW1		;wait if not
RWDIR	DEFW	0000H		;OUTI / INI
	LD	B,60H		;delay here
RWTNOP	DJNZ	$		;before second byte
	LD	A,D		;get wait command
SWR2	OUT	(0F4H),A	;go wait states
RWDIR2	DEFW	0000H		;OUTI / INI
	JR	SWR2		;go till done!
;
;	select drive
;
SELECT	IN	A,(0F0H)	;read status
	AND	80H		;check if motor on
	LD	A,(IY+5)	;get select code
	OUT	(0F4H),A	;select drive
	RET	Z		;drive already on
;
	PUSH	BC		;save BC
	LD	BC,0000H	;delay before access
	CALL	60H		;call ROM sub
	POP	BC		;restore
;
;	check for ready now!
;
	JR	SELECT		;re-select drive
;
;	seek head to desired track in D register
;
SEEK	CALL	SELECT		;select drive
	RET	NZ		;return in error
	CALL	GETTRK		;get current track
	OUT	(0F1H),A	;to FDC track reg
	OR	A		;on track 0?
	JR	NZ,SEEKOK	;nope, continue
	CALL	RESTORE		;restore drive
	JR	NZ,SEEKER	;error, abort
;
SEEKOK	CALL	SELECT		;reselect drive
	JR	NZ,SEEKER	;dropped ready
	LD	A,D		;get desired track
	OUT	(0F3H),A	;to FDC register
	LD	A,E		;get desired sector
	OUT	(0F2H),A	;to FDC sector reg
	LD	A,18H		;seek
	OR	(IY+7)		;combine with step rate
	CALL	DSKSLO		;wait for valid status
;
SEEKWT	CALL	SELECT		;re-select drive
	JR	NZ,SEEKER	;dropped ready!
	IN	A,(0F0H)	;read FDC status reg
	BIT	0,A		;command in progress?
	JR	NZ,SEEKWT	;wait if not done
;
	AND	98H		;any errors?
	PUSH	AF		;save on stack
	IN	A,(0F1H)	;read track register
	JR	SEEKPT		;continue
;
SEEKER	PUSH	AF		;save error
	XOR	A		;force $restore next time
;
SEEKPT	CALL	PUTTRK		;load track into table
	POP	AF		;restore Z flag
	RET	Z		;return if no error
DSKERR	PUSH	AF		;save it
	LD	A,0D0H		;clear FDC
	OUT	(0F0H),A	;issue it
	POP	AF		;restore error code
	RET
;
;	restore drive to track 0
;
RESTORE	CALL	SELECT		;select drive
	RET	NZ		;return in error
	LD	A,08H		;restore command
	OR	(IY+7)		;combine with step rate
	CALL	DSKSLO		;wait for valid status
;
RESWT	IN	A,(0F0H)	;read status
	BIT	0,A		;command in progress?
	JR	NZ,RESWT	;wait if yes
	CPL			;reverse bits
	AND	4		;check for bit 2
	JR	Z,SEEKER	;go if no error
	LD	A,80H		;load not available
	JR	SEEKER		;load 0 to table
;
;	short wait for FDC to place valid status
;
DSKSLO	OUT	(0F0H),A	;issue FDC command
	LD	A,13		;delay count
DSKSLO1	DEC	A		;less count
	JR	NZ,DSKSLO1	;wait for count
	RET			;else OK to continue
;
;	setup drive for I/O
;
SETDRV	AND	3		;0-3 only
	LD	(IY+6),A	;save binary drive
	PUSH	BC		;save
	LD	B,1		;bit mask for drive
	JR	Z,SETHAV	;have it, go!
SETDRL	SLA	B		;align bit mask
	DEC	A		;go again
	JR	NZ,SETDRL	;go till found
SETHAV	LD	A,(IY+8)	;get density
	AND	80H		;assure bit 7 only
	OR	B		;merge with select code
	LD	(IY+5),A	;save as select code
	POP	BC		;restore BC
	RET			;done
;
;	setup NMI for activity
;
SETNMI	IN	A,(0F0H)	;clear FDCint
	LD	BC,RETNMI	;nmi return vector
	LD	(404AH),BC	;set fixed address
	LD	A,0C3H		;JP opcode
	LD	(4049H),A	;set into vector
;
	LD	BC,00F3H	;counter, I/O port
	LD	D,(IY+5)	;get select code
	LD	A,(IY+0)	;get current track
	CP	23		;< 23?
	LD	A,0		;zero mask
	JR	C,NOTG23	;not, go!
	LD	A,20H		;pre-comp mask
NOTG23	OR	D		;merge with select
	OUT	(0F4H),A	;select drive
	OR	40H		;set wait bit
	LD	D,A		;pass it
	LD	E,2		;set bit 1 for test
	DI			;disable for xfer
	LD	A,0C0H		;enable NMI
	OUT	(0E4H),A	;enabled!
	RET			;done, return
;
;	return from NMI vector
;
RETNMI	XOR	A		;load zero
	OUT	(0E4H),A	;disable any more NMI's
	LD	HL,NMIRET	;non-disk NMI's
	LD	(404AH),HL	;save fixed address
	IN	A,(0F0H)	;read status
	PUSH	AF		;save status
	LD	A,0D0H		;reset FDC
	OUT	(0F0H),A	;assure terminated cmd
	POP	AF		;restore status
NMICOMM	OR	A		;check for errors
	LD	SP,$		;reset stack
SPSAVE	EQU	$-2
	EI			;can enable now
	RET			;return with status
;
ERRNMI	XOR	A		;load zero
	OUT	(0E4H),A	;disable NMI
	LD	HL,NMIRET	;non-disk vector
	LD	(404AH),HL	;set vector
	LD	A,0D8H		;immediate interrupt
	OUT	(0F0H),A	;to FDC
	LD	A,0D0H		;reset FDC
	OUT	(0F0H),A	;to FDC
	LD	A,80H		;set error code
	JR	NMICOMM		;go common
;
NMIRET	RETN			;non-disk
;
;	load/save track into table
;
GETTRK	OR	A		;clear carry flag
	JR	GETPUT		;go common
;
PUTTRK	SCF			;set carry flag
;
GETPUT	PUSH	HL		;save it
	PUSH	AF		;save flags
	LD	HL,CTRACK	;current track table
	CALL	POINT		;point to it
	POP	AF		;restore flags
	JR	C,PUTIN		;go if store
	LD	A,(HL)		;fetch from table
PUTIN	LD	(HL),A		;install in table
	POP	HL		;restore
	RET			;done
;
;	point to table entry for current drive
;
POINT	LD	A,(IY+6)	;get binary drive #
	ADD	A,L		;add offset
	LD	L,A		;update
	RET	NC		;did not cross page
	INC	H		;bump MSB
	RET			;done!
;
;	locate serial # current
;
TOSERL	LD	A,(IY+6)	;get current drive
	AND	7		;force in range
	PUSH	HL		;save HL
	ADD	A,A		;*2
	LD	E,A		;pass to E
	LD	D,0		;DE = offset
	LD	HL,SERNOS	;serial # table
	ADD	HL,DE		;HL => entry
	LD	E,(HL)		;get LSB
	INC	HL		;bump table
	LD	D,(HL)		;get MSB
	POP	HL		;restore
	RET			;done!
;
;	check out disk drive for ready
;
STAT	CALL	SELECT		;select drive
	LD	A,0D8H		;immediate interrupt
	OUT	(0F0H),A	;issue to FDC
	LD	A,0D0H		;reset FDC
	OUT	(0F0H),A	;to FDC
	CALL	SELECT		;re-select drive
	RET	NZ		;error!
;
	LD	BC,4000H	;max delay
STAT1	CALL	STAT0		;get status
	JR	NZ,STAT1	;wait for no hole
;
STAT2	CALL	STAT0		;get status
	JR	Z,STAT2		;wait for hole
;
STAT3	CALL	STAT0		;get status
	JR	NZ,STAT3	;wait for no hole
	RET			;return, drive OK
;
STAT0	DEC	BC		;less counter
	LD	A,B		;any bits?
	OR	C		;yes?
	JR	Z,STAT4		;go if error!
	IN	A,(0F0H)	;read status
	AND	2		;check for index hole
	RET			;return for check
;
STAT4	POP	BC		;dummy pop BC
	LD	A,0D0H		;clear/reset FDC
	OUT	(0F0H),A
	LD	A,01H		;return not ready
	OR	A		;return NZ
	RET			;back to caller
;
