; ptsub3/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
; revised 04/25/83 - kjw/bqsd
;
	PAGE
;
;	$EXIT	- exit program
;
;	ENT	none
;
;	EXT	exit made to bootstrap in ROM
;
;	NOTE	user is prompted to mount a system
;		system disk and press enter
;
EXIT	XOR	A		;setup BREAK to menu
	CALL	SETUPS		;set it up
;
	CALL	SETDRV		;setup for drive 0
	CALL	MNTSYS		;mount system disk
;
;	on a mod I, do not jump to 0000 while the
;	disk drive is turning or a the ROM will not
;	detect the correct drive status
;
;i*
	IF	MODI
FDCWAIT	LD	A,(FDCSTA)	;get FDC status byte
	RLCA			;check bit 7
	JR	NC,FDCWAIT	;wait for motor to go off
	ENDIF
;i*
	CALL	SPDOFF		;high speed clock OFF
;
;	disable serial number checksum byte
;	if program is re-entered, the interrupt
;	routine will clear out the program
;
	XOR	A		;load zero
	DI			;must disable !!
	LD	I,A		;clear checksum
;i*
	IF	MODI
	HALT			;boot Mod I
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,(VLATCH)	;get system functions
	AND	0F8H		;enable ROM
	DI			;disable
	LD	(VLATCH),A	;rom enabled!
	RST	@00		;go boot-rom!
	ENDIF
;m*
;iii*
	IF	MODIII
	RST	@00		;boot Mod III
	ENDIF
;iii*
	JR	$		;fail trap!
;
	PAGE
;
;	$MNTSRC	- prompt for source disk mount
;	$MNTDES	- prompt for dest disk mount
;	$MNTSYS	- prompt for system disk mount
;
;	ENT	none
;
;	EXT	A = char pressed during mount prompt
;
MNTSRC	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Mount SOURCE'
	DEFB	ETX
;
	JR	MOCOMM		;go common
;
MNTDES	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Mount DESTINATION'
	DEFB	ETX
;
	JR	MOCOMM		;go common
;
MNTSYS	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Mount SYSTEM'
	DEFB	ETX
;
MOCOMM	CALL	DRVASC		;fetch ascii drive #
	LD	(WDVV),A	;put into the string
	RST	@08		;display following
;
	DEFM	' Disk on Drive '
WDVV	DEFM	'x:'
	DEFB	ETX
;
	PAGE
;
;	$ONEKEY	- fetch a key from keyboard
;
;	ENT	NONE
;
;	EXT	A = char pressed
;		current display line is erased
;
ONEKEY	PUSH	HL		;save 'em
	PUSH	BC
;
	LD	B,1		;one key to input
	RST	@10		;fetch from keyboard
;
	RST	@08		;display following
;
	DEFB	EOL		;clear the line
	DEFB	ETX		;term
;
	POP	BC		;unstack 'em
	POP	HL
	RET			;done, return
;
	PAGE
;
;	$DRVCOMM - execute subroutine multiple drives
;
;	ENT	DE = subroutine address for active drives
;		BC = return vector when completed
;
;	EXT	to (BC) when all drives completed
;
;	NOTE	a drive is indicated as being active
;		in this command if bit 5 of DCT+5
;		is set
;	NOTE	HL is preserved to all subroutines
;		IY points to the current drive DCT
;
DRVCOMM	XOR	A		;set current drive to 0
	LD	(RETN1),DE	;subroutine address
	LD	(RETN2),BC	;return vector
;
DRVLP	LD	(POSA),A	;save current drive
	CALL	SETDRV		;setup for disk activity
;
	BIT	5,(IY+5)	;drive enabled?
	CALL	NZ,0		;call subroutine if yes
RETN1	EQU	$-2
;
	PUSH	BC		;save it
	LD	BC,(DRIVES)	;C = # drives
	LD	A,(POSA)	;fetch current drive
	INC	A		;bump it
	CP	C		;test for max
	POP	BC		;unstack BC
	JR	C,DRVLP		;more to do, go!
;
	JP	0		;else return to caller
RETN2	EQU	$-2
;
	PAGE
;
;	$INITDRV - activate all drives
;	$INITDVO - deactivate all drives
;
;	ENT	none
;
;	EXT	all drives set as active/inactive by
;		setting/resetting bit 3 of DCT+5
;
;	NOTE	this is the normal setup for a call
;		being made to $DRVCOMM
;
INITDVO	PUSH	AF		;save AF
	LD	A,20H		;mask for bit 5 ON
	JR	INITDV		;go common
;
INITDRV	PUSH	AF		;save it
	XOR	A		;mask for bit 5 OFF
;
INITDV	PUSH	BC		;save from use
	PUSH	DE		;save it
	PUSH	IY		;save too
	LD	BC,(DRIVES)	;C = # drives
	LD	B,A		;give mask to B
	XOR	A		;drive 0
	LD	E,A		;save it here
;
INITLP	CALL	SETDRV		;locate the DCT
	LD	A,(IY+5)	;get mask
	AND	0DFH		;all but bit 5
	OR	B		;merge with mask
	LD	(IY+5),A	;put back into DCT
;
	INC	E		;bump drive
	LD	A,E		;fetch it
	CP	C		;0-(drives)?
	JR	C,INITLP	;do more
;
	POP	IY		;unstack
	POP	DE
	POP	BC
	POP	AF
	RET			;done, return
;
	PAGE
;
;	$ZBUFF	- clear out memory buffer
;
;	ENT	BC => 256 byte buffer
;
;	EXT	buffer filled with zeroes
;		all registers preserved
;
ZBUFF	PUSH	HL		;save 'em
	PUSH	DE
	PUSH	BC
;
	LD	H,B		;give buffer to HL
	LD	L,C
;
	LD	D,H		;and to DE
	LD	E,L
	INC	DE		;start +1
;
	LD	BC,255		;length -1
	LD	(HL),0		;put a zero
	LDIR			;put all zeroes
;
	POP	BC		;unstack & return
	POP	DE
	POP	HL
	RET
;
	PAGE
;
;	$UCASE - convert character to upper case
;
;	ENT	A = character
;
;	EXT	A = character in upper case
;
UCASE	CP	'a'		;already upper?
	RET	C		;yes, don't change it
;
	CP	'z'+1		;non alpha?
	RET	NC		;yes, skip it
;
	AND	5FH		;make it upper case
	RET			;done, return
;
	PAGE
;
;	$FIGDRV	- evaluate user drive specifiers
;
;	ENT	HL => drive specifications
;
;	EXT	C = invalid characters found
;		NC = OK, drive set for I/O activity
;		IY => drives DCT
;		HL => next char after drive specifiers
;
FIGDRV	LD	A,(HL)		;get a character
;
	SUB	'0'		;remove ascii
	RET	C		;error, return
	PUSH	BC		;save
	LD	BC,(DRIVES)	;C = # drives
	CP	C		;compare for valid
	POP	BC		;restore
	CCF			;reverse carry flag
	RET	C		;error, return
;
	CALL	SETDRV		;setup drive for activity
	INC	HL		;bump pointer
;
	LD	A,(HL)		;get next char
	CALL	CKSEP		;done?
	SCF			;clear carry
	CCF
	RET	Z		;done if yes
;
	CP	'='		;track count?
	JR	Z,CKTKS		;go if yes
	CALL	CKCONF		;check for valid type
	RET	C		;nope, error
;
	LD	A,(HL)		;get next char
	CALL	CKSEP		;separator?
	SCF
	CCF			;turn off carry
	RET	Z		;yes, done!
;
	CP	'='		;track specifier
	SCF			;error if not
	RET	NZ		;error!
;
CKTKS	PUSH	BC		;save it
	INC	HL		;bump past =
	CALL	VALUE		;get track value
	LD	A,C		;get it
	POP	BC		;restore
	RET	C		;error, return
	OR	A		;zero?
	SCF			;set error
	RET	Z		;cannot have 0 tracks!
	CP	2		;less than 2?
	RET	C		;yes, invalid
	CP	97		;1-96?
	CCF			;reverse carry
	RET	C		;out of range!
;
	LD	(IY+0),A	;real track count
	CALL	RELTKS		;compute relative tracks
;
	XOR	A		;set OK
	RET			;back to caller
;
	PAGE
;
;	$TASKDRV - force $RESTORE next drive access
;
;	ENT	none
;
;	EXT	last drive accessed will be forced
;		to issue a $RESTORE next access
;
;	NOTE	this service is in case the BREAK key
;		if pressed during a $SEEK or $STEPIN
;		operation whereby the current track
;		table will not reflect the actual track
;		where the head landed, thus future
;		seek operations would be incorrect.
;		this routine will force a zero into the
;		current track table thus forcing the
;		$SEEK operation to $RESTORE the drive
;		before it is accessed next time
;
TASKDRV	NOP			;can be intercepted
	LD	A,0C9H		;RET opcode
	LD	(TASKDRV),A	;only allow one pass
;
	LD	A,(DRIV)	;get current drive
	CALL	SETDRV		;locate the DCT
	LD	(IY+3),0	;current track to zero
	RET			;done
;
	PAGE
;
;	$TURNSPD - activate/deactivate high speed clock
;
;	ENT	none
;
;	EXT	clock turned on or off
;
TURNSPD	LD	A,(FLAGA)	;get system flag
	BIT	6,A		;high speed on?
	JR	NZ,SPDON	;yes, turn it on
;
SPDOFF	LD	A,0		;user instructions!
	OUT	(0FEH),A
	NOP
	NOP
	NOP
	NOP
	RET
;
SPDON	LD	A,1		;user configurable!
	OUT	(0FEH),A
	NOP
	NOP
	NOP
	NOP
	RET
;
;	$CKSEP	- check for separator/terminator
;
;	ENT	A = char to check
;
;	EXT	C = terminator (13)
;		Z = separator (space,comma)
;		NZ = none
;
CKSEP	CP	CR		;terminator?
	SCF			;carry = yes
	RET	Z		;yes, return
;
	CP	BLANK		;separator?
	RET	Z		;Z = yes
	CP	COMMA		;sep?
	RET			;Z = yes
;
	PAGE
;
;	$CKCONF - check for valid dos specifier
;
;	ENT	A = specifer to check
;
;	EXT	C = invalid
;		NC = OK, DCT adjusted accordingly
;
;	valid dos specifiers
;
;	U = Undefinded
;	T = Trsdos
;	L = Ldos
;	D = Dosplus
;	M = Multidos
;	N = Newdos
;	B = Doubledos
;	X = user defined
;
CKCONF	PUSH	DE		;save track/sector
	RES	2,(IY+5)	;set 5" drive
	LD	A,(ALLFLAG)	;get type flag
	OR	A		;TRSDOS/LDOS only?
	LD	DE,CONTBL	;config table
	JR	NZ,$+5		;go if all
	LD	DE,CONTBLP	;else only TRS/LDOS
	LD	A,(HL)		;fetch string char
	CALL	GOTABL		;see if valid char
;
CONRET	POP	DE		;unstack track/sect
	SCF			;invalid entry
	RET			;go if invalid
;
CONTBL	DEFB	'D'		;dosplus
	DEFW	SETD
	DEFB	'M'		;multidos
	DEFW	SETM
	DEFB	'N'		;newdos
	DEFW	SETN
	DEFB	'B'		;doubledos
	DEFW	SETB
	DEFB	'X'		;extra
	DEFW	SETX
	DEFB	27H
	DEFW	CKDSIE
	DEFB	'"'
	DEFW	CKDSIE
	DEFB	'U'		;undefined
	DEFW	SETU		;vector
;
CONTBLP	DEFB	'T'		;trsdos
	DEFW	SETT
	DEFB	'L'		;ldos
	DEFW	SETL
	DEFB	ETBL		;end of table
;
SETU	CALL	CKSET		;fetch density/model
	LD	DE,$U		;table
	JP	SETCON		;setup config
;
SETT	CALL	CKSET		;fetch density/model
	CP	6		;single mod 3?
	JP	Z,CONRET	;invalid!
	LD	DE,$T1D		;double den 1
	CP	09H		;T1D?
	JP	Z,SETCON	;go if yes
	LD	DE,$T3		;double den 3
	AND	5		;yes?
	JP	NZ,SETCON	;go if yes
	LD	DE,$T		;single den 1
	JP	SETCON		;continue
;
SETL	CALL	CKSET		;density/model
	LD	DE,$L1D		;double mod I
	CP	09H		;yes?
	JP	Z,SETCON	;go if yes
	LD	DE,$L3		;double mod III
	AND	5		;yes?
	JP	NZ,SETCON	;go if yes
	LD	DE,$L		;single mod I
	JR	SETCON		;continue
;
SETD	CALL	CKSET		;density/model
	LD	DE,$D1D		;double mod I
	CP	09H		;yes?
	JR	Z,SETCON	;go if yes
	LD	DE,$D3		;double mod III
	AND	5		;yes?
	JR	NZ,SETCON	;go if yes
	LD	DE,$D		;single mod I
	JR	SETCON		;continue
;
SETM	CALL	CKSET		;density/model
	LD	DE,$M1D		;double mod I
	CP	09H		;yes?
	JR	Z,SETCON	;go if yes
	LD	DE,$M3		;double mod III
	AND	5		;yes?
	JR	NZ,SETCON	;go if yes
	LD	DE,$M		;single mod I
	JR	SETCON		;continue
;
SETN	CALL	CKSET		;density/model
	LD	DE,$N1D		;double mod I
	CP	09H		;yes?
	JR	Z,SETCON	;go if yes
	LD	DE,$N3		;double mod III
	AND	5		;yes?
	JR	NZ,SETCON	;go if yes
	LD	DE,$N		;single mod I
	JR	SETCON		;continue
;
SETB	CALL	CKSET		;density/model
	LD	DE,$B		;doubledos
	OR	A		;zero?
	JR	Z,SETCON	;go if yes
	AND	6		;3 or single?
	JP	NZ,CONRET	;go if invalid
	JR	SETCON		;continue
;
SETX	SET	2,(IY+5)	;set 8" drive
	LD	(IY+0),77	;track count
	LD	(IY+1),77	;rel tracks
	LD	(IY+2),38	;dir track
	CALL	CKSET		;density/model
	LD	DE,$X1D		;double mod I
	CP	09H		;yes?
	JR	Z,SETCON	;go if yes
	LD	DE,$X3S		;single mod III
	CP	06H		;yes?
	JR	Z,SETCON	;go if yes
	LD	DE,$X3		;mod III double?
	AND	5		;check it out
	JR	NZ,SETCON	;go if yes
	LD	DE,$X		;single mod I
;
SETCON	PUSH	HL		;save HL
	PUSH	BC		;save
	PUSH	IY		;pass IY to HL
	POP	HL		;HL => DCT
;
	LD	BC,6		;offset to DCT
	ADD	HL,BC		;HL => dest
	EX	DE,HL		;DE => DCT data
	INC	BC		;data length
	LDIR			;move into DCT
	POP	BC		;restore
	POP	HL		;restore
	PUSH	IY		;save IY
	LD	A,(DRIV)	;get binary drive
	CALL	SETDRV		;setup for $SELECT
	POP	IY		;restore DCT
;
	POP	DE		;restore track/sector
;
	LD	A,(ALLFLAG)	;all types?
	OR	A		;0=TRS/LDOS
	JP	Z,CKDEND	;go if not
;
	LD	A,(HL)		;check for RELATIVE add
	CALL	UCASE		;make upper case
	CP	'R'		;relative?
	JR	NZ,CKDSID	;nope, check for 2 sides
	BIT	4,(IY+6)	;relative available?
	SCF			;C = invalid
	RET	Z		;nope, skip it
	SET	3,(IY+6)	;relative engaged
	LD	(IY+8),9	;highest sect 0
	LD	(IY+9),9	;highest sect disk
	LD	(IY+10),5	;secs/gran
	LD	(IY+11),2	;grans/trk
	LD	(IY+12),10	;dir length
	INC	HL		;bump string pointer
	JR	CKDSID		;continue
;
CKDSIE	POP	DE		;restore track/sect
CKDSID	LD	A,(HL)		;fetch next char
	CP	27H		;apostrophe?
	JR	NZ,CKSIDS	;check for double
	RES	0,(IY+5)	;single = single side
	INC	HL		;bump pointer
	JR	CKDEND		;continue
;
CKSIDS	CP	'"'		;double quote?
	JR	NZ,CKDEND	;go if not
	INC	HL		;bump pointer
	LD	A,(IY+7)	;get dos type
	CP	4		;U or T?
	RET	C		;return if out
	CP	17		;$X?
	JR	NC,CKDENDX	;go if yes
	CP	13		;N B or X?
	CCF			;reverse carry
	RET	C		;return if error
CKDENDX	SET	0,(IY+5)	;set 2 sides
;
CKDEND	CALL	RELTKS		;compute relative tracks
	LD	A,(HL)		;get next char
	CP	'='		;track count?
	RET	Z		;yes, done!
	CALL	CKSEP		;separator/terminator?
	SCF			;clear carry
	CCF			;carry clear
	RET	Z		;NC = OK
	SCF			;else invalid char!
	RET			;go!
;
;	check for mod 1/3 single/double density
;
;	EXT	NC = mod 1
;		C  = mod 3
;		Z  = single den
;		NZ = double den
;
;	invalid stack is popped and exit made
;
CKSET	XOR	A		;set Z and NC
CKSLP	EX	AF,AF'		;save flag
	INC	HL		;bump pointer
;
	LD	A,(HL)		;fetch char
	CALL	CKSEP		;sep/term?
	JR	Z,CKSRET	;yes, done!
;
	LD	A,(ALLFLAG)	;all types?
	OR	A		;0=TRS/LDOS
	LD	A,(HL)		;re-fetch char
	JR	Z,CKSPRT	;check only partial
;
	CALL	UCASE		;make upper case
	CP	'R'		;relative?
	JR	Z,CKSRET	;yes, go!
	CP	27H		;single side?
	JR	Z,CKSRET	;yes, go!
	CP	'"'		;double side?
	JR	Z,CKSRET	;yes, go!
;
CKSPRT	CALL	UCASE		;make upper case
	CP	'='		;terminator?
	JR	Z,CKSRET	;yes, go!
	CP	'S'		;single den?
	JR	Z,CKSLS		;yes, go!
	CP	'D'		;double den?
	JR	Z,CKSLD		;yes, go!
	CP	'1'		;mod 1?
	JR	Z,CKSL1		;yes, go!
	CP	'3'		;mod 3?
	JR	Z,CKSL3		;yes, go!
;
BADCONX	POP	AF		;unstack caller
	JP	CONRET		;return invalid!
;
CKSRET	EX	AF,AF'		;get flags back
	RET			;return with condition
;
CKSLS	EX	AF,AF'		;get flags
	SET	1,A		;set flag
	JR	CKSLP		;continue
;
CKSLD	LD	A,(FLAGB)	;get system flag
	BIT	4,A		;double density available
	JR	NZ,BADCONX	;go if not! illegal!
	EX	AF,AF'		;get flags
	SET	0,A		;set flag
	JR	CKSLP		;continue
;
CKSL1	EX	AF,AF'		;get flags
	SET	3,A		;set flag
	JR	CKSLP		;continue
;
CKSL3	EX	AF,AF'		;get flags
	SET	2,A		;set flag
	JR	CKSLP		;go next char
;
