; ptcopy3/asm - kjw/bqsd - 04/83
;
; revised 04/21/83 - kjw/bqsd
;
SRCERR	CALL	ERRMSG		;display status
	LD	A,(IY+6)	;get current drive
	ADD	A,'0'		;make it ascii
	LD	(SRCMSGX),A	;to the string
	LD	HL,SRCMSG	;point to start
	CALL	DISPLAY		;display error
	JP	PARAMS		;go next loop
;
REMDRIV	CALL	ERRMSG		;display status
	LD	A,(IY+6)	;current binary drive
	ADD	A,'0'		;make it ascii
	LD	(REMMSGX),A	;to the string
	LD	HL,REMMSG	;removed
	CALL	DISPLAY		;display it
	XOR	A		;non-active flag
;
;	lockout the drive
;
LOCKIT	PUSH	AF		;save flag
	LD	HL,LTABLE	;lockout table
	CALL	POINT		;point to the byte
	POP	AF		;restore flag
	LD	(HL),A		;set as non-active
	OR	-1		;return NZ
	RET			;done!
;
;	display error condition
;
ERRMSG	LD	HL,ERRTBL	;error table
	LD	B,8		;check 8 bits
ERRFND	RRCA			;check a bit
	JR	C,ERRHAV	;have the error
	INC	HL		;2 byte entries
	INC	HL
	DJNZ	ERRFND		;go find it
;	LD	HL,PGMERR	;program error
;	JR	DSPERR		;display error
ERRHAV	LD	A,(HL)		;get LSB
	INC	HL		;bump table
	LD	H,(HL)		;get MSB
	LD	L,A		;HL => message
DSPERR	JP	DISPLAY		;display error
;
;	display string to video
;
DISPLAY	LD	A,(HL)		;get a byte
	CP	ETX		;done?
	RET	Z		;yes, return
	CALL	VOUT		;display byte
	INC	HL		;bump pointer
	JR	DISPLAY		;continue
;
;	character to video
;
VOUT	PUSH	HL		;save
	PUSH	AF		;save char
	LD	HL,(CURSOR)	;get cursor
	CP	20H		;control code?
	JR	C,VCTL		;yes, go!
	LD	(HL),A		;to video
	CP	(HL)		;still there?
	JR	Z,VOUTOK	;yes, go!
	SUB	20H		;make upper case
	LD	(HL),A		;to video
VOUTOK	INC	HL		;bump video
;
VOUTRET	CALL	FRAME		;check for scroll
	LD	(CURSOR),HL	;reset cursor
	POP	AF		;restore char
	POP	HL		;unstack
	RET			;done
;
;	display control code
;
VCTL	CP	CLS		;clear screen?
	JR	Z,CLSIT		;yes, go!
	CP	BOL		;begin line?
	JR	Z,BOLIT		;yes
	CP	LF		;linefeed?
	JR	NZ,VOUTRET	;return if none
;
;	display linefeed
;
LFIT	LD	A,L		;get LSB
	AND	0C0H		;reset to line beginning
	LD	L,A		;update it
	PUSH	DE		;save
	LD	DE,40H		;64 chars / line
	ADD	HL,DE		;HL = new posit
	POP	DE		;restore
	JR	VOUTRET		;continue
;
;	move cursor to beginning of line
;
BOLIT	LD	A,L		;get LSB
	AND	0C0H		;reset to begin
	LD	L,A		;update
	JR	VOUTRET		;continue
;
;	clear video screen
;
CLSIT	PUSH	DE		;save
	PUSH	BC		;save
	LD	HL,3C00H	;start of video
	LD	DE,3C01H	;start +1
	LD	BC,3FFH		;length -1
;
	LD	(HL),' '	;load a space
	PUSH	HL		;save for cursor
	DI			;turn off alive
	LDIR
	EI
	POP	HL		;cursor
	POP	BC		;unstack
	POP	DE
	JR	VOUTRET		;continue
;
;	check to see if cursor within video
;
FRAME	LD	A,H		;get MSB video
	CP	40H		;yes?
	RET	C		;yes, no change
;
;	scroll video
;
	PUSH	DE		;save
	PUSH	BC		;save
	LD	HL,3C40H	;start line 1
	LD	DE,3C00H	;start line 0
	LD	BC,3C0H		;video length - row
	LDIR			;scroll
	LD	HL,3FC0H	;bottom row
	LD	DE,3FC1H	;bottom +1
	LD	BC,3FH		;length -1
	LD	(HL),' '	;load blank
	PUSH	HL		;save
	LDIR			;clear screen
	POP	HL		;unstack
	POP	BC
	POP	DE
	RET			;done
;
;	get string from keyboard
;
GETSTR	LD	HL,(CURSOR)	;get cursor
	LD	DE,STRING	;input buffer
	LD	C,B		;C = max length
	LD	B,0		;set current length
;
GETLP	CALL	INKEY		;get a key
	CP	CR		;terminator?
	JR	Z,GETDON	;yes, done!
	CP	BREAK		;break key?
	JR	Z,GETDON	;yes, done!
	CP	LARR		;backspace?
	JR	Z,BACKIT	;yes, go!
	LD	(DE),A		;char to string
	LD	(HL),A		;to video
	CP	(HL)		;still there?
	JR	Z,GETOK		;yes, go!
	SUB	20H		;remove ascii
	LD	(HL),A		;back to video
GETOK	LD	A,B		;get char count
	CP	C		;at max?
	JR	Z,GETLP		;yes, cannot add
	INC	HL		;bump video
	INC	DE		;bump pointer
	INC	B		;bump char count
	JR	GETLP		;go next char
;
BACKIT	INC	B		;any length?
	DEC	B		;yes?
	JR	Z,GETLP		;can't dec it, nil!
	DEC	HL		;less video
	DEC	DE		;less buffer
	DEC	B		;less length
	JR	GETLP		;go again
;
	LD	A,CR
GETDON	CP	BREAK		;break key?
	LD	A,0		;load NOP
	JR	NZ,GETDON0	;nope, go!
	LD	A,37H		;SCF opcode
GETDON0	LD	(GETDON1),A	;save flag
;
	LD	A,CR		;CR to buffer
	LD	(DE),A		;terminate input line
	LD	A,B		;get length
	OR	A		;return flags on length
	LD	HL,STRING	;point to input
	LD	A,(HL)		;return with first char
GETDON1	NOP			;set/clear carry
	RET			;return!
;
INKEY	PUSH	BC		;save
	LD	(HL),5FH	;set cursor
INKEY1	LD	B,10		;flash delay
INKEY2	CALL	KEY		;fetch a key
	JR	NZ,INKEY3	;have one, go!
	DJNZ	INKEY2		;go if not
	LD	A,5FH.XOR.8CH	;flash mask
	XOR	(HL)		;change it
	LD	(HL),A		;update it
	JR	INKEY1		;go next char
;
INKEY3	LD	(HL),' '	;blank video
	POP	BC		;restore stack
	RET			;A = char
;
;	fetch key from keyboard
;
KEY	PUSH	BC		;save
	PUSH	DE		;save
	PUSH	HL		;save
;
	LD	BC,500H		;keybounce
	CALL	60H		;wait a bit
	LD	HL,KEYBRD	;work area
	LD	BC,3801H	;keyboard memory
	LD	E,0		;row counter
;
KEY1	LD	A,(BC)		;read a key
	LD	D,A		;save it
	XOR	(HL)		;compare with mask
	LD	(HL),D		;update mask
	AND	D		;have new key?
	JR	NZ,KEY2		;yes, go!
;
	INC	E		;bump row
	INC	HL		;bump mask
	RLC	C		;shift key mask
	JP	P,KEY1		;go till done!
	XOR	A		;load zero
	JR	KEYRET		;done, return
;
KEY2	LD	D,A		;save masked byte
	LD	A,E		;get row
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	E,A		;save row
	LD	C,1		;set bit 0 mask
;
KEY3	LD	A,C		;get mask
	AND	D		;compare
	JR	NZ,KEY4		;have it!
	INC	E		;bump row*8
	RLC	C		;move mask bit
	JR	KEY3		;go till found
;
KEY4	LD	D,0		;DE = key offset
	LD	HL,KEYTBL	;lookup table
	LD	A,(3880H)	;get shift key
	OR	A		;pressed?
	JR	Z,$+5		;go if not
	LD	HL,KEYTBLS	;shift table
	ADD	HL,DE		;add offset
	LD	A,(HL)		;get table entry
;
KEYRET	POP	HL		;unstack
	POP	DE
	POP	BC
	OR	A		;set flags
	RET			;return with char
;
KEYBRD	DEFB	0,0,0,0,0,0,0	;mask area for rollover
;
KEYTBL	DEFB	'@abcdefg'
	DEFB	'hijklmno'
	DEFB	'pqrstuvw'
	DEFB	'xyz`````'
	DEFB	'01234567'
	DEFB	'89:;,-./'
	DEFB	CR,CLEAR,BREAK,UARR,DARR,LARR,RARR,SPACE
;
KEYTBLS	DEFB	'`ABCDEFG'
	DEFB	'HIJKLMNO'
	DEFB	'PQRSTUVW'
	DEFB	'XYZ`````'
	DEFB	8FH,'!"#$%&',27H
	DEFB	'()*+<=>?'
	DEFB	5BH,5CH,5DH,5EH,7BH,7CH,7DH,7EH
;
;	convert A to upper case
;
UCASE	CP	'a'
	RET	C
	CP	'z'+1
	RET	NC
	AND	5FH
	RET
;
;	interrupt task processor
;
TASK	PUSH	AF		;save it
	IN	A,(0E0H)	;read interrupt latch
	BIT	2,A		;RTC interrupt?
	JR	NZ,TASKRET	;nope, done!
;
;	check for CLEAR BREAK for immediate terminate!
;
	LD	A,(3840H)	;read keyboard row
	CP	6		;clear break?
	JR	Z,ABORT		;abort!
;
;	'alive' task in video upper right corner
;
	LD	A,10		;get counter
TSKCNT	EQU	$-1
	DEC	A		;less one
	LD	(TSKCNT),A	;put it back
	JR	NZ,TASKRET	;go if not time
	LD	A,10		;reset counter
	LD	(TSKCNT),A	;put it back
;
	LD	A,(3C3FH)	;get video byte
	CP	8CH		;on?
	LD	A,8CH		;turn on if not
	JR	NZ,TASKSET	;set it
	LD	A,5FH		;off
TASKSET	LD	(3C3FH),A	;to video
;
TASKRET	IN	A,(0ECH)	;clear RTC
	POP	AF		;restore stack
	EI			;enable interrupts
	RET			;return from interrupt
;
;	abort program, display and l@rx<r@%D4pFW@Д4D5F7@Ӱ%Eu@@3tdvBW&&B&VV6PД W2&W76VCД %Eu@vBbW0Д $Tt&R7F'B&w&ӰӰF77W'&VBG&6&Vrf&atted
;
SHOWRTR	PUSH	HL		;save
	LD	A,(IY+0)	;get current track
	CALL	ASCII		;to decimal ascii
	LD	(WRTRMGX),BC	;to the string
	LD	A,(IY+6)	;get binary drive
	ADD	A,'0'		;add ascii
	LD	(WRTRMGY),A	;to string
	LD	HL,WRTRMG	;start of text
	CALL	DISPLAY		;display it
	POP	HL		;restore stack
	RET			;done
;
SHOWRD	PUSH	HL		;save buffer
	LD	A,(IY+0)	;get track
	CALL	ASCII		;to decimal ascii
	LD	(RDMGX),BC	;to string
	LD	A,(IY+6)	;get binary drive
	ADD	A,'0'		;to ascii
	LD	(RDMGY),A	;to string
	LD	HL,RDMG		;start of text
	CALL	DISPLAY		;display it
	POP	HL		;unstack
	RET			;done
;
SHOWWR	PUSH	HL		;save
	LD	A,(IY+0)	;get track
	CALL	ASCII		;go decimal ascii
	LD	(WRMGX),BC	;to the string
	LD	A,(IY+6)	;get drive
	ADD	A,'0'		;make it ascii
	LD	(WRMGY),A	;to the string
	LD	HL,WRMG		;start of test
	CALL	DISPLAY		;display it
	POP	HL		;unstack
	RET			;done
;
SHOWVE	PUSH	HL		;save
	LD	A,(IY+0)	;get track
	CALL	ASCII		;to decimal ascii
	LD	(VEMGX),BC	;to string
	LD	A,(IY+6)	;get drive
	ADD	A,'0'		;make it ascii
	LD	(VEMGY),A	;to the string
	LD	HL,VEMG		;start of string
	CALL	DISPLAY		;display string
	POP	HL		;restore stack
	RET			;done
;
;	convert A => CB decimal ascii
;
ASCII	LD	C,'0'		;init MSB
ASC1	SUB	10		;less 10's place
	JR	C,ASC2		;go if found
	INC	C		;bump ascii
	JR	ASC1		;go more
ASC2	ADD	A,'0'+10	;last sub + ascii
	LD	B,A		;CB = ascii
	RET			;done
;
;	verify current sector
;
VERIFY	PUSH	HL		;save buffer
	LD	HL,READV	;read / verify
	JR	VERIFYC		;go common
;
VERIFYN	PUSH	HL		;save buffer
	LD	HL,READNS	;read no seek
;
VERIFYC	LD	(VERIFYV),HL	;save vector
	PUSH	BC		;save sector length
	LD	HL,VERBUFF	;verify buffer
	CALL	$		;read sector
VERIFYV	EQU	$-2
	POP	BC		;restore length
	POP	HL		;restore buffer
	RET	NZ		;go if disk error!
;
;	check if data matches exactly
;
	PUSH	HL		;save buffer
	PUSH	DE		;save track/sector
	LD	DE,VERBUFF	;verify buffer
;
VERIFYW	LD	B,0		;256 bytes / page
VERIFYX	LD	A,(DE)		;get a byte
	CP	(HL)		;match?
	JR	NZ,VERIFYY	;go if error!
	INC	DE		;bump pointers
	INC	HL
	DJNZ	VERIFYX		;go for 256 bytes
	DEC	C		;less page counter
	JR	NZ,VERIFYW	;go for C # pages
;
	XOR	A		;load no error
	JR	VERIFYZ		;go common
;
VERIFYY	OR	-1		;set NZ flag
	LD	A,0		;bump return with 00H
;
VERIFYZ	POP	DE		;unstack
	POP	HL		;restore buffer
	RET			;return with Z status
;
