; ptback/asm - kjw/bqsd - 10/82 - version 1.00 - 04/83
;
; revised 04/21/83 - kjw/bqsd
;
	PAGE
;
;	$SCOPY - standard disk backup
;
SCOPY	LD	A,2		;init format type
	LD	(FMTYPE),A	;save into flag
	XOR	A		;set start track to 0
	LD	(STRTRK),A	;save starting track #
;
;	fetch source information
;
	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Source'
	DEFB	ETX
;
	CALL	ONEDRIV		;fetch drive number
	LD	A,(DRIV)	;get the drive
	LD	(SDRIVE),A	;save it
;
;	get destination info
;
	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Destination'
	DEFB	ETX
;
	CALL	GETDRVS		;get which drives
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	XOR	A		;save starting drive
	LD	(POSA),A	;start position
	DEC	A		;set mount flag
	LD	(MFLAG),A	;init flag
;
;	check if source drive = any dest drive
;
	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;fetch DCT into IY
	BIT	5,(IY+5)	;selected as dest drive?
	JR	Z,ASKFMT	;nope, go!
	XOR	A		;set mount flag active
	LD	(MFLAG),A	;save it
;
ASKFMT	RST	@08		;prompt for format
;
	DEFB	EOL
	DEFM	'Format Drives? '
	DEFB	ETX
;
	XOR	A		;set TRUE flag
	LD	(SKVER),A	;enable verify
	LD	(HASFLAG),A	;enable prompt if format
	INC	A		;set non-zero
	LD	(IFBFMT),A	;enable format prompt
	LD	B,1		;1 key input
	RST	@10		;get from keyboard
	CALL	POSHL		;find a char
	JR	Z,SOLOOP	;go if nil input
;
AKBAK	CALL	POSHL		;move to next field
	JR	Z,ANOBAK	;go if done
	CALL	UCASE		;convert first char
	CP	'*'		;skip verify?
	JR	Z,VERSKP	;yes, go!
	CP	'!'		;overwrite on format?
	JR	Z,BAKFMTS	;yes, go!
	CP	'Y'		;format?
	JR	Z,BAKFMT0	;yes, go!
	CP	'N'		;no format?
	JR	Z,BAKFMT1	;yes, go!
	JR	ASKFMT		;else invalid, ask again
;
;	skip verify on backup
;
VERSKP	LD	A,1		;set flag
	LD	(SKVER),A	;save flag
;
BAKVGO	INC	HL		;bump input pointer
	JR	AKBAK		;check for more input
;
BAKFMTS	LD	A,-1		;format over data
	LD	(HASFLAG),A	;save flag
;
BAKFMT0	LD	A,1		;disable format
	LD	(IFBFMT),A	;save flag
	JR	BAKVGO		;check next field
;
BAKFMT1	XOR	A		;enable flag
	JR	BAKFMT0+2	;set flag & continue
;
;	copy completed, do another backup
;
ANOBAK	LD	A,0		;fetch flag
IFBFMT	EQU	$-1
	DEC	A		;format dest disks?
	JR	NZ,SCPYBAK	;no, continue past!
;
;	copy disk outer loop
;
SOLOOP	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Mount DESTINATION diskettes:'
	DEFB	ETX
;
	CALL	ONEKEY		;wait for single key
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	DE,SCOPYO	;formatter subroutine
	LD	BC,SCPYBAK	;return here after format
	JP	DRVCOMM		;do all dest drives
;
SCOPYO	CALL	DSTAT		;is drive ready?
	JP	NZ,REMDRIV	;nope, remove from que
	CALL	RESTORE		;move head to track 0
	JP	NZ,REMDRIV	;not there, remove it
	LD	A,(IY+6)	;get system flags
	PUSH	AF		;save on stack
	CALL	FORMIT		;format the disk!
	POP	AF		;restore
	LD	(IY+6),A	;reset relative
	RET			;done!
;
SCPYBAK	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;setup for I/O
	CALL	CNTOTAL		;compute total sectors
	LD	(TEMP2),HL	;save sector count
;
	LD	D,0		;set track 0
	CALL	FIRSTS		;load E with first sector
	LD	(TEMP0),DE	;save starting position
;
	CALL	INITBD1		;enable error monitor
	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
;	check to see if any dest drives are active
;
SCOPYLP	LD	BC,(DRIVES)	;C = # drives
	LD	B,C		;pass # to B
	LD	C,0		;C = counter
;
SCOPYCK	LD	A,C		;get drive #
	CALL	SETDRV		;locate DCT
	BIT	5,(IY+5)	;active drive?
	JR	NZ,SCOPYK0	;yes, go!
	INC	C		;bump drive #
	DJNZ	SCOPYCK		;check all 8 drives
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'No Destination Drives'
	DEFB	ETX
;
	JP	GOBACK		;back to sub-menu
;
;	enable/disable mount prompt
;
SCOPYK0	LD	A,(SDRIVE)	;get source drive
	PUSH	AF		;save drive #
	CALL	SETDRV		;fetch DCT
	POP	AF		;get drive back
	BIT	5,(IY+5)	;drive on?
	JR	NZ,MSTMNT	;yes, go!
	INC	A		;else set non-source driv
;
MSTMNT	LD	(DDRIVE),A	;setup for prompts
;
;	setup params for current loop
;
	LD	DE,(TEMP0)	;get start track/sector
	LD	(TEMP1),DE	;save for write
	LD	HL,(TEMP2)	;get # sectors remaining
	LD	BC,BUFFER	;start of I/O buffer
	LD	A,(SDRIVE)	;get source drive
	CALL	SETDRV		;setup for I/O
	CALL	DRVSAME		;source & dest same?
	CALL	Z,SMOUNT	;yes, prompt for mounts
;
;	read a buffer full
;
	PUSH	HL		;save remain count
	CALL	MREAD		;read as many as possible
	LD	(TEMP2),HL	;save remaining count
	LD	(TEMP0),DE	;save next track/sector
	LD	B,H		;pass remaining to BC
	LD	C,L		;BC = # sectors left
	POP	HL		;HL = total number start
	OR	A		;clear carry flag
	SBC	HL,BC		;HL = # sectors just read
	LD	(TEMP3),HL	;save for each drive loop
	LD	DE,CPLP1	;subroutine vector
	LD	BC,CPLP2	;return vector after copy
	JP	DRVCOMM		;do all dest drives
;
CPLP1	LD	A,(DRIV)	;get current drive
	LD	(DDRIVE),A	;save into dest drive
	CALL	DRVSAME		;source & dest same?
	CALL	Z,DMOUNT	;yes, mount dest disk
;
	LD	HL,(TEMP3)	;get # sectors to write
	LD	DE,(TEMP1)	;get start track/sector
	LD	BC,BUFFER	;start of data buffer
	CALL	DSTAT		;check if drive is ready
	JR	NZ,REMDRIV	;nope, remove from que
;
	CALL	MWRITE		;write buffer to dest
	JR	CPYVER		;verify!
;
;	drive found faulty, remove drive from que
;
REMDRIV	RES	5,(IY+5)	;remove drive
	RET			;done!
;
;	dest disks to be verified?
;
CPYVER	LD	A,0		;get flag
SKVER	EQU	$-1
	DEC	A		;verify on?
	RET	Z		;nope, skip it!
;
	LD	HL,(TEMP3)	;get # sectors to verify
	LD	DE,(TEMP1)	;get start track/sector
	LD	BC,BUFFER	;start of data
	LD	(TEMP9),BC	;save buffer pointer
;
CPYVER1	PUSH	HL		;save # sectors to go
	LD	BC,DAMBUFF	;read sector here
	CALL	SHOVERF		;verify the sectors
;
	LD	HL,(TEMP9)	;get buff pointer
	PUSH	DE		;save track/sector
	LD	DE,DAMBUFF	;verify data here
	LD	B,0		;256 bytes to compare
	CALL	COMPARE		;same?
	CALL	NZ,NOGOODV	;nope, show as bad!
;
	LD	HL,(TEMP9)	;get buff pointer
	INC	H		;bump by 256 bytes
	LD	(TEMP9),HL	;put back new pointer
	POP	DE		;restore track/sector
	POP	HL		;restore remain count
	CALL	NEXSEC		;move DE to next sector
	RET	C		;go if disk end
;
	DEC	HL		;less sector just read
	LD	A,H		;any more to do?
	OR	L		;any bits on?
	JR	NZ,CPYVER1	;go if more to do
	RET			;else on to next drive
;
CPLP2	LD	HL,(TEMP2)	;get remaining sectors
	LD	A,H		;anything?
	OR	L		;any bits on?
	JP	NZ,SCOPYLP	;go if more to do
;
;	verify disk remainder if track count > source
;
	LD	DE,CPLPX	;subroutine vector
	LD	BC,CPLPY	;return vector when done
	JP	DRVCOMM		;do all active drives
;
;	see if dest disk larger than source disk
;	and verify the additional sectors
;
CPLPX	LD	DE,(TEMP0)	;get current track/sector
	CALL	NEXSEC		;move to next
	RET	C		;not beyond disk boundary
	LD	DE,(TEMP0)	;re-fetch it
;
CPLPZ	LD	BC,BUFFER	;I/O buffer
	CALL	SHOVERF		;verify it
	CALL	NEXSEC		;move to next sector
	JR	NC,CPLPZ	;go if not at disk end
;
;	disk completely verified
;	update directory to new track count
;
UPDIRX	LD	A,(IY+1)	;get track count
	RST	@18		;convert to ascii
	LD	(UPDIRY),A	;to the string
	LD	(UPDIRY+1),BC	;rest to string
	RST	@08		;display message
;
	DEFB	LF
	DEFM	'Updating Directory to '
UPDIRY	DEFM	'xxx Tracks'
	DEFB	LF
	DEFB	ETX
;
	CALL	RDDIR		;read directory
	JR	NZ,UPDIRZ	;skip if any errors
	CALL	MAKEGAT+3	;re-create GAT sector
	JP	WRDIR		;write dir and return
;
UPDIRZ	RST	@08		;display message
;
	DEFB	EOL
	DEFM	'Cannot Update Directory'
	DEFB	LF
	DEFB	ETX
;
	RET			;on to the next drive
;
;	all diskettes copied, see if to repeat
;
CPLPY	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	JP	SFMT4		;ask if to do again!
;
;	display sector mismatch from $BACKUP
;
NOGOODV	RST	@08		;display
;
	DEFM	'  ** BAD **'
	DEFB	LF
	DEFB	ETX
;
	RET
;
;	alternate serial # storage
;
SERSAV2	DEFB	0,0,0,0,0,0,0,0
	DEFB	0,0,0,0,0,0,0,0
;
