PEA    ; pea/asm
 	ORG	5200H
 ENTRY	LD	(STACK),SP	;save stack pointer
 	PUSH	HL		;save command string
 	LD	HL,HELLO	;intro message
 	CALL	@DISPLY		;display it
 	LD	IY,SYSTEM	;system table
 	LD	HL,0		;get stack
 STACK	EQU	$-2
 	LD	(IY+5),L	;save in system
 	LD	(IY+6),H
 	POP	HL		;get command back
 	CALL	POSHL		;any input?
 	JP	C,ASKPARAMS	;ask if not
 SCAN1	CALL	POSHL		;get next character
 	JP	C,PARAMERR	;parameter error
 	CP	'-'		;assemble command?
 	JR	NZ,SCAN2	;get filespec
 	INC	HL		;next character
 	LD	DE,TABLE1	;table of addresses
 	LD	B,2		;length of commands
 	CALL	IFTABLE1	;is it here
 	JP	Z,PARAMERR	;not found, error
 	PUSH	DE		;go address
 	RET			;done
 SCAN2	PUSH	HL		;save this
 	LD	HL,DCB1		;opcode dcb
 	LD	DE,DCB1+1
 	LD	BC,149		;go for 3 dcbs
 	LD	(HL),3		;fill with terminator
 	LDIR
 	POP	HL		;done
 	LD	DE,DCB1		;move it there
 	CALL	@FSPEC		;move the file
 	JP	C,ERROR		;illegal filespec
 	LD	DE,DCB1		;find it
 	LD	B,0		;for LRL 0
 	PUSH	HL		;save pointer
 	LD	HL,@IOBUFF1	;input/output buffer
 	PUSH	IY		;don't use
 	CALL	4424H		;open the file
 	POP	IY		;protect it from DOS
 	POP	HL		;filename pointer
 	JP	NZ,ERROR	;something happened
 	CALL	POSHL		;any more input
 	JR	C,NOMORE	;nothing else
 	LD	DE,DCB2		;source filespec
 	CALL	@FSPEC		;move the filename
 	JP	C,ERROR		;illegal filespec
 	LD	DE,DCB2		;find it
 	LD	B,0		;for LRL 0
 	PUSH	HL
 	LD	HL,@IOBUFF2
 	PUSH	IY
 	CALL	4424H		;open it up
 	POP	IY
 	POP	HL
 	JP	NZ,ERROR	;not found?
 	CALL	POSHL		;any more?
 	JR	C,NOMORE	;nothing
 	LD	DE,DCB3		;for object file
 	CALL	@FSPEC		;fetch the filespec
 	JP	C,ERROR		;illegal
 	SET	6,(IY)		;set -WO flag
 NOMORE	BIT	6,(IY)		;-WO specified?
 	JR	Z,GETOPS	;load opcode file
 	LD	A,(DCB3)	;get a byte
 	CP	3		;anything?
 	JP	Z,PARAMERR	;-WO with no filename
 GETOPS	LD	BC,0		;starting record
 	LD	HL,@IOBUFF1+0FFH
 	LD	DE,DCB1
 	EXX			;stow it in these
 	LD	HL,OPBUFF	;opcode buffer
 	LD	(IY+1),L	;initialize the area
 	LD	(IY+2),H
 OPCODES
 	CALL	GETB		;get a byte
 	JP	NZ,LOADBD	;bad load or end?
 	CP	'.'		;remark?
 	JP	Z,DOREMARK	;finish it
 	LD	E,(IY+1)	;get opcode table pointer
 	LD	D,(IY+2)
 	JR	STUOP		;stuff into table
 OPLP	CALL	GETB		;next byte
 	JP	NZ,LOADBD
 	CP	'/'		;terminator?
 STUOP	LD	(DE),A		;put into table
 	INC	DE		;bump pointer
 	JR	NZ,OPLP		;continue if not
 	LD	HL,STRING	;use this for decode
 STORLP	CALL	GETB		;get a byte
 	JP	NZ,LOADBD	;error occured
 	LD	(HL),A		;put in buffer
 	INC	HL		;bump pointer
 	CP	13		;line terminator?
 	JR	Z,STORGOT
 	CP	10
 	JR	NZ,STORLP
 	DEC	HL
 	LD	(HL),13
 	INC	HL
 STORGOT	LD	HL,STRING	;start of the line
 	LD	IX,STORAGE	;storage area
 FIGLP	CALL	POSHL		;get a byte
 	JR	C,FIGDONE	;finished
 	CP	'#'		;numerical?
 	JR	Z,FIGNUM	;go if yes
 	CP	'%'		;numerical?
 	JR	Z,FIGNUM	;go if yes
 	CP	'$'		;relative addresser?
 	JR	Z,FIGNUM	;go if yes
 	CALL	VALUE		;must be a number
 	JP	C,FMTERR	;file format error
 	LD	A,B		;check for 1 byte
 	OR	A		;set flag
 	JP	NZ,FMTERR	;format error
 	LD	A,'!'		;force number
 	LD	(IX),C		;save value
 	INC	IX
 	DEC	HL
 FIGNUM	LD	(DE),A		;for position
 	INC	DE		;bump table
 	INC	HL
 	JR	FIGLP		;get more
 FIGDONE	LD	A,'/'		;insert divider
 	LD	(DE),A		;into table
 	INC	DE		;bump pointer
 	LD	HL,STRING-1	;start of computed
 	LD	IX,STORAGE	;saved numbers
 	INC	HL
 FIG2LP	CALL	POSHL		;get a command
 	JR	C,FIGURED	;begone
 	CP	'#'
 	JR	Z,FIG2LP-1
 	CP	'%'
 	JR	Z,FIG2LP-1
 	CP	'$'
 	JR	Z,FIG2LP-1
 	CALL	VALUE
 	LD	A,(IX)		;get a value
 	LD	(DE),A		;put into code
 	INC	IX		;bump pointers
 	INC	DE
 	JR	FIG2LP		;get more
 FIGURED	LD	(IY+1),E	;update table pointer
 	LD	(IY+2),D
 	JP	OPCODES		;go some more
 LOADBD	CP	1CH		;end of file?
 	JR	Z,LOADOK	;allow it
 	CP	1DH		;out of range?
 	JP	NZ,ERROR	;report the error
 LOADOK	LD	HL,MADMSG
 	CALL	@DISPLY
 	LD	L,(IY+1)	;get opcode end
 	LD	H,(IY+2)
 	LD	(IY+3),L	;save label pointer
 	LD	(IY+4),H
 	LD	HL,OPBUFF	;start of opcodes
 	LD	(IY+1),L	;save it
 	LD	(IY+2),H
 	LD	BC,0		;starting source record
 	LD	HL,@IOBUFF2+0FFH
 	LD	DE,DCB2		;source code file (open)
 	EXX			;save in alt set
 ASSEM	LD	HL,STRING	;line work area
 ASSEMLP	CALL	GETB		;get a byte
 	JP	NZ,ASSERR	;assembly error
 	LD	(HL),A		;put into string
 	INC	HL
 	CP	13
 	JR	NZ,ASSEMLP	;finish this line
 	LD	HL,STRING	;start of line
 	CALL	PARSE		;parse the string
 	JR	ASSEM		;continue
 ASSERR	CP	1CH		;end of file?
 	JR	Z,ASSOK
 	CP	1DH
 	JP	NZ,ERROR
 ASSOK	JP	402DH		;stop here for now
 ;!!!
 PARSE	RET
 DOREMARK
 	CALL	GETB		;get a byte
 	JP	NZ,LOADBD
 	CP	13		;end of line?
 	JP	Z,OPCODES	;continue is yes
 	JR	DOREMARK	;finish the remark
 ABORT	CALL	2BH		;drain type-ahead
 	OR	A		;anything?
 	JR	NZ,ABORT	;wait if yes
 	LD	HL,ABMSG	;abort message
 	CALL	@DISPLY		;display it
 	JP	4030H		;exit to DOS
 FMTERR	CALL	@DISPLY
 	LD	A,22H
 ERROR	OR	0C0H		;setup for return
 	CALL	4409H		;display error
 	JR	ASKPARAMS	;re-start
 PARAMERR
 	LD	HL,PARMSG	;parameter error
 	CALL	@DISPLY
 ASKPARAMS
 	LD	(IY),0		;clear parameters
 	LD	HL,PROMPT	;prompt message
 	CALL	@DISPLY		;display it
 	LD	B,63		;# char for input
 	LD	HL,STRING	;internal string
 	CALL	40H		;get from keyboard
 	JR	C,ABORT		;abort program
 	LD	A,B		;get length
 	OR	A		;anything?
 	JP	NZ,SCAN1	;scan it if yes
 	LD	HL,HELP		;help message
 	CALL	@DISPLY		;print it
 	JR	ASKPARAMS	;ask again
 IFTABLE1
 	LD	A,(DE)		;get table byte
 	OR	A		;check for terminator
 	RET	Z		;0 terminator
 	LD	C,A		;save here
 	LD	A,(HL)		;get string byte
 	CALL	UCASE		;make it upper case
 	CP	C		;same?
 	JR	NZ,NEXT1	;next command
 	PUSH	HL		;save pointers
 	PUSH	DE
 	PUSH	BC
 CKTAB1	LD	A,(DE)		;get table byte
 	LD	C,A		;save here
 	LD	A,(HL)		;get string byte
 	CALL	UCASE		;make it upper
 	CP	C		;same?
 	JR	NZ,NEXT1P	;pop, next one
 	INC	HL		;bump string
 	INC	DE		;bump table
 	DJNZ	CKTAB1		;go for length
 	POP	BC		;have the bugger
 	LD	A,(DE)		;get lsb
 	LD	C,A		;save it here
 	INC	DE		;point to next
 	LD	A,(DE)		;get MSB
 	POP	DE		;fix stack
 	LD	D,A		;give to D
 	LD	E,C		;DE = address
 	EX	(SP),HL		;save new HL
 	POP	HL		;fix the stack
 	OR	1		;set NZ flag
 	RET			;back with DE = addr.
 NEXT1P	POP	BC		;restore pointers
 	POP	DE
 	POP	HL
 NEXT1	PUSH	HL
 	LD	L,B		;get length
 	LD	H,0		;only to LSB
 	ADD	HL,DE		;point to address
 	INC	HL		;pass over it
 	INC	HL
 	EX	DE,HL		;back to DE
 	POP	HL		;string pointer
 	JR	IFTABLE1	;get next entry
 @DISPLY	PUSH	HL		;save pointer
 DISPLP	LD	A,(HL)		;get a byte
 	INC	HL		;bump pointer
 	CP	3		;terminator?
 	JR	Z,DISPDN	;done if yes
 	CALL	33H		;display it
 	CP	13		;terminator?
 	JR	NZ,DISPLP	;go if not
 DISPDN	POP	HL		;restore string start
 	RET			;done
 ADNL	SET	7,(IY)		;-NL
 	JR	ADFIN
 ADWO	SET	6,(IY)		;-WO
 	JR	ADFIN
 ADWS	SET	5,(IY)		;-WS
 	JR	ADFIN
 ADLP	SET	4,(IY)		;-LP
 	JR	ADFIN
 ADWE	SET	3,(IY)		;-WE
 	JR	ADFIN
 ADNE	SET	2,(IY)		;-NE
 	JR	ADFIN
 ADIM	SET	1,(IY)		;-IM
 ADFIN	JP	SCAN1		;check for more
 UCASE	CP	60H		;upper case now?
 	RET	C		;skip if yes
 	CP	80H		;graphic or tab ?
 	RET	NC		;skip if yes
 	AND	5FH		;else make it upper
 	RET			;done
 	INC	HL		;point to next byte
 POSHL	LD	A,(HL)		;get a byte
 	CP	13		;terminator?
 	SCF			;C = yes
 	RET	Z		;back if end of line
 	CP	','		;separator?
 	JR	Z,POSHL-1	;next one if yes
 	CP	' '		;separator?
 	JR	Z,POSHL-1	;go if yes
 	CP	9		;tab
 	JR	Z,POSHL-1
 	OR	A		;clear carry flag
 	RET			;back to caller
 @FSPEC	LD	A,(HL)		;get a byte
 	CP	13		;check for terminators
 	JR	Z,SPECDN	;go if yes
 	CP	3
 	JR	Z,SPECDN
 	CP	','
 	JR	Z,SPECDN
 	CP	' '
 	JR	Z,SPECDN
 	CP	9
 	JR	Z,SPECDN
 	CALL	UCASE
 	CALL	CKVALID		;valid ?
 	JR	C,SPECBDX	;invalid spec
 SPECBAK	LD	(DE),A		;put in dcb
 	INC	DE		;bump it
 	INC	HL		;bump input pointer
 	JR	@FSPEC		;continue
 SPECBDX	CP	'/'		;extension?
 	JR	Z,SPECBAK	;back to it
 	CP	'.'		;password?
 	JR	Z,SPECBAK
 	CP	':'		;drive number?
 	JR	Z,SPECBAK
 	JR	SPECBD
 SPECDN	OR	A		;clear carry
 	LD	A,3		;put terminator
 	LD	(DE),A		;into dcb
 	RET			;done
 SPECBD	SCF			;C = bad
 	JR	SPECDN+1	;return
 CKVALID	CP	30H		;less than '0'?
 	RET	C		;C = bad
 	CP	3AH		;less than or = '9'
 	CCF
 	RET	NC
 	CP	41H		;less than 'A'
 	RET	C		;bad if yes
 	CP	5BH		;still alphabetic
 	CCF
 	RET
 BERROR	POP	BC		;restore stack
 	POP	DE
 	POP	HL
 	EXX			;put 'em back
 	RET			;NZ flag set
 GETB	EXX			;alt set
 	INC	L		;buffer pointer
 	JR	NZ,GOTB		;in buffer now
 	PUSH	HL		;save buffer
 	PUSH	DE		;save dcb
 	PUSH	BC		;save position
 	CALL	4442H		;position to file
 	JR	NZ,BERROR	;error now
 	POP	BC
 	POP	DE
 	POP	HL		;restore values
 	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	CALL	4436H		;read the sector
 	JR	NZ,BERROR	;error now
 	POP	BC
 	POP	DE
 	POP	HL		;have it
 	INC	BC		;bump rel sector
 GOTB	XOR	A		;set Z flag
 	LD	A,(HL)		;get the byte
 	EXX			;alt back
 	RET			;have new byte
 VALUE	CALL	FIGBASE		;compute the base
 	LD	(IY+7),A	;max digit
 	LD	(IY+8),C	;adder address
 	LD	(IY+9),B	;MSB adder
 	LD	BC,0		;start value
 VALLP	LD	A,(HL)		;get a digit
 	CP	','		;separator?
 	RET	Z
 	CP	' '		;separator?
 	RET	Z
 	CP	9		;tab?
 	RET	Z
 	CP	13
 	RET	Z
 	CP	0
 VALTERM	EQU	$-1
 	JR	Z,VALDONE
 	CALL	ADJBYTE		;adjust to binary
 	RET	C		;invalid already
 	CALL	ADDIT		;mult X base and add curr
 	INC	HL		;bump data pointer
 	JR	VALLP		;get next digit
 VALDONE	INC	HL
 	RET
 VALOK	OR	A		;clear carry flag
 	RET			;done
 ADDIT	PUSH	HL		;save position
 	PUSH	AF		;save current number
 	LD	L,(IY+8)	;get evaluator address
 	LD	H,(IY+9)
 	LD	(CALL1),HL	;put into call code
 	LD	H,B		;get start value
 	LD	L,C
 	CALL	0		;call adder
 CALL1	EQU	$-2
 	POP	AF		;get new number
 	LD	C,A		;give to bc
 	LD	B,0
 	ADD	HL,BC		;add to total
 	LD	B,H		;replace new total
 	LD	C,L
 	POP	HL		;get pointer back
 	RET			;done
 ADDHEX	ADD	HL,HL		;*16
 ADDOCT	ADD	HL,HL		;*8
 DECADD	ADD	HL,HL		;*4
 ADDBIN	ADD	HL,HL		;*2
 	RET
 ADDDEC	CALL	DECADD		;*4
 	ADD	HL,BC		;*5
 	JR	ADDBIN		;*10
 ADJBYTE	CALL	UCASE		;make it upper
 	SUB	30H		;remove ascii
 	RET	C		;bad now
 	CP	10		;0-9?
 	CCF
 	RET	NC		;allow it
 	SUB	7		;remove -A
 	RET	C		;bad
 	CP	(IY+7)		;compare to max
 	CCF
 	RET			;done with convert
 FIGBASE	PUSH	HL		;save pointer
 	CALL	POSEND		;point to terminator
 	DEC	HL		;decrement it
 	LD	A,(HL)		;get the byte
 	POP	HL		;restore pointer
 	LD	(VALTERM),A
 	CALL	UCASE		;make it upper
 	CP	'B'		;binary?
 	JR	Z,SETBIN
 	CP	'D'		;decimal?
 	JR	Z,SETDEC
 	CP	'H'		;hex
 	JR	Z,SETHEX
 	CP	'O'		;octal?
 	JR	Z,SETOCT
 	XOR	A
 	LD	(VALTERM),A
 	LD	A,10		;max number
 	LD	BC,ADDDEC	;decimal adder
 	RET
 SETDEC	LD	A,10
 	LD	BC,ADDDEC
 	RET
 SETBIN	LD	A,2		;base
 	LD	BC,ADDBIN
 	RET
 SETHEX	LD	A,16
 	LD	BC,ADDHEX
 	RET
 SETOCT	LD	A,8
 	LD	BC,ADDOCT
 	RET
 POSEND	LD	A,(HL)		;get a byte
 	CP	13
 	RET	Z
 	CP	','
 	RET	Z
 	CP	' '
 	RET	Z
 	CP	9
 	RET	Z
 	INC	HL
 	JR	POSEND
 ;**
 SYSTEM 	DB	0	;+0
 ;7 = -NL, 6 = -WO, 5 = -WS, 4 = -LD
 ;3 = -WE, 2 = -NE, 1 = -IM, 0 = unused
 	DW	0	;+1,2 - opcode table pointer
 	DW	0	;+3,4 - instruction table pointer
 	DW	0	;+5,6 - stack pointer pointer
 TABLE1	DB	'NL'
 	DW	ADNL		;no listing
 	DB	'WO'
 	DW	ADWO		;with object code
 	DB	'WS'
 	DW	ADWS		;with symbol table
 	DB	'LP'
 	DW	ADLP		;to line printer
 	DB	'WE'
 	DW	ADWE		;wait on errors
 	DB	'NE'
 	DW	ADNE		;no expansions
 	DB	'IM'
 	DW	ADIM		;object to memory
 	DB	0		;terminator
 ;##
 MADMSG	DB	'Instruction Set Loaded.',13
 ABMSG	DB	10,'** Aborted **',13
 HELP	DB	10,'-NL,-WO,-WS,-LP,-WE,-NE,-IM,opfile,sourcefile,outfile',10,10
 	DB	'-NL = No Listing Output          -WO = With Object Code',10
 	DB	'-WS = With Symbol Table          -LP = Output to Lineprinter',10
 	DB	'-WE = Wait on Errors             -NE = No Expansions',10
 	DB	'-IM = Assemble Into Memory',10
 	DB	'opfile        = data file of opcodes',10
 	DB	'sourcefile    = source code file',10
 	DB	'outfile       = object code file',13
 PROMPT	DB	'Parameters:',13
 PARMSG	DB	'Parameter Error !',13
 HELLO	DB	1CH,1FH
 	DB	'PEA - PowerSoft Editor Assembler - Version 1.0',10
 	DB	'by Kim Watt - Breeze/QSD, Inc. - Dallas, Texas',10,13
 DCB1	DS	50
 DCB2	DS	50
 DCB3	DS	50
 DBUFF	EQU	$&0FF00H
 STORAGE	EQU	DBUFF+100H
 STRING	EQU	DBUFF+200H
 @IOBUFF1	EQU	STRING+100H
 @IOBUFF2	EQU	STRING+200H
 @IOBUFF3	EQU	STRING+300H
 OPBUFF	EQU	STRING+400H
 	END	ENTRY
