; maild/asm - kjw/bqsd - version 2.00 - 01/83
;
; revised 02/10/83 - kjw
;
	TITLE	'<PowerMAIL - 2.00 source code>'
;
*GET	MAILEQU			;system equates
*GET	MAILDISK		;I/O drivers
;
	ORG	CODE
*GET	MAILDVRS		;I/O drivers
*GET	MAILMATH		;math subroutines
;
	SUBTTL	'<maild/asm - powermail utilities>'
;
	PAGE
;
ENTRY	LD	IY,SYSTEM	;reset system pointer
	CALL	INTEG		;check sys integrety
	LD	A,(IY+31)	;get init flag
	CP	'*'		;inited?
	JP	NZ,CORRUPT	;go if bad!
	BIT	5,(IY+0)	;recovery mode?
	JP	NZ,RECOVER	;yes, go!
;
MENU	LD	IY,SYSTEM	;reset sys pointer
	RES	5,(IY+0)	;set NOT recovery mode
	LD	L,(IY+2)	;fetch stack pointer
	LD	H,(IY+3)	;HL = init stack
	LD	SP,HL		;reset it
;
	CALL	CLRDATA		;clear data file
	CALL	SHOW		;to video
	LD	HL,MSG1		;menu selections
	CALL	DISPLAY		;display options
	LD	B,1		;one key input
	CALL	GETSTR		;from keyboard
	JR	C,EXIT		;go on BREAK
	JR	Z,MENU		;no defaults here
	LD	HL,TABLE1	;jump table
	CALL	GOTABLE		;go vector if match
	JR	MENU		;invalid, ask again
;
CORRUPT	EQU	$
;
	IF	MOD2
	CALL	@VIDON		;enable video memory
	ENDIF
;
	LD	HL,MSG99	;error message
	LD	DE,@VIDEO	;start video memory
	LD	BC,MSG99L	;length of message
	LDIR			;move to video
DEAD	JP	DEAD		;hold here
;
EXIT	LD	HL,PGM1		;PMAILM/CMD
	LD	BC,RUNERR	;error vector
	JP	RUNPGM		;execute program!
;
;	error on run attempt
;
RUNERR	CALL	ERROR		;display error message
	LD	HL,MSG2		;'key to continue'
	CALL	DISPLAY		;display message
	CALL	INKEY		;wait for a key
	JP	MENU		;back to menu
;
;	get support modules
;
*GET	MAILDA			;sort
*GET	MAILDB			;repack
*GET	MAILDC			;convert
*GET	MAILDD			;combine
*GET	MAILDE			;separate
*GET	MAILDF			;review open files
;
	SUBTTL	'<maild/asm - subroutine section>'
;
	PAGE
;
;	display author
;
SHOWWHO	LD	HL,WHOMSG	;text
	CALL	DISPLAY		;display it
	CALL	INKEY		;wait for a key
	JP	MENU		;back to menu
;
WHOMSG	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
	DEFM	'Program by Kim Watt'
	DEFB	CR
	DEFM	'(c)(p) Copyright 1983'
	DEFB	CR
	DEFM	'Breeze/QSD, Inc.'
	DEFB	CR
	DEFM	'Dallas, Texas '
	DEFB	ETX
;
;	clear current counters
;
INITCNT	PUSH	HL		;save
	LD	HL,SYSTEM+32	;start counter
	LD	A,6		;6 bytes
INITCL	LD	(HL),0		;clear a byte
	INC	HL		;bump posit
	DEC	A		;less counter
	JR	NZ,INITCL	;go for count
	POP	HL		;restore
	RET			;done
;
ADDCNTA	PUSH	BC		;save BC / HL
	PUSH	HL
	LD	B,(IY+32)	;get counter A
	LD	H,(IY+33)
	LD	L,(IY+34)
	CALL	INCBHL		;bump it
	LD	(IY+32),B	;update
	LD	(IY+33),H
	LD	(IY+34),L
	POP	HL		;unstack
	POP	BC
	RET
;
ADDCNTB	PUSH	BC		;save
	PUSH	HL
	LD	B,(IY+35)	;get counter B
	LD	H,(IY+36)
	LD	L,(IY+37)
	CALL	INCBHL		;+1
	LD	(IY+35),B	;update
	LD	(IY+36),H
	LD	(IY+37),L
	POP	HL		;unstack
	POP	BC
	RET
;
;	display error message
;
ERROR	ERROR$			;display error
	RET			;done!
;
;	abort operation with BREAK
;
ABORT	LD	HL,ABMSG	;abort message
	CALL	DISPLAY		;display it
	CALL	INKEY		;wait for a key
	JP	MENU		;back to menu
;
	SUBTTL	'<maild/asm - text section>'
;
ABMSG	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
	DEFB	CR
	DEFB	CR
	DEFM	'Operation ABORTED, (KEY):'
	DEFB	ETX
;
MSG1	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
;
	DEFM	'(1) Sort Data File'
	DEFB	SETCUR
	DEFB	12,COLS/2
	DEFM	'(5) Merge Adder>Data'
	DEFB	CR
;
	DEFM	'(2) Re-Pack Data File'
	DEFB	SETCUR
	DEFB	13,COLS/2
	DEFB	'(6) Separate Data>Adder'
	DEFB	CR
;
	DEFM	'(3) Convert File'
	DEFB	SETCUR
	DEFB	14,COLS/2
	DEFM	'(7) Return to Menu'
	DEFB	CR
;
	DEFM	'(4) Review Open Files'
	DEFB	SETCUR
	DEFB	15,COLS/2
	DEFM	'Choice ? '
	DEFB	ETX
;
MSG2	DEFM	'(KEY) to continue:'
	DEFB	ETX
;
MSG99	DEFM	'RUN PMAIL/CMD ONLY!'
MSG99L	EQU	$-MSG99
;
;	3 byte pointer for rewinds
;
REWIND	DEFB	00,00,00
;
;	jump table for menu selections
;
TABLE1	DEFB	'1'
	DEFW	SORT		;sort file
	DEFB	'2'
	DEFW	REPACK		;repack file
	DEFB	'3'
	DEFW	CONVERT		;convert file
	DEFB	'4'
	DEFW	REVIEW		;review files
	DEFB	'5'
	DEFW	COMBINE		;combine files
	DEFB	'6'
	DEFW	SEPARAT		;separate files
	DEFB	'7'
	DEFW	EXIT		;exit to menu
	DEFB	'W'
	DEFW	SHOWWHO
	DEFB	ETBL		;end of table
;
;	program name to link back to menu
;
PGM1	DEFM	'PMAILM/CMD'
	DEFB	SYSDRV
	DEFB	SYSDRVN
	DEFB	ETX
;
PGM2	DEFM	'PMAILS/CMD'
	DEFB	SYSDRV
	DEFB	SYSDRVN
	DEFB	ETX
;
;	open param list for mod II
;
	IF	MOD2
OLIST	DEFW	0
	DEFW	0
	DEFW	0
	DEFB	'W'
	DEFB	0
	DEFB	'E'
	DEFB	0
	DEFB	00
	ENDIF
;
;	buffer to pass sorted table to PMAILS/CMD
;
PASSBUF	DEFM	'xxxxxxxxxxxxxxxxxxxxxx'
;
LSTPAGE	EQU	$&0FF00H	;last even page
BUFFER	EQU	LSTPAGE+100H	;first even free page
FLAGMSK	EQU	BUFFER+100H	;flag mask storage
BUFFX	EQU	FLAGMSK+100H	;extra I/O buffer
FCBX	EQU	BUFFX+100H	;extra FCB block
;
PGMEND	EQU	FCBX+100H	;end of buffers
;
	SUBTTL	'<maild/asm - symbol table>'
;
	END	ENTRY
