; mailb/asm - kjw/bqsd - version 2.00 - 01/83
;
; revised 02/04/83 - kjw
;
	TITLE	'<PowerMAIL - 2.00 source code>'
;
*GET	MAILEQU			;system equates
*GET	MAILDISK		;I/O conditionals
;
	ORG	CODE
*GET	MAILDVRS		;I/O drivers
*GET	MAILMATH		;math subroutines
;
	SUBTTL	'<mailb/asm - add records to file>'
;
	PAGE
;
ENTRY	LD	IY,SYSTEM	;reset system pointer
	CALL	INTEG		;check sys integrety
	LD	A,(IY+31)	;get init flag
	CP	'*'		;system inited?
	JP	NZ,CORRUPT	;nope, run PMAIL!
	RES	0,(IY+0)	;set NO flags in memory
;
MENU	LD	IY,SYSTEM	;reset pointer
	LD	L,(IY+2)	;fetch stack pointer
	LD	H,(IY+3)	;HL = init stack
	LD	SP,HL		;reset it
;
;	load # existing records in ADDER file
;
	LD	B,(IY+4)	;MSB
	LD	H,(IY+5)	;NSB
	LD	L,(IY+6)	;LSB
	LD	DE,MSG1A	;text to place it
	CALL	BINASC		;convert to ascii
;
	CALL	CLRDATA		;clear out data field
	CALL	SHOW		;display data
	CALL	SHOWF		;display flags
;
MENU0	LD	HL,MSG1		;menu options
	CALL	DISPLAY		;display options
	LD	B,1		;one key input
	CALL	GETSTR		;from keyboard
	JP	C,EXIT		;go if BREAK
	JR	Z,ADD		;go default on nil input
	LD	HL,TABLE1	;menu jump table
	CALL	GOTABLE		;go vector if valid entry
	JR	MENU0		;invalid, ask again
;
	PAGE
;
;	exit program back to main menu
;
CORRUPT	EQU	$
;
	IF	MOD2
	CALL	@VIDON		;enable video
	ENDIF
;
	LD	HL,MSG99	;error text
	LD	DE,@VIDEO	;start video memory
	LD	BC,MSG99L	;length of message
	LDIR			;move to video
DEAD	JP	DEAD		;abort here!
;
EXIT	LD	HL,PGM1		;PMAILM/CMD
	LD	BC,RUNERR	;error vector
	JP	RUNPGM		;execute program!
;
;	error on run attempt
;
RUNERR	CALL	ERROR		;display error message
	LD	HL,MSG2		;'key to continue'
	CALL	DISPLAY		;display message
	CALL	INKEY		;wait for a key
	JP	MENU		;back to menu
;
	PAGE
;
;	add record to ADDER file
;
ADD	LD	B,(IY+4)	;fetch # records in adder
	LD	H,(IY+5)	;NSB
	LD	L,(IY+6)	;LSB
	CALL	INCBHL		;increment BHL
	LD	DE,MSG3A	;current record #
	CALL	BINASC		;binary => ascii (24 bit)
	CALL	CLRDATA		;clear out data buffer
;
	PUSH	IY		;save
	CALL	SHOW		;display data
	CALL	SHOWF		;display flags
	POP	IY		;restore
;
;	edit mode to enter data
;
EDIT	LD	HL,MSG3		;current record
	CALL	DISPLAY		;display message
;
	PUSH	IY		;save sys pointer
EDITAGN	CALL	GETINFO		;get record information
	JR	C,EDITAF	;go flags on BREAK
	CP	ESCAPE		;escape key?
	JR	Z,EDITNMR	;edit no more!
EDITAF	CALL	GETFLAG		;get flag information
	JR	C,EDITAGN	;go again on BREAK
EDITNMR	POP	IY		;unstack
;
;	ask user if data is correct
;
EDITIF	LD	HL,MSG4		;'edit, save, cancel?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;one key input
	CALL	GETSTR		;from keyboard
	JP	C,MENU		;BREAK, cancel operation
	JR	Z,SAVE		;default to SAVE record
;
	CALL	UCASE		;char to upper case
	CP	'E'		;edit?
	JR	Z,EDIT		;yes, edit record
	CP	'C'		;cancel?
	JP	Z,MENU		;yes, abort!
	CP	'S'		;save?
	JR	NZ,EDITIF	;neither, ask again
;
SAVE	LD	B,(IY+4)	;get record #
	LD	H,(IY+5)
	LD	L,(IY+6)	;BHL = # records
	CALL	INCBHL		;increment BHL for next
	CALL	SAVEREC		;save record to disk
	JP	MENU		;back to menu
;
;	load flags into memory buffer
;
LOADF	LD	HL,MSG8		;'load from drive?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;one key input
	CALL	GETSTR		;from keyboard
	JP	C,MENU		;go on BREAK
	JR	Z,LOADF		;no defaults!
	CALL	UCASE		;make upper case
	CP	'X'		;abort?
	JP	Z,MENU		;alternate BREAK
	SUB	'0'		;remove ascii
	JR	C,LOADF		;out of range
	CP	DRIVES		;in range?
	JR	NC,LOADF	;invalid, ask again
;
	CALL	LOCFCB		;locate fcb block
	BIT	7,(IX+0)	;available?
	JR	Z,LOADF		;go if not open
	LD	HL,MSG9		;'loading'
	CALL	DISPLAY		;display message
;
;	read first sector to fetch flag names
;
	LD	E,(IX+15)	;get FCB pointer
	LD	D,(IX+16)
	LD	BC,REWIND	;record #0
;
	POSN$			;rewind file
	JP	NZ,FERROR	;go if error
	READ$			;read first record
	JP	NZ,FERROR	;go if error
;
	LD	L,(IX+17)	;get buffer pointer
	LD	H,(IX+18)
	LD	DE,40H		;offset to names
	ADD	HL,DE		;HL => flag names
	LD	DE,FLAGBUF	;flag name buffer
	LD	BC,24*8		;# flags * length
	LDIR			;move into buffer
	SET	0,(IY+0)	;set flags in memory
	LD	HL,MSG10	;completed
	CALL	DISPLAY		;display message
	CALL	INKEY		;wait for a key
	JP	MENU		;back to menu
;
	SUBTTL	'<mailb/asm - subroutine section>'
;
	PAGE
;
;	display author
;
SHOWWHO	LD	HL,WHOMSG	;author message
	CALL	DISPLAY		;display it
	CALL	INKEY		;wait for a key
	JP	MENU		;back to menu!
;
WHOMSG	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
	DEFM	'Program by Kim Watt'
	DEFB	CR
	DEFM	'(c)(p) Copyright 1983'
	DEFB	CR
	DEFM	'Breeze/QSD, Inc.'
	DEFB	CR
	DEFM	'Dallas, Texas '
	DEFB	ETX
;
;	display name of current flag
;
NAMEF	PUSH	BC		;save all
	PUSH	DE
	PUSH	HL
;
	DEC	A		;adjust to 0-23
	LD	L,A		;L = flag #
	LD	H,0		;HL = flag #
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,HL		;*8
	LD	BC,FLAGBUF	;flag buffer
	ADD	HL,BC		;HL => flag text
	LD	DE,FLAGTXT	;point to text
	LD	BC,8		;description length
	LDIR			;move name into string
	LD	HL,FLAGTX	;start of text
	CALL	DISPLAY		;display flag name
;
	POP	HL		;unstack all
	POP	DE
	POP	BC
	RET			;flag displayed
;
	PAGE
;
;	get flags from user
;
GETFLAG	LD	IX,TABLEB	;lower video table
	LD	IY,TABLEB2	;offset table
;
GETFLP	PUSH	IY		;save
	PUSH	IX		;save
	CALL	SHOWF		;display flags
	POP	IX		;unstack
	POP	IY
;
	LD	A,(SYSTEM)	;get system flag
	BIT	0,A		;flags loaded?
	LD	A,(IX+2)	;get flag number
	CALL	NZ,NAMEF	;yes, display name
	LD	L,(IX+0)	;lsb video address
	LD	H,(IX+1)	;msb video address
	LD	A,EDITCUR	;cursor
	LD	(CURCHR),A	;save it
	CALL	KEY		;wait for a key
	RET	C		;return on BREAK
	JP	Z,GETFNX	;go next if ENTER
	CP	ESCAPE		;escape key?
	RET	Z		;yes, go!
;
	LD	HL,TABLE4	;command table
	LD	C,0		;init counter
	CALL	UCASE		;make upper case
	CALL	GOTABLE		;see if valid command
	JR	GETFLP		;nope, wait more
;
RFLAG	INC	C		;+3 = right
LFLAG	INC	C		;+2 = left
DFLAG	INC	C		;+1 = down
UFLAG	EQU	$		;+0 = up
	LD	A,C		;fetch offset
	LD	(FDISY),A	;save into code
	LD	C,(IY+0)	;fetch table entry
FDISY	EQU	$-1
	LD	B,0		;BC = offset
	LD	IX,TABLEB	;video table
	LD	IY,TABLEB2	;start offset table
FDISZ	ADD	IX,BC		;offset to next
	ADD	IY,BC		;add offset
;
;	check for terminator
;
	LD	A,(IX+0)	;fetch a byte
	OR	(IX+1)		;terminator?
	JR	NZ,GETFLP	;go next flag
	JP	SHOWF		;display results!
;
;	set flag
;
SETF	INC	C		;C = 1
;
;	reset flag
;
RESETF	LD	A,(IX+2)	;get flag #
	LD	B,C		;pass flag byte
	LD	DE,BUFFER+125	;start of flags
	LD	C,1		;test bit
GOTF1	DEC	A		;less flag #
	JR	Z,GOTF2		;go if found
	SLA	C		;shift test bit
	JR	NC,GOTF1	;go for byte
	INC	DE		;bump flag byte
	LD	C,1		;reset test bit
	JR	GOTF1		;go next byte
GOTF2	LD	A,C		;fetch test bit
	CPL			;reverse bits
	LD	C,A		;re-save it
	LD	A,(DE)		;read current flag
	AND	C		;reset bit
	LD	(DE),A		;save result
	DEC	B		;reset?
	JR	NZ,GETFNX	;go next if yes
	LD	A,C		;fetch mask
	CPL			;reverse back
	LD	C,A		;save temp
	LD	A,(DE)		;fetch byte
	OR	C		;set bit
	LD	(DE),A		;save result
;
GETFNX	LD	BC,4		;offset to next entry
	JR	FDISZ		;go next entry
;
	PAGE
;
;	get information from user
;
GETINFO	LD	IX,TABLET	;top video table
	LD	IY,TABLET2	;editor vector table
;
;	special inkeyed editor
;
GETINLP	LD	E,(IX+3)	;data offset
	LD	D,BUFFER<-8	;page data
	LD	B,(IX+2)	;length of input
	LD	L,(IX+0)	;fetch lsb video
	LD	H,(IX+1)	;fetch msb video
	LD	A,EDITCUR	;editor cursor
	LD	(CURCHR),A	;save character
	CALL	KEY		;fetch key
	RET	C		;go if BREAK
	JR	Z,EDITMOD	;go if ENTER
	CP	ESCAPE		;escape key?
	RET	Z		;go if yes
;
;	evaluate edit command
;
	LD	C,0		;init for vector
	LD	HL,TABLE2	;jump table for arrows
	CALL	GOTABLE		;go if arrow else right
;
;	not an edit key, go next entry
;
	PUSH	AF		;save key
	LD	A,CHARCUR	;character cursor
	LD	(CURCHR),A	;save it
	POP	AF		;restore key
	LD	C,0		;init count
	LD	L,(IX+0)	;fetch LSB video
	LD	H,(IX+1)	;fetch MSB video
	CALL	ONEKEY		;intercept keyboard drvr
	RET	C		;go on BREAK
	JR	ADVNX		;continue
;
EDITMOD	LD	L,(IX+0)	;get lsb video
	LD	H,(IX+1)	;msb video
	CALL	SPGET		;special $getstr
	RET	C		;go on BREAK
;
ADVNX	LD	BC,4		;offset to next entry
	JR	DISPZ		;continue
;
ADVR	INC	C		;+3 - right
ADVL	INC	C		;+2 - left
ADVD	INC	C		;+1 - down
ADVU	EQU	$		;+0 - up
;
	LD	A,C		;fetch offset
	LD	(DISPY),A	;save for load
	LD	C,(IY+0)	;fetch offset value
DISPY	EQU	$-1
	LD	B,0		;BC = table offset
	LD	IX,TABLET	;top table start
	LD	IY,TABLET2	;top arrow vectors
DISPZ	ADD	IX,BC		;IX => new location
	ADD	IY,BC		;IY => new vectors
;
;	check for completed
;
	LD	A,(IX+0)	;fetch table entry
	OR	(IX+1)		;=0000H?
	JR	NZ,GETINLP	;go if more to do
	RET
;
	PAGE
;
;	display current file data to video
;
SHOW	LD	IX,TABLET	;top video table
;
	IF	MOD2
	CALL	@VIDON		;enable video memory
	ENDIF
;
SHOWLP	LD	E,(IX+0)	;lsb video address
	LD	D,(IX+1)	;msb video address
	LD	C,(IX+2)	;length this field
	LD	L,(IX+3)	;offset into data
	LD	H,BUFFER<-8	;MSB page of data
	LD	B,0		;BC = length of field
	LDIR			;move into video memory
	LD	BC,4		;offset to next entry
	ADD	IX,BC		;IX => next entry
	LD	A,(IX+0)	;check for 0000 term
	OR	(IX+1)		;=000H?
	JR	NZ,SHOWLP	;go if more
;
	IF	MOD2
	CALL	@VIDOFF		;disable video memory
	ENDIF
;
	RET			;done!
;
;	display flags to video
;
SHOWF	LD	IX,TABLEB	;lower video table
	LD	DE,BUFFER+125	;offset to flags
	LD	C,1		;mask test bit
;
	IF	MOD2
	CALL	@VIDON		;enable video memory
	ENDIF
;
SHOWFLP	LD	A,(DE)		;read flag byte
	AND	C		;test current bit
	LD	L,(IX+0)	;fetch lsb video
	LD	H,(IX+1)	;fetch msb video
	LD	A,FLON		;on video char
	JR	NZ,$+4		;go if on
	LD	A,FLOFF		;off video char
	LD	(HL),A		;to video
;
;	move to next bit
;
	SLA	C		;shift left test bit
	JR	NC,SHOWFF	;go if not end
	LD	C,1		;init test bit
	INC	DE		;bump to next flag byte
SHOWFF	INC	IX		;bump table
	INC	IX
	INC	IX
	INC	IX		;4 byte entries
	LD	A,(IX+0)	;check for terminator
	OR	(IX+1)		;=0000H?
	JR	NZ,SHOWFLP	;go if more to do
;
	IF	MOD2
	CALL	@VIDOFF		;disable video memory
	ENDIF
;
	RET			;flags displayed
;
	PAGE
;
;	compute logical record # to save data
;
;	divide BHL in half
;
COMPSEC	SRL	B		;MSB
	RR	H		;NSB
	RR	L		;LSB
	LD	A,80H		;second offset
	RET	C		;existing page
;
;	new page, clear sector
;
	PUSH	BC		;save
	PUSH	HL		;save
	LD	HL,BUFFA	;adder buffer
	LD	B,0		;256 bytes
BUFFIL	LD	(HL),-1		;load FF
	INC	HL		;bump buffer
	DJNZ	BUFFIL		;fill for 256
	POP	HL		;unstack
	POP	BC		;unstack
	XOR	A		;start of page
	RET			;done
;
	PAGE
;
;	save record to disk
;
SAVEREC	LD	IY,SYSTEM	;re-init pointer
	LD	HL,MSG5		;'saving record'
	CALL	DISPLAY		;display message
	LD	DE,FCBA		;adder fcb
	LD	B,(IY+4)	;msb adder total
	LD	H,(IY+5)	;nsb
	LD	L,(IY+6)	;lsb
	CALL	COMPSEC		;compute logical sector
	LD	(PASSE),A	;save buffer offset
	PUSH	AF		;save flags
	CALL	INCBHL		;add one to sector
	LD	(IY+7),B	;save record #
	LD	(IY+8),H
	LD	(IY+9),L
	POP	AF		;restore flags
	JR	NC,ADDOK2	;new sector, go!
	LD	BC,SYSTEM+7	;point to rec #
;
	POSN$			;position to record
	JR	Z,ADDOK1	;go if no error
	CP	1CH		;out of range?
	JR	Z,ADDOK2	;yes, go!
	CP	1DH		;beyond file?
	JP	NZ,SERROR	;save error!
	JR	ADDOK2		;continue
ADDOK1	READ$			;read the record
	JR	NZ,SERROR	;save error!
;
ADDOK2	LD	D,BUFFA<-8	;MSB adder buffer
	LD	E,'$'		;load LSB
PASSE	EQU	$-1
	LD	HL,BUFFER	;stored data
	LD	BC,80H		;data length
	LDIR			;move data into file
	LD	DE,FCBA		;reset fcb pointer
	LD	BC,SYSTEM+7	;point to rec #
;
	POSN$			;position to record
	JR	Z,ADDOK3	;go if no error
	CP	1CH		;out of range?
	JR	Z,ADDOK3	;yes, continue
	CP	1DH		;beyond file?
	JR	NZ,SERROR	;go if error!
;
ADDOK3	WRITE$			;write the record
	JR	NZ,SERROR	;go if error
;
;	update counter of record
;
	LD	B,(IY+4)	;MSB
	LD	H,(IY+5)	;NSB
	LD	L,(IY+6)	;LSB
	CALL	INCBHL		;bump it
	LD	(IY+4),B	;update
	LD	(IY+5),H
	LD	(IY+6),L
	LD	HL,MSG6		;'record saved'
;
ADDOK4	CALL	DISPLAY		;display message
	CALL	INKEY		;wait for a key
	JP	MENU		;back to menu
;
;	error on save
;
SERROR	CALL	ERROR		;display error message
	LD	HL,MSG7		;not saved!
	JR	ADDOK4		;continue
;
;	error on flag load
;
FERROR	CALL	ERROR		;display message
	LD	HL,MSG2		;<KEY> to continue
	JR	ADDOK4		;continue
;
	PAGE
;
;	clear out record buffer for new
;
CLRDATA	LD	HL,BUFFER	;start of data
	LD	DE,BUFFER+1	;start +1
	LD	BC,125		;data length
	LD	(HL),SPACE	;load nil data
	LDIR			;fill record
	LD	(HL),0		;clear flag 0
	LD	C,2		;2 more to do
	LDIR			;3 flag bytes (24 bits)
	RET			;temp buffer cleared
;
;	display error message
;
ERROR	ERROR$			;display error
	RET			;done
;
	SUBTTL	'<mailb/asm - text section>'
;
	PAGE
;
FLAGTX	DEFB	SETCUR
	DEFB	14,00
	DEFB	EOF
FLAGTXT	DEFM	'xxxxxxxx'
	DEFB	ETX
;
MSG1	DEFB	SETCUR
	DEFB	12,000
	DEFB	EOF
;
MSG1A	DEFM	'xxxxxxxx Records in Adder File'
	DEFB	CR
;
	DEFM	')1( Add Record'
	DEFB	SETCUR
	DEFB	13,COLS/2
	DEFM	'(3) Return to Menu'
	DEFB	CR
;
	DEFM	'(2) Load Flag Descriptions'
	DEFB	CR
	DEFM	'Choice ? '
	DEFB	ETX
;
MSG2	DEFM	'(KEY) to continue:'
	DEFB	ETX
;
MSG3	DEFB	SETCUR
	DEFB	12,000
	DEFB	EOF
;
	DEFM	'Enter Record # '
MSG3A	DEFM	'xxxxxxxx'
	DEFB	CR
	DEFB	ETX
;
MSG4	DEFB	SETCUR
	DEFB	14,000
	DEFB	EOF
;
	DEFM	')S(ave, (E)dit, (C)ancel ? '
	DEFB	ETX
;
MSG5	DEFB	SETCUR
	DEFB	13,000
	DEFB	EOF
;
	DEFM	'Saving Record - '
	DEFB	ETX
;
MSG6	DEFM	'Saved, (KEY):'
	DEFB	ETX
;
MSG7	DEFM	'NOT SAVED, (KEY):'
	DEFB	ETX
;
MSG8	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
	DEFB	SETCUR
	DEFB	14,00
	DEFM	'Load Flags From Drive (0-7) ? '
	DEFB	ETX
;
MSG9	DEFB	SETCUR
	DEFB	14,00
	DEFB	EOF
	DEFM	'Loading Flags - '
	DEFB	ETX
;
MSG10	DEFM	'Done, (KEY):'
	DEFB	ETX
;
MSG99	DEFM	'RUN PMAIL/CMD ONLY1'
MSG99L	EQU	$-MSG99
;
	SUBTTL	'<mailb/asm - vector/lookup tables>'
;
	PAGE
;
;	3 bytes of 00 for rewind
;
REWIND	DEFB	00,00,00
;
;	jump table for menu selections
;
TABLE1	DEFB	'1'
	DEFW	ADD		;add record
	DEFB	'2'
	DEFW	LOADF		;load flags
	DEFB	'3'
	DEFW	EXIT		;exit to main menu
	DEFB	'W'
	DEFW	SHOWWHO
	DEFB	ETBL		;end of table
;
;	table of locations for file data
;
;	+0,1	= video memory for field
;	+2	= length of entry
;	+3	= offset into data field
;
	IF	MOD1.OR.MOD3.OR.LDOSSVC
TABLET	DEFW	@VIDEO+192+8	;last
	DEFB	15,0
	DEFW	@VIDEO+192+32	;first
	DEFB	10,15
	DEFW	@VIDEO+256+11	;company
	DEFB	20,25
	DEFW	@VIDEO+320+12	;addr 1
	DEFB	20,45
	DEFW	@VIDEO+320+48	;addr 2
	DEFB	10,65
	DEFW	@VIDEO+384+8	;city
	DEFB	15,75
	DEFW	@VIDEO+384+33	;state
	DEFB	8,90
	DEFW	@VIDEO+384+48	;zip
	DEFB	10,98
	DEFW	@VIDEO+192+50	;data 1
	DEFB	5,108
	DEFW	@VIDEO+256+50	;data 2
	DEFB	12,113
	DEFW	0000H		;terminator
	ENDIF
;
	IF	MOD2
TABLET	DEFW	@VIDEO+240+9	;last
	DEFB	15,0
	DEFW	@VIDEO+240+36	;first
	DEFB	10,15
	DEFW	@VIDEO+320+12	;company
	DEFB	20,25
	DEFW	@VIDEO+400+13	;addr 1
	DEFB	20,45
	DEFW	@VIDEO+400+52	;addr 2
	DEFB	10,65
	DEFW	@VIDEO+480+9	;city
	DEFB	15,75
	DEFW	@VIDEO+480+37	;state
	DEFB	8,90
	DEFW	@VIDEO+480+58	;zip
	DEFB	10,98
	DEFW	@VIDEO+240+60	;data 1
	DEFB	5,108
	DEFW	@VIDEO+320+60	;data 2
	DEFB	12,113
	DEFW	0000H		;terminator
	ENDIF
;
;	lookup table for editing commands
;
;	each entry is offset for UP/DOWN/LEFT/RIGHT
;
TABLET2	DEFB	00,08,28,04	;last
	DEFB	04,08,00,32	;first
	DEFB	00,12,32,36	;company
	DEFB	08,20,36,16	;addr 1
	DEFB	36,28,12,20	;addr 2
	DEFB	12,20,16,24	;city
	DEFB	12,24,20,28	;state
	DEFB	16,28,24,00	;zip
	DEFB	32,36,04,08	;data 1
	DEFB	32,16,08,12	;data 2
	DEFB	00,00,00,00	;terminator
;
;	video tables for flag placement
;
	IF	MOD1.OR.MOD3.OR.LDOSSVC
TABLEB	DEFW	@VIDEO+512+12	;1
	DEFB	1,-1
	DEFW	@VIDEO+512+18	;2
	DEFB	2,-1
	DEFW	@VIDEO+512+24	;3
	DEFB	3,-1
	DEFW	@VIDEO+512+30	;4
	DEFB	4,-1
	DEFW	@VIDEO+512+36	;5
	DEFB	5,-1
	DEFW	@VIDEO+512+42	;6
	DEFB	6,-1
	DEFW	@VIDEO+512+48	;7
	DEFB	7,-1
	DEFW	@VIDEO+512+54	;8
	DEFB	8,-1
	DEFW	@VIDEO+576+12	;9
	DEFB	9,-1
	DEFW	@VIDEO+576+18	;10
	DEFB	10,-1
	DEFW	@VIDEO+576+24	;11
	DEFB	11,-1
	DEFW	@VIDEO+576+30	;12
	DEFB	12,-1
	DEFW	@VIDEO+576+36	;13
	DEFB	13,-1
	DEFW	@VIDEO+576+42	;14
	DEFB	14,-1
	DEFW	@VIDEO+576+48	;15
	DEFB	15,-1
	DEFW	@VIDEO+576+54	;16
	DEFB	16,-1
	DEFW	@VIDEO+640+12	;17
	DEFB	17,-1
	DEFW	@VIDEO+640+18	;18
	DEFB	18,-1
	DEFW	@VIDEO+640+24	;19
	DEFB	19,-1
	DEFW	@VIDEO+640+30	;20
	DEFB	20,-1
	DEFW	@VIDEO+640+36	;21
	DEFB	21,-1
	DEFW	@VIDEO+640+42	;22
	DEFB	22,-1
	DEFW	@VIDEO+640+48	;23
	DEFB	23,-1
	DEFW	@VIDEO+640+54	;24
	DEFB	24,-1
	DEFW	0000H		;terminator
	ENDIF
;
	IF	MOD2
TABLEB	DEFW	@VIDEO+640+13	;1
	DEFB	1,-1
	DEFW	@VIDEO+640+20	;2
	DEFB	2,-1
	DEFW	@VIDEO+640+27	;3
	DEFB	3,-1
	DEFW	@VIDEO+640+34	;4
	DEFB	4,-1
	DEFW	@VIDEO+640+41	;5
	DEFB	5,-1
	DEFW	@VIDEO+640+48	;6
	DEFB	6,-1
	DEFW	@VIDEO+640+55	;7
	DEFB	7,-1
	DEFW	@VIDEO+640+62	;8
	DEFB	8,-1
	DEFW	@VIDEO+720+13	;9
	DEFB	9,-1
	DEFW	@VIDEO+720+20	;10
	DEFB	10,-1
	DEFW	@VIDEO+720+27	;11
	DEFB	11,-1
	DEFW	@VIDEO+720+34	;12
	DEFB	12,-1
	DEFW	@VIDEO+720+41	;13
	DEFB	13,-1
	DEFW	@VIDEO+720+48	;14
	DEFB	14,-1
	DEFW	@VIDEO+720+55	;15
	DEFB	15,-1
	DEFW	@VIDEO+720+62	;16
	DEFB	16,-1
	DEFW	@VIDEO+800+13	;17
	DEFB	17,-1
	DEFW	@VIDEO+800+20	;18
	DEFB	18,-1
	DEFW	@VIDEO+800+27	;19
	DEFB	19,-1
	DEFW	@VIDEO+800+34	;20
	DEFB	20,-1
	DEFW	@VIDEO+800+41	;21
	DEFB	21,-1
	DEFW	@VIDEO+800+48	;22
	DEFB	22,-1
	DEFW	@VIDEO+800+55	;23
	DEFB	23,-1
	DEFW	@VIDEO+800+62	;24
	DEFB	24,-1
	DEFW	0000H		;terminator
	ENDIF
;
;	lookup table for editing flags
;
TABLEB2	DEFB	00,32,92,04	;1	-00
	DEFB	04,36,00,08	;2	-04
	DEFB	08,40,04,12	;3	-08
	DEFB	12,44,08,16	;4	-12
	DEFB	16,48,12,20	;5	-16
	DEFB	20,52,16,24	;6	-20
	DEFB	24,56,20,28	;7	-24
	DEFB	28,60,24,32	;8	-28
;
	DEFB	00,64,28,36	;9	-32
	DEFB	04,68,32,40	;10	-36
	DEFB	08,72,36,44	;11	-40
	DEFB	12,76,40,48	;12	-44
	DEFB	16,80,44,52	;13	-48
	DEFB	20,84,48,56	;14	-52
	DEFB	24,88,52,60	;15	-56
	DEFB	28,92,56,64	;16	-60
;
	DEFB	32,64,60,68	;17	-64
	DEFB	36,68,64,72	;18	-68
	DEFB	40,72,68,76	;19	-72
	DEFB	44,76,72,80	;20	-76
	DEFB	48,80,76,84	;21	-80
	DEFB	52,84,80,88	;22	-84
	DEFB	56,88,84,92	;23	-88
	DEFB	60,92,88,00	;24	-92
	DEFB	00,00,00,00	;terminator
;
;	lookup table for screen editing arrows
;
TABLE2	DEFB	LEFT		;left arrow
	DEFW	ADVL
	DEFB	RIGHT		;right arrow
	DEFW	ADVR
	DEFB	UP		;up arrow
	DEFW	ADVU
	DEFB	DOWN		;down arrow
	DEFW	ADVD
	DEFB	ETBL		;end of table
;
;	table for flag command vectors
;
TABLE4	DEFB	'Y'		;turn flag on?
	DEFW	SETF
	DEFB	'S'		;set flag?
	DEFW	SETF
	DEFB	'N'		;turn flag off?
	DEFW	RESETF
	DEFB	'R'		;reset flag?
	DEFW	RESETF
	DEFB	UP		;up arrow?
	DEFW	UFLAG
	DEFB	DOWN		;down arrow?
	DEFW	DFLAG
	DEFB	LEFT		;left arrow?
	DEFW	LFLAG
	DEFB	RIGHT		;right arrow?
	DEFW	RFLAG
	DEFB	ETBL		;end of table
;
;	program name to link back to menu
;
PGM1	DEFM	'PMAILM/CMD'
	DEFB	SYSDRV
	DEFB	SYSDRVN
	DEFB	ETX
;
;	open param list for mod II
;
	IF	MOD2
OLIST	DEFW	0		;buffer addr
	DEFW	0		;rec buff addr
	DEFW	0		;eof xfer
	DEFB	'W'		;access WRITE
	DEFB	0		;LRL
	DEFB	'E'		;type EXTENDED
	DEFB	0		;open existing only
	DEFB	00		;list terminator
	ENDIF
;
LSTPAGE	EQU	$&0FF00H	;last even page
BUFFER	EQU	LSTPAGE+100H	;first even free page
FLAGBUF	EQU	BUFFER+100H	;flag name buffer
;
PGMEND	EQU	FLAGBUF+100H	;end of buffers
;
	SUBTTL	'<mailb/asm - symbol table>'
;
	END	ENTRY
