; mailequ/asm - kjw/bqsd - version 2.00 - 01/83
;
; revised 02/23/83 - kjw
;
	SUBTTL	'<mailequ/asm - local equivalences>'
;
;	local equivalences
;
ETBL	EQU	000H		;end of table marker
ETX	EQU	003H		;end of text marker
SETCUR	EQU	002H		;cursor address block
CR	EQU	00DH		;carriage return
SPACE	EQU	020H		;blank char ' '
COMMA	EQU	02CH		;comma ','
DELAY	EQU	0C0H		;cursor flash delay
;
	IF	MOD1.OR.MOD3.OR.LDOSSVC
EOF	EQU	01FH		;clear to end of frame
HOME	EQU	01CH		;home cursor
BREAK	EQU	001H		;break key
ESCAPE	EQU	01BH		;escape key
EDITCUR	EQU	08CH		;editor cursor
CHARCUR	EQU	05FH		;char cursor
UP	EQU	05BH		;up arrow
DOWN	EQU	00AH		;down arrow
LEFT	EQU	008H		;left arrow
RIGHT	EQU	009H		;right arrow
SLEFT	EQU	018H		;shift left
SRIGHT	EQU	019H		;shift right
FCLEAR	EQU	01FH		;clear key
FLON	EQU	08FH		;flag ON char
FLOFF	EQU	02EH		;flag OFF char
COLS	EQU	0064		;# video columns
ROWS	EQU	0016		;# video rows
CURON	EQU	00EH		;cursor on char
CUROFF	EQU	00FH		;cursor off char
FREE	EQU	5200H		;begin free memory
@VIDEO	EQU	3C00H		;start video memory
@CURSOR	EQU	4020H		;cursor address
	ENDIF
;
	IF	MOD2
BREAK	EQU	003H		;break key
EOF	EQU	018H		;clear to end of frame
HOME	EQU	01BH		;home cursor
SVC	EQU	008H		;execute SVC call
ESCAPE	EQU	01BH		;escape key
EDITCUR	EQU	019H		;editor cursor
CHARCUR	EQU	05FH		;char cursor
UP	EQU	01EH		;up arrow
DOWN	EQU	01FH		;down arrow
LEFT	EQU	01CH		;left arrow
RIGHT	EQU	01DH		;right arrow
SLEFT	EQU	008H		;backspace
SRIGHT	EQU	009H		;tab
FCLEAR	EQU	001H		;F1 key
FLON	EQU	01BH		;flag ON char
FLOFF	EQU	02EH		;flag OFF char
COLS	EQU	0080		;# video columns
ROWS	EQU	0024		;# video rows
CURON	EQU	001H		;cursor on char
CUROFF	EQU	002H		;cursor off char
FREE	EQU	2200H		;begin free memory
@VIDEO	EQU	0F800H		;start video memory
@VIDON	EQU	0336H		;enable video memory
@VIDOFF	EQU	0339H		;disable video memory
@LOCDCB	EQU	032AH		;locate DCB address
	ENDIF
;
	SUBTTL	'<mailequ/asm - memory assignments>'
;
DBUFF	EQU	FREE		;begin dummy buffer
BUFFA	EQU	DBUFF+100H	;PMAIL/ADD I/O buffer
BUFF0	EQU	BUFFA+100H	;PMAIL/DAT drive 0
BUFF1	EQU	BUFF0+100H	;drive 1
BUFF2	EQU	BUFF1+100H	;drive 2
BUFF3	EQU	BUFF2+100H	;drive 3
BUFF4	EQU	BUFF3+100H	;drive 4
BUFF5	EQU	BUFF4+100H	;drive 5
BUFF6	EQU	BUFF5+100H	;drive 6
BUFF7	EQU	BUFF6+100H	;drive 7
;
;	file control blocks
;
FCBA	EQU	BUFF7+100H	;PMAIL/ADD fcb
FCB0	EQU	FCBA+50		;PMAIL/DAT fcb drive 0
FCB1	EQU	FCB0+50		;drive 1
FCB2	EQU	FCB1+50		;drive 2
FCB3	EQU	FCB2+50		;drive 3
FCB4	EQU	FCB3+50		;drive 4
FCB5	EQU	FCB4+50		;drive 5
FCB6	EQU	FCB5+50		;drive 6
FCB7	EQU	FCB6+50		;drive 7
DATA	EQU	FCB7+50		;begin data tables
;
;	fcb block tables
;
FCBTBL	EQU	DATA		;block lookup tables
BLOCK0	EQU	FCBTBL+16	;start block 0
BLOCK1	EQU	BLOCK0+19
BLOCK2	EQU	BLOCK1+19
BLOCK3	EQU	BLOCK2+19
BLOCK4	EQU	BLOCK3+19
BLOCK5	EQU	BLOCK4+19
BLOCK6	EQU	BLOCK5+19
BLOCK7	EQU	BLOCK6+19
;
;	string input and system data tables
;
STRING	EQU	BLOCK7+19	;string input & temp fcb
SYSTEM	EQU	STRING+64	;start system data table
;
CODE	EQU	SYSTEM+40	;start load code
;
