; maildf/asm - kjw/bqsd - version 2.00 - 01/83
;
; revised 02/03/83 - kjw
;
	SUBTTL	'<maildf/asm - REVIEW module>'
;
	PAGE
;
REVIEW	LD	HL,MSGF1	;'reviewing'
	CALL	DISPLAY
	BIT	7,(IY+0)	;adder available?
	JR	Z,REVDAT	;nope, go data!
	LD	B,(IY+4)	;get # recs in adder
	LD	H,(IY+5)
	LD	L,(IY+6)
	LD	DE,MSGF2A	;text
	CALL	BINASC		;binary => ascii
	LD	HL,MSGF2	;start of text
	CALL	DISPLAY		;display it
	CALL	INKEY		;wait for a key
	JP	C,MENU		;go on BREAK
	CALL	UCASE		;make upper case
	CP	'X'		;alternate BREAK?
	JP	Z,MENU		;go if yes!
;
;	setup loop to display each drive
;
REVDAT	LD	HL,SHOWREV	;subroutine address
	CALL	COMMON		;do all 8 drives
	JP	MENU		;then back to menu direct
;
SHOWREV	BIT	7,(IX+0)	;file available?
	RET	Z		;go if nil file
;
	LD	A,C		;get drive #
	ADD	A,'0'		;make it ascii
	LD	(MSGF4A),A	;to string
;
;	read first sector to get disk name
;
	LD	BC,REWIND	;3 00's
;
	POSN$			;rewind file!
	JP	NZ,FERROR	;go on error!
	READ$			;read first sector
	JP	NZ,FERROR	;go on disk error
;
	LD	L,(IX+17)	;get I/O buff pointer
	LD	H,(IX+18)
	LD	BC,20H		;offset to disk name
	ADD	HL,BC		;HL => name
	LD	DE,MSGF4X	;name text
	LD	BC,16		;name length
	LDIR			;move into text
;
	LD	B,(IX+7)	;get # recs available
	LD	H,(IX+8)
	LD	L,(IX+9)
	PUSH	BC		;save on stack
	PUSH	HL
	LD	DE,MSGF4B	;text
	CALL	BINASC		;binary => ascii
	LD	B,(IX+10)	;get # recs used
	LD	H,(IX+11)
	LD	L,(IX+12)
	PUSH	BC		;save
	PUSH	HL
	LD	DE,MSGF4C	;text
	CALL	BINASC		;ascii to string
	POP	DE		;NSB, LSB
	POP	AF		;A = MSB
	POP	HL		;NSB, LSB avail
	POP	BC		;B = MSB
	LD	C,A		;BHL=total, CDE=used
	CALL	SUBIT		;BHL = BHL - CDE
	LD	DE,MSGF4D	;text
	CALL	BINASC		;binary => ascii
	LD	HL,MSGF4	;start of message
	CALL	DISPLAY		;display it
	LD	HL,MSGF5	;NOT sorted
	BIT	6,(IX+0)	;yes?
	JR	Z,SHOREV1	;go if not
;
	LD	HL,MSGF6	;'sorted by:'
	CALL	DISPLAY		;display it
	LD	A,(IX+13)	;sort field #1
	CALL	SHOWSRT		;display field
	LD	A,(IX+14)	;sort field #2
	CP	-1		;nil?
	JR	Z,SHOREV2	;go if yes
	LD	HL,MSGF7	;gap
	PUSH	AF		;save char
	CALL	DISPLAY		;display gap
	POP	AF		;restore field
	CALL	SHOWSRT		;display field
	JR	SHOREV2		;continue
;
SHOREV1	CALL	DISPLAY		;display message
SHOREV2	LD	HL,MSGF8	;'(KEY)'
	CALL	DISPLAY		;display
	CALL	INKEY		;wait for a key
	JP	C,MENU		;go on BREAK
	CALL	UCASE		;make upper case
	CP	'X'		;alternate BREAK?
	JP	Z,MENU		;go if yes
	RET			;else go next drive!
;
FERROR	CALL	ERROR		;display error message
	JR	SHOREV2		;continue
;
;	display sorted field name
;
SHOWSRT	ADD	A,A		;two byte table
	LD	C,A		;pass to C
	LD	B,0		;BC = table offset
	LD	HL,TABLEF1	;lookup table
	ADD	HL,BC		;HL => vector
	LD	A,(HL)		;get LSB
	INC	HL		;bump table
	LD	H,(HL)		;get MSB
	LD	L,A		;HL = vector
	JP	DISPLAY		;display text
;
	SUBTTL	'<maildf/asm - text/table section>'
;
	PAGE
;
MSGF1	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
	DEFM	'Reviewing Open Files'
	DEFB	ETX
;
MSGF2	DEFB	SETCUR
	DEFB	14,00
	DEFB	EOF
	DEFM	'Adder File Contains '
MSGF2A	DEFM	'xxxxxxxx Records, (KEY):'
	DEFB	ETX
;
MSGF4	DEFB	SETCUR
	DEFB	13,00
	DEFB	EOF
	DEFM	':'
MSGF4A	DEFM	'x - '
MSGF4X	DEFM	'xxxxxxxxxxxxxxxx'
	DEFB	CR
MSGF4B	DEFM	'xxxxxxxx Records - '
MSGF4C	DEFM	'xxxxxxxx Used - '
MSGF4D	DEFM	'xxxxxxxx Free'
	DEFB	CR
	DEFM	'File is '
	DEFB	ETX
;
MSGF5	DEFM	'NOT Sorted'
	DEFB	ETX
;
MSGF6	DEFM	'Sorted by: '
	DEFB	ETX
;
MSGF7	DEFM	' - '
	DEFB	ETX
;
MSGF8	DEFM	' - (KEY):'
	DEFB	ETX
;
;
FIELD0	DEFM	'Last Name'
	DEFB	ETX
FIELD1	DEFM	'First Name'
	DEFB	ETX
FIELD2	DEFM	'Company'
	DEFB	ETX
FIELD3	DEFM	'Address 1'
	DEFB	ETX
FIELD4	DEFM	'Address 2'
	DEFB	ETX
FIELD5	DEFM	'City'
	DEFB	ETX
FIELD6	DEFM	'State'
	DEFB	ETX
FIELD7	DEFM	'Zip'
	DEFB	ETX
FIELD8	DEFM	'Data 1'
	DEFB	ETX
FIELD9	DEFM	'Data 2'
	DEFB	ETX
;
;	lookup table for sorted names
;
TABLEF1	DEFW	FIELD0	;last name
	DEFW	FIELD1	;first name
	DEFW	FIELD2	;company
	DEFW	FIELD3	;address 1
	DEFW	FIELD4	;address 2
	DEFW	FIELD5	;city
	DEFW	FIELD6	;state
	DEFW	FIELD7	;zip
	DEFW	FIELD8	;data 1
	DEFW	FIELD9	;data 2
;
