; pdraw5/asm - kjw/bqsd - revised 05/20/83 dwh
;
;	setup file for disk/tape
;
DSKTAP	LD	IX,FGBYTE	;extra flags
	BIT	7,(IX+0)	;load file?
	JR	Z,DSKTAP1	;go if not
	RES	7,(IX+0)	;turn off flag!
;
;	file specified at entry time, fetch filespec len
;
	LD	B,0		;init length
	LD	L,(IX+1)	;get input pointer
	LD	H,(IX+2)
	LD	DE,DCB		;move filespec here
	PUSH	DE		;save on stack
;
DSKTAPL	LD	A,(HL)		;get string byte
	LD	(DE),A		;to buffer
	CP	_CR		;terminator?
	JR	Z,DSKTAPF	;go if yes
	CP	_ETX		;terminator?
	JR	Z,DSKTAPF	;go if yes
	INC	B		;else bump length
	INC	HL		;bump pointer
	INC	DE		;bump DCB pointer
	JR	DSKTAPL		;continue
;
DSKTAPF	POP	DE		;restore start
	LD	A,B		;any input?
	OR	A		;yes?
	JR	Z,DSKTAP1	;go if nil input!
	RES	7,(IY-1)	;set DISK load
	CALL	DSKTAP2		;adjust filespec/ext
	JP	DSKTAP3		;continue
;
DSKTAP1	BIT	3,(IY-1)	;load or save?
	CALL	NZ,SAVTYPE	;if save, which type?
	LD	HL,DTMSG	;disk/tape prompt
	CALL	PRINT		;display it
	LD	B,1		;1 key input
	CALL	GETSTR		;get response
	JP	Z,RESUME	;cancel routine nil input
;
	CALL	UCASE		;make it upper case
	RES	7,(IY-1)	;set DISK load
	CP	'D'		;disk?
	JP	Z,SETDISK	;set it up
	SET	7,(IY-1)	;set TAPE load
	CP	'T'		;tape?
	JP	NZ,RESUME	;cancel, invalid input
	BIT	5,(IY-1)	;Mod I or III?
	JR	NZ,TAPEIII	;setup for III
;
;	setup for tape I/O - Mod I
;
	LD	HL,TAPE1MG	;deck 1 or 2?
	CALL	PRINT		;display prompt
	LD	B,1		;single key input
	CALL	GETSTR		;get from keyboard
	JP	Z,RESUME	;cancel if nil input
	RES	6,(IY-1)	;set deck #1
	CP	'1'		;deck 1?
	JR	Z,HAVDCK	;go if yes
	CP	'2'		;deck 2?
	JP	NZ,RESUME	;neither, abort!
	SET	6,(IY-1)	;set deck #2
;
;	tape deck defined, prompt for cassette ready
;
HAVDCK	LD	HL,TAPMSG	;prompt message
	CALL	PRINT		;display it
;
;	wait for a key to continue
;
HLDT	LD	A,($KBDR7-1)	;any keys pressed?
	OR	A		;anything pressed?
	JR	NZ,HLDT		;wait for one
	CALL	FLKEY		;wait till enter
;
;	defined cassette to ROM/DOS
;
	BIT	5,(IY-1)	;Mod III?
	RET	NZ		;all set up, continue
	LD	A,(IY-1)	;get flag
	RLCA			;move bit 6 to 0
	RLCA
	AND	1		;bit 0 only
	JP	@DEFCAS		;define cassette
;
;	fetch baud rate of cassette
;
TAPEIII	LD	HL,TAPE3MG	;500/1500 baud ?
	CALL	PRINT		;display prompt
	LD	B,1		;single key input
	CALL	GETSTR		;get from user
	JP	Z,RESUME	;abort on nil input
	XOR	A		;load zero
	LD	($DEFBAU),A	;set 500 baud
	LD	A,(HL)		;get input char
	CALL	UCASE		;make upper case
	RES	4,(IY-1)	;set 500 baud
	CP	'A'		;baud 'A'?
	JP	Z,HAVDCK	;yes, go!
	SET	4,(IY-1)	;set 1500 baud
	CP	'B'		;baud 'B'?
	JP	NZ,RESUME	;neither, abort!
	LD	A,1		;set one
	LD	($DEFBAU),A	;define baud
	JP	HAVDCK		;continue
;
;	setup for disk I/O
;
SETDISK	CALL	ASKFILE		;get filename
DSKTAP3	LD	HL,IOBUFF	;I/O buffer
	LD	B,0		;LRL = 256
	BIT	3,(IY-1)	;load or save?
	JR	NZ,CINIT	;call via 'INIT' if save
	CALL	@OPEN		;open existing file
	RET	Z		;OK, return
;
;	error on open
;
BADSET	POP	HL		;remove RET address
	JP	CERROR		;close and return
;
CINIT	CALL	@INIT		;open old else create
	JR	NZ,BADSET	;go if error
	PUSH	AF		;save carry flag
	CALL	@CLOSE		;close file
	JR	NZ,BADSET	;go if error
	CALL	@OPEN		;open normal
	JR	NZ,BADSET	;go if error
	POP	AF		;restore flags
	RET			;done
;
;	load I/O buffer with 256 bytes data
;
RDBUFF	BIT	7,(IY-1)	;disk or tape?
	JP	Z,@READ		;go if disk
;
;	read buffer from tape
;
	CALL	@TLEAD		;read leader
	LD	B,0		;read 256 bytes
TRDLP	CALL	@TREAD		;read one byte
	LD	(HL),A		;put in the buffer
	INC	HL		;point to next spot
	DJNZ	TRDLP		;do 256 bytes
;
FLAST	DEC	(IY+8)		;reduce counter
	LD	A,(IY+8)	;get the byte
	CALL	ASCII		;decimal ascii
	LD	($VIDEO+125),A	;to video
	NOP
	LD	($VIDEO+126),BC	;rest
	NOP
	XOR	A		;load zero
	RET			;return no error
;
;	write a buffer to disk/tape
;
WRBUFF	LD	A,(IY-1)	;get flag
	AND	7		;low 3 bits only
	JR	Z,WRBUFF2	;go if header done
	XOR	A		;else return Z
	RET			;no error
;
WRBUFF2	LD	A,(IY-1)	;get format
	AND	7		;low 3 bits only
	JR	Z,WRBFGO	;go if compressed
;
	LD	A,(IY+13)	;get desired buffer
	CP	(IY+12)		;same as curent?
	JR	Z,WRBFDO	;do if yes
	XOR	A		;else set Z flag for OK
	RET			;write nothing!
;
;	write current buffer
;
WRBFDO	LD	E,(IY+14)	;get buffer address
	LD	D,(IY+15)
	LD	BC,100H		;length
	LDIR			;move to I/O buffer
	LD	(IY+14),E	;put buffer back
	LD	(IY+15),D
	XOR	A		;set no error
	RET			;return
;
;	write full buffer
;
WRBFGO	BIT	7,(IY-1)	;disk or tape?
	LD	DE,DCB		;file block
	JP	Z,@WRITE	;write to disk
;
;	writing to tape
;
	CALL	@TWLEAD		;write leader and sync
WRTAPE	LD	B,0		;write 256 bytes
	LD	A,'#'		;char for video
	LD	($VIDEO+63),A	;upper right corner
	NOP
;
TWRLP	LD	A,(HL)		;get buffer byte
	CALL	@TWRITE		;write the byte
	INC	HL		;bump buffer
	LD	A,(IY+9)	;get flash counter
	INC	A		;+1
	AND	5FH		;force in range
	LD	(IY+9),A	;update
	JR	NZ,SKFLS	;go if not flash time
	LD	A,($VIDEO+63)	;read video
	NOP
	XOR	3		;reverse #/*
	LD	($VIDEO+63),A	;update video
	NOP
SKFLS	DJNZ	TWRLP		;do 256 bytes
	LD	A,(IY-1)	;get flags
	AND	7		;get type of save
	JP	Z,FLAST		;go if compressed
	XOR	A		;else return OK
	RET			;no error
;
;	fetch type of save from user
;
SAVTYPE	LD	HL,STYPMSG	;type of save
	CALL	PRINT		;display prompt
	LD	B,1		;single key input
	CALL	GETSTR		;get from keyboard
	JR	NZ,CONSTY	;go if any input
CONSBD	POP	HL		;invalid, fix stack
	JP	RESUME		;fix the stack, cancel
;
CONSTY	LD	A,(HL)		;get a byte from user
	SUB	'0'		;remove ascii
	JR	C,CONSBD	;go if out of range
	CP	7		;0-6?
	JR	NC,CONSBD	;cancel, invalid input
	LD	(HL),A		;save here a second
	LD	A,(IY-1)	;get flag byte
	AND	0F8H		;remove low 3 bits
	OR	(HL)		;set which type of oper.
	LD	(IY-1),A	;res-save the type
	AND	7		;check for compressed
	RET	Z		;yes if 0
;
;	not compressed, fetch buffer # to save
;
	LD	HL,BFSVMSG	;which buffer to save
	CALL	PRINT		;display prompt
	LD	B,2		;2 char input
	CALL	GETSTR		;get from user
	JP	Z,CONSBD	;nil input, abort
	CALL	VALUE		;compute the value
	JP	C,CONSBD	;go if invalid
	LD	A,(IY+1)	;get # of buffers
	CP	C		;compare to buff #
	JP	C,CONSBD	;too high of number
	LD	A,C		;get requested #
	OR	A		;request 0?
	JR	Z,CONSBD	;invalid!
	LD	(IY+13),A	;save buffer number
;
	LD	HL,VBUFF	;where to save data
	LD	(IY+14),L	;save pointer
	LD	(IY+15),H	;save address here
	XOR	A		;load zero
	RET			;return no error
;
;	add default extension to filespec
;
ADDEXT	PUSH	DE		;add default extension
	PUSH	HL		;save start
	EX	DE,HL		;swap pointers
	INC	HL		;start +1
	LD	B,9		;9 spaces
EXTLP	LD	A,(HL)		;get a byte
	CP	'/'		;has extension?
	JR	Z,EXTDONE	;done if yes
	JR	C,DOEXT		;add extension if less
	CP	':'		;drive number?
	JR	C,EXTNEXT	;continue if yes
	CP	'A'		;41H
	JR	C,DOEXT		;add extension
EXTNEXT	INC	HL		;next location
	DJNZ	EXTLP		;continue
EXTDONE	POP	HL		;done
	POP	DE
	RET			;DCB restored
;
DOEXT	LD	BC,0FH		;15 bytes
	ADD	HL,BC		;offset to end
	LD	D,H		;pass to DE
	LD	E,L
	INC	DE		;room for /EXT
	INC	DE
	INC	DE
	INC	DE
	INC	BC		;bump length
	LDDR			;make a hole
	POP	HL		;restore extension text
	INC	HL		;+1
	INC	HL
	LD	C,3		;3 chars
	LDDR			;move it in
	LD	A,'/'		;extension indicator
	LD	(DE),A		;to buffer
	POP	DE		;restore filespec start
	RET			;extension added!
;
;	flush partial buffer after write operation
;
FLUSH	CALL	ZIOBUF		;clear I/O buffer
	LD	(IY+16),0	;starting line number
	LD	(IY+17),0
	LD	A,(IY-1)	;get save type
	AND	7		;low 3 bits only
	LD	HL,VBUFF	;data source
	LD	DE,IOBUFF	;dest buffer
	LD	BC,$VIDLEN	;1K data
	DEC	A		;1 = edas
	JP	Z,DOEDAS	;go if yes
	DEC	A		;2 = edtasm
	JP	Z,DOEDTSM	;go if yes
	DEC	A		;3 = basic array
	JP	Z,DOARRAY	;go if yes
	DEC	A		;4 = basic print
	JP	Z,DOBASIC	;go if yes
	DEC	A		;5 = basic data
	JP	Z,PERDATA	;go if yes
;
;	write buffer in load file format
;
DOLDFMT	LD	A,55H		;remark header
	BIT	7,(IY-1)	;tape?
	JR	NZ,DOLDC	;yes
	LD	A,05H		;disk header
	CALL	PBUF		;to buffer
	LD	A,06H		;remark length
DOLDC	CALL	PBUF		;to bufffer
	CALL	HEADER2		;setup header
	PUSH	HL		;pass buffer to IX
	POP	IX		;IX => buffer
;
;	move data to I/O buffer
;
	LD	HL,$VIDEO	;address of video
	CALL	FILBUF		;fill 256 bytes
	INC	H		;bump buffer
	CALL	FILBUF		;256 more
	INC	H		;continue for 1024 bytes
	CALL	FILBUF
	INC	H
	CALL	FILBUF
;
	BIT	7,(IY-1)	;disk/tape?
	JR	Z,TERMDSK	;go if disk
;
;	install entry header on tape
;
	LD	A,78H		;entry header code
	CALL	PBUF		;to buffer
	LD	A,@BASIC2.AND.0FFH ;LSB basic vector
	CALL	PBUF		;to buffer
	LD	A,@BASIC2<-8	;MSB basic vector
	CALL	PBUF		;to buffer
;
;	buffer filled, write to disk/tape
;
FINTERM	LD	HL,IOBUFF	;start I/O buffer
	LD	DE,DCB		;file block
	JP	SENDBUF		;send buffer
;
;	install entry block for disk file
;
TERMDSK	LD	A,02H		;entry block header
	CALL	PBUF		;to buffer
	LD	A,02H		;entry block length
	CALL	PBUF		;to buffer
	LD	A,@DOS.AND.0FFH	;LSB dos vector
	CALL	PBUF		;to buffer
	LD	A,@DOS<-8	;MSB dos vector
	CALL	PBUF		;to buffer
	JR	FINTERM		;completed, write out!
;
;	move data to I/O buffer
;
FILBUF	LD	A,01H		;disk header
	BIT	7,(IY-1)	;tape?
	JR	Z,FILBUFC	;no
	LD	A,3CH		;tape header
FILBUFC	CALL	PBUF		;put in buffer if disk
	XOR	A		;start with 0
	BIT	7,(IY-1)	;check for tape
	JR	NZ,FILBGO	;ok for tape
	LD	A,02H		;make it 2 for disk
FILBGO	CALL	PBUF		;put in buffer
	LD	A,L		;get address LSB
	LD	C,A		;init cksum
	CALL	PBUF		;to buffer
	LD	A,H		;get address MSB
	ADD	A,C		;add
	LD	C,A		;save cksum
	CALL	PBUF		;to buffer
	LD	B,0		;256 bytes to move
FILBDO	LD	A,(IX)		;get a byte
	INC	IX		;bump pointer
	CALL	PBUF		;put in buffer
	ADD	A,C		;add
	LD	C,A		;save cksum
	DJNZ	FILBDO		;do 256 bytes
	BIT	7,(IY-1)	;tape?
	RET	Z		;no
	LD	A,C		;cksum
	JP	PBUF		;put in buffer
	RET			;done
;
;	send char to I/O buffer
;
PBUF	LD	(DE),A		;put in buffer
	INC	E		;bump LSB
	RET	NZ		;not at end yet
;
;	write buffer
;
	PUSH	AF		;save char
	PUSH	HL		;save everything
	PUSH	DE
	PUSH	BC
	LD	HL,IOBUFF	;I/O buffer
	LD	DE,DCB		;file block
	CALL	SENDBUF		;write it out
	CALL	ZIOBUF		;clear I/O buffer
	POP	BC		;restore stack
	POP	DE
	POP	HL
	JR	NZ,$+4		;go if error
	POP	AF		;restore char
	RET			;else OK
	EX	(SP),HL		;leave HL
	POP	HL		;dummy pop char
	JP	CERROR		;go error!
;
;	zero I/O buffer
;
ZIOBUF	LD	HL,IOBUFF	;start buffer
	LD	DE,IOBUFF+1	;start +1
	LD	(HL),0		;load zero
	LD	BC,0FFH		;length page -1
	LDIR			;fill buffer
	RET			;done, return!
;
;	send contents of buffer to file/disk
;
SENDBUF	BIT	7,(IY-1)	;disk/tape
	JP	Z,@WRITE	;write to disk
	JP	WRTAPE		;write to tape
;
;	install header in buffer
;
HEADER2	LD	IX,HEDMESG	;header text
	CALL	SBUFFXX		;move to buffer
	BIT	7,(IY-1)	;tape/disk?
	RET	Z		;return if disk
;
;
HEADER	PUSH	HL		;save registers
	PUSH	DE
	PUSH	BC
	CALL	@TWLEAD		;write leader header
	POP	BC		;restore stack
	POP	DE
	POP	HL
	RET
;
;	install line number in buffer
;
PUTLINE	PUSH	HL		;save these
	PUSH	BC
;
	LD	L,(IY+16)	;get line number lsb
	LD	H,(IY+17)	;msb
	INC	HL		;next number
	LD	(IY+16),L	;update new number
	LD	(IY+17),H
;
;	convert to decimal ascii and write to buffer
;
	LD	IX,TENTBL	;10's place table
;
ATB1	LD	C,(IX+0)	;fetch place lsb
	LD	B,(IX+1)	;fetch place msb
	LD	A,'0'		;init ascii digit
ATB2	OR	A		;clear carry flag
	SBC	HL,BC		;compare to 10's place
	JR	C,ATB3		;go if digit found
	INC	A		;bump digit
	JR	ATB2		;continue
;
ATB3	ADD	HL,BC		;add back last subtract
	OR	80H		;set high bit on digit
	CALL	PBUF		;put in buffer
;
	INC	IX		;bump to next table entry
	INC	IX
	DEC	C		;at table end?
	JR	NZ,ATB1		;go next entry if more
	POP	BC		;unstack
	POP	HL
	LD	A,_SPACE	;send a space
	JP	PBUF		;print this too
;
;	decimal definition table
;
TENTBL	DEFW	10000
	DEFW	1000
	DEFW	100
	DEFW	10
	DEFW	1
;
;	write out file in EDAS format
;
DOEDAS	BIT	7,(IY-1)	;tape?
	JR	Z,DOEDTSM	;continue if disk
	LD	HL,EDASMSG	;invalid if TAPE!
	CALL	PRINT		;display message
	XOR	A		;load zero
	RET			;done
;
;	write out in EDTASM format
;
DOEDTSM	LD	A,0D3H		;header code
	CALL	PBUF		;to buffer
	LD	IX,HEDMESG	;header message
	CALL	SBUFFXX		;to buffer
	BIT	7,(IY-1)	;tape?
	CALL	NZ,HEADER	;turn it on if yes
	CALL	PUTLINE		;put line number
	LD	A,';'		;remark line
	CALL	PBUF		;to buffer
	LD	IX,BUFMSGU	;buffer message
	CALL	SBUFFXX		;to buffer
	LD	A,(IY+12)	;buffer number
	CALL	ASCII		;to ascii
	LD	A,C		;get NSB
	CALL	PBUF		;to buffer
	LD	A,B		;get LSB
	CALL	PBUF		;to buffer
	LD	A,_CR		;carriage return
	CALL	PBUF		;to buffer
	CALL	FLPBF		;fill buffer
	JP	FINTERM		;write last buffer
;
;	write string to buffer
;
SBUFFXX	LD	A,(IX+0)	;get a byte
	CP	_ETX		;end of text?
	RET	Z		;yes, go!
	CALL	PBUF		;put in buffer
	INC	IX		;bump pointer
	JR	SBUFFXX		;continue
;
FLPBF	LD	C,128		;128 iterations
	LD	A,(IY-1)	;get flag
	AND	7		;mask low 3 bits only
	CP	1		;edas?
	JP	Z,FLPBF1	;go if yes
	LD	BC,512		;512 lines long
;
EDTBF1	CALL	PUTLINE		;write line number
	LD	IX,DEFWMG	;DEFW
	CALL	SBUFFXX		;to buffer
;
;	since we are using DEFW opcodes, the bytes
;	must be written in REVERSE ORDER!
;
	PUSH	BC		;save counter
	LD	A,'0'		;leading 0
	CALL	PBUF		;to buffer
	LD	A,(HL)		;get 2'nd byte
	PUSH	AF		;save it
	INC	HL		;bump pointer
	LD	A,(HL)		;get second
	INC	HL		;keep going
	CALL	HEXCV		;to hex ascii
	LD	A,C		;get MSB
	CALL	PBUF		;to buffer
	LD	A,B		;get LSB
	CALL	PBUF		;to buffer
	POP	AF		;get first back
	CALL	HEXCV		;to hex ascii
	LD	A,C		;get MSB
	CALL	PBUF		;to buffer
	LD	A,B		;get LSB
	CALL	PBUF		;to buffer
	LD	A,'H'		;specify HEX
	CALL	PBUF		;to buffer
	LD	A,_CR		;carriage return
	CALL	PBUF		;to buffer
	POP	BC		;get counter back
	DEC	BC		;less byte counter
	LD	A,B		;any more?
	OR	C		;any bits on?
	JP	NZ,EDTBF1	;continue if more
	LD	A,1AH		;EOF marker
	CALL	PBUF		;to buffer
	XOR	A		;load zero
	JP	PBUF		;file terminator
;
FLPBF1	CALL	PUTLINE		;write a line number
	LD	IX,DBMESG	;DB
	CALL	SBUFFXX		;to buffer
	LD	B,8		;8 data bytes / line
	JR	FIBPL3		;continue
;
FIBLP2	LD	A,','		;send comma between
	CALL	PBUF		;to buffer
FIBPL3	PUSH	BC		;save counter
	LD	A,(HL)		;get a byte
	INC	HL		;look to next one
	CALL	ASCII		;decimal ascii
	CALL	PBUF		;MSB to buffer
	LD	A,C		;get NSB
	CALL	PBUF		;to buffer
	LD	A,B		;get LSB
	CALL	PBUF		;to buffer
	POP	BC		;get counter back
	DJNZ	FIBLP2		;do this line
	LD	A,_CR		;send C/R
	CALL	PBUF		;to buffer
	DEC	C		;less counter
	JP	NZ,FLPBF1	;go if more to do
	LD	A,1AH		;end of file marker
	CALL	PBUF		;to buffer
	XOR	A		;correct EOF for TRSDOS
	JP	PBUF		;put in buffer
;
