PDSEDI ;pdsedit1
 	DB	0		;system flag #-1
 SYSTEM
 	DB	0		;system flag #1
 ; bit 7 = 1 = text entry mode
 ; bit 6 = 1 = double wide mode
 ; bit 5 = 1 = buffer contains data not updated to video
 ; bit 4 = 1 = "trace" mode ON
 ; bit 3 = 1 = grid mode ON
 ; bit 2 = 1 = solid angles
 ; bit 1 = 1 = erase mode
 ; bit 0 = 1 = draw mode
 	DB	0		;+1, # memory buffers
 	DB	1		;+2, horizontal speed
 	DB	1		;+3, vertical speed
 	DW	0		;+4+5, graphic mode posit
 	DW	0		;+6+7, text mode position
 	DW	0		;+8+9, temp storage
 	DB	0		;+10 temp
 	DB	0		;+11 temp
 	DB	0		;+12 temp
 	DW	0		;+13+14, temp
 	DW	0		;+15+16, temp
 	DW	0		;+17+18, temp
 MASK	DB	0,0,0,0,0,0,0	;keyboard mask area
 ZERTBL	LD	HL,BUFFTABLE	;set all buffers empty
 	LD	DE,BUFFTABLE+1
 	LD	(HL),0		;99 indicates active
 	LD	BC,229
 	LDIR
 	RET
 ENTRY	LD	IY,SYSTEM	;point to parameter table
 	LD	(STACK),SP	;save stack pointer
 	LD	BC,0
 	CALL	60H
 	CALL	60H
 	LD	HL,3FFFH
 	LD	E,(HL)
 	LD	A,60H
 	LD	(HL),A
 	CP	(HL)
 	LD	(HL),E
 	JP	NZ,KEYS0K
 	LD	HL,KEYS2
 	LD	DE,KEYS3
 	LD	B,32
 EXKEY	LD	A,(HL)
 	EX	AF,AF'
 	LD	A,(DE)
 	LD	(HL),A
 	EX	AF,AF'
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	EXKEY
 KEYS0K	LD	A,(3804H)
 	BIT	3,A		;check for 'S'
 	CALL	NZ,CAPTURE
 	LD	A,(3804H)	;check for "R"
 	AND	4
 	CALL	Z,ZERTBL	;clear the table if not
 	LD	A,(4)		;check for Mod I or III
 	CP	30H		;compare to III
 	SET	5,(IY-1)	;set Mod III
 	LD	HL,(4411H)	;get top of mem III
 	JR	Z,HTPMEM	;if Z, then have it
 	LD	HL,(4049H)	;else get top mem I
 	RES	5,(IY-1)	;set Mod I
 HTPMEM	LD	DE,BUFFER+400H	;point to first buffer
 	OR	A		;clear carry flag
 	SBC	HL,DE		;how much memory avail
 	DEC	H		;don't use last partial
 	LD	A,H		;get into A for math
 	SRL	A		;divide by 2
 	SRL	A		;again, 400H per buffer
 	LD	(IY+1),A	;# buffers available
 	LD	A,(3804H)	;check for "R" again
 	AND	4
 	CALL	Z,CLRBUFF	;don't clear screen
 HALTER	LD	A,(3840H)
 	AND	80H
 	JR	NZ,HALTER
 MENU	LD	HL,MESG		;menu page
 	CALL	PRINT		;display it
 	CALL	FLKEY		;flash <KEY> message
 RESUME	LD	SP,0		;set stack
 STACK	EQU	$-2
 	CALL	PUTBUFF		;draw buffer
 LOOP	CALL	KEY		;wait for a key
 	SET	5,(IY)		;buffer updated
 	CP	141
 	JP	Z,SCREENPRT
 	CP	160
 	JP	Z,SCREENPRT
 	CP	176
 	JP	Z,SCREENPRT
 	BIT	7,(IY)		;text entry mode?
 	JR	Z,NOTTXT	;nope if not set
 	CP	81H		;check for control key
 	JP	C,TEXTENTRY	;put it on if not control
 NOTTXT	AND	7FH		;remove control bit
 	CALL	UCASE		;make it upper case
 	CP	'G'
 	JP	Z,LOAD		;load file
 	CP	'P'
 	JP	Z,SAVE		;save file
 	CP	'B'
 	JP	Z,DOBUFF	;buffer control
 	CP	'A'
 	JP	Z,ANGLES	;angle control
 	CP	'T'
 	JP	Z,TEXTCHG	;toggle text control
 	CP	'R'
 	JP	Z,REVERSE	;reverse character set
 	CP	'S'
 	JP	Z,SKIP		;skip mode
 	CP	'D'
 	JP	Z,DRAW		;draw mode
 	CP	'E'
 	JP	Z,ERASE		;erase mode
 	CP	'M'
 	JP	Z,MENU		;display menu
 	CP	'?'
 	JP	Z,PARAMETERS	;display settings
 	CP	'/'
 	JP	Z,PARAMETERS
 	CP	'F'
 	JP	Z,FLASH		;set flash speed
 	CP	'C'
 	JP	Z,CLEAR
 	CP	'V'
 	JP	Z,VIDEO		;reverse video size
 	CP	'Q'
 	JP	Z,QUIT		;back to dos
 	CP	5BH
 	JP	Z,UARROW
 	CP	5CH
 	JP	Z,DARROW
 	CP	5DH
 	JP	Z,LARROW
 	CP	5EH
 	JP	Z,RARROW
 	CP	18H
 	JP	Z,SUARROW
 	CP	19H
 	JP	Z,SDARROW
 	CP	1AH
 	JP	Z,SLARROW
 	CP	1BH
 	JP	Z,SRARROW
 	CP	'I'
 	JP	Z,LUARROW
 	CP	'K'
 	JP	Z,LDARROW
 	CP	'O'
 	JP	Z,RUARROW
 	CP	'L'
 	JP	Z,RDARROW
 	CP	'@'
 	JP	Z,SPECIAL
 	CP	'`'
 	JP	Z,SPECIAL
 	CP	'W'
 	JP	Z,WATCH
 	CP	'U'
 	JP	Z,TRACE
 	CP	'J'
 	JP	Z,GRID
 	CP	'X'
 	JP	Z,REVVID
 	CP	'Y'
 	JP	Z,REVVID2
 	CP	'Z'
 	JP	Z,MOVVID
 	CP	'H'
 	JR	Z,HOME
 	CP	'N'
 	JP	Z,DUBREV
 	RES	5,(IY)		;buffer not updated
 	JP	LOOP		;invalid key
 HOME	XOR	A
 	LD	(IY+4),A
 	LD	(IY+5),A
 	LD	(IY+6),A
 	LD	(IY+7),A
 	SET	5,(IY)
 	JP	RESUME
 TEXTENTRY
 	CP	18H
 	JP	Z,SUARROW
 	CP	19H
 	JP	Z,SDARROW
 	CP	1AH
 	JP	Z,SLARROW
 	CP	1BH
 	JP	Z,SRARROW
 	CP	5BH
 	JP	Z,UARROWX
 	CP	5CH
 	JP	Z,DARROWX
 	CP	5DH
 	JP	Z,LARROWX
 	CP	5EH
 	JP	Z,RARROWX
 	CP	7FH
 	JR	NZ,TEXTRET
 	LD	A,191
 TEXTRET	PUSH	AF		;save character
 	LD	A,(IY)		;save size
 	PUSH	AF		;save on stack
 	RES	6,(IY)		;force non-adjust for buf
 	CALL	FIGTPOS		;compute the position
 	POP	AF		;restore size
 	LD	(IY),A		;put it back
 	POP	AF		;restore character
 	LD	HL,BUFFER	;put in buffer
 	ADD	HL,DE		;point to position
 	LD	(HL),A		;put it in
 	SET	5,(IY)		;buffer has new data
 	JP	RARROWX		;go next position
 TEXTCHG	LD	A,(IY)		;get text flag
 	XOR	80H		;reverse bit 7
 	LD	(IY),A		;put it back
 	JP	RESUME		;continue
 SIZFIX	BIT	6,(IY)		;set parameters
 	LD	HL,7F3FH	;single	wide video
 	RET	Z
 	LD	HL,4020H	;half the values
 	RET			;must be even number
 SIZFIX2	BIT	7,(IY)		;text entry?
 	JR	Z,SIZFIX
 	LD	HL,3F0FH	;max text entry
 	BIT	6,(IY)		;check size
 	RET	Z
 	LD	HL,1E0FH
 	RET
 SRARROW	CALL	DORARROW	;do it
 	CALL	DORARROW	;again
 	CALL	DORARROW	;real fast
 	JP	RESUME		;continue
 RARROW	BIT	7,(IY)
 	JP	NZ,TEXTRET
 RARROWX	CALL	DORARROW
 	JP	RESUME
 DORARROW	SET	5,(IY)	;new buffer data
 	CALL	SIZFIX		;get max values
 	LD	A,H
 	LD	(RFIX1),A
 	LD	A,L
 	LD	(RFIX2),A
 	BIT	7,(IY)		;text entry ?
 	JR	NZ,RTEXT	;move text
 	LD	A,(IY+5)	;get vertical position
 	CP	127		;compare for last posit
 RFIX1	EQU	$-1		;set from above
 	RET	Z		;don't change
 	INC	A
 	LD	(IY+5),A	;put it back
 	JP	DRAWIT		;draw the new spot
 RTEXT	LD	A,(IY+7)	;vertical text position
 	CP	63		;at end?
 RFIX2	EQU	$-1
 	RET	Z
 	INC	A		;move one more
 RCFIX	LD	(IY+7),A	;update new spot
 	RET
 SLARROW	CALL	DOLARROW
 	CALL	DOLARROW
 	CALL	DOLARROW
 	JP	RESUME
 LARROW	BIT	7,(IY)
 	JP	NZ,TEXTRET
 LARROWX	CALL	DOLARROW
 	JP	RESUME
 DOLARROW	SET	5,(IY)	;updated buffer
 	BIT	7,(IY)		;text entry?
 	JR	NZ,LTEXT
 	LD	A,(IY+5)
 	OR	A
 	RET	Z
 	DEC	A
 	LD	(IY+5),A
 	JP	DRAWIT
 LTEXT	LD	A,(IY+7)
 	OR	A
 	RET	Z
 	DEC	A
 	LD	(IY+7),A
 	RET
 RUARROW	LD	HL,DORARROW
 	LD	DE,DOUARROW
 	JR	ACOMM		;go common
 RDARROW	LD	HL,DORARROW
 	LD	DE,DODARROW
 	JR	ACOMM
 LUARROW	LD	HL,DOLARROW
 	LD	DE,DOUARROW
 	JR	ACOMM
 LDARROW	LD	HL,DOLARROW
 	LD	DE,DODARROW
 ACOMM	LD	(CAL1),HL
 	LD	(CAL2),DE
 	LD	A,(IY)		;save flag
 	PUSH	AF		;save on stack
 	BIT	2,(IY)		;solid?
 	JR	Z,AXLP		;continue if yes
 	AND	0FCH		;mask out low 2 bits
 	LD	(IY),A
 AXLP	LD	A,(IY+2)	;get horiz speed
 ACLOOP	PUSH	AF		;save count
 	CALL	0		;horizontal call
 CAL1	EQU	$-2
 	POP	AF
 	DEC	A
 	JR	NZ,ACLOOP
 	LD	A,(IY+3)	;get vertical speed
 AVLOOP	PUSH	AF		;save counter
 	CALL	0		;vertical call
 CAL2	EQU	$-2
 	POP	AF
 	DEC	A
 	JR	NZ,AVLOOP	;continue
 	POP	AF
 	LD	(IY),A
 	JP	RESUME		;continue
 SUARROW	CALL	DOUARROW
 	CALL	DOUARROW
 	CALL	DOUARROW
 	JP	RESUME
 UARROW	BIT	7,(IY)
 	JP	NZ,TEXTRET
 UARROWX	CALL	DOUARROW
 	JP	RESUME
 DOUARROW	SET	5,(IY)
 	BIT	7,(IY)
 	JR	NZ,UTEXT
 	LD	A,(IY+4)	;get horizontal posit
 	OR	A
 	RET	Z
 	DEC	A
 	LD	(IY+4),A
 	JP	DRAWIT
 UTEXT	LD	A,(IY+6)
 	OR	A
 	RET	Z
 	DEC	A
 	LD	(IY+6),A
 	RET
 SDARROW	CALL	DODARROW
 	CALL	DODARROW
 	CALL	DODARROW
 	JP	RESUME
 DARROW	BIT	7,(IY)
 	JP	NZ,TEXTRET
 DARROWX	CALL	DODARROW
 	JP	RESUME
 DODARROW	SET	5,(IY)
 	BIT	7,(IY)
 	JR	NZ,DTEXT
 	LD	A,(IY+4)
 	CP	47
 	RET	Z
 	INC	A
 	LD	(IY+4),A
 	JP	DRAWIT
 DTEXT	LD	A,(IY+6)
 	CP	15
 	RET	Z
 	INC	A
 	LD	(IY+6),A
 	RET
 DRAWIT	LD	A,(IY)		;get mode
 	AND	3		;anything?
 	RET	Z		;nope, no change
 	LD	A,(IY)		;get it back
 	PUSH	AF		;save on stack
 	BIT	1,A		;check for ERASE
 	RES	6,(IY)		;set single wide
 	JR	NZ,DRWER	;do it
 	CALL	SET		;turn it on
 	JR	DRWER+3
 DRWER	CALL	RESET		;turn it off
 	POP	AF
 	LD	(IY),A		;replace original
 	SET	5,(IY)		;buffer has changed
 	RET
 VIDEO	BIT	6,(IY)		;check for size
 	JR	NZ,GOVIDEO
 	RES	0,(IY+5)
 	RES	0,(IY+7)
 	LD	A,(IY+5)
 	BIT	7,(IY)		;text entry?
 	JR	Z,VIDE1
 	LD	A,(IY+7)
 VIDE1	INC	A
 	CP	L
 	JR	C,GOVIDEO	;don't adjust
 	LD	A,30		;set at right side
 	LD	(IY+7),A	;set text position
 	LD	A,62
 	LD	(IY+5),A	;graphic position
 GOVIDEO	LD	A,(IY)		;get size
 	XOR	40H		;reverse it
 	LD	(IY),A		;put it back
 	SET	5,(IY)		;update the video
 	JP	RESUME		;re-draw it
 GRID	LD	A,(IY)		;get grid flag
 	XOR	8		;reverse bit 3
 	SET	5,A		;set updated screen
 	LD	(IY),A
 	JP	RESUME		;continue
 DOGRID	LD	HL,3C00H
 	LD	(SBUFF),HL	;where to set the points
 	LD	IX,GRIDTABL
 	BIT	6,(IY)
 	JR	NZ,GRIDLP
 	LD	IX,GRIDTABLE
 GRIDLP	LD	D,(IX)		;get horiz
 	LD	E,(IX+1)
 	LD	A,D
 	CP	-1
 	RET	Z
 	LD	A,0C6H
 	LD	(INST+1),A
 	CALL	DOSET
 	INC	IX
 	INC	IX		;next entry
 	JR	GRIDLP
 SKIP	RES	0,(IY)		;reset draw mode
 	RES	1,(IY)		;reset erase mode
 	JR	SCOMM
 ERASE	RES	0,(IY)		;reset draw mode
 	SET	1,(IY)		;set erase mode
 	JR	SCOMM
 DRAW	SET	0,(IY)		;set draw mode
 	RES	1,(IY)		;reset erase mode
 SCOMM	CALL	DRAWIT		;display it
 	JP	RESUME		;continue
 TRACE	LD	A,(IY)		;get flag
 	XOR	10H		;reverse bit 4
 	SET	5,A		;set update flag
 	LD	(IY),A
 	JP	RESUME		;continue
 WATCH	BIT	6,(IY)		;double size?
 	JP	NZ,RESUME	;cancel if yes
 	LD	HL,WATMSG
 	CALL	PRINT
 	LD	B,3
 	CALL	GETSTR
 	SET	1,(IY-1)
 	JR	Z,DOWATCH
 	CALL	VALUE
 	JP	C,RESUME	;invalid
 	LD	A,C
 	LD	(DLYNUM),A	;save it
 	RES	1,(IY-1)
 DOWATCH	LD	HL,BUFFTABLE	;start of table
 	LD	B,(IY+1)
 	LD	C,1
 	SET	5,(IY)		;re-draw video when done
 WATCHLP	LD	A,(HL)		;active?
 	CP	99
 	JR	NZ,WATNXT	;skip this one
 	PUSH	HL		;save these
 	PUSH	BC
 	LD	HL,BUFFER
 	LD	DE,400H		;length of buffer
 	LD	A,C		;get buffer number
 WATLP	ADD	HL,DE
 	DEC	C
 	JR	NZ,WATLP	;position to area
 	LD	DE,3C00H	;video
 	LD	BC,1024		;length of video
 	LDIR			;display buffer
 	NOP
 	CALL	ASCII		;convert buff # to ascii
 	LD	(3C3EH),BC	;put on video
 	POP	BC		;restore counters
 	POP	HL		;next
 	BIT	1,(IY-1)
 	JR	NZ,WAT1		;pause
 	LD	A,0		;get counter
 DLYNUM	EQU	$-1
 	PUSH	BC
 DLYGO	LD	BC,2000H
 	PUSH	AF
 	CALL	60H
 	POP	AF
 	DEC	A
 	JR	NZ,DLYGO
 	POP	BC
 	JR	WATNXT
 WAT1	LD	A,(387FH)	;wait till no keys
 	OR	A
 	JR	NZ,WAT1
 WAT2	LD	A,(3840H)	;now wait till spacebar
 	AND	80H
 	JR	Z,WAT2		;wait here
 WATNXT	LD	A,(3840H)
 	AND	4
 	JP	NZ,RESUME
 	INC	HL
 	INC	C		;bump counter
 	DJNZ	WATCHLP		;do 'em all
 	JP	RESUME		;re-draw screen
 CLEAR	CALL	KEY		;must be pressed again
 	CP	'C'+80H		;control C?
 	JP	NZ,RESUME	;cancel routine
 	CALL	CLRBUFF		;zero the buffer
 	JP	RESUME		;redraw and continue
 SPECIAL	BIT	7,(IY)		;check for text entry
 	JP	Z,LOOP		;non valid in graphics
 	LD	HL,3FC0H	;last line video
 	LD	(4020H),HL	;where cursor goes
 	LD	HL,AREAMSG
 	BIT	5,(IY)		;MOD III?
 	JR	Z,UR01
 	LD	HL,AREAMSG3
 UR01	CALL	PRINT
 	CALL	KEYWT		;get the key
 	CALL	UCASE
 	LD	(IY+8),A	;save this key
 	LD	HL,(4020H)	;get cursor
 	LD	(HL),A		;put on screen
 	CALL	INCHL
 	LD	(4020H),HL
 	CALL	KEYWT		;get next key
 	CALL	UCASE
 	LD	(IY+9),A	;save it here
 	LD	HL,(4020H)
 	LD	(HL),A		;display it
 	CALL	INCHL
 	LD	(4020H),HL	;update cursor
 	LD	HL,ACTMSG1	;action msg (graphic)
 	CALL	PRINT		;display it
 	CALL	KEYWT
 	CALL	UCASE
 	LD	(IY+10),A	;save it
 	LD	HL,(4020H)
 	LD	(HL),A
 	CALL	INCHL
 	LD	(4020H),HL
 AREANXT	CALL	SIZFIX2		;load HL with max val's
 	LD	A,L
 	LD	(IY+15),A	;max top
 	LD	A,H
 	LD	(IY+13),A	;max right
 	XOR	A
 	LD	(IY+12),A	;max left
 	LD	(IY+14),A	;max right
 	LD	A,(IY+8)	;get first indicator
 	CALL	SETARR		;setup arrows
 	JP	NXAREA		;continue
 SETARR	CALL	ADJARR		;adjust arrows
 	CP	5BH
 	JR	Z,ARUP
 	CP	5CH
 	JR	Z,ARDN
 	CP	5DH
 	JR	Z,ARLF
 	CP	5EH
 	JR	Z,ARRT
 	JP	RESUME		;invalid entry
 ARRT	LD	A,(IY+5)	;get horizontal posit
 	BIT	7,(IY)		;text entry?
 	JR	Z,QBZ1
 	LD	A,(IY+7)	;get text posit
 QBZ1	LD	(IY+12),A	;set left boundry
 	RET			;done
 ARLF	LD	A,(IY+5)	;get horizontal
 	BIT	7,(IY)
 	JR	Z,QBZ2
 	LD	A,(IY+7)
 QBZ2	LD	(IY+13),A	;set max right
 	RET
 ARDN	LD	A,(IY+4)	;get vertical
 	BIT	7,(IY)
 	JR	Z,QBZ3
 	LD	A,(IY+6)
 QBZ3	LD	(IY+14),A	;save lower bound
 	RET
 ARUP	LD	A,(IY+4)
 	BIT	7,(IY)
 	JR	Z,QBZ4
 	LD	A,(IY+6)
 QBZ4	LD	(IY+15),A	;top boundry
 	RET
 NXAREA	LD	A,(IY+9)	;second area
 	CP	'A'		;all?
 	JR	Z,CONTAREA	;have the area
 	CP	'L'		;set a line?
 	JR	Z,SETLINE
 	CALL	SETARR		;setup arrows area
 	JR	CONTAREA	;continue
 SETLINE	LD	A,(IY+8)	;get first area
 	CP	5BH
 	JR	Z,VSETUP	;setup for vertical
 	CP	5CH
 	JR	Z,VSETUP
 	LD	A,(IY+6)
 	LD	(IY+14),A
 	LD	(IY+15),A
 	JR	CONTAREA
 VSETUP	LD	A,(IY+7)
 	LD	(IY+12),A
 	LD	(IY+13),A
 CONTAREA
 	LD	A,(IY+10)	;get action key
 	JR	AREATXT		;do it in text
 ADJARR	CP	18H
 	RET	C
 	CP	1CH
 	RET	NC
 	ADD	A,67
 	RET
 AREATXT	LD	HL,PERFILL
 	CP	'F'
 	JR	Z,GOTPER
 	LD	HL,PERREV
 	CP	'R'
 	JR	Z,GOTPER
 	LD	HL,PERCLR
 	CP	'C'
 	JR	Z,GOTPER
 	CP	'D'
 	LD	HL,PERDUP
 	JP	NZ,RESUME	;forget it
 GOTPER	LD	(PERCALL),HL	;save calling address
 	LD	A,(IY+12)	;save left area
 	LD	(IY+8),A	;save it here
 	CALL	FIGTPOS		;get position
 	LD	HL,BUFFER
 	ADD	HL,DE
 	LD	A,(HL)
 	LD	(IY+9),A	;save it here
 PERLP	LD	L,(IY+12)	;get left
 	LD	H,(IY+14)	;get top
 	CALL	FIGPOS		;compute position
 	LD	HL,BUFFER
 	ADD	HL,DE
 	CALL	0		;set from above
 PERCALL	EQU	$-2
 	LD	A,(IY+12)	;get left
 	INC	A		;bump it
 	LD	(IY+12),A	;re-save it
 	CP	(IY+13)		;check for bounds
 	JR	Z,PERLP		;go if the same
 	JR	C,PERLP		;or less
 	LD	A,(IY+8)	;restore value
 	LD	(IY+12),A	;starting position
 	LD	A,(IY+14)	;get vertical
 	INC	A		;bump this
 	LD	(IY+14),A	;re-save it
 	CP	(IY+15)		;check for bounds
 	JR	Z,PERLP		;go if the same
 	JR	C,PERLP		;or less
 	JP	RESUME		;done now
 PERFILL	LD	(HL),191	;all bits on
 	RET			;done
 PERREV	LD	A,(HL)		;grahics?
 	BIT	7,A		;graphic bit on?
 	RET	Z		;don't do if not
 	CPL			;reverse it
 	SET	7,A
 	RES	6,A
 	LD	(HL),A		;re-display it
 	RET
 PERCLR	LD	(HL),80H	;all bits off
 	RET
 PERDUP	LD	A,(IY+9)	;get duplicate byte
 	LD	(HL),A		;display it
 	RET			;done
 QUIT	CALL	KEY
 	CP	'Q'+80H
 	JP	NZ,RESUME
 	LD	HL,QUITMSG
 	CALL	PRINT		;display it
 	JP	402DH		;back to DOS
 CLRBUFF	LD	HL,BUFFER	;clear the buffer
 	LD	DE,BUFFER+1
 	LD	BC,1023
 	LD	(HL),80H	;graphic "spaces"
 	LDIR
 	NOP
 	SET	5,(IY)		;new data
 	RET
 REVERSE	LD	HL,BUFFER	;where data lies
 	LD	BC,1024		;1k of data
 REVLP	LD	A,(HL)		;get a byte
 	BIT	7,A		;graphics?
 	JR	Z,REVNXT	;skip if yes
 	CPL			;reverse all bits
 	SET	7,A		;turn on graphic
 	RES	6,A
 	LD	(HL),A		;put it back
 REVNXT	INC	HL		;bump buffer
 	DEC	BC
 	LD	A,B		;any more?
 	OR	C
 	JR	NZ,REVLP
 	SET	5,(IY)		;new data
 	JP	RESUME		;re-draw it now
 PUTBUFF	BIT	5,(IY)		;new data ?
 	RET	Z		;forget this
 	BIT	5,(IY-1)	;check for Mod I or III
 	JR	NZ,PUTIII	;do it special
 	BIT	6,(IY)		;check size
 	LD	A,0		;for the port
 	JR	Z,PUTI		;have the byte
 	LD	A,8		;else set double wide
 PUTI	OUT	(0FFH),A	;set the hardware
 	JR	PUTCONT		;continue
 PUTIII	BIT	6,(IY)		;get size
 	LD	A,20H		;single byte
 	JR	Z,PUTIIIX
 	LD	A,24H		;set double wide
 PUTIIIX	OUT	(0ECH),A	;do it
 PUTCONT	JP	Z,PUTSNG	;do it LDIR
 	LD	HL,BUFFER	;data area
 	LD	DE,3C00H	;video
 	LD	B,16		;16 lines to do
 PUTLPO	LD	C,32		;32 chars / line
 	PUSH	HL
 	PUSH	DE
 PUTLPI	LD	A,(HL)		;get data byte
 	LD	(DE),A		;to the video
 	NOP
 	INC	HL		;bump buffer
 	INC	DE		;bump video twice
 	INC	DE
 	DEC	C		;do this line
 	JR	NZ,PUTLPI	;continue
 	POP	DE		;get start pointers back
 	POP	HL
 	PUSH	BC		;save count
 	LD	BC,40H		;next line
 	ADD	HL,BC		;add to both
 	EX	DE,HL
 	ADD	HL,BC
 	EX	DE,HL
 	POP	BC
 	DJNZ	PUTLPO		;continue 16 rows
 RESPUT	RES	5,(IY)		;data updated
 	BIT	3,(IY)		;grid ON
 	CALL	NZ,DOGRID	;display if yes
 	BIT	4,(IY)		;"trace" ON?
 	RET	Z
 	LD	HL,3C00H+57	;single wide start
 	BIT	6,(IY)		;check video flag
 	JR	Z,TRSNG
 	LD	L,50		;double wide start
 TRSNG	LD	DE,GXMSG	;text table (8 bytes)
 	LD	A,20H		;space
 	BIT	7,(IY)		;text entry?
 	JR	NZ,TRSGG
 	LD	A,'>'
 TRSGG	EX	AF,AF'		;store it here
 	LD	A,(IY+5)	;graphic horizontal
 	CALL	PUTTRACE	;display it
 	LD	A,(IY+4)	;graphic vertical
 	CALL	PUTTRACE
 	LD	A,20H		;space
 	BIT	7,(IY)		;text entry?
 	JR	Z,TRSGY
 	LD	A,'>'
 TRSGY	EX	AF,AF'
 	LD	A,(IY+7)	;text horizontal
 	CALL	PUTTRACE
 	LD	A,(IY+6)	;text vertical
 PUTTRACE
 	PUSH	HL		;save video start
 	PUSH	AF		;save value
 	EX	AF,AF'		;get "active" symbol
 	LD	(HL),A		;display it
 	NOP
 	EX	AF,AF'		;re-save it
 	CALL	INCHL		;point to next posit
 	LD	A,(DE)		;get string byte
 	INC	DE		;bump it
 	LD	(HL),A		;display it
 	NOP
 	CALL	INCHL		;bump HL
 	LD	A,(DE)		;get 2nd string byte
 	INC	DE
 	LD	(HL),A		;display it
 	NOP
 	CALL	INCHL		;bump HL
 	LD	(HL),'='	;right arrow
 	NOP
 	CALL	INCHL		;bump it
 	POP	AF		;restore character
 	CALL	ASCII		;convert to decimal ascii
 	LD	(HL),A		;display it
 	NOP
 	CALL	INCHL
 	LD	(HL),C
 	NOP
 	CALL	INCHL
 	LD	(HL),B		;on screen now
 	NOP
 	POP	HL		;restore original
 	LD	BC,40H		;next line down
 	ADD	HL,BC		;point to it
 	RET			;done
 INCHL	INC	HL		;bump video
 	BIT	6,(IY)		;double wide?
 	RET	Z		;skip if not
 	INC	HL		;else bump again
 	RET
 CAPTURE	LD	HL,3C00H
 	LD	DE,BUFFER
 	LD	BC,400H
 	LDIR
 	SET	5,(IY)
 	RET
