PDREDI ;redit/asm
 DISKTAPE
 	BIT	3,(IY-1)	;load or save?
 	CALL	NZ,SAVTYPE	;if save, which type?
 	LD	HL,DTMSG	;disk/tape prompt
 	CALL	PRINT		;display it
 	LD	B,1		;1 key input
 	CALL	GETSTR		;get response
 	JP	Z,RESUME	;cancel routine
 	CALL	UCASE		;make it upper case
 	RES	7,(IY-1)	;set DISK load
 	CP	'D'
 	JP	Z,SETUPDSK	;set it up
 	SET	7,(IY-1)	;set TAPE load
 	CP	'T'
 	JP	NZ,RESUME	;cancel, invalid input
 	BIT	5,(IY-1)	;Mod I or III?
 	JR	NZ,TAPEIII	;setup for III
 	LD	HL,TAPE1MSG	;deck 1 or 2?
 	CALL	PRINT
 	LD	B,1
 	CALL	GETSTR
 	JP	Z,RESUME	;cancel
 	RES	6,(IY-1)	;set deck #1
 	CP	'1'		;deck 1?
 	JR	Z,HAVDCK
 	CP	'2'
 	JP	NZ,RESUME
 	SET	6,(IY-1)
 HAVDCK	LD	HL,TAPMSG
 	CALL	PRINT
 HLDT	LD	A,(387FH)	;any keys pressed?
 	OR	A
 	JR	NZ,HLDT
 	CALL	FLKEY		;wait till enter
 	BIT	5,(IY-1)	;Mod III?
 	RET	NZ		;all set up
 	LD	A,(IY-1)	;get flag
 	RLA			;move bit 6 to 0
 	RLA
 	RLA
 	AND	1		;bit 0 only
 	JP	212H		;define cassette
 TAPEIII	LD	HL,TAPE3MSG	;500/1500 baud ?
 	CALL	PRINT
 	LD	B,1
 	CALL	GETSTR
 	JP	Z,RESUME
 	XOR	A
 	LD	(16913),A	;set 500 baud
 	LD	A,(HL)
 	CALL	UCASE
 	RES	4,(IY-1)	;set 500 baud
 	CP	'A'
 	JP	Z,HAVDCK
 	SET	4,(IY-1)
 	CP	'B'
 	JP	NZ,RESUME
 	LD	A,1
 	LD	(16913),A
 	JP	HAVDCK
 SETUPDSK
 	CALL	ASKFILE		;get filename
 	LD	HL,IOBUFF	;I/O buffer
 	LD	B,0		;LRL = 256
 	BIT	3,(IY-1)	;load or save?
 	JR	NZ,CINIT	;call via 'INIT'
 	CALL	4424H		;open existing file
 	RET	Z		;OK, return
 BADSET	POP	HL		;remove RET address
 	JP	CERROR		;close and return
 CINIT	CALL	4420H		;open old else create
 	RET	Z		;OK
 	JR	BADSET		;close, cancel
 RDBUFF	BIT	7,(IY-1)	;disk or tape?
 	JP	Z,4436H		;read a sector
 	CALL	296H		;read leader
 	LD	B,0		;read 256 bytes
 TRDLP	CALL	235H		;read one byte
 	LD	(HL),A		;put in the buffer
 	INC	HL		;point to next spot
 	DJNZ	TRDLP		;do 256 bytes
 FLAST	DEC	(IY+8)		;reduce counter
 	LD	A,(IY+8)	;get the byte
 	CALL	ASCII		;decimal ascii
 	LD	(3C7DH),A
 	LD	(3C7EH),BC
 	XOR	A
 	RET			;return no error
 WRBUFF	LD	A,(IY-1)	;get flag
 	AND	7		;low 3 bits only
 	JR	Z,WRBUFF2
 	XOR	A
 	RET
 WRBUFF2	LD	A,(IY-1)	;get format
 	AND	7
 	JR	Z,WRBFGO	;go if compressed
 	LD	A,(IY+13)	;get desired buffer
 	CP	(IY+12)		;same as curent?
 	JR	Z,WRBFDO	;do if yes
 	XOR	A		;else set Z flag for OK
 	RET
 WRBFDO	LD	E,(IY+14)	;get buffer address
 	LD	D,(IY+15)
 	LD	BC,100H		;move to here
 	LDIR
 	LD	(IY+14),E	;put buffer back
 	LD	(IY+15),D
 	XOR	A
 	RET
 WRBFGO	BIT	7,(IY-1)	;disk or tape?
 	JP	Z,4439H		;write to disk
 	CALL	287H		;write leader and sync
 WRTAPE	LD	B,0		;write 256 bytes
 	LD	A,'#'
 	LD	(3C3EH),A
 TWRLP	LD	A,(HL)		;get buffer byte
 	CALL	264H		;write the byte
 	INC	HL		;bump buffer
 	LD	A,(IY+9)	;get flash counter
 	INC	A
 	AND	5FH
 	LD	(IY+9),A
 	JR	NZ,SKFLS
 	LD	A,(3C3FH)
 	XOR	3
 	LD	(3C3FH),A
 SKFLS	DJNZ	TWRLP		;do 256
 	LD	A,(IY-1)
 	AND	7
 	JP	Z,FLAST
 	XOR	A
 	RET
 SAVTYPE	LD	HL,STYPMSG	;type of save
 	CALL	PRINT
 	LD	B,1
 	CALL	GETSTR
 	JR	NZ,CONSTY
 CONSBD	POP	HL
 	JP	RESUME		;fix the stack, cancel
 CONSTY	LD	A,(HL)		;get a byte
 	SUB	30H		;remove ascii
 	JR	C,CONSBD
 	CP	6
 	JR	NC,CONSBD	;cancel, invalid input
 	LD	(HL),A		;save here a second
 	LD	A,(IY-1)	;get flag byte
 	AND	0F8H		;remove low 3 bits
 	OR	(HL)		;set which type of oper.
 	LD	(IY-1),A	;res-save the type
 	AND	7		;check for compressed
 	RET	Z		;yes if 0
 	LD	HL,BFSVMSG	;which buffer to save
 	CALL	PRINT
 	LD	B,2
 	CALL	GETSTR
 	JP	Z,CONSBD	;invalid
 	CALL	VALUE		;compute the value
 	JP	C,CONSBD
 	LD	A,(IY+1)	;get # of buffers
 	CP	C
 	JP	C,CONSBD	;too high of number
 	LD	A,C		;get requested #
 	OR	A
 	JR	Z,CONSBD
 	LD	(IY+13),A	;save it here
 	LD	HL,BUFFER	;where to save data
 	LD	(IY+14),L
 	LD	(IY+15),H	;save address here
 	XOR	A
 	RET
 ADDEXT	PUSH	DE		;add default extension
 	PUSH	HL
 	EX	DE,HL
 	INC	HL
 	LD	B,9		;9 spaces
 EXTLP	LD	A,(HL)		;get a byte
 	CP	'/'		;has extension?
 	JR	Z,EXTDONE	;done if yes
 	JR	C,DOEXT		;add extension
 	CP	':'		;drive number?
 	JR	C,EXTNEXT	;continue if yes
 	CP	'A'		;41H
 	JR	C,DOEXT		;add extension
 EXTNEXT	INC	HL		;next location
 	DJNZ	EXTLP		;continue
 EXTDONE	POP	HL		;done
 	POP	DE
 	RET			;DCB restored
 DOEXT	LD	BC,0FH		;15 bytes
 	ADD	HL,BC
 	LD	D,H
 	LD	E,L
 	INC	DE
 	INC	DE
 	INC	DE
 	INC	DE
 	INC	BC
 	LDDR
 	POP	HL
 	INC	HL
 	INC	HL
 	LD	C,3
 	LDDR
 	LD	A,2FH
 	LD	(DE),A
 	POP	DE
 	RET
 FLUSH	CALL	ZIOBUF
 	LD	(IY+16),0	;starting line number
 	LD	(IY+17),0
 	LD	A,(IY-1)
 	AND	7		;low 3 bits only
 	LD	HL,BUFFER	;data source
 	LD	DE,IOBUFF	;dest buffer
 	LD	BC,400H		;1K data
 	DEC	A		;1 = edas
 	JP	Z,DOEDAS
 	DEC	A		;2 = edtasm
 	JP	Z,DOEDTASM
 	DEC	A		;3 = basic
 	JP	Z,DOBASIC
 	DEC	A
 	JP	Z,PERDATA
 DOLOADFMT
 	LD	A,5
 	CALL	PBUF
 	LD	A,6
 	CALL	PBUF
 	CALL	HEADER2		;setup header
 	PUSH	HL		;pass buffer to IX
 	POP	IX
 	LD	HL,3C00H	;address
 	CALL	FILBUF		;fill 256 bytes
 	INC	H
 	CALL	FILBUF
 	INC	H
 	CALL	FILBUF
 	INC	H
 	CALL	FILBUF
 	BIT	7,(IY-1)
 	JR	Z,TERMDSK
 	LD	A,78H
 	CALL	PBUF
 	LD	A,19H
 	CALL	PBUF
 	LD	A,1AH
 	CALL	PBUF
 FINTERM	LD	HL,IOBUFF
 	LD	DE,DCB
 	JP	SENDBUFF
 TERMDSK	LD	A,2
 	CALL	PBUF
 	LD	A,2
 	CALL	PBUF
 	LD	A,2DH
 	CALL	PBUF
 	LD	A,40H
 	CALL	PBUF
 	JR	FINTERM
 FILBUF	LD	A,1		;disk header
 	BIT	7,(IY-1)
 	CALL	Z,PBUF		;put in buffer
 	XOR	A		;start with 0
 	BIT	7,(IY-1)	;check for tape
 	JR	NZ,FILBGO	;ok for tape
 	LD	A,2		;make it 2 for disk
 FILBGO	CALL	PBUF		;put in buffer
 	LD	A,L		;get address
 	CALL	PBUF
 	LD	A,H
 	CALL	PBUF		;lsb-msb
 	LD	B,0		;256 bytes to move
 FILBDO	LD	A,(IX)		;get a byte
 	INC	IX
 	CALL	PBUF		;put in buffer
 	DJNZ	FILBDO		;do 256
 	RET			;done
 PBUF	LD	(DE),A		;put in buffer
 	INC	E		;bump it
 	RET	NZ		;not at end yet
 	PUSH	HL		;save everything
 	PUSH	DE
 	PUSH	BC
 	LD	HL,IOBUFF
 	LD	DE,DCB
 	CALL	SENDBUFF	;write it out
 	CALL	ZIOBUF
 	POP	BC
 	POP	DE
 	POP	HL
 	JP	NZ,CERROR	;error
 	RET
 ZIOBUF	LD	HL,IOBUFF
 	LD	DE,IOBUFF+1
 	LD	(HL),0
 	LD	BC,0FFH
 	LDIR
 	RET
 SENDBUFF	BIT	7,(IY-1)
 	JP	Z,4439H		;write to disk
 	JP	WRTAPE		;write to tape
 HEADER2	LD	IX,HEDMESG
 	CALL	SBUFFXX
 	BIT	7,(IY-1)
 	RET	Z
 	LD	A,3CH
 	CALL	PBUF		;data header
 HEADER	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	CALL	287H		;write header
 	POP	BC
 	POP	DE
 	POP	HL
 	RET
 PUTLINE	PUSH	HL		;save these
 	PUSH	BC
 	LD	L,(IY+16)	;get line number
 	LD	H,(IY+17)	;msb
 	INC	HL
 	LD	(IY+16),L	;update new number
 	LD	(IY+17),H
 	LD	IX,TENTBL	;table
 A4B7B	LD	C,(IX)
 	INC	IX
 	LD	B,(IX)
 	INC	IX
 	PUSH	IX
 	LD	A,2FH
 	PUSH	DE
 A4B84	INC	A
 	LD	D,H
 	LD	E,L
 	ADD	HL,BC
 	JR	C,A4B84
 	EX	DE,HL
 	POP	DE
 	POP	IX
 	SET	7,A		;set high bit
 	CALL	PBUF		;put in buffer
 	INC	C
 	JR	NZ,A4B7B	;do whole thing
 	POP	BC		;restore stack
 	POP	HL
 	LD	A,20H		;send a space
 	JP	PBUF		;print this too
 TENTBL	DW	-10000,-1000,-100,-10,-1
 DOEDAS	BIT	7,(IY-1)	;tape?
 	JR	Z,DOEDTASM	;continue if disk
 	LD	HL,EDASMSG	;invalid
 	CALL	PRINT
 	XOR	A
 	RET			;done
 DOEDTASM	LD	A,0D3H
 	CALL	PBUF
 	LD	IX,HEDMESG
 	CALL	SBUFFXX
 	BIT	7,(IY-1)	;tape?
 	CALL	NZ,HEADER	;turn it on
 	CALL	PUTLINE		;put line number
 	LD	A,';'
 	CALL	PBUF
 	LD	IX,BUFMSGU
 	CALL	SBUFFXX
 	LD	A,(IY+12)	;buffer number
 	CALL	ASCII
 	LD	A,C
 	CALL	PBUF
 	LD	A,B
 	CALL	PBUF
 	LD	A,0DH
 	CALL	PBUF
 	CALL	FLPBF		;fill buffer
 	JP	FINTERM		;write last buffer
 SBUFFXX	LD	A,(IX)		;get a byte
 	CP	3
 	RET	Z
 	CALL	PBUF		;put in buffer
 	INC	IX
 	JR	SBUFFXX
 FLPBF	LD	C,128		;128 iterations
 	LD	A,(IY-1)	;get flag
 	AND	7		;mask low 3 bits only
 	CP	1		;edas?
 	JP	Z,FLPBF1	;go if yes
 	LD	BC,512		;512 lines long
 EDTBF1	CALL	PUTLINE		;write line number
 	LD	IX,DEFWMESG
 	CALL	SBUFFXX
 	PUSH	BC
 	LD	A,'0'
 	CALL	PBUF
 	LD	A,(HL)		;get 2'nd byte
 	PUSH	AF		;save it
 	INC	HL
 	LD	A,(HL)
 	INC	HL		;keep going
 	CALL	HEXCV
 	LD	A,C
 	CALL	PBUF
 	LD	A,B
 	CALL	PBUF
 	POP	AF		;get first back
 	CALL	HEXCV
 	LD	A,C
 	CALL	PBUF
 	LD	A,B
 	CALL	PBUF
 	LD	A,'H'		;specify HEX
 	CALL	PBUF
 	LD	A,0DH		;C/R
 	CALL	PBUF
 	POP	BC		;get counter back
 	DEC	BC
 	LD	A,B
 	OR	C		;any bits on?
 	JP	NZ,EDTBF1	;continue
 	LD	A,1AH		;EOF marker
 	CALL	PBUF
 	XOR	A
 	JP	PBUF
 FLPBF1	CALL	PUTLINE		;write a line number
 	LD	IX,DBMESG
 	CALL	SBUFFXX
 	LD	B,8		;8 data bytes
 	JR	FIBPL3		;continue
 FIBLP2	LD	A,','		;send comma between
 	CALL	PBUF
 FIBPL3	PUSH	BC		;save counter
 	LD	A,(HL)		;get a byte
 	INC	HL		;look to next one
 	CALL	ASCII		;decimal ascii
 	CALL	PBUF
 	LD	A,C		;MSB
 	CALL	PBUF
 	LD	A,B
 	CALL	PBUF
 	POP	BC		;get counter back
 	DJNZ	FIBLP2		;do this line
 	LD	A,0DH		;send C/R
 	CALL	PBUF
 	DEC	C
 	JP	NZ,FLPBF1
 	LD	A,1AH		;end of file marker
 	CALL	PBUF		;print it
 	XOR	A		;correct EOF for TRSDOS
 	JP	PBUF		;put in buffer
 BLINE	LD	A,(IY+16)	;get line number
 	INC	A		;bump it
 	LD	(IY+16),A	;update it
 	PUSH	BC		;save BC
 	CALL	ASCII		;decimal ascii
 	CALL	PBUF
 	LD	A,C		;get MSB
 	CALL	PBUF		;to buffer
 	LD	A,B
 	CALL	PBUF
 	POP	BC		;restore it
 	LD	A,20H		;now a space
 	JP	PBUF		;put and return
 DOBASIC	BIT	7,(IY-1)	;tape?
 	CALL	NZ,HEADER	;turn it on
 	CALL	BLINE		;basic line number
 	LD	IX,BASHMSG	;basic header
 	CALL	SBUFFXX
 	LD	B,16		;16 loops on video
 DOBSLP	PUSH	BC		;save counter
 	CALL	BLINE		;basic line #
 	LD	IX,PRINTMESG
 	CALL	SBUFFXX
 	LD	B,64		;64 chars / line
 HG81LP	LD	A,(HL)		;get character
 	INC	HL
 	CALL	PBUF
 	DJNZ	HG81LP
 	LD	A,'"'
 	CALL	PBUF
 	LD	A,';'
 	CALL	PBUF
 	LD	A,0DH
 	CALL	PBUF
 	POP	BC
 	DEC	B
 	JP	NZ,DOBSLP
 	JP	FINTERM
 PERDATA	BIT	7,(IY-1)	;tape?
 	CALL	NZ,HEADER
 	CALL	BLINE
 	LD	IX,BASHMSG
 	CALL	SBUFFXX
 	LD	C,128		;128 lines long
 DODATA1	CALL	BLINE		;do line #
 	LD	IX,DATAMSG	;data message
 	CALL	SBUFFXX		;do it
 	LD	B,8		;8 data statements
 	JR	DODATA3
 DODATA2	LD	A,','		;comma between
 	CALL	PBUF
 DODATA3	PUSH	BC
 	LD	A,(HL)		;get a byte
 	INC	HL
 	CALL	ASCII		;make it ascii
 	CALL	PBUF
 	LD	A,C
 	CALL	PBUF
 	LD	A,B
 	CALL	PBUF
 	POP	BC
 	DJNZ	DODATA2		;do all 8
 	LD	A,13
 	CALL	PBUF
 	DEC	C		;next line
 	JP	NZ,DODATA1
 	JP	FINTERM
 REVVID	LD	B,16		;16 lines on video
 	LD	HL,BUFFER	;top left
 	LD	DE,BUFFER+3FH	;top right
 REVL1	LD	C,32		;32 loops/line
 	PUSH	HL		;save start posit
 	PUSH	DE
 REVL2	LD	A,(HL)		;get one byte
 	EX	AF,AF'		;save it here
 	LD	A,(DE)		;get other byte
 	LD	(HL),A		;put in first spot
 	EX	AF,AF'		;get first byte
 	LD	(DE),A		;save it here
 	INC	HL		;bump
 	DEC	DE		;bump
 	DEC	C		;go 32 times
 	JR	NZ,REVL2
 	POP	DE		;get start back
 	POP	HL		;get start back
 	PUSH	BC		;save from add
 	LD	BC,40H		;line length
 	ADD	HL,BC		;add to source
 	EX	DE,HL
 	ADD	HL,BC		;add to dest
 	EX	DE,HL
 	POP	BC		;counter back
 	DJNZ	REVL1		;do 16 lines
 	SET	5,(IY)		;set updated video
 	JP	RESUME		;re-draw it
 REVVID2	LD	B,8		;8 lines to do
 	LD	HL,BUFFER	;top line
 	LD	DE,BUFFER+3C0H	;bottom line
 REVML1	LD	C,64		;64 chars / line
 	PUSH	HL
 	PUSH	DE		;save pointers
 REVML2	LD	A,(HL)		;get a byte
 	EX	AF,AF'
 	LD	A,(DE)
 	LD	(HL),A
 	EX	AF,AF'
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DEC	C
 	JR	NZ,REVML2
 	POP	DE
 	POP	HL
 	PUSH	BC
 	LD	BC,40H
 	ADD	HL,BC		;next line
 	EX	DE,HL
 	OR	A		;clear carry
 	SBC	HL,BC
 	EX	DE,HL
 	POP	BC
 	DJNZ	REVML1
 	SET	5,(IY)
 	JP	RESUME
 MOVVID	CALL	KEY		;wait for next key
 	AND	7FH		;must be arrow
 	CP	5BH
 	JP	Z,MOVVIDU
 	CP	5CH
 	JP	Z,MOVVIDD
 	CP	5EH		;left?
 	JR	Z,MOVVIDR
 	CP	5DH
 	JP	NZ,LOOP		;cancel it
 	LD	B,16
 	LD	HL,BUFFER
 MOVLP1	PUSH	HL		;save start
 	LD	D,H
 	LD	E,L		;give to DE
 	INC	DE
 	LD	C,63		;63 times / line
 MOVLP2	LD	A,(DE)		;get a byte
 	LD	(HL),A		;put it here
 	INC	DE
 	INC	HL
 	DEC	C
 	JR	NZ,MOVLP2
 	LD	(HL),80H	;space at end
 	POP	HL		;restore position
 	LD	DE,40H
 	ADD	HL,DE
 	DJNZ	MOVLP1
 	SET	5,(IY)
 	JP	RESUME
 MOVVIDR	LD	B,16
 	LD	HL,BUFFER+3FH
 MOVMLP1	PUSH	HL
 	LD	D,H
 	LD	E,L
 	DEC	DE
 	LD	C,63
 MOVMLP2	LD	A,(DE)
 	LD	(HL),A
 	DEC	DE
 	DEC	HL
 	DEC	C
 	JR	NZ,MOVMLP2
 	LD	(HL),80H
 	POP	HL
 	LD	DE,40H
 	ADD	HL,DE
 	DJNZ	MOVMLP1
 	SET	5,(IY)
 	JP	RESUME
 MOVVIDU	LD	B,15
 	LD	HL,BUFFER
 	LD	DE,BUFFER+40H
 MOVX1	PUSH	HL
 	PUSH	DE
 	LD	C,64
 MOVX2	LD	A,(DE)
 	LD	(HL),A
 	INC	DE
 	INC	HL
 	DEC	C
 	JR	NZ,MOVX2
 	POP	DE
 	POP	HL
 	PUSH	BC
 	LD	BC,40H
 	ADD	HL,BC
 	EX	DE,HL
 	ADD	HL,BC
 	EX	DE,HL
 	POP	BC
 	DJNZ	MOVX1
 	SET	5,(IY)
 	LD	HL,BUFFER+3C0H
 	LD	DE,BUFFER+3C1H
 	LD	BC,63
 	LD	(HL),80H
 	LDIR
 	JP	RESUME
 MOVVIDD	LD	HL,BUFFER+3C0H
 	LD	DE,BUFFER+380H
 	LD	B,15
 MOVY1	PUSH	HL
 	PUSH	DE
 	LD	C,64
 MOVY2	LD	A,(DE)
 	LD	(HL),A
 	INC	HL
 	INC	DE
 	DEC	C
 	JR	NZ,MOVY2
 	POP	DE
 	POP	HL
 	PUSH	BC
 	LD	BC,-40H
 	ADD	HL,BC
 	EX	DE,HL
 	ADD	HL,BC
 	EX	DE,HL
 	POP	BC
 	DJNZ	MOVY1
 	LD	HL,BUFFER
 	LD	DE,BUFFER+1
 	LD	BC,63
 	LD	(HL),80H
 	LDIR
 	SET	5,(IY)
 	JP	RESUME
 SCREENPRT	PUSH	AF
 	XOR	A
 	LD	(MX80),A
 	SET	5,(IY)		;update video
 	CALL	PUTBUFF		;display it, cursor off
 	POP	AF
 	CP	176
 	JR	NZ,SCREEN2
 	LD	A,20H
 	LD	(MX80),A
 	LD	A,160
 	JR	SCREEN2
 @SCPRT	XOR	A
 	LD	(MX80),A
 	LD	A,160
 SCREEN2	LD	HL,XPOUT
 	CP	141		;shift ENTER?
 	JR	Z,VIDEXX
 	LD	HL,YPOUT	;else do video
 	CP	160		;shift SPACEBAR?
 	JP	NZ,LOOP		;can't get here
 VIDEXX	LD	(PRINTER),HL	;which one to call
 	LD	B,16		;16 lines on video
 	LD	HL,3C00H	;where data is
 VIDEX1	LD	C,64		;64 chars/line
 VIDEX2	LD	A,(HL)		;get a byte
 	PUSH	AF
 	LD	(HL),191
 	CALL	POUT		;send to printer
 	POP	AF
 	LD	(HL),A
 	INC	HL		;next position
 	DEC	C		;decrement counter
 	JR	NZ,VIDEX2	;finish this line
 	LD	A,13		;send C/R
 	CALL	POUT
 	DJNZ	VIDEX1		;do next 15 lines
 	JP	RESUME		;continue
 POUT	EX	AF,AF'		;save char here
 	LD	A,(3840H)
 	AND	4		;check for BREAK
 	JP	NZ,RESUME	;return
 	EX	AF,AF'		;get char back
 	BIT	7,A
 	JR	Z,GOPRTR
 	RES	6,A
 	ADD	A,20H
 MX80	EQU	$-1
 GOPRTR	JP	0		;display it
 PRINTER	EQU	$-2
 XPOUT	PUSH	IY
 	CALL	3BH
 	POP	IY
 	JR	YOUTGO
 YPOUT	EX	AF,AF'		;save here again
 YPOUT1	LD	A,(37E8H)	;get status
 	AND	0F0H		;ready?
 	CP	30H
 	JR	Z,YPOUT2
 	LD	A,(3840H)
 	AND	4
 	JP	NZ,RESUME
 	JR	YPOUT1
 YPOUT2	EX	AF,AF'		;have char
 	BIT	5,(IY-1)	;check for I III
 	JR	NZ,YPOUT3	;do Mod III
 	LD	(37E8H),A	;do Mod I
 	JR	YOUTGO
 YPOUT3	OUT	(0F8H),A	;do Mod III
 YOUTGO	PUSH	AF
 	PUSH	BC
 	LD	BC,262
 	CALL	60H
 	POP	BC
 	POP	AF
 	RET
