PLAY   ;play
 	ORG	5200H
 ENTRY	PUSH	HL		;save input pointer
 	LD	HL,MESG		;title message
 	CALL	PRINT		;display it
 	POP	HL		;get pointer back
 	CALL	POSHL		;anything?
 	JR	NC,RESUME	;continue
 	LD	HL,FMESG	;ask for files
 	CALL	PRINT
 	LD	B,63		;63 char input
 	CALL	GETSTR		;ask for input
 RESUME	XOR	A
 	LD	(TIME),A	;set pause between
 	CALL	POSHL		;anything?
 	JP	C,ABORT		;cancel and quit
 	CP	'>'		;time specifier?
 	JR	NZ,CONT		;go loop
 	INC	HL		;next position
 	CALL	POSHL		;go to character
 	JP	C,ABORT		;nothing else
 	CALL	VALUE
 	JP	C,ABORT		;invalid input
 	LD	A,C		;get it
 	LD	(TIME),A	;time delay
 CONT	LD	(PTR),HL	;save pointer
 LOOP	LD	HL,0		;get pointer
 PTR	EQU	$-2
 	CALL	POSHL		;check for input
 	JP	C,QUIT		;nothing more
 	CALL	MOVEFILE	;move file to DCB
 	LD	(PTR),HL	;save new pointer
 	CALL	ADDEXT		;add extension
 	LD	HL,IOBUFF
 	LD	B,0
 	CALL	4424H		;open the file
 	JP	NZ,ERROR	;I/O error
 	CALL	4436H		;read first sector
 	JP	NZ,ERROR	;cancel
 	LD	HL,IOBUFF
 	LD	DE,QUICK	;file header
 	LD	B,21		;check for valid file
 	CALL	COMPARE
 	JP	NZ,INVALID	;invalid file
 	LD	BC,0E600H	;get counter
 CKLP	LD	A,(HL)		;get a byte
 	CP	99		;active?
 	JR	NZ,NXCK		;don't count this one
 	INC	C		;bump counter
 NXCK	INC	HL
 	DJNZ	CKLP		;check 'em all
 	LD	A,C		;get counter
 	LD	(COUNT),A	;save # buffers
 LOADLP	CALL	LOAD		;load a buffer
 	CALL	PUTBUFF		;put on screen
 	LD	A,0		;get counter
 TIME	EQU	$-1
 	OR	A
 	JR	Z,WAT1		;wait for key between
 	PUSH	BC
 DLYGO	LD	BC,2000H
 	PUSH	AF
 	LD	A,(3840H)
 	AND	4
 	JP	NZ,QUIT
 	CALL	60H
 	POP	AF
 	DEC	A
 	JR	NZ,DLYGO
 	POP	BC
 	JR	WATNXT
 WAT1	LD	A,(3840H)
 	AND	4
 	JP	NZ,QUIT
 	LD	A,(387FH)
 	OR	A
 	JR	NZ,WAT1
 WAT2	LD	A,(3840H)	;now wait till spacebar
 	BIT	2,A
 	JP	NZ,QUIT
 	AND	80H
 	JR	Z,WAT2		;wait here
 WATNXT	LD	A,(3840H)
 	AND	4
 	JP	NZ,QUIT
 	CALL	2BH		;drain keyboard
 	LD	A,0		;get counter
 COUNT	EQU	$-1
 	DEC	A
 	LD	(COUNT),A
 	JP	NZ,LOADLP	;do next screen
 	JP	LOOP		;do next file
 INVALID	LD	HL,VALMSG
 	CALL	PRINT
 	LD	HL,ABORTMSG+2
 	JR	QUIT+3
 ABORT	LD	HL,ABORTMSG
 	JR	QUIT+3
 QUIT	LD	HL,QUICK-2
 	CALL	PRINT		;display it
 	JP	402DH		;back to DOS
 PUTBUFF	LD	HL,BUFFER	;where it is
 	LD	DE,3C00H	;where it goes
 	LD	BC,1024		;1K of data
 	LDIR			;move it to video
 	RET			;done
 PRINT	PUSH	HL		;save the string
 PRTLP	LD	A,(HL)		;get a byte
 	INC	HL		;bump it
 	CP	3		;terminator?
 	JR	Z,PRTDN		;done
 	CALL	VOUT		;out to video
 	CP	13		;terminator?
 	JR	NZ,PRTLP
 PRTDN	POP	HL
 	RET
 VOUT	CP	20H		;control code?
 	JP	C,33H		;let ROM do this
 	PUSH	HL		;else save pointer
 	LD	HL,(4020H)	;get cursor
 	LD	(HL),A		;put on screen
 	CP	(HL)		;still there?
 	JR	Z,VIDOK		;lower case in
 	SUB	20H		;else make it upper
 	LD	(HL),A		;put it back
 VIDOK	INC	HL
 	LD	(4020H),HL	;update cursor
 	POP	HL		;restore pointer
 	RET			;done
 LOAD	LD	B,4		;4 sectors / file
 	LD	DE,BUFFER	;where data goes
 LOADIT	PUSH	BC		;save pointers
 	PUSH	DE
 	LD	DE,DCB		;point to file DCB
 	CALL	4436H		;read a sector
 	JP	NZ,ERROR	;abort
 	POP	DE		;get pointer back
 	LD	HL,IOBUFF	;where data is
 	LD	BC,100H		;1 sector worth
 	LDIR			;move it there
 	POP	BC		;get counter back
 	DJNZ	LOADIT		;do all 4 sectors
 	RET			;done
 COMPARE	LD	A,(DE)		;compare buffers
 	CP	(HL)
 	INC	DE
 	INC	HL
 	RET	NZ
 	DJNZ	COMPARE
 	RET
 ERROR	PUSH	AF		;save error code
 	LD	HL,ERRMSG	;error message
 	CALL	PRINT
 	POP	AF
 	OR	0C0H
 	CALL	4409H
 	JP	402DH
 GETSTR	LD	HL,STRING	;point to string
 WAITKEY	LD	A,(387FH)
 	OR	A
 	JR	NZ,WAITKEY
 	CALL	40H
 	JP	C,QUIT
 	LD	A,B		;get length of input
 	OR	A		;set flags
 	LD	A,(HL)		;get first character
 	RET
 UCASE	CP	60H		;upper case now?
 	RET	C
 	CP	80H
 	RET	NC
 	AND	5FH
 	RET
 VALUE	LD	C,0		;start value
 VALLP	LD	A,(HL)		;get a number
 	CALL	CKVAL		;good
 	RET	Z
 	RET	C
 	LD	C,A		;ok
 	INC	HL
 	LD	A,(HL)		;ok?
 	CP	13		;terminator?
 	RET	Z		;done
 	CALL	CKVAL		;good?
 	RET	Z
 	RET	C		;nope
 	LD	B,A		;save here
 	LD	A,C		;get first
 	ADD	A,A		;*2
 	ADD	A,A		;*4
 	ADD	A,C		;*5
 	ADD	A,A		;*10
 	ADD	A,B		;add second number
 	LD	C,A
 	OR	A		;clear carry
 	RET
 CKVAL	CP	1
 	RET	Z
 	CP	13
 	RET	Z
 	CP	20H
 	RET	Z
 	CP	','
 	RET	Z
 	SUB	30H
 	RET	C		;no good
 	CP	10
 	CCF
 	RET			;C flag if bad
 	INC	HL
 POSHL	LD	A,(HL)		;get a byte
 	CP	13		;check for terminator
 	SCF
 	RET	Z		;end of string
 	CP	1		;break?
 	SCF
 	RET	Z
 	CP	20H		;space?
 	JR	Z,POSHL-1	;bump pointer
 	CP	','		;comma?
 	JR	Z,POSHL-1	;bump it
 	OR	A		;clear carry
 	RET
 MOVEFILE	LD	DE,DCB	;point to DCB
 MOVLP	LD	A,(HL)		;get a byte
 	CP	13		;terminator?
 	JR	Z,TERM
 	CP	1
 	JR	Z,TERM
 	INC	HL
 	CP	20H
 	JR	Z,TERM
 	CP	','
 	JR	Z,TERM
 	CALL	UCASE
 	LD	(DE),A		;put in DCB
 	INC	DE
 	JR	MOVLP		;continue
 TERM	LD	A,13		;insert terminator
 	LD	(DE),A		;to the DCB
 	LD	DE,DCB
 	RET			;done
 ADDEXT	LD	HL,DEFEXT
 	PUSH	DE
 	PUSH	HL
 	EX	DE,HL
 	INC	HL
 	LD	B,9		;9 spaces
 EXTLP	LD	A,(HL)		;get a byte
 	CP	'/'		;has extension?
 	JR	Z,EXTDONE	;done if yes
 	JR	C,DOEXT		;add extension
 	CP	':'		;drive number?
 	JR	C,EXTNEXT	;continue if yes
 	CP	'A'		;41H
 	JR	C,DOEXT		;add extension
 EXTNEXT	INC	HL		;next location
 	DJNZ	EXTLP		;continue
 EXTDONE	POP	HL		;done
 	POP	DE
 	RET			;DCB restored
 DOEXT	LD	BC,0FH		;15 bytes
 	ADD	HL,BC
 	LD	D,H
 	LD	E,L
 	INC	DE
 	INC	DE
 	INC	DE
 	INC	DE
 	INC	BC
 	LDDR
 	POP	HL
 	INC	HL
 	INC	HL
 	LD	C,3
 	LDDR
 	LD	A,2FH
 	LD	(DE),A
 	POP	DE
 	RET
 DEFEXT	DB	'DRW'		;default extension
 ERRMSG	DB	1CH,1FH
 	DB	'Error !',13
 ABORTMSG	DB	1CH,1FH
 	DB	'Utility ABORTED !',10,13
 	DB	1CH,1FH
 QUICK	DB	'***  POWER-DRAW  ***',13
 MESG	DB	1CH,1FH
 	DB	'***  POWER-DRAW ',27H,'play',27H
 	DB	' UTILITY  ***',10
 	DB	'by Kim Watt - Breeze/QSD, Inc.',10
 	DB	10,13
 VALMSG	DB	1CH,1FH
 	DB	'Invalid File Format',10,13
 FMESG	DB	'Enter File(s):',13
 DCB	EQU	$
 DBUFF	EQU	$&0FF00H
 STRING	EQU	DBUFF+100H
 IOBUFF	EQU	STRING+100H
 BUFFER	EQU	IOBUFF+100H
 	END	ENTRY
 	DB	10,13
 VALMSG	DB	1CH,1FH
 	DB	'Inv