; work1 - kjw/bqsd - dallas, texas
;
; created 02/23/83 - kjw
; revised 03/04/83 - kjw
;
	TITLE	'<WORK1/ASM>'
	SUBTTL	'<by Kim Watt - (c)(p) 1983 Breeze/QSD, Inc. - Dallas, Texas>'
;
;	Mod I/III/MAX size is 678 bytes
;	Mod II/12/16  size is 600 bytes
;	LDOS SVC call size is 645 bytes
;
;	contains the following subroutines
;
;	@GET	- fetch character from device
;	@PUT	- send character to device
;	@CTL	- fetch character from device with wait
;	@KBCHAR	- fetch character from keyboard
;	@VDCHAR	- send character to video
;	@PRCHAR	- send character to printer
;	@PRSTAT	- fetch printer status
;	@KBLINE	- fetch string from keyboard
;	@VDLINE	- send string to video
;	@VDGRAF	- send characters to video
;	@PRLINE	- send string to printer
;	@VIDKEY	- display string and get keyboard string
;	@VIDPRT	- dual output string to video and printer
;	@WHERE	- resolve calling address
;	@MODEL	- determine computer machine/model
;	@SETUP	- setup for normal program exit
;	@EXIT	- exit program to last level
;	@ABORT	- display error and exit program
;	@RESET	- cold reboot of computer
;	@ERROR	- display error message
;	@DOSCAL	- execute dos call from program
;	@HIMEM	- fetch system memory definitions
;	@SETMEM	- store new high memory pointer
;	@VSIZE	- determine size of video
;	@CLS	- clear video screen
;	@VIDCUR	- fetch/store video cursor
;	@VPOKE	- write character to video
;	@VPEEK	- fetch character from video
;	@VIDRAM	- move memory to/from video/user buffer
;	@SCRPRT	- send contents of video to printer
;	@FLASH	- flash text on video
;
TRS13	EQU	-1		;trs80 Mod I/III - MAX
TRS2	EQU	0		;trs80 Mod II/12/16
LDOSSVC	EQU	0		;ldos SVC calls
;
	PAGE
;
;	$GET	- fetch character from device
;
;	ENT	DE => device DCB
;
;	EXIT	Z  = A = input character
;		NZ = A = error code
;
@GET	EQU	$
;
	IF	TRS13
	CALL	0013H		;get character
	OR	A		;anything?
	JR	Z,$+4		;go if nothing!
	CP	A		;set Z flag
	RET			;return with char
	OR	8		;set NZ, (char not avail)
	RET			;go!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	LD	A,77		;SVC # get
	RST	08H		;get character
	JR	NZ,$+3		;go if no char
	LD	A,B		;get character
	POP	BC		;restore stack
	RET			;return with status
	ENDIF
;
	IF	LDOSSVC
	LD	A,3		;SVC # get
	RST	28H		;scan keyboard
	OR	A		;anything?
	JR	Z,$+4		;go if nothing!
	CP	A		;set Z flag for char
	RET			;done!
	OR	8		;set NZ (char not avail)
	RET			;go!
	ENDIF
;
	PAGE
;
;	$PUT	- send character to device
;
;	ENT	A  = character to send
;		DE => DCB
;
;	EXIT	Z  = character sent OK
;		NZ = A = error code
;
@PUT	EQU	$
;
	IF	TRS13
	JP	001BH		;send character
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	LD	B,A		;pass character
	LD	A,77		;SVC # put
	RST	08H		;send byte
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save
	LD	C,A		;pass char
	LD	A,4		;SVC # put
	RST	28H		;send byte
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	PAGE
;
;	$CTL	- get char from device with wait
;
;	ENT	DE => DCB
;
;	EXIT	Z  = A = input character
;		NZ = A = error code
;
@CTL	CALL	@GET		;attempt to get char
	RET	Z		;go if have char
;
	IF	TRS13.OR.LDOSSVC
	CP	8		;char not available?
	ENDIF
;
	IF	TRS2
	CP	2		;char not avail?
	ENDIF
;
	JR	Z,@CTL		;go if yes
	OR	A		;clear carry, set NZ
	RET			;return with error!
;
	PAGE
;
;	$KBCHAR - fetch character from keyboard
;
;	ENT	none
;
;	EXIT	Z  = A = input char
;		NZ = A = error code
;
@KBCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save it
	CALL	002BH		;read keyboard
	POP	DE		;restore
	OR	A		;anything?
	JR	Z,$+4		;go if no!
	CP	A		;set Z flag
	RET			;return with char
	OR	8		;set char not avail
	RET			;go!
	ENDIF
;
	IF	TRS2
	LD	A,4		;SVC # kbchar
	RST	08H		;fetch key char
	RET			;return with char/flags
	ENDIF
;
	IF	LDOSSVC
	LD	A,8		;SVC # kbd
	RST	28H		;scan keyboard
	OR	A		;anything?
	JR	Z,$+4		;go if not!
	CP	A		;set Z/NC
	RET			;done!
	OR	8		;set NZ
	RET			;return no char
	ENDIF
;
	PAGE
;
;	$VDCHAR	- character to video
;
;	ENT	A  = char to send
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@VDCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save it
	CALL	0033H		;display char
	POP	DE		;restore
	RET			;return with status
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	LD	B,A		;pass char
	LD	A,8		;SVC # vdchar
	RST	08H		;display char
	POP	BC		;restore
	RET			;return
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save
	LD	C,A		;pass char
	LD	A,2		;SVC # dsp
	RST	28H		;display char
	POP	BC		;restore
	RET			;done!
	ENDIF
;
	PAGE
;
;	$PRCHAR	- character to printer
;
;	ENT	A  = char to print
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@PRCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save
	CALL	003BH		;print character
	POP	DE		;restore
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	LD	B,A		;pass character
	LD	A,18		;SVC # prchar
	RST	08H		;print char
	POP	BC		;restore
	RET			;return!
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save
	LD	C,A		;pass char
	LD	A,6		;SVC # prt
	RST	28H		;print char
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	PAGE
;
;	$PRSTAT	- fetch printer status
;
;	ENT	none
;
;	EXIT	Z  = printer ready
;		NZ = A = error code
;
@PRSTAT	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	XOR	A		;load zero
	CALL	@PRCHAR		;send char
	LD	A,8		;set not available
	RET	NZ		;go if not ready
	XOR	A		;else return Z
	RET			;printer ready!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save it
	LD	B,0		;command #
	LD	A,95		;SVC # prctl
	RST	08H		;fetch status
	POP	BC		;restore
	LD	A,42		;'printer not ready'
	RET	NZ		;go if not ready
	XOR	A		;else return Z for ready
	RET			;done!
	ENDIF
;
	PAGE
;
;	$KBLINE	- fetch string from keyboard
;
;	ENT	HL => input string buffer
;		B  =  maximum input length
;
;	EXIT	NZ = A = error code
;		Z  = OK and
;		HL => input string
;		B  = actual input length
;		C  = max input length
;		Carry = input terminated with <BREAK>
;
@KBLINE	EQU	$
;
	IF	TRS13
	CALL	0040H		;get input line
	LD	A,0		;set NO error
	INC	A		;set Z flag but don't
	DEC	A		;change C flag
	RET			;go!
	ENDIF
;
	IF	TRS2
	LD	A,5		;SVC # kbline
	RST	08H		;get input line
	RET			;return with it
	ENDIF
;
	IF	LDOSSVC
	LD	A,9		;SVC # keyin
	RST	28H		;get line input
	RET			;return with it
	ENDIF
;
	PAGE
;
;	$VDLINE	- send string to video
;
;	ENT	HL => display string terminated 03H
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@VDLINE	PUSH	HL		;save string start
VDLINY	LD	A,(HL)		;get string char
	CP	3		;terminator?
	JR	Z,VDLINZ	;go if done!
	CALL	@VDCHAR		;send char to video
	JR	NZ,VDLINZ	;go if error!
	INC	HL		;bump pointer
	JR	VDLINY		;go next char
VDLINZ	POP	HL		;restore stack
	RET	NZ		;go if any errors
	XOR	A		;else return ZERO
	RET			;done!
;
	PAGE
;
;	$VDGRAF	- graphic string to video
;
;	ENT	HL => text string
;		B  = string length
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@VDGRAF	PUSH	HL		;save string start
	PUSH	BC		;save length
VDGRAY	LD	A,(HL)		;get a char
	CALL	@VPOKE		;to video
	JR	NZ,VDGRAZ	;go if error!
	INC	HL		;bump pointer
	DJNZ	VDGRAY		;go for length
VDGRAZ	POP	BC		;unstack
	POP	HL		;restore string start
	RET			;return Z/NZ status
;
	PAGE
;
;	$PRLINE	- send line to printer
;
;	ENT	HL => text string to print
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@PRLINE	PUSH	HL		;save string start
PRLINY	LD	A,(HL)		;get a char
	CP	3		;end of text?
	JR	Z,PRLINZ	;go if yes
	CALL	@PRCHAR		;send char to printer
	JR	NZ,PRLINZ	;go if error!
	INC	HL		;bump pointer
	JR	PRLINY		;go next char
PRLINZ	POP	HL		;restore stack
	RET	NZ		;go if any errors
	XOR	A		;set Z flag
	RET			;done, go!
;
	PAGE
;
;	$VIDKEY	- video/keyboard strings
;
;	ENT	HL => display string terminated 03H
;		DE => keyboard input buffer
;		B  = maximum keyboard input length
;
;	EXIT	NZ = A = error code
;		Z  = OK &
;		HL => input string from keyboard
;		DE => display string
;		B  = actual # input chars
;		C  = max input key length
;
@VIDKEY	CALL	@VDLINE		;display prompt string
	EX	DE,HL		;HL => input buffer
	JP	@KBLINE		;get keyboard line
;
	PAGE
;
;	$VIDPRT	- dual output to video/printer
;
;	ENT	HL => display text terminated 03H
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@VIDPRT	CALL	@VDLINE		;text to video
	JP	@PRLINE		;text to printer
;
	PAGE
;
;	$MODEL	- fetch computer machine/model #
;
;	ENT	none
;
;	EXIT	B = machine	C = model
;		1 = TRS80	1 = mod I
;				2 = mod II/12/16
;				3 = mod III
;		2 = LOBO	3 = max 80 (Mod IV)
;		3 = IBM		1 = PC
;
@MODEL	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	PUSH	HL		;save HL
	LD	HL,0125H	;point to ROM ID
	CALL	TESTIT		;test byte @ (HL)
	POP	HL		;restore
	LD	BC,2<8+3	;max 80
	JR	Z,MODEZ		;go if RAM there!
	CP	'I'		;mod III?
	LD	B,1		;set mod III
	JR	Z,MODEZ		;go if yes!
	LD	C,B		;set Mod I
MODEZ	XOR	A		;return Z
	RET			;done!
	ENDIF
;
	IF	TRS2
	LD	BC,1<8+2	;set Mod II
	XOR	A		;return Z
	RET			;go!
	ENDIF
;
TESTIT	LD	A,(HL)		;get char @ (HL)
	CPL			;reverse bits
	LD	(HL),A		;load new value
	CP	(HL)		;memory there?
	CPL			;reverse back
	LD	(HL),A		;reset character
	RET			;done!
;
	PAGE
;
;	$WHERE	- resolve current program address
;
;	ENT	none
;
;	EXIT	HL = contents of current program counter
;
@WHERE	POP	HL		;get PC address
	JP	(HL)		;return!
;
	PAGE
;
;	$SETUP	- store stack and interrupts for reset
;
;	ENT	none (must be called immediately)
;
;	EXIT	none
;
@SETUP	LD	(STACK),SP	;preserve stack pointer
	LD	A,I		;read INTERRUPT REG
	PUSH	BC		;save BC
	PUSH	AF		;pass to BC
	POP	BC		;C = F
	LD	(INTLAT),BC	;save interrupt latch
	POP	BC		;restore BC
	XOR	A		;return Z
	RET			;done!
;
	PAGE
;
;	$ABORT	- program error exit
;
;	ENT	A = error code
;
;	EXIT	error displayed and program exit taken
;
@ABORT	CALL	@ERROR		;display error
	JP	@EXIT		;exit program
;
	PAGE
;
;	$EXIT	- exit program
;
;	ENT	none (@SETUP must have been pre-called)
;
;	EXIT	program exit taken
;
@EXIT	LD	SP,$		;reset stack to entry
STACK	EQU	$-2
	PUSH	BC		;save BC
	LD	BC,$		;get interrupt latch
INTLAT	EQU	$-2
	PUSH	BC		;pass to AF
	POP	AF		;F = interrupt status
	POP	BC		;restore stack
	JP	PO,$+4		;go if previously off
	EI			;else re-enable
	XOR	A		;return Z
	RET			;go next sub-level
;
	PAGE
;
;	$RESET	- cold reboot computer
;
;	ENT	none
;
;	EXIT	machine cold started
;
@RESET	EQU	$
;
	IF	TRS13
	CALL	@MODEL		;which model?
	DEC	B		;trs80?
	JR	NZ,RESEM	;nope, reset MAX80!
	DEC	C		;mod I?
	JR	Z,$+3		;go if yes
	RST	0		;re-boot mod III
	HALT			;re-boot mod III
RESEM	LD	A,(37DCH)	;read $VLATCH
	AND	0F8H		;enable boot ROM
	DI			;disable
	LD	(37DCH),A	;ROM enabled now!
	RST	0		;re-boot!
	ENDIF
;
	IF	TRS2
	LD	A,1		;set bit 0
	DI			;disable interrupts
	OUT	(0F9H),A	;enable boot ROM
	RST	0		;go boot rom!
	ENDIF
;
	IF	LDOSSVC
	RST	0		;re-boot
	ENDIF
;
	PAGE
;
;	$ERROR	- display error message
;
;	ENT	A = error code
;
;	EXIT	error displayed, Z flag set
;
@ERROR	EQU	$
;
	IF	TRS13
	OR	0C0H		;no detail, return
	JP	4409H		;display error & return
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	AND	7FH		;assure a return
	LD	B,A		;pass error code
	LD	A,39		;SVC #
	RST	08H		;display error
	POP	BC		;restore stack
	RET			;done!
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save
	OR	0C0H		;normal + return
	LD	C,A		;pass error code
	LD	A,26		;SVC # error
	RST	28H		;display message
	POP	BC		;restore BC
	RET			;done!
	ENDIF
;
	PAGE
;
;	$HIMEM	- fetch memory pointers
;
;	ENT	none
;
;	EXIT	HL = top of free memory
;		DE = top of physical memory
;		BC = bottom of physical memory
;
@HIMEM	EQU	$
	IF	TRS13.OR.LDOSSVC
	LD	HL,-1		;start memory @ FFFFH
FTMEM	CALL	TESTIT		;test the byte
	JR	Z,FTMEMH	;have it, go!
	DEC	H		;move back a page
	JR	FTMEM		;continue
FTMEMH	EX	DE,HL		;DE = top physical memory
	CALL	@MODEL		;fetch model number
	LD	HL,4049H	;topmem mod I
	DEC	C		;mod I?
	JR	Z,$+5		;go if yes
	LD	HL,4411H	;topmem mod III/max
	LD	A,(HL)		;get LSB topmem
	INC	HL		;bump pointer
	LD	H,(HL)		;get MSB topmem
	LD	L,A		;HL = topmem
	XOR	A		;set Z
	DEC	B		;trs80?
	LD	BC,4000H	;start RAM trs80
	RET	Z		;go if trs80
	LD	BC,0000H	;start RAM max80
	XOR	A		;set Z
	RET			;go!
	ENDIF
;
	IF	TRS2
	LD	HL,(0173H)	;get topmem
	LD	DE,(0175H)	;get physical memory
	XOR	A		;load zero
	LD	B,A		;pass to BC
	LD	C,A		;BC = lowest memory
	RET			;return
	ENDIF
;
	PAGE
;
;	$SETMEM	- set new high memory pointer
;
;	ENT	HL = new high memory address
;
;	EXIT	(HIMEM) set accordingly
;
@SETMEM	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	PUSH	BC		;save it
	CALL	@MODEL		;Mod I or III?
	DEC	C		;I?
	LD	BC,4049H	;topmem I
	JR	Z,$+5		;go if yes
	LD	BC,4411H	;topmem III
	LD	(SETTA),BC	;save address
	POP	BC		;restore stack
	LD	($),HL		;save new topmem
SETTA	EQU	$-2
	RET			;done!
	ENDIF
;
	IF	TRS2
	LD	(0173H),HL	;new topmem
	RET			;done!
	ENDIF
;
	PAGE
;
;	$DOSCAL	- pass command string to DOS
;
;	ENT	HL => command string terminated 0DH
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@DOSCAL	EQU	$
;
	IF	TRS13
	PUSH	BC		;save BC
	CALL	@MODEL		;fetch model #
	DEC	C		;mod I?
	LD	BC,4405H	;interpreter Mod I
	JR	Z,$+5		;go if mod I
	LD	BC,4299H	;interpreter Mod III
	LD	(DOSVEC),BC	;save vector
	POP	BC		;restore stack
	JP	$		;go doscall!
DOSVEC	EQU	$-2
	ENDIF
;
	IF	TRS2
	LD	A,38		;SVC # retcmd
	RST	08H		;execute dos command
	RET			;done!
	ENDIF
;
	IF	LDOSSVC
	LD	A,24		;SVC # cmndi
	RST	28H		;execute command
	RET			;return status
	ENDIF
;
	PAGE
;
;	$VSIZE	- fetch video specifics
;
;	ENT	none
;
;	EXIT	HL => start video memory
;		DE =  length video memory
;		B  = # video rows
;		C  = # video columns
;
@VSIZE	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	HL,3C00H	;start video
	LD	DE,16*64	;length of video
	LD	BC,16<8+64	;rows / columns
	XOR	A		;return Z
	RET			;done
	ENDIF
;
	IF	TRS2
	LD	HL,0F800H	;start video
	LD	DE,24*80	;length of video
	LD	BC,24<8+80	;rows / columns
	XOR	A		;return Z
	RET
	ENDIF
;
	PAGE
;
;	$CLS	- clear video screen
;
;	ENT	none
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@CLS	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	A,1CH		;home cursor
	CALL	@VDCHAR		;display it
	RET	NZ		;go if error
	LD	A,1FH		;clear to end of frame
	JP	@VDCHAR		;display and return
	ENDIF
;
	IF	TRS2
	LD	A,1BH		;home and clear
	JP	@VDCHAR		;display and return
	ENDIF
;
	PAGE
;
;	$VIDCUR	- fetch/save video cursor position
;
;	ENT	A  = command #
;			1 = set row/column
;			2 = set offset
;			3 = get row/column
;			4 = get offset
;			5 = cursor on
;			6 = cursor off
;		BC = row/column/offset if SET command
;
;	EXIT	NZ = A = error code
;		Z  = OK &
;		BC = row/column/offset if GET command
;
@VIDCUR	DEC	A		;1?
	JR	Z,SETRC		;set row/column
	DEC	A		;2?
	JR	Z,SETOF		;set offset
	DEC	A		;3?
	JR	Z,GETRC		;get row/column
	DEC	A		;4?
	JR	Z,GETOF		;get offset
	DEC	A		;5?
	JR	Z,CURON		;cursor on
	DEC	A		;6?
	JR	Z,CUROF		;cursor off
;
	IF	TRS13.OR.LDOSSVC
	LD	A,29		;'record out of range' ?
	ENDIF
;
	IF	TRS2
	LD	A,1		;bad function code
	ENDIF
;
	OR	A		;clear carry, set NZ
	RET			;go in error!
;
SETRC	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	PUSH	HL		;save it
	LD	L,B		;fetch row
	LD	H,0		;HL = row #
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,HL		;*8
	ADD	HL,HL		;*16
	ADD	HL,HL		;*32
	ADD	HL,HL		;*64
	LD	A,C		;get column
	ADD	A,L		;add it
	LD	L,A		;HL = offset
	LD	A,H		;get MSB
	ADD	A,3CH		;add offset to video
	LD	H,A		;HL => video memory
	LD	(4020H),HL	;update cursor posit
	POP	HL		;unstack
	XOR	A		;return Z
	RET			;done! cursor set
	ENDIF
;
	IF	TRS2
	PUSH	DE		;save it
	LD	D,0		;# chars to display
	LD	A,10		;SVC # vdgraf
	RST	08H		;set cursor
	POP	DE		;restore stack
	RET			;return with status
	ENDIF
;
SETOF	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	(4020H),BC	;set offset
	XOR	A		;return Z
	RET			;done, cursor set!
	ENDIF
;
	IF	TRS2
	PUSH	IX		;save it
	LD	A,1		;video DCB #
	CALL	032AH		;locate DCB address
	LD	(IX+11),C	;pass LSB offset
	LD	(IX+12),B	;pass MSB offset
	POP	IX		;restore
	XOR	A		;return Z
	RET			;done!
	ENDIF
;
GETRC	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	PUSH	HL		;save HL
	LD	HL,(4020H)	;get cursor address
	LD	A,L		;get LSB
	AND	3FH		;get column
	LD	C,A		;C = column
	LD	A,H		;get MSB
	AND	3		;low 2 bits only
	RL	L		;move bit 7 => carry
	RLA			;move carry => accum
	RL	L		;move bit 6 => carry
	RLA			;move carry => accum
	LD	B,A		;B = row
	POP	HL		;restore stack
	XOR	A		;return Z
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	DE		;save it
	LD	D,0		;# chars to fetch
	LD	A,11		;SVC # vdread
	RST	08H		;fetch cursor to BC
	POP	DE		;restore stack
	RET			;return dos status
	ENDIF
;
GETOF	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,(4020H)	;get cursor address
	XOR	A		;return Z
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	IX		;save
	LD	A,1		;video DCB #
	CALL	032AH		;locate DCB
	LD	C,(IX+11)	;get LSB cursor
	LD	B,(IX+12)	;get MSB cursor
	POP	IX		;restore stack
	XOR	A		;return Z
	RET			;done!
	ENDIF
;
CURON	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	A,14		;cursor ON char
	ENDIF
;
	IF	TRS2
	LD	A,01		;cursor ON char
	ENDIF
;
	JP	@VDCHAR		;turn cursor ON
;
CUROF	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	A,15		;cursor OFF char
	ENDIF
;
	IF	TRS2
	LD	A,02		;cursor OFF char
	ENDIF
;
	JP	@VDCHAR		;turn cursor OFF
;
	PAGE
;
;	$VPOKE	- display character to video
;
;	ENT	A  = character to display
;		HL = video address
;
;	EXIT	character displayed
;
@VPOKE	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	(HL),A		;character to video
	CP	A		;return Z
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	LD	B,A		;pass char
	CALL	0336H		;enable video memory
	LD	(HL),B		;char to video
	CALL	0339H		;disable video memory
	LD	A,B		;get char back
	CP	A		;set Z flag
	POP	BC		;restore stack
	RET			;done!
	ENDIF
;
	PAGE
;
;	$VPEEK	- fetch character from current cursor
;
;	ENT	HL => video memory to fetch char
;
;	EXIT	A  = char currently on video
;
@VPEEK	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	XOR	A		;return Z
	LD	A,(HL)		;fetch char direct
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save it
	CALL	0336H		;select video memory
	LD	B,(HL)		;get char
	CALL	0339H		;de-select video
	XOR	A		;return Z
	LD	A,B		;get char
	POP	BC		;restore stack
	RET			;done!
	ENDIF
;
	PAGE
;
;	$VIDRAM	- move video memory => user memory
;
;	ENT	A  = command #
;			1 = put	BC = row/column
;				DE = # rows/columns
;			2 = get	BC = row/column
;				DE = # rows/columns
;			3 = put	BC = offset
;				DE = byte count
;			4 = get	BC = offset
;				DE = byte count
;		HL => buffer
;
;	EXIT	data move to/from video/user buffer
;
@VIDRAM	CALL	@SAVREG		;save registers
	DEC	A		;1?
	JR	Z,VDRAM1	;put row/col
	DEC	A		;2?
	JR	Z,VDRAM2	;put offset
	DEC	A		;3?
	JR	Z,VDRAM3	;get row/col
	DEC	A		;4?
	JR	Z,VDRAM4	;get offset
;
	IF	TRS13.OR.LDOSSVC
	LD	A,29		;'record out of range' ?
	ENDIF
;
	IF	TRS2
	LD	A,1		;'bad function code'
	ENDIF
;
	OR	A		;clear carry, set NZ
	RET			;return error
;
VDRAM3	CALL	SAVCUR		;save current cursor
	LD	A,C		;get start column
	LD	(VDRAM31),A	;save it
	LD	A,E		;get # columns
	LD	(VDRAM32),A	;save it
;
VDRAM3O	LD	C,'$'		;get start column
VDRAM31	EQU	$-1
	LD	E,'$'		;get # columns
VDRAM32	EQU	$-1
;
VDRAM3I	LD	A,1		;setcur by row/col
	CALL	@VIDCUR		;set cursor
	PUSH	BC		;save row/col
	LD	A,4		;getcur by offset
	CALL	@VIDCUR		;BC = offset
	PUSH	HL		;save HL
	LD	H,B		;pass BC => HL
	LD	L,C		;HL => video memory
	CALL	@VPEEK		;read video char
	POP	HL		;restore buffer
	LD	(HL),A		;char to buffer
	POP	BC		;restore row/col
	INC	HL		;bump video
	INC	C		;bump column
	DEC	E		;less column
	JR	NZ,VDRAM3I	;go inner loop till done
	DEC	D		;less row
	JR	NZ,VDRAM3O	;go outer loop till done
	JR	FETCUR		;restore old cursor
;
VDRAM1	CALL	SAVCUR		;save cursor
	LD	A,C		;get start column
	LD	(VDRAM11),A	;save it
	LD	A,E		;get # columns
	LD	(VDRAM12),A	;save it
;
VDRAM1O	LD	C,'$'		;get start column
VDRAM11	EQU	$-1
	LD	E,'$'		;get # columns
VDRAM12	EQU	$-1
;
VDRAM1I	LD	A,1		;setcur by row/col
	CALL	@VIDCUR		;set cursor
	PUSH	BC		;save row/col
	LD	A,4		;getcur by offset
	CALL	@VIDCUR		;get cursor
	PUSH	HL		;save buffer
	LD	A,(HL)		;get buffer char
	LD	H,B		;pass offset to HL
	LD	L,C		;HL => video
	CALL	@VPOKE		;write to video
	POP	HL		;restore
	POP	BC		;restore row/col
	INC	HL		;bump buffer
	INC	C		;bump column
	DEC	E		;less col count
	JR	NZ,VDRAM1I	;finish current row
	DEC	D		;less row count
	JR	NZ,VDRAM1O	;finish col count
	JR	FETCUR		;restore old cursor
;
VDRAM2	CALL	SAVCUR		;save old cursor
	PUSH	DE		;save byte count
	LD	A,4		;get cursor offset
	CALL	@VIDCUR		;BC = video offset
	LD	D,B		;pass to DE
	LD	E,C		;DE = video offset
	POP	BC		;BC = byte count
	JR	VDRAM24		;go common
;
VDRAM4	CALL	SAVCUR		;save old cursor
	PUSH	DE		;save byte count
	LD	A,4		;get cursor offset
	CALL	@VIDCUR		;BC = video offset
	LD	D,B		;pass to DE
	LD	E,C		;DE => video
	POP	BC		;get byte count
	EX	DE,HL		;DE => buffer, HL=> video
;
VDRAM24	EQU	$
;
	IF	TRS2
	CALL	0336H		;select video memory
	ENDIF
	LDIR			;move it in
	IF	TRS2
	CALL	0339H		;de-select video
	ENDIF
;
;	restore previous cursor position
;
FETCUR	LD	BC,$		;get offset
OLDCUR	EQU	$-2
	LD	A,2		;put cursor offset
	CALL	@VIDCUR		;reset cursor
	XOR	A		;return Z
	RET			;done!
;
;	save current cursor position
;
SAVCUR	PUSH	BC		;save row/col/offset
	LD	A,4		;get cursor offset
	CALL	@VIDCUR		;get it
	LD	(OLDCUR),BC	;save for cursor reset
	POP	BC		;restore
	RET			;done!
;
	PAGE
;
;	$SCRPRT	- send contents of video to printer
;
;	ENT	none
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
@SCRPRT	CALL	@SAVREG		;save registers
	CALL	@VSIZE		;get video size
	LD	E,C		;save # video columns
;
SCRPRTL	CALL	@VPEEK		;get char from video
	CALL	@PRCHAR		;send to printer
	RET	NZ		;go if error!
	INC	HL		;bump video
	DEC	C		;less column
	JR	NZ,SCRPRTL	;go for this row
	LD	A,13		;send CR
	CALL	@PRCHAR		;send to printer
	RET	NZ		;go if error!
	LD	C,E		;reset col count
	DJNZ	SCRPRTL		;finish all rows
	XOR	A		;return Z
	RET			;done!
;
	PAGE
;
;	$FLASH	- flash text on video
;
;	ENT	HL => display string
;
;	EXIT	NZ = A = error code
;		Z  = OK &
;		A  = input char from keyboard
;
@FLASH	CALL	CLRLIN		;clear video line
	RET	NZ		;go if error!
	XOR	A		;clear flag
	LD	(FLFLAG),A	;save flash flag
	LD	(FLASHCT),A	;init counter
;
FLASHOL	LD	A,'$'		;get flash flag
FLFLAG	EQU	$-1
	XOR	1		;reverse bit 0
	LD	(FLFLAG),A	;set new flag
	JR	Z,FLASHCL	;clear line
	CALL	@VDLINE		;display string to video
	RET	NZ		;go if error!
	JR	FLASHOL		;go outer loop
FLASHCL	CALL	CLRLIN		;clear video line
	RET	NZ		;go if error!
;
FLASHIL	CALL	@KBCHAR		;get key character
	JR	Z,FLASHEN	;done, go!
	LD	A,'$'		;get flag
FLASHCT	EQU	$-1
	DEC	A		;less this count
	LD	(FLASHCT),A	;update counter
	JR	NZ,FLASHIL	;continue inner loop
	JR	FLASHOL		;else change video
;
FLASHEN	PUSH	AF		;save input char
	CALL	CLRLIN		;clear video line
	JR	NZ,FLASHER	;go if error!
	POP	AF		;restore char
	RET			;done!
;
FLASHER	EX	(SP),HL		;put HL on stack
	POP	HL		;dummy pop AF from stack
	RET			;return NZ error code
;
CLRLIN	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	A,29		;cursor to begin of line
	CALL	@VDCHAR		;move cursor
	RET	NZ		;go if error
	LD	A,30		;clear current line
	JP	@VDCHAR		;clear line
	ENDIF
;
	IF	TRS2
	LD	A,13		;carriage return
	CALL	@VDCHAR		;move cursor
	RET	NZ		;go if error
	LD	A,11		;up linefeed
	CALL	@VDCHAR		;move cursor
	RET	NZ		;go if error
	LD	A,23		;clear line
	JP	@VDCHAR		;clear line
	ENDIF
;
ZZZZZ	EQU	$
;
