; pmodc/asm - kjw/bqsd - version 3.00
;
; created from WORK?/ASM files
; revised 04/01/83 - kjw
;
@SAVREG	POP	AF		;get caller address
	PUSH	IY		;save registers
	PUSH	IX
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	HL
	LD	HL,SAVREG1	;return vector
	EX	(SP),HL		;leave on stack, get HL
	PUSH	AF		;caller address
	RET			;return!
;
SAVREG1	POP	BC		;unstack 'em
	POP	DE
	POP	HL
	POP	IX
	POP	IY
	RET			;A returned from sub
;
@LOOKUP	PUSH	HL		;save start
	LD	(LOOKCHR),A	;save original char
	CALL	@UCASE		;make upper for search
LOOKUP1	INC	(HL)		;check for terminator
	DEC	(HL)		;(HL) = 00?
	JR	Z,LOOKUP3	;yes, not found!
	CP	(HL)		;matching entry?
	INC	HL		;bump table
	JR	Z,LOOKUP2	;yes, go!
	INC	HL		;bump table to next entry
	INC	HL		;3 bytes each
	JR	LOOKUP1		;try next entry
;
LOOKUP2	LD	A,(HL)		;get LSB vector
	INC	HL		;bump table
	LD	H,(HL)		;get MSB vector
	LD	L,A		;HL = vector
	POP	AF		;dummy pop HL
	XOR	A		;return Z for found
	RET			;done!
;
LOOKUP3	OR	-1		;set NZ for not found
	LD	A,'$'		;restore original
LOOKCHR	EQU	$-1
	POP	HL		;restore table start
	RET			;return NOT FOUND
;
	INC	HL		;bump pointer
@POSHL	LD	A,(HL)		;get character
	CP	' '		;space?
	JR	Z,@POSHL-1	;yes, ignore it
	CP	','		;comma?
	JR	Z,@POSHL-1	;yes, ignore it
CKTERM	CP	03H		;terminator?
	RET	Z		;yes, go!
	CP	0DH		;terminator?
	RET			;return with Z/C flags
;
@UCASE	CP	'a'		;in lowcase range?
	RET	C		;nope, not valid
	CP	'z'+1		;in range?
	RET	NC		;nope, not valid
	SUB	20H		;make upper case
	RET			;done!
;
@ERRMON	SCF			;clear carry flag
	CCF
	RET	Z		;no error, return!
	CALL	@ERROR		;display error message
	CALL	@SAVREG		;save registers
;
ERRASK	LD	HL,ERRMSG	;prompt text
	LD	DE,STRING	;input buffer
	LD	B,1		;single key input
	CALL	@VIDKEY		;display/keyboard
	RET	C		;<BREAK> = QUIT!
	DEC	B		;any keys?
	RET	NZ		;no keys = RETRY
	LD	A,(HL)		;get input key
	CALL	@UCASE		;make upper case
	CP	'Q'		;quit?
	SCF			;carry = yes
	RET	Z		;yes, go!
	CP	'S'		;skip?
	RET	Z		;yes, go!
	CP	'R'		;retry?
	JR	NZ,ERRASK	;invalid, ask again
	OR	-1		;NC/NZ
	RET			;retry!
;
ERRMSG	DEFM	'(R)etry, (S)kip or (Q)uit ? '
	DEFB	3
;
@KBCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save it
	PUSH	IY		;save also
	CALL	002BH		;read keyboard
	POP	IY		;restore
	POP	DE		;restore
	OR	A		;anything?
	JR	Z,$+4		;go if no!
	CP	A		;set Z flag
	RET			;return with char
	OR	8		;set char not avail
	RET			;go!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save it
	LD	A,4		;SVC # kbchar
	RST	08H		;fetch key char
	JR	NZ,$+3		;go if no chars
	LD	A,B		;else get char
	POP	BC		;restore BC
	RET			;done
	ENDIF
;
	IF	LDOSSVC
	LD	A,8		;SVC # kbd
	RST	28H		;scan keyboard
	OR	A		;anything?
	JR	Z,$+4		;go if not!
	CP	A		;set Z/NC
	RET			;done!
	OR	8		;set NZ
	RET			;return no char
	ENDIF
;
@VDCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save it
	PUSH	IY		;save also
	CALL	0033H		;display char
	POP	IY		;restore
	POP	DE		;restore
	RET			;return with status
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	LD	B,A		;pass char
	LD	A,8		;SVC # vdchar
	RST	08H		;display char
	POP	BC		;restore
	RET			;return
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save
	LD	C,A		;pass char
	LD	A,2		;SVC # dsp
	RST	28H		;display char
	POP	BC		;restore
	RET			;done!
	ENDIF
;
@KBLINE	EQU	$
;
	IF	TRS13
	CALL	0040H		;get input line
	LD	A,0		;set NO error
	INC	A		;set Z flag but don't
	DEC	A		;change C flag
	RET			;go!
	ENDIF
;
	IF	TRS2
	LD	A,5		;SVC # kbline
	RST	08H		;get input line
	RET			;return with it
	ENDIF
;
	IF	LDOSSVC
	LD	A,9		;SVC # keyin
	RST	28H		;get line input
	RET			;return with it
	ENDIF
;
@VDLINE	PUSH	HL		;save string start
VDLINY	LD	A,(HL)		;get string char
	CP	3		;terminator?
	JR	Z,VDLINZ	;go if done!
	CALL	@VDCHAR		;send char to video
	JR	NZ,VDLINZ	;go if error!
	INC	HL		;bump pointer
	JR	VDLINY		;go next char
VDLINZ	POP	HL		;restore stack
	RET	NZ		;go if any errors
	XOR	A		;else return ZERO
	RET			;done!
;
@VIDKEY	CALL	@VDLINE		;display prompt string
	EX	DE,HL		;HL => input buffer
	JP	@KBLINE		;get keyboard line
;
@MODEL	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	PUSH	HL		;save HL
	LD	HL,0125H	;point to ROM ID
	CALL	TESTIT		;test byte @ (HL)
	POP	HL		;restore
	LD	BC,2<8+3	;max 80
	JR	Z,MODEZ		;go if RAM there!
	CP	'I'		;mod III?
	LD	B,1		;set mod III
	JR	Z,MODEZ		;go if yes!
	LD	C,B		;set Mod I
MODEZ	XOR	A		;return Z
	RET			;done!
	ENDIF
;
	IF	TRS2
	LD	BC,1<8+2	;set Mod II
	XOR	A		;return Z
	RET			;go!
	ENDIF
;
TESTIT	LD	A,(HL)		;get char @ (HL)
	CPL			;reverse bits
	LD	(HL),A		;load new value
	CP	(HL)		;memory there?
	CPL			;reverse back
	LD	(HL),A		;reset character
	RET			;done!
;
@SETUP	POP	AF		;fix stack
	LD	(STACK),SP	;preserve stack pointer
	PUSH	AF		;reset
	LD	A,I		;read INTERRUPT REG
	PUSH	BC		;save BC
	PUSH	AF		;pass to BC
	POP	BC		;C = F
	LD	(INTLAT),BC	;save interrupt latch
	POP	BC		;restore BC
	XOR	A		;return Z
	RET			;done!
;
@EXIT	LD	SP,$		;reset stack to entry
STACK	EQU	$-2
	PUSH	BC		;save BC
	LD	BC,$		;get interrupt latch
INTLAT	EQU	$-2
	PUSH	BC		;pass to AF
	POP	AF		;F = interrupt status
	POP	BC		;restore stack
	JP	PO,$+4		;go if previously off
	EI			;else re-enable
	XOR	A		;return Z
	RET			;go next sub-level
;
@ERROR	EQU	$
;
	IF	TRS13
	OR	0C0H		;no detail, return
	JP	4409H		;display error & return
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	AND	7FH		;assure a return
	LD	B,A		;pass error code
	LD	A,39		;SVC #
	RST	08H		;display error
	POP	BC		;restore stack
	RET			;done!
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save
	OR	0C0H		;normal + return
	LD	C,A		;pass error code
	LD	A,26		;SVC # error
	RST	28H		;display message
	POP	BC		;restore BC
	RET			;done!
	ENDIF
;
@HIMEM	EQU	$
	IF	TRS13.OR.LDOSSVC
	LD	HL,-1		;start memory @ FFFFH
FTMEM	CALL	TESTIT		;test the byte
	JR	Z,FTMEMH	;have it, go!
	DEC	H		;move back a page
	JR	FTMEM		;continue
FTMEMH	EX	DE,HL		;DE = top physical memory
	CALL	@MODEL		;fetch model number
	LD	HL,4049H	;topmem mod I
	DEC	C		;mod I?
	JR	Z,$+5		;go if yes
	LD	HL,4411H	;topmem mod III/max
	LD	A,(HL)		;get LSB topmem
	INC	HL		;bump pointer
	LD	H,(HL)		;get MSB topmem
	LD	L,A		;HL = topmem
	XOR	A		;set Z
	DEC	B		;trs80?
	LD	BC,4000H	;start RAM trs80
	RET	Z		;go if trs80
	LD	BC,0000H	;start RAM max80
	XOR	A		;set Z
	RET			;go!
	ENDIF
;
	IF	TRS2
	LD	BC,0<8+5	;command #
	LD	A,59		;SVC memctl
	LD	HL,0		;init
	LD	DE,0		;init
	RST	8		;get high/low
	XOR	A		;set NO eror
	LD	B,A		;pass lowest to BC
	LD	C,A		;BC = 0000
	RET			;done
	ENDIF
;
@VSIZE	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	HL,3C00H	;start video
	LD	DE,16*64	;length of video
	LD	BC,16<8+64	;rows / columns
	XOR	A		;return Z
	RET			;done
	ENDIF
;
	IF	TRS2
	LD	HL,0F800H	;start video
	LD	DE,24*80	;length of video
	LD	BC,24<8+80	;rows / columns
	XOR	A		;return Z
	RET
	ENDIF
;
@CLS	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	A,1CH		;home cursor
	CALL	@VDCHAR		;display it
	RET	NZ		;go if error
	LD	A,1FH		;clear to end of frame
	JP	@VDCHAR		;display and return
	ENDIF
;
	IF	TRS2
	LD	A,1BH		;home and clear
	JP	@VDCHAR		;display and return
	ENDIF
;
@VIDCUR	DEC	A		;1?
	JR	Z,SETRC		;set row/column
	DEC	A		;2?
	JR	Z,SETOF		;set offset
	DEC	A		;3?
	JR	Z,GETRC		;get row/column
	DEC	A		;4?
	JR	Z,GETOF		;get offset
	DEC	A		;5?
	JR	Z,CURON		;cursor on
	DEC	A		;6?
	JR	Z,CUROF		;cursor off
;
	IF	TRS13.OR.LDOSSVC
	LD	A,29		;'record out of range' ?
	ENDIF
;
	IF	TRS2
	LD	A,1		;bad function code
	ENDIF
;
	OR	A		;clear carry, set NZ
	RET			;go in error!
;
SETRC	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	PUSH	HL		;save it
	LD	L,B		;fetch row
	LD	H,0		;HL = row #
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,HL		;*8
	ADD	HL,HL		;*16
	ADD	HL,HL		;*32
	ADD	HL,HL		;*64
	LD	A,C		;get column
	ADD	A,L		;add it
	LD	L,A		;HL = offset
	LD	A,H		;get MSB
	ADD	A,3CH		;add offset to video
	LD	H,A		;HL => video memory
	LD	(4020H),HL	;update cursor posit
	POP	HL		;unstack
	XOR	A		;return Z
	RET			;done! cursor set
	ENDIF
;
	IF	TRS2
	PUSH	DE		;save it
	LD	D,0		;# chars to display
	LD	A,10		;SVC # vdgraf
	RST	08H		;set cursor
	POP	DE		;restore stack
	RET			;return with status
	ENDIF
;
SETOF	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	(4020H),BC	;set offset
	XOR	A		;return Z
	RET			;done, cursor set!
	ENDIF
;
	IF	TRS2
	PUSH	IX		;save it
	PUSH	BC		;save row/col
	LD	C,1		;device #
	LD	A,60		;SVC #
	RST	8		;get dcb
	POP	BC		;restore offset
	LD	(IX+10),C
	LD	(IX+11),B
	POP	IX		;restore
	XOR	A		;return Z
	RET			;done!
	ENDIF
;
GETRC	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	PUSH	HL		;save HL
	LD	HL,(4020H)	;get cursor address
	LD	A,L		;get LSB
	AND	3FH		;get column
	LD	C,A		;C = column
	LD	A,H		;get MSB
	AND	3		;low 2 bits only
	RL	L		;move bit 7 => carry
	RLA			;move carry => accum
	RL	L		;move bit 6 => carry
	RLA			;move carry => accum
	LD	B,A		;B = row
	POP	HL		;restore stack
	XOR	A		;return Z
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	DE		;save it
	LD	D,0		;# chars to fetch
	LD	A,11		;SVC # vdread
	RST	08H		;fetch cursor to BC
	POP	DE		;restore stack
	RET			;return dos status
	ENDIF
;
GETOF	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,(4020H)	;get cursor address
	XOR	A		;return Z
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	IX		;save
	LD	C,1		;video DCB #
	LD	A,60
	RST	8
	LD	C,(IX+10)	;get LSB cursor
	LD	B,(IX+11)	;get MSB cursor
	POP	IX		;restore stack
	XOR	A		;return Z
	RET			;done!
	ENDIF
;
CURON	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	A,14		;cursor ON char
	ENDIF
;
	IF	TRS2
	LD	A,01		;cursor ON char
	ENDIF
;
	JP	@VDCHAR		;turn cursor ON
;
CUROF	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	A,15		;cursor OFF char
	ENDIF
;
	IF	TRS2
	LD	A,02		;cursor OFF char
	ENDIF
;
	JP	@VDCHAR		;turn cursor OFF
;
@VPOKE	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	LD	(HL),A		;character to video
	CP	A		;return Z
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save
	LD	B,A		;pass char
	LD	A,89
	RST	8
	LD	(HL),B		;char to video
	LD	A,90
	RST	8
	LD	A,B		;get char back
	CP	A		;set Z flag
	POP	BC		;restore stack
	RET			;done!
	ENDIF
;
@VPEEK	EQU	$
;
	IF	TRS13.OR.LDOSSVC
	XOR	A		;return Z
	LD	A,(HL)		;fetch char direct
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save it
	LD	A,89
	RST	8
	LD	B,(HL)		;get char
	LD	A,90
	RST	8
	XOR	A		;return Z
	LD	A,B		;get char
	POP	BC		;restore stack
	RET			;done!
	ENDIF
;
@VIDRAM	EX	AF,AF'		;save command
	CALL	@SAVREG		;save registers
	EX	AF,AF'		;get command back
	DEC	A		;1?
	JR	Z,VDRAM1	;put row/col
	DEC	A		;2?
	JR	Z,VDRAM3	;get row/col
	DEC	A		;3?
	JR	Z,VDRAM2	;put offset
	DEC	A		;4?
	JR	Z,VDRAM4	;get offset
;
	IF	TRS13.OR.LDOSSVC
	LD	A,29		;'record out of range' ?
	ENDIF
;
	IF	TRS2
	LD	A,1		;'bad function code'
	ENDIF
;
	OR	A		;clear carry, set NZ
	RET			;return error
;
VDRAM3	CALL	SAVCUR		;save current cursor
	LD	A,C		;get start column
	LD	(VDRAM31),A	;save it
	LD	A,E		;get # columns
	LD	(VDRAM32),A	;save it
;
VDRAM3O	LD	C,'$'		;get start column
VDRAM31	EQU	$-1
	LD	E,'$'		;get # columns
VDRAM32	EQU	$-1
;
VDRAM3I	LD	A,1		;setcur by row/col
	CALL	@VIDCUR		;set cursor
	PUSH	BC		;save row/col
	LD	A,4		;getcur by offset
	CALL	@VIDCUR		;BC = offset
	PUSH	HL		;save HL
	LD	H,B		;pass BC => HL
	LD	L,C		;HL => video memory
	CALL	@VPEEK		;read video char
	POP	HL		;restore buffer
	LD	(HL),A		;char to buffer
	POP	BC		;restore row/col
	INC	HL		;bump video
	INC	C		;bump column
	DEC	E		;less column
	JR	NZ,VDRAM3I	;go inner loop till done
	INC	B		;bump row
	DEC	D		;less row
	JR	NZ,VDRAM3O	;go outer loop till done
	JR	FETCUR		;restore old cursor
;
VDRAM1	CALL	SAVCUR		;save cursor
	LD	A,C		;get start column
	LD	(VDRAM11),A	;save it
	LD	A,E		;get # columns
	LD	(VDRAM12),A	;save it
;
VDRAM1O	LD	C,'$'		;get start column
VDRAM11	EQU	$-1
	LD	E,'$'		;get # columns
VDRAM12	EQU	$-1
;
VDRAM1I	LD	A,1		;setcur by row/col
	CALL	@VIDCUR		;set cursor
	PUSH	BC		;save row/col
	LD	A,4		;getcur by offset
	CALL	@VIDCUR		;get cursor
	PUSH	HL		;save buffer
	LD	A,(HL)		;get buffer char
	LD	H,B		;pass offset to HL
	LD	L,C		;HL => video
	CALL	@VPOKE		;write to video
	POP	HL		;restore
	POP	BC		;restore row/col
	INC	HL		;bump buffer
	INC	C		;bump column
	DEC	E		;less col count
	JR	NZ,VDRAM1I	;finish current row
	INC	B		;bump row
	DEC	D		;less row count
	JR	NZ,VDRAM1O	;finish col count
	JR	FETCUR		;restore old cursor
;
VDRAM2	CALL	SAVCUR		;save old cursor
	PUSH	DE		;save byte count
	LD	A,2		;set cursor offset
	CALL	@VIDCUR		;BC = video offset
	LD	D,B		;pass to DE
	LD	E,C		;DE = video offset
	POP	BC		;BC = byte count
	JR	VDRAM24		;go common
;
VDRAM4	CALL	SAVCUR		;save old cursor
	PUSH	DE		;save byte count
	LD	A,2		;set cursor offset
	CALL	@VIDCUR		;BC = video offset
	LD	D,B		;pass to DE
	LD	E,C		;DE => video
	POP	BC		;get byte count
	EX	DE,HL		;DE => buffer, HL=> video
;
VDRAM24	EQU	$
;
	IF	TRS2
	LD	A,89
	RST	8
	ENDIF
	LDIR			;move it in
	IF	TRS2
	LD	A,90
	RST	8
	ENDIF
;
;	restore previous cursor position
;
FETCUR	LD	BC,$		;get offset
OLDCUR	EQU	$-2
	LD	A,2		;put cursor offset
	CALL	@VIDCUR		;reset cursor
	XOR	A		;return Z
	RET			;done!
;
;	save current cursor position
;
SAVCUR	PUSH	BC		;save row/col/offset
	LD	A,4		;get cursor offset
	CALL	@VIDCUR		;get it
	LD	(OLDCUR),BC	;save for cursor reset
	POP	BC		;restore
	RET			;done!
;
@FSPEC	PUSH	HL		;save string start
	PUSH	BC		;need to use
	PUSH	DE		;save DCB start
	XOR	A		;clear flags
	LD	(DE),A		;to first byte
	INC	DE		;bump pointer
	DEC	HL		;move HL back
	CALL	MOVBLK8		;move in block
	JR	NZ,CKDEV	;check for device only
	JR	NC,MBLK1	;no wild card chars
;
	EX	(SP),HL		;get first DCB byte
	SET	5,(HL)		;set wild card bit
	EX	(SP),HL		;update
;
MBLK1	EX	(SP),HL		;get DCB byte
	SET	6,(HL)		;set contains file
	EX	(SP),HL		;swap back
;
	CP	'/'		;extension?
	JR	NZ,FSPEC1	;go if not
	LD	(DE),A		;to buffer
	INC	DE		;bump pointer
	LD	B,3		;3 char extension
	CALL	MOVBLK-1	;move it in
	JR	NZ,FSPCER	;go if invalid!
	JR	NC,FSPEC1	;go if not
	EX	(SP),HL		;get flags back
	SET	5,(HL)		;set WILD bit
	EX	(SP),HL		;swap back
;
FSPEC1	CP	'.'		;password?
	JR	NZ,FSPEC2	;go if not
	LD	(DE),A		;char to buffer
	INC	DE		;bump pointer
	CALL	MOVBLK8		;move it in!
	JR	NZ,FSPCER	;go if invalid!
	JR	C,FSPCER	;go if wild card chars!
;
FSPEC2	CP	':'		;drive #?
	JR	NZ,FSPEC3	;nope, terminate
;
;	check for wild card chars & device
;
FSPEC4	EX	(SP),HL		;get flags
	BIT	5,(HL)		;wild here?
	EX	(SP),HL		;swap back
	JR	NZ,FSPEC3	;terminate now if yes
;
	LD	(DE),A		;move into string
	INC	DE		;bump pointer
	LD	B,2		;up to 2 chars in drive
	CALL	MOVBLK-1	;move it in!
	JR	NZ,FSPCER	;go if error!
	EX	(SP),HL		;get flags
	SET	7,(HL)		;set device evaluated
	EX	(SP),HL		;resave
;
FSPEC3	LD	A,3		;end of text
	LD	(DE),A		;to string
	POP	DE		;DCB start
	POP	BC		;restore BC
	POP	AF		;dummy pop HL start
	XOR	A		;set NO error
	RET			;done!
;
FSPCER	LD	A,19		;'illegal filename'
	POP	DE		;restore DCB start
	POP	BC		;restore
	POP	HL		;original string start
	OR	A		;set NZ for error
	RET			;done!
;
;	check for DEVICE specification
;
CKDEV	CP	':'		;drive only?
	JR	Z,FSPEC4	;go if yes
	CP	'*'		;device?
	JR	Z,FSPEC4	;go if yes
	CP	'@'		;device?
	JR	Z,FSPEC4	;go if yes
	JR	FSPCER		;go if none of above!
;
MOVBLK8	LD	B,8		;go for 8 chars
;
	INC	HL		;bump string pointer
MOVBLK	LD	A,-1		;set ERROR
	OR	A		;set flags
	EX	AF,AF'		;save flags
;
MOVBLK1	LD	A,(HL)		;get string char
	CALL	VALCHR		;valid character?
	JR	Z,MOVBLK5	;go if invalid!
	INC	HL		;bump pointer
;
	CP	'?'		;wild?
	JR	Z,MOVBLK2	;go if yes!
	CP	'!'		;wild?
	JR	Z,MOVBLK2	;go if yes!
	CP	'$'		;wild?
	JR	NZ,MOVBLK3	;go if neither
;
MOVBLK2	EX	AF,AF'		;get flags
	SCF			;carry = wild chars
	EX	AF,AF'		;swap back
;
MOVBLK3	CALL	@UCASE		;make upper case
	LD	(DE),A		;to dcb
	INC	DE		;bump pointer
	EX	AF,AF'		;get flags back
	LD	A,0		;load zero
	INC	A		;set Z flag but do not
	DEC	A		;affect carry flag
	EX	AF,AF'		;save in A'
	DJNZ	MOVBLK1		;continue for length
;
MOVBLK5	EX	AF,AF'		;get flags back
	LD	A,(HL)		;return with next char
	RET			;done!
;
VALCHR	PUSH	BC		;save
	PUSH	HL		;save
	LD	HL,CHARTBL	;invalid char table
	LD	BC,CHARLEN	;length of table
	CPIR			;find it!
	POP	HL		;restore
	POP	BC		;restore
	RET			;Z = invalid char!
;
CHARTBL	DEFB	'('
	DEFB	')'
	DEFB	','
	DEFB	'.'
	DEFB	'/'
	DEFB	';'
	DEFB	' '
	DEFB	':'
	DEFB	'@'
	DEFB	'*'
	DEFB	'='
	DEFB	'"'
	DEFB	27H
	DEFB	03H
	DEFB	0DH
	DEFB	7BH
	DEFB	7DH
CHARLEN	EQU	$-CHARTBL
;
@OPEN	EQU	$
;
	IF	TRS13
	PUSH	BC		;save
	LD	B,A		;pass LRL
	CALL	4424H		;open existing file
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	TRS2
	LD	(OLISTL),A	;pass LRL
	LD	(OLISTI),HL	;pass I/O buffer
	LD	(OLISTB),BC	;pass blocking buffer
	PUSH	HL		;save
	LD	HL,OLIST	;start param list
	XOR	A		;open type code
	LD	(OLISTT),A	;pass it
	LD	A,40		;SVC # open
	RST	08H		;open file
	POP	HL		;restore HL
	RET			;return with status
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save BC
	LD	B,A		;pass LRL
	LD	A,59		;SVC # open
	RST	28H		;open file
	POP	BC		;restore
	RET			;done!
	ENDIF
;
;	open param list for Mod II/12/16
;
	IF	TRS2
OLIST	EQU	$
OLISTI	DEFW	0000H		;I/O buffer
OLISTB	DEFW	0000H		;blocking buffer
	DEFW	0000H		;end of file xfer address
	DEFB	'W'		;access type read/write
OLISTL	DEFB	0		;logical record length
	DEFB	'E'		;access mode extended
OLISTT	DEFB	0		;creation code
	DEFB	0		;list terminator
	ENDIF
;
@POSN	EQU	$
;
	IF	TRS13
	PUSH	BC		;save pointer
	PUSH	HL		;save for use
	LD	H,B		;pass BC => HL
	LD	L,C		;HL => record
	INC	HL		;bump it
	LD	B,(HL)		;get NSB
	INC	HL		;bump it
	LD	C,(HL)		;get LSB
	POP	HL		;restore
	CALL	4442H		;position to record
	POP	BC		;restore
	RET			;done!
	ENDIF
;
	IF	TRS2
	LD	A,79		;SVC # posn
	RST	08H		;position to record
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	PUSH	BC		;save it
	PUSH	HL		;save it
	LD	H,B		;pass rec # to HL
	LD	L,C		;HL => 3 byte record
	INC	HL		;ignore MSB
	LD	B,(HL)		;get NSB
	INC	HL		;bump pointer
	LD	C,(HL)		;get LSB
	POP	HL		;restore
	LD	A,66		;SVC # posn
	RST	28H		;position file
	POP	BC		;restore BC
	RET			;done, return status
	ENDIF
;
@READ	EQU	$
;
	IF	TRS13
	JP	4436H		;read record!
	ENDIF
;
	IF	TRS2
	LD	A,34		;SVC # readnx
	RST	08H		;read record!
	RET			;return with status
	ENDIF
;
	IF	LDOSSVC
	LD	A,67		;SVC # read
	RST	28H		;read record
	RET			;return status
	ENDIF
;
@WRITE	EQU	$
;
	IF	TRS13
	JP	4439H		;write next record
	ENDIF
;
	IF	TRS2
	LD	A,43		;SVC # writnx
	RST	08H		;write next record!
	RET			;return with status
	ENDIF
;
	IF	LDOSSVC
	LD	A,75		;SVC # write
	RST	28H		;write record
	RET			;return status
	ENDIF
;
@DSIZE	EQU	$
;
	IF	TRS13.AND.LDOS.OR.LDOSSVC
	PUSH	IY		;save it
	CALL	478FH		;locate DCT address
	LD	B,(IY+9)	;dir track
	LD	C,(IY+6)	;highest cylinder
	INC	C		;# cylinders
	BIT	3,(IY+3)	;rigid?
	JR	Z,DSIZE1	;go if not
	BIT	5,(IY+4)	;double cyl count?
	JR	Z,DSIZE1	;go if not
	SLA	C		;double cyl count
DSIZE1	LD	A,(IY+8)	;DCT data
	AND	1FH		;low 5 bits
	INC	A		;adjust to actual
	LD	D,A		;sectors / gran
	LD	A,(IY+8)	;DCT data
	RLCA			;move bits 7-5 => 2-0
	RLCA
	RLCA
	AND	7		;low 3 bits only
	INC	A		;adjust to actual
	BIT	3,(IY+3)	;rigid drive?
	JR	NZ,DSIZE2	;go if yes
	BIT	5,(IY+4)	;2 sided?
	JR	Z,DSIZE2	;go if not
	ADD	A,A		;double it
DSIZE2	LD	E,A		;grans / cylinder
	LD	A,(IY+7)	;DCT data
	AND	1FH		;low 5 bits only
	LD	H,A		;highest sector #
	BIT	3,(IY+3)	;rigid?
	JR	NZ,DSIZE22	;go if yes
	BIT	5,(IY+4)	;2 sides?
	JR	Z,DSIZE4	;go if not
	INC	A		;# sectors / track
	ADD	A,A		;*2
	DEC	A		;adjust back
	LD	H,A		;highest sector #
	JR	DSIZE4		;continue
;
DSIZE22	INC	H		;H = # sectors/head
	LD	A,(IY+7)	;get # heads
	RLCA			;move 5-7 => 0-2
	RLCA
	RLCA
	AND	7		;0-7 only
	INC	A		;1-8 only
	LD	L,A		;pass count
	XOR	A		;init zero
DSIZE3	ADD	A,H		;add highest sector
	DEC	L		;less counter
	JR	NZ,DSIZE3	;continue
	DEC	A		;less one
	LD	H,A		;H = highest sector
DSIZE4	POP	IY		;restore stack
	XOR	A		;return Z
	LD	L,A		;lowest sector #
	RET			;done!
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	PUSH	IY		;save it
	CALL	@MODEL		;mod I/III?
	DEC	C		;mod I?
	LD	BC,448BH	;vector Mod I
	JR	Z,$+5		;go if yes
	LD	BC,44A3H	;vector Mod III
	LD	(DSIZV),BC	;save vector
	CALL	$		;locate DCT
DSIZV	EQU	$-2
	LD	B,(IY+18)	;get dir cylinder
	LD	C,(IY+19)	;get cylinder count
	LD	D,(IY+15)	;get sectors / gran
	LD	E,(IY+16)	;get grans / cylinder
	LD	H,(IY+17)	;get sects / cylinder
	DEC	H		;highest sector #
	POP	IY		;restore stack
	XOR	A		;return Z
	LD	L,A		;lowest sector #
	RET			;done!
	ENDIF
;
	IF	TRS2
	PUSH	IY		;save it
	LD	A,61
	RST	8
	LD	B,(IY+22)	;dir cylinder
	LD	C,(IY+15)	;cylinder count
	LD	D,(IY+24)	;sectors / gran
	LD	E,(IY+25)	;grans / cylinder
	LD	H,(IY+20)	;sectors / cylinder
	DEC	H		;highest sector
	POP	IY		;restore stack
	XOR	A		;return Z
	LD	L,A		;lowest sector #
	RET			;done!
	ENDIF
;
@DCHECK	EQU	$
;
	IF	TRS13.AND.LDOS
	PUSH	BC		;save
	CALL	@MODEL		;get model #
	DEC	C		;mod I?
	LD	BC,44B8H	;chkdrv I
	JR	Z,$+5		;go if mod I
	LD	BC,4209H	;chkdrv III
	LD	(CHKCAL),BC	;save call vector
	POP	BC		;restore BC
	JP	$		;check drive
CHKCAL	EQU	$-2
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	XOR	A		;command 0
	JR	DOSPDSK		;go common I/O
	ENDIF
;
	IF	TRS2
	LD	A,1
	RST	10H		;execute disk command
	RET			;done!
	ENDIF
;
	IF	LDOSSVC
	LD	A,33		;SVC # ckdrv
	RST	28H		;check drive
	RET			;return status
	ENDIF
;
@RDSEC	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	4777H		;read data sector
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,3		;command #
	JR	DOSPDSK		;go common
	ENDIF
;
	IF	TRS2
	LD	A,4		;command #
	PUSH	BC		;save
	LD	B,0		;MSB sector #
	RST	10H		;disk I/O
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	LD	A,49		;SVC # rdsect
	RST	28H		;read sector
	RET			;return status
	ENDIF
;
@WRSEC	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	4763H		;write sector
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,5		;command #
	JR	DOSPDSK		;go common
	ENDIF
;
	IF	TRS2
	LD	A,7		;command #
	PUSH	BC		;save
	LD	B,0		;MSB sector #
	RST	10H		;disk I/O
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	LD	A,53		;SVC # wrsect
	RST	28H		;write sector
	RET			;return status
	ENDIF
;
@WRDAM	EQU	$
;
	IF	TRS13.AND.LDOS
	JP	4768H		;write with A/M
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	LD	A,8		;command #
	JR	DOSPDSK		;go common I/O
	ENDIF
;
	IF	TRS2
	LD	A,9		;command #
	PUSH	BC		;save
	LD	B,0		;MSB sector #
	RST	10H		;write
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	LDOSSVC
	LD	A,54		;SVC # wrprot
	RST	28H		;write the sector
	RET			;return with status
	ENDIF
;
;	dosplus common disk I/O
;
	IF	TRS13.AND.DOSPLUS
DOSPDSK	PUSH	AF		;save command
	PUSH	BC		;save BC
	CALL	@MODEL		;get mod I/III
	DEC	C		;mod I?
	LD	BC,4485H	;vector Mod I
	JR	Z,$+5		;go if I
	LD	BC,4488H	;vector Mod III
	LD	(DSKCAL),BC	;save vector
	POP	BC		;restore BC
	POP	AF		;restore command
	JP	$		;go disk I/O
DSKCAL	EQU	$-2
	ENDIF
;
@MULT	PUSH	IX		;save
	PUSH	DE		;save
;
	PUSH	BC		;save
	LD	A,C		;get multiplier
	LD	C,B		;pass MSB
	EX	DE,HL		;CDE = multiplicand
	LD	HL,0		;init MSB's
	LD	IX,0		;init LSB's
	LD	B,8		;multiplier precision
;
MULT1	ADD	IX,IX		;shift LSB's left
	ADC	HL,HL		;shift MSB's left
	RLCA			;catch overflow
	JR	NC,MULT2	;go if none
	PUSH	BC		;save count/MSB
	ADD	IX,DE		;result + multiplicand
	LD	B,0		;init MSB
	ADC	HL,BC		;catch overflow
	POP	BC		;restore
;
MULT2	DJNZ	MULT1		;for for precision
	POP	BC		;restore C register
	LD	A,H		;get MSB
	LD	B,L		;get NSB
	PUSH	IX		;pass LSB's to HL
	POP	HL		;ABHL = result
	POP	DE		;unstack
	POP	IX		;unstack
	RET			;done, C unchanged
;
@INC	INC	L		;bump LSB
	RET	NZ		;not FF => 00
	INC	H		;bump NSB
	RET	NZ		;not FF => 00
	INC	B		;bump MSB
	RET			;BHL = BHL + 1
;
@DEC	LD	A,-1		;init for test
	DEC	L		;dec LSB
	CP	L		;00 => FF?
	RET	NZ		;go if not
	DEC	H		;dec NSB
	CP	H		;00 => FF?
	RET	NZ		;go if not
	DEC	B		;dec MSB
	RET			;BHL = BHL - 1
;
@BINASC	CALL	@SAVREG		;save registers
	PUSH	DE		;pass DE => IX
	POP	IX		;IX => string start
	LD	A,C		;get precision
	LD	IY,TENTBL3	;lookup table for places
	CP	3		;3 bytes?
	JR	Z,BINASC1	;go if yes!
	LD	B,0		;init MSB to nil
	LD	IY,TENTBL2	;2 digits
	CP	2		;2 bytes?
	JR	Z,BINASC1	;yes, go!
	LD	H,B		;init NSB to nil
	LD	IY,TENTBL1	;1 digit
;
BINASC1	LD	(IX+0),'0'	;init digit
	LD	C,(IY+0)	;get MSB
	LD	D,(IY+1)	;get NSB
	LD	E,(IY+2)	;get LSB
;
BINASC2	CALL	@SUB		;subtract CDE from BHL
	JR	C,BINASC3	;go if digit found
	INC	(IX+0)		;bump ascii digit
	JR	BINASC2		;continue
;
BINASC3	CALL	@ADD		;add last subtract
	INC	IX		;bump string
	INC	IY		;bump table
	INC	IY		;3 bytes each entry
	INC	IY
	DEC	E		;at end?
	JR	NZ,BINASC1	;nope, go for length!
	RET			;done!
;
TENTBL3	DEFB	098H,096H,080H	;10,000,000
	DEFB	00FH,042H,040H	;1,000,000
	DEFB	001H,086H,0A0H	;100,000
TENTBL2	DEFB	000H,027H,010H	;10,000
	DEFB	000H,003H,0E8H	;1,000
TENTBL1	DEFB	000H,000H,064H	;100
	DEFB	000H,000H,00AH	;10
	DEFB	000H,000H,001H	;1
;
@VALUE	PUSH	HL		;save input pointer
	CALL	POSEND		;find last valid char
;
	LD	HL,ADDHEX	;HEX adder
	LD	B,16		;base
	CP	'H'		;hex?
	JR	Z,GOVAL		;yes, go!
;
	LD	HL,ADDOCT	;OCTAL adder
	LD	B,8		;base
	CP	'O'		;octal?
	JR	Z,GOVAL		;yes, go!
	CP	'Q'		;octal?
	JR	Z,GOVAL		;yes, go!
;
	LD	HL,ADDBIN	;BINARY adder
	LD	B,2		;base
	CP	'B'		;binary?
	JR	Z,GOVAL		;yes, go!
;
	LD	HL,ADDDEC	;DECIMAL adder
	LD	B,10		;base
	CP	'D'		;decimal?
	JR	Z,GOVAL		;yes, go!
	XOR	A		;default decimal
;
GOVAL	LD	(ADDCALL),HL	;pass call vector
	LD	(ADDTERM),A	;pass term character
	LD	A,B		;get base
	LD	(ADDMAX),A	;for max digit test
	POP	HL		;restore string start
	LD	C,0		;init MSB
	LD	D,C		;init NSB
	LD	E,C		;init LSB
;
;	loop to evaluate numeric input
;
VALLP	LD	A,(HL)		;get string char
	CALL	@UCASE		;make upper case
	CALL	CKTERM		;terminator?
	JR	Z,VALOK		;yes, go!
	INC	HL		;bump string pointer
	CP	'$'		;base specifier?
ADDTERM	EQU	$-1
	JR	Z,VALOK		;yes, go!
	CP	' '		;space?
	JR	Z,VALOK		;yes, go!
	CP	','		;comma?
	JR	Z,VALOK		;yes, go!
;
;	convert character
;
	CALL	CONVCHR		;convert to binary
	RET	NZ		;error! invalid char!
	EX	DE,HL		;HL = subtotal
	LD	B,A		;save new digit
	LD	A,C		;get MSB
	CALL	$		;multiply times base
ADDCALL	EQU	$-2
	LD	C,B		;pass new digit
	LD	B,0		;BC = new digit
	ADD	HL,BC		;add new digit
	ADC	A,0		;catch overflow
	LD	C,A		;update MSB
	EX	DE,HL		;DE=NSB/LSB - HL=>string
	JR	VALLP		;go next character
;
VALOK	LD	B,3		;precision
	INC	C		;C = 0?
	DEC	C		;yes?
	JR	NZ,VALRET	;nope, precision CDE
	DEC	B		;precision
	INC	D		;D = 0?
	DEC	D		;yes?
	JR	NZ,VALRET	;nope, precision DE
	DEC	B		;precision
	INC	E		;E = 0?
	DEC	E		;yes?
	JR	NZ,VALRET	;nope, precision E
	DEC	B		;precision 000000H!
VALRET	XOR	A		;return Z
	RET			;done!
;
;	digit to binary conversion
;
CONVCHR	SUB	'0'		;remove ascii
	JR	C,CHBAD		;go if <'0'
	CP	10		;0-9?
	JR	C,CHOK		;yes, go!
	SUB	7		;A-F?
	JR	C,CHBAD		;go if invalid
CHOK	CP	'$'		;test to base
ADDMAX	EQU	$-1
	JR	NC,CHBAD	;>= base
	CP	A		;set Z flag
	RET			;done!
CHBAD	OR	-1		;set NZ error
	RET			;return
;
;	hex/octal adder
;
ADDHEX	ADD	HL,HL		;*02
	RLA			;catch carry
ADDOCT	ADD	HL,HL		;*04 - *02
	RLA			;catch carry
	ADD	HL,HL		;*08 - *04
	RLA			;catch carry
	ADD	HL,HL		;*16 - *08
	RLA			;catch carry
	RET			;HL = HL * 16/08
;
;	decimal/binary adder
;
ADDDEC	LD	(ADDECX),A	;save current MSB
	PUSH	BC		;save
	LD	B,H		;pass current NSB
	LD	C,L		;pass current LSB
	ADD	HL,HL		;*02
	RLA			;catch carry
	ADD	HL,HL		;*04
	RLA			;catch carry
	ADD	HL,BC		;*05
	ADC	A,'$'
ADDECX	EQU	$-1
	POP	BC		;restore BC
ADDBIN	ADD	HL,HL		;*10 - *02
	RLA			;catch carry
	RET			;done
;
;	position to last char for base specifier
;
	INC	HL		;bump pointer
POSEND	LD	A,(HL)		;get a char
	CALL	CKTERM		;terminator?
	JR	Z,POSHAV	;have it, go!
	CP	' '		;space?
	JR	Z,POSHAV	;yes, go!
	CP	','		;comma?
	JR	NZ,POSEND-1	;go next char if none
POSHAV	DEC	HL		;last valid char
	LD	A,(HL)		;get the char
	JP	@UCASE		;make upper case for test
;
	PAGE
;
;	$ADD	- triple precision addition (BHL=BHL+CDE)
;
;	ENT	BHL = factor 1
;		CDE = factor 2
;
;	EXIT	BHL = sum
;
@ADD	LD	A,L		;get LSB
	ADD	A,E		;add LSB
	LD	L,A		;update
	LD	A,H		;get NSB
	ADC	A,D		;add NSB
	LD	H,A		;update
	LD	A,B		;get MSB
	ADC	A,C		;add MSB
	LD	B,A		;update
	RET			;BHL = sum
;
	PAGE
;
;	$SUB	- triple precision subtract (BHL=BHL-CDE)
;
;	ENT	BHL = factor 1
;		CDE = factor 2
;
;	EXIT	BHL = difference
;
@SUB	LD	A,L		;get LSB
	SUB	E		;less LSB
	LD	L,A		;update
	LD	A,H		;get NSB
	SBC	A,D		;less NSB
	LD	H,A		;update
	LD	A,B		;get MSB
	SBC	A,C		;less MSB
	LD	B,A		;update
	RET			;BHL = difference
;
