; pmodb/asm - kjw/bqsd - 06/82 - version 3.0 - 03/83
;
; created 06/82 - kjw
; revised 04/15/83 - kjw
;
;	cursor positioning commands
;
MODR	CALL	MODRX		;right one space
	RET	NC		;did not cross row
	CALL	MODDX		;move down
	JR	NC,MODLE	;go if OK
;
MODRCNT	LD	A,(TYPE)	;get modify type
	CP	1		;from memory?
	SCF			;set row end exceed
	RET	NZ		;cannot move
;
;	fetch additional block of memory
;
	LD	HL,(ADDRESS)	;get buffer address
	LD	BC,16		;# bytes to bring in
	ADD	HL,BC		;HL = new start address
	LD	(ADDRESS),HL	;re-save it
	EX	DE,HL		;get cursor offset
	ADD	HL,BC		;add new length
	EX	DE,HL		;update
	CALL	AASHOW		;re-display data
	JP	MODLE		;cursor to left end
;
MODTOP	LD	A,0		;get offset
TEMP2	EQU	$-1
	LD	B,A		;save for loop
	OR	A		;at top?
	RET	Z		;yes, go!
;
MODTOPL	PUSH	BC		;save count
	CALL	MODL		;move left
	POP	BC		;restore
	DJNZ	MODTOPL		;for length
	RET			;done
;
MODRX	PUSH	IX		;IX => hex
	POP	BC		;BC => hex video
	LD	A,2		;command
	CALL	@VIDCUR		;setup cursor there
	LD	A,3		;command
	CALL	@VIDCUR		;get row/column
	LD	A,C		;get column
	CP	2DH		;check for hex limit
	SCF			;C = at end!
	RET	Z		;yes, return!
;
;	OK to advance current row
;
	INC	IX		;bump hex pointer
	INC	IX		;2 chars/byte
	INC	IY		;bump ascii pointer
	INC	DE		;bump data address
	PUSH	IX		;pass IX => HL
	POP	HL		;HL => current video
	CALL	@VPEEK		;read char at cursor
	CP	' '		;blank?
	SCF			;clear carry flag
	CCF
	RET	NZ		;go if not blank
	INC	IX		;bump past gap
	RET			;Z flag doesn't matter
;
MODRE	LD	B,16		;row count
MODREX	PUSH	BC		;save count
	CALL	MODRX		;right one place
	POP	BC		;get count
	DJNZ	MODREX		;go for count
	RET			;done!
;
MODL	CALL	MODLX		;left same row
	RET	NC		;not at end
	CALL	MODUX		;move up a row
	JR	NC,MODRE	;left side if not past
;
MODLCNT	LD	A,(TYPE)	;get modify mode type
	CP	1		;from memory?
	SCF			;set edge
	RET	NZ		;cannot bring in more
;
;	bring in more data
;
	LD	HL,(ADDRESS)	;get current address
	LD	BC,-16		;data offset
	ADD	HL,BC		;subtract
	LD	(ADDRESS),HL	;save new address
	EX	DE,HL		;get current offset
	ADD	HL,BC		;subtract
	EX	DE,HL		;swap back
	CALL	AASHOW		;re-display data
	JP	MODRE		;cursor to right end
;
MODLE	LD	B,16		;init count
MODLEX	PUSH	BC		;save count
	CALL	MODLX		;left one place
	POP	BC		;get count
	DJNZ	MODLEX		;go for count
	RET			;done!
;
MODLX	PUSH	IX		;pass video => HL
	POP	BC		;BC = current video
	LD	A,2		;command
	CALL	@VIDCUR		;set cursor
	LD	A,3		;command
	CALL	@VIDCUR		;get row/column
	LD	A,C		;get column
	CP	8		;in range?
	SCF			;C = at edge
	RET	Z		;cannot move
	DEC	IX		;dec hex side
	DEC	IX		;two bytes each
	DEC	IY		;less ascii side
	DEC	DE		;less buff pointer
	PUSH	IX		;pass IX => HL
	POP	HL
	INC	HL		;+1
	CALL	@VPEEK		;read char @ (HL)
	CP	' '		;blank?
	SCF			;clear carry
	CCF
	RET	NZ		;OK
	DEC	IX		;once more back
	RET			;done!
;
MODU	CALL	MODUX		;move up
	RET	NC		;done
	JP	MODLCNT		;continue
;
MODUE	LD	B,16		;count
MODUEX	PUSH	BC		;save count
	CALL	MODUX		;up a row
	POP	BC		;restore count
	DJNZ	MODUEX		;for count
	RET			;done
;
MODUX	PUSH	DE		;save buff
	CALL	@VSIZE		;C = # columns
	LD	B,0		;BC = # cols
	EX	DE,HL		;DE = start video
	LD	H,B		;init to zero
	LD	L,H		;HL = 0000
	SBC	HL,BC		;HL = 0 - BC
	LD	B,H		;pass back to BC
	LD	C,L		;BC = 0 - BC
	PUSH	IX		;pass IX => HL
	POP	HL		;HL => current video
	ADD	HL,BC		;less a row
	LD	A,H		;get MSB result
	CP	D		;below video?
	POP	DE		;restore buffer
	RET	C		;nope, go!
	ADD	IX,BC		;less hex pointer
	ADD	IY,BC		;less ascii pointer
	EX	DE,HL		;HL => buffer
	LD	BC,-16		;moving 16 bytes
	ADD	HL,BC		;move
	EX	DE,HL		;swap back
	OR	A		;clear carry
	RET			;done!
;
MODD	CALL	MODDX		;down
	RET	NC		;not at edge
	JP	MODRCNT		;continue
;
MODDE	LD	B,16		;count
MODDEX	PUSH	BC		;save
	CALL	MODDX		;move down
	POP	BC		;get count
	DJNZ	MODDEX		;go for length
	RET			;done!
;
MODDX	PUSH	DE		;save
	CALL	@VSIZE		;get video cols
	ADD	HL,DE		;HL => end of video
	EX	DE,HL		;DE => end
	LD	B,0		;BC = # cols
	PUSH	IX		;pass IX => HL
	POP	HL		;HL = video
	ADD	HL,BC		;HL = HL + row
	LD	A,H		;get MSB
	CP	D		;in range?
	CCF			;reverse carry
	POP	DE		;restore stack
	RET	C		;go if out of range
	ADD	IX,BC		;add hex offset
	ADD	IY,BC		;add ascii offset
	EX	DE,HL		;HL => data
	LD	C,16		;data offset
	ADD	HL,BC		;new data
	EX	DE,HL		;swap back
	OR	A		;clear carry
	RET			;done!
;
CANCEL	LD	HL,$		;get cancel vector
VECTOR2	EQU	$-2
	JP	(HL)		;re-read data
;
UPDATE	LD	HL,$		;get update vector
VECTOR1	EQU	$-2
	JP	(HL)		;write data!
;
;	change modify mode base
;
HEXIT	XOR	A
	JR	ITCONT
BINIT	LD	A,2
	JR	ITCONT
OCTIT	LD	A,3
	JR	ITCONT
ASCIT	LD	A,4
	JR	ITCONT
DECIT	LD	A,1
ITCONT	LD	(MODE),A	;set new mode
	CALL	SHOMODE		;re-display
	LD	HL,$		;get vector
VECTOR3	EQU	$-2
	JP	(HL)		;return!
NUMBER	EX	AF,AF'		;save char
	LD	A,(MODE)	;get type of modify
	CP	4		;ascii?
	JR	Z,ASCNUM	;yes, use char
;
	LD	A,RATE		;flash delay
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,20B0H	;on/off bytes
	ENDIF
	IF	TRS2
	LD	BC,2018H	;on/off bytes
	ENDIF
	CALL	FLSNUM		;get numeric
	RET	C		;error, don't change
	EX	AF,AF'		;save char
;
ASCNUM	EX	AF,AF'		;get char
	LD	(DE),A		;to buffer
	CALL	MODFIX		;update video
	JP	MODR		;go next char
;
;	locate specified byte
;
FINBYTE	LD	A,RATE		;flash counter
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,0BF00H	;off/on
	ENDIF
	IF	TRS2
	LD	BC,01900H
	ENDIF
	CALL	FLICKSP		;special input
;
	CP	'L'		;last?
	JR	Z,LSTBYTE	;yes, go!
	CP	'l'		;last?
	JR	Z,LSTBYTE	;yes, go!
	EX	AF,AF'		;save the key
	LD	A,RATE		;flash counter
	CALL	FLSNUM		;get numeric
	RET	C		;error!
;
FBGO	LD	(LBLST),A	;save for last
	LD	C,A		;pass for test
	CALL	MODFIX		;update video
	LD	A,(TEMP2)	;get offset
	LD	B,A		;pass to B
	INC	A		;at end?
	RET	Z		;yes, don't move
	XOR	A		;load zero
	SUB	B		;less offset
	DEC	A		;less cursor
	LD	B,A		;B = # entries
;
FIGO1	PUSH	BC		;save count
	CALL	MODR		;move cursor right
	POP	BC		;restore count
	LD	A,(DE)		;get buff byte
	CP	C		;match?
	RET	Z		;yes, go!
	DJNZ	FIGO1		;else continue
	RET			;done, cursor at end!
;
LSTBYTE	LD	A,0		;get last
LBLST	EQU	$-1
	JR	FBGO		;continue
;
;	insert byte at cursor
;
INSBYTE	PUSH	DE		;save buffer
	LD	HL,(ADDRESS)	;get start address
	LD	BC,0FFH		;page length -1
	ADD	HL,BC		;HL => end
	PUSH	HL		;save
	OR	A		;clear carry
	SBC	HL,DE		;HL = length
	LD	B,H		;pass to BC
	LD	C,L
	POP	HL		;HL = end
	LD	D,H		;pass to DE
	LD	E,L
	DEC	HL		;end -1
	LDDR			;move up
	POP	DE		;restore start
	XOR	A		;load zero
	LD	(DE),A		;to buffer
	JP	AASHOW		;continue
;
;	delete byte at cursor
;
DELBYTE	PUSH	DE		;save curr buffer
	LD	HL,(ADDRESS)	;get data start
	LD	BC,0FFH		;page length -1
	ADD	HL,BC		;HL => end
	OR	A		;clear carry
	SBC	HL,DE		;remain length
	LD	B,H		;pass to BC
	LD	C,L
	POP	HL		;restore start
	PUSH	HL		;back on stack
	LD	D,H		;pass to DE
	LD	E,L
	INC	HL		;start +1
	LDIR			;move data
	POP	DE		;get start back
	LD	HL,(ADDRESS)	;start back
	LD	BC,0FFH		;+255
	ADD	HL,BC		;HL => end
	LD	(HL),0		;clear it
	JP	AASHOW		;re-display
;
;	fill block of memory
;
FILBYTS	LD	A,RATE		;delay counter
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,0B300H	;B=on/C=off
	ENDIF
	IF	TRS2
	LD	BC,01500H	;B=on/C=off
	ENDIF
;
	CALL	FLICKSP		;special key input
	EX	AF,AF'		;save input key
	LD	A,RATE		;delay count
	CALL	FLSNUM		;fetch numeric input
	RET	C		;invalid numeric
;
FLGBO	PUSH	AF		;save key
	CALL	MODFIX		;update cursors
	POP	AF		;restore key
	LD	C,A		;save key
	LD	B,0		;BC = value
	PUSH	DE		;save data offset
	EX	DE,HL		;HL = offset
	LD	D,H		;pass to DE
	LD	E,L
	INC	DE		;bump for move
	LDIR			;propogate data
	POP	DE		;restore
	JP	AASHOW		;re-display data
;
;	zero buffer from cursor
;
ZEROFF	XOR	A		;load zero
	LD	(DE),A		;to buffer
	LD	A,(TEMP2)	;get offset
	CPL			;remainder length -1
	JR	FLGBO		;continue
;
;	move cursor to desired offset
;
GOBYTE	LD	A,RATE		;flash rate
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,99A6H	;B=on/C=off
	ENDIF
	IF	TRS2
	LD	BC,0C0FH	;B=on/C=off
	ENDIF
	CALL	FLICKSP		;special key input
;
	CP	'L'		;go last?
	JR	Z,GOBLST	;yes, go!
	CP	'l'		;last?
	JR	Z,GOBLST
;
	EX	AF,AF'		;save input key
	LD	A,RATE		;flash count
	CALL	FLSNUM		;get numerical input
	RET	C		;go if invalid
;
GOBGO	PUSH	AF		;save key
	CALL	MODFIX		;update display
	PUSH	DE		;save DE
	CALL	@VSIZE		;get video params
	PUSH	HL		;pass HL => IX
	POP	IX		;IX => video
	PUSH	HL		;pass to IY
	POP	IY		;IY => video
	LD	BC,8		;offset to hex side
	ADD	IX,BC		;IX => HEX chars
	LD	C,48		;offset to ascii side
	ADD	IY,BC		;IY => ASCII chars
	POP	DE		;restore buffer
	POP	AF		;get user count
	LD	B,A		;pass to B
	LD	(GBLST),A	;save as LAST
	OR	A		;offset 0?
	RET	Z		;yes, done!
	LD	DE,(ADDRESS)	;buffer start
;
GOBGO1	PUSH	BC		;save
	CALL	MODR		;move cursor right
	POP	BC		;restore count
	DJNZ	GOBGO1		;go for length
	RET			;done!
;
GOBLST	LD	A,0		;get last command
GBLST	EQU	$-1
	JR	GOBGO		;continue
;
;	start/end modify buffer
;
STAOFF	XOR	A		;load zero
	JR	GOBGO		;go to it
;
ENDOFF	LD	A,-1		;load -1
	JR	GOBGO		;go to it
;
;	offset from current modify
;
INCOFF	LD	HL,MODR		;inc vector
	JR	INCDECO		;go common
;
DECOFF	LD	HL,MODL		;dec vector
INCDECO	LD	(INCDECV),HL	;save vector
	LD	BC,'+-'		;cursor chars
	LD	A,RATE		;flash rate
	CALL	FLICKSP		;special key input
	CALL	@UCASE		;make upper case
	CP	'L'		;last?
	JR	NZ,INCDECX	;go if not
	LD	A,0		;get last
INCDECL	EQU	$-1
	JR	INCDECG		;continue
;
INCDECX	EX	AF,AF'		;save key
	LD	A,RATE		;flash rate
	CALL	FLSNUM		;get numeric
	RET	C		;go if error
;
INCDECG	LD	(INCDECL),A	;save as last
	PUSH	AF		;save key
	CALL	MODFIX		;update video
	POP	AF		;restore key
	LD	B,A		;pass offset
	OR	A		;zero?
	RET	Z		;yes, go!
INCDECQ	PUSH	BC		;save count
	CALL	$		;call vector
INCDECV	EQU	$-2
	POP	BC		;restore
	DJNZ	INCDECQ		;continue loop
	RET			;done!
;
;	display disk sectors
;
CONT2	LD	HL,DISDSK1	;modify mode return
	LD	(VECTOR1),HL	;for UPDATE
	LD	HL,DISDSK0	;modify mode return
	LD	(VECTOR2),HL	;for CANCEL
	LD	HL,DISCON1	;modify mode return
	LD	(VECTOR3),HL	;for base change
	JR	DISDSK0		;continue
;
DISDSK	CALL	@CLS		;clear video
	LD	HL,TKMSG	;prompt string
	LD	B,31		;input length
	LD	DE,STRING	;input buffer
	CALL	@VIDKEY		;video/keyboard
	JP	C,EXIT		;go on BREAK
	CALL	@POSHL		;any input?
	JP	Z,RESTART	;restart if not
	CALL	@POSHL		;position to input
	JR	Z,CONT2		;go if nothing!
	CP	':'		;drive issued?
	JP	Z,ZAPDRV	;yes, interpret!
	JP	ZAPTRK		;else fetch track
;
;	write modified sector to disk
;
DISDSK1	LD	DE,(SECTOR)	;get track/sector
	LD	HL,(ADDRESS)	;get I/O buffer
	LD	BC,(DRIVE)	;C = drive
	LD	A,(RDTYP)	;get write type
;
	IF	TRS13
	SUB	6		;read protect?
	ENDIF
;
	IF	TRS2
	SUB	56		;read protect?
	ENDIF
;
	JR	Z,DISDS11	;go if yes
	DEC	A		;user defined?
	JR	Z,DISDS11	;yes, go!
	CALL	@WRSEC		;write data sector
	JR	DISDS12		;continue
DISDS11	CALL	@WRDAM		;write protected
DISDS12	CALL	BADWRT		;any error?
	JP	C,EXIT		;BREAK
	JR	NZ,DISDSK1	;try again if retry
	JR	DISDSK0		;go!
;
DISDSKX	LD	(SECTOR),DE	;update track/sector
	JR	DISDK00		;don't clear video
;
;	read current sector
;
DISDSK0	CALL	@CLS		;clear video
DISDK00	CALL	ZBUFF		;clear buffer
	LD	HL,$BUFFER	;I/O buffer
	LD	(ADDRESS),HL	;save as address
	LD	DE,0		;get track/sector
SECTOR	EQU	$-2
TRACK	EQU	$-1
	LD	BC,(DRIVE)	;C = drive
	CALL	RDSEC		;read the sector
	LD	(RDTYP),A	;save type of I/O
	CALL	BADRD		;go error monitor
	JP	C,EXIT		;BREAK
	JR	NZ,DISDSK0	;retry
;
CONTDSK	LD	DE,(SECTOR)	;get track/sector
DISCON	CALL	SHOW		;display data
DISCON1	CALL	SHOWLF		;display data source
;
DISWT	PUSH	DE		;save track/sector
	CALL	@VSIZE		;HL => video
	POP	DE		;restore
	LD	A,RATE		;flash counter
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,20B0H	;B=off/C=on
	ENDIF
	IF	TRS2
	LD	BC,2019H	;B=off/C=on
	ENDIF
	CALL	FLICKS		;key input
	PUSH	AF		;save it
	CP	' '		;displayable?
	JR	NC,$+4		;go if yes
	LD	A,BLOCK		;else use this
;
	CALL	@VPOKE		;to video
	POP	AF		;restore char
;
;	check for digit 0-9 for direct paging
;
	CP	'0'		;compare
	JR	C,GOTTT		;go if not
	CP	'9'+1		;0-9?
	JR	NC,GOTTT	;go if not
	SUB	'0'		;remove ascii
	LD	E,A		;E = new sector
	JR	DISDSKX		;resume!
;
;	not digit, check if in table
;
GOTTT	LD	HL,DISTBL	;jump table
	CALL	@LOOKUP		;correct vector?
	JR	NZ,DISWT	;not there, wait again
	LD	BC,DISDSKX	;resume vector
	PUSH	BC		;leave on stack
	JP	(HL)		;else go vector!
;
DISTBL	DEFB	'R'		;lowest sector
	DEFW	GOREST
	DEFB	'M'		;modify mode
	DEFW	MODIFY
	DEFB	'A'		;ascii modify
	DEFW	ASCIT
	DEFB	'B'		;binary modify
	DEFW	BINIT
	DEFB	'D'		;decimal modify?
	DEFW	DECIT
	DEFB	'O'		;octal modify
	DEFW	OCTIT
	DEFB	'Q'
	DEFW	OCTIT
	DEFB	'H'		;hex modify
	DEFW	HEXIT
	DEFB	'@'		;directory track?
	DEFW	DIRTRK
	DEFB	UARR		;one track up
	DEFW	TRKUP
	DEFB	DARR		;one track down
	DEFW	TRKDN
	DEFB	LARR		;one sector down
	DEFW	SECDN
	DEFB	RARR		;one sector up
	DEFW	SECUP
	DEFB	SLARR		;lowest sector
	DEFW	SECBOT
	DEFB	SRARR		;highest sector
	DEFW	SECTOP
	DEFB	SDARR		;lowest track
	DEFW	TRKBOT
	DEFB	SUARR		;highest track
	DEFW	TRKTOP
	DEFB	ESCAPE		;new track/sector?
	DEFW	DISDSK
	DEFB	BREAK		;abort?
	DEFW	RESTART
	DEFB	ETBL
;
;	paging mode controls
;
SECBOT	LD	E,0		;lowest sector
	RET			;done
;
SECTOP	CALL	HISEC		;get highest sector
	LD	E,C		;pass highest sector
	RET			;done!
;
TRKBOT	LD	D,0		;lowest track
	RET			;done
;
TRKTOP	CALL	HISEC		;get highest track
	LD	D,B		;pass to D
	RET			;done!
;
DIRTRK	PUSH	DE		;save track/sector
	LD	BC,(DRIVE)	;C = drive
	CALL	@DSIZE		;get drive params
	POP	DE		;restore
	LD	D,B		;pass dir track
	RET			;done!
;
GOREST	LD	DE,0		;lowest track/sector
	RET			;done
;
TRKUP	CALL	HISEC		;get highest track
	LD	A,D		;get current track
	CP	B		;at highest?
	RET	Z		;don't change
	INC	D		;else bump track
	RET			;done!
;
TRKDN	LD	A,D		;get current track
	OR	A		;on zero?
	RET	Z		;yes, leave it
	DEC	D		;else decrement it
	RET			;done!
;
SECUP	CALL	NEXSEC		;bump to next sector
	RET			;done!
;
SECDN	CALL	BAKSEC		;back a sector
	RET			;done!
;
AASHOW	CALL	SHOW		;display data
	JP	SHOWLF		;display source
;
;	zero I/O buffer
;
ZBUFF	LD	HL,$BUFFER	;buffer start
	LD	DE,$BUFFER+1	;start +1
	LD	BC,0FFH		;length -1
	LD	(HL),0		;load one zero
	LDIR			;load all zeroes
	RET			;cleared!
;
;	file modify
;
CONT3	CALL	@CLS		;clear video
	LD	HL,TRIFLWR	;for modify return
	LD	(VECTOR1),HL	;for UPDATE
	LD	HL,FFILCON	;for modify return
	LD	(VECTOR2),HL	;for CANCEL
	LD	HL,DFILWTX	;for modify return
	LD	(VECTOR3),HL	;for base change
	JR	FFILCON		;continue
;
;	update modified sector to disk
;
TRIFLWR	LD	DE,$FCB		;file control block
	LD	BC,POSIT	;relative sector
	CALL	@POSN		;position file
	JR	NZ,TRIFL1	;go if error
	CALL	@WRITE		;write record
TRIFL1	CALL	BADWRT		;monitor
	JP	C,EXIT		;go on BREAK
	JR	NZ,TRIFLWR	;try to write again!
;
;	read relative sector
;
FFILCON	CALL	@CLS		;clear video
FILECT	CALL	ZBUFF		;clear I/O buffer
	LD	DE,$FCB		;file block
	LD	BC,POSIT	;relative sector
	CALL	@POSN		;position file
	JR	NZ,FILCXT	;go if error
	CALL	@READ		;read record
FILCXT	CALL	BADRD		;monitor
	JP	C,EXIT		;go on BREAK
	JR	NZ,FFILCON	;go if retry
;
DFILELP	CALL	SHOW		;display data
DFILWTX	CALL	SHOWLF		;display data source
;
DFILEWT	CALL	@VSIZE		;HL => video
	LD	A,RATE		;flash count
;
	IF	TRS13.OR.LDOSSVC
	LD	BC,20B0H	;B=off/C=on
	ENDIF
	IF	TRS2
	LD	BC,2019H	;B=off/C=on
	ENDIF
	CALL	FLICKS		;key input
;
;	display char
;
	PUSH	AF		;save key
	CP	' '		;displayable?
	JR	NC,$+4		;go if yes
	LD	A,BLOCK		;else use a block
	CALL	@VPOKE		;to video
	POP	AF		;restore char
	LD	HL,DISFLTB	;paging lookup table
	CALL	@LOOKUP		;valid command?
	JR	NZ,DFILEWT	;go if not
;
;	load relative sector into BHL
;
	LD	BC,FILERET	;return vector
	PUSH	BC		;leave on stack
	PUSH	HL		;jump vector
	LD	HL,POSIT	;point to position
	LD	B,(HL)		;get MSB
	INC	HL		;bump
	LD	D,(HL)		;get NSB
	INC	HL		;bump
	LD	E,(HL)		;get LSB
	EX	DE,HL		;BHL = record #
	RET			;go vector
;
FILERET	EX	DE,HL		;BDE = rel sector
	LD	HL,POSIT	;point to block
	LD	(HL),B		;put MSB
	INC	HL		;bump
	LD	(HL),D		;put NSB
	INC	HL		;bump
	LD	(HL),E		;put LSB
	JR	FILECT		;continue
;
DISFLTB	DEFB	RARR		;bump sector
	DEFW	@INC
	DEFB	UARR		;bump sector
	DEFW	@INC
	DEFB	DARR		;dec sector
	DEFW	DOWNFIL
	DEFB	LARR
	DEFW	DOWNFIL
	DEFB	'R'		;rewind
	DEFW	BOTOFIL
	DEFB	'M'		;modify
	DEFW	MODIFY
	DEFB	'B'		;binary modify
	DEFW	BINIT
	DEFB	'A'		;ascii modify
	DEFW	ASCIT
	DEFB	'D'		;decimal modify?
	DEFW	DECIT
	DEFB	'O'		;octal modify
	DEFW	OCTIT
	DEFB	'Q'
	DEFW	OCTIT
	DEFB	'H'		;hex modify
	DEFW	HEXIT
	DEFB	ESCAPE		;new file
	DEFW	NEWFILE
	DEFB	BREAK		;abort?
	DEFW	RESTART
	DEFB	ETBL
;
;	decrement relative sector
;
DOWNFIL	LD	A,B		;get MSB
	OR	H		;check for 000000H?
	OR	L		;yes?
	RET	Z		;yes, go!
	JP	@DEC		;decrement
;
BOTOFIL	LD	HL,0		;NSB/LSB = 0
	LD	B,H		;BHL = 0
	RET			;done
;
;	compute highest sector/track
;
HISEC	PUSH	HL		;save
	PUSH	DE		;save
	LD	BC,(DRIVE)	;get drive to C
	CALL	@DSIZE		;get params
	LD	B,C		;B = cyl count
	DEC	B		;B = highest track
	LD	C,H		;C = highest sector
	POP	DE		;unstack
	POP	HL
	RET			;done, BC high track/sect
;
RDSEC	CALL	@RDSEC		;read sector
	RET	Z		;no error
;
	IF	TRS13
	CP	6		;read protected?
	RET	Z		;yes, go!
	CP	7		;user defined?
	RET			;return Z/NZ
	ENDIF
;
	IF	TRS2
	CP	56		;read protect?
	RET	Z		;yes, go!
	CP	57		;user defined?
	RET			;return status
	ENDIF
;
;	special numeric input evaluator
;
FLSNUM	LD	HL,MODELN	;base/length table
	LD	(FLSSPD),A	;flash speed
	LD	(FLSCUR),BC	;cursors
;
	LD	A,(MODE)	;get modify mode
	AND	3		;low 2 bits
	ADD	A,A		;*2
	LD	C,A		;pass offset
	LD	B,0		;BC = offset
	ADD	HL,BC		;get length of input
	LD	B,(HL)		;get it
	INC	HL		;bump table
	LD	C,(HL)		;get number base
	EX	AF,AF'		;restore first char
;
	LD	HL,STRING	;input buffer
	JR	CKENUM		;insert first char
;
MODELN	DEFB	2,'H'		;hex
	DEFB	3,'D'		;decimal
	DEFB	8,'B'		;binary
	DEFB	3,'O'		;octal
	DEFB	1,'A'		;ascii
;
;	wait for input char
;
NUMON	PUSH	BC		;save
	LD	BC,$		;get on/off chars
FLSCUR	EQU	$-2
	LD	A,'$'		;get flash rate
FLSSPD	EQU	$-1
	CALL	FLICKSP		;get input
	POP	BC		;restore
	CP	CR		;enter?
	JR	Z,DECNUM	;yes, interpret number
;
;	check for valid char
;
CKENUM	CALL	@UCASE		;make upper case
	CP	'0'		;valid
	RET	C		;go if invalid
	CP	'9'+1		;valid?
	JR	C,NUMHAV	;in range, go!
	CP	'A'		;hex digit?
	RET	C		;go if invalid
	CP	'G'		;hex digit?
	CCF			;reverse carryy
	RET	C		;nope, cancel
;
NUMHAV	LD	(HL),A		;to holding buffer
	INC	HL		;bump pointer
	DJNZ	NUMON		;go for length
;
DECNUM	LD	(HL),C		;term character
	INC	HL		;bump pointer
	LD	(HL),CR		;terminator
	LD	HL,STRING	;reset pointer
	PUSH	DE		;save buff ptr
	CALL	@VALUE		;get input value
	LD	A,E		;get LSB value
	POP	DE		;restore
	SCF			;setup for error
	RET	NZ		;go if invalid!
	OR	A		;clear carry for OK
	RET			;A = input value
;##
HELP1	DEFB	CR
	DEFM	'aaaa        or'
	DEFB	CR
	DEFM	'file1,aaaa  or'
	DEFB	CR
	DEFM	':b,c,d'
	DEFB	CR
	DEFB	CR
	DEFM	'aaaa        = memory address to display'
	DEFB	CR
	DEFM	'file1,aaaa  = file to display, '
	DEFM	'starting relative sector'
	DEFB	CR
	DEFM	':b,c,d      = Drive, Cylinder, '
	DEFM	'Sector to display'
	DEFB	CR
	DEFB	CR
	DEFB	ETX
;
EXMSG	DEFM	'Power Modify * Terminated *'
	DEFB	CR
	DEFB	ETX
;
FILMSG	DEFM	'Relative Sector ? '
	DEFB	ETX
;
TKMSG	DEFM	'Drive, Cylinder, Sector ? '
	DEFB	ETX
;
NEWADD	DEFM	'Address ? '
	DEFB	ETX
;
;
DVMSG	DEFB	'DRV'
CYLMSG	DEFB	'CYL'
SECMSG	DEFB	'SEC'
STDMSG	DEFB	'STD'
RPTMSG	DEFB	'RPT'
DELMSG	DEFB	'DDT'
;
BADRMSG	DEFM	'Disk READ Error'
	DEFB	CR
	DEFB	ETX
;
BADWMSG	DEFM	'Disk WRITE Error'
	DEFB	CR
	DEFB	ETX
;
PARMSG	DEFM	'Parameter Error'
	DEFB	CR
	DEFB	ETX
;
HELLO	DEFM	'PMOD - '
	DEFM	'Modification Utility - '
	DEFM	'Version 3.1'
;
	IF	TRS13.AND.LDOS
	DEFM	'/L'
	ENDIF
;
	IF	TRS13.AND.DOSPLUS
	DEFM	'/D'
	ENDIF
;
	IF	TRS13.AND.LDOSSVC
	DEFM	'/LS'
	ENDIF
;
	IF	TRS2
	DEFM	'/PDOS'
	ENDIF
;
	DEFB	CR
	DEFM	'by Kim Watt - '
	DEFM	'Copyright (C) 1983 '
	DEFM	'Breeze/QSD, Inc.'
	DEFB	CR
	DEFB	CR
	DEFB	ETX
;
DRVMSG	DEFM	'Modification Parameters ? '
	DEFB	ETX
;
