; pdraw6/asm - kjw/bqsd - revised 05/20/83 dwh
;
;	send BASIC line number to buffer
;
BLINE	LD	A,(IY+16)	;get line number
	INC	A		;bump it
	LD	(IY+16),A	;update it
	BIT	7,(IY-1)	;tape?
	JR	NZ,BLINET	;yes
	PUSH	BC		;save BC
	CALL	ASCII		;decimal ascii
	CALL	PBUF		;MSB to buffer
	LD	A,C		;get NSB
	CALL	PBUF		;to buffer
	LD	A,B		;get LSB
	CALL	PBUF		;to buffer
	POP	BC		;restore it
	LD	A,_SPACE	;now a space
	JP	PBUF		;put and return
BLINET	CALL	PBUF		;dummy LSB next line
	CALL	PBUF		;dummy MSB
	CALL	PBUF		;LSB line number
	XOR	A		;MSB line number
	JP	PBUF		;to buffer
;
HEADERB	BIT	7,(IY-1)	;tape?
	JR	Z,HEADERD	;no
	CALL	HEADER		;turn it on
	LD	IX,BTHMSG	;basic tape header
	CALL	SBUFFXX		;to buffer
	CALL	BLINE
	LD	IX,BASHTMSG	;basic header tape
	JR	BHOUT
HEADERD	CALL	BLINE
	LD	IX,BASHMSG	;basic header
BHOUT	JP	SBUFFXX		;to buffer
BTHMSG	DEFB	0D3H,0D3H,0D3H,'B',_ETX
;
;	send file in BASIC format
;
DOBASIC	CALL	HEADERB		;header and line
	LD	B,$TROWS	;16 loops on video
;
DOBSLP	PUSH	BC		;save counter
	CALL	BLINE		;basic line #
	LD	IX,PRINTMG	;PRINT"
	BIT	7,(IY-1)	;tape?
	JR	Z,DPRINT	;no
	LD	IX,PRINTTMG	;token PRINT"
DPRINT	CALL	SBUFFXX		;to buffer
	LD	B,64		;64 chars / line
HG81LP	LD	A,(HL)		;get character
	INC	HL		;bump pointer
	CALL	PBUF		;to buffer
	DJNZ	HG81LP		;go for length
	LD	A,'"'		;send closing quote
	CALL	PBUF		;to buffer
	LD	A,';'		;suppress carriage return
	CALL	PBUF		;to buffer
	LD	A,_CR		;line terminator
	BIT	7,(IY-1)	;tape?
	JR	Z,DEND		;no
	LD	A,_ETBL
DEND	CALL	PBUF		;to buffer
	POP	BC		;restore counter
	DEC	B		;less counter
	JP	NZ,DOBSLP	;go if more to do
FINTERB	XOR	A		;zero
	CALL	PBUF
	CALL	PBUF
	JP	FINTERM		;load terminator
;
;	write file in DATA statements
;
PERDATA	CALL	HEADERB		;header and line
	LD	C,128		;128 lines long
;
DODATA1	CALL	BLINE		;do line #
	LD	IX,DATAMSG	;DATA
	BIT	7,(IY-1)	;tape?
	JR	Z,DODATAC	;no
	LD	IX,DATATMSG	;data token
DODATAC	CALL	SBUFFXX		;move to buffer
	LD	B,8		;8 data statements
	JR	DODATA3		;continue
;
DODATA2	LD	A,','		;comma between
	CALL	PBUF		;to buffer
DODATA3	PUSH	BC		;save counter
	LD	A,(HL)		;get a byte
	INC	HL		;bump pointer
	CALL	ASCII		;make it ascii
	CALL	PBUF		;MSB to buffer
	LD	A,C		;get NSB
	CALL	PBUF		;to buffer
	LD	A,B		;get LSB
	CALL	PBUF		;to buffer
	POP	BC		;restore counter
	DJNZ	DODATA2		;do all 8
	LD	A,_CR		;send CR
	BIT	7,(IY-1)	;tape?
	JR	Z,DODATAO	;no
	LD	A,_ETBL
DODATAO	CALL	PBUF		;to buffer
	DEC	C		;next line
	JP	NZ,DODATA1	;go if more to do
	JP	FINTERB		;else terminate
;
;	revsere video
;
REVVID	LD	B,$TROWS	;16 lines on video
	LD	HL,VBUFF	;top left
	LD	DE,VBUFF+3FH	;top right
;
REVL1	LD	C,$TCOLS/2	;32 loops / line
	PUSH	HL		;save start posit
	PUSH	DE
REVL2	CALL	REVX		;reverse X axis
	INC	HL		;bump
	DEC	DE		;dec
	DEC	C		;go 32 times
	JR	NZ,REVL2	;finish line
	POP	DE		;get start back
	POP	HL		;get start back
	PUSH	BC		;save from add
	LD	BC,$TCOLS	;line length
	ADD	HL,BC		;add to source
	EX	DE,HL		;swap
	ADD	HL,BC		;add to dest
	EX	DE,HL		;swap back
	POP	BC		;counter back
	DJNZ	REVL1		;do 16 lines
	SET	5,(IY+0)	;set updated video
	JP	RESUME		;re-draw it and continue
;
;	reverse vertical axis
;
REVVID2	LD	B,8		;8 lines to do
	LD	HL,VBUFF	;top line
	LD	DE,VBUFF+3C0H	;bottom line
;
REVML1	LD	C,$TCOLS	;64 chars / line
	PUSH	HL		;save pointers
	PUSH	DE
REVML2	CALL	REVY		;reverse Y axis
	INC	HL		;bump
	INC	DE		;bump
	DEC	C		;less counter
	JR	NZ,REVML2	;finish column
	POP	DE		;restore start
	POP	HL		;restore start
	PUSH	BC		;save from math
	LD	BC,$TCOLS	;# video columns
	ADD	HL,BC		;next line
	EX	DE,HL		;swap
	OR	A		;clear carry
	SBC	HL,BC		;move other up
	EX	DE,HL		;swap back
	POP	BC		;restore counter
	DJNZ	REVML1		;go for # rows
	SET	5,(IY+0)	;set buffer updated
	JP	RESUME		;re-draw and continue
;
;	move video buffer
;
MOVVID	CALL	PUTBUFF		;move buffer to video
	CALL	KEY		;wait for next key
	AND	_CTL.XOR.-1	;strip control bit
	CP	_UARR		;move up?
	JP	Z,MOVVIDU
	CP	_DARR		;move down?
	JP	Z,MOVVIDD
	CP	_RARR		;move right?
	JR	Z,MOVVIDR
	CP	_LARR		;move left?
	JP	NZ,LOOP		;cancel it if none
;
;	move left
;
	LD	B,$TROWS	;# video rows
	LD	HL,VBUFF	;video buffer
;
MOVLP1	PUSH	HL		;save start
	LD	D,H		;pass start to DE
	LD	E,L		;give to DE
	INC	DE		;start +1
	LD	C,$TCOLS-1	;63 times / line
	LD	A,(HL)		;get first byte
	EX	AF,AF'		;save it
MOVLP2	LD	A,(DE)		;get a byte
	LD	(HL),A		;put it here
	INC	DE		;bump pointer
	INC	HL		;bump source
	DEC	C		;less counter
	JR	NZ,MOVLP2	;go for length
	EX	AF,AF'		;get first back
	LD	(HL),A		;update char
	POP	HL		;restore position
	LD	DE,$TCOLS	;video columns
	ADD	HL,DE		;next position
	DJNZ	MOVLP1		;go for # rows
	SET	5,(IY+0)	;set buffer updated
	JP	MOVVID		;see if another
;
;	move video right
;
MOVVIDR	LD	B,$TROWS	;# video rows
	LD	HL,VBUFF+3FH	;end top video buf line
;
MOVMLP1	PUSH	HL		;save start
	LD	D,H		;pass to DE
	LD	E,L		;DE = start
	DEC	DE		;start -1
	LD	C,$TCOLS-1	;columns -1
	LD	A,(HL)		;get first char
	EX	AF,AF'		;save it
MOVMLP2	LD	A,(DE)		;get second char
	LD	(HL),A		;to first
	DEC	DE		;move pointers back
	DEC	HL		;two
	DEC	C		;less counter
	JR	NZ,MOVMLP2	;go till row end
	EX	AF,AF'		;get first char back
	LD	(HL),A		;to buffer
	POP	HL		;get start back
	LD	DE,$TCOLS	;# video columns
	ADD	HL,DE		;next row
	DJNZ	MOVMLP1		;go for row count
	SET	5,(IY+0)	;buffer updated
	JP	MOVVID		;continue
;
;	move video up
;
MOVVIDU	LD	HL,VBUFF	;start video buffer
	CALL	MOVSAVE		;save top row
	LD	B,$TROWS-1	;# video rows -1
	LD	HL,VBUFF	;start buffer
	LD	DE,VBUFF+$TCOLS	;start row 1
;
MOVX1	PUSH	HL		;save pointer
	PUSH	DE		;second pointer
	LD	C,$TCOLS	;# video columns
MOVX2	LD	A,(DE)		;get a char
	LD	(HL),A		;swap
	INC	DE		;bump source
	INC	HL		;bump dest
	DEC	C		;less counter
	JR	NZ,MOVX2	;go for length
	POP	DE		;restore start
	POP	HL
	PUSH	BC		;save from math
	LD	BC,$TCOLS	;# video columns
	ADD	HL,BC		;next row
	EX	DE,HL		;swap
	ADD	HL,BC		;new row
	EX	DE,HL		;swap back
	POP	BC		;restore counter
	DJNZ	MOVX1		;go for # rows
	SET	5,(IY+0)	;buffer updated
	LD	HL,DCB		;start stored top row
	LD	DE,VBUFF+3C0H	;location bottom row
	LD	BC,$TCOLS	;length of row
	LDIR			;move to video
	JP	MOVVID		;continue
;
;	move video down
;
MOVVIDD	LD	HL,VBUFF+3C0H	;start last row
	CALL	MOVSAVE		;save last row
	LD	HL,VBUFF+3C0H	;start last row
	LD	DE,VBUFF+380H	;start second last row
	LD	B,$TROWS-1	;# video rows -1
;
MOVY1	PUSH	HL		;save pointers start
	PUSH	DE
	LD	C,$TCOLS	;# video columns
MOVY2	LD	A,(DE)		;get a byte
	LD	(HL),A		;move it
	INC	HL		;bump pointers
	INC	DE
	DEC	C		;less column count
	JR	NZ,MOVY2	;finish a row
	POP	DE		;restore rows start
	POP	HL
	PUSH	BC		;save from math
	LD	BC,0-$TCOLS	;minus col count
	ADD	HL,BC		;back a row
	EX	DE,HL		;swap
	ADD	HL,BC		;back a row
	EX	DE,HL		;swap back
	POP	BC		;restore counter
	DJNZ	MOVY1		;go for row count
	LD	HL,DCB		;stored last line
	LD	DE,VBUFF	;move to top line
	LD	BC,$TCOLS	;length to move
	LDIR			;move to video buffer
	SET	5,(IY+0)	;set buffer updated
	JP	MOVVID		;continue
;
;	send contents of video to printer
;
SCRNPRT	PUSH	AF		;save invoking key
	SET	5,(IY+0)	;update video
	CALL	PUTBUFF		;display it, cursor off
	LD	A,($KBDR7)	;shift row
	AND	3		;low 2 bits
	JR	Z,$+4
	LD	A,20H		;MX80 adjust
	LD	(MX80),A	;store offset
	POP	AF		;restore command
	JR	SCREEN2		;continue
;
SCRPRT	XOR	A		;load zero
	LD	(MX80),A	;reset MX80 flag
	LD	A,_SPACE+_CTL	;set control space
;
SCREEN2	LD	HL,XPOUT	;external vector
	CP	_CR+_CTL	;control enter?
	JR	Z,VIDEXX	;go if yes
	LD	HL,YPOUT	;else internal vector
	CP	_SPACE+_CTL	;control space?
	JP	NZ,LOOP		;can't get here, go!
VIDEXX	LD	(PRINTER),HL	;pass printer vector
	LD	B,$TROWS	;16 lines on video
	LD	HL,$VIDEO	;where data is
;
VIDEX1	LD	C,$TCOLS	;64 chars/line
VIDEX2	LD	A,(HL)		;get a byte
	NOP
	PUSH	AF		;save it
	LD	(HL),191	;graphic block to video
	NOP
	CALL	POUT		;send to printer
	POP	AF		;restore char
	LD	(HL),A		;update video
	NOP
	INC	HL		;next position
	DEC	C		;decrement col counter
	JR	NZ,VIDEX2	;finish this line
	LD	A,_CR		;send C/R
	CALL	POUT		;to printer
	DJNZ	VIDEX1		;do next 15 lines
	JP	RESUME		;continue
;
;	send character to printer
;
POUT	EX	AF,AF'		;save char here
	LD	A,($KBDR6)	;read keyboard
	AND	4		;check for BREAK
	JP	NZ,RESUME	;abort on BREAK
	EX	AF,AF'		;get char back
	CP	20H		;too low?
	JR	NC,NORM		;okay
	LD	A,'.'		;convert
NORM	BIT	7,A		;graphic char?
	JR	Z,GOPRTR	;nope, send it!
;
;	adjust here for MX80 graphics
;
	RES	6,A		;reset bit 6
	ADD	A,20H		;add MX80 adjust
MX80	EQU	$-1
GOPRTR	JP	$		;print character
PRINTER	EQU	$-2
;
;	send char to ROM printer driver
;
XPOUT	PUSH	IY		;save it
	CALL	@PRCHAR		;print character
	POP	IY		;restore
	JR	YOUTGO		;continue
;
YPOUT	EX	AF,AF'		;save here again
YPOUT1	LD	A,($PRTSTA)	;get status
	AND	0F0H		;top 4 bits only
	CP	30H		;ready to go?
	JR	Z,YPOUT2	;send byte if ready
	LD	A,($KBDR6)	;scan keyboard
	AND	4		;BREAK key?
	JP	NZ,RESUME	;abort if yes
	JR	YPOUT1		;else wait more
;
YPOUT2	EX	AF,AF'		;have char
	BIT	5,(IY-1)	;check for I III
	JR	NZ,YPOUT3	;do Mod III
	LD	($PRTR1),A	;do Mod I
	JR	YOUTGO		;go common
YPOUT3	OUT	($PRTR3),A	;do Mod III
YOUTGO	PUSH	AF		;save char
	PUSH	BC		;save counter
	LD	BC,262		;delay for slow printer
	CALL	@DELAY		;countdown
	POP	BC		;restore BC
	POP	AF		;restore char
	RET			;done!
;
;	reverse char X axis
;
REVX	PUSH	HL		;save
	LD	HL,REVXX	;sub address
	JR	REVCM		;go common
;
;	reverse char Y axis
;
REVY	PUSH	HL		;save
	LD	HL,REVYY	;sub address
;
REVCM	LD	(REVSUB),HL	;pass vector
	LD	(REVSUB2),HL	;here too
	POP	HL		;can restore now
;
	PUSH	BC		;save it
	LD	B,(HL)		;get first char
	LD	A,(DE)		;get second char
	CALL	$		;convert char
REVSUB	EQU	$-2
	LD	(HL),A		;swap it
	LD	A,B		;get first char
	CALL	$		;convert char
REVSUB2	EQU	$-2
	LD	(DE),A		;swap it
	POP	BC		;unstack
	RET			;done
;
;	reverse a character on X axis
;
REVXX	OR	A		;text?
	RET	P		;yes, don't adjust
	LD	C,0		;starting bits
	BIT	1,A		;1 set?
	JR	Z,REVXA		;nope, go
	SET	0,C		;set 0
REVXA	BIT	0,A		;0 set?
	JR	Z,REVXB		;nope, go
	SET	1,C		;set 1
REVXB	BIT	3,A		;3 set?
	JR	Z,REVXC
	SET	2,C
REVXC	BIT	2,A
	JR	Z,REVXD
	SET	3,C
REVXD	BIT	5,A
	JR	Z,REVXE
	SET	4,C
REVXE	BIT	4,A
	JR	Z,REVXF
	SET	5,C
REVXF	LD	A,C
	AND	3FH		;remove bit 6
	OR	80H		;set 7
	RET			;char reversed
;
;	reverse single char Y axis
;
REVYY	OR	A		;text?
	RET	P		;yes, skip
	PUSH	AF		;save char
	AND	12		;bits 2/3 only
	LD	C,A		;pass here
	POP	AF		;restore
	BIT	0,A		;0?
	JR	Z,REVYA		;go if not
	SET	4,C		;set opposite
REVYA	BIT	4,A		;4?
	JR	Z,REVYB		;go if not
	SET	0,C		;ste opposite
REVYB	BIT	1,A		;1?
	JR	Z,REVYC
	SET	5,C
REVYC	BIT	5,A
	JR	Z,REVYD
	SET	1,C
REVYD	LD	A,C
	AND	3FH		;remove 6
	OR	80H		;set 7 (graphic)
	RET
;
;	write out file in ARRAY format
;
DOARRAY	CALL	HEADERB		;header and line
	CALL	BLINE		;line number
	LD	IX,VRHDMG	;dimension header
	BIT	7,(IY-1)	;tape?
	JR	Z,DOARRD	;no
	LD	IX,VRHDTMG
DOARRD	CALL	SBUFFXX		;write to file
	XOR	A		;array number
	LD	(ARRNUM),A	;save it
	LD	B,$TROWS	;16 video lines
;
DOARLP	PUSH	BC		;save line counter
	CALL	BLINE		;generate line number
	LD	IX,VARMSG	;array header message
	CALL	SBUFFXX		;write to buffer
	LD	A,0		;get array element
ARRNUM	EQU	$-1
	PUSH	AF		;save current
	INC	A		;bump for next pass
	LD	(ARRNUM),A	;re-save it
	POP	AF		;get current value
	CALL	ASCII		;convert to ascii
	LD	A,C		;get NSB
	CALL	PBUF		;to buffer
	LD	A,B		;get LSB
	CALL	PBUF		;to buffer
	LD	A,')'		;close array
	CALL	PBUF		;to buffer
	LD	A,'='		;equate
	BIT	7,(IY-1)	;tape?
	JR	Z,ARRC		;no
	LD	A,0D5H		;"=" token
ARRC	CALL	PBUF		;to buffer
	LD	A,'"'		;start string
	CALL	PBUF		;to buffer
	LD	B,$TCOLS	;64 chars to send
PRARR	LD	A,(HL)		;get string char
	INC	HL		;bump buffer
	CALL	PBUF		;to buffer
	DJNZ	PRARR		;finish the string
	LD	A,'"'		;close the quote
	CALL	PBUF		;to buffer
	LD	A,_CR		;C/R
	BIT	7,(IY-1)	;tape?
	JR	Z,PRARRC	;no
	LD	A,_ETBL
PRARRC	CALL	PBUF		;to buffer
	POP	BC		;restore loop counter
	DEC	B		;less this pass
	JP	NZ,DOARLP	;finish 16 lines
	JP	FINTERB		;flush buffer if done
;
;	save current string of video
;
MOVSAVE	LD	DE,DCB		;save it here
	LD	BC,$TCOLS	;length of column
	LDIR			;save it
	RET			;return
;
