; pdraw4/asm - kjw/bqsd - revised 04/22/83
;
;	alter angle settings
;
ANGLES	LD	A,(IY+2)	;get horizontal
	ADD	A,'0'		;make it ascii
	LD	(HMUCH),A	;put in string
	LD	A,(IY+3)	;get vertical speed
	ADD	A,'0'		;make ascii
	LD	(VMUCH),A	;to string
	LD	HL,AMSG1	;first message
	CALL	ASKFLS		;get the input
	JR	Z,DOSK1		;go if nil input
	LD	(IY+2),A	;else resave it
;
DOSK1	LD	HL,AMSG2	;second message
	CALL	ASKFLS		;get user input
	JR	Z,DOSK2		;go if nothing
	LD	(IY+3),A	;else update
;
DOSK2	LD	HL,AMSG3	;3rd messge
	CALL	PRINT		;display
	LD	B,1		;single key input
	CALL	GETSTR		;get from user
	JP	Z,RESUME	;resume on nil input
	CALL	UCASE		;else make upper case
	SET	2,(IY+0)	;set DOTTED lines
	CP	'D'		;user specified?
	JP	Z,RESUME	;yes, set to go
	RES	2,(IY+0)	;set SOLID lines
	JP	RESUME		;continue
;
;	convert binary to hex ascii A => CB
;
HEXCV	LD	B,A		;save char
	RRCA			;align high bits to low
	RRCA
	RRCA
	RRCA
	CALL	HEXADJ		;adjust to hex char
	LD	C,A		;save MSB into C
	LD	A,B		;get original value
	CALL	HEXADJ		;adjust low 4 bits to ASC
	LD	B,A		;save LSB into B
	RET			;done!
;
HEXADJ	AND	0FH		;low 4 bits only
	ADD	A,'0'		;add ascii
	CP	'9'+1		;0-9 digit?
	RET	C		;go if in range
	ADD	A,'A'-'9'-1	;adjust to A-F
	RET			;done!
;
;	convert binary to decimal ascii A => ACB
;
ASCII	LD	B,'0'		;init MSB
ASCI1	SUB	100		;check 100's place
	JR	C,ASCI2		;go if found
	INC	B		;bump ascii
	JR	ASCI1		;continue
;
ASCI2	ADD	A,100		;add back last sub
	PUSH	BC		;MSB on stack
	LD	C,'0'		;init NSB
ASCI3	SUB	10		;check 10's place
	JR	C,ASCI4		;go if found
	INC	C		;bump ascii
	JR	ASCI3		;continue
;
ASCI4	ADD	A,10+'0'	;last sub + ascii
	LD	B,A		;pass LSB
	POP	AF		;get MSB
	RET			;done, ACB = ascii
;
;	ask user for filespec
;
ASKFILE	LD	HL,FILEMSG	;filename prompt
	CALL	PRINT		;display it
	LD	B,24		;24 chars possible
	LD	HL,DCB		;where to put the data
	CALL	WAITKEY		;get key input
	EX	DE,HL		;DE => filespec
	JP	Z,RESUME	;abort if nil input
;
;	convert input to upper case
;
DSKTAP2	PUSH	BC		;save length
	PUSH	DE		;save start
FIXFL	LD	A,(DE)		;get a char
	CALL	UCASE		;make upper case
	LD	(DE),A		;put it back
	INC	DE		;bump pointer
	DJNZ	FIXFL		;go for length
;
;	figure correct extension to add to filespec
;
	POP	DE		;start of filespec
	LD	HL,DEFEXT	;/DRW
	LD	A,(IY-1)	;get save type flags
	BIT	3,A		;loading a file?
	JR	Z,DODEF		;go if yes
	AND	7		;get type flags
	JR	Z,DODEF		;go if saving compressed
;
	LD	HL,DEFASM	;/ASM
	DEC	A		;source code?
	JR	Z,DODEF		;go if EDAS
	DEC	A
	JR	Z,DODEF		;go if EDTASM
;
	LD	HL,DEFBAS	;/BAS
	DEC	A		;basic strings?
	JR	Z,DODEF		;go if yes
	DEC	A
	JR	Z,DODEF		;go if basic data
	DEC	A
	JR	Z,DODEF		;go if basic arrays
;
	LD	HL,DEFCMD	;/CMD
;
DODEF	CALL	ADDEXT		;add default extension
	POP	BC		;restore length
	RET			;done, DE => filespec
;
;	loading a file
;
LOAD	LD	HL,LOADMSG	;loading message
	CALL	PRINT		;display it
	RES	3,(IY-1)	;set LOAD flag
	CALL	DSKTAP		;setup for disk/tape
	LD	HL,IOBUFF	;where data goes
	LD	DE,DCB		;filespec here
	LD	(IY+8),1	;# buffers to load
	LD	(IY+9),0	;current # buffers
;
;	read first page of file
;
	CALL	RDBUFF		;read 256 bytes
	JP	NZ,CERROR	;no good, go error
;
;	check header string to be sure file is valid
;
	LD	HL,IOBUFF	;start I/O buffer
	LD	DE,QUICK	;header text
	LD	B,QUICKL	;length of header
	CALL	COMPARE		;test 'em
	JR	Z,RVALID	;ok to read if match!
;
;	invalid file found, check if OK to continue
;
INVALID	CALL	TAPOFF		;tape deck off if on
	LD	HL,VALMSG	;invalid data
	CALL	PRINT		;display prompt
	LD	B,1		;single key input
	CALL	GETSTR		;get from keyboard
	JP	Z,RESUME	;abort on nil input
	CALL	UCASE		;else input to upper case
	CP	'Y'		;continue?
	JP	NZ,RESUME	;abort load if not
;
	CALL	TAPON		;turn on tape deck
	LD	HL,IOBUFF	;first buffer loaded
	LD	DE,SBUFF	;storage buffer start
	JP	LOADIRL		;load irregular
;
;	compute # of buffers available
;
RVALID	LD	BC,BFTSIZE<8+0	;B=counter, C=active
	LD	(IY+10),L	;save buff posit
	LD	(IY+11),H
;
LCKLP	LD	A,(HL)		;get a slot byte
	CP	_ACTBUF		;active buffer?
	JR	NZ,CKLP		;go if not
	INC	C		;bump active counter
CKLP	INC	HL		;bump table
	DJNZ	LCKLP		;go for table length
;
;	display # of buffers to be loaded
;
	PUSH	BC		;save it
	LD	A,C		;get result
	LD	(IY+8),A	;save # buffers
	CALL	ASCII		;make it ascii
	LD	(RDMSG),BC	;save it in string
	LD	HL,RDMSG	;reading message
	CALL	PRINT		;display it
	POP	BC		;restore count
;
;	check for sufficient memory to load file
;
	LD	A,(IY+1)	;get # available
	CP	C		;test to # to load
	JR	NC,LOADLPX	;enough to read 'em
;
;	insufficient memory, read part of file?
;
	CALL	TAPOFF		;turn off tape if on
	LD	HL,MEMMSG	;not enough memory
	CALL	PRINT		;display prompt
	LD	B,1		;single key input
	CALL	GETSTR		;get from keyboard
	JP	Z,RESUME	;abort on nil input
	CALL	UCASE		;else make upper case
	CP	'Y'		;continue?
	JP	NZ,RESUME	;go if anything but
;
;	continue reading from next buffer
;
	CALL	TAPON		;turn deck back on
	LD	DE,SBUFF	;storage buffer
	JP	LOADIRR		;load irregular
;
;	loading standard file
;
LOADLPX	LD	L,(IY+10)	;get position back
	LD	H,(IY+11)
	LD	DE,STRING	;save data here for now
	PUSH	DE		;save pointer
	LD	BC,BFTSIZE	;230 entries possible
	LDIR			;move it in
	LD	A,(IY+8)	;get # buffers
	ADD	A,A		;*2
	ADD	A,A		;*4
	LD	(IY+8),A	;# sectors to read
	CALL	ASCII		;convert to ascii
	BIT	7,(IY-1)	;tape/disk?
	JR	Z,SKPSHW	;go if disk
	LD	($VIDEO+125),A	;# buffs to video
	NOP
	LD	($VIDEO+126),BC	;rest of text
	NOP
SKPSHW	POP	HL		;hl => bufftable
;
	LD	BC,BFTSIZE<8+1	;B=looper, C=counter
LOADLP	LD	A,(HL)		;get a byte
	CP	_ACTBUF		;anything there?
	JR	NZ,NEXTLD	;skip if not
	LD	A,C		;get buff #
	LD	(IY+12),A	;save here
	INC	A		;+1
	CP	(IY+1)		;in range of memory?
	JR	NC,NEXTLD	;ignore if out of range!
;
	PUSH	HL		;save pointer
	PUSH	BC		;save counter
	LD	HL,BFTABLE-1	;buffer table -1
	LD	B,0		;BC = table offset
	ADD	HL,BC		;HL => entry
	LD	(HL),_ACTBUF	;buffer has data
	LD	HL,VBUFF	;start video buffer
	LD	DE,$VIDLEN	;length of video
;
FIXB1	ADD	HL,DE		;point to next buffer
	DEC	C		;less buffer #
	JR	NZ,FIXB1	;go for buffer #
	LD	B,4		;4 sectors / screen
RDLP	PUSH	HL		;save pointer
	PUSH	BC		;save counter
	LD	DE,DCB		;point to file block
	LD	HL,IOBUFF	;I/O buffer
	CALL	RDBUFF		;read the buffer
	POP	BC		;restore count
	POP	HL		;restore pointer
	JR	NZ,BADLD	;no good, go
	EX	DE,HL		;put the bytes there
	PUSH	BC		;save this
	LD	HL,IOBUFF	;data is here
	LD	BC,100H		;length of a page
	LDIR			;move 'em into buffer
	EX	DE,HL		;swap back
	POP	BC		;restore count
	DJNZ	RDLP		;go for 4 pages/screen
	POP	BC		;restore stack
	POP	HL		;restore pointer
NEXTLD	INC	HL		;bump table pointer
	INC	C		;bump buffer #
	DJNZ	LOADLP		;continue for 230 entries
;
;	file loaded
;
LOADED	CALL	CLSBUFF		;close files
	JP	NZ,CERROR	;go if error
	CALL	FLKEY		;wait for input key
	JP	RESUME		;load completed, resume
;
;	error on load
;
BADLD	POP	BC		;restore stack
	POP	HL
	JP	CERROR		;go error vector!
;
;	load irregular file until out of memory or EOF
;
LOADIRR	PUSH	DE		;save memory buffer
	LD	DE,DCB		;file block
	LD	HL,IOBUFF	;read data here
	PUSH	HL		;save on stack
	CALL	RDBUFF		;read buffer full
	POP	HL		;HL => I/O buffer
	POP	DE		;DE => memory buffer
	JR	Z,LOADIRL	;go if no error
;
;	check for end of file error
;
	CP	_EOF1		;end of file error?
	JR	Z,LOADIRE	;yes, end load!
	CP	_EOF2		;end of file error?
	JR	Z,LOADIRE	;yes, end load!
	JP	CERROR		;else go error!
;
;	move data from I/O buffer to memory buffer
;
LOADIRL	LD	BC,100H		;length of I/O buffer
	LDIR			;move into memory buffer
;
;	check for sufficient memory to continue loading
;
	LD	HL,$		;get top memory
HIMEM	EQU	$-2
	DEC	H		;less one more page
	OR	A		;clear carry flag
	SBC	HL,DE		;compare to mem pointer
	JR	NC,LOADIRR	;continue if more room
;
;	either out of memory, or end of file
;
LOADIRE	JP	LOADED		;close file/turn off tape
;
;	compare 2 strings
;
COMPARE	LD	A,(DE)		;fetch a byte
	CP	(HL)		;match?
	INC	DE		;bump pointers
	INC	HL
	RET	NZ		;return if mismatch
	DJNZ	COMPARE		;else compare for length
	RET			;done!
;
;	display dos error code
;
ERROR	OR	11000000B	;return/short message
	CALL	@ERROR		;display DOS error
	CALL	FLKEY		;wait for key
	JP	RESUME		;clear and continue
SAVE	LD	HL,SAVEMSG	;saving message
	CALL	PRINT		;display message
	SET	3,(IY-1)	;set SAVE operation
;
;	compute # of active buffers
;
	LD	B,(IY+1)	;get # of buffers
	LD	C,0		;init counter
	LD	HL,BFTABLE	;start buffer table
;
SVLP	LD	A,(HL)		;fetch table entry
	CP	_ACTBUF		;active buffer?
	JR	NZ,SVLP1	;go if not
	INC	C		;bump counter if active
SVLP1	INC	HL		;bump table pointer
	DJNZ	SVLP		;go for table length
	LD	A,C		;get count
	LD	(IY+8),A	;save # buffers
	OR	A		;anything?
	JR	NZ,SVCONT	;continue if some there
;
;	no data in any buffers!
;
	LD	HL,NOSAVE	;nothing to save
	CALL	PRINT		;display message
	CALL	FLKEY		;wait for ENTER
	JP	RESUME		;continue
;
SVCONT	CALL	ASCII		;# buffer=>ascii
	LD	(SAVNUM),BC	;put in string
	LD	A,(IY+8)	;get again
	ADD	A,A		;*2
	ADD	A,A		;*4
	INC	A		;+1 for header
	LD	(IY+8),A	;# of sectors to write
	LD	(IY+9),1	;init counter
	LD	HL,PUTMSG	;# of buffers
	CALL	PRINT		;display message
;
;	open file, check if new file or if
;	existing file to be overwritten
;
	CALL	DSKTAP		;setup parameters
	BIT	7,(IY-1)	;tape/disk?
	JP	NZ,NOWTHER	;continue if tape
	JR	C,THERNOW	;new file created
	LD	HL,THERMSG	;see if yes/no
	CALL	PRINT		;display it
	LD	B,3		;3 char input
	CALL	GETSTR		;get request
	JP	Z,RESUME	;cancel it if nil input
	CALL	UCASE		;make it upper
	CP	'Y'		;must be YES
	JP	NZ,RESUME	;quit now if not YES
	JR	NOWTHER		;else continue
;
THERNOW	LD	HL,THRMSG	;new file created!
	CALL	PRINT		;display message
;
;	init header sector for file
;
NOWTHER	LD	HL,IOBUFF	;start I/O buffer
	LD	DE,IOBUFF+1	;start +1
	LD	BC,0FFH		;length -1
	LD	(HL),0		;load zero
	LDIR			;clear the buffer
;
	LD	HL,QUICK	;insert identity
	LD	DE,IOBUFF	;start buffer
	LD	BC,QUICKL	;length of header
	LDIR			;move in header
;
	LD	HL,BFTABLE	;start buffer table
	LD	BC,BFTSIZE	;length of table
	LDIR			;move table to buffer
;
	LD	DE,DCB		;point to DCB
	LD	HL,IOBUFF	;start I/O buffer
	CALL	WRBUFF		;write the buffer
	JP	NZ,CERROR	;go if error
;
	LD	HL,BFTABLE	;start buff table
	LD	B,(IY+1)	;get total # buffers
	LD	C,1		;buffer # current
;
SVLOOP	LD	A,(HL)		;get a byte
	CP	_ACTBUF		;anything in buffer?
	JR	NZ,NEXTSAV	;skip it if not
;
	LD	A,C		;get buff #
	LD	(IY+12),A	;save current
	PUSH	HL		;save table pointer
	PUSH	BC		;save counter
	LD	HL,VBUFF	;start video buffer
	LD	DE,$VIDLEN	;length of video buffer
FIGB2	ADD	HL,DE		;point to next buffer
	DEC	C		;less buff #
	JR	NZ,FIGB2	;go for count
	LD	B,4		;4 sectors/screen
;
SSAVLP	PUSH	BC		;save counter
	LD	DE,IOBUFF	;start I/O buffer
	LD	BC,100H		;length of buffer
	LDIR			;move data to I/O buff
	PUSH	HL		;save pointer
	LD	DE,DCB		;file block
	LD	HL,IOBUFF	;I/O buffer
	CALL	WRBUFF2		;write the buffer
	POP	HL		;restore table
	POP	BC		;restore count
	JR	NZ,BADSAV	;go if error
	DJNZ	SSAVLP		;else finish buffer
	POP	BC		;restore counter
	POP	HL		;restore table pointer
;
NEXTSAV	INC	HL		;bump table pointer
	INC	C		;bump buffer #
	DJNZ	SVLOOP		;go for # entries
;
	LD	A,(IY-1)	;check for special write
	AND	7		;get type
	CALL	NZ,FLUSH	;write last data back
	CALL	CLSBUFF		;close buffers
	JP	NZ,ERROR	;print error if bad
	CALL	FLKEY		;wait for a key
	JP	RESUME		;continue
;
;	error on save
;
BADSAV	POP	BC		;restore stack
	POP	HL
;
CERROR	PUSH	AF		;save error code
	CALL	TAPOFF		;turn off tape deck
	POP	AF		;restore error
	JP	ERROR		;display & return
;
;	close I/O channel
;
CLSBUFF	LD	DE,DCB		;point to DCB
	BIT	7,(IY-1)	;from disk?
	JR	NZ,CLSTAPE	;turn off tape
;
	BIT	3,(IY-1)	;loading?
	RET	Z		;no need to close!
	LD	A,(DE)		;get a byte
	AND	80H		;open now?
	RET	Z		;no need to close!
	JP	@CLOSE		;close file
;
;	turn off tape
;
CLSTAPE	CALL	TAPOFF		;turn off cassette
	XOR	A		;set Z flag
	RET			;done!
;
;	turn tape deck on
;
TAPON	BIT	7,(IY-1)	;tape/disk?
	RET	Z		;no need if disk
	JP	@TAPON		;turn on tape
;
;	turn tape deck off
;
TAPOFF	BIT	7,(IY-1)	;tape/disk?
	RET	Z		;go if disk!
	JP	@TAPOFF		;turn off tape
;
;	fetch string from keyboard
;	drain all type-ahead keys first
;
GETSTR	CALL	@KBCHAR		;scan keyboard
	OR	A		;any keys?
	JR	NZ,GETSTR	;wait till empty
;
	LD	HL,STRING	;start key buffer
WAITKEY	PUSH	IY		;save pointer
	CALL	@KBLINE		;get string from keybrd
	POP	IY		;restore pointer
	JP	C,RESUME	;cancel if BREAK
	LD	A,B		;get length of input
	OR	A		;set flags
	LD	A,(HL)		;get first character
	RET			;done!
;
;	convert character to upper case
;
UCASE	CP	'a'		;in range?
	RET	C		;go if already upper
	CP	'z'+1		;in range?
	RET	NC		;go if not in LC range
	AND	5FH		;else make upper case
	RET			;A = ucase char
;
;	execute buffer controls
;
DOBUFF	LD	A,(IY+1)	;get number of buffers
	CALL	ASCII		;convert to ascii
	LD	(BUFNUM),BC	;save it to message
	LD	HL,BUFMSG	;start of text
	CALL	PRINT		;display prompt
	CALL	PARAMS		;show settings
	LD	HL,BUFMG0	;get prompt
	CALL	PRINT		;display it
	LD	B,1		;single key input
	CALL	GETSTR		;get user input
	JP	Z,RESUME	;go if nil input
	CALL	UCASE		;make it upper case
	CP	'S'		;save to buffer?
	JP	Z,SAVBUF	;yes, go!
	CP	'R'		;restore a buffer?
	JP	Z,RESBUF	;go if yes
	CP	'C'		;clear all?
	JP	Z,ERABUF	;erase all
	CP	'Z'		;zero single?
	JP	Z,ZROBUF	;go if yes
	CP	'M'		;merge?
	JP	Z,MERGBUF
	CP	'E'		;exchange?
	JP	NZ,RESUME	;forget it
;
;	exchanging buffers
;
	LD	HL,EBFMSG	;exchange what?
	CALL	ASKBUF		;which one?
	LD	DE,VBUFF	;exchange here
	LD	BC,$VIDLEN	;1k to do
EXCHG	LD	A,(DE)		;get a byte
	EX	AF,AF'		;save it
	LD	A,(HL)		;get other one
	LD	(DE),A		;swap one
	EX	AF,AF'		;get original
	LD	(HL),A		;fix this one now
	INC	DE		;bump buffers
	INC	HL
	DEC	BC		;counter
	LD	A,B		;done?
	OR	C
	JR	NZ,EXCHG	;go till all done
;
	LD	A,_ACTBUF	;set active
	JR	SETACT		;continue
;
;	merging buffers
;
MERGBUF	LD	HL,MBUFMG	;prompt
	CALL	ASKBUF		;ask for buffer #
	LD	DE,VBUFF	;start buffer
	EX	DE,HL		;HL => video buffer
	LD	BC,$VIDLEN	;one screen full
;
MERLP	LD	A,(DE)		;get a byte
	CP	20H		;blank char?
	JR	Z,SKPM		;skip if yes
	CP	80H		;blank graphic char?
	JR	Z,SKPM		;skip if yes
	OR	(HL)		;merge with current video
	LD	(HL),A		;update char
SKPM	INC	HL		;bump video pointer
	INC	DE		;bump data pointer
	DEC	BC		;less counter
	LD	A,B		;any more?
	OR	C
	JR	NZ,MERLP	;go if more left
	SET	5,(IY+0)	;set buffer updated
	JP	RESUME		;continue!
;
;	saving buffer
;
SAVBUF	LD	HL,SBFMSG	;save buffer
	CALL	ASKBUF		;get reply
	LD	DE,VBUFF	;point to buffer
	EX	DE,HL		;video => buffer
CONBUF	LD	BC,$VIDLEN	;length of buffer
	LDIR			;move 'em
	LD	A,_ACTBUF	;set active
;
;	set buffer # as active
;
SETACT	LD	E,(IY+8)	;get position
	LD	D,(IY+9)
	LD	(DE),A		;save value on/off
	JP	RESUME		;continue
;
;	set buffer # as inactive
;
RESBUF	LD	HL,RBFMSG	;prompt
	CALL	ASKBUF		;get which buffer
	LD	DE,VBUFF	;start buffer
	LD	BC,$VIDLEN	;length of buffer
	LDIR			;move it in
	JP	RESUME		;continue
;
;	erase ALL buffers
;
ERABUF	LD	A,(IY+1)	;get buffer count
	LD	HL,SBUFF	;storage buffer
	LD	DE,SBUFF+1	;start +1
	LD	(HL),80H	;graphic space
ELOP	LD	BC,$VIDLEN	;video length
	LDIR			;fill buffer
	DEC	A		;less counter
	JR	NZ,ELOP		;go for length + 1 byte
;
;	reset buffer table also
;
	LD	HL,BFTABLE	;start table
	LD	DE,BFTABLE+1	;start +1
	LD	(HL),0		;load zero
	LD	BC,BFTSIZE-1	;length -1
	LDIR			;clear table
	JP	RESUME		;continue
;
;	zero single buffer
;
ZROBUF	LD	HL,ZBFMSG	;prompt
	CALL	ASKBUF		;get which buffer
	LD	D,H		;pass pointer to DE
	LD	E,L
	INC	DE		;start +1
	LD	BC,$VIDLEN-1	;length -1
	LD	(HL),80H	;load graphic space
	LDIR			;fill buffer
	XOR	A		;load zero
	JP	SETACT		;reset buffer #
;
;	ask user which buffer to operate on
;
ASKBUF	CALL	PRINT		;display prompt
	LD	HL,UBFMSG	;buffer # prompt
	CALL	PRINT		;display prompt
	LD	B,2		;2 chars input
	CALL	GETSTR		;get from keyboard
	JR	Z,BUFNOP	;ignore command if nil
	CALL	VALUE		;else get input value
	JR	C,BUFNOP	;go if invalid!
;
	LD	A,(IY+1)	;get max # buffers
	CP	C		;compare to user input
	JR	C,BUFNOP	;go if out of range
	LD	A,C		;get user #
	OR	A		;buffer 0?
	JR	Z,BUFNOP	;invalid!
;
	LD	HL,VBUFF	;start video buffer
	LD	DE,$VIDLEN	;length of video
COMPBF	ADD	HL,DE		;add to pointer
	DEC	C		;less counter
	JR	NZ,COMPBF	;HL => buffer
	LD	DE,BFTABLE-1	;start buff table -1
	PUSH	HL		;save buff pointer
	LD	H,0		;init MSB
	LD	L,A		;HL = buffer offset
	ADD	HL,DE		;HL => table entry
	LD	(IY+8),L	;load table pointer
	LD	(IY+9),H	;for set/reset
	POP	HL		;restore buff pointer
	RET			;done, HL => buffer
;
;	fetch value from input string
;
VALUE	LD	C,0		;init value
;
VALLP	LD	A,(HL)		;fetch input char
	CP	_CR		;terminator?
	RET	Z		;yes, done!
	CALL	CKVAL		;valid char?
	RET	C		;go if not
	LD	B,A		;save new char
;
;	multiply subtotal times 10
;
	LD	A,C		;get subtotal
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,C		;*5
	ADD	A,A		;*10
	ADD	A,B		;+ new digit
	LD	C,A		;update subtotal
	INC	HL		;bump pointer
	JR	VALLP		;go next char
;
;	check for valid decimal digit
;
CKVAL	SUB	'0'		;remove ascii
	RET	C		;go if invalid
	CP	10		;0-9?
	CCF			;reverse carry flag
	RET			;C = invalid
;
;	abort buffer operation
;
BUFNOP	JP	RESUME		;abort
;
;	display buffer parameters
;
PMETER	LD	HL,PARMSG	;prompt message
	CALL	PRINT		;display it
	CALL	PARAMS		;display buffer settings
	JP	PARAMR		;continue
;
;	display buffer parameters
;
PARAMS	LD	HL,($CURSOR)	;fetch cursor
	LD	B,(IY+1)	;get buffer count
	LD	C,1		;init buffer number
;
PARLP	PUSH	BC		;save count/position
	LD	A,C		;get buffer #
	PUSH	AF		;save it
	CALL	ASCII		;convert to ascii
	LD	(HL),C		;NSB to video
	NOP
	INC	HL		;bump video
	LD	(HL),B		;LSB to video
	NOP
	INC	HL		;bump video
	LD	(HL),'='	;separator
	NOP
	INC	HL		;bump video
	POP	AF		;get buffer # back
	LD	C,A		;save it
	LD	B,0		;BC = buff number
;
	PUSH	HL		;save video
	LD	HL,BFTABLE-1	;start buffer table
	ADD	HL,BC		;HL => current entry
	LD	A,(HL)		;fetch flag byte
	CP	_ACTBUF		;active buffer?
	POP	HL		;restore video
	POP	BC		;restore counter
	JR	NZ,DEADSPT	;go if nil buffer
	LD	(HL),143	;else put graphic char
	NOP
	INC	HL		;bump video
	LD	(HL),143	;2 chars
	NOP
	INC	HL		;bump video
	LD	(HL),143	;graphic char
	NOP
	JR	DEADCNT		;continue
;
DEADSPT	INC	HL		;bump video
	INC	HL		;twice
DEADCNT	INC	HL		;next position
	INC	HL		;3 spaces in between
	INC	HL
	INC	C		;bump buffer #
	DJNZ	PARLP		;go for buffer count
	LD	($CURSOR),HL	;update cursor position
	LD	HL,LFEED	;linefeed
	JP	PRINT		;display and return
;
PARAMR	CALL	FLKEY		;wait for input key
	JP	RESUME		;continue
;
;	reverse right/left halves of video
;	used in double wide display mode
;
DUBREV	LD	B,$TROWS	;# video rows
	LD	HL,VBUFF	;start video buffer
	LD	DE,$TCOLS/2+VBUFF ;middle of row
;
DUBL1	PUSH	HL		;save pointer
	PUSH	DE		;save half row pointer
	LD	C,$TCOLS/2	;half # video columns
DUBL2	LD	A,(HL)		;fetch a byte
	EX	AF,AF'		;save char
	LD	A,(DE)		;get second
	LD	(HL),A		;put in first
	EX	AF,AF'		;get first back
	LD	(DE),A		;put in second
	INC	HL		;bump left pointer
	INC	DE		;bump right pointer
	DEC	C		;less half row counter
	JR	NZ,DUBL2	;go for row
	POP	DE		;restore row start
	POP	HL		;restore row start
	PUSH	BC		;save counter
	LD	BC,$TCOLS	;# columns on video
	ADD	HL,BC		;HL => next entry
	EX	DE,HL		;swap for add
	ADD	HL,BC		;HL => next entry
	EX	DE,HL		;swap back
	POP	BC		;restore counter
	DJNZ	DUBL1		;go for length
	SET	5,(IY+0)	;set buffer updated
	JP	RESUME		;re-draw and continue
;
